DIR_E = 1
DIR_W = 2
DIR_N = 4
DIR_S = 8

PLAY_FIELD_OFFSET_X = 1
PLAY_FIELD_OFFSET_Y = 1

SCORE_BAR_OFFSET_SCORE = 21
SCORE_BAR_OFFSET_BONUS = 8
SCORE_BAR_OFFSET_CRYSTAL = 39

COUNT_STAGES = 10

  
  
!zone StartGame
StartGame
          ldx #0
-          
          lda TEXT_SCORE_BAR,x
          sta TEXT_CURRENT_SCORE_BAR,x
          inx
          cpx #40
          bne -
          
          jsr ClearScreen
          
          lda #0
          sta BUTTON_RELEASED
          lda #1
          ;lda #10
          sta LEVEL_NR

StartGame.RestartLevel          
          lda #'5'
          sta TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_BONUS
          lda #'0'
          sta TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_BONUS + 1
          sta TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_BONUS + 2

          lda #<TEXT_CURRENT_SCORE_BAR
          sta ZEROPAGE_POINTER_1
          lda #>TEXT_CURRENT_SCORE_BAR
          sta ZEROPAGE_POINTER_1 + 1
          jsr DisplayText
          
          lda #0
          sta NUM_POTENTIAL_SPAWN_POS
          sta DIAMOND_ACTIVE
          sta NUM_DIAMONDS_PICKED
          sta PLAYER_KILLED
          sta DIAMOND_SPAWN_DELAY
          sta VIC.SPRITE_ENABLE
          sta LEVEL_COMPLETED
          sta BONUS_DELAY
          
          jsr ClearObjects
          
          jsr BuildScreen
          
          lda NUM_POTENTIAL_SPAWN_POS
          clc
          adc #'0'
          sta TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_CRYSTAL
          sta SCREEN_CHAR + SCORE_BAR_OFFSET_CRYSTAL
          
          lda #SFX_LEVEL_START
          jsr SFXPlay
          
          lda #120
          sta LEVEL_START_DELAY
          
!zone GameLoop
GameLoop
          lda #240
          jsr WaitFrame
          
          lda LEVEL_START_DELAY
          beq +
          dec LEVEL_START_DELAY
          bne GameLoop
          
+
          
          lda JOY_VALUE
          and #JOY_FIRE
          beq +
          lda #1
          sta BUTTON_RELEASED
+          
          
          lda PLAYER_KILLED
          cmp #3
          bne +
          ;jmp StartGame.RestartLevel
          jmp Retry
+          

          lda LEVEL_COMPLETED
          cmp #3
          bne +
          inc LEVEL_NR
          
          lda LEVEL_NR
          cmp #COUNT_STAGES + 1
          bne .GoToNext
          
          jmp Done
          
.GoToNext          
          jmp StartGame.RestartLevel
+          

          jsr HandleLevelCompleted
          jsr HandlePlayerKilled
          
          jsr HandleBonus
          
          inc SPEED_TABLE_POS
          lda SPEED_TABLE_POS
          and #$07
          sta SPEED_TABLE_POS
          
          jsr ObjectControl
          
          lda LEVEL_COMPLETED
          bne .HasDiamond
          lda DIAMOND_ACTIVE
          bne .HasDiamond

          lda DIAMOND_SPAWN_DELAY
          beq .CanSpawnDiamond
          
          dec DIAMOND_SPAWN_DELAY
          jmp .HasDiamond
          
.CanSpawnDiamond          
          
          lda #0
          sta PARAM5
          lda NUM_POTENTIAL_SPAWN_POS
          sta PARAM6
          dec PARAM6
          jsr GenerateRangedRandom
          tay
          
          ldx #0
-          
          lda POTENTIAL_SPAWN_SPOT_USED,x
          bne .CheckNext
          
          cpy #0
          beq .FoundSpawnSpot
          
          dey
.CheckNext
          inx
          cpx NUM_POTENTIAL_SPAWN_POS
          bne -
          
          ldx #0
          jmp -
          
          
.FoundSpawnSpot
          lda POTENTIAL_SPAWN_SPOT_X,x
          clc
          adc #2
          sta PARAM1
          lda POTENTIAL_SPAWN_SPOT_Y,x
          sta PARAM2
          inc PARAM2
          
          lda #1
          sta POTENTIAL_SPAWN_SPOT_USED,x
          
          lda #TYPE_DIAMOND
          sta PARAM3
          ldx #7
          jsr CreateObjectInSlot
          jsr MoveSpriteLeft
          jsr MoveSpriteLeft
          jsr MoveSpriteLeft
          jsr MoveSpriteLeft
          inc DIAMOND_ACTIVE
          
.HasDiamond          
          jmp GameLoop
          
          
          
          
!zone HandleBonus
HandleBonus
          lda PLAYER_KILLED
          bne .NoUpdate
          
          lda LEVEL_COMPLETED
          cmp #1
          beq .CountDown
          cmp #0
          bne .NoUpdate
          
          
          lda TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_BONUS
          cmp #'0'
          bne .CanDecrease
          lda TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_BONUS + 1
          cmp #'0'
          bne .CanDecrease
          lda TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_BONUS + 2
          cmp #'0'
          beq .Done
          
.CanDecrease          
          inc BONUS_DELAY
          lda BONUS_DELAY
          and #$07
          bne .Done
          
.DecreaseNow          
          ldx #2
-          
          lda TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_BONUS,x
          cmp #'0'
          beq .OverFlow
          
          dec TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_BONUS,x
          jmp .Done
          
.OverFlow
          lda #'9'
          sta TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_BONUS,x
          dex
          jmp -
          
.CountDown
          jsr IncScore
          
          inc BONUS_DOWN_TICK_COUNT
          lda BONUS_DOWN_TICK_COUNT
          cmp #10
          bne .DecreaseNow
          
          lda #0
          sta BONUS_DOWN_TICK_COUNT
          lda #SFX_PICK_DOT
          jsr SFXPlay
          jmp .DecreaseNow
          
          
.Done
          lda TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_BONUS
          sta SCREEN_CHAR + SCORE_BAR_OFFSET_BONUS + 0
          lda TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_BONUS + 1
          sta SCREEN_CHAR + SCORE_BAR_OFFSET_BONUS + 1
          lda TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_BONUS + 2
          sta SCREEN_CHAR + SCORE_BAR_OFFSET_BONUS + 2
.NoUpdate          
          rts
          
BONUS_DOWN_TICK_COUNT
          !byte 0
          
          

!zone HandlePlayerKilled
HandlePlayerKilled
          lda PLAYER_KILLED
          cmp #2
          bne +
 
          ;check restart
          lda JOY_VALUE
          and #JOY_FIRE
          bne +
          
          lda BUTTON_RELEASED
          beq +
          
          inc PLAYER_KILLED
          dec BUTTON_RELEASED
          rts
+          
          cmp #1
          bne .NothingToDo
          
          inc PLAYER_KILLED
          lda #<TEXT_PLAYER_KILLED
          sta ZEROPAGE_POINTER_1
          lda #>TEXT_PLAYER_KILLED
          sta ZEROPAGE_POINTER_1 + 1
          jsr DisplayText
          
.NothingToDo
          rts
          
          
          
!zone HandleLevelCompleted
HandleLevelCompleted
          lda LEVEL_COMPLETED
          cmp #2
          beq .Check
          jmp +
 
.Check          
          ;check restart
          lda JOY_VALUE
          and #JOY_FIRE
          bne .NothingToDo
          
          lda BUTTON_RELEASED
          beq .NothingToDo
          
          dec BUTTON_RELEASED
          inc LEVEL_COMPLETED
          rts
+          
          cmp #1
          bne .NothingToDo

          ;bonus complete?
          lda SCREEN_CHAR + SCORE_BAR_OFFSET_BONUS + 0
          cmp #'0'
          bne .NothingToDo
          lda SCREEN_CHAR + SCORE_BAR_OFFSET_BONUS + 1
          cmp #'0'
          bne .NothingToDo
          lda SCREEN_CHAR + SCORE_BAR_OFFSET_BONUS + 2
          cmp #'0'
          bne .NothingToDo
          
          inc LEVEL_COMPLETED
          lda #<TEXT_LEVEL_COMPLETED
          sta ZEROPAGE_POINTER_1
          lda #>TEXT_LEVEL_COMPLETED
          sta ZEROPAGE_POINTER_1 + 1
          jsr DisplayText
          
.NothingToDo
          rts
          
          
          
!zone DrawTile
;x = x
;y = y
;a = tile index
DrawTile  
          pha
          lda SCREEN_LINE_OFFSET_TABLE_LO,y
          sta ZEROPAGE_POINTER_1
          sta ZEROPAGE_POINTER_2
          
          lda SCREEN_LINE_OFFSET_TABLE_HI,y
          sta ZEROPAGE_POINTER_1 + 1
          clc
          adc #>( SCREEN_COLOR - SCREEN_CHAR )
          sta ZEROPAGE_POINTER_2 + 1
          
          txa
          tay
          
          pla
          tax
          
          lda TILES_TILE_CHARS_0_0,x
          sta (ZEROPAGE_POINTER_1),y
          lda TILES_TILE_COLORS_0_0,x
          sta (ZEROPAGE_POINTER_2),y
          iny
          lda TILES_TILE_CHARS_1_0,x
          sta (ZEROPAGE_POINTER_1),y
          lda TILES_TILE_COLORS_1_0,x
          sta (ZEROPAGE_POINTER_2),y
          iny
          lda TILES_TILE_CHARS_2_0,x
          sta (ZEROPAGE_POINTER_1),y
          lda TILES_TILE_COLORS_2_0,x
          sta (ZEROPAGE_POINTER_2),y
          
          tya
          clc
          adc #38
          tay
          
          lda TILES_TILE_CHARS_0_1,x
          sta (ZEROPAGE_POINTER_1),y
          lda TILES_TILE_COLORS_0_1,x
          sta (ZEROPAGE_POINTER_2),y
          iny
          lda TILES_TILE_CHARS_1_1,x
          sta (ZEROPAGE_POINTER_1),y
          lda TILES_TILE_COLORS_1_1,x
          sta (ZEROPAGE_POINTER_2),y
          iny
          lda TILES_TILE_CHARS_2_1,x
          sta (ZEROPAGE_POINTER_1),y
          lda TILES_TILE_COLORS_2_1,x
          sta (ZEROPAGE_POINTER_2),y
          
          tya
          clc
          adc #38
          tay
          
          lda TILES_TILE_CHARS_0_2,x
          sta (ZEROPAGE_POINTER_1),y
          lda TILES_TILE_COLORS_0_2,x
          sta (ZEROPAGE_POINTER_2),y
          iny
          lda TILES_TILE_CHARS_1_2,x
          sta (ZEROPAGE_POINTER_1),y
          lda TILES_TILE_COLORS_1_2,x
          sta (ZEROPAGE_POINTER_2),y
          iny
          lda TILES_TILE_CHARS_2_2,x
          sta (ZEROPAGE_POINTER_1),y
          lda TILES_TILE_COLORS_2_2,x
          sta (ZEROPAGE_POINTER_2),y
          
          rts
          
          
          
!zone DisplayText
;display text in ZEROPAGE_POINTER_1  
DisplayText
          ldy #1
-          
          lda (ZEROPAGE_POINTER_1),y
          beq .Done
          sta SCREEN_CHAR,y
          lda #1
          sta SCREEN_COLOR,y
          
          iny
          jmp -
          
          
.Done
-
          cpy #40
          beq .Done2

          lda #32
          sta SCREEN_CHAR,y
          iny
          jmp -
          
          
.Done2          
          

          rts
          
          
          
!zone IncScore10          
IncScore10      
          ldx #4
          jmp IncScore.NextChar
          
!zone IncScore
IncScore
          ldx #5
          
.NextChar
          inc TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_SCORE,x
          lda TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_SCORE,x
          cmp #'0' + 10
          bne .Done
          
          lda #'0'
          sta TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_SCORE,x
          dex
          bmi .Done
          
          jmp .NextChar
          
.Done     
          ;copy score to screen
          ldx #0
-          
          lda TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_SCORE,x
          sta SCREEN_CHAR + SCORE_BAR_OFFSET_SCORE,x
          inx
          cpx #6
          bne -
          rts
          
          
          
;x = x, y = y        
!zone CalcTilePos
CalcTilePos  
          txa
          
          cpy #0
          beq .Done
-          
          clc
          adc #13
          dey
          bne -
          
.Done
          rts
          
          
          
TEXT_PLAYER_KILLED
          !scr "   your trolley has been destroyed!",0
          
TEXT_SCORE_BAR
          !scr " bonus: 500   score: 000000   crystal: 0",0
          
TEXT_CURRENT_SCORE_BAR
          !scr " bonus: 500   score: 000000   crystal: 0",0
          
TEXT_LEVEL_COMPLETED
          !scr "            level completed!", 0

JOY_VALUE
          !byte 0
          
PLAYER_CAN_SET_HERE
          !byte 0
          
TILE_OFFSET_X
TILE_OFFSET_Y
          !byte PLAY_FIELD_OFFSET_X + 0, PLAY_FIELD_OFFSET_X + 3, PLAY_FIELD_OFFSET_X + 6,PLAY_FIELD_OFFSET_X + 9
          !byte PLAY_FIELD_OFFSET_X + 12,PLAY_FIELD_OFFSET_X + 15,PLAY_FIELD_OFFSET_X + 18,PLAY_FIELD_OFFSET_X + 21
          !byte PLAY_FIELD_OFFSET_X + 24,PLAY_FIELD_OFFSET_X + 27,PLAY_FIELD_OFFSET_X + 30,PLAY_FIELD_OFFSET_X + 33,PLAY_FIELD_OFFSET_X + 36

;offset by dir          
;e = 0, w = 1, n = 2, s = 3
TILE_DELTA
          !byte 1, 255, 256 - 13, 13
          
;lookup per tile (*4, offset by dir bit)          
TILE_RESULTING_DIR
          ;empty
          !byte 0,0,0,0
          ;e
          !byte 0,1,0,0
          ;w
          !byte 2,0,0,0
          ;we
          !byte 1,2,0,0
          ;n
          !byte 0,0,0,4
          ;ne
          !byte 0,4,0,1
          ;nw
          !byte 4,0,0,2
          ;nwe
          !byte 1,2,0,2
          ;s
          !byte 0,0,8,0
          ;se
          !byte 0,8,1,0
          ;sw
          !byte 8,0,2,0
          ;swe
          !byte 1,2,1,0
          ;ns
          !byte 0,0,4,8
          ;nse
          !byte 0,4,4,8
          ;nsw
          !byte 8,0,4,8
          ;nswe -> does nothing, default is straight
          !byte 1,2,4,8
          ;deco
          !byte 0,0,0,0
          ;cross fixed
          !byte 1,2,4,8
          

;lookup per tile (*4, offset by dir bit)
TILE_OVERRIDE_DIR
          ;empty
          !byte 0,0,0,0
          ;e
          !byte 1,0,0,0
          ;w
          !byte 0,2,0,0
          ;we
          !byte 1,2,0,0
          ;n
          !byte 0,0,0,4
          ;ne
          !byte 0,4,0,1
          ;nw
          !byte 4,0,0,2
          ;nwe -> overriding
          !byte 4,4,0,1
          ;s
          !byte 0,0,8,0
          ;se
          !byte 0,8,1,0
          ;sw
          !byte 8,0,2,0
          ;swe -> overriding
          !byte 8,8,2,0
          ;ns
          !byte 0,0,4,8
          ;nse -> overriding
          !byte 0,8,1,1
          ;nsw -> overriding
          !byte 4,0,2,2
          ;nswe -> overriding
          !byte 8,4,1,2
          ;deco
          !byte 0,0,0,0
          ;cross fixed
          !byte 1,2,4,8
          

;1 if changeable (T crossings)          
TILE_CHANGEABLE
          !byte 0,0,0,0,0,0,0,SPRITE_CURSOR_NWE,0,0,0,SPRITE_CURSOR_SWE,0,SPRITE_CURSOR_NSE,SPRITE_CURSOR_NSW,SPRITE_CURSOR_NSWE,0,0,0,0,0
          
TILE_SPAWNABLE
          !byte 0,1,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0
          
          
POTENTIAL_SPAWN_SPOT_X
          !fill 8
POTENTIAL_SPAWN_SPOT_Y
          !fill 8
POTENTIAL_SPAWN_SPOT_USED
          !fill 8

NUM_POTENTIAL_SPAWN_POS
          !byte 0
          
DIAMOND_ACTIVE
          !byte 0
NUM_DIAMONDS_PICKED
          !byte 0

DIAMOND_SPAWN_DELAY
          !byte 0
          
BONUS_DELAY
          !byte 0
          
          
;1 = killed, 2 = death message displayed, 3 = restart level
PLAYER_KILLED
          !byte 0
          
;1 = completed , 2 = message displayed, 3 = next level          
LEVEL_COMPLETED
          !byte 0
          
LEVEL_NR
          !byte 0
          
LEVEL_START_DELAY
          !byte 0
          
BUTTON_RELEASED
          !byte 0

LEVEL_DATA
          !fill 13 * 8