;y = index of map, 0 = title
!zone BuildScreen
BuildScreen  
          ldy LEVEL_NR
          lda SCREENS_MAP_LIST_LO,y
          sta .ReadPos
          lda SCREENS_MAP_LIST_HI,y
          sta .ReadPos + 1
          
          ldx #0
-          
.ReadPos = * + 1          
          lda $ffff,x
          sta LEVEL_DATA,x
          inx
          cpx #13 * 8
          bne -
          
          lda #<LEVEL_DATA
          sta ZEROPAGE_POINTER_3
          lda #>LEVEL_DATA
          sta ZEROPAGE_POINTER_3 + 1
          lda #0
          sta PARAM3
          
          lda #PLAY_FIELD_OFFSET_X
          sta PARAM1
          lda #PLAY_FIELD_OFFSET_Y
          sta PARAM2
          
.NextTile          
          ldy PARAM3
          lda (ZEROPAGE_POINTER_3),y
          inc PARAM3
          sta PARAM7
          
          ldx PARAM1
          ldy PARAM2
          jsr DrawTile
          
          ldy PARAM7
          lda TILE_SPAWNABLE,y
          beq +
          
          ;new spawn spot
          ldy NUM_POTENTIAL_SPAWN_POS
          lda PARAM1
          sta POTENTIAL_SPAWN_SPOT_X,y
          lda PARAM2
          sta POTENTIAL_SPAWN_SPOT_Y,y
          lda #0
          sta POTENTIAL_SPAWN_SPOT_USED,y
          
          inc NUM_POTENTIAL_SPAWN_POS
+          
          
          
          inc PARAM1
          inc PARAM1
          inc PARAM1
          lda PARAM1
          cmp #1 + 13 * 3
          bne +
          
          lda #PLAY_FIELD_OFFSET_X
          sta PARAM1
          inc PARAM2
          inc PARAM2
          inc PARAM2
          lda PARAM2
          cmp #1 + 8 * 3
          beq .LevelDone
+         
          jmp .NextTile
          
          
          
          

.LevelDone
          ;spawn cursor first
          ldx #6
          ldy #3
          stx CURSOR_TILE_X
          sty CURSOR_TILE_Y
          
          ldy CURSOR_TILE_X
          lda TILE_OFFSET_X,y
          clc
          adc #2    ;center in tile
          sta PARAM1

          ldy CURSOR_TILE_Y
          lda TILE_OFFSET_Y,y
          clc
          adc #2    ;center in tile
          sta PARAM2
          
          lda #TYPE_PLAYER_CURSOR
          sta PARAM3
          jsr SpawnObject
          jsr ObjectMoveDown
          jsr ObjectMoveDown
          jsr ObjectMoveDown
          
          ;calc real pos
          ldx CURSOR_TILE_X
          ldy CURSOR_TILE_Y
          jsr CalcTilePos
          sta OBJECT_TILE_POS          
          
          ;handle extra data
          ldy LEVEL_NR
          lda SCREENS_MAP_EXTRA_DATA_LIST_LO,y
          sta .EDReadPos
          sta .EDReadPos2
          lda SCREENS_MAP_EXTRA_DATA_LIST_HI,y
          sta .EDReadPos + 1
          sta .EDReadPos2 + 1
          
          ldy #0
-          
.EDReadPos = * + 1          
          lda $ffff,y
          sta ED_PARAM1
          iny

.EDReadPos2 = * + 1          
          lda $ffff,y
          sta ED_PARAM2
          sty EXTRA_DATA_POS
          
          lda ED_PARAM1
          lsr
          lsr
          lsr
          lsr
          tay
          
          lda EXTRA_DATA_TABLE_LO,y
          sta .EDPos
          lda EXTRA_DATA_TABLE_HI,y
          sta .EDPos + 1
          
.EDPos = * + 1
          jsr $ffff
          
          ldy EXTRA_DATA_POS
          iny
          jmp -
          
          
EXTRA_DATA_POS
          !byte 0
          
ED_PARAM1
          !byte 0
ED_PARAM2
          !byte 0
            
          
EXTRA_DATA_TABLE_LO
          !byte <EDDone
          !byte <EDFriendlyWagon
          !byte <EDEnemyWagon

EXTRA_DATA_TABLE_HI
          !byte >EDDone
          !byte >EDFriendlyWagon
          !byte >EDEnemyWagon
          
          
EDFriendlyWagon
          ;ED_PARAM1 = 1<speed>
          ;ED_PARAM2 = xxxx Dyyy
          
          lda ED_PARAM2
          lsr
          lsr
          lsr
          lsr
          tax
          lda ED_PARAM2
          and #$07
          tay
          jsr SpawnWagon
          
          lda ED_PARAM2
          and #$08
          beq +
          
          lda #DIR_W
          sta OBJECT_DIR,x
          
+          
          
          lda ED_PARAM1
          and #$0f
          sta OBJECT_MOVE_SPEED,x
          rts
          


EDEnemyWagon
          ;ED_PARAM1 = 1<speed>
          ;ED_PARAM2 = xxxx yyyy
          
          lda ED_PARAM2
          lsr
          lsr
          lsr
          lsr
          tax
          lda ED_PARAM2
          and #$07
          tay

          jsr SpawnWagon
          lda #TYPE_ENEMY_WAGON
          sta OBJECT_TYPE,x
          lda #2
          sta VIC.SPRITE_COLOR + 1,x

          lda ED_PARAM2
          and #$08
          beq +
          
          lda #DIR_W
          sta OBJECT_DIR,x
          
+          
          
          lda ED_PARAM1
          and #$0f
          sta OBJECT_MOVE_SPEED,x
          rts
          


EDDone          
          pla
          pla
          rts