.pc =$0801 "Basic Upstart Program"
:BasicUpstart($4500)

.var music = LoadSid("Tetris.sid")
.pc=music.location "Music"
.fill music.size, music.getData(i)



.var music2 = LoadSid("re_axel.sid")
.pc=music2.location "Musi2c"
.fill music2.size, music2.getData(i)

.pc = $4500 "Main Program"

	sei


	lda #$7f
	sta $dc0d
	lda #$81
	sta $d01a
	lda #<irq1
	sta $0314
	lda #>irq1
	sta $0315

	lda #$55		//$5a
	sta $d012

	lda#$1b
	sta $d011



	cli


	
// $d000 X
// $d001 Y...
//
// $d015 sprite be/ki '00000000'
//
// $d017 nyujtas y be/ki '00000000'
//
// $d01b sprite a szoveg elott(1) vagy mogott(0)
//
// $d01c multicolor be/ki '00000000'
//
// $d01d nyujtas x be/ki '00000000'
//
// $d025 multicol sp szin1 	     -> '01'
// $d026 multicol sp szin2     	     -> '11'
//
// $d027 sp1 szin	multi eseten -> '10'
// $d028 sp2 szin...
//
// screen+03f8 sp1 minta
// $07f8 sp1 minta
// $07f9 sp2 minta...
//
// lathato screen kezdete X:23 y:29
// gameboy: 48*72 px
// pos: 136+23:63+29 ->  159:92   $9f:$5c






	lda #$ff
	sta $d015	//sprites on





	lda #$0b
	sta $d020
	sta $d021


lda #$0f		//0f
sta $d025

lda #$06		//00
sta $d026	//lcd szin




//screen del
	lda #$20
	
	ldx #$00
sdel:
	sta $0400,x
	sta $0500,x
	sta $0600,x
	sta $0700,x
	sta $0800,x
	//sta $0c00,x
	
	inx
	bne sdel
	
	lda #$0b
	
	ldx #$00
scol:
	sta $d900,x
	sta $da00,x
	sta $db00,x
	
	//sta $d800,x
	
	inx
	bne scol





	//zene init
	lda #$00
	jsr $5000






vege:	




	jmp vege






irq1:  	
	inc $d019

	
	lda $d012
r_var3:	cmp $d012
	beq r_var3

	lda #$01
	sta $d020
	sta $d021

	lda $d012
r_var4:	cmp $d012
	beq r_var4
	
	lda #$0b
	sta $d020
	sta $d021


	lda part_sel
	cmp #$00
	bne prtcheck
	jmp main_normal

prtcheck:
	cmp #$02
	beq intropart
	jmp zoom


///////////////////////////////////////////
/// INTRO ////////////////////////////////
/////////////////////////////////////////
intropart:


	lda #$7f
	sta $d015	//sprites on

	lda #$fe
	sta $d017
	sta $d01d

	lda #$40	//S jobboldalra
	sta $d010

	ldx #$ac
	stx $07f8	//mini
	inx
	stx $07f9	//T
	inx
	stx $07fa	//E

	ldx #$ad
	stx $07fb	//T


	ldx #$af	
	stx $07fc	//R
	inx
	stx $07fd	//i
	inx
	stx $07fe	//S
	


	lda #$88
	sta $d001
	lda #$78
	sta $d003
	sta $d005
	sta $d007
	sta $d009
	sta $d00b
	sta $d00d



p1:	lda #$3a
	sta $d000
p2:	lda #$3e
	sta $d002
p3:	lda #$6c
	sta $d004
p4:	lda #$9a
	sta $d006
p5:	lda #$c8
	sta $d008
p6:	lda #$e4
	sta $d00a
p7:	lda #$00
	sta $d00c




	//tetris elemek szeinei
ic1:	lda #$00
	sta $d027
ic2:	lda #$00
	sta $d028
ic3:	lda #$00
	sta $d029
ic4:	lda #$00
	sta $d02a
ic5:	lda #$00
	sta $d02b
ic6:	lda #$00
	sta $d02c
ic7:	lda #$00
	sta $d02d


	ldx sinpos

	lda logo_posx
	clc
	adc sin,x
	sta p1+1
	txa
	clc
	adc #$44	
	tax
	and #%00111111
	tay
	lda logo_col,y
	sta ic1+1

	lda logo_posx+1
	clc
	adc sin,x
	sta p2+1
	txa
	clc
	adc #$44	
	tax
	and #%00111111
	tay
	lda logo_col,y
	sta ic2+1

	lda logo_posx+2
	clc
	adc sin,x
	sta p3+1
	txa
	clc
	adc #$44	
	tax
	and #%00111111
	tay
	lda logo_col,y
	sta ic3+1

	lda logo_posx+3
	clc
	adc sin,x
	sta p4+1
	txa
	clc
	adc #$44	
	tax
	and #%00111111
	tay
	lda logo_col,y
	sta ic4+1
		
	lda logo_posx+4
	clc
	adc sin,x
	sta p5+1
	txa
	clc
	adc #$44	
	tax
	and #%00111111
	tay
	lda logo_col,y
	sta ic5+1

	lda logo_posx+5
	clc
	adc sin,x
	sta p6+1
	txa
	clc
	adc #$44	
	tax
	and #%00111111
	tay
	lda logo_col,y
	sta ic6+1


	lda logo_posx+6
	clc
	adc sin,x
	sta p7+1
	txa
	clc
	adc #$44	
	tax
	and #%00111111
	tay
	lda logo_col,y
	sta ic7+1


	inc sinpos


	ldx #$ff
iv1:	dex
	bne iv1

	ldx #$ff
iv2:	dex
	bne iv2

	ldx #$ff
iv3:	dex
	bne iv3

	ldx #$b8
iv4:	dex
	bne iv4





	

	jmp main_over	

///////////////////////////////////////////
/// ZOOM Mode ////////////////////////////
/////////////////////////////////////////
	
zoom:	
	lda #$ff
	sta $d015	//sprites on
	sta $d017
	sta $d01d

	ldx #$d4
	stx $07f8
	inx
	stx $07f9
	inx
	stx $07fa
	inx
	stx $07fb
	inx
	stx $07fc
	inx
	stx $07fd
	inx
	stx $07fe

	lda #$b3	//b9 a mergelt sprite :)
	sta $07ff
	
	lda #$78
	sta $d001
	sta $d003
	sta $d005
	sta $d007

	sta $d009
	sta $d00b
	sta $d00d
	sta $d00f


	lda #$9a
	sta $d000
	sta $d002
	sta $d004
	sta $d006

	sta $d008
	sta $d00a
	sta $d00c

	lda #$a6
	sta $d00e

	//tetris elemek szeinei
zc1:	lda #$00
	sta $d027
zc2:	lda #$00
	sta $d028
zc3:	lda #$00
	sta $d029
zc4:	lda #$00
	sta $d02a
zc5:	lda #$00
	sta $d02b
z6:	lda #$00
	sta $d02c
zc7:	lda #$00
	sta $d02d

	lda #$bd
zoomvar:
	cmp $d012
	bne zoomvar


	
	jmp main_over


main_normal:
/////////////////////////
//    elso sor /////////
///////////////////////


	ldx #$1c
r_var5:
	dex
	cpx #$00
	bne r_var5

	stx $d017
	stx $d010
	lda #$ff
	sta $d015

///// bal: 9f  jobb b7

	
	


	lda #$5c
	sta $d00f
	sta $d003
	sta $d005
	sta $d007
	sta $d009
	sta $d00b
	sta $d00d


	lda #$9f
	sta $d00e
	sta $d002
	sta $d006
	sta $d00a
	sta $d00c

	lda #$b7

	sta $d004
	sta $d008

	//1 6 es 7 8nyujtas
	lda #$e1
	sta $d01d	//szethuz x

	ldx #$c0
	stx $07f9
	inx
	stx $07fb
	inx
	stx $07fa
	inx
	stx $07fc
	inx
	stx $07fd
	inx
	stx $07fe
	inx
	stx $07ff


	
	lda #$0f
	sta $d028
	sta $d029
	lda #$0b
	sta $d02a
	sta $d02b
	lda #$02
	sta $d02c
	lda #$01
	sta $d02d
	

	//belojjuk a spriteokat elore a 0800as lapra
	ldx #$d4
	stx $0bf8
	inx
	stx $0bf9
	inx
	stx $0bfa
	inx
	stx $0bfb
	inx
	stx $0bfc
	inx
	stx $0bfd
	inx
	stx $0bfe

	lda #$c7
	sta $0bff


	//68

	ldx  #$68

v1:	dex
	cpx #$00
	bne v1
	nop




nop




	//jmp $ea31

/////////////////////////
// masodik sor /////////
///////////////////////
	
	//atvaltjuk a screent 0800ra
	lda #$28
	sta $d018

	lda #$80
	sta $d01d	//szethuz 8as sprite (hatter)
	

	

	lda #$71
	

	sta $d001
	sta $d003
	sta $d005
	sta $d007
	sta $d009
	sta $d00b
	sta $d00d
	sta $d00f


	lda #$80
	sta $d01c  //8as multira
	lda #$0e	//0b
	sta $d02e

	lda #$aa
	sta $d000
	sta $d002
	sta $d004
	sta $d006
	sta $d008
	sta $d00a
	sta $d00c


	//tetris elemek szeinei
tc1:	lda #$0d
	sta $d027
tc2:	lda #$09
	sta $d028
tc3:	lda #$03
	sta $d029
tc4:	lda #$06
	sta $d02a
tc5:	lda #$05
	sta $d02b
tc6:	lda #$01
	sta $d02c
tc7:	lda #$07
	sta $d02d





	//belojjuk a spriteokat elore a 0400as lapra
	ldx #$c8
	stx $07ff
	inx
	stx $07fe
	inx
	stx $07fd
	inx
	stx $07fc

g1:	lda #$cc
	sta $07fb

g2:	lda #$cd
	sta $07fa

g3:	lda #$ce
	sta $07f9
	
g4:	lda #$cf
	sta $07f8



	ldx  #$58	
v2:	dex
	cpx #$00
	bne v2



//////////////////////////
// harmadik sor /////////
////////////////////////


	nop
	nop


	//screen vissza 0400ra
	lda #$18
	sta $d018


	lda #$86
	sta $d00f
	sta $d00d
	sta $d00b
	sta $d009

	lda #$9f
	sta $d00c
	lda #$b7
	sta $d00a
	lda #$a5
	sta $d008

	lda #$0b
	sta $d02c
	sta $d02d


	//a gombok picit lejjebb :)

	lda #$89
	sta $d001
	sta $d003
	sta $d005
	sta $d007

	lda #$b7
	sta $d000
	sta $d002

	lda #$9f
	sta $d004
	sta $d006

	lda #$02
	sta $d028
	lda #$0a
	sta $d027

	lda #$0c
	sta $d029
	lda #$00
	sta $d02a
	lda #$06
	sta $d02b

	ldx  #$64
v3:	dex
	cpx #$00
	bne v3



//////////////////////////
// negyedik sor /////////
////////////////////////



	ldx #$d0
	stx $07fe
	inx
	stx $07fd


	lda #$9b
	sta $d00d
	sta $d00b


	lda #$0f
	sta $d02c
	sta $d02d


	ldy #$10
piciv:	dey
	bpl piciv

	lda #$0c
	sta $d027
	sta $d028
	
	lda #$a1
	sta $d001
	sta $d003

	lda #$9f
	sta $d000
	lda #$b7
	sta $d002


	inx
	stx $07f8
	inx
	stx $07f9




	ldx  #$a0
v4:	dex
	cpx #$00
	bne v4


	//multit levesszuk
	lda #$00
	sta $d01c 

	//screen vissza 0400ra
	lda #$18
	sta $d018



	ldx #$32
r_var6:
	dex
	cpx #$00
	bne r_var6
	nop
	



main_over:


	ldx #$01
	lda $d012
r_var1:	cmp $d012
	beq r_var1


	stx $d020
	stx $d021


	ldx #$00
	lda $d012
r_var2:	cmp $d012
	beq r_var2

	stx $d020
	stx $d021




	//egyesitjuk az osszes szinu teris elemet

	ldx #$00
merge:

	lda $2e00,x
	eor #$ff
	sta $c001

	lda $3500,x
	ora $3540,x
	ora $3580,x
	ora $35c0,x
	ora $3600,x
	ora $3640,x
	ora $3680,x

	and $c001
	
	sta $2e40,x
	
		
	lda $2e01,x
	eor #$ff
	sta $c001


	lda $3501,x
	ora $3541,x
	ora $3581,x
	ora $35c1,x
	ora $3601,x
	ora $3641,x
	ora $3681,x

	and $c001

	sta $2e41,x

inx
inx
inx

cpx#$3f
bne merge



	// jelenlegi pozit ementjuk

	lda posx
	sta posx_old
	lda posy
	sta posy_old
	lda joy_fire
	sta joy_fire_old


///////////////////
// joy Check :) //
/////////////////


	lda $dc00


	lsr
	bcs j1	

	/////////
	//fel///
	///////

	lda #$dc
	sta g1+1

	lda #$dd
	sta g2+1


	lda #$01
	sta joy_most
	jsr joy_skiptest
	lda joy_mehet
	cmp #$01
	bne j0_vege

	lda posy
	beq j0_vege	//0 ala nem engedjuk
	dec posy

j0_vege:
	jmp j6



j1:
	lsr
	bcs j2

	///////
	//le//
	/////

	lda #$e0
	sta g1+1

	lda #$e1
	sta g2+1

	lda #$02
	sta joy_most
	jsr joy_skiptest
	lda joy_mehet
	cmp #$01
	bne j1_vege

	lda #$00	//automatikus eses ne legyen akkor
	sta spcount

	inc posy
	//jmp j6

j1_vege:
	//sta manual_down
	jmp j6

j2:
	lsr
	bcs j3

	////////
	//bal//
	//////

	lda #$de
	sta g1+1

	lda #$df
	sta g2+1

	lda #$03
	sta joy_most
	jsr joy_skiptest
	lda joy_mehet
	cmp #$01
	bne j2_vege

	lda posx
	beq j2_vege	//0 ala nem engedjuk
	dec posx
	

j2_vege:

	
	jmp j6

j3:
	lsr
	bcs j4
	
	/////////
	//jobb//
	///////


	lda #$e2
	sta g1+1

	lda #$e3
	sta g2+1


	lda #$04
	sta joy_most
	jsr joy_skiptest
	lda joy_mehet
	cmp #$01
	bne j3_vege
	inc posx

j3_vege:

	jmp j6

j4:
	lsr
	bcs j5
	
	//tuzgomb
	lda #$e4
	sta g3+1

	lda #$e5
	sta g4+1
	
	lda #$05
	sta joy_most
	jsr joy_skiptest
	lda joy_mehet
	cmp #$01
	bne j4_vege
	inc joy_fire
	lda joy_fire
	cmp #$04
	bne j4_vege
	lda #$00
	sta joy_fire	



j4_vege:

	jmp j6


j5:
	//semmi
	lda #$cc
	sta g1+1

	lda #$cd
	sta g2+1

	lda #$ce
	sta g3+1

	lda #$cf
	sta g4+1

	lda#$00
	sta joy_uccso
	sta joy_skip


j6:




//////////////////
// bill csekk  //
////////////////


	

	jsr $ffe4
	bne bill1
	jmp billveg



bill1:
	cmp #$85		//F1 - paletta change
	bne bill2
	
	inc paletta_id
	lda paletta_id
	cmp #$04	
	bne pal_tov
	lda #$00
	sta paletta_id
pal_tov:
	asl
	asl
	asl
	tax
	lda paletta,x
	sta tc1+1
	lda paletta+1,x
	sta tc2+1
	lda paletta+2,x
	sta tc3+1
	lda paletta+3,x
	sta tc4+1
	lda paletta+4,x
	sta tc5+1
	lda paletta+5,x
	sta tc6+1
	lda paletta+6,x
	sta tc7+1



	jmp billveg


bill2:
	cmp #$20		// SPACE Part selection
	bne bill3

	inc part_sel
	lda part_sel
	cmp #$03
	bne mchoose
	lda #$00
	sta part_sel

mchoose:
	cmp #$00
	bne masikpart
	
	lda #00
	jsr $1000
	jmp billveg
masikpart:
	lda #$00
	jsr $5000
	jmp billveg

bill3:
	//inc $d021



billveg:



	lda part_sel
	cmp #$02
	bne gameplay
	jmp zeneplayer




gameplay:






/////////////////
// auto posy  //
///////////////



	inc spcount
	lda spcount
	cmp speed
	bne speed_tov


	lda #$00
	sta spcount

	inc posy




speed_tov:








//////////////////////////
/// egy tile kiraksa  //
////////////////////////



	lda #$00
	tax
tempnullaz:
	sta $2e00,x
	inx
	cpx #63
	bne tempnullaz
	

	lda tetris_id
	asl
	asl
	clc
	adc joy_fire
	sta melyik

	tax
	lda posxlimit,x
	cmp posx

	bcs posx_OK	// ha limit feletti a posx kkor lecsapjuk limitre
	sta posx


posx_OK:

	lda tilestart_a,x
	sta honnan+2

	lda tilestart_b,x
	sta honnan+1

	ldy posy
	lda harmas,y		
	sta hova+1

	ldy posx
	lda tizenkettes,y
	tay
	

	ldx #$00
honnan:
	lda $0000,y
hova:
	sta $2e00,x

	iny
	inx

	cpx #12
	bne honnan




/////////////////////
//  utkozes csekk //
///////////////////


	
	ldx #$00
	sta $c000
	
	ldy posy
	lda harmas,y		
	tay

	clc


csekk1:
	lda $2e40,y
	and $2e00,y
	ora $c000
	sta $c000

	iny	
	inx
	cpx #12
	bne csekk1

	lda $c000
	cmp #$00
	bne csekk2

	jmp csekk3
csekk2:
	
	lda posx_old
	sta posx
	lda posy_old
	sta posy
	lda joy_fire_old
	sta joy_fire
	
	
	
csekk3:
	
	

/////////////////////////////////////////////
//  a rendes kepre is kirkjuk a cuccost  ///
///////////////////////////////////////////


	// 1: krealunk egy jo posban levo tilet
	
	ldx melyik

	lda tilestart_a,x
	sta honnan2+2

	lda tilestart_b,x
	sta honnan2+1

	ldy posy
	lda harmas,y		
	sta hova2+1

	ldy posx
	lda tizenkettes,y
	tay
	

	ldx #$00
honnan2:
	lda $0000,y
hova2:
	sta $2e00,x //$2e00

	iny
	inx

	cpx #12
	bne honnan2




	// 2:temp ora tile -> vissza	

	lda tetris_id

	tax
	lda tsm_a,x
	sta tmp_back+2
	lda tsm_b,x
	sta tmp_back+1



	ldx #$3f
tmploop:
	lda tempsprite,x
	ora $2e00,x
tmp_back:
	sta $3500,x

	dex
	bpl tmploop




	lda new_tile
	cmp #$ff
	bne nincs_uj

	lda #$00
	sta new_tile
	lda #$02
	sta posy

nincs_uj:





////////////////////////////
//   also utkozes volt   //
//////////////////////////

	clc
	lda $c000
	cmp #$00
	beq nincs_alsoutkozes

	lda spcount
	cmp #$00
	bne nincs_alsoutkozes


	//ha volt utkozes akkor megnezzuk vane teli sor
	jsr sortorles



	//inc tetris_id	//ide majd randomszam kell, most csak vegigemegy mindegyiken--------------------------------------
	//lda tetris_id
	//cmp #$07
	//bne id_ugras
	//lda #$00
	//sta tetris_id

ujra:	jsr randomgenerator
	lda rnd
	and #%00000111

	cmp #$07
	bcs ujra

	cmp tetris_id
	beq ujra

	sta tetris_id

	
	

id_ugras:


	///////////
	// temp-be el kell rakni a tile eredeti spritejat
	///////////

	tax
	lda tsm_a,x
	sta tmpmasol2+2
	lda tsm_b,x
	sta tmpmasol2+1



	ldx #$3f
tmpmasol2:
	lda $3500,x
	sta tempsprite,x
	dex
	bpl tmpmasol2


	lda #$ff
	sta new_tile
	lda #$01
	sta posy

	lda #$04
	sta posx




nincs_alsoutkozes:





	jsr scoreee

	



	lda #$db
	sta $07f8
	sta $07f9
	sta $07fa
	sta $07fb
	sta $07fc
	sta $07fd
	sta $07fe
	sta $07ff
	lda #$0c
	sta $d02e



////////////////
//zene player//
//////////////
zeneplayer:

	lda part_sel
	cmp #$00
	bne zene2
zene1:
	lda #$00
	jsr $1003
	jmp vegeee
zene2:
	lda #$00
	jsr $5003
	jmp vegeee


vegeee:
	jmp $ea31

		

////////////////////
////joyskipper/////
//////////////////
joy_skiptest:
	lda joy_most
	cmp joy_uccso
	bne j_tov

	//fire eseten nincs ugralas
	cmp #$05
	bne nofire
	lda #$00
	sta joy_mehet
	rts

nofire:

	inc joy_skip
	lda joy_skip
	cmp #5
	beq j_tov+3

	lda #$00
	sta joy_mehet
	
	rts

		
j_tov:
	sta joy_uccso
	lda #$00
	sta joy_skip
	lda#$01
	sta joy_mehet
	rts




//////////////////
// sortorles ////
////////////////
sortorles:

	
	ldx #$00

merg:	lda $2e40,x
	ora $2e00,x



	cmp #$03
	bne mergevege


	lda $2e41,x
	ora $2e01,x

	

	cmp #$ff
	beq van_telesor

	jmp mergevege



van_telesor:

	txa
	tay
	
	dey
	dey
	dey

masol:

	lda $3500,y
	sta $3503,y

	lda $3540,y
	sta $3543,y

	lda $3580,y
	sta $3583,y

	lda $35c0,y
	sta $35c3,y

	lda $3600,y
	sta $3603,y

	lda $3640,y
	sta $3643,y

	lda $3680,y
	sta $3683,y



	lda $3500+1,y
	sta $3503+1,y

	lda $3540+1,y
	sta $3543+1,y

	lda $3580+1,y
	sta $3583+1,y

	lda $35c0+1,y
	sta $35c3+1,y

	lda $3600+1,y
	sta $3603+1,y

	lda $3640+1,y
	sta $3643+1,y

	lda $3680+1,y
	sta $3683+1,y


	dey
	dey
	dey

	cpy #$00
	bne masol

	

	inc score1
	lda score1
	cmp #$0a
	bne mergevege
	lda #$00
	sta score1
	inc score2


mergevege:



	clc	

	inx
	inx
	inx

	cpx #$3f
	beq kilepunk
	jmp merg

kilepunk:
	rts



//////////////
// score  ///
////////////
scoreee:


//64-  tizesek($2200)   74-egyesek($2250)

	lda score2
	asl
	asl
	asl
	tax
	lda score1
	asl
	asl	
	asl
	tay

	lda $2200,x
	ora $2250,y
	sta $350e

	lda $2201,x
	ora $2251,y
	sta $3511

	lda $2202,x
	ora $2252,y
	sta $3514

	lda $2203,x
	ora $2253,y
	sta $3517

	lda $2204,x
	ora $2254,y
	sta $351a


	rts


///////////////////////
// random generator //
/////////////////////
randomgenerator:

	asl rnd
	rol rnd+1
	rol rnd+2
	rol rnd+3
	bcc rndvege

	lda rnd
	eor #$b7
	sta rnd

	lda rnd+1
	eor #$1d
	sta rnd+1

	lda rnd+2
	eor #$1c
	sta rnd+2

	lda rnd+3
	eor #$04
	sta rnd+3

rndvege:
	rts



	
.pc = $2fa0 "posx"
posx:
.byte 4

.pc = $2fa1 "posy"
posy:
.byte 1

.pc = $2fa2 "elozo mozdulat"
joy_uccso:
.byte 0

.pc = $2fa3 "joy skipp"
joy_skip:
.byte 0

.pc = $2fa4 "mostani mozdulat"
joy_most:
.byte 0

.pc = $2fa5 "joy mehet nem mehet"
joy_mehet:
.byte 0

.pc = $2fa6 "joy_fire"
joy_fire:
.byte 0


.pc = $2fa7 "tetris_id"
tetris_id:
.byte 1

.pc = $2fa8 "melyik tetramino melyik pozban  t*4+forgatas"
melyik:
.byte 0

.pc = $2fa9 "speed"
speed:
.byte 50

.pc = $2faa "speedcounter"
spcount:
.byte 0

.pc = $2fab "theme id"
paletta_id:
.byte 0


.pc = $2fac "posx elozo"
posx_old:
.byte 0

.pc = $2fad "posy elozo"
posy_old:
.byte 0

.pc = $2fae "joy_fire elozo"
joy_fire_old:
.byte 0

.pc = $2faf "uj tile"
new_tile:
.byte 0

.pc = $2fb0 "manual lefele volt?"
manual_down:
.byte 0

.pc = $2fb1 "part selector"
part_sel:
.byte 2

.pc = $2fb2 "score1"
score1:
.byte 0

.pc = $2fb3 "score2"
score2:
.byte 0

.pc = $2fb4 "sinpos"
sinpos:
.byte 0



.pc = $3000 "sprite mask"
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,255,255,236,127,255,239,255,255,0,0,0,255,255,255,255,255,255,255,255,255,252,0,0,248,0,0,240,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,7,0,48,15,255,255,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,246,255,255,247,255,255,247,0,0,0,255,255,255,255,255,255,255,255,255,0,0,63,0,0,31,0,0,15,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,192,0,12,224,255,255,240,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,128,16,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,192,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,2,127,128,6,64,0,2,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

//.byte 107,255,233,107,255,233,107,255,233,107,255,233,107,255,233,107,255,233,107,255,233,107,255,233,107,255,233,107,255,233,107,255,233,107,255,233,107,255,233,107,255,233,107,255,233,107,255,233,107,255,233,107,255,233,107,255,233,107,255,233,107,255,233,0
.byte 67,255,193,67,255,193,67,171,193,67,171,193,67,171,193,67,171,193,67,171,193,67,171,193,67,171,193,67,171,193,67,171,193,67,171,193,67,171,193,67,171,193,67,171,193,67,171,193,67,171,193,67,171,193,67,171,193,67,171,193,67,171,193,0


.byte 85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0
.byte 15,255,255,7,255,255,3,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 255,255,224,255,255,192,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,55,182,255,189,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,96,0,0,224,0,1,252,0,3,252,0,7,252,0,0,96,0,0,96,0,0,224,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,0,0,128,0,0,0,0,6,0,0,4,0,0,0,0,0,0,128,0,0,128,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,0,0,248,0,1,248,0,113,248,0,249,248,1,248,240,1,248,0,1,248,0,0,240,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,1,0,0,0,0,0,128,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,227,255,255,143,255,254,62,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,255,255,0,0,0,0
.byte 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,227,255,255,143,255,255,63,255,127,255,253,191,255,246,223,255,219,111,255,109,183,253,182,223,254,219,127,255,109,255,255,183,255,255,223,255,255,255,255,255,255,254,0,0,0,0
.byte 0,0,24,0,0,96,0,1,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 24,0,0,96,0,0,128,0,128,0,2,64,0,9,32,0,36,144,0,146,64,2,73,0,1,36,0,0,144,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

//.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,3,193,0,0,32,0,0,32,0,0,32,0,0,160,0,0,128,0,0,128,0,0,128,0,0
//.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,3,6,0,3,0,0,0,0,0,0,3,0,0,3,0,3,0,0,3,0,0,0
//.byte 0,0,0,0,0,0,0,32,0,0,32,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,8,0,0,192,0,0,64,0,2,64,0,2,28,0,3,16,0,0,0,0,0,0,0,0
//.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,3,128,0,0,0,0,0,1,0,0,1,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0
//.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,96,0,0,72,0,0,28,0,0
//.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,48,0,0,16,0,0,6,0,0,12,0,0,0,0,0,0,0,0,48,0,0,96,0,0
//.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,1,128,0,1,0,0,0,0,0,0,0,0,0,8,0,0,152,0,1,144,0,1,0,0,0,12,0,0,6,0,0,0,0,0

.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0


.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,0,0,224,0,0,224,0,7,252,0,3,248,0,0,224,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,0,7,28,0,0,224,0,0,224,0,0,224,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,192,0,0,192,0,7,224,0,7,224,0,7,224,0,0,192,0,0,192,0,0,128,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,0,0,32,0,0,32,0,0,28,0,0,28,0,0,28,0,0,32,0,0,32,0,0,96,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,0,3,248,0,7,252,0,0,224,0,0,224,0,0,224,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,0,0,224,0,0,224,0,7,28,0,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,96,0,0,96,0,0,252,0,0,252,0,0,252,0,0,96,0,0,96,0,0,32,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,0,0,128,0,0,128,0,7,0,0,7,0,0,7,0,0,0,128,0,0,128,0,0,192,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,0,0,248,0,1,248,0,1,248,0,113,248,0,248,240,0,248,0,0,248,0,0,112,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,1,0,0,0,0,0,240,0,1,136,0,1,0,0,1,0,0,1,0,0,0,128,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0


.pc = $3a00 "tileset"
tileset:
.byte 2,0,0,2,0,0,2,0,0,2,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,128,0,0,128,0,0,128,0,0,128,0,0,64,0,0,64,0,0,64,0,0,64,0,0,32,0,0,32,0,0,32,0,0,32,0,0,16,0,0,16,0,0,16,0,0,16,0,0,8,0,0,8,0,0,8,0,0,8,0,0,4,0,0,4,0,0,4,0,0,4,0,0,2,0,0,2,0,0,2,0,0,2,0,0,1,0,0,1,0,0,1,0,0,1,0
.byte 0,0,0,3,192,0,0,0,0,0,0,0,0,0,0,1,224,0,0,0,0,0,0,0,0,0,0,0,240,0,0,0,0,0,0,0,0,0,0,0,120,0,0,0,0,0,0,0,0,0,0,0,60,0,0,0,0,0,0,0,0,0,0,0,30,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,0,0,0
.byte 0,0,0,3,0,0,3,0,0,0,0,0,0,0,0,1,128,0,1,128,0,0,0,0,0,0,0,0,192,0,0,192,0,0,0,0,0,0,0,0,96,0,0,96,0,0,0,0,0,0,0,0,48,0,0,48,0,0,0,0,0,0,0,0,24,0,0,24,0,0,0,0,0,0,0,0,12,0,0,12,0,0,0,0,0,0,0,0,6,0,0,6,0,0,0,0,0,0,0,0,3,0,0,3,0,0,0,0
.byte 2,0,0,2,0,0,3,0,0,0,0,0,1,0,0,1,0,0,1,128,0,0,0,0,0,128,0,0,128,0,0,192,0,0,0,0,0,64,0,0,64,0,0,96,0,0,0,0,0,32,0,0,32,0,0,48,0,0,0,0,0,16,0,0,16,0,0,24,0,0,0,0,0,8,0,0,8,0,0,12,0,0,0,0,0,4,0,0,4,0,0,6,0,0,0,0,0,2,0,0,2,0,0,3,0,0,0,0
.byte 0,128,0,3,128,0,0,0,0,0,0,0,0,64,0,1,192,0,0,0,0,0,0,0,0,32,0,0,224,0,0,0,0,0,0,0,0,16,0,0,112,0,0,0,0,0,0,0,0,8,0,0,56,0,0,0,0,0,0,0,0,4,0,0,28,0,0,0,0,0,0,0,0,2,0,0,14,0,0,0,0,0,0,0,0,1,0,0,7,0,0,0,0,0,0,0
.byte 3,0,0,1,0,0,1,0,0,0,0,0,1,128,0,0,128,0,0,128,0,0,0,0,0,192,0,0,64,0,0,64,0,0,0,0,0,96,0,0,32,0,0,32,0,0,0,0,0,48,0,0,16,0,0,16,0,0,0,0,0,24,0,0,8,0,0,8,0,0,0,0,0,12,0,0,4,0,0,4,0,0,0,0,0,6,0,0,2,0,0,2,0,0,0,0,0,3,0,0,1,0,0,1,0,0,0,0
.byte 3,128,0,2,0,0,0,0,0,0,0,0,1,192,0,1,0,0,0,0,0,0,0,0,0,224,0,0,128,0,0,0,0,0,0,0,0,112,0,0,64,0,0,0,0,0,0,0,0,56,0,0,32,0,0,0,0,0,0,0,0,28,0,0,16,0,0,0,0,0,0,0,0,14,0,0,8,0,0,0,0,0,0,0,0,7,0,0,4,0,0,0,0,0,0,0
.byte 1,0,0,1,0,0,3,0,0,0,0,0,0,128,0,0,128,0,1,128,0,0,0,0,0,64,0,0,64,0,0,192,0,0,0,0,0,32,0,0,32,0,0,96,0,0,0,0,0,16,0,0,16,0,0,48,0,0,0,0,0,8,0,0,8,0,0,24,0,0,0,0,0,4,0,0,4,0,0,12,0,0,0,0,0,2,0,0,2,0,0,6,0,0,0,0,0,1,0,0,1,0,0,3,0,0,0,0
.byte 3,128,0,0,128,0,0,0,0,0,0,0,1,192,0,0,64,0,0,0,0,0,0,0,0,224,0,0,32,0,0,0,0,0,0,0,0,112,0,0,16,0,0,0,0,0,0,0,0,56,0,0,8,0,0,0,0,0,0,0,0,28,0,0,4,0,0,0,0,0,0,0,0,14,0,0,2,0,0,0,0,0,0,0,0,7,0,0,1,0,0,0,0,0,0,0
.byte 3,0,0,2,0,0,2,0,0,0,0,0,1,128,0,1,0,0,1,0,0,0,0,0,0,192,0,0,128,0,0,128,0,0,0,0,0,96,0,0,64,0,0,64,0,0,0,0,0,48,0,0,32,0,0,32,0,0,0,0,0,24,0,0,16,0,0,16,0,0,0,0,0,12,0,0,8,0,0,8,0,0,0,0,0,6,0,0,4,0,0,4,0,0,0,0,0,3,0,0,2,0,0,2,0,0,0,0
.byte 2,0,0,3,128,0,0,0,0,0,0,0,1,0,0,1,192,0,0,0,0,0,0,0,0,128,0,0,224,0,0,0,0,0,0,0,0,64,0,0,112,0,0,0,0,0,0,0,0,32,0,0,56,0,0,0,0,0,0,0,0,16,0,0,28,0,0,0,0,0,0,0,0,8,0,0,14,0,0,0,0,0,0,0,0,4,0,0,7,0,0,0,0,0,0,0
.byte 3,128,0,1,0,0,0,0,0,0,0,0,1,192,0,0,128,0,0,0,0,0,0,0,0,224,0,0,64,0,0,0,0,0,0,0,0,112,0,0,32,0,0,0,0,0,0,0,0,56,0,0,16,0,0,0,0,0,0,0,0,28,0,0,8,0,0,0,0,0,0,0,0,14,0,0,4,0,0,0,0,0,0,0,0,7,0,0,2,0,0,0,0,0,0,0
.byte 2,0,0,3,0,0,2,0,0,0,0,0,1,0,0,1,128,0,1,0,0,0,0,0,0,128,0,0,192,0,0,128,0,0,0,0,0,64,0,0,96,0,0,64,0,0,0,0,0,32,0,0,48,0,0,32,0,0,0,0,0,16,0,0,24,0,0,16,0,0,0,0,0,8,0,0,12,0,0,8,0,0,0,0,0,4,0,0,6,0,0,4,0,0,0,0,0,2,0,0,3,0,0,2,0,0,0,0
.byte 1,0,0,3,128,0,0,0,0,0,0,0,0,128,0,1,192,0,0,0,0,0,0,0,0,64,0,0,224,0,0,0,0,0,0,0,0,32,0,0,112,0,0,0,0,0,0,0,0,16,0,0,56,0,0,0,0,0,0,0,0,8,0,0,28,0,0,0,0,0,0,0,0,4,0,0,14,0,0,0,0,0,0,0,0,2,0,0,7,0,0,0,0,0,0,0
.byte 1,0,0,3,0,0,1,0,0,0,0,0,0,128,0,1,128,0,0,128,0,0,0,0,0,64,0,0,192,0,0,64,0,0,0,0,0,32,0,0,96,0,0,32,0,0,0,0,0,16,0,0,48,0,0,16,0,0,0,0,0,8,0,0,24,0,0,8,0,0,0,0,0,4,0,0,12,0,0,4,0,0,0,0,0,2,0,0,6,0,0,2,0,0,0,0,0,1,0,0,3,0,0,1,0,0,0,0
.byte 1,128,0,3,0,0,0,0,0,0,0,0,0,192,0,1,128,0,0,0,0,0,0,0,0,96,0,0,192,0,0,0,0,0,0,0,0,48,0,0,96,0,0,0,0,0,0,0,0,24,0,0,48,0,0,0,0,0,0,0,0,12,0,0,24,0,0,0,0,0,0,0,0,6,0,0,12,0,0,0,0,0,0,0,0,3,0,0,6,0,0,0,0,0,0,0
.byte 2,0,0,3,0,0,1,0,0,0,0,0,1,0,0,1,128,0,0,128,0,0,0,0,0,128,0,0,192,0,0,64,0,0,0,0,0,64,0,0,96,0,0,32,0,0,0,0,0,32,0,0,48,0,0,16,0,0,0,0,0,16,0,0,24,0,0,8,0,0,0,0,0,8,0,0,12,0,0,4,0,0,0,0,0,4,0,0,6,0,0,2,0,0,0,0,0,2,0,0,3,0,0,1,0,0,0,0
.byte 3,0,0,1,128,0,0,0,0,0,0,0,1,128,0,0,192,0,0,0,0,0,0,0,0,192,0,0,96,0,0,0,0,0,0,0,0,96,0,0,48,0,0,0,0,0,0,0,0,48,0,0,24,0,0,0,0,0,0,0,0,24,0,0,12,0,0,0,0,0,0,0,0,12,0,0,6,0,0,0,0,0,0,0,0,6,0,0,3,0,0,0,0,0,0,0
.byte 1,0,0,3,0,0,2,0,0,0,0,0,0,128,0,1,128,0,1,0,0,0,0,0,0,64,0,0,192,0,0,128,0,0,0,0,0,32,0,0,96,0,0,64,0,0,0,0,0,16,0,0,48,0,0,32,0,0,0,0,0,8,0,0,24,0,0,16,0,0,0,0,0,4,0,0,12,0,0,8,0,0,0,0,0,2,0,0,6,0,0,4,0,0,0,0,0,1,0,0,3,0,0,2,0,0,0,0


.pc = $2f00 "tilestart"
tilestart_a:
.byte $3a,$3a,$3a,$3a,$3a,$3a,$3a,$3a,$3b,$3b,$3c,$3c,$3c,$3d,$3d,$3e,$3e,$3e,$3f,$3f,$40,$40,$40,$40,$40,$41,$40,$41
tilestart_b:
.byte $00,$78,$00,$78,$cc,$cc,$cc,$cc,$38,$a4,$04,$70,$d0,$3c,$9c,$08,$68,$c8,$34,$94,$00,$60,$00,$60,$cc,$2c,$cc,$2c


.pc = $2f40 "posx limitek"
posxlimit:
//.byte 10,7,10,7,9,9,9,9,9,8,9,8,9,8,9,8,8,9,8,9
.byte 9,6,9,6,  8,8,8,8,  8,7,8,7,  8,7,8,7,   7,8,7,8,   7,8,7,8,   7,8,7,8	

.pc = $2f60 "12es szorzotabla"
tizenkettes:
.byte 0,12,24,36,48,60,72,84,96,108,120,132,144,156,168,180,192,204,216,228,240,252

.pc = $2f80 "3as szorzotabla"
harmas:
.byte 0,3,6,9,12,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,60,63,66,69,72,75,78,81,84,87,90


.pc = $2e40 "mergelt spriteok / jatekmezo"
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0
.byte 255,255,255    // ez a padlo :)

.pc = $2e00 "tile mozgato temp sprite"
.byte 128,0,1,128,0,1,128,0
.byte 1,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0

.pc = $2dc0 "egy szin temp sprite"
tempsprite:
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0


.pc = $2cc0 "zoom BG"
zoom_bg:
.byte 255,192,0,255,192,0,255,192,0
.byte 255,192,0,255,192,0,255,192,0
.byte 255,192,0,255,192,0,255,192,0
.byte 255,192,0,255,192,0,255,192,0
.byte 255,192,0,255,192,0,255,192,0
.byte 255,192,0,255,192,0,255,192,0
.byte 255,192,0,255,192,0,255,192,0
.byte 0


.pc = $2d00 "color theme"
paletta:
//.byte 02,03,04,05,06,07,08,00
//.byte 03,07,08,10,04,13,02,05
.byte 13,09,03,06,05,01,07,00
.byte 00,06,04,03,01,13,15,00
.byte 06,06,06,06,06,06,06,00
.byte 01,01,01,01,01,01,01,00

.pc = $2d30 "tilespr mem a"
tsm_a:
.byte $35,$35,$35,$35,$35,$35,$35,$35

.pc = $2d38 "tilespr mem b"
tsm_b:
.byte $00,$40,$80,$c0,$00,$40,$80,$c0


.pc = $2d20 "random cucc"
rnd:
.byte 255,255,255,255





.pc = $2000 "fontZ"  //64  0*   74  *0
.byte 0,126,66,90,94,64,126,0
.byte 0,0,124,12,124,108,124,0
.byte 0,96,96,124,108,108,124,0
.byte 0,0,124,108,96,108,124,0
.byte 0,12,12,124,108,108,124,0
.byte 0,0,124,108,124,96,124,0
.byte 0,0,124,108,96,112,96,96
.byte 0,0,124,108,108,124,12,124
.byte 0,0,96,124,108,108,108,0
.byte 0,0,48,0,48,48,48,0
.byte 0,0,24,0,24,24,24,56
.byte 0,0,108,108,112,108,108,0
.byte 48,48,48,48,48,48,48,0
.byte 0,0,68,108,124,108,108,0
.byte 0,0,124,108,108,108,108,0
.byte 0,0,124,108,108,108,124,0
.byte 0,0,124,108,108,124,96,96
.byte 0,0,124,108,108,108,124,6
.byte 0,0,124,108,96,96,96,0
.byte 0,0,124,96,124,12,124,0
.byte 96,96,96,112,96,108,124,0
.byte 0,0,108,108,108,108,124,0
.byte 0,0,108,108,108,56,16,0
.byte 0,0,108,108,124,108,68,0
.byte 0,0,108,108,56,108,108,0
.byte 0,0,108,108,56,48,96,96
.byte 0,0,124,12,124,96,124,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,48,48,48,48,0,48,0
.byte 0,108,72,0,0,0,0,0
.byte 0,108,108,254,108,254,108,108
.byte 0,0,0,0,0,0,0,0
.byte 0,0,102,76,24,50,102,0
.byte 0,0,0,0,0,0,0,0
.byte 0,48,32,0,0,0,0,0
.byte 0,0,56,96,96,96,56,0
.byte 0,0,112,24,24,24,112,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,96,96,192
.byte 0,0,0,124,124,0,0,0
.byte 0,0,0,0,0,96,96,0
.byte 0,4,12,24,48,96,64,0
.byte 0,0,124,108,108,108,124,0
.byte 0,0,56,24,24,24,24,0
.byte 0,0,124,12,124,96,124,0
.byte 0,0,124,12,60,12,124,0
.byte 0,0,108,108,124,12,12,0
.byte 0,0,124,96,124,12,124,0
.byte 0,0,124,96,124,108,124,0
.byte 0,0,124,12,28,12,12,0
.byte 0,0,124,108,124,108,124,0
.byte 0,0,124,108,124,12,124,0
.byte 0,0,48,48,0,48,48,0
.byte 0,0,48,48,0,48,48,96
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,124,12,28,48,0,48,0
.byte 112,80,80,80,112,0,0,0
.byte 32,32,32,32,32,0,0,0
.byte 112,16,112,64,112,0,0,0
.byte 112,16,48,16,112,0,0,0
.byte 80,80,112,16,16,0,0,0
.byte 112,64,112,16,112,0,0,0
.byte 112,64,112,80,112,0,0,0
.byte 112,16,16,16,16,0,0,0
.byte 112,80,112,80,112,0,0,0
.byte 112,80,112,16,112,0,0,0
.byte 7,5,5,5,7,0,0,0
.byte 2,2,2,2,2,0,0,0
.byte 7,1,7,4,7,0,0,0
.byte 7,1,3,1,7,0,0,0
.byte 5,5,7,1,1,0,0,0
.byte 7,4,7,1,7,0,0,0
.byte 7,4,7,5,7,0,0,0
.byte 7,1,1,1,1,0,0,0
.byte 7,5,7,5,7,0,0,0
.byte 7,5,7,1,7,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0


.pc = $2b00 "TETRIS LOGO"
logoSPR:
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,103,48,107,13,128,107,109,176,99,109,176,99,109,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	
.byte 0,0,0,127,191,252,127,191,252,127,191,252,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	
.byte 0,0,0,119,255,252,119,255,252,119,255,252,112,0,0,112,0,0,127,248,0,127,248,0,127,248,0,112,0,0,112,0,0,119,255,252,119,255,252,119,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	
.byte 0,0,0,119,255,240,119,255,248,119,255,252,112,0,28,112,0,28,127,255,252,127,255,248,127,255,240,112,3,192,112,1,224,112,0,240,112,0,120,112,0,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	
.byte 0,0,0,0,56,0,0,56,0,0,56,0,0,0,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	
.byte 0,0,0,31,255,252,63,255,248,127,255,240,112,0,0,112,0,0,127,255,240,63,255,248,31,255,252,0,0,28,0,0,28,31,255,252,63,255,248,127,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	

.pc = $2c80 "logo posx"
logo_posx:
.byte $20,$34,$64,$94,$c4,$e2,$00

.pc = $2980 "logo color"
logo_col:
//.byte 0,4,6,14,3,7,1,13,15,12,11,0,0,0,0,0

//.byte 1,1,7,7,15,15,12,12
//.byte 11,11,0,0,0,0,0,0
.byte 1,7,8,9,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0

.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,9,8,7

.pc = $2a00 "sin"
sin:
.byte 10,9,8,7,6,5,4,3,2,2,1,1,0,0,0,0
.byte 0,0,0,0,0,1,1,2,2,3,4,5,6,7,8,9
.byte 10,11,12,13,13,14,15,16,17,17,18,18,19,19,19,19
.byte 19,19,19,19,19,18,18,17,16,16,15,14,13,12,11,10
.byte 9,8,7,6,5,5,4,3,2,2,1,1,0,0,0,0
.byte 0,0,0,0,0,1,1,2,3,3,4,5,6,7,8,9
.byte 10,11,12,13,14,15,15,16,17,17,18,19,19,19,19,19
.byte 19,19,19,19,19,18,18,17,16,15,15,14,13,12,11,10
.byte 9,8,7,6,5,4,4,3,2,1,1,0,0,0,0,0
.byte 0,0,0,0,0,1,2,2,3,4,4,5,6,7,8,9
.byte 10,11,12,13,14,15,16,16,17,18,18,19,19,19,19,19
.byte 19,19,19,19,18,18,17,17,16,15,14,14,13,12,11,10
.byte 9,8,7,6,5,4,3,3,2,1,1,0,0,0,0,0
.byte 0,0,0,0,1,1,2,2,3,4,5,6,6,7,8,9
.byte 10,11,12,13,14,15,16,17,17,18,18,19,19,19,19,19
.byte 19,19,19,19,18,18,17,17,16,15,14,13,12,11,10,10

