/************************************** 
* CC65 Tiny-Pong in C                 *
* josip.kalebic@gmail.com, 2022.      *
**************************************/

/* #define DEBUG */

// some cleanup, bugfixing, deluxe improvements by the human waist
// if you take this seriously you are a silly golem

// Build: cl65 -Osir --static-locals -o tiny_pong.prg tiny_pong.c

#include <stddef.h>
#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <conio.h>
#include <c64.h>
#include <peekpoke.h>
#include <cc65.h>

uint8_t sprite[64] = {
    255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,0
};
uint8_t sprite2[64] = {
    255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,47,128,2,40,128,2,72,128,2,136,
    128,3,136,128,2,136,128,2,72,128,2,40,128,2,47,128,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,255,255,255,0
};

#define SPRITELOC   0x3200
#define SPRITE2LOC  0x3240

uint8_t *SPRITE = (uint8_t*)SPRITELOC;

uint8_t ball_x = 4;
uint8_t ball_y = 4;
uint8_t ball_dx = 1;
uint8_t ball_dy = 1;
uint8_t ball_hx = 0;
uint8_t ball_hy = 0;

uint8_t bat_l = 5;
uint8_t bat_r = 10;

uint8_t score_l = 0;
uint8_t score_r = 0;
uint8_t score = 0;

uint16_t x = 30;
uint8_t y = 60;
signed char dy = 1;
signed char dx = 1;

uint8_t move_sprite = 0;
uint8_t doublesize = 0;
uint8_t playing = 0;

uint8_t mul3tab[30] =
{
    0*3,1*3,2*3,3*3,4*3,5*3,6*3,7*3,8*3,9*3,
    10*3,11*3,12*3,13*3,14*3,15*3,16*3,17*3,18*3,19*3,
    20*3,21*3,22*3,23*3,24*3,25*3,26*3,27*3,28*3,29*3
};

uint8_t bittab[8] =
{
    0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01
};
uint8_t bittab2[8] =
{
    ~0x80, ~0x40, ~0x20, ~0x10, ~0x08, ~0x04, ~0x02, ~0x01
};

uint8_t getBitXY(int x,int y) 
{
    uint8_t pos;

    pos = mul3tab[y] + (x >> 3);
    return SPRITE[pos] & bittab[x & 7];
}

void setBitXY(int x,int y) 
{
    uint8_t pos;

    pos = mul3tab[y] + (x >> 3);
    SPRITE[pos] |= bittab[x & 7];
}

void clearBitXY(int x,int y) 
{
    uint8_t pos;

    pos = mul3tab[y] + (x >> 3);
    SPRITE[pos] &= bittab2[x & 7];
}

void initSpritePos(void) 
{
    x = 30;
    y = 80;

    VIC.spr0_x = x & 0xff;
    VIC.spr_hi_x = x >> 8;
    VIC.spr0_y = y;
}

void setupSprite(void) 
{
    uint8_t i;

    POKE(0x07F8, SPRITELOC / 64);

    for(i = 0; i < 64; ++i) {
        POKE(SPRITELOC + i, sprite[i]);
    }

    for(i = 0; i < 64; ++i) {
        POKE(SPRITE2LOC + i, sprite2[i]);
    }

    VIC.spr_ena = 3; //enable sprite 1 and 2

    VIC.spr_exp_x = 0; // sprite double width no
    VIC.spr_exp_y = 0; // sprite double height no

    VIC.spr0_color = 1;  // sprite main color
    VIC.spr_mcolor = 0;  // disable multicolor

    initSpritePos();
}

void moveSprite(void) {

    x= x + dx;
    y= y + dy;

    if (doublesize) {
        if(y >= (228-21) || y <= 50) { dy =- dy; }
        if(x >= (320-24)  || x <= 24) { dx =- dx; }
    } else {
        if(y >= 228 || y <= 50) { dy =- dy; }
        if(x >= 320  || x <= 24) { dx =- dx; }
    }

    VIC.spr0_x = x & 0xff;
    VIC.spr_hi_x = x >> 8;
    VIC.spr0_y = y;
}

void batSound(void) 
{
    uint8_t i;

    SID.v1.ctrl  = 0x10;
    SID.amp      = 0x1F;     // Volume
    SID.v1.ad    = 0x09;     // Attack/decay voice 1
    SID.v1.sr    = 0x88;

    SID.v1.freq  = 0x1125;   // Frequency 
    SID.v1.ctrl  = 0x11;     // Control voice 1

    SID.v1.ctrl  = 0x10;
}

void makeSound(void) 
{
    const unsigned int scale[] = {
        0x1125, 0x133F, 0x159A, 0x16E3,
        0x19B1, 0x1CD6, 0x205E, 0x22AF
    };

    uint8_t t;

    SID.amp      = 0x1F;     // Volume
    SID.v1.ad    = 0x09;     // Attack/decay voice 1
    SID.v1.sr    = 0x88;

    for (t = 0 ; t < sizeof(scale) / 2; t++) {
        SID.v1.freq  = scale[t];  // Frequency 
        SID.v1.ctrl  = 0x11;      // Control voice 1
        waitvsync();
        SID.v1.ctrl  = 0x10;
        waitvsync();
    }
}

void printScores(void)
{
    textcolor(7);
    gotoxy(0,2);
    cprintf(" %i - %i  #%i   ", score_l, score_r, score);
}

void doScores(int addto) {

    if(addto == 1) {
        ++score_l;
    } else if(addto == 2) {
        ++score_r;
    }

    if(addto) {
        POKE(0x07F8, SPRITE2LOC / 64);
        makeSound();
        POKE(0x07F8, SPRITELOC / 64);
    }
    printScores();
}

void moveBall(void) 
{
    ball_x = ball_x + ball_dx;
    ball_y = ball_y + ball_dy;

    // here we will check for collision with a bats
    if(getBitXY(ball_x, ball_y) > 0) {
        // we have a collision
        ball_dx=-ball_dx;
        ball_x = ball_hx + ball_dx;
        batSound();
        ++score;
        printScores();
    } 

    clearBitXY(ball_hx, ball_hy);
    setBitXY(ball_x, ball_y);

    ball_hx = ball_x;
    ball_hy = ball_y;

    if(ball_y >= 19) { ball_y = 19; ball_dy =- ball_dy; }
    if(ball_y <= 1) { ball_y = 1; ball_dy =- ball_dy; }

    // this part will end current game a calcualte score
    if(ball_x >= 23) { ball_dx =- ball_dx; doScores(1); }
    if(ball_x <= 0) { ball_dx =- ball_dx; doScores(2); }
}

void setBats(void) 
{
    uint8_t i;

    if (bat_l > 1) clearBitXY(0, bat_l-1);
    for(i = bat_l; i < (bat_l + 6); ++i) {
        setBitXY(0, i);
    }
    if (i < 20) clearBitXY(0, i);

    if (bat_r > 1) clearBitXY(23, bat_r - 1);
    for(i = bat_r; i < bat_r + 6; ++i) {
        setBitXY(23, i);
    }
    if (i < 20) clearBitXY(23, i);
}

void setUpInitArena(void) 
{
    setBats();
    ball_x = 4; ball_y = 4;
    ball_dx = 1; ball_dy = 1;
    setBitXY(ball_x, ball_y);
    ball_hx = ball_x; ball_hy = ball_y;
}

void resetGame(void)
{
    score = score_l = score_r = 0;
    playing = 0;

    clearBitXY(ball_hx, ball_hy);
    clearBitXY(ball_x, ball_y);
    setupSprite();
    setUpInitArena();
}

void drawScreen(void) 
{
    gotoxy(0,0);

    textcolor(1);
    cputs("tiny - pong deluxe\n\r");

    textcolor(5);
    cputs("******************\n\r");

    printScores();

    textcolor(12);
    gotoxy(0, 10);
    cputs("w/s or joy#2 to play\n\r\n\r"
          "q        - change size\n\r"
          "space    - moving arena:\n\r"
          "run/stop - default arena position\n\r");

    gotoxy(25,13);
    cputs(move_sprite ? "yes" : "no ");
}

void checkKeyPress(void) 
{
    uint8_t k1 = PEEK(0xCB); // get key
    uint8_t k2;

    // get joystick
    asm("sei");
    POKE(0xdc02, 0);
    k2 = PEEK(0xdc00) ^ 0xff;
    POKE(0xdc02, 0xff);
    asm("cli");

    // w
    if (k1 == 9 || (k2 & 0x04)) {
        if (playing == 0) {
            printScores();
        }
        playing = 1;

        if(bat_l > 1) {
            --bat_l;
        } 
        if(bat_r < 14) {
            ++bat_r;
        }
        return;
    }

    // s
    else if (k1 == 13 || (k2 & 0x08)) {
        if (playing == 0) {
            printScores();
        }
        playing = 1;

        if(bat_l < 14) {
            ++bat_l;
        }
        if(bat_r > 1) {
            --bat_r;
        }
        return;
    }

    if (kbhit()) {
        k1 = cgetc();
        // space
        if (k1 == ' ')  {
            move_sprite ^= 1;
            initSpritePos();
            drawScreen();
            return;
        }

        // run-stop
        else if (k1 == CH_STOP) {
            // end game
            move_sprite = 0;
            initSpritePos();
            resetGame();
            return;
        }

        // q
        else if (k1 == 'q') {
            doublesize ^= 1;
            initSpritePos();

            VIC.spr_exp_x = doublesize; // sprite double width
            VIC.spr_exp_y = doublesize; // sprite double height
            return;
        }
    }
}

void syncit(void)
{
    while(!((*(unsigned char*)0xd011) & 0x80)) {} ;
}

int main(void) 
{
    uint8_t c1 = 0;
    uint8_t c2 = 0;

    POKE(0xd018, 20); // set big petscii chars

    clrscr();
    drawScreen();

    setupSprite();
    setUpInitArena();

    while(1) {
#ifdef DEBUG
        asm("inc $d020");
#endif
        if (playing) {
            ++c1; if (c1 == 3) c1 = 0;
            if (c1 == 0) {
                moveBall();
            }
            setBats();
            if (move_sprite) {
                c2 += 3;
                if (c2 >= 7) {
                    c2 -= 7;
                    moveSprite();
                }
            }
        }
        checkKeyPress();
#ifdef DEBUG
        asm("dec $d020");
#endif
        syncit();
    }

    return EXIT_SUCCESS;
}
