;***************************************
;*                                     *
;*            Poing Ultra              *
;*    Written by Richard Bayliss       *
;*   For RETRO PROGRAMMERS INSIDE      *
;*          PONG Challenge             *
;*                                     *
;*     (C) 2022 The New Dimension      *
;*                                     *
;***************************************

;GAME CODE

;---------------------------------------
;RESTORE press automatically goes back 
;to the main title screen

         lda #<title
         sta $0328
         lda #>title
         sta $0329
		 lda #8
		 jsr $ffd2
		 lda #$00
		 sta $c6 ;Flush key press once
;---------------------------------------
         ;Onetime PAL/NTSC system check

pncheck  lda $d012
         cmp $d012
         beq *-3
         bmi pncheck
         cmp #$20
         bcc ntsct
         lda #1
         sta system
         jmp title
ntsct    lda #0
         sta system
         jmp title
;---------------------------------------
;Main code start
gamestart
         sei
         lda #$0b
         sta $d011
		 lda #$03
		 sta $dd00
         ldx #$31
         ldy #$ea
         lda #$81
         stx $0314
         sty $0315
         sta $dc0d
         sta $dd0d
         lda #$00
         sta $d019
         sta $d01a
	
;Setup hardware registers and display
;the game screen

         lda #$1a
         sta $d018
         lda #$18
         sta $d016
         lda #$00
         sta $d020
         sta $d021
         lda #$01
         sta $d022
         lda #$09
         sta $d023
         ldx #$fb
         txs
         lda defaultbatspd
         sta batspeed1
         sta batspeed2

         ;Draw game map to screen

         ldx #$00
drawscreen
         lda gamemap,x
         sta $0400,x
         lda gamemap+$0100,x
         sta $0500,x
         lda gamemap+$0200,x
         sta $0600,x
         lda gamemap+$02e8,x
         sta $06e8,x
         lda gamecol,x
         sta $d800,x
         lda gamecol+$0100,x
         sta $d900,x
         lda gamecol+$0200,x
         sta $da00,x
         lda gamecol+$02e8,x
         sta $dae8,x
         inx
         bne drawscreen
;Call random routine and select
;void character, and colour scheme.

		jsr random
		and #7
		sta voidtype 
		jsr random 
		and #7
		sta voidcolourstore
		
		ldx voidtype 
		lda voidtopleftlo,x 
		sta voidsm1+1
		lda voidtoplefthi,x 
		sta voidsm1+2
		lda voidtoprightlo,x 
		sta voidsm2+1
		lda voidtoprighthi,x 
		sta voidsm2+2 
		lda voidbottomleftlo,x 
		sta voidsm3+1
		lda voidbottomlefthi,x 
		sta voidsm3+2 
		lda voidbottomrightlo,x 
		sta voidsm4+1
		lda voidbottomrighthi,x 
		sta voidsm4+2
		lda voidcolour,x 
		sta voidcolourstore
		
		;Draw the void 
		
		ldx #$00
voidsm1	lda voidchar1a,x
		sta scrtile1,x 
voidsm2 lda voidchar1b,x 
		sta scrtile2,x 
voidsm3 lda voidchar1c,x 
		sta scrtile3,x 
voidsm4	lda voidchar1d,x 
		sta scrtile4,x
		inx 
		cpx #8
		bne voidsm1
		
;Now check for dark blue background 
;which has been stored to screen colour
;RAM. Replace the colour with the void
;colour pointer Then paint to a new 
;colour according to table row.

		lda #0
		sta fieldreadpointer
convertfield		
		ldx fieldreadpointer
		lda rowtblo,x 
		sta fieldcolsm1+1
		sta fieldcolsm2+1
		lda rowtblhi,x
		sta fieldcolsm1+2
		sta fieldcolsm2+2 
		inx 
		cpx #24
		beq initsettings 
		inc fieldreadpointer 
		jsr drawfieldcolour 
		jmp convertfield
drawfieldcolour 
		 
		ldx #$00
fieldcolsm1
		lda $d829,x
		jsr checkcolour
fieldcolsm2 
		sta $d829,x
		inx 
		cpx #38
		bne fieldcolsm1
		rts
		
		
checkcolour
		and #7
		cmp #$06
		bne colourok 
		lda voidcolourstore
colourok
		rts

		
         ;Initialise pointers
initsettings
         ldx #$00
initptrs lda pointers,x
         and #$00
         sta pointers,x
         inx
         cpx #pointersend-pointers
         bne initptrs
         jsr initscore
         lda #0
         sta p1frozen
         sta p2frozen
         lda #1
         sta p1joyup+1
         sta p2joyup+1
         lda #2
         sta p1joydown+1
         sta p2joydown+1
		 lda #60 ;1 second ball collider 
		 sta waitball ;wait time
		
;Setup game sprites

         lda bat
         sta $07f8 ;Sprite 0 = bat
         sta $07f9 ;Sprite 1 = ball
         lda ball
         sta $07fa

                        ;Sprites
         lda #%00011111 ;0-4 enabled
         sta $d015
         sta $d01c

         lda #$8c
         sta player1ypos
         sta player2ypos
         sta ballypos
         lda #$0e
         sta player1xpos
         lda #$a1
         sta player2xpos
         lda #$8c
         sta alienypos
         lda #$56
         sta ballxpos
         sta alienxpos
		 lda #0
		 sta powerupxpos 
		 sta powerupypos
		 
         lda #$05
         sta $d02a
         jsr resetball
         lda #$0e ;Left bat = light ble
         sta $d027
         lda #$0a ;Right bat = pink
         sta $d028
         lda #$0f ;Ball = silver
         sta $d029

         lda #$09
         sta $d025
         lda #$01
         sta $d026

         ldx #$00
clearsound lda #$00
         sta $d400,x
         inx
         cpx #$18
         bne clearsound

         jsr rotateup

		 ldx #$fb 
		 txs
;Setup IRQ raster interrupt

         ldx #<irq
         ldy #>irq
         lda #$7f
         stx $0314
         sty $0315
         sta $dc0d
         sta $dd0d
         lda #$2a
         sta $d012

         lda #$1b
         sta $d011
         lda #$01
         sta $d01a
         sta $d019
         lda soundoption
         cmp #1
         beq sfx
         lda #$00
         jsr musicinit
         jmp nextcli
sfx      lda #$0f
         sta $d418
         lda #$88
         sta 54274
         sta 54275
		 
nextcli  cli
		 lda #shieldcount
		 sta p1shieldtime
		 sta p2shieldtime
         jmp gameloop

;Main single irq

irq      asl $d019
         lda $dc0d
         sta $dd0d
         lda #$fa
         sta $d012
         lda #1
         sta rt
         jsr musicplayer
         jmp $ea7e

;PAL/NTSC sound player check

musicplayer lda system
         beq ntscmode
         jmp pal
ntscmode
         inc ntsctimer
         lda ntsctimer
         cmp #6
         beq resetntsc
pal      lda soundoption
         cmp #1
         beq soundfx
         jsr musicplay
         rts
soundfx  jsr sfxplay
         rts
resetntsc lda #$00
         sta ntsctimer
         rts


;Main game loop

gameloop jsr synctimer
         jsr ballcontrol
         jsr playercontrol
         jsr collision

         jmp gameloop

;Synchronize game timer

synctimer
         lda #0
         sta rt
         cmp rt
         beq *-3

         jsr expandmsb
         jsr bganim
         jsr animspawn
		 jsr flashshield
         jmp testspawner


;Expand sprite position area so that all
;sprites can use whole screen area,
;rather than a portion of it!

expandmsb ldx #$00
expmain  lda softsprpos+1,x
         sta $d001,x
         lda softsprpos,x
         asl a
         ror $d010
         sta $d000,x
         inx
         inx
         cpx #16
         bne expmain
         rts

;Background animation routines

bganim   jsr laseranim
         jmp rotator


         ;Animate the lasers

laseranim
         lda lasdelay
         cmp #2
         beq lasok
         inc lasdelay
         rts
lasok    lda #$00
         sta lasdelay
         lda laserchar1
         pha
         ldx #$00
chrloop1 lda laserchar1+1,x
         sta laserchar1,x
         inx
         cpx #$08
         bne chrloop1
         pla
         sta laserchar1+7
         lda laserchar2+7
         pha
         ldx #$06
chrloop2 lda laserchar2,x
         sta laserchar2+1,x
         dex
         bpl chrloop2
         pla
         sta laserchar2
         rts

;Rotating tiles
rotator  jsr rotatetimer
         lda tiledelay
         cmp #2
         beq tileok
         inc tiledelay
         rts
tileok   lda #$00
         sta tiledelay

;Check direction the tiles can shift.

         lda tiledir
         bne notnorth
         jmp north
notnorth cmp #1
         bne notnortheast
         jmp northeast
notnortheast cmp #2
         bne noteast
         jmp east
noteast  cmp #3
         bne notsoutheast
         jmp southeast
notsoutheast
         cmp #4
         bne notsouth
         jmp south
notsouth cmp #5
         bne notsouthwest
         jmp southwest
notsouthwest cmp #6
         bne notwest
         jmp west
notwest  cmp #7
         bne fault
         jmp northwest
fault    jmp *

north    jmp rotateup

northeast jsr rotateup
         jmp rotateright

east     jmp rotateright

southeast jsr rotatedown
         jmp rotateright

south    jmp rotatedown

southwest jsr rotatedown
         jmp rotateleft

west     jmp rotateleft

northwest jsr rotateup
         jmp rotateleft



rotatetimer
         inc tilewaitdelay
         lda tilewaitdelay
         beq nextdirection
         rts
nextdirection inc tiledir

         lda tiledir
         cmp #8
         beq resettiledir
         rts
resettiledir lda #$00
         sta tiledir
         rts

rotateup lda scrtile1
         pha
         lda scrtile3
         pha
         ldx #$00
movup1   lda scrtile1+1,x
         sta scrtile1,x
         inx
         cpx #7
         bne movup1
         pla
         sta scrtile1+7

         ldx #$00
movup2   lda scrtile3+1,x
         sta scrtile3,x
         inx
         cpx #7
         bne movup2
         pla
         sta scrtile3+7

         lda scrtile2
         pha
         lda scrtile4
         pha
         ldx #$00
movup3   lda scrtile2+1,x
         sta scrtile2,x
         inx
         cpx #7
         bne movup3
         pla
         sta scrtile2+7

         ldx #$00
movup4   lda scrtile4+1,x
         sta scrtile4,x
         inx
         cpx #7
         bne movup4
         pla
         sta scrtile4+7
         rts

         ;Move tile data down
rotatedown
         lda scrtile1+7
         pha
         lda scrtile3+7
         pha

         ldx #$06
movdn1   lda scrtile1,x
         sta scrtile1+1,x
         dex
         bpl movdn1
         pla
         sta scrtile1
         ldx #$06
movdn2   lda scrtile3,x
         sta scrtile3+1,x
         dex
         bpl movdn2
         pla
         sta scrtile3

         lda scrtile2+7
         pha
         lda scrtile4+7
         pha
         ldx #$06
movdn3   lda scrtile2,x
         sta scrtile2+1,x
         dex
         bpl movdn3
         pla
         sta scrtile2
         ldx #$06
movdn4   lda scrtile4,x
         sta scrtile4+1,x
         dex
         bpl movdn4
         pla
         sta scrtile4
         rts

         ;Rotate tiles left

rotateleft
         ldx #$00
movleft1 lda scrtile1,x
         asl a
         rol scrtile2,x
         rol scrtile1,x
         inx
         cpx #8
         bne movleft1

         ldx #$00
movleft2 lda scrtile3,x
         asl a
         rol scrtile4,x
         rol scrtile3,x
         inx
         cpx #8
         bne movleft2
         rts

         ;Rotate to right

rotateright
         ldx #$00
movright1 lda scrtile1,x
         lsr a
         ror scrtile2,x
         ror scrtile1,x
         inx
         cpx #8
         bne movright1

         ldx #$00
movright2 lda scrtile3,x
         lsr a
         ror scrtile4,x
         ror scrtile3,x
         inx
         cpx #8
         bne movright2
         rts

;In game ball control

ballcontrol
         jsr moveballx
         jmp movebally


moveballx
         lda balldirx
         beq ballleft
         jmp ballright
         ;Ball bouncing X-direction
ballleft
         lda ballxpos ;Ball spr object
         sec
ballspd1 sbc ballspeedx
         ;cmp #ballboundleft
         bcs nobouncex
		; cmp #$f0 
		; bcs nobouncex
         lda #1
         sta balldirx
         jmp killplayer1
nobouncex sta ballxpos
         rts

ballright
         lda ballxpos
         clc
ballspd2 adc ballspeedx
         cmp #ballboundright
         bcc nobouncex
		 jsr ball2sfx
         lda #0
         sta balldirx
         jmp killplayer2

         ; Ball bouncing Y-Direction

movebally
         lda balldiry
         beq ballup
         jmp balldown

ballup   lda ballypos
         sec
         sbc ballspeedy
         cmp #ballboundup
         bcs nobouncey
         jsr ball2sfx
         lda #1
         sta balldiry
         jsr addhit
         rts
nobouncey sta ballypos
         rts

balldown lda ballypos
         clc
         adc ballspeedy
         cmp #ballbounddown
         bcc nobouncey
         jsr ball2sfx
         lda #0
         sta balldiry
         jsr addhit
         rts

;Kill player 1

killplayer1

		 lda #1 
		 sta player1dead
         lda #0
         sta ballxpos
         sta ballypos
         jsr explodesfx
		 
         lda #1
         sta p1joyup+1
         lda #2
         sta p1joydown+1
         lda defaultbatspd
         sta batspeed1
         lda #0
         sta p1frozen
         jmp killp1routine

;Kill player 2
killplayer2
		 lda #1 
		 sta player2dead
		 
         lda #0
         sta ballxpos
         sta ballypos
         jsr explodesfx
	
         lda #1
         sta p2joyup+1
         lda #2
         sta p2joydown+1
         lda defaultbatspd
         sta batspeed2
         lda #0
         sta p2frozen
         jmp killp2routine

;Main kill player 1 routine
killp1routine
         lda #$00
         sta explodepointer
         sta explodedelay
		 lda #7
		 sta $d027
killloop1
         jsr synctimer
		 jsr testplayer2
		 jsr collision
         lda explodedelay
         cmp #4
         beq exp1ready
         inc explodedelay

         jmp killloop1
exp1ready
         lda #$00
         sta explodedelay

         ldx explodepointer
         lda explodetable,x
         sta $07f8
         inx
         cpx #expend-explodetable
         beq stopexp1
         inc explodepointer
         jmp killloop1
stopexp1
         lda #$80
         sta $07f8
         jsr resetball
         lda defaultbatspd
         sta batspeed1
		 lda #shieldcount
		 sta p1shieldtime
		 lda #0
		 sta player1dead
         jmp p2scores

;Do the same to kill off player 2

killp2routine
         lda #$00
         sta explodedelay
         sta explodepointer
		 lda #7
		 sta $d028
killloop2
         jsr synctimer
		 jsr testplayer1
         lda explodedelay
         cmp #4
         beq expok2
         inc explodedelay
         jmp killloop2
expok2   lda #$00
         sta explodedelay
         ldx explodepointer
         lda explodetable,x
         sta $07f9
         inx
         cpx #expend-explodetable
         beq stopexp2
         inc explodepointer
         jmp killloop2
stopexp2 lda #$80
         sta $07f9
         jsr resetball
         lda defaultbatspd
         sta batspeed2
		 lda #shieldcount
		 sta p2shieldtime
		 lda #0
		 sta player2dead
         jmp p1scores

;Reset the ball, and spawn it via the
;spawner and default all features.

resetball

;This timer is used to disable the ball 
;collision with the alien when spawned
;ball for 1 second. 
	
		 lda #60 
		 sta waitball 
		 
         jsr startsfx

         lda alienxpos
         sta ballxpos
         lda alienypos
         sta ballypos
         lda defaultballsy
         sta ballspeedx
         lda defaultballsx
         sta ballspeedy
         sta targetvely
         lda #$00
         sta hits
         lda #1
         sta p1joyup+1
         sta p2joyup+1
         lda #2
         sta p1joydown+1
         sta p2joydown+1
         rts

;Ball hitcount

addhit
         inc hits
         lda hits
         cmp #10
         beq speedit
         rts
speedit  lda #$00
         sta hits
		 lda ballspeedx
		 beq justtarg
         inc ballspeedx
         inc ballspeedy
justtarg		 
         inc targetvely
         rts

;Player 1 scores. Add point to player 1
;score.

p1scores lda scorep1+1 ;Units
         cmp #9
         beq tensp1
         inc scorep1+1
         jsr checkp1score
         jmp updatep1scoreu

tensp1   lda #0
         sta scorep1+1
         inc scorep1

         jsr checkp1score
         jsr updatep1scoreu
         jmp updatep1scoret

         ;Check if score limit has
         ;been reached.

checkp1score
         ldx #$00
chksc1   lda scorep1,x
         cmp scorelimit,x
         bne skip
         inx
         cpx #$02
         bne chksc1

         jsr updatep1scoreu
         jsr updatep1scoret
         jmp player1wins
skip     rts

checkp2score
         ldx #$00
chksc2   lda scorep2,x
         cmp scorelimit,x
         bne skip2
         inx
         cpx #$02
         bne chksc2

         jsr updatep2scoreu
         jsr updatep2scoret
         jmp player2wins
skip2    rts

;Player 2 scores. Add point to playr 2
;score

p2scores lda scorep2+1
         cmp #9
         beq tensp2
         inc scorep2+1
         jsr checkp2score
         jmp updatep2scoreu

tensp2   lda #0
         sta scorep2+1
         inc scorep2

         jsr checkp2score
         jsr updatep2scoreu
         jmp updatep2scoret

;Update score

initscore 
		 jsr updatep1scoret
         jsr updatep1scoreu
         jsr updatep2scoret
         jmp updatep2scoreu

;Update score for player 1 (digit TENS)

updatep1scoret
         ldx scorep1
         lda scoretbl1,x
         sta p1scorebit1a
         lda scoretbl2,x
         sta p1scorebit1b
         lda scoretbl3,x
         sta p1scorebit1c
         lda scoretbl4,x
         sta p1scorebit1d
         rts

;Update score for player 1 (digit UNITS)

updatep1scoreu
         ldx scorep1+1
         lda scoretbl1,x
         sta p1scorebit2a
         lda scoretbl2,x
         sta p1scorebit2b
         lda scoretbl3,x
         sta p1scorebit2c
         lda scoretbl4,x
         sta p1scorebit2d
         rts

;Update score for player 2 (digit TENS)

updatep2scoret
         ldx scorep2
         lda scoretbl1,x
         sta p2scorebit1a
         lda scoretbl2,x
         sta p2scorebit1b
         lda scoretbl3,x
         sta p2scorebit1c
         lda scoretbl4,x
         sta p2scorebit1d
         rts

;Upate score for player 2 (digit UNITS)

updatep2scoreu
         ldx scorep2+1
         lda scoretbl1,x
         sta p2scorebit2a
         lda scoretbl2,x
         sta p2scorebit2b
         lda scoretbl3,x
         sta p2scorebit2c
         lda scoretbl4,x
         sta p2scorebit2d
         rts

;Player control. Player 2 should be
;played as either a single joystick or
;drone.

playercontrol
		 
         jsr testplayer1
         jmp testplayer2

;Test joystick control for player 1

testplayer1
         lda p1frozen
         cmp #1
         beq playerisfrozen
          
         lda aimode
         cmp #2
         bne p1joymode
         jmp testai2

playerisfrozen 
		 lda #$03
         sta $d027
         rts
p1joymode
		 
;Test joystick movement up
;PLAYER 1
		
p1joyup  lda #1
         bit $dc00
         bne notupp1
p1up     lda #0
         sta player1dir
         lda player1ypos
         sec
p1speed  sbc batspeed1
         cmp #batstopup
         bcs updatepos1
         lda #batstopup
updatepos1
         sta player1ypos
         rts

;Test joystick movement down
;Player 1
		 
p1joydown
notupp1  lda #2
         bit $dc00
         bne notdownp1
         lda #1
         sta player1dir
p1down   lda player1ypos
         clc
p1speed2 adc batspeed1
         cmp #batstopdown
         bcc updatepos1
         lda #batstopdown
         jmp updatepos1
notdownp1
         lda #2
         sta player1dir
         rts

;Test joystick control for player 2

testplayer2
         lda p2frozen
         cmp #$01
         beq p2isfrozen
        
         lda aimode
         beq joystickp2
         cmp #2
         beq joystickp2
         jmp testai
p2isfrozen lda #$03
         sta $d028
         rts
joystickp2

;Test joystick movement up
;PLAYER 2

p2joyup
         lda #1
         bit $dc01
         bne notupp2
aimoveup lda #0
         sta player2dir
         lda player2ypos
         sec
p2speed1 sbc batspeed2
         cmp #batstopup
         bcs updatepos2
         lda #batstopup
updatepos2
         sta player2ypos
         rts
p2joydown

;Test movement joystick movement down 
;PLAYER 2

notupp2  lda #2
         bit $dc01
         bne notdown2

aimovedown
         lda #1
         sta player2dir
         lda player2ypos
         clc
p2speed2 adc batspeed2
         cmp #batstopdown
         bcc updatepos2
         lda #batstopdown
         jmp updatepos2
notdown2 lda #2
         sta player2dir
         rts

;1 player game only, player 1/2 is
;automatically the computer

testai
         lda ballxpos
         cmp #ballrange
         bcc ignoreai
         lda player2ypos;Bat 2 Y position
         cmp ballypos   ;Ball Y position
         bcc aimovedown
         bcs aimoveup
ignoreai
         rts

testai2  lda ballxpos
         cmp #ballrange2
         bcs ignoreai
         lda player1ypos
         cmp ballypos
         bcc testp1down
         bcs testp1up
         rts
testp1down jmp p1down
testp1up jmp p1up

;Sprite to sprite - software collision

collision

	;Setup box collision co-ordinates
	;for the ball 
	
         lda ballxpos ;Ball object
         sec
         sbc #collleft
         sta collider
         clc
         adc #collright
         sta collider+1
         lda ballypos
         sec
         sbc #collup
         sta collider+2
         clc
         adc #colldown
         sta collider+3
		 
	;Also setup box collision co
	;-ordinates for the power up
	
         lda powerupxpos
         sec
         sbc #powcolleft
         sta collider2
         clc
         adc #powcollright
         sta collider2+1
         lda powerupypos
         sec
         sbc #powcollup
         sta collider2+2
         clc
         adc #powcolldown
         sta collider2+3

         jsr testcolp1
         jsr testcolp2
         jmp testcolal

         ;Test player 1 to ball or
         ;power up collision
		 
testcolp1
		 ;Player 1 death = 0 = collision
		 lda player1dead 
		 beq collcheck01
		 rts 
		 
collcheck01
         jsr testpowcol1

		 lda balldirx
		 bne ballnothit1
         lda player1xpos
         cmp collider
         bcc ballnothit1
         cmp collider+1
         bcs ballnothit1
		 
         lda player1ypos
         cmp collider+2
         bcc ballnothit1
         cmp collider+3
         bcs ballnothit1

         jsr ball1sfx

         lda player1dir
         beq bdirup1

         lda player1dir
         cmp #2
         beq diridle1

         lda #$01
         sta balldiry
         lda targetvely
         sta ballspeedy
         jmp reboundballx

bdirup1  lda #$00
         sta balldiry
         lda targetvely
         sta ballspeedy
         jmp reboundballx

		 ;The player is idle, so ball 
		 ;can only move straight
		 
diridle1 lda #$00
         sta ballspeedy ;Straight
		 
         jmp reboundballx
		 
ballnothit1
         rts

		;Test collision with player 2
		;and ball or power up. 
		;Note: No collision if player is 
		;already dead.

testcolp2 
		 lda player2dead 
		 beq collcheck02
		 rts 
collcheck02
		 jsr testpowcol2

		 ;Prevent the ball being hit 
		 ;if going opposite direction 
		 ;to the player. 
		 
		 lda balldirx
		 beq ballnothit1
		 
         lda player2xpos
         cmp collider
         bcc ballnothit2
         cmp collider+1
         bcs ballnothit2
		 
         lda player2ypos
         cmp collider+2
         bcc ballnothit2
         cmp collider+3
         bcs ballnothit2

         jsr ball1sfx

         lda player2dir
         beq bdirup2
         cmp #$02
         beq diridle1
         lda targetvely
         sta ballspeedy
         lda #$01
         sta balldiry

         jmp reboundballx

bdirup2  lda #$00
         sta balldiry
         lda targetvely
         sta ballspeedy
         jmp reboundballx

		 ;The ball rebounds, add 1 hit 
		 ;to the rebound. After 10 hits 
		 ;the ball should speed up.
		 
reboundballx
         jsr addhit
         lda balldirx
         beq switchtoright
         lda #0
         sta balldirx
         rts
		 
switchtoright
         lda #1
         sta balldirx
ballnothit2
         rts

;Test collision with alien and ball and
;make the ball rebound if hits alien

testcolal
		 
		 ;ballwait pointer must be zero
		 ;before collision can take 
		 ;place with ball on alien 
		 
		 lda waitball
		 bne noalcol1
		 jmp testcolal2
noalcol1 dec waitball
		 jmp noalcol
testcolal2		 
         lda alienxpos
         cmp collider
         bcc noalcol
         cmp collider+1
         bcs noalcol
		 
         lda alienypos
         cmp collider+2
         bcc noalcol
         cmp collider+3
         bcs noalcol
         jsr ball3sfx
		 
		 ;Rebound ball on collision of 
		 ;alien (if set).
		 
         jmp reboundballx
noalcol  rts

;Power up spawning from the alien.

animspawn
         jsr movespawner
         lda spandelay
         cmp #5
         beq spanim
         inc spandelay
         rts
		 
spanim   lda #0
         sta spandelay
         ldx spanptr
         lda spawnanimtbl,x
         sta $07fb
         lda spawnanimcol,x
         sta $d02a
         inx
         cpx #8
         beq loopsanim
         inc spanptr
         rts
		 
loopsanim ldx #$00
         stx spanptr
         rts

    ;Move the alien up or down 
	
movespawner
         lda spawndir
         cmp #1
         beq spawndown
		 
	;Alien moves up until it reaches 
	;the highest point inside the arena 
	
         lda alienypos
         sec
         sbc #1
         cmp #spawnstopup
         bcs spawnupok
         lda #1
         sta spawndir
         rts
spawnupok
         sta alienypos
         rts
		 
	;Alien moves down until it reaches 
	;the lowest point inside the arena 
	
spawndown lda alienypos

         clc
         adc #1
         cmp #spawnstopdown
         bcc spawndownok
         lda #0
         sta spawndir
         rts
spawndownok 
		 sta alienypos
         rts

;Power up spawner test mode

testspawner

		;The power up object can move 
		;even if outside the screen. 
		
         jsr shiftpow
		 
		 ;Power up cannot be visible 
		 ;until the spawn time == 30.
		 
         lda spawntime
         cmp #30
         beq spawnwait2
         inc spawntime
         rts
		 
		 ;Count another 10 to the spawn
		 ;wait before launching a new 
		 ;power up.
		 
spawnwait2
         lda #0
         sta spawntime
         lda spawntime+1
         cmp #10
         beq launchpow
         inc spawntime+1
         rts
		 
		 ;The power up is ready to be 
		 ;launched - only if offset!!
		 
launchpow

         lda powerupypos
         beq oktolaunch
         rts
		 
		 ;Randomly select the power up 
		 ;to be launched. Reset 
		 ;the spawn wait time.
		 
oktolaunch
         jsr pusfx
         jsr selectpowerup
         lda #0
         sta spawntime
         sta spawntime+1
         rts

		;Drag rate for power up (half 
		;of the slow speed).
		
shiftpow lda powermovedelay
         cmp #1
         beq halfspeedset
         inc powermovedelay
         rts
		 
		 ;Okay to move the power up 
		 
halfspeedset lda #$00
         sta powermovedelay
         lda powdir
         cmp #1
         bne totheleft
			
		;Shift power up to the right 
		
         lda powerupxpos
         clc
         adc #1
         cmp #$a8
         bcc notoffset

		;Force power up offset 
		
offset   lda #$00
         sta powerupypos
         rts
notoffset sta powerupxpos
         rts
		 
		 ;Shift power up to the left
		 ;until it leaves the screen at 
		 ;position $02 
		 
totheleft

         lda powerupxpos
         sec
         sbc #1
         cmp #$02
         bcs notoffset
         jmp offset

;Select power up to be launched via
;the game spawner and random check

selectpowerup

         jsr random
         and #$07
         sta powerup
         ldx powerup
         lda powtable,x
         sta $07fc
         lda powcolour,x
         sta $d02b
         jsr random
         and #$01
         sta powdir
		 
		 ;Place new power up onto alien 
         lda alienxpos
         sta powerupxpos
         lda alienypos
         sta powerupypos
         rts

random   lda rand+1
         sta rtemp
         lda rand
         asl a
         rol rtemp
         asl a
         rol rtemp
         clc
         adc rand
         pha
         lda rtemp
         adc rand+1
         pla
         adc #$11
         sta rand
         lda rand+1
         adc #$36
         sta rand+1
         lda rand
         rts

;Test player 1 to power up collision.
;SHIELD should ignore power up 
;collision.

testpowcol1
		 lda p1shieldtime
		 beq powerupcolltest1
		 rts 
powerupcolltest1

         lda player1xpos
         cmp collider2
         bcc nopowerup1
         cmp collider2+1
         bcs nopowerup1
		 
         lda player1ypos
         cmp collider2+2
         bcc nopowerup1
         cmp collider2+3
         bcs nopowerup1
         jsr collectsfx
         lda #0
         sta powerupypos
		 
	;Now check the power up type 
		 
		 ;Slow ball object 
		 
         lda $07fc ;Power up sprite 
         cmp #pslowball
         bne notslowballp1
         jmp slowballdown
		 
nopowerup1 rts

		;Fast ball object 
		
notslowballp1
         cmp #pfastball
         bne notfastballp1
         jmp speedupball

		;Frozen bat power up
		
notfastballp1
         cmp #pfreezebat
         bne notfreezep1
         lda #1
         sta p1frozen
         rts

		;Speed up bat power up
		
notfreezep1
         cmp #pspeedbat
         bne notspeedbatp1
         lda #7
         sta batspeed1
speednomorep1
         rts

		;Slow down bat power up

notspeedbatp1
         cmp #pslowbat
         bne notslowbatp1
         lda #2
         sta batspeed1
         rts

		;Reverse bat power up

notslowbatp1
         cmp #preversebat
         bne notreversep1
         lda #1
         sta p1joydown+1
         lda #2
         sta p1joyup+1
         rts

		;Minus two points power up

notreversep1
         cmp #plose2pts
         bne notlose2ptsp1
         jsr l1p
l1p
         lda scorep1
         beq checkldigitp1
         jmp deductp1

checkldigitp1
         lda scorep1+1
         beq nodeduct1
deductp1
         dec scorep1+1
         lda scorep1+1
         cmp #$ff
         bne nodeduct1
         lda #$09
         sta scorep1+1
         dec scorep1
nodeduct1 jsr updatep1scoret
         jsr updatep1scoreu
         rts

		;Instant death power up 
		
notlose2ptsp1
         cmp #pdeath
         bne notdeathp1
         jmp killplayer1
notdeathp1 rts


;Test player 2 to power up collision
;unless player 2 is SHIELD mode.

testpowcol2
		 lda p2shieldtime
		 beq powerupok2 
		 rts 
		 
powerupok2
         lda player2xpos
         cmp collider2
         bcc nopowerup2
         cmp collider2+1
         bcs nopowerup2
		 
         lda player2ypos
         cmp collider2+2
         bcc nopowerup2
         cmp collider2+3
         bcs nopowerup2
         jsr collectsfx

		 ;Power up picked up
		 
         lda #0
         sta powerupypos
		 
		 ;Slow ball power up
		 
         lda $07fc
         cmp #pslowball
         bne notslowballp2
         jmp slowballdown
		 
nopowerup2 rts

		 ;Fast ball power up
notslowballp2
         cmp #pfastball
         bne notfastballp2
         jmp speedballup
		 
		 ;Freeze bat power up
notfastballp2
         cmp #pfreezebat
         bne notfreezep2
         lda #1
         sta p2frozen
         rts
		 
		 ;Speed bat power up
		 
notfreezep2
         cmp #pspeedbat
         bne notspeedbatp2
         lda #7
         sta batspeed2
         rts
		 
		 ;Slow bat power up
		 
notspeedbatp2
         cmp #pslowbat
         bne notslowbatp2
         lda #2
         sta batspeed2
         rts
		 
		 ;Reverse bat power up
		 
notslowbatp2
         cmp #preversebat
         bne notreversep2
         lda #1
         sta p2joydown+1
         lda #2
         sta p2joyup+1
         rts
		 
		 ;Minus two points power up
		 
notreversep2
         cmp #plose2pts
         bne notlose2ptsp2
         jsr l2p
         jmp l2p
l2p
         lda scorep2
         beq checkd2zerop2
         jmp deductp2
checkd2zerop2
         lda scorep2+1
         beq nodeductp2
deductp2
         dec scorep2+1
         lda scorep2+1
         cmp #$ff
         bne nodeductp2
         lda #$39
         sta scorep2+1
         dec scorep2
nodeductp2 jsr updatep2scoret
         jsr updatep2scoreu
         rts

		;Instant death power up
		
notlose2ptsp2
         cmp #pdeath
         bne notdeath4p2
         jmp killplayer2
notdeath4p2 rts

;The ball speed is increased by the 
;power up.

speedupball
speedballup 
		 inc ballspeedx
		 lda ballspeedy
		 
		 ;We don't want to change Y 
		 ;position if player that hit 
		 ;ball is idle. So we skip 
		 ;incrementing the ball speed 
		 ;and only increment the target 
		 ;velocity pointer.
		 
		 beq noanglespeed1
         inc ballspeedy
noanglespeed1		 
         inc targetvely
         rts
		 
;The ball is slowed down by the power 
;up. 

slowballdown
         lda ballspeedx
         cmp #1
         beq noslowdown
         dec ballspeedx
		 
		 ;We don't want to change Y 
		 ;position if player that hit 
		 ;ball is idle. So we skip 
		 ;incrementing the ball speed 
		 ;and only decrement the target 
		 ;velocity pointer.
		 
		 lda ballspeedy
		 beq noanglespeed2
         dec targetvely
noanglespeed2
         dec ballspeedy
noslowdown
         rts

;The game is over, display the sprite
;on screen indicating which player has
;won the match

player1wins
         jsr clearsprites
         lda #p1winsspr
         sta $07f8
         lda #$56
         sta winspritexpos
         lda #$88
         sta winspriteypos
         lda #1
         sta $d027
         jmp gameover
player2wins
         jsr clearsprites
         lda #p2winsspr
         sta $07f8
         lda #$56
         sta winspritexpos
         lda #$00
         sta winspriteypos
         lda #1
         sta $d027
         jmp gameover

;Tidy up ... Remove all sprites before 
;changing sprite frames to game over 
;scene. 

clearsprites
         ldx #$00
zsprs    lda #$00
         sta softsprpos,x
         sta $d000,x
         inx
         cpx #$10
         bne zsprs
         rts

;Game over loop ... Basically allow the
;animation of the background to
;continue. Also wait for the fire
;button on any port pressed

gameover lda #0
         sta firebutton
         lda #1
         sta $d015
         lda #0
         sta $d01c
         jsr gosfx

gameoverloop
         lda #0
         sta rt
         cmp rt
         beq *-3
         jsr expandmsb
         jsr bganim
         jsr droptomiddle
         lda $dc00
         lsr a
         lsr a
         lsr a
         lsr a
         lsr a
         bit firebutton
         ror firebutton
         bmi gameoverloop2
         bvc gameoverloop2
         jmp title
gameoverloop2
         lda $dc01
         lsr a
         lsr a
         lsr a
         lsr a
         lsr a
         bit firebutton
         ror firebutton
         bmi gameoverloop
         bvc gameoverloop
         jmp title

droptomiddle lda winspriteypos
         clc
         adc #4
         cmp #$88
         bcc storo1
         lda #$88
storo1   sta winspriteypos
         rts
		 
;Custom sound effects pointers for 
;making sound effects. 

		;Start game / ball launch sfx
startsfx
         lda #0
         sta sfxtype
         jmp initsfx
		 
		 ;Ball rebound with bat sfx
		 
ball1sfx lda #1
         sta sfxtype
         jmp initsfx
		 
		 ;Ball bounce off wall sfx 
		 
ball2sfx lda #2
         sta sfxtype
         jmp initsfx
		 
		 ;Player explosion (drum) sfx
		 
explodesfx lda #3
         sta sfxtype
         jmp initsfx

		 ;Power up launched sfx
pusfx
         lda #4
         sta sfxtype
         jmp initsfx
		 
		 ;Game over/Player win sfx
		 
gosfx    lda #5
         sta sfxtype
         jmp initsfx
		 
		 ;Ball rebound from alien sfx
		 
ball3sfx lda #6
         sta sfxtype
         jmp initsfx
		
		;Power up collected sfx 
		
collectsfx
         lda #7
         sta sfxtype

		;Initialise sound effects loop
initsfx
         ldx sfxtype
         lda wavlotb,x
         sta wav+1
         lda wavhitb,x
         sta wav+2
         lda freqtblo,x
         sta freq+1
         lda freqtbhi,x
         sta freq+2
         lda #$00
         sta soundpointer
         rts

		;The main SFX player loop 
		;The sounds only use one chanel
sfxplay
         ldx soundpointer
         lda #$0e
         sta 54277
         lda #$ee
         sta 54278
wav      lda startwav,x
         sta 54276
         lda #$88
         sta 54274
         lda #$88
         sta 54275
freq     lda startfreq,x
         sta 54272
         sta 54273
         inx
         cpx #24 ;24 pointers max
         beq stopsound
         inc soundpointer
         rts
stopsound ldx #23
         stx soundpointer
         rts

;Fair shield settings - preventing the 
;player from picking up power ups if 
;the shield time does not = 00

flashshield 
		jsr checkp1shieldstatus
		jsr checkp2shieldstatus
		lda flashshielddelay 
		cmp #2
		beq flashshieldnow
		inc flashshielddelay 
		rts 
flashshieldnow	
		lda #0
		sta flashshielddelay
		ldx flashshieldpointer
		lda p1shieldflashcolour,x
		sta p1shieldcolour
		lda p2shieldflashcolour,x
		sta p2shieldcolour 
		inx 
		cpx #4
		beq resetshieldcolour
		inc flashshieldpointer
		rts
resetshieldcolour 
		ldx #0
		stx flashshieldpointer
		rts
		
checkp1shieldstatus
		lda p1shieldtime
		beq stopflash1
		dec p1shieldtime 
		lda p1shieldcolour
		sta $d027
		rts 
stopflash1
		lda #$0e 
		sta $d027 
		rts 
		
checkp2shieldstatus 
		lda p2shieldtime 
		beq stopflash2 
		dec p2shieldtime 
		lda p2shieldcolour 
		sta $d028 
		rts 
stopflash2 
		lda #$0a 
		sta $d028 
		rts


;---------------------------------------
;Game pointers

rt       .byte 0 ;Raster timer
system   .byte 0 ;PAL/NTSC pointer
ntsctimer .byte 0 ;NTSC delay timer 
firebutton .byte 0 ;Fire control
soundoption .byte 0;0=music 1=sfx
sfxtype  .byte 0 ;Sound effects value
voidtype .byte 0 ;Void char value 
voidcolourstore .byte 0 ;Void colour
fieldreadpointer  .byte 0 ;Row pointer

waitball .byte 0 ;Collider ball wait

;--------------------------------------
pointers ;Starting label for init at 
		 ;start of new game

;Player death trigger 0 = off / 1 = on
player1dead .byte 0 
player2dead .byte 0

;Laser and tile pointers
tiledelay .byte 0
lasdelay .byte 0
tilewaitdelay .byte 0
tiledir  .byte 0

;Scoring

scorep1  .byte 0,0
scorep2  .byte 0,0
explodedelay .byte 0
explodepointer .byte 0


;Ball control
balldirx .byte 0
balldiry .byte 0

;Spawner
spandelay .byte 0
spanptr  .byte 0
spawndir .byte 0

;Power ups
oktospawn .byte 0
spawntime .byte 0,0
powerup  .byte 0
powermovedelay .byte 0
powdir   .byte 0

;Sound
soundpointer .byte 0

pointersend

;Random values for random routine 

rand     .byte %10010101,%01001011
rtemp    .byte 0

;Game options
           ;Scoring to win
scorelimit .byte $01,$00 ;Tens+Units

           ;Default ball speed
defaultballsx .byte $01
defaultballsy .byte $01

           ;Default bat speed
defaultbatspd .byte 4

           ;Number of players 1/2
           ;2 players: aimode = 0
           ;Player 2:  aimode = 1
           ;Player 1:  aimode = 3
aimode   .byte 1

;Sprite settings
objpos   .byte 0,0,0,0,0,0,0,0
         .byte 0,0,0,0,0,0,0,0
collider .byte 0,0,0,0
collider2 .byte 0,0,0,0
;--------------------------------------
;Ball control
ballspeedx .byte 1
ballspeedy .byte 1

;Hidden Y speed for ball Y position 
targetvely .byte 2

;Number of hits the ball take on 
;impact before speed up
hits     .byte 0
;--------------------------------------
;Player speed
batspeed1 .byte 0 
batspeed2 .byte 0
;Player Y direction
player1dir .byte 0
player2dir .byte 0
;Player frozen check 0 = off / 1 = on
p1frozen .byte 0
p2frozen .byte 0
;Flashing shield timers and colour
p1shieldtime .byte 0
p2shieldtime .byte 0
p1shieldcolour .byte 0
p2shieldcolour .byte 0
flashshielddelay .byte 0
flashshieldpointer .byte 0

;Scoring characters (They are character 
;values for each of the 10 digits)

scoretbl1 .byte $47,$49,$4c,$4e,$50
         .byte $52,$54,$56,$58,$6d
scoretbend .byte 0

scoretbl2 .byte $48,$4a,$4d,$4f,$51
         .byte $53,$55,$57,$59,$6e

scoretbl3 .byte $5a,$5c,$5f,$61,$63
         .byte $65,$67,$69,$6b,$80

scoretbl4 .byte $5b,$5d,$60,$62,$64
         .byte $66,$68,$6a,$6c,$81

;Selfmod - sprite animation frames

bat      .byte $80
ball     .byte $81
spawner  .byte $8c
powerupobj .byte $8d

;Explosion animation frame 

explodetable .byte $82,$83,$84,$85,$86
         .byte $87,$88,$97,$97,$97,$97
         .byte $97,$97,$97,$97,$97,$97
expend

;Alien animation table and colour

spawnanimtbl
         .byte $89,$8a,$8b,$8c
         .byte $89,$8a,$8b,$8c
spawnanimcol
         .byte $04,$0e,$03,$0d
         .byte $07,$0d,$03,$0e
spawnend

;Power up sprite types and colour

powtable
         .byte pslowball  ;Slow ball
         .byte pfastball  ;Fast ball
         .byte pfreezebat ;Stop bat
         .byte pspeedbat  ;Speed bat
         .byte pslowbat   ;Slow bat
         .byte preversebat;Reverse bat
         .byte plose2pts  ;Deduct 2pts
         .byte pdeath     ;Instant death
powcolour
         .byte $0a        ;Light red
         .byte $0d        ;Light greeb
         .byte $03        ;Cyan
         .byte $05        ;Green
         .byte $08        ;Orange
         .byte $0c        ;Medium grey
         .byte $04        ;Purple
         .byte $02        ;Red
;---------------------------------------
;Sound effects

         ;Game start / ball spawn

startwav .byte $41,$41,$41,$41,$41,$41
         .byte $41,$41,$41,$41,$41,$41
         .byte $41,$41,$41,$41,$41,$41
         .byte $41,$41,$41,$41,$00,$00
startfreq
         .byte $22,$22,$22,$22,$22,$22
         .byte $28,$2a,$2c,$2e,$30,$32
         .byte $34,$36,$38,$3a,$3c,$3e
         .byte $40,$42,$44,$46,$00,$00

         ;Ball hit bat
ballwav  .byte $21,$21,$21,$21,$11,$11
         .byte $11,$11,$11,$11,$11,$11
         .byte $11,$11,$11,$11,$11,$11
         .byte $11,$11,$11,$11,$00,$00
ballfreq
         .byte $22,$42,$22,$42,$22,$42
         .byte $22,$42,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00

         ;Ball hit wall
ball2wav .byte $81,$81,$11,$11,$00,$00
         .byte $11,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00

ball2freq .byte $81,$81,$22,$22,$00,$00
         .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00

         ;Bat explode
		 
batexpwav .byte $81,$41,$41,$41,$41,$41
         .byte $81,$81,$81,$81,$81,$81
         .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00
batexpfreq
         .byte $81,$0c,$0a,$08,$04,$02
         .byte $df,$df,$df,$df,$df,$df
         .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00

         ;Pickup spawned
		 
puwav    .byte $41,$41,$41,$41,$41,$41
         .byte $41,$41,$41,$41,$41,$41
         .byte $41,$41,$41,$41,$41,$41
         .byte $00,$00,$00,$00,$00,$00
pufreq   .byte $70,$60,$50,$40,$30,$20
         .byte $20,$10,$20,$40,$60,$70
         .byte $00,$00,$00,$00,$00,$00

         ;Game over
		 
gowav    .byte $41,$41,$41,$41,$41,$41
         .byte $41,$41,$41,$41,$41,$41
         .byte $41,$41,$41,$41,$41,$41
         .byte $41,$41,$41,$41,$41,$00
gofreq   .byte $18,$18,$18,$18,$14,$14
         .byte $14,$14,$10,$10,$10,$10
         .byte $0c,$0c,$0c,$0c,$08,$08
         .byte $08,$08,$04,$00,$00,$00

         ;Ball on alien spawner

ball3wav .byte $51,$51,$51,$51,$51,$51
         .byte $51,$51,$51,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00

ball3freq
         .byte $02,$03,$04,$05,$06,$07
         .byte $08,$09,$0a,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00

		 ;Power up picked up

collectwav
         .byte $21,$21,$21,$21,$21,$21
         .byte $21,$21,$21,$21,$21,$21
         .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00

collectfreq
         .byte $20,$20,$20,$20,$27,$27
         .byte $27,$27,$27,$2c,$2c,$2c
         .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00

		;LO/HI BYTE sound tables for 
		;SFX player 
		
wavlotb  .byte <startwav
         .byte <ballwav
         .byte <ball2wav
         .byte <batexpwav
         .byte <puwav
         .byte <gowav
         .byte <ball3wav
         .byte <collectwav

wavhitb  .byte >startwav
         .byte >ballwav
         .byte >ball2wav
         .byte >batexpwav
         .byte >puwav
         .byte >gowav
         .byte >ball3wav
         .byte >collectwav

freqtblo .byte <startfreq
         .byte <ballfreq
         .byte <ball2freq
         .byte <batexpfreq
         .byte <pufreq
         .byte <gofreq
         .byte <ball3freq
         .byte <collectfreq

freqtbhi .byte >startfreq
         .byte >ballfreq
         .byte >ball2freq
         .byte >batexpfreq
         .byte >pufreq
         .byte >gofreq
         .byte >ball3freq
         .byte >collectfreq
		 
;Scrolling void charsets LO/HI byte 
;values

voidtopleftlo
		.byte <voidchar1a
		.byte <voidchar2a
		.byte <voidchar3a
		.byte <voidchar4a 
		.byte <voidchar5a 
		.byte <voidchar6a 
		.byte <voidchar7a 
		.byte <voidchar8a 
voidtoplefthi
		.byte >voidchar1a 
		.byte >voidchar2a
		.byte >voidchar3a
		.byte >voidchar4a 
		.byte >voidchar5a 
		.byte >voidchar6a 
		.byte >voidchar7a 
		.byte >voidchar8a 
voidtoprightlo
		.byte <voidchar1b
		.byte <voidchar2b 
		.byte <voidchar3b 
		.byte <voidchar4b 
		.byte <voidchar5b 
		.byte <voidchar6b 
		.byte <voidchar7b 
		.byte <voidchar8b 
voidtoprighthi
		.byte >voidchar1b 
		.byte >voidchar2b 
		.byte >voidchar3b 
		.byte >voidchar4b 
		.byte >voidchar5b 
		.byte >voidchar6b 
		.byte >voidchar7b 
		.byte >voidchar8b
voidbottomleftlo
		.byte <voidchar1c
		.byte <voidchar2c 
		.byte <voidchar3c 
		.byte <voidchar4c 
		.byte <voidchar5c 
		.byte <voidchar6c 
		.byte <voidchar7c 
		.byte <voidchar8c 
voidbottomlefthi
		.byte >voidchar1c 
		.byte >voidchar2c 
		.byte >voidchar3c 
		.byte >voidchar4c 
		.byte >voidchar5c
		.byte >voidchar6c
		.byte >voidchar7c 
		.byte >voidchar8c 
voidbottomrightlo
		.byte <voidchar1d
		.byte <voidchar2d
		.byte <voidchar3d
		.byte <voidchar4d
		.byte <voidchar5d 
		.byte <voidchar6d 
		.byte <voidchar7d 
		.byte <voidchar8d 
voidbottomrighthi
		.byte >voidchar1d 
		.byte >voidchar2d 
		.byte >voidchar3d 
		.byte >voidchar4d 
		.byte >voidchar5d 
		.byte >voidchar6d 
		.byte >voidchar7d 
		.byte >voidchar8d
		
;Scrolling void colour table 
		
voidcolour
		.byte $02,$06,$04,$05
		.byte $02,$06,$04,$05
		
;Player shield flash colours

p1shieldflashcolour
		.byte $06,$0e,$03,$0e
p2shieldflashcolour
		.byte $02,$0a,$07,$0a
		
;Game screen colour positio lo byte and 
;hi byte settings 

rowtblo
		.byte <fieldrow1
		.byte <fieldrow2
		.byte <fieldrow3
		.byte <fieldrow4
		.byte <fieldrow5
		.byte <fieldrow6
		.byte <fieldrow7 
		.byte <fieldrow8
		.byte <fieldrow9
		.byte <fieldrow10
		.byte <fieldrow11
		.byte <fieldrow12
		.byte <fieldrow13
		.byte <fieldrow14
		.byte <fieldrow15
		.byte <fieldrow16
		.byte <fieldrow17
		.byte <fieldrow18
		.byte <fieldrow19
		.byte <fieldrow20
		.byte <fieldrow21
		.byte <fieldrow22
		.byte <fieldrow23 

rowtblhi

		.byte >fieldrow1
		.byte >fieldrow2
		.byte >fieldrow3
		.byte >fieldrow4 
		.byte >fieldrow5
		.byte >fieldrow6 
		.byte >fieldrow7
		.byte >fieldrow8
		.byte >fieldrow9
		.byte >fieldrow10 
		.byte >fieldrow11 
		.byte >fieldrow12 
		.byte >fieldrow13
		.byte >fieldrow14
		.byte >fieldrow15 
		.byte >fieldrow16
		.byte >fieldrow17
		.byte >fieldrow18 
		.byte >fieldrow19 
		.byte >fieldrow20 
		.byte >fieldrow21 
		.byte >fieldrow22 
		.byte >fieldrow23

;END OF GAME CODE