;***************************************
;*                                     *
;*            Poing Ultra              *
;*    Written by Richard Bayliss       *
;*   For RETRO PROGRAMMERS INSIDE      *
;*          PONG Challenge             *
;*                                     *
;*     (C) 2022 The New Dimension      *
;*                                     *
;***************************************

;Colour RAM and VIDEO RAM data memory 
;for the Koala Paint picture linker 

koacol1 = $3f40 
koacol2 = $4328

;Screen and colour RAM BANK #3 

scrn = $0400
col = $d800

;Loading picture + music linker

		;BASIC SYS Header
		*= $0801 
		.byte $0b,$08,$e6,$07,$9e
		.byte $32,$30,$36,$31,$00
		
		*= $080d
		sei
		jmp main

;PAL/NTSC video check. Based on raster 
;position.

pncheck	lda $d012
		cmp $d012 
		beq *-3
		bmi pncheck
		cmp #$20
		bcc ntsct
		lda #1
		sta system
		rts
ntsct	lda #0
		sta system 
		rts

;Main setup
		
main	jsr pncheck 
		lda #$0b
		sta $d011
		lda #$00
		sta $d020
		sta $d021
		lda #$18
		sta $d016
		sta $d018
		lda #$03
		sta $dd00
		
;Draw the koala paint pic 
		
		ldx #$00
drawpic lda koacol1,x
		sta scrn,x
		lda koacol1+$100,x
		sta scrn+$100,x
		lda koacol1+$200,x
		sta scrn+$200,x
		lda koacol1+$2e8,x 
		sta scrn+$2e8,x
		lda koacol2,x
		sta col,x
		lda koacol2+$100,x
		sta col+$100,x
		lda koacol2+$200,x
		sta col+$200,x
		lda koacol2+$2e8,x 
		sta col+$2e8,x 
		inx 
		bne drawpic 
		
		lda #$08
		jsr $ffd2
		lda #$fb
		sta $0328
		ldx #<irq
		ldy #>irq
		lda #$7f
		stx $0314
		sty $0315
		sta $dc0d 
		sta $dd0d 
		lda #$2e
		sta $d012 
		lda #$3b
		sta $d011 
		lda #$01
		sta $d019
		sta $d01a 
		lda #$00
		jsr $1000
		cli
loop		
		lda #16
		bit $dc00
		bne space
		jmp exitpic
space	lda #16
		bit $dc01 
		bne loop
		jmp exitpic 
		
irq		asl $d019
		lda $dc0d 
		sta $dd0d
		lda #$fa
		sta $d012
		jsr pnplayer
		jmp $ea7e
		
pnplayer
		lda system
		cmp #1
		beq palm
		inc ntsctimer
		lda ntsctimer
		cmp #$06
		beq resetntsc
palm	jsr $1003
		rts
resetntsc
		lda #0
		sta ntsctimer
		rts 
		
exitpic sei 
		ldx #$31
		ldy #$ea 
		lda #$81
		stx $0314
		sty $0315
		sta $dc0d 
		sta $dd0d 
		lda #$00
		sta $d019 
		sta $d01a 
		ldx #$00
silence lda #$00
		sta $d400,x
		inx 
		cpx #$28 
		bne silence
		ldx #$00
blackout 
		lda #$00
		sta $d800,x 
		sta $d900,x 
		sta $da00,x 
		sta $dae8,x 
		lda mctransfer,x
		sta $0400,x
		inx 
		bne blackout 
		lda #$00
		sta $0800
		lda #$08
		sta $d016
		lda #$14
		sta $d018
		lda #$1b
		sta $d011
		cli
		jmp $0400
		
mctransfer
		sei 
		lda #$34
		sta $01
reloc1  ldx #$00
reloc2	lda $4800,x
		sta $0801,x 
		inx 
		bne reloc2 
		inc $0409
		inc $040c
		lda $0409
		bne reloc1 
		lda #$37
		sta $01
		cli
		jsr $a659
		jmp $a7ae
		
		;Import loading/intro music
		* = $1000
		.binary "c64/intromusic.prg",2
		
		;Import loading bitmap 
		* = $2000
		.binary "c64/loaderpic.kla",2
		
system  	.byte 0
ntsctimer 	.byte 0

		
	