
;***************************************
;*                                     *
;*            Poing Ultra              *
;*    Written by Richard Bayliss       *
;*   For RETRO PROGRAMMERS INSIDE      *
;*          PONG Challenge             *
;*                                     *
;*     (C) 2022 The New Dimension      *
;*                                     *
;***************************************
;---------------------------------------
; Title screen code
;---------------------------------------
title    sei
         ldx #$31
         ldy #$ea
         lda #$81
         sta $dc0d
         sta $dd0d
         lda #$00
         sta $d019
         sta $d01a
		 sta $d020 
		 sta $d021
         lda #$0b
         sta $d011
         lda #$00
         sta cyclepointer
         sta cycletime
         sta char
         sta case
         sta xpos
		 sta flashpointer
		 sta flashdelay
		
         ;Disable SID chip

         ldx #$00
initsid  lda #$00
         sta $d400,x
         inx
         cpx #$18
         bne initsid
		 
		 ;Clear whole screen and fill
         ;colour RAM

         ldx #$00
wipescrn lda #$20
         sta $0400,x
         sta $0500,x
         sta $0600,x
         sta $06e8,x
         lda #$06
         sta $d800,x
         sta $d900,x
         sta $da00,x
         sta $dae8,x
         inx
         bne wipescrn
		
		 ;Small delay routine 
		 ldx #$00
delayrt1 ldy #$00
delayrt2 iny 
		 bne delayrt2
		 inx 
		 bne delayrt1
		 lda #0
		 sta firebutton
		 ;Reset title screen scroll text 
         lda #<scrolltext
         sta messread+1
         lda #>scrolltext
         sta messread+2

         ldx #$00
putopttxt
         lda optiontxt,x
         sta scrn+(11*40),x
         lda optiontxt+(1*40),x
         sta scrn+(13*40),x
         lda optiontxt+(2*40),x
         sta scrn+(14*40),x
         lda optiontxt+(3*40),x
         sta scrn+(15*40),x
         lda optiontxt+(4*40),x
         sta scrn+(16*40),x
         inx
         cpx #40
         bne putopttxt

         ;Draw logo to main screen

         ldx #$00
logscrn1 lda logocol1,x
         sta bmpscrn,x
         lda logocol1+(1*40),x
         sta bmpscrn+(1*40),x
         lda logocol1+(2*40),x
         sta bmpscrn+(2*40),x
         lda logocol1+(3*40),x
         sta bmpscrn+(3*40),x
         lda logocol1+(4*40),x
         sta bmpscrn+(4*40),x
         lda logocol1+(5*40),x
         sta bmpscrn+(5*40),x
         lda logocol1+(6*40),x
         sta bmpscrn+(6*40),x
         lda logocol1+(7*40),x
         sta bmpscrn+(7*40),x
         lda logocol1+(8*40),x
         sta bmpscrn+(8*40),x
         inx
         cpx #$40
         bne logscrn1

         ldx #$00
logscrn2 lda logocol2,x
         sta $d800,x
         lda logocol2+(1*40),x
         sta $d800+(1*40),x
         lda logocol2+(2*40),x
         sta $d800+(2*40),x
         lda logocol2+(3*40),x
         sta $d800+(3*40),x
         lda logocol2+(4*40),x
         sta $d800+(4*40),x
         lda logocol2+(5*40),x
         sta $d800+(5*40),x
         lda logocol2+(6*40),x
         sta $d800+(6*40),x
         lda logocol2+(7*40),x
         sta $d800+(7*40),x
         lda logocol2+(8*40),x
         sta $d800+(8*40),x
         inx
         cpx #40
         bne logscrn2

         ldx #$00
putoptiontext

         lda #$1b
         sta $d011

         lda #1
         sta $d015
         lda #1
         sta $d01c
         lda #$ac
         sta $d000
         lda #$ba
         sta $d001
		 sta $d003
         lda #$00
         sta $d010
         lda #$09
         sta $d025
         lda #$01
         sta $d026
		 
         lda #$98
         sta $07f8
         lda #$07
         sta $d027
		 lda #0
		 sta $d028 
		 
		 ldx #$00
getcptext 
		 lda cptext,x
		 jsr converttxt
		 sta scrn+800,x 
		 inx 
		 cpx #40 
		 bne getcptext 
		 
		 ldx #$fb 
		 txs
		 
;Setup the IRQ raster interrupts for
;the title screen

         ldx #<tirq1
         ldy #>tirq1
         lda #$7f
         stx $0314
         sty $0315
         sta $dc0d
         sta $dd0d
         lda #$22
         sta $d012
         lda #$1b
         sta $d011
         lda #$01
         sta $d019
         sta $d01a
         lda #$00
         jsr music2init
         cli
         jmp titleloop

;The main IRQ raster interrupt player
;for the title screen.

tirq1 ;IRQ 1 the scrolling text

         asl $d019
         lda $dc0d
         sta $dd0d
         lda #$30
         sta $d012
         lda #$01
         sta $d020
         sta $d021
         ldx #$06
         dex
         bne *-1
         lda #$03
         sta $dd00
         lda #$12
         sta $d018
         lda xpos
         sta $d016
         lda #$1b
         sta $d011
         lda #$00
         sta $d020
         sta $d021
       
         ldx #<tirq2
         ldy #>tirq2
         stx $0314
         sty $0315
         jmp $ea81

tirq2 ;IRQ 2 the logo displayer

         asl $d019
         lda #$79
         sta $d012
         ldx #$02
         dex
         bne *-1
         lda #$01
         sta $d020
         sta $d021
         ldx #$0a
         dex
         bne *-1
         lda #$00
         sta $d020
         sta $d021
         lda #$18
         sta $d018
         lda #$18
         sta $d016
         lda #$3b
         sta $d011
         lda #$02
         sta $dd00
         ldx #<tirq3
         ldy #>tirq3
         stx $0314
         sty $0315
         jmp $ea81

tirq3 ;IRQ 3 the still text

         asl $d019
         lda #$e4
         sta $d012
         nop
         nop
		 nop
         nop
         lda #$01
         sta $d020
         sta $d021
         ldx #$09
         dex
         bne *-1
		 nop
		 nop
		 nop
         lda #$06
         sta $d020
         sta $d021
         lda #$1a
         sta $d018
         lda #$1b
         sta $d011
         lda #$03
         sta $dd00
         lda #$08
         sta $d016
		 lda #1
         sta rt
         jsr titlepn
         ldx #<tirq1
         ldy #>tirq1
         stx $0314
         sty $0315
         jmp $ea31

;Title music PAL/NTSC speed check

titlepn  lda system
         cmp #1
         beq palt
         inc ntsctimer
         lda ntsctimer
         cmp #6
         beq resetntsct
palt     jsr music2play
         rts

resetntsct
         lda #$00
         sta ntsctimer
         rts

;Main title screen loop

titleloop lda #0
         sta rt
         cmp rt
         beq *-3
         jsr cycle
         jsr scroller
         jsr flasher
         jsr keyinput
         lda $dc00
         lsr a
         lsr a
         lsr a
         lsr a
         lsr a
         bit firebutton
         ror firebutton
         bmi j1nofire
         bvc j1nofire
         jmp gamestart
j1nofire lda $dc01
         lsr a
         lsr a
         lsr a
         lsr a
         lsr a
         bit firebutton
         ror firebutton
         bmi j2nofire
         bvc j2nofire
         jmp gamestart

j2nofire
         jmp titleloop

;Title screen object cycle routine

cycle    inc cycletime
         lda cycletime
         beq selectnext
         rts
selectnext
         ldx cyclepointer
         lda lineslo,x
         sta linesm+1
         lda lineshi,x
         sta linesm+2
         lda sprites,x
         sta $07f8
         lda colours,x
         sta $d027
         inx
         cpx #11
         beq resetcycle
         inc cyclepointer
         jmp putinplace
resetcycle
         ldx #$00
         stx cyclepointer
putinplace
         ldx #$00
linesm   lda line1,x
         sta scrn+800,x
         inx
         cpx #40
         bne linesm
skipt1   rts

;Title screen 2x2 scrolltext routine

scroller lda xpos
         sec
         sbc #2
         and #$07
         sta xpos
         bcs skipt1
         ldx #$00
shift    lda scrn+(23*40)+1,x
         sta scrn+(23*40),x
		 lda scrn+(24*40)+1,x 
		 sta scrn+(24*40),x
         inx 
		 cpx #$27
         bne shift
messread lda scrolltext
         sta char
         bne store

         lda #<scrolltext
         sta messread+1
         lda #>scrolltext
         sta messread+2
         jmp messread

store    lda case
         cmp #1
         beq upper
         lda #1
         sta case
         lda char
         sta scrn+(23*40)+39
         eor #$80
         sta scrn+(24*40)+39
         rts
upper    lda #0
         sta case
         lda char
         eor #$40
         sta scrn+(23*40)+39
         eor #$80
         sta scrn+(24*40)+39
         inc messread+1
         bne skipt2
         inc messread+2
skipt2   rts

;Title screen colour wash routine

flasher  lda flashdelay
         cmp #1
         beq doflash
         inc flashdelay
         rts
doflash  lda #0
         sta flashdelay
flashmain
         ldx flashpointer
         lda flashtable,x
         sta $d800+(11*40)
         sta $d800+(13*40)+39
         sta $d800+(14*40)
         sta $d800+(15*40)+39
         sta $d800+(16*40)
         sta $d800+(23*40)+39
         sta $d800+(24*40)+39
         inx
         cpx #flashend-flashtable
         beq resetflashtable
         inc flashpointer
         jsr washcols
         rts
resetflashtable
         ldx #$00
         stx flashpointer
washcols
         jsr washright
         jmp washleft

washleft
         ldx #39
forward  lda $d800+(11*40),x
         sta $d800+(11*40)+1,x
         lda $d800+(14*40),x
         sta $d800+(14*40)+1,x
         lda $d800+(16*40),x
         sta $d800+(16*40)+1,x
         dex
         bpl forward

washright
         ldx #0
backward lda $d800+(13*40)+1,x
         sta $d800+(13*40),x
         lda $d800+(15*40)+1,x
         sta $d800+(15*40),x
         lda $d800+(17*40)+1,x
         sta $d800+(17*40),x
         lda $d800+(23*40)+1,x
         sta $d800+(23*40),x
         lda $d800+(24*40)+1,x
         sta $d800+(24*40),x
         lda $d800+(24*40)
         sta $d800+800,x
         inx
         cpx #39
         bne backward
         rts

;In game options keyboard input

keyinput jsr highlight
         jsr $ffe4
         cmp #133 ;F1
         beq soundops
         cmp #134 ;F3
         beq playerops
         cmp #135 ;F5
         beq speedops
		 cmp #136 ;F7
		 beq scoreops1
         rts
scoreops1 
		 jmp scoreops
soundops lda soundoption
         cmp #1
         beq setmusic
         lda #1
         sta soundoption
         rts
setmusic lda #0
         sta soundoption
         rts

playerops 
		 inc aimode
		 lda aimode
		 cmp #3
		 beq resetai
		 
		 rts 
resetai  lda #0
		 sta aimode
		 rts
		 

;Game speed options, this should  
;correspond to the bat and ball speed. 

speedops lda speedpointer
         beq setmedium
         cmp #1
         beq seteasy
         rts
		 
		 ;Slow speed, ball slow, 
		 ;X1, Y1, bat normal Y4
seteasy  lda #$00
         sta speedpointer
		 lda #1
		 sta defaultballsx
		 sta defaultballsy
		 sta targetvely
		 lda #4
		 sta defaultbatspd
         rts
setmedium lda #$01
         sta speedpointer
		 
		 lda #2
		 sta defaultballsx
		 sta defaultballsy
		 sta targetvely
		 lda #6
		 sta defaultbatspd
         rts
		 


;Setup the score limit to win the game

scoreops 
		lda scorelimit 
		cmp #$02
		beq limitexpired
		inc scorelimit+1
		lda scorelimit+1
		cmp #$0a 
		bne slok
		lda #$00
		sta scorelimit+1 
		
		
		inc scorelimit
slok		
		rts 
limitexpired
		
		lda scorelimit+1
	
		beq limitexpired2
		inc scorelimit+1
		rts
limitexpired2
		lda #$00
		sta scorelimit 
		lda #$05
		sta scorelimit+1
		rts

;Highlight all the game display options
;(sound, player, game speed, scorelimit)		

highlight jsr displaysndops
         jsr displayplrops
         jsr displayspeedops
		 jmp displayscorelimit

;Display sound option text

displaysndops
         ldx soundoption
         lda sndoplo,x
         sta op1sm+1
         lda sndophi,x
         sta op1sm+2
         jmp showsndop

displayplrops 
		 
         ldx aimode
		 lda plroplo,x 
		 sta op2sm+1
		 lda plrophi,x 
		 sta op2sm+2
		 
         jmp showplrop
		 

displayspeedops
         ldx speedpointer
         lda spdoplo,x
		 sta op3sm+1
		 lda spdophi,x 
		 sta op3sm+2
		 jmp showspdop

showsndop
		 ldx #$00
op1sm    lda sndop1text,x
         jsr converttxt
         sta $062a,x
         inx
         cpx #5
         bne op1sm
         rts
	

showplrop 
		ldx #$00
op2sm   lda plrop1txt,x 
		jsr converttxt
     	sta $0643,x 	
		inx 
		cpx #20
		bne op2sm
        rts
		 
showspdop
		ldx #$00
op3sm	lda spd1txt,x 
		jsr converttxt
		sta $0679,x
		inx 
		cpx #6
		bne op3sm
		rts 
		
;Convert score bytes to number chars		
displayscorelimit
		lda scorelimit
		clc
		adc #$30
		sta $06a5
		lda scorelimit+1
		adc #$30
		sta $06a6
		rts 
		
		

converttxt
         cmp #$3b
         bcc txtok
         sec
         sbc #$40
txtok
         rts

flashdelay .byte 0
flashpointer .byte 0
speedpointer .byte 0

xpos     .byte 0
char     .byte 0
case     .byte 0
cycletime .byte 0
cyclepointer .byte 0

lineslo  .byte <line1,<line2,<line3
         .byte <line4,<line5,<line6
         .byte <line7,<line8,<line9
         .byte <line10,<line11

lineshi  .byte >line1,>line2,>line3
         .byte >line4,>line5,>line6
         .byte >line7,>line8,>line9
         .byte >line10,>line11

sprites  .byte sprite1,sprite2
         .byte sprite3,sprite4
         .byte sprite5,sprite6
         .byte sprite7,sprite8
         .byte sprite9,sprite10
         .byte sprite11

colours  .byte colour1,colour2
         .byte colour3,colour4
         .byte colour5,colour6
         .byte colour7,colour8
         .byte colour9,colour10
         .byte colour11

flashtable
         .byte $06,$0e,$03,$0d,$01
         .byte $0d,$03,$0e
flashend

sndop1text .text "MUSIC"
sndop2text .text "  SFX"
 
plrop1txt 
		  .text "PLAYER 1 VS PLAYER 2"
plrop2txt 
		  .text "PLAYER 1 VS COMPUTER"
plrop3txt 
		  .text "COMPUTER VS PLAYER 2"

spd1txt  .text "  SLOW"
spd2txt  .text "  FAST"
spd3txt  .text "STUPID"

cptext   .text "         2"
		 .text "022 THE NE"
		 .text "W DIMENSIO"
		 .text "N         "

scoreopt .byte $30,$30

sndoplo  .byte <sndop1text
         .byte <sndop2text

sndophi  .byte >sndop1text
         .byte >sndop2text

plroplo  .byte <plrop1txt
         .byte <plrop2txt
         .byte <plrop3txt

plrophi  .byte >plrop1txt
         .byte >plrop2txt
         .byte >plrop3txt

spdoplo  .byte <spd1txt
         .byte <spd2txt
         .byte <spd3txt

spdophi  .byte >spd1txt
         .byte >spd2txt
         .byte >spd3txt
