

DEBUG = 0

DEMO_BUTTON_DELAY = 125

;---------------------------------------------------------------------------------------
;zoo mania assembler routines
;04/2004 hannenz
;---------------------------------------------------------------------------------------
;0			ingame 1
;1			ingame 2
;2			title screen
;3			level up
;4			time out
;5			hi score

			.macro jeq adr
			bne *+5
			jmp adr
			.endmacro

			.macro jne adr
			beq *+5
			jmp adr
			.endmacro

			.macro jmi adr
			bpl *+5
			jmp adr
			.endmacro

			.macro jpl adr
			bmi *+5
			jmp adr
			.endmacro

			.macro jcc adr
			bcs *+5
			jmp adr
			.endmacro
			.macro jcs adr
			bcc *+5
			jmp adr
			.endmacro

			.macro rotate char
			ldy $3002 + char*8
			ldx #2
:			lda $3001 + char*8,x
			sta $3000 + char*8,x
			inx
			cpx #6
			bne :-
			sty $3005 + char*8
			.endmacro


			joy_speed = 4;

			.import popax
			.import popa

			;include data (charsets, sprites, msx)

			.export _colortab,_highscore,_matrix
			.segment "DAT"
			.incbin "zoo.dat",2

_colortab:		.byte 1,1,2,5,6,4,7,3
_highscore:		.res 160
_matrix:		.res 64
			.export _bmp_data
			.segment "RODATA"
_bmp_data:		.incbin "zootitle.pic"
			.segment "CODE"
;---------------------------------------------
;void __fastcall__ init_msx(unsigned char);
;---------------------------------------------
			.export _init_msx
_init_msx:		jmp $1000

                        .export _detectvideo
_detectvideo:
    sei
    ldx #0
@l1:
    lda $d012
@l2:
    cmp $d012
    beq @l2
    bmi @l1
    cmp #$20
    bcc @ntsc
    inx
@ntsc:
    stx $02a6
    cli
    rts
;---------------------------------------------------
    .export _sync_irq_timer
_sync_irq_timer:
		
			lda #$00
			sta $dc0e

			ldy #$08
@wait:
			cpy $d012
			bne @wait
			lda $d011
			bmi @wait

			lda $02a6
			beq @ntsc

			; 50hz on PAL
                        lda #<((63*312)-1)
                        ldy #>((63*312)-1)
			jmp @nontsc
@ntsc:
			; 50hz on NTSC
			lda #<($4fb4)
			ldy #>($4fb4)
@nontsc:

			sta $dc04
			sty $dc05
		
                        lda #$11
                        sta $dc0e
                        rts
init_irq_timer:
			lda #$01
			sta $dc0e
			rts
		
;---------------------------------------------------
;void init_irq(void);
; used from asm AND C !
;---------------------------------------------------
;inits the irq running in-game

			.export _game_irq

_game_irq:		sei
                        lda #$7b
                        sta $d011

			lda #<_interrupt_handler
			ldx #>_interrupt_handler
			ldy #0
			sta $314
			stx $315

                        lda #3
                        sta $dd00
                        lda #$1a
                        sta $d018
                        lda #$18
                        sta $d016
			lda #0
			sta $d021

			jsr init_irq_timer

			lda #$00
			sta $d01a
			lda #$81
			sta $dc0d

                        lda #$1b
                        sta $d011

			lda $dc0d
			asl $d019
		
			cli
			rts
;---------------------------------------------------
;void __fastcall__ fld(char at_row);
;---------------------------------------------------
;little fld when scrolling out the main menu screen

			.export _fld

_fld:
        sta fldlines
        lsr
        lsr
        tay
        lsr
        tax
        lda fldcols,x
        sta fldcol
        lda fldcols2,y
        sta fldcol2
        rts

fldcols:  .byte 8,8,8,2,9,0,0,0
fldcols2: .byte 1,1,1,1,1,7,10,12,8,2,9,0,0,0,0,0

;---------------------------------------------------
;void setup_title_irq(void);
;---------------------------------------------------
;setup the irq runnnig in the main menu screen

			.export _title_irq

_title_irq:		sei
			lda #$7f
			sta $dc0d
			sta $dd0d
			lda $dc0d
			lda $dd0d
			lda #1
			sta $d01a

			lda #$7b
			sta $d011

                        jsr init_irq_timer

                        lda #$81
                        sta $dc0d

			lda #<title_irq
			ldx #>title_irq
			ldy #$b0 -1
			sta $314
			stx $315
			sty $d012
			
			lda #<(scroll_text-1)
			ldx #>(scroll_text-1)
			sta $7a
			stx $7b

                        lda $dc0d
                        asl $d019
			
			cli
			rts
;---------------------------------------------------------
_inter_irq:
        sei
        lda #<irq_x
        ldx #>irq_x
        ldy #$c8
        sta $314
        stx $315
        sty $d012

        jsr init_irq_timer

        lda #$01
        sta $d01a
        lda #$81
        sta $dc0d

        lda $dc0d
        asl $d019
        cli
        rts

irq_x:
        sei
        asl $d019
        bcc @timer

    ; raster IRQ
.if DEBUG = 1
        dec $d021
.endif
        lda #$1b
        sta $d018

        ldx #$a0
@lp:
        dex
        bne @lp
		
        lda #$1f
        sta $d018

.if DEBUG = 1
        inc $d021
.endif
        cli
        ; force cbm+shift off
        lda #$80
        sta $0291
        jmp $ea31

    ; 50 Hz TImer IRQ

@timer:
        lda $dc0d
        cli
		
.if DEBUG = 1
        inc $d020
.endif
        jsr $1003
.if DEBUG = 1
        dec $d020
.endif

        inc framecount50Hz
        jmp $febc

;---------------------------------------------------------

		
			.export _hs_irq
		
_hs_irq:		sei
			lda #<irq_hs
			ldx #>irq_hs
			sta $314
			stx $315
		
			ldy #$f0
			sty $d012
_inter_irq2:		
			lda #$1b
			sta $d011

			jsr init_irq_timer
		
			lda #$01
			sta $d01a
			lda #$81
			sta $dc0d

			lda $dc0d
			asl $d019

			cli
			rts

irq_hs:
		sei
			lsr $d019
			bcc @timer

.if DEBUG = 1
		dec $d021
.endif
			lda #$1b
			sta $d018

		ldx #$a0
@lp:
		dex
		bne @lp

			lda #$1f
			sta $d018
.if DEBUG = 1
		inc $d021
.endif
                inc framecount
		cli

        ; force cbm+shift off
        lda #$80
        sta $0291
			jmp $ea31

        ; 50 Hz Timer Irq
@timer:
        lda $dc0d
        cli
		
.if DEBUG = 1
        inc $d020
.endif
        jsr $1003
.if DEBUG = 1
        dec $d020
.endif
        inc framecount50Hz
        jmp $febc
		
;---------------------------------------------------
;interrupt handler
;---------------------------------------------------
;in-game irq routine

                        .export _getshift
_getshift:
                        lda $028d
                        and #1
                        rts

_interrupt_handler:
			asl $d019		;acknoledge raster irq
			lda $dc0d

			lda count
			beq get_joy

			lda $d00e		;move cursor
			clc
			adc _xdir1
			sta $d00e
			lda $d00f
			clc
			adc _ydir1
			sta $d00f

			lda _players
			beq @skip

			lda $d00c
			clc
			adc _xdir2
			sta $d00c
			lda $d00d
			clc
			adc _ydir2
			sta $d00d

@skip:			dec count
			jmp timer

get_joy:
                        ldy _tt
                        bne @skipkeys

                        lda $028d
                        and #1
                        bne @skipkeys

                        lda $c5
                        cmp #9 ;w
                        bne @skipkeys1
                        lda #126
                        bne @dokey
@skipkeys1:
                        cmp #10 ;a
                        bne @skipkeys2
                        lda #123
                        bne @dokey
@skipkeys2:
                        cmp #13 ;s
                        bne @skipkeys3
                        lda #125
                        bne @dokey
@skipkeys3:
                        cmp #18 ;d
                        bne @skipkeys
                        lda #119
                        bne @dokey


@skipkeys:
                        ldy _tt
			lda $dc00,y		;get joystick

@dokey:
			and #$7f

			ldx _demo		;if in demo mode get movement from cue
			beq @skip
			ldx _cue_max
			jsr _getfromcue
			jeq timer		;nothing waiting in the cue, then skip

@skip:			ldx #0			;we will need a zero
			cmp #126
			bne @joy1
			lda _ypos1		;if ypos is 0 then up isn't possible
			beq @joy4		;so skip
			dec _ypos1		;decrease ypos
			lda #256 - joy_speed
			sta _ydir1		;load the value to add to the sprite y coordinate
			stx _xdir1		;.x is alwayx 0, no x-movement
			jmp @joy5		;skip the following

@joy1:			cmp #125
			bne @joy2
			lda _ypos1
			cmp #7
			beq @joy4
			inc _ypos1
			lda #joy_speed
			sta _ydir1
			stx _xdir1
			jmp @joy5

@joy2:			cmp #123
			bne @joy3
			lda _xpos1
			beq @joy4
			dec _xpos1
			lda #256 - joy_speed
			sta _xdir1
			stx _ydir1
			jmp @joy5

@joy3:			cmp #119
			bne @joy4
			lda _xpos1
			cmp #7
			beq @joy4
			inc _xpos1
			lda #joy_speed
			sta _xdir1
			stx _ydir1
			jmp @joy5

@joy4:			stx _xdir1		;no joy input from joy#1, then both dir's are 0
			stx _ydir1
			jmp get_joy2

@joy5:			lda #6			;counter for sprite movement (6*4 pixels => move 24 pixels)
			sta count

get_joy2:		lda _players		;only one player?
			beq timer		;then skip this...

			lda $dc01		;check joy#2, see above
			ldx #0

			cmp #254
			bne @joy1
			lda _ypos2
			beq @joy4
			dec _ypos2
			lda #256 - joy_speed
			sta _ydir2
			stx _xdir2
			jmp @joy5

@joy1:			cmp #253
			bne @joy2
			lda _ypos2
			cmp #7
			beq @joy4
			inc _ypos2
			lda #joy_speed
			sta _ydir2
			stx _xdir2
			jmp @joy5

@joy2:			cmp #251
			bne @joy3
			lda _xpos2
			beq @joy4
			dec _xpos2
			lda #256 - joy_speed
			sta _xdir2
			stx _ydir2
			jmp @joy5

@joy3:			cmp #247
			bne @joy4
			lda _xpos2
			cmp #7
			beq @joy4
			inc _xpos2
			lda #joy_speed
			sta _xdir2
			stx _ydir2
			jmp @joy5

@joy4:			stx _xdir2
			stx _ydir2
			jmp timer

@joy5:			lda #6
			sta count

			;timer

timer:			lda _stop		;if the stop flag
			bne joker		;don't do the timer stuff

			lda _time1		;if the timer is decremented to zero yet
			ora _time1 + 1
			bne do_timer

			lda #1
			sta _time_out		;set a flag for the main program
			bne joker		;and skip the following

do_timer:		dec del			;respect timer delay
			bne joker
			lda _timer_delay
			sta del

			lda _time1		;decrease timer...
			bne @sk
			dec _time1+1
@sk:
			dec _time1

			jsr _display_time	;and display the bar

			;joker

joker:			lda _joker		;is there a joker running...??!
			jeq exit		;no, then skip

			dec _joker_delay		;respect delay value
			lda _joker_delay
			and #7			;every 8th frame...
			bne exit

			inc _joker_tmp		;increase the icon to display
			lda _joker_tmp
			cmp _animals		;if it is larger than possible animals in this level?
			bcc @skip
			lda #0			;then reset to zero
			sta _joker_tmp

@skip:			ldy _joker_y		;claculate screen ram adress to display the joker at

			lda ytab_hi,y
			sta $f5

			lda _joker_x
			asl
			clc
			adc _joker_x		;joker_x * 3 + xoffs
			clc
			adc ytab_lo,y
			bcc *+4
			inc $f5
			clc
			adc #2
			sta $f4
			bcc *+4
			inc $f5			;$f4/$f5 points to screen ram adress

			ldx _joker_tmp
			lda _colortab,x		;get proper color for the icon
			ora #8
			sta @col+1
			txa
			asl
			asl
			asl
			clc
			adc _joker_tmp		;multiply the icon code by 9 to get character code of first 3x3 char

			ldx #3			;count rows to draw

@lp2:			ldy #0
@lp1:			sta ($f4),y		;draw one character
			pha			;do color ram stuff..., remember accu value (character code)
			lda $f5			;(use current lo byte of pointer but alter hibyte to point to color ram)
			pha			;remember old hi byte
			and #3
			ora #$d8		;let it point to colorram
			sta $f5
@col:			lda #0			;plot color
			sta ($f4),y
			pla			;restore hibyte (screen ram)
			sta $f5
			pla			;restore accu (char code)
			clc
			adc #1			;and increase it
			iny
			cpy #3			;3 times in x-dir
			bne @lp1		;then goto next line
			pha
			lda $f4
			clc
			adc #$28		;(add 40 to pointer)
			sta $f4
			bcc *+4
			inc $f5
			pla
			dex			;and do 3 rows...
			bne @lp2

exit:
.if DEBUG = 1
			inc $d020
.endif
			jsr $1003		;play that funky music :)
.if DEBUG = 1
			dec $d020
.endif					
			dec rotate_delay	;rotate the chars of the timer bar
			lda rotate_delay	;each 4th frame
			and #3
			jne skip_rotate

			rotate 254
			rotate 253
			rotate 252
			rotate 251
			rotate 250
			rotate 249
			rotate 248
			rotate 247
skip_rotate:
                        inc framecount
                        inc framecount50Hz

        ; force cbm+shift off
        lda #$80
        sta $0291
                        jmp $ea31


;draw the timer bar

; used from asm AND C !
			.export _display_time

_display_time:		lda _time_out
			bne done
			lda _time1
			ldx _time1+1
			stx aux		;.A still has time1 lo byte
			lsr aux		;time1 is max. 319, so max. 1 bit set in Hibyte
			ror		;rotate right over 3 bytes (Hi,Lo,Remainder)
			ror rem
			lsr		;rotate right over 2 Bytes (Lo,Remainder)
			ror rem
			lsr
			ror rem
			tax		;time1 / 8
			lda rem 	;rotate rem right 5 times to get the remainder right
			lsr
			lsr
			lsr
			lsr
			lsr
			clc
			adc #$f6	;screen code of proper 'part' bar character
			sta $07c0,x
			lda #$fe	;screen code: 'full' bar char
l1:			dex
			bmi done
			sta $07c0,x
			jmp l1
done:			rts

;---------------------------------------------------------------------------------
;void print2x2_centered (char *string,char color1,char color2,char line);
;---------------------------------------------------------------------------------
			.export _print2x2_centered

_print2x2_centered:	sta line		;line
			jsr popa
			sta color2		;color2
			jsr popa
			sta color1
			jsr popax		;get string
			sta $fc
			stx $fd

			ldy line
			lda tab_lo,y
			sta $fe
			lda tab_hi,y
			sta $ff

			;calc length

			ldy #$ff
loop:			iny
			lda ($fc),y
			bne loop

			sty aux
			lda #20
			sec
			sbc aux
			clc
			adc $fe
			sta $fe
			bcc *+4
			inc $ff

			ldy #0
			sty tmp

loop2:			ldy tmp
			lda ($fc),y
			beq p2x2_done
			jsr plot2x2
			inc tmp
			jmp loop2

p2x2_done:		rts
;---------------------------------------------------------------------------------
;void __fastcall__ plot2x2_xy (char c,char x,char y,char color1,char color2);
;---------------------------------------------------------------------------------
			.export _plot2x2_xy

_plot2x2_xy:		sta color2	;store 'low' color
			jsr popa	;get 'high' color
			sta color1	;store it
			jsr popa	;get y
			sta line	;store
			jsr popa	;get x
			ldy line
			clc
			adc tab_lo,y	;line * 40 + x
			sta $fe		;in pointer lo-byte
			lda tab_hi,y	;hi-byte
			adc #0		;respect carry from addition of x
			sta $ff		;into pointer hi-byte
			jsr popa	;get 'character' to plot

plot2x2:		ldy #0
			ldx #0

			jsr _pet2scr	;convert into screen code
			asl		;screen code * 4
			asl
			sta ($fe),y	;store fisrt char
			jsr docol	;color it
			clc
			adc #1		;increase screen code by 1
			iny
			sta ($fe),y
			jsr docol
			clc
			adc #1

			inx
			pha		;remember screen code
			lda $fe		;pointer to next line
			clc
			adc #40
			sta $fe
			bcc @skip
			inc $ff
@skip:			pla

			ldy #0
			sta ($fe),y
			jsr docol
			iny
			clc
			adc #1
			sta ($fe),y
			jsr docol
			lda $fe
			sec
			sbc #38
			sta $fe
			bcs *+4
			dec $ff
			rts

docol:			pha
			lda $ff
			pha
			and #3
			ora #$d8
			sta $ff
			lda color1,x
			sta ($fe),y
			pla
			sta $ff
			pla
			rts


;---------------------------------------------
;void __fastcall__ setgfx(unsigned int);
;---------------------------------------------
; used from asm AND C !
			.export _setgfx

_setgfx:		ldx #4
			ldy #0
			sty d1
			asl
			rol d1
			asl
			rol d1
			sta tmp
			txa
			lsr
			lsr
			ldx #4
loop1:			asl tmp
			rol
			dex
			bne loop1
			sta $d018
			lda $dd00
			and #$fc
			ora d1
			eor #3
			sta $dd00
			rts

;---------------------------------------------
;void random_init(void);
;---------------------------------------------
			.export _random_init
_random_init:
			rts
					
;---------------------------------------------
;unsigned char random(void);
;---------------------------------------------
; BUGBUG: the function that generates the matrix and checks wether
;         it is solveable relies on the exact (!) behavior of this
;         random function. replacing it with a better algo does
;         result in a deadlock when initialising the matrix
; used from asm AND C !
			.export _random

_random:
			lda #0
			eor $dc04
			eor $dc05
; these aren't running anyway ! (gpz)
;			eor $dd04
;			eor $dd05
;			eor $dd06
;			eor $dd07
			sta _random+1
			ldx #0
					
			rts

; args, some of the asm routines seem to rely on X not being modified
; by this routine
				
_random_asm:
			stx @xtmp+1
			jsr _random
@xtmp:			ldx #0
			rts
					
;---------------------------------------------

_pet2scr:		eor #$e0
			clc
			adc #$20
			bpl cont
			adc #$40
			bpl cont
			eor #$a0
cont:
			rts

;------------------------------------------------
;unsigned char isstop(void)
;------------------------------------------------
			.export _isstop

_isstop:		lda #$7f
			sta $dc00
			cmp $dc01
			beq no

			lda #1
			ldx #0
			rts
					
no:			lda #0

;			ldx #0
			tax
			rts

;----------------------------------------------------
;void wait_for_key_or_joy(void);
;----------------------------------------------------
; used from asm AND C !
			.export _wait_for_key_or_joy

_wait_for_key_or_joy:	lda _demo
			bne @exitdelay
			lda $028d
			and #1
			bne @exit
			lda $dc00
			cmp #111
			beq @exit
			lda $dc01
			cmp #239
			bne _wait_for_key_or_joy
@exit:                  rts
@exitdelay:
                        lda #DEMO_BUTTON_DELAY
                        jmp _delay

;--------------------------------------------------------------
__check_matrix:
			;first we check horizontally

			lda #0
			sta cmxi		;count the rows
@loop2:			lda #0
			sta cmxj		;count the column
@loop1:			lda cmxi
			ldx cmxj
			jsr get_matrix		;.Y has index in _matrix of cmxi/cmxj, .A has value of _matrix,y
			cmp _matrix+1,y		;is it the same as its next neighbour?
			bne @no			;no then increas x position and try again
			cmp _matrix+2,y		;if we are here, two are same and testing the third neighbour
			bne @no_2		;if not equal we can advance by 2 in x dir !
			jmp @success		;three equal--> exit success
@no_2:			inc cmxj
@no:			inc cmxj
			lda cmxj
			cmp #6			;we need to test only up to xpos 5
			bcc @loop1
			inc cmxi		;next row
			lda cmxi
			cmp #8
			bne @loop2		;all 8 rows checked...?!

			;check vertically

			lda #0
			sta cmxj

@loop4:			lda #0
			sta cmxi
@loop3:			lda cmxi
			ldx cmxj
			jsr get_matrix
			cmp _matrix+8,y
			bne @no2
			cmp _matrix+16,y
			bne @no2
@success:
			lda #1
			rts
					
@no2:			inc cmxi
			lda cmxi
			cmp #6
			bne @loop3
			inc cmxj
			lda cmxj
			cmp #8
			bne @loop4

			lda #0
			rts

;-----------------------------------------------------------------------

title_irq:
                        sei
                        asl $d019
                        bcs @raster

                        lda $dc0d
                        cli

.if DEBUG = 1
                        inc $d020
.endif
                        jsr $1003
.if DEBUG = 1
                        dec $d020
.endif
;                       jmp out3
                        inc framecount50Hz
                        jmp $febc
@raster:
.if DEBUG = 1
                        lda #2
                        sta $d020
.endif
                        lda #$7f
                        sta $d015

                        ldx fldcol2
                        lda #$b7+2
                        cmp $d012
                        bne *-3
                        stx $d021
                        stx $d026

                        lda #$c0+2
                        sta $d016

                        ldx #$18+3
                        stx $d011

                        ; white
                        ldy #3

                        lda $d012
                        cmp $d012
                        beq *-3
                        ldx #$1a
                        nop
                        stx $d018
                        sty $dd00

                        ; orange -$bc
                        ldx fldcol
                        lda #$bc
                        cmp $d012
                        bne *-3
                        stx $d021

                        ldx fldlines
                        beq @skipfld
@loop:                  lda $d012
                        cmp $d012
                        beq *-3
                        and #7
                        ora #$10
                        sta $d011
                        dex
                        bne @loop

                        lda #$f8
                        cmp $d012
                        bne *-3

                        lda #$3b
                        sta $d011
                        lda #$d0
                        sta $d016
                        lda #$38
                        sta $d018
                        lda #0
                        sta $d021
                        sta $dd00

                        jmp skipscroll
@skipfld:
                        ldx barcolor
                        lda barline
                       cmp $d012
                       bne *-3

                        stx $d021
                       clc
                       adc #1
                       ldx #8

                       cmp $d012
                       bne *-3
                       stx $d021


                        lda #$ef
                        cmp $d012
                        bne *-3


                        ; white
                        ldx #1
			lda $d012
			cmp $d012
			beq *-3

			stx $d021

			lda #$f0
			cmp $d012
			bne *-3

			dec scroll
			dec scroll
			lda scroll
			and #7
			sta $d016

			lda $d012
			cmp $d012
			beq *-3

                        ; colorbars behind scroller

			ldx #7+2
                        ldy $d012
barlp:			lda barcolor_tab,x
			cpy $d012
			beq *-3
			sta $d021
			iny
			dex
			bpl barlp

			lda #0
			sta $d021
			sta $d016

			asl $d019

			lda #0
			sta $dd00
			lda #$38
			sta $d018
			lda #$3b
			sta $d011
			lda #$10
			sta $d016

                        ; rotate bar
			dec bar_delay
			lda bar_delay
@xyz:			and #1
			sta bar_delay
			bne @skip


			ldx barcolor_tab	;4
			ldy #0			;2
@loop:			lda barcolor_tab+1,y	;4
			sta barcolor_tab,y	;4		;80
			iny			;6
			cpy #31			;4
			bne @loop		;3
			txa			;2
			sta barcolor_tab,y	;4		;99

        ;----------------------------------------------------
        ; scroller
        ;----------------------------------------------------

@skip:
                        lda scroll
			and #7
			bne out2

			ldx #0
gklp:			lda $07c1,x
			sta $07c0,x
			lda $dbc1,x
			sta $dbc0,x
			inx
			cpx #$27
			bne gklp
			
			inc $7a
			bne *+4
			inc $7b
			
wrap:			ldy #0
			lda ($7a),y
			bne okok
			
			lda #<scroll_text
			ldx #>scroll_text
			ldy #1
			sty _demo
			sta $7a
			stx $7b
			jmp wrap
			
okok:			cmp #$10
			bcs okok1
			sta $dbc0+39
			bcc out2
			
okok1:			jsr _pet2scr
			ora #$80
			sta $07e7
out2:
out1:
out3:

skipscroll:


.if DEBUG = 1
                        lda #0
                        sta $d020
.endif
                        inc framecount

                        cli
        ; force cbm+shift off
        lda #$80
        sta $0291
                        jmp $ea31

fldlines:  .byte 0
fldcol:    .byte 0
fldcol2:   .byte 0

;---------------------------------------------------------------------------------

nmi:			pha
			lda #140
			sta _key
			pla
			rti

;---------------------------------------------------------------------------------
;void ass_setup(void)
;---------------------------------------------------------------------------------
			.export _ass_setup

_ass_setup:
			lda #<nmi
			ldx #>nmi
			sta $318
			stx $319

			lda #1
			sta del
			rts

                        .export _sprites_setup

_sprites_setup:
                        lda #11
                        sta $d022
                        sta $d025
                        lda #8
                        sta $d023
                        sta $d026
                        ldx #2
                        stx $d02d
                        dex
                        stx $d02e
                        dex
                        stx $d020
                        stx $d021
                        dex
                        stx $d01c
                        lda #39
                        ldx #50
                        sta $d00e
                        stx $d00f
                        clc
                        adc #24
                        sta $d00c
                        stx $d00d

                        lda #0
                        sta $d010
                        sta $d01d
                        sta $d017

                        lda #$3f
                        sta $07ff
                        sta $07fe
                        rts

;---------------------------------------------------------------------------------
;void cursor_on(void);
;void cursor_off(void);
;---------------------------------------------------------------------------------
			.export _cursor_on,_cursor_off

_cursor_on:		lda _players
			beq oneplayer_on
			lda #$c0
			.byte $2c
oneplayer_on:		lda #$80
			.byte $2c
_cursor_off:		lda #0
			sta $d015
			rts		;17

;------------------------------------------------
;void __fastcall__ clone(char i, char j,char s);
;------------------------------------------------
			.export _clone

_clone:			sta sprite
			jsr popa
			sta tmp		;x-pos (j)
			jsr popa	;i
			pha
			asl
			asl
			asl
			clc
			adc tmp
			tay
			lda _matrix,y	; x = matrix[i][j];
			tax
			ldy sprite

			clc
			adc #$37
			sta $07f8,y
			lda _colortab,x
			sta $d027,y

			tya
			asl
			tay

			lda tmp
			jsr mult24	;j*24
			clc
			adc #40		;+8*XOFFS + 24
			sta $d000,y

			pla
			jsr mult24
			adc #50
			sta $d001,y
			lda sprite
			clc
			adc #1
			ora $d015
			sta $d015
			rts

mult24:			sta add+1
			asl
			clc
add:			adc #0
			asl
			asl
			asl
			rts



;---------------------------------------------------------------------------------
;void __fastcall__ print3x3(char symbol,char x,char y);
;---------------------------------------------------------------------------------
			.export _print3x3

			;_print3x3: c-interface

_print3x3:		sta p3x3_y
			jsr popa
			sta p3x3_x
			jsr popa

			;p3x3: assembler-interface

p3x3:			ldx #0
			cmp #$ff	;code $ff --> blank!, then color = 10
			beq endif
			pha		;remember code
			and #7		;to get color just respect lower 3 bits
			tay
			pla		;restore code
			ldx _colortab,y	;get color code in .X
			sta p3x3_add+1	;store code for mult by 9
			asl
			asl
			asl		; *8
			clc
p3x3_add:		adc #0		;+1 --> multiplied by 9
endif:			stx p3x3_color	;store color

			tax		;remember start code

			ldy p3x3_y
			lda ytab_lo,y
			sta $fe
			lda ytab_hi,y	;y*24*3
			sta $ff
			lda p3x3_x
			asl
			clc
			adc p3x3_x
			adc #2		;+ x offset
			sta p3x3_x

			txa		;restore start code

			ldx #3
			stx tmp		;count rows
			ldy p3x3_x	;column to start
p3x3_lp1:		ldx #3		;count columns
p3x3_lp:		sta ($fe),y
			pha

			lda $ff
			pha
			and #3
			ora #$d8
			sta $ff
			lda p3x3_color
			ora #8
			sta ($fe),y
			pla
			sta $ff

			pla
			cmp #$ff
			beq p3x3_skip
			clc
			adc #1
p3x3_skip:		iny
			dex
			bne p3x3_lp
			pha
			tya
			clc
			adc #37
			tay
			pla
			dec tmp
			bne p3x3_lp1
			rts

;---------------------------------------------------------------------------------
;void broesel(void);
;---------------------------------------------------------------------------------
			.export _broesel

_broesel:		jsr _kill_joker
			lda #0
			sta $d015
			lda #64
			sta br_i

br_loop:		jsr _random_asm
			and #7
			sta p3x3_x
			jsr _random_asm
			and #7
			sta p3x3_y
			asl
			asl
			asl
			clc
			adc p3x3_x
			tax
			lda _matrix,x
			cmp #$ff
			beq br_loop

			lda #$ff
			sta _matrix,x
			jsr p3x3
                        jsr _waitframe
			dec br_i
			bne br_loop
			rts
;---------------------------------------------------------------------------------
;void appear(void);
;---------------------------------------------------------------------------------
			.export _appear

_appear:		lda #64
			sta br_i

app_loop:		jsr _random_asm
			and #7
			sta p3x3_x
			asl
			clc
			adc p3x3_x
			adc #2
			tay
			jsr _random_asm
			and #7
			sta p3x3_y
			tax
			lda ytab_lo,x
			sta $fe
			lda ytab_hi,x
			sta $ff

			lda ($fe),y
			cmp #$ff
			bne app_loop

			lda p3x3_y
			asl
			asl
			asl
			clc
			adc p3x3_x
			tax
			lda _matrix,x
			jsr p3x3
                        jsr _waitframe

			dec br_i
			bne app_loop
			rts
;---------------------------------------------------------------------------------
;void fill(void);
;---------------------------------------------------------------------------------
; used from asm AND C
			.export _fill

_fill:			lda #$ff
			ldx #0
@lp:
			sta $0400,x
			sta $0500,x
			sta $0600,x
			sta $06e8,x
			inx
			bne @lp
			rts
;---------------------------------------------------------------------------------
;void gfx_mode(void);
;---------------------------------------------------------------------------------
			.export _gfx_mode

_gfx_mode:		jsr _fill
			lda #$18
			sta $d016
			lda #$30
			jmp _setgfx
;---------------------------------------------------------------------------------
;void txt_mode(void);
;---------------------------------------------------------------------------------
			.export _txt_mode

_txt_mode:		jsr _kill_joker
			lda #0
			sta $c6
			sta $d015
			lda #8
			sta $d016
			lda #$1b
			sta $d011
			jsr _fill
			lda #$38
			jmp _setgfx
;---------------------------------------------------------------------------------
;void kill_joker(void);
;---------------------------------------------------------------------------------
			.export _kill_joker

_kill_joker:		lda _joker
			beq @end
			lda #0
			sta _joker
			lda _joker_y
			asl
			asl
			asl
			clc
			adc _joker_x
			sta kj_tmp
@lp:
			jsr _get_random_symb
			ldx kj_tmp
			sta _matrix,x
			jsr __check_matrix
			bne @lp
					
			ldx kj_tmp
			lda _matrix,x
			ldx _joker_x
			ldy _joker_y
			stx p3x3_x
			sty p3x3_y
			jsr p3x3
@end:			rts

;---------------------------------------------------------------------------------

_get_random_symb:	jsr _random_asm
			cmp _animals
			bcs _get_random_symb
			rts

;---------------------------------------------------------------------------------
;void fill_matrix(void);
;---------------------------------------------------------------------------------
			.export _fill_matrix

_fill_matrix:		jsr _inter_irq

			ldx #0
@lp1:			lda text,x
			jsr _pet2scr
			ora #$80
			sta $0729-40,x
			lda #12
			sta $db29-40,x
			inx
			cpx #22
			bne @lp1

			lda #1
			sta $d015
			sta $d017
			sta $d01d
			ldx #160
			stx $d000
			ldx #144
			stx $d001

@loop:			inc hugo

			lda hugo
			and #7
			tay
			ldx _colortab,y
			clc
			adc #$37
			sta $07f8
			stx $d027

			ldx #63
@lp:			jsr _get_random_symb
			sta _matrix,x
			dex
			bpl @lp

			jsr __check_matrix
			bne @loop

			jsr _check_moves
			beq @loop

			ldy _level
			dey
			tya
			and #7
			tay
			ldx _colortab,y
			clc
			adc #$37
			sta $07f8
			stx $d027

			ldx #$27
			lda #$ff
@lp2:			sta $0720-40,x
			dex
			bpl @lp2

			jsr _wait_for_key_or_joy
			lda #0
			sta $d015
			sta $d017
			sta $d01d
			jsr _fill
			jsr _game_irq
			jmp _gfx_mode


;------------------------------------------------------------
;void __fastcall__ plot_score(unsigned int sc,char x,char y);
;------------------------------------------------------------
			.export _plot_score

_plot_score:		tay
			lda tab_lo,y
			sta $fe
			lda tab_hi,y
			sta $ff

			jsr popa
			sta @tmp
			clc
			adc $fe
			sta $fe
			bcc *+4
			inc $ff

			jsr popax
			sta @value
			stx @value+1

			ldy #3
@lp1:			jsr @div10
			pha
			dey
			bne @lp1

@lp2:			pla
			clc
			adc #$ec
			sta ($fe),y

			lda $ff
			pha
			and #$03
			ora #$d8
			sta $ff
			lda _players
			beq @skip
			lda @tmp
			cmp #30
			bcs @skip
			ldx _pl
			lda ps_coltab2,x
			bne @do
@skip:			lda ps_coltab1,y
@do:			sta ($fe),y
			pla
			sta $ff

			iny
			cpy #3
			bne @lp2
			rts

@tmp:			.byte 0
@value:			.word 0

@div10:			ldx #$ff
@loop:			inx
			lda @value
			sec
			sbc #10
			sta @value
			lda @value+1
			sbc #0
			sta @value+1
			bcs @loop
			lda #0
			sta @value+1
			lda @value
			adc #10
			stx @value
			rts

ps_coltab1:		.byte 6,3,1
ps_coltab2:		.byte 1,2
;---------------------------------------------------------------------------------
;void load_hs(void);
;---------------------------------------------------------------------------------
			.export _load_hs

_load_hs:		jmp (_load_vector)
			lda #1
			ldx #8
			ldy #0
			jsr $ffba
			lda #6
			ldx #<(fn+2)
			ldy #>(fn+2)
			jsr $ffbd
			lda #0
			ldx #<_highscore
			ldy #>_highscore
			jmp $ffd5
;---------------------------------------------------------------------------------
;void save_hs(void);
;---------------------------------------------------------------------------------
			.export _save_hs

_save_hs:		jmp (_save_vector)
			lda #0
			sta $d01a
			sta $d418

			lda #$7f
			sta $dc0d
					
			lda #<_highscore
			ldx #>_highscore
			sta $fe
			stx $ff

			lda #1
			tay
			ldx #8
			jsr $ffba
			lda #8
			ldx #<fn
			ldy #>fn
			jsr $ffbd
			lda #$fe
			ldx #<(_highscore + 160)
			ldy #>(_highscore + 160)
			jsr $ffd8
;			inc $d01a

			lda #1
			sta $d01a
			lda #$81
			sta $dc0d
					
			rts
;---------------------------------------------------------------------------------
;unsigned char yesno(void)
;---------------------------------------------------------------------------------
			.export _yesno

_yesno:			jsr $ffe4
			cmp #'l'
			beq ys_yes
			cmp #'r'
			bne _yesno
			lda #0
			tax
			rts
ys_yes:			lda #1
			ldx #0
			rts
;--------------------------------------------------------------------
;void move_matrix(void)
;--------------------------------------------------------------------

plex_wait_top:
;    lda #2
;    sta $d021
    lda #120
    cmp $d012
    bcs *-3
;    lda #0
;    sta $d021
    rts
plex_wait_bot:
    lda #242
    cmp $d012
    bcs *-3
;    lda #3
;    sta $d020
    lda #242
    cmp $d012
    bcc *-3
;    lda #0
;    sta $d020
    rts

			.export _move_matrix

_move_matrix:
			.proc move_matrix
			lda _joker
			sta jb		;jb = joker;

			lda #7
			sta rows	;i = 7;

@do:			lda #0		;for (j=0;j<8;++j)
			sta columns

@for_j_loop:		lda rows	;{
			ldx columns
			jsr get_matrix	;if (matrix[i][j] == BLACK)
			cmp #$ff
			jne @endif1
			lda #0		;yes
			sta depth
@while:			inc depth	;depth = 1
			lda rows
			sec
			sbc depth		;.A: i-depth
			bcc @endwhile	;(i-depth) < 0 --> exit while loop
			ldx columns
			jsr get_matrix	;matrix[i-depth][j]
			cmp #$ff	;==BLACK??
			beq @while	;yes, then increase depth and continue while loop

@endwhile:		lda #0		;s = 0;
			sta spr
			lda #$c0	;vic->spr_ena = 0xc0;
			sta $d015

			lda rows	;for (k=i;k!=255;--k)
			sta temp_k
@for_loop2:		lda temp_k	;if (k - depth) >= 0
			sec
			sbc depth
			bcc @else	;k-depth is less than 0, so do 'else'-case
			ldx columns
			jsr get_matrix	;get matrix[k-depth][j]
			pha		;remebmer
			lda temp_k
			ldx columns
			jsr get_matrix	;.Y to matrix[k][j]
			pla		;get symbol to copy to back
			sta _matrix,y	;this is: matrix[k][j] = matrix[k-depth][j]
			jmp @endif2

@else:			jsr _get_random_symb
			pha
			lda temp_k
			ldx columns
			jsr get_matrix
			pla
			sta _matrix,y	;matrix[k][j] = get_random_symb();

@endif2:		ldx columns
			ldy temp_k
			lda #$ff
			stx p3x3_x
			sty p3x3_y
			jsr p3x3	;print3x3(BLACK,j,k)

			lda spr		;if (s < 6){
			cmp #6
			bcs @endif3

			lda temp_k
			ldx columns
			jsr get_matrix
			cmp #$b0	;if (matrix[k][j] == JOKER_SYMB
			bne @else2
			ldy spr
			lda #$37
			sta $07f8,y	;spr_ptr[s] = 0x37;
			lda #1
			sta $d027,y	;*(char*)(0xd027 + s) = 1;
			lda #0
			sta _joker	;joker = 0;
			lda _joker_y
			clc
			adc depth
			sta _joker_y	;joker_y += depth;
			jmp @endif4
@else2:			lda temp_k
			ldx columns
			jsr get_matrix
			tax
			clc
			adc #$37
			ldy spr
			sta $07f8,y	;spr_ptr[s] = 0x37 + matrix[k][j];
			lda _colortab,x
			sta $d027,y	;*(char*)(0xd027+s) = colortab[matrix[k][j]];

@endif4:		lda spr
			asl
			tay
			lda columns
			jsr mult24	;j*24
			clc
			adc #40
			sta $d000,y	;*(char*)(0xd000 + 2*s) = 24+XOFFS*8+j*24;
			lda temp_k
			sec
			sbc depth
			php
			jsr mult24
			clc
			adc #50
			sta $d001,y	;*(char*)(0xd001 + 2*s) = 50 + (k - depth)*24;
			plp		;if (k-depth >= 0)
			bcc @endif3
			ldx spr
			lda #1
@loop:			dex
			bmi @ex
			asl
			jmp @loop
@ex:			ora $d015
			sta $d015	;vic->spr_ena = tab[s];

@endif3:		inc spr		;++s;
			dec temp_k
			jpl  @for_loop2

			;multiplexer

			lda #0
			sta temp_l
			lda #1
			sta spr		;now used to count 6es for mover

			lda depth
			asl
			clc
			adc depth
			asl		;depth*6
			sta @comp+1

@for_loop3:				;if (l%6 == 0)
			dec spr
			bne @endif5
			lda #6
			sta spr
			lda $d015
			asl
			ora #$c1
			sta $d015

@endif5:

                        ; move sprites 0-5 4 down
                        lda $d00b
			clc
			adc #4
			sta $d00b
			lda $d009
			clc
			adc #4
			sta $d009
			lda $d007
			clc
			adc #4
			sta $d007
			lda $d005
			clc
			adc #4
			sta $d005
			lda $d003
			clc
			adc #4
			sta $d003
			lda $d001
			clc
			adc #4
			sta $d001

			lda $d001
			sta bck
			cmp #(50+5*24)	;if((bck1 = *(char*)0xd001 >= 50+5*24)
			jcc  @else3

			ldx $07f8
			ldy $d027
			stx bck+1
			sty bck+2

			lda $d003
			ldx $07f9
			ldy $d028
			sta bck+3
			stx bck+4
			sty bck+5

;			lda #255-10
;			jsr _wait	;wait(255)
			jsr plex_wait_bot

			ldx columns	;row0 --> spr0
			lda _matrix,x
			tax
			clc
			adc #$37
			sta $07f8	;spr_ptr[0] = matrix[0][j] + 0x37
			lda _colortab,x	;*(char*)0xd027 = colortab[matrix[0][j]];
			sta $d027

			lda rows
			cmp #7
			bne @plex7

			lda #8		;row1 --> spr1
			clc
			adc columns
			tax
			lda _matrix,x
			tax
			clc
			adc #$37
			sta $07f9
			lda _colortab,x
			sta $d028

			lda $d001
			sec
			sbc #(7*24)
			sta $d001
			lda $d003
			sec
			sbc #(5*24)
			sta $d003
			jmp @end_plex

@plex7:			lda $d001
			sec
			sbc #(6*24)
			sta $d001

@end_plex:
                        jsr plex_wait_top

			lda bck
			ldx bck+1
			ldy bck+2
			sta $d001
			stx $07f8
			sty $d027
			lda bck+3
			ldx bck+4
			ldy bck+5
			sta $d003
			stx $07f9
			sty $d028
			jmp @end_for
@else3:
                        jsr plex_wait_bot

@end_for:

                        inc temp_l
			lda temp_l
@comp:			cmp #6
			jne @for_loop3

			lda #0
			sta temp_k

@for_loop4:		lda temp_k
			ldx columns
			sta p3x3_y
			stx p3x3_x
			jsr get_matrix
			cmp #$b0
			beq @end_for1
			jsr p3x3
@end_for1:		inc temp_k
			lda temp_k
			cmp rows
			beq @for_loop4
			bcc @for_loop4


@endif1:		inc columns	;end of (if (matrix[i][j] == BLACK), for_j_loop++
			lda columns
			cmp #8
			jne @for_j_loop

			dec rows
			bmi @end
			jmp @do
@end:			lda jb
			sta _joker
			jmp _cursor_on



.endproc

get_matrix:		stx @add+1
			asl
			asl
			asl
			clc
@add:			adc #0
			tay
			lda _matrix,y
			rts

                        .export _getkey
_getkey:                jsr $ffcc
                        jmp $ffe4

;---------------------------------------------------------------------------------
;unsigned char __fastcall__ check_moves(void);
;---------------------------------------------------------------------------------
; used from asm AND C
					
			.export _check_moves

_check_moves:

;we advance throug the matrix in x then y dir each time swapping with each the right neighbour and the lower
;neighbour, then calling __check_matrix to see if there are three or more...

			lda #1
			sta _stop		;stop timer

			lda #7
			sta cmi
for_i_loop:		lda #0
			sta cmj

for_j_loop:		ldx cmj
			cpx #7
			beq endif1		;we need only 0-6 since 6 will swap with 7
			lda cmi
			jsr swap_h		;swap (x) with (x+1)
			jsr __check_matrix	;check if this causes a three or more...
			pha			;remember result of check
			lda cmi
			ldx cmj
			jsr swap_h		;swap them back again to restore original matrix
			pla			;get result of check
			beq endif1		;=0, then check was negativ, go ahead

			ldx cmj			;we found a possible move, so
			stx _pm_x1		;store the x/y pos of both swappers in pm_x1/pm_y1 and pm_x2/pm_y2
			inx
			stx _pm_x2
			lda cmi
			sta _pm_y1
			sta _pm_y2
cm_exit:		lda #0			;free timer freeze
			tax
			sta _stop
			lda #1			;success
			rts			;return
endif1:
			lda cmi			;now swap vertically
			cmp #7			;again only 0-6 need to be swapped since 6 will swap with 7
			beq endif2
			ldx cmj
			jsr swap_v		;swap'em
			jsr __check_matrix	;check _matrix
			pha			;remember check result
			lda cmi
			ldx cmj
			jsr swap_v		;swap'em back
			pla			;re-get check result
			beq endif2		;0 = no success

			ldx cmi			;found, then store the result...
			stx _pm_y1
			inx
			stx _pm_y2
			lda cmj
			sta _pm_x1
			sta _pm_x2
			jmp cm_exit

endif2:			inc cmj			;advance in x-direction
			lda cmj
			cmp #8
			jne for_j_loop
			dec cmi
			jpl for_i_loop
			lda #0
			tax
			sta _stop
			rts


swap_h:			jsr get_matrix		;.A: matrix[i][j]
			iny
			ldx _matrix,y		;.X: matrix[i][j+1]
			sta _matrix,y		;matrix[i][j+1] = matrix[i][j]
			dey
			txa
			sta _matrix,y		;matrix[i][j] = matrix[i][j+1]
			rts

swap_v:			jsr get_matrix
			pha
			tya
			clc
			adc #8
			tay
			pla
			ldx _matrix,y
			sta _matrix,y
			tya
			sec
			sbc #8
			tay
			txa
			sta _matrix,y
			rts

;--------------------------------------------------------------------------
;void __fastcall__ put2cue(char);
;--------------------------------------------------------------------------
			.export _put2cue

_put2cue:		ldx _cue_max
			cpx #16
			beq @exit
			sta _cue,x
			inc _cue_max
@exit:			rts
;--------------------------------------------------------------------------

_getfromcue:		lda _cue_max
			beq @exit
			ldy _cue
			dec _cue_max
			ldx #0
@lp:			cpx _cue_max
			beq @done
			lda _cue+1,x
			sta _cue,x
			inx
			bne @lp
@done:			tya
@exit:
			rts

;---------------------------------------------------------------------------------
;void __fastcall__ do_bar(char);
;---------------------------------------------------------------------------------
			.export _do_bar

_do_bar:		clc
			adc #(55+18*8)
                        sta barline
			inc @delay
			lda @delay
			and #3
			bne @skip
			inc @tmp
@skip:			lda @tmp
			and #7
			tay
			ldx @tab,y
                        stx barcolor
			rts
@delay:			.byte 0
@tmp:			.byte 0
@tab:			.byte 0,11,12,15,1,15,12,11

barline:        .byte 0
barcolor:       .byte 0

                        .export _waitframe50Hz
_waitframe50Hz:
                        lda framecount50Hz
                        cmp framecount50Hz
                        beq *-3
                        rts

			.export _delay

_delay:			tax
			;lda #100
@loop:
                        ;jsr _wait
                        jsr _waitframe50Hz
			dex
			bne @loop
			rts

                        .export _waitframe
_waitframe:
                        lda framecount
                        cmp framecount
                        beq *-3
                        rts
framecount:     .byte 0
framecount50Hz: .byte 0
;---------------------------------------------------------------------------------
;void screen_off(void); void screen_on(void)
;---------------------------------------------------------------------------------
			.export _screen_off, _screen_on

_screen_off:		lda #$0b
			.byte $2c
_screen_on:		lda #$1b
			sta $d011
			rts
;---------------------------------------------------------------------------------
;variables, tables, data...
;---------------------------------------------------------------------------------
.export _key,_timer_delay,_stop,_time_out,_joker_tmp,_joker,_animals,_level
.export _xpos1,_xpos2,_ypos1,_ypos2,_xdir1,_xdir2,_ydir1,_ydir2
.export _load_vector,_save_vector,_time1,_players,_joker_x,_joker_y
.export _pm_x1,_pm_x2,_pm_y1,_pm_y2
.export _cue,_cue_max,_demo,_pl, _team, _tt
.export _fld_done
.export _joker_delay

bck:			.res 6
_cue:			.res 16
_fld_done:		.byte 0
fld_tmp:		.byte 0
_cue_max:		.byte 0
_demo:			.byte 0
_pl:			.byte 0
_pm_x1:			.byte 0
_pm_x2:			.byte 0
_pm_y1:			.byte 0
_pm_y2:			.byte 0
_key:			.byte 0
_xpos1:			.byte 0
_ypos1:			.byte 0
_xdir1:			.byte 0
_ydir1:			.byte 0
_xpos2:			.byte 0
_ypos2:			.byte 0
_xdir2:			.byte 0
_ydir2:			.byte 0
_timer_delay:		.byte 0
_stop:			.byte 0
_time_out:		.byte 0
_joker_tmp:		.byte 0
_joker:			.byte 0
_animals:		.byte 0
_level: 		.byte 0
_players:		.byte 0
_joker_x:		.byte 0
_joker_y:		.byte 0
_time1:			.word 0
_team:			.byte 0
_tt:			.byte 0

rotate_delay:		.byte 0
_joker_delay:		.byte 0
scroll_delay:		.byte 0
bar_delay:		.byte 0
d1:			.byte 0
tmp:			.byte 0
count:			.byte 0
aux:			.byte 0
rem:			.byte 0
scroll:			.byte 0
del:			.byte 0
line:			.byte 0
color1:			.byte 0
color2:			.byte 0,0
cmxi:			.byte 0
cmxj:			.byte 0
key_delay:		.byte 0
sprite:			.byte 0
p3x3_color:		.byte 0
p3x3_x:			.byte 0
p3x3_y:			.byte 0
br_i:			.byte 0
kj_tmp:			.byte 0
rows:			.byte 0
columns:		.byte 0
temp_k:			.byte 0
temp_l:			.byte 0
depth:			.byte 0
spr:			.byte 0
jb:			.byte 0
cmi:			.byte 0
cmj:			.byte 0


_load_vector:		.word _load_hs+3
_save_vector:		.word _save_hs+3

ytab_lo:		.byte 0,120,240,<(9*40),<(12*40),<(15*40),<(18*40),<(21*40)
ytab_hi:		.byte 4,4,4,5,5,6,6,7

tab_lo:			.byte 0,40,80,120,160,200,240,<280,<320,<360,<400,<440,<480,<520,<560,<600,<640,<680,<720
			.byte <760,<800,<840,<880,<920,<960
tab_hi:			.byte 4,4,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7

barcolor_tab:
                        .byte $00,$09,$02,$08,$0c,$08,$02,$09
                        .byte $00,$06,$0b,$04,$0e,$04,$0b,$06
                        .byte $00,$09,$02,$08,$0c,$08,$02,$09
                        .byte $00,$06,$0b,$04,$0e,$04,$0b,$06

hugo:			.byte 0
text:			.byte "one moment, please...!",0
fn:			.byte "@:zoo.hi"

;modul_version	= 0;
.if .defined (modul_version)
scroll_text:
.byte 1,"no scroll text in cartridge version                    ",0

.else

scroll_text:
.byte $0f,"Welcome to ",1,"ZOO MANIA.            "
.byte 3,"This is the ",1,"final version ",3,"of this game with even more important bugfixes. "
;.byte $0f,"it was released by ninja in january 2009 and approved by hannenz who left the scene for good. ",$0a
;.byte "so, in case you encounter problems, "
;.byte "contact ninja for assistance. "
;.byte 3,"Now for the complete credits and original scrolltext: "
.byte "          "
.byte 1,"code ",$0f,"hannenz "
.byte 1,"ingame gfx ",$0f,"crossbow "
.byte 1,"msx ",$0f,"fanta "
.byte 1,"title pic ",$0f,"scorp.ius "
.byte 1,"idea ",$0f,"bugjam "
.byte 1,"bugfixes ",$0f,"ninja ",$0f,"groepaz "
.byte 1,"ntsc fixes ",$0f,"groepaz "
.byte "          "
.byte $0f,"instructions: ",$0f,"use ",1,"joy #2 ",$0f,"in single player mode or "
.byte 1,"joy #1 and #2 ",$0f,"in two player modes. "
.byte $0f,"use ",1,"W A S D ",$0f,"and ",1,"SHIFT ",$0f,"if you can't find your joystick. "
.byte "          "
.byte $0f,"try to ",1,"swap ",$0f,"the animals so that "
.byte 1,"rows or columns of three or more equal animals ",$0f,"occur."
.byte " there is a certain amount of animals to catch to proceed to the next level. ",1,"time ",$0f,"is your enemy.  "
.byte 1,"keys: ",$0f,"hit "
.byte 1,"RUN/STOP ",$0f,"to pause the game. "
.byte 1,"RESTORE ",$0f,"will get you back to the game menu. "
.byte 1,"D ",$0f,"in the game menu jumps to demo mode. "
.byte "          "
.byte 1,"have fun! "
.byte "          "
.byte $0f,"hannenz@freenet.de  ninja@the-dreams.de  groepaz@gmx.net "
.byte "                                                             "
.byte 0

.endif
