;           /-----\
;           |SLIDE|
;           | 64  |
;           \-----/
;
;-------------------------------
;| A C64 version of the famous |
;|        puzzle game.         |
;|                             |
;|     Written in 2011 by      |
;|      Joonas Lindberg.       |
;|                             |
;|   Public Domain - spread    |
;|     and modify at will.     |
;-------------------------------

; Joystick required - port 2
; (sorry, no key controls
;  this time.. wanted to get
;  this mini game done as
;  quickly as possible :) )

Screen1 = $02
Screen2 = $04
Blockchars = $04
Read = $06
Wipemode = $06
Offset = $08
Lines = $08; Lines left when we colour the lines for the text
Blockoffset = $09; Offset on Game_board when we put the pieces on screen
Block_temp = $0a
Cursor_offset = $0b
Moves = $0c ; Number of moves made during the game, it's a 3-byte value
Cursormove_NS = $0f
Cursormove_EW = $10
Cursor_X = $11
Cursor_Y = $12
Blockbytes = $13 ; How many bytes from the Game_board when the pieces move
Checking = $13
Colourpoint = $fe
Flashtimer = $ff
Sprite_pointer = $07f8

;**Screen locations of things **
Outline1 = $042b
Outline1b = $0453
Theboard = $0454
Outline2 = $0773
Cset1 = $2040
Cset2 = $23B0
Cursor_location = $303d
;**                           **

* = $0810
;VIC2 settings $D010 - D021
IOsetts
!byte $00,$1b,$20,$00,$00,$00,$c8,$01,$19,$71,$f0,$00,$00,$01,$00,$00,$0d,$00

CURSOR_COLOURS !byte $06,$0e,$03,$01,$03

Decimal_numbers
!byte $0e
!byte $01,$02,$03,$04,$05,$06,$07,$08,$09,$10
!byte $11,$12,$13,$14,$15,$16,$17,$18,$19,$20
!byte $21,$22,$23,$24,$25,$26,$27,$28,$29,$30
!byte $31,$32,$33,$34,$35,$36,$37,$38,$39

;The order of the blocks on the game
;board is randomised at the start of
;each new game.
Game_board
!byte $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
!byte $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
!byte $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
!byte $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
!byte $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff

; Texts start with 1 byte: how many spaces before the text.
; Texts end in one of the following byte codes:
; 00 - END OF TEXT
; 01 - 1 LINE BREAK
; 02 - 2 LINE BREAKS
; 03 - 3 LINE BREAKS
!ct scr {
Title
!byte $10
!text "SLIDE!"
!byte $02
!byte $02
!text "WRITTEN BY JOONAS LINDBERG IN 2011"
!byte $02
!byte $0a
!text "THIS IS A PD GAME."
!byte $02
!byte $00
!text "JOYSTICK SHOULD BE PLUGGED IN PORT 2."
!byte $03
!byte $05
!text "PRESS FIRE TO START THE GAME"
!byte $00

Complete
!byte $00
!text "WOW! YOU ACTUALLY SOLVED THE PUZZLE!"
!byte $01
!byte $00
!text "YOU ARE VERY GOOD. IF YOU WANT TO"
!byte $01
!byte $00
!text "HAVE AN ANOTHER GO, PRESS FIRE NOW."
!byte $02
!byte $00
!text "ME SAYS  BYE!!"
!byte $02
!byte $00
!text "MOVES MADE.... "

Counter
!text "00000"
!byte $03
!byte $0c
!text "PRESS FIRE..."
!byte $00

}

;The only thing the IRQ does
;is change the colours of the
;cursor sprite.
Stuff	dec Flashtimer
	bpl irqend
	lda #$06
	sta Flashtimer
	ldx Colourpoint
	lda CURSOR_COLOURS,x
	sta $d027
	dex
	bpl *+4
	ldx #$05
	stx Colourpoint
irqend	jmp $ea31

;Clear the screen
;(fill it with $2A - empty space)
CLEAR	lda #$2a
	ldx #$00
	ldy #$00
	sta $0400,x
	sta $0500,x
	sta $0600,x
	sta $0700,y
	cpy #$e7
	beq *+3
	iny
	inx
	bne *-18
	rts

;=============================
;The text writer
;=============================
Write	stx Read
	sty Read+1
	lda #$50
	sta Screen1
	lda #$d8
	sta Screen1+1
	ldy #$00
	lda #$15
	sta Lines
	lda #$07
	ldx #$28
W_cfill	sta (Screen1),y
	iny
	bne *+4
	inc Screen1+1
	dex
	bne W_cfill
	eor #$0f
	dec Lines
	bne W_cfill-2
W_full	lda #$78
	sta Screen2
	lda #$04
	sta Screen1+1
	sta Screen2+1
	ldy #$00
	beq W_goff
W_lineb	tay
	lda Screen1
	sec
	sbc Offset
	bcs *+4
	dec Screen1+1
	clc
	adc #$50
	sta Screen1
	bcc *+4
	inc Screen1+1
	lda Screen2
	sec
	sbc Offset
	bcs *+4
	dec Screen2+1
	clc
	adc #$50
	sta Screen2
	bcc *+4
	inc Screen2+1
	lda #$00
	sta Offset
	dey
	bne W_lineb+1
	dec Screen1
	lda Screen1
	cmp #$ff
	bne *+4
	dec Screen1+1
	dec Screen2
	lda Screen2
	cmp #$ff
	bne *+4
	dec Screen2+1
	inc Read
	bne *+4
	inc Read+1
W_goff	lda (Read),y
	sta Offset
	tax
	clc
	adc Screen1
	sta Screen1
	bcc *+4
	inc Screen1+1
	txa
	clc
	adc Screen2
	sta Screen2
	bcc Wri_pr+2
	inc Screen2+1
	bne Wri_pr+2
Writemn	lda (Read),y
	bne *+3
	rts
	cmp #$20
	bne *+8
	lda #$2a
	ldx #$2a
	bne w_punc
	cmp #$21
	bne *+8
	lda #$29
	ldx #$4f
	bne w_punc
	cmp #$2c
	bne *+8
	lda #$2a
	ldx #$50
	bne w_punc
	cmp #$2e
	bne w_norm
	lda #$2a
	ldx #$51
w_punc	sta (Screen1),y
	txa
	bne W_Lett2
w_norm	cmp #$04
	bcs *+5
	jmp W_lineb
	cmp #$40
	bcs W_Lett
	sbc #$04
	bne *+4
W_Lett	sbc #$0c
	sta (Screen1),y
	adc #$26
W_Lett2	sta (Screen2),y
Wri_pr	inc Offset
	inc Read
	bne *+4
	inc Read+1
	inc Screen1
	bne *+4
	inc Screen1+1
	inc Screen2
	bne Writemn
	inc Screen2+1
	bne Writemn
;=============================
;
;=============================

; The 'Wipe Out' Fader
; Carry SET    =  Charset enabled
; Carry CLEAR  =  Wipe out charset
WIPEOUT	ldy #$08
	sty Wipemode
	bcs *+6
	lda #$00
	sta Wipemode
	dey
	bpl *+3
	rts
	lda #<Cset1
	sta Screen1
	lda #>Cset1
	sta Screen1+1
	lda #<Cset2
	sta Screen2
	lda #>Cset2
	sta Screen2+1
	ldx #$10
	lda $d012
	cmp #$40
	bne *-5
	dex
	bne *-8
	ldx #$6e
Wiping	lda Wipemode
	beq *+4
	lda (Screen2),y
	sta (Screen1),y
	dex
	beq WIPEOUT+10
	lda Screen1
	clc
	adc #$08
	sta Screen1
	bcc *+4
	inc Screen1+1
	lda Screen2
	clc
	adc #$08
	sta Screen2
	bcc Wiping
	inc Screen2+1
	bne Wiping

;-----------------------------------
;***********************************
;Put the pieces on the board!:)
;Pieces at $1D - 28
;1D 1E 1F 20
;21 2A 2A 22
;23 2A 2A 24
;25 26 27 28
SCR_UPD	lda #<Theboard
	sta Screen1
	lda #>Theboard
	sta Screen1+1
	lda #$00
	sta Blockoffset
	ldx #$1d
	lda #$08
	sta Offset
	ldy Blockoffset
	lda Offset
	beq *+12
	cpx #$21
	beq isspace+1
	cpx #$23
	beq isspace+1
	bne isblock+1
	lda #$08
	sta Offset
	lda #$21
	cpx #$1d
	beq isspace
	lda #$23
	cpx #$21
	beq isspace
	lda #$25
	cpx #$23
	beq isblock
	lda Blockoffset
	adc #$07
	sta Blockoffset
	tay
	cmp #$28
	bne *+3
	rts
	lda #$1d
isblock	tax
	stx Blockchars
	inx
	stx Blockchars+1
	inx
	stx Blockchars+2
	inx
	stx Blockchars+3
	dex
	dex
	dex
	lda Game_board,y
	bne *+12
	lda #$2a
	sta Blockchars
	sta Blockchars+1
	sta Blockchars+2
	sta Blockchars+3
	ldy #$03
lineop	lda Blockchars,y
	sta (Screen1),y
	dey
	bpl lineop
	inc Blockoffset
	lda #$04
	dec Offset
	bne *+11
	lda Blockoffset
	sec
	sbc #$08
	sta Blockoffset
	lda #$0c
	clc
	adc Screen1
	sta Screen1
	bcc SCR_UPD+18
	inc Screen1+1
	bne SCR_UPD+18
isspace	tax
	lda Game_board,y
	beq lineop-17
	tay
	lda #$09
	cpx #$23
	bne *+4
	lda #$13
	sta Block_temp
	lda Decimal_numbers,y
	tay
	and #$f0
	lsr
	lsr
	lsr
	lsr
	adc Block_temp
	sta Blockchars+1
	tya
	and #$0f
	adc Block_temp
	sta Blockchars+2
	stx Blockchars
	inx
	stx Blockchars+3
	dex
	bne lineop-2
;-----------------------------------
;***********************************

CHECKEM	lda #$01
	ldx #$00
	sta Checking
	lda Game_board,x
	cmp Checking
	bne NOMATCH
	inc Checking
	inx
	cpx #$27
	bcc CHECKEM+6
	rts
NOMATCH	clc
	rts

Settim	stx $dc04
	sty $dc05
	rts

DECIM	tay
	and #$0f
	clc
	adc #$30
	tax
	tya
	and #$f0
	lsr
	lsr
	lsr
	lsr
	adc #$30
	rts

; ************************
; ** END OF SUBROUTINES **
; ************************

INIT	sei
	lda #<Stuff
	sta $0314
	lda #>Stuff
	sta $0315
	cli
	ldx #$11
	lda IOsetts,x
	sta $d010,x
	dex
	bpl *-7
	lda #$01
	sta $d027
	lda #$80
	sta Sprite_pointer
	lda #$08
	jsr $ffd2
	jsr CLEAR
	ldx #<Title
	ldy #>Title
BEGIN	jsr Write
	sec
	jsr WIPEOUT
	lda #$10
	bit $dc00
	bne *-3
	clc
	jsr WIPEOUT
;The game has begun!
;Now we randomise the game board.
	lda #$ff
	ldx #$27
	sta Game_board,x
	dex
	bpl *-4
	ldy #$27
RANDOM	lda $dc04
	and #$3f
	cmp #$28
	bcc *+4
	sbc #$28
	sta $02
	tax
	dex
	bne *-1
	ldx $02
	lda Game_board,x
	bmi *+9
	dex
	bpl *-6
	ldx #$27
	bne *-10
	tya
	sta Game_board,x
	dey
	bpl RANDOM
;Draw the outlines of the game board
	jsr CLEAR
	ldx #$21
Outs	lda #$08
	sta Outline1,x
	sta Outline2,x
	lda #$02
	sta Outline1+$d400,x
	sta Outline2+$d400,x
	dex
	bpl Outs
	lda #<Outline1b
	sta Screen1
	sta Screen2
	lda #>Outline1b
	sta Screen1+1
	lda #$d8
	sta Screen2+1
	ldx #$14
	ldy #$00
Outs2	lda #$08
	sta (Screen1),y
	lda #$02
	sta (Screen2),y
	cpy #$21
	beq *+6
	ldy #$21
	bne Outs2
	ldy #$20
	lda #$0f
Outs3	sta (Screen2),y
	dey
	bne Outs3
	lda Screen1
	clc
	adc #$28
	sta Screen1
	sta Screen2
	bcc *+6
	inc Screen1+1
	inc Screen2+1
	dex
	bne Outs2-2
	jsr SCR_UPD
	sec
	jsr WIPEOUT
	lda #>Cursor_location
	sta $d000
	lda #<Cursor_location
	sta $d001
	inc $d015
	lda #$00
	sta Cursor_offset
	sta Moves
	sta Moves+1
	sta Moves+2
	sta Cursormove_NS
	sta Cursormove_EW
	sta Cursor_X
	sta Cursor_Y
; The game loop.....
GAME	lda #$01
	bit $d019
	beq *-3
	sta $d019
	lda Cursormove_EW
	bne MovesEW
	lda #$08
	bit $dc00
	bne Joy_W
	lda Cursor_X
	cmp #$07
	beq Vert
	inc Cursor_X
	inc Cursor_offset
	lda #$08
	sta Cursormove_EW
	bne Vert
Joy_W	lsr
	bit $dc00
	bne Vert
	lda Cursor_X
	beq Vert
	dec Cursor_X
	dec Cursor_offset
	lda #$f8
	sta Cursormove_EW
	bne Vert
MovesEW	bmi Cur_W
Cur_E	dec Cursormove_EW
	lda $d000
	clc
	adc #$04
	sta $d000
	bcc Vert
	inc $d010
	bne Vert
Cur_W	inc Cursormove_EW
	lda $d000
	sec
	sbc #$04
	sta $d000
	bcs Vert
	dec $d010
Vert	lda Cursormove_NS
	bne MovesNS
	lda #$02
	bit $dc00
	bne Joy_N
	lda Cursor_Y
	cmp #$04
	bcs if_fire
	lda Cursor_offset
	adc #$08
	sta Cursor_offset
	inc Cursor_Y
	lda #$10
	sta Cursormove_NS
	bne if_fire
Joy_N	lsr
	bit $dc00
	bne if_fire
	lda Cursor_Y
	beq if_fire
	lda Cursor_offset
	sec
	sbc #$08
	sta Cursor_offset
	dec Cursor_Y
	lda #$f0
	sta Cursormove_NS
	bne if_fire
MovesNS	bmi Cur_N
Cur_S	inc $d001
	inc $d001
	dec Cursormove_NS
	bpl if_fire
Cur_N	dec $d001
	dec $d001
	inc Cursormove_NS
if_fire	lda #$10
	bit $dc00
	bne branch
	lda Cursormove_NS
	bne branch
	lda Cursormove_EW
	bne branch
	ldx Cursor_offset
	lda Game_board,x
	bne *+5
branch	jmp GAME
; --------------------------------
; Fire has been pressed on a tile,
; so we check whether the tile(s)
; can be moved in any of the 4
; directions.
; --------------------------------
	lda #$00
	sta Blockbytes
	ldy Cursor_X
maybeW	lda Game_board,x
	beq Slide_W
	cpy #$00
	beq maybeE-6
	inc Blockbytes
	dex
	dey
	bpl maybeW
	sty Blockbytes
	ldy Cursor_X
	ldx Cursor_offset
maybeE	lda Game_board,x
	beq Slide_E
	cpy #$07
	beq maybeN-8
	inc Blockbytes
	inx
	iny
	bpl maybeE
	ldy #$00
	sty Blockbytes
	ldy Cursor_Y
	ldx Cursor_offset
maybeN	lda Game_board,x
	beq Slide_N
	cpy #$01
	bcc maybeS-6
	inc Blockbytes
	txa
	sbc #$08
	tax
	dey
	bpl maybeN
	sty Blockbytes
	ldy Cursor_Y
	ldx Cursor_offset
maybeS	lda Game_board,x
	beq Slide_S
	cpy #$04
	bcs NO_MOVE
	inc Blockbytes
	txa
	adc #$08
	tax
	iny
	bpl maybeS
	tax
Slide_N	txa
	tay
	clc
	adc #$08
	tax
	lda Game_board,x
	sta Game_board,y
	tya
	adc #$08
	dec Blockbytes
	bne Slide_N-1
	beq S_empty
	tax
Slide_S	txa
	tay
	sec
	sbc #$08
	tax
	lda Game_board,x
	sta Game_board,y
	tya
	sbc #$08
	dec Blockbytes
	bne Slide_S-1
	beq S_empty
Slide_W	inx
	lda Game_board,x
	dex
	sta Game_board,x
	inx
	dec Blockbytes
	bne Slide_W
	beq S_empty
Slide_E	dex
	lda Game_board,x
	inx
	sta Game_board,x
	dex
	dec Blockbytes
	bne Slide_E
S_empty	lda #$00
	sta Game_board,x
	sed
	lda Moves+2
	clc
	adc #$01
	sta Moves+2
	lda Moves+1
	adc #$00
	sta Moves+1
	lda Moves
	adc #$00
	sta Moves
	cld
NO_MOVE	jsr SCR_UPD
	jsr CHECKEM
	bcs *+5
	jmp GAME

; GAME COMPLETED!!
	lda #$40
	sta $03
	lda #$01
	tax
	tay
	jsr Settim
stripes	bit $dc0d
	beq *-3
	inc $d020
	dec $02
	bne stripes
	dec $03
	bne stripes
	ldx #$25
	ldy #$40
	jsr Settim
	dec $d015
	lda #$00
	sta $d010
	lda Moves
	clc
	adc #$30
	sta Counter
	lda Moves+1
	jsr DECIM
	sta Counter+1
	stx Counter+2
	lda Moves+2
	jsr DECIM
	sta Counter+3
	stx Counter+4
	lda #$0d
	sta $d020
	clc
	jsr WIPEOUT
	jsr CLEAR
	ldx #<Complete
	ldy #>Complete
	jmp BEGIN
;Load the location of the end text,
;then jump back to the code that
;waits for joystick fire press.

;The cursor sprite
* = $2000
!byte $3f,$ff,$fc,$3f,$ff,$fc,$3f,$ff,$fc,$38,$00,$1c,$38,$00,$1c,$38
!byte $00,$1c,$38,$00,$1c,$38,$00,$1c,$38,$00,$1c,$38,$00,$1c,$38,$00
!byte $1c,$38,$00,$1c,$38,$00,$1c,$38,$00,$1c,$38,$00,$1c,$38,$00,$1c
!byte $38,$00,$1c,$3f,$ff,$fc,$3f,$ff,$fc,$3f,$ff,$fc,$00,$00,$00,$00

* = $23B0
!bin "SLIDE.CHR",, 0