/******************************************************************
 * dtvmkfs - Make DTV flash filesystem                            *
 ******************************************************************
 * $Id: filelist.c,v 1.5 2008-10-13 21:42:00 spiff Exp $
 * Linked list for directory structure                            *
 ******************************************************************
 * Author: Mikkel Holm Olsen (dtv@symlink.dk)                     *
 ******************************************************************
 * dtvmkfs is free software; you can redistribute it and/or       *
 * modify it under the terms of the GNU General Public License    *
 * as published by the Free Software Foundation; either version 2 *
 * of the License, or (at your option) any later version.         *
 *                                                                *
 * dtvmkfs is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  *
 * GNU General Public License for more details.                   *
 *                                                                *
 * You should have received a copy of the GNU General Public      *
 * License along with dtvmkfs; if not, write to the Free Software *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,         *
 * MA  02110-1301  USA                                            *
 ******************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "filelist.h"

struct filelist_t *filelist=NULL, *lastfile=NULL;
int num_entries=0;

void file_add_to_list(char *zip, char *file, FileType_t file_type, char *c64n,
                      int flash, int load, int sys, int pksize, int show) {
  struct filelist_t *newentry;
  newentry=malloc(sizeof(struct filelist_t));
  newentry->archive=zip;
  newentry->filename=file;
  newentry->file_type=file_type;
  newentry->c64name=c64n;
  newentry->flashaddr=flash;
  newentry->loadaddr=load;
  newentry->sysaddr=sys;
  newentry->packedsize=pksize;
  newentry->unpackedsize=0;
  newentry->show_in_listing=show;
  newentry->included=0;
  newentry->crc32=0;
  newentry->next=NULL;

  if (!filelist) filelist=newentry;
  if (lastfile) lastfile->next=newentry;
  lastfile=newentry;
  num_entries++;
}

void file_delete_entry(struct filelist_t *entry) {
  struct filelist_t *ptr;
  if (filelist==entry) {
    filelist=entry->next;
    num_entries--;
  } else {
    ptr=filelist;
    while (ptr) {
      if (ptr->next==entry) {
        ptr->next=entry->next;
        num_entries--;
        break;
      }
      ptr=ptr->next;
    }
  }
}

int file_get_num_entries(void) {
  return num_entries;
}

struct filelist_t *file_get_first_entry(void) {
  return filelist;
}

struct filelist_t *file_find_name(char *name) {
  struct filelist_t *ptr=filelist;
  if ((!name)||(name[0]==0))
    return NULL;
  while ((ptr)&&(ptr->included)) {
    if (strcmp(ptr->c64name,name)==0)
      return ptr;
    ptr=ptr->next;
  }
  return NULL;
}

struct filelist_t *file_find_crc32(uint32_t crc) {
  struct filelist_t *ptr=filelist;
  if (crc==0)
    return NULL;
  while (ptr) {
    if (ptr->crc32==crc)
      return ptr;    
    ptr=ptr->next;
  }
  return NULL;
}

void file_print_list(void) {
  struct filelist_t *ptr=filelist;

  while (ptr) {
    printf("%s\n",ptr->archive);
    ptr=ptr->next;
  }

}

