/******************************************************************
 * dtvmkfs - Make DTV flash filesystem                            *
 ******************************************************************
 * $Id: filelist.h,v 1.4 2008-10-13 21:42:00 spiff Exp $
 * Linked list for directory structure                            *
 ******************************************************************
 * Author: Mikkel Holm Olsen (dtv@symlink.dk)                     *
 ******************************************************************
 * dtvmkfs is free software; you can redistribute it and/or       *
 * modify it under the terms of the GNU General Public License    *
 * as published by the Free Software Foundation; either version 2 *
 * of the License, or (at your option) any later version.         *
 *                                                                *
 * dtvmkfs is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  *
 * GNU General Public License for more details.                   *
 *                                                                *
 * You should have received a copy of the GNU General Public      *
 * License along with dtvmkfs; if not, write to the Free Software *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,         *
 * MA  02110-1301  USA                                            *
 ******************************************************************/

#ifndef _FILELIST_H
#define _FILELIST_H

#include <stdint.h>

typedef enum {
  FILETYPE_UNKNOWN=0,
  FILETYPE_ARCHIVE,       // Archive containing index.txt to be parsed
  FILETYPE_DTVPACKED,     // File is already DTV-packed
  FILETYPE_PRG,           // PRG-file. Reads loadaddr from file and packs.
  FILETYPE_BIN,           // Binary file. Packed.
  FILETYPE_RAW            // A raw file, which should not be packed
} FileType_t;

struct filelist_t {
  char *archive;
  char *filename;
  FileType_t file_type;
  char *c64name;
  int flashaddr, loadaddr, sysaddr;
  int packedsize;
  int unpackedsize;
  int show_in_listing;
  int included;
  uint32_t crc32;
  struct filelist_t *next;
};

void file_add_to_list(char *zip, char *file, FileType_t file_type, char *c64n,
                      int flash, int load, int sys, int pksize, int show);

void file_delete_entry(struct filelist_t *entry);

int file_get_num_entries(void);

struct filelist_t *file_get_first_entry(void);

struct filelist_t *file_find_name(char *name);

struct filelist_t *file_find_crc32(uint32_t crc);

void file_print_list(void);

#endif
