/******************************************************************
 * dtvmkfs - Make DTV flash filesystem                            *
 ******************************************************************
 * $Id: flash.c,v 1.2 2007-03-14 19:49:55 spiff Exp $
 * Helper functions to access flash file system                   *
 ******************************************************************
 * Author: Mikkel Holm Olsen (dtv@symlink.dk)                     *
 ******************************************************************
 * dtvmkfs is free software; you can redistribute it and/or       *
 * modify it under the terms of the GNU General Public License    *
 * as published by the Free Software Foundation; either version 2 *
 * of the License, or (at your option) any later version.         *
 *                                                                *
 * dtvmkfs is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  *
 * GNU General Public License for more details.                   *
 *                                                                *
 * You should have received a copy of the GNU General Public      *
 * License along with dtvmkfs; if not, write to the Free Software *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,         *
 * MA  02110-1301  USA                                            *
 ******************************************************************/

#include "flash.h"

int flash_get_2_bytes(unsigned char *mem) {
  return mem[0]|(mem[1]<<8);
}

void flash_set_2_bytes(unsigned char *mem, int value) {
  mem[0]=value&0x000000FF;
  mem[1]=(value&0x0000FF00)>>8;
}

int flash_get_3_bytes(unsigned char *mem) {
  return mem[0]|(mem[1]<<8)|(mem[2]<<16);
}

void flash_set_3_bytes(unsigned char *mem, int value) {
  mem[0]=value&0x000000FF;
  mem[1]=(value&0x0000FF00)>>8;
  mem[2]=(value&0x00FF0000)>>16;
}

