/******************************************************************
 * dtvmkfs - Make DTV flash filesystem                            *
 ******************************************************************
 * $Id: hex.c,v 1.2 2007-03-14 19:49:55 spiff Exp $
 * HEX printing functions                                         *
 ******************************************************************
 * Author: Mikkel Holm Olsen (dtv@symlink.dk)                     *
 ******************************************************************
 * dtvmkfs is free software; you can redistribute it and/or       *
 * modify it under the terms of the GNU General Public License    *
 * as published by the Free Software Foundation; either version 2 *
 * of the License, or (at your option) any later version.         *
 *                                                                *
 * dtvmkfs is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  *
 * GNU General Public License for more details.                   *
 *                                                                *
 * You should have received a copy of the GNU General Public      *
 * License along with dtvmkfs; if not, write to the Free Software *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,         *
 * MA  02110-1301  USA                                            *
 ******************************************************************/

#include <stdio.h>

#include "hex.h"

void hexprint(unsigned char *buf, unsigned int start, unsigned int end) {
  unsigned int i;
  for (i=start;i<=end;i++) {
    if (i%16==0) printf("%08X  ",i);
    printf("%02X ",buf[i]);
    if (i%16==7) 
      printf(" ");
    else if (i%16==15)
      printf("\n");
  }
}
