; sd2brwse
; --------
; 2008 Hannu Nuotio

; This program works as a program launcher.
; MMC2IEC with sd2iec is required.

; Start of project: 12.3.2008
; v.0.5 - 8.11.2008
; v.0.4 - 7.11.2008
; v.0.3 - 20.4.2008
; v.0.2 - 15.3.2008
; v.0.1 - 14.3.2008
; v.0.0 - 12.3.2008 - fork() of sdbrowse v.0.7

; Compiles with ACME 0.91
; # acme --cpu 6502 -f cbm -o sd2brwse.prg sd2brwse.asm

; Type RUN to start.

; Known bugs:

; TODO:

; Memory map:
; $0000-$03ff : (mostly) unused
; $0400-$07ff : screen, LOAD&RUN code
; $0801-$xxxx : code
; $xxxx-$zzzz : data
; $zzzz-$ffff : unused

; Notes:


; --- Constants

; - joystick port address
joyport = $dc00         ; joystick port
joypddr = $dc02         ; joystick port data direction register

; - max. length for stored entries
entrylen = 17
; - max. length for shown entries
namelen = 16

; - some PETSCII chars
quotechar = $22
leftarrowchar = 95

; - kernal functions
SETLFS = $ffba          ; a = filenr, x = unitnr, y = sec.addr/command (255|1)
SETNAM = $ffbd          ; a = namelen, x:y->name
OPEN = $ffc0
CLOSE = $ffc3           ; x = filenr
LOAD = $ffd5            ; a = 0
SCNKEY = $ff9f
GETIN = $ffe4           ; ret: a = 0: no keys pressed, otherwise a = ASCII code
CHROUT = $ffd2          ; a = output char
PLOT = $fff0            ; x<->y
CLEARSCREEN = $e544

; - basic functions
GIVAYF = $b391          ; in: y:a, ret: FAC#1
FOUT = $bddd            ; in: FAC#1, ret: a:y->string

; - hw addresses
screen = $0400          ; screen address
color = $d800           ; color ram address
vicborder = $d020       ; border color register
vicbackgnd = $d021      ; background color register
vicraster = $d012       ; raster compare register
keybuf = $0277          ; keyboard buffer
keybuflen = $c6         ; keyboard buffer byte count
lastdevice = $ba        ; last used device number

; - user configuration
!src "config.def"


; --- Zero page variables

; current joystick state (1 = falling edge)
curjoy = $22

; temp variables
tmp  = $23
tmp2 = $24
tmp3 = $25

; pointer to last of the table
tbllst  = $26
tbllsth = $27

; menustate, bits:
; 0 = top reached (disable up & page up)
; 1 = bottom reached
; 2 = last reached (disable down & page down)
; 7 = inside d64
menustate = $28

; length of diskname
disknamepetlen = $29

!if rememberpos = 1 {
; previous dir position
prevdirpos  = $57
prevdirposh = $58
}

!if firmware = 0 {
; current subdirectory depth
subdirdepth = $2a
}

; - pointer to selected entry
selected  = $fb
selectedh = $fc

; - temp pointer
tmpptr = $fd
tmpptrh = $fe


; --- Main 

!ct pet		; petscii

; start of program
*=$0801
entry:
; BASIC stub: "1 SYS 2061"
!by $0b,$08,$01,$00,$9e,$32,$30,$36,$31,$00,$00,$00

mlcodeentry:
!if hwdevicenum = 0 {
; store last used device number
lda lastdevice
sta device
}

; set colors
!if bordercolor<16 {
lda #bordercolor
sta vicborder
}
!if backcolor<16 {
lda #backcolor
sta vicbackgnd
}
!if forecolor>4 {
lda #forecolor
jsr CHROUT
}

; clear screen
!if clearscrena = 1 {
jsr CLEARSCREEN
}

!if showcursors = 1 {
; draw arrows
!if arrowcolor>4 {
lda #arrowcolor
jsr CHROUT
}
!if listx > 0 {
ldy #listx-1
ldx #listtopy
jsr PLOT
lda #'>'
jsr CHROUT
}
!if listx+namelen < 40 {
ldy #listx+namelen
ldx #listtopy
jsr PLOT
lda #'<'
jsr CHROUT
}
!if arrowcolor>4 {
!if forecolor>4 {
; set foreground color again
lda #forecolor
jsr CHROUT
} ; forecolor
} ; arrowcolor
} ; showcursors

; exit to root: "CD:_", "CD//"
ldx #<diskcmdexit
ldy #>diskcmdexit
lda #0
!if firmware = 0 {
sta subdirdepth
}
jsr openclose
ldx #<diskcmdroot
ldy #>diskcmdroot
lda #0
!if rememberpos = 1 {
sta prevdirposh
}
jsr openclose

; - previous directory load
;
loadprev:
lda #0
sta menustate
sta tmp
sta disknamepetlen
lda #<tmp
sta selected
lda #>tmp
sta selectedh
lda #<diskcmdexit
sta tmpptr
lda #>diskcmdexit
sta tmpptrh
jsr loadlist
; set selected to tbl (or remembered pos)
!if rememberpos = 1 {
lda prevdirposh
beq +           ; skip if not available
sta selectedh
lda prevdirpos
sta selected
lda #0
sta prevdirposh ; disable next remembered pos
+
}


; - menu
;
menu:
jsr clearlist
jsr redrawlist  ; SLOW

menuchanged:
!if statusenabl = 1 {
; print file status
jsr printstatus
}

menuwait:
lda #rastercmp
- cmp vicraster
bne -           ; wait until raster = rastercmp
iny             ; y++
cpy #joyrepeat  ; check if y >= joyrepeat
bcc +           ; if not, skip
ldy #0          ; reset joyrepeat counter
lda #$ff        ; reset lastjoy for repeat
sta lastjoy
; read joystick
+ lda joyport   ; a = joy
tax             ; save to x
eor lastjoy     ; a = joy xor lastjoy
and lastjoy     ; a = a and lastjoy
stx lastjoy     ; update lastjoy
sta curjoy
and #$1f        ; test if anything is pressed
bne +           ; if is, process input
jsr GETIN       ; read keyboard
tax             ; x = pressed key (or 0)
beq menuwait    ; if no keys pressed, no input -> wait

; process input
+ lda curjoy
lsr             ; check if up
bcs +           ; jump if pressed
cpx #key_preve  ; check if key_preve
bne ++          ; jump if not
+ lda menustate ; a = menustate
and #1          ; check if top reached
bne menuwait    ; if it is, jump back
; prev entry
sec
lda selected    ; selected -= entrylen
sbc #entrylen
sta selected
bcs +
dec selectedh
+ 
!if fastscrolle = 1 {
jsr scrollup
jmp menuchanged
} else {
jmp menu
}

++ lsr          ; check if down
bcs +           ; jump if pressed
cpx #key_nexte  ; check if key_nexte
bne ++          ; jump if not
+ lda menustate ; a = menustate
and #4          ; check if last reached
bne menuwait    ; if it is, jump back
; next entry
clc
lda selected    ; selected += entrylen
adc #entrylen
sta selected
bcc +
inc selectedh
+ 
!if fastscrolle = 1 {
jsr scrolldown
jmp menuchanged
} else {
jmp menu
}

++ cpx #key_exit    ; check if key_exit
bne ++              ; jump if not
jmp loadprev        ; load prev dir

++ cpx #key_quit    ; check if key_quit
bne ++              ; jump if not
rts                 ; quit to basic

++ cpx #key_top     ; check if key_top
bne ++              ; jump if not
lda #<tbl
sta selected        ; selected = table
lda #>tbl
sta selectedh
jmp menu

++ cpx #key_bottom  ; check if key_bottom
bne ++              ; jump if not
lda tbllst
sta selected        ; selected = table
lda tbllsth
sta selectedh
jmp menu

++ lsr          ; check if left
bcs +           ; jump if pressed
cpx #key_prevp  ; check if key_prevp
bne ++          ; jump if not
+ jmp prevpage  ; previous page

++ lsr          ; check if right
bcs +           ; jump if pressed
cpx #key_nextp  ; check if key_nextp
bne ++          ; jump if not
+ jmp nextpage  ; next page

++ lsr          ; check if fire
bcs firepressed ; jump if pressed
cpx #key_fire   ; check if key_fire
beq firepressed ; jump if pressed
jmp menuwait

; - fire pressed
firepressed:

; - check if first file ("_")
lda selectedh
cmp #>tbl
bne ++          ; jump if not
lda selected
cmp #<tbl
bne ++          ; jump if not
!if firmware = 0 {
ldx subdirdepth
beq +
dec subdirdepth
+
}
jmp loadprev    ; was "_", load prev dir

; copy selected to disknamepet, save length-1 of name
++ ldy #namelen
sty disknamepetlen
lda #<disknamepet
sta tmpptr
lda #>disknamepet
sta tmpptrh
- dey
php 
lda (selected),y
bne +
sty disknamepetlen
+ sta (tmpptr),y
plp
bne -

; check if inside d64
bit menustate
bmi prselected  ; if in d64, load selected program

; check if selected is dir
ldy #(entrylen-1)
lda (selected),y
cmp #3          ; FIXME magic value for "dir"
bne search      ; jump if not dir

loaddir:
!if rememberpos = 1 {
lda selected
sta prevdirpos
lda selectedh
sta prevdirposh
}
!if firmware = 0 {
inc subdirdepth
}
lda #<diskcmdcd
sta tmpptr
lda #>diskcmdcd
sta tmpptrh
jsr loadlist
jmp menu

; determine if selected file is d64(/d71/d81/m2i)
;  - if d64 -> change dir & set d64 flag

; seach for last .
search:
+ ldy #namelen-1
- lda (tmpptr),y
cmp #'.'
beq +
dey
bne -

; . not found, assuming entry is program
beq prselected

; . found on y (>0), check known extensions
+ iny
lda #<extensions
sta extension_list
lda #>extensions
sta extension_list+1
lda #4               ; extension len
ldx #extensions_max  ; extension max
jsr parseext
cpx #0
beq prselected      ; jump not d64(/d71/d81/m2i)

; d64(/d71/d81/m2i) selected
lda #$80        ; inside d64
sta menustate
bne loaddir     ; load directory

; - program selected, start loading
prselected:

!if pleasewaite = 1 {
; print info...
jsr showpleasewait
}

; setup load
setupload:
lda #1      ; filenr
ldx device  ; unitnr
ldy #1      ; sec.address (,1)
jsr SETLFS
ldx disknamepetlen
inx
txa                 ; a = filenamelen
ldx #<disknamepet
ldy #>disknamepet   ; x:y->filename
jsr SETNAM

; copy LOAD & RUN code to loadrunpos
ldy #0
ldx #loadrunend-loadrunstart
- lda loadrunstart,y
sta loadrunpos,y
iny
dex
bne -
jmp loadrunpos  ; jump to loadrunpos

; (the following code is executed at loadrunpos)
loadrunstart    ; start of code to copy
!pseudopc loadrunpos {
; load program
;
lda #0      ; a = 0: load
jsr LOAD
; error detection would be nice :)

; save end address
stx $2d
sty $2e

; autostart program
; (from comp.sys.cbm)
;
jsr $a659   ; reset pointers etc...
jmp $a7ae   ; BASIC warm start
}
loadrunend  ; end of code to copy


; --- Subroutines

; - nextpage
;
nextpage:
lda #<(listbottomy-listtopy)*entrylen
sta tmp
lda #>(listbottomy-listtopy)*entrylen
sta tmp2
clc
lda selected    ; selected += page
adc tmp
sta selected
lda selectedh
adc tmp2
sta selectedh
lda tbllsth     ; check if table last < selected
cmp selectedh
bcc +
bne ++
lda tbllst
cmp selected
bcs ++
+ lda tbllst
sta selected    ; table last < selected -> selected = table last
lda tbllsth
sta selectedh
++ jmp menu 


; - prevpage
;
prevpage:
lda #<(listbottomy-listtopy)*entrylen
sta tmp
lda #>(listbottomy-listtopy)*entrylen
sta tmp2
sec
lda selected    ; selected -= page
sbc tmp
sta selected
lda selectedh
sbc tmp2
sta selectedh
lda #>tbl       ; check if selected < table
cmp selectedh
bcc ++
bne +
lda #<tbl
cmp selected
bcc ++
+ lda #<tbl
sta selected    ; selected < table -> selected = table
lda #>tbl
sta selectedh
++ jmp menu 


; - clearlist
;
clearlist:
lda #<screen+listtopy*40+listx
sta clearlistsl
lda #>screen+listtopy*40+listx
sta clearlistsh
ldx #listbottomy-listtopy
-- ldy #0
lda #listbackgnd
- 
clearlistsl = *+1
clearlistsh = *+2
sta $1234,y
iny
cpy #namelen
bne -
clc
lda clearlistsl
adc #40
sta clearlistsl
lda clearlistsh
adc #0
sta clearlistsh
dex
bne --
rts


; - redrawlist (SLOW)
; parameters:
;  selected:h->top entry
; returns:
;  menustate
;
redrawlist:
; check if top is reached
lda menustate
and #$f0
tay
lda #>tbl
cmp selectedh
bne +
lda #<tbl
cmp selected
bne +
; selected is the first entry
iny                 ; y bit 0 = 1
+ sty menustate     ; menustate = y
; store selected:h
lda selected
sta tmpptr
lda selectedh
sta tmpptrh
ldx #listtopy       ; set list y location
; print loop
- ldy #0
lda (selected),y    ; check if end reached
beq ++              ; jump if end
; print entry
ldy #listx          ; set list x location
jsr printentry      ; print
cpx #listbottomy    ; is bottom reached
beq +++             ; jump if it is
clc
lda selected        ; selected += entrylen
adc #entrylen
sta selected
bcc -
inc selectedh
bne -               ; loop
; end reached
++ lda menustate
ora #2              ; end reached, bit 1 = 1
sta menustate
cpx #listtopy+1     ; check if last reached
bne +               ; skip if not
ora #4              ; last reached, bit 2 = 1
+ sta menustate     ; menustate |= a
+++ lda tmpptr      ; restore selected:h
sta selected
lda tmpptrh
sta selectedh
rts


; - printentry
; parameters:
;  x = y-coordinate (row)
;  y = x-coordinate (column)
;  selected:h->text to print
; returns:
;  x,y = coord. of next line
;
printentry:
txa
pha
tya
pha         ; store x,y
clc         ; function: set cursor
jsr PLOT    ; set place to print
ldy #0
- lda (selected),y  ; load char
beq +       ; jump if 0
jsr CHROUT  ; print char
iny
cpy #namelen
bne -       ; loop entrylen times
+ pla
tay
pla
tax     ; restore x,y
inx     ; x++ (next row)
rts


!if disknameena + fastscrolle != 0 {
; - printoverentry
; parameters:
;  x = y-coordinate (row)
;  y = x-coordinate (column)
;  tmpptr:h->text to print
; returns:
;  x,y = coord. of line end
;
printoverentry:
clc         ; function: set cursor
jsr PLOT    ; set place to print
ldy #0
- lda (tmpptr),y    ; load char
beq +       ; jump if 0
jsr CHROUT  ; print char
iny
cpy #namelen
bne -
rts
+ lda #listbackgnd
- jsr CHROUT
iny
cpy #namelen
bne -
sec
jsr PLOT
rts
} ; disknameena + fastscrolle != 0


!if statusenabl = 1 {
; - printstatus
;
printstatus:
ldy #statusx
ldx #statusy
clc         ; function: set cursor
jsr PLOT    ; set place to print
ldy #(entrylen-1)
lda (selected),y
tax
ldy #0
- lda filetypes_print,x
jsr CHROUT
inx
iny
cpy #3
bne -
rts
}


!if fastscrolle = 1 {
; - scrolldown
;
scrolldown:
lda menustate
and #$f0
sta menustate
lda #<screen+(listtopy+1)*40+listx
sta scrolldownll
lda #>screen+(listtopy+1)*40+listx
sta scrolldownlh
lda #<screen+(listtopy)*40+listx
sta scrolldownsl
lda #>screen+(listtopy)*40+listx
sta scrolldownsh
ldx #listbottomy-listtopy-1
-- ldy #namelen-1
- 
scrolldownll = *+1
scrolldownlh = *+2
lda $1234,y
scrolldownsl = *+1
scrolldownsh = *+2
sta $1234,y
dey
cpy #$ff
bne -
clc
lda scrolldownll
sta scrolldownsl
adc #40
sta scrolldownll
lda scrolldownlh
sta scrolldownsh
adc #0
sta scrolldownlh
dex
bne --
jsr scrollcheckend      ; check if end
lda menustate
and #2
beq ++
lda #0
sta tmp
lda #<tmp
sta tmpptr
lda #>tmp
sta tmpptrh
++ lda tbllsth          ; check if selected = table last
cmp selectedh
bne +
lda tbllst
cmp selected
bne +
lda menustate
ora #4                  ; last reached, bit 2 = 1
sta menustate
bne +++                 ; if last, don't print
+ ldx #listbottomy-1
ldy #listx
jsr printoverentry
+++ ldy #0
rts


; - scrollup
;
scrollup:
lda menustate
and #$f0
sta menustate
lda #<screen+(listbottomy-2)*40+listx
sta scrollupll
lda #>screen+(listbottomy-2)*40+listx
sta scrolluplh
lda #<screen+(listbottomy-1)*40+listx
sta scrollupsl
lda #>screen+(listbottomy-1)*40+listx
sta scrollupsh
ldx #listbottomy-listtopy-1
-- ldy #namelen-1
- 
scrollupll = *+1
scrolluplh = *+2
lda $1234,y
scrollupsl = *+1
scrollupsh = *+2
sta $1234,y
dey
cpy #$ff
bne -
sec
lda scrollupll
sta scrollupsl
sbc #40
sta scrollupll
lda scrolluplh
sta scrollupsh
sbc #0
sta scrolluplh
dex
bne --
jsr scrollcheckend      ; check if end
lda #>tbl               ; check if selected = table first
cmp selectedh
bne +
lda #<tbl
cmp selected
bne +
lda menustate
ora #1                  ; top reached, bit 0 = 1
sta menustate
+ lda selected
sta tmpptr
lda selectedh
sta tmpptrh
ldx #listtopy
ldy #listx
jsr printoverentry
+++ ldy #0
rts


; - scrollcheckend
; parameters:
;  selected:h
; returns:
;  menustate ( = a )
;  tmpptr
;
scrollcheckend:
lda #<(listbottomy-listtopy-1)*entrylen
sta tmp
lda #>(listbottomy-listtopy-1)*entrylen
sta tmp2
clc
lda selected
adc tmp
sta tmpptr
lda selectedh
adc tmp2
sta tmpptrh
lda tbllsth             ; check if table last >= tmpptr
cmp tmpptrh
bcc +
bne ++
lda tbllst
cmp tmpptr
bcs ++
+ lda menustate
ora #2               ; end reached, bit 1 = 1
sta menustate
++ rts
} ; fastscrolle


!if pleasewaite = 1 {
; - showpleasewait
; parameters:
;  selected:h->text to be shown
;
showpleasewait:
jsr clearlist
ldx #listtopy
ldy #listx
jsr printentry	; print filename
lda selected
pha
lda selectedh
pha
lda #<pleasewait
sta selected
lda #>pleasewait
sta selectedh
jsr printentry	; print "loading"
pla
sta selectedh
pla
sta selected
rts
}


; - parseext
; parameters:
;  tmpptr:h+y->first char of extension
;  extension_list->list of extensions
;  a = extension length
;  x = extension max
; returns:
;  x = offset to next extension (or 0 if not found)
;
parseext:
sty tmp     ; store offset to first char
sta extension_len   ; store len
stx extension_max   ; store max
ldx #0
stx extension_limit ; store offset to extension
-- ldy tmp  ; y->first char of extension
lda extension_limit
tax         ; x->filetypes
clc
extension_len = *+1
adc #3      ; a->end of filetypes
sta extension_limit ; x->filetypes
extension_max = *+1
cpx #$12
beq +       ; extension not found
- lda (tmpptr),y
extension_list = *+1
cmp $1234,x
bne --
iny
inx
extension_limit = *+1
cpx #0
bne -
; match found (x->next extension)
rts
; no match found
+ ldx #0
rts


; - openclose
; parameters:
;  x:y->filename
;  a = filenamelen - 1 (or cmdlen - 4)
;
openclose:
clc
adc #4      ; add "cd:" and the -1
jsr SETNAM
lda #1      ; filenr
ldx device  ; unitnr
ldy #15     ; sec.address (,15)
jsr SETLFS
jsr OPEN    ; OPEN1,device,15,""
; error detection would be nice :)
lda #1
jsr CLOSE   ; CLOSE1
rts


; - loadlist
; parameters:
;  selected:h->text to be shown
;  tmpptr:h->dir/diskname as petscii
;  disknamepetlen = length of dir/diskname - 1
; extra parameters: (for firmware = 0)
;  subdirdepth = 0 if in root
;  menustate & 0x80 = 0 if outside d64
; returns:
;  tbl = the list
;  tbllst:h->end of list
;  selected->top of list (or remembered position)
;
loadlist:
!if pleasewaite = 1 {
; clear list & show info
jsr showpleasewait
}

; prepare for extension parsing
lda #<filetypes
sta extension_list
lda #>filetypes
sta extension_list+1

; send open command
ldx tmpptr
ldy tmpptrh
lda disknamepetlen
jsr openclose

; load the list
lda #1              ; filenr
ldx device          ; unitnr
ldy #0              ; sec.address (0 = reloc)
jsr SETLFS
lda #1              ; filenamelen
ldx #<disklist
ldy #>disklist      ; x:y->filename ("$")
jsr SETNAM
lda #0              ; a = 0: load
ldx #<tbl
stx selected
stx tmpptr
ldy #>tbl           ; load address = tbl 
sty selectedh       ; selected:h->2nd entry in list
iny                 ; load address = tbl+256
sty tmpptrh         ; tmpptr:h->load address
jsr LOAD

; - parse list
; skip first 6 bytes
clc
lda tmpptr
adc #6
sta tmpptr
bcc +
inc tmpptrh

+
!if disknameena = 1 {
; print disk name
lda #18
jsr CHROUT
ldx #disknamey
ldy #disknamex
jsr printoverentry
lda #146
jsr CHROUT
}

!if firmware = 0 {
; skip first two entries "." and ".." if not in root or d64
ldx #0
lda subdirdepth
beq +
bit menustate
bmi +
inx
inx
+
stx tmp3
}

loadlist_loop: 
; search 0
ldy #0
- lda (tmpptr),y
beq +       ; if 0 -> next line
inc tmpptr
bne -
inc tmpptrh
bne -       ; loop until zero

; next entry (skips "_" on first time), set tbllst = current
+ clc
lda selected
sta tbllst
adc #<entrylen
sta selected
lda selectedh
sta tbllsth
adc #>entrylen
sta selectedh

; skip 5 bytes (0 + filelen&type)
+ clc
lda tmpptr
adc #5
sta tmpptr
bcc +
inc tmpptrh

; search for " (or 0 for last)
+
- lda (tmpptr),y
beq +++     ; if 0 -> "BLOCKS FREE" -> finished
cmp #quotechar
beq ++      ; if " -> start of filename found
inc tmpptr
bne -
inc tmpptrh
bne -       ; loop until zero

; error - no " or 0 found.

; finished
+++
; put end mark
sta (selected),y
lda #<tbl
sta selected
lda #>tbl
sta selectedh
rts

; copy name until last "
++ iny       ; y = 1, skip first "
ldx #0
- lda (tmpptr),y
cmp #quotechar
beq +       ; if ", ok
dey         ; y--, for selected
sta (selected),y
iny         ; restore y
iny         ; next y
bne -

; error - no " found.

; 0-pad to entrylen
+ lda #0
sty tmp2    ; tmp2 -> "
dey
- cpy #entrylen
beq +
sta (selected),y
iny
bne -

; skip ' ''s
+ ldy tmp2
iny         ; y++, skip last "
ldx #0
- lda (tmpptr),y
cmp #' '
bne +       ; jump if not ' '
iny         ; next y
bne -

; skip possible '*'
+ cmp #'*'
bne +
iny

; parse filetype
+ lda #3      ; extension len
ldx #filetypes_max  ; extension max
jsr parseext

; save extension to entry
ldy #(entrylen-1)
txa
sta (selected),y

!if firmware = 0 {
; skip first two entries "." and ".." if not in root or d64
ldx tmp3
beq +
dec tmp3
sec
lda selected
sbc #<entrylen
sta selected
lda selectedh
sbc #>entrylen
sta selectedh
}
+ jmp loadlist_loop


; --- Variables

; device number (8,9,...)
device !by hwdevicenum

; last joystick state (for edge detection)
lastjoy !by $ff


; --- Strings

;    |---------0---------0---------0--------|

extensions
!tx "d64",0
!tx "d71",0
!tx "d81",0
!tx "m2i",0
extensions_max = * - extensions

filetypes_print
!tx "cd",leftarrowchar
filetypes
!tx "dir"
!tx "del"
!tx "seq"
!tx "prg"
!tx "usr"
!tx "rel"
!tx "cbm"
filetypes_max = * - filetypes

!if pleasewaite = 1 {
pleasewait
!tx "loading...",0
}

disklist
!tx "$"

diskcmdroot
!tx "cd//",0

diskcmdcd   ; "cd:0123456789abcdef",0
!tx "cd:"
disknamepet ; "0123456789abcdef",0
!tx 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0


diskcmdexit ; "cd:_"
!tx "cd:"


; --- Program table

tbl
; "prev dir" entry is always present
!tx leftarrowchar,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; name
!by 0 ; type

progsize = * - entry
