#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <ftdi.h>

int product_id = 0x8738;

  int deviceNumber = 0;

int init(struct ftdi_context *p_ftdic)
{
  if (ftdi_init(p_ftdic)) {
    fprintf(stderr, "can't initialize ftdi_context");
    return 1;
  }
  return 0;
}

int fail(struct ftdi_context *p_ftdic)
{
  int rc = 0;
  char *err;
  err = ftdi_get_error_string(p_ftdic);
  if (strncmp(err, "all fine", 8)) {
    fprintf(stderr, "libftdi: %s\n", err);
    rc = 1;
  }
  ftdi_deinit(p_ftdic);
  return rc;
}

int listDevices(struct ftdi_context *p_ftdic,
                struct ftdi_device_list *p_deviceList, int product_id)
{
  struct ftdi_device_list *p_currentDevice;
  char p_manufacturer[128], p_description[128], p_serial[128];
  int i = 0;
  if (ftdi_usb_find_all(p_ftdic, &p_deviceList, 0x0403, product_id) < 0) {
    fprintf(stderr, "There was a problem listing the devices.\n");
    fail(p_ftdic);
    return 1;
  }
  if (p_deviceList == NULL) {
    printf("No devices found.\n Check connection and access permissions!\n");
    return 1;
  }
  p_currentDevice = p_deviceList;
  if (p_currentDevice != NULL) {
    if (ftdi_usb_get_strings(p_ftdic, p_currentDevice->dev,
      p_manufacturer, 128, p_description, 128,
    p_serial, 128) < 0) {
      ftdi_list_free(&p_deviceList);
      ftdi_deinit(p_ftdic);
      return 1;
    }
    printf("Device: %d, Manufacturer: %s, Description: %s, Serial: %s\n",
      i, p_manufacturer, p_description, p_serial);
    p_currentDevice = p_currentDevice->next;
    ++i;
  }
  ftdi_list_free(&p_deviceList);
  return 0;
}

int d81 = 0;

int nrTracks=40;

static int sectorsPerTrack[]={ 21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,
							   19,19,19,19,19,19,19,
							   18,18,18,18,18,18,
							   17,17,17,17,17,
							   17,17,17,17,17 };
							   
static int sectorsPerTrack71[]={ 21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,
							   19,19,19,19,19,19,19,
							   18,18,18,18,18,18,
							   17,17,17,17,17,
                                21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,
							   19,19,19,19,19,19,19,
							   18,18,18,18,18,18,
							   17,17,17,17,17							   							   
							    };

char* filetypes[]={"DEL\0","SEQ\0","PRG\0","USR\0","REL\0","CBM\0"};

unsigned char c64filename[20];

int linearSector(int track, int sector)
{
int i;

        int* spt = sectorsPerTrack;
        if (nrTracks == 70)
        {
                spt = sectorsPerTrack71;
        }

	if ((track<1) || (track>nrTracks))
	{
		fprintf(stderr, " - Illegal track %d\n", track);
//		exit(-1);
                return -1;
        
	}

        if (!d81)
        {
        	if ((sector<0) || (sector>=spt[track-1]))
        	{
        		fprintf(stderr, " - Illegal sector %d for track %d (max is %d)\n", sector, track, sectorsPerTrack[track-1]);
//        		exit(-1);
                        return -1;
        	}
        }
        else if (sector>39)
        {
		fprintf(stderr, " - Illegal sector %d (max is %d)\n", sector, 39);
//		exit(-1);
                return -1;
        }

        if (d81)
        {
                return (track-1)*40 + sector;
        }

	int linearSector=0;
	for (i=0;i<track-1;i++)
		linearSector+=spt[i];
	linearSector+=sector;

	return linearSector;
}

int off(int track, int sector)
{
        int tr = linearSector(track, sector);
        if (tr != -1)
        {
                return tr*256;
        }
        return -1;
}

int usednum;
unsigned char usedtr[1024];
unsigned char usedse[1024];

struct ftdi_context ftdic;
struct ftdi_device_list *p_deviceList = NULL;

int ftdiwrite(unsigned char * buf, int len)
{
        int i;
        int written;
        
        for (i = 0; i < len; i++)
        {
                written = 0;
                while (written != 1)
                {
                        written = ftdi_write_data(&ftdic, buf + i, 1);
                }
        }
        
        return len;
}

int ftdiread(unsigned char * buf, int len)
{
        int i;
        int written;
        
        for (i = 0; i < len; i++)
        {
                written = 0;
                while (written != 1)
                {
                        written = ftdi_read_data(&ftdic, buf + i, 1);
                }
        }
        
        return len;
}

  unsigned char * buf;
  unsigned char * buf2;
  unsigned char * filebuf;
  unsigned char checksum;
  unsigned char * bufread;
  unsigned char * bufstart;   
  int written;
  int fileptr;
  unsigned char ft;
  int entoff;

int sendfile()
{
        int i;
        
        printf(" - Len: %6d bytes. Sending file. Bytes left:", fileptr);
        
        bufstart[0] = ft;        // filetype
        written = ftdiwrite(bufstart, 1);

        // filename
        written = ftdiwrite(buf+entoff+0x05, 16);

        // filelen in 3 bytes
        bufstart[0] = (unsigned char) (fileptr&0xff);        // len lo
        bufstart[1] = (unsigned char) ((fileptr>>8)&0xff);   // len hi                                                
        bufstart[2] = (unsigned char) ((fileptr>>16)&0xff);  // len hi hi
        written = ftdiwrite(bufstart, 3);  
        
        // calc checksum                                                  
        checksum = 0;
        for (i=0; i < fileptr; i++)
        {
              checksum = checksum + filebuf[i];
        }
        bufstart[0] = checksum;
        written = ftdiwrite(bufstart, 1);

        // data
        for (i=0; i < fileptr; i++)
        {
                ftdiwrite(filebuf+i,1);
                printf("%6d%c%c%c%c%c%c",fileptr-i,8,8,8,8,8,8);
        }
        printf("%c%c%c%c%c%c%c%c%c%c%cDone.                    \n",8,8,8,8,8,8,8,8,8,8,8);
        //written = ftdiwrite(filebuf, fileptr);
        
        // get ack
        written = ftdiread(bufread, 1);
        if (bufread[0] != 0xff)
        {
                printf("Error on the C64 side ... exiting...\n");
                return 1;
        }
        return 0;
}

void sendindicator(int format, int track, int sector)
{
        // send the position of the '*' on the c64 screen
        int add;
        if (format == 80)
        {
                // d81
                add = 0x0400 + (3+(sector/2))*40 + ((track-1)/2);
                unsigned char vis;
                if (track%2)
                {
                        // 1,2
                        if (sector%2)
                        {
                                vis = 0x32;
                        }
                        else
                        {
                                vis = 0x31;
                        }
                }
                else
                {
                        // 3,*
                        if (sector%2)
                        {
                                vis = 0x2a;
                        }
                        else
                        {
                                vis = 0x33;
                        }
                }
                bufstart[2] = vis;     // 1,2,3,*
        }
        else
        {
                // d64
                add = 0x0400 + (3+sector)*40 + (track-1);
                bufstart[2] = 0x2a;     // '*'
        }
        bufstart[0] = (unsigned char) (add&0xff);
        bufstart[1] = (unsigned char) ((add>>8)&0xff);
        written = ftdiwrite(bufstart,3);        // send over the coordinates and character
}                                

void printusage()
{
   printf("Usage: EF3USB.exe command file [options]\n");
   printf("        commands: e[xecute] file.prg|p00                   - execute prg on c64\n");
   printf("                  c[opy]    file.prg|p00|d64|d81|d71       - copy files to c64\n");
   printf("                  x[fer]    [p00]                          - copy files from c64\n");
   printf("                  w[rite]   file.d64|d81 [verify] [kernal] - write image on c64\n");
   printf("                  r[ead]    file.d64|d81 [40] [kernal]     - read image from c64\n");
   printf("                  d[ir]     file.d64|d81|d71               - display dir of file and check it\n");
   printf("                  f[ormat]  [40]                           - turbo format 1541 floppy\n");
   printf("                  t[est]                                   - test the usb connection\n");
   exit(1);
}

void startcommand(unsigned char cmd)
{
  // SYNC BYTES
  bufstart[0] = 0xB3;
  bufstart[1] = 0x68;
  bufstart[2] = 0x92;
  
  bufstart[3] = cmd;
  
  written = ftdiwrite(bufstart, 4);         // send sync & command
  
  written = ftdiread(bufstart, 1);          // get back ACK
}

int main(int argc, char *argv[])
{
  char *fname = NULL;
  FILE *fp;
  int read;
  
  int i;
  int len;
  int batch;
  int mode = 0;
  int mode40 = 0;
  int command = -1;
  
  char p00start[8] = "C64File\0";
  
  printf("EF3 USB Client v1.7\n");
  if (argc < 2)
  {
        printusage();
  }
  
  if (init(&ftdic)) return 1;
  if (listDevices(&ftdic, p_deviceList, product_id)) return 1;

  if (ftdi_usb_open_desc_index(&ftdic, 0x0403, product_id, NULL, NULL,
    deviceNumber))
    return 1;
  while (ftdi_usb_reset(&ftdic)) {
    fprintf(stderr, "%s", ftdi_get_error_string(&ftdic));
    usleep(1000000);
  }
  
  int verify = 0;
  
  printf("\n"); 
  switch(argv[1][0])
  {
        case 'e': command = 0;
                  printf(" - EXECUTE FILE\n");
                  if (argc != 3)
                  {
                        printusage();
                  }
                  fname = argv[2];
                  break;
        case 'c': command = 1;
                  printf(" - COPY FILE(S) TO C64\n");
                  if (argc != 3)
                  {
                        printusage();
                  }
                  fname = argv[2];
                  break;
        case 'w': command = 2;
                  printf(" - WRITE IMAGE\n");
                  if (argc == 5)
                  {
                        mode = 1;
                        verify = 1;
                  }
                  else if (argc == 4)
                  {
                        if (argv[3][0] == 'k')
                        {
                                mode = 1;
                        }
                        else
                        {
                                verify = 1;
                        }
                  }
                  fname = argv[2];
                  break;
        case 'r': command = 3;
                  printf(" - READ IMAGE\n");
                  if (argc == 5)
                  {
                        mode = 1;
                        mode40 = 1;
                  }
                  else if (argc == 4)
                  {
                        if (argv[3][0] == 'k')
                        {
                                mode = 1;
                        }
                        else
                        {
                                mode40 = 1;
                        }
                  }
                  fname = argv[2];
                  break;
        case 'd': command = 1;
                  printf(" - DIR\n");
                  if (argc != 3)
                  {
                        printusage();
                  }
                  fname = argv[2];
                  mode = 1;
                  break;        
        case 'f': command = 6;
                  printf(" - TURBO FORMAT\n");
                  if (argc == 3)
                  {
                        if (argv[2][0] != '4')
                        {
                                printusage();
                        }
                        mode40 = 1;
                  }
                  break;        
        case 't': command = 5;
                  printf(" - TEST USB CONNECTION\n");
                  break;
        case 'x': command = 7;
                  printf(" - COPY FILE(S) FROM C64\n");
                  if (argc == 3)
                  {
                        mode = 1;
                  }
                  break;
        default: printusage();
  }
  printf("\n");

  buf = (unsigned char *) malloc(0x1000000);
  filebuf = (unsigned char *) malloc(0x1000000);
  bufread = (unsigned char *) malloc(30);
  bufstart = (unsigned char *) malloc(30); 

  if (fname != NULL && command != 3)
  {  
        if (!(fp = fopen(fname, "rb")))
        {
                fprintf(stderr, "can't open %s\n", fname);
                return 0;
        }
        read = fread (buf, 1, 0x1000000, fp);
        fclose(fp);
  }
  
  if (command == 7)
  {
        // COPY FILES FROM C64
        startcommand(0x07);
        
        printf("- Waiting for files from C64...\n");

        written = ftdiread(bufstart,1);                         // get status
        
        int fnlen;
        while (bufstart[0] == 0)
        {
                for (i=0; i < 19; i++)
                {
                        c64filename[i]=0;
                }
                written = ftdiread(bufstart,1);                         // get file length
                fnlen = bufstart[0];
                written = ftdiread(c64filename, fnlen);           // get filename
                        
                printf("Transfering %-17s  Bytes: ", c64filename);
                
                int ok = 0;
                int len=0;
                while (!ok)
                {
                        written = ftdiread(buf+len,1);                 // get byte
                        len++;
                        printf("%6d%c%c%c%c%c%c",len,8,8,8,8,8,8);
                        written = ftdiread(bufstart, 1);          // status
                        ok = bufstart[0];
                }
                printf("\n");

                // fix filename
                for(i=0; i < fnlen; i++)
                {
                        if (c64filename[i]>=0x20 && c64filename[i]<=0x5f)
                        {
                                bufstart[i]=c64filename[i];
                        }
                        else
                        {
                                bufstart[i]=0x5f;
                        }
                }
                
                bufstart[fnlen]='.';
                bufstart[fnlen+1]='P';
                bufstart[fnlen+4]=0;
                if (mode == 0)
                {
                        // PRG
                        bufstart[fnlen+2]='R';
                        bufstart[fnlen+3]='G';
                }
                else
                {
                        // P00
                        bufstart[fnlen+2]='0';
                        bufstart[fnlen+3]='0';
                }                
                
                if (!(fp = fopen(bufstart, "wb")))
                {
                        printf("Can't open %s for writing !\n", bufstart);
                }
                else
                {
                        if (mode == 1)
                        {
                                fwrite(p00start, 1 , 8, fp);
                                fwrite(c64filename, 1, 18, fp);
                        }
                        fwrite (buf, 1, len, fp);
                        fclose(fp);                
                }

                written = ftdiread(bufstart,1);                         // get status
        }
        printf("- End of transfer\n");
  }
  else if (command == 6)
  {
        // TURBO FORMAT DISK
        startcommand(0x06);
        
        bufstart[0] = 35;                   // normal mode
        if (mode40 == 1)
        {
                bufstart[0] = 40;
        }
        written = ftdiwrite(bufstart,1);
        printf("Formating disk with %d tracks...\n", bufstart[0]);
        written = ftdiread(bufstart,1);
  }
  else if (command == 2)
  {
        // WRITE IMAGE

          int format = 0;
          
          if (read == 174848 || read == 175531)
          {
                format = 35;
          }
          else if (read == 196608 || read == 197376)
          {
                format = 40;
          }
          else if (read == 819200 || read == 822400)
          {
                format = 80;
          }
          
          if (format == 40 && mode == 1)
          {
                printf("40 tracks D64 is not supported in Kernal mode!\n");
                goto exitpoint;
          }
          
          if (format == 0)
          {
                printf("Unsupported Image format!\n");
                goto exitpoint;
          }
          else
          {
                if (format == 35 || format == 40)
                {
                        printf (" - .D64 format %d tracks.\n\n", format);
                }
                else
                {
                        printf (" - .D81 format %d tracks.\n\n", format);        
                        mode = 1;
                }
          }
          
        int track;
        int sector;
        int pos = 0;
        
        printf("Transferring image to C64. ");  
        
        if (mode == 1)
        {
                  // KERNAL WRITE
                  
                  startcommand(0x02);
                  
                  bufstart[0] = 0x00;                   // kernal write
                  written = ftdiwrite(bufstart,1);

                  if (verify)
                  {
                          bufstart[0] = 3;
                  }
                  else
                  {
                          bufstart[0] = 0;              // verify retries #
                  }
                  written = ftdiwrite(bufstart,1);
                  
                  for (track=1; track < format+1; track++)
                  {
                        int numsec;
                        if (format != 80)
                        {
                                numsec = sectorsPerTrack[track-1];
                        }
                        else
                        {
                                numsec = 40;
                        }
                        for (sector=0; sector < numsec; sector++)
                        {
                                printf("T:%2d S:%2d%c%c%c%c%c%c%c%c%c",track,sector,8,8,8,8,8,8,8,8,8);
                                
                                bufstart[0] = 0xff;                     // indicate that we are transferring a sector
                                written = ftdiwrite(bufstart, 1);
                                
                                sprintf(bufstart,"%2d %2d",track,sector);
                                written = ftdiwrite(bufstart, 5);       // send over the string containing track & sector
                                
                                // calc checksum                                                  
                                checksum = 0;
                                for (i=0; i < 256; i++)
                                {
                                        checksum = checksum + buf[pos+i];
                                }
                                bufstart[0] = checksum;
                                written = ftdiwrite(bufstart, 1);                 
                                
                                written = ftdiwrite(buf+pos, 256);      // send the sector over
                                pos += 256;

                                sendindicator(format, track, sector);                                
                                
                                // get ack
                                written = ftdiread(bufread, 1);
                                if (bufread[0] != 0xff)
                                {
                                        printf("Error on the C64 side ... exiting...\n");
                                        goto exitpoint;
                                }
                        }
                  }
                  bufstart[0] = 0;        // end of transfer
                  written = ftdiwrite(bufstart, 1);
                  printf("\nDone\n");
                  
        }
        else
        {
                // TURBO WRITE

                  startcommand(0x02);
                  
                  bufstart[0] = 0xff;                   // turbo write
                  written = ftdiwrite(bufstart,1);

                  if (verify)
                  {
                          bufstart[0] = 3;
                  }
                  else
                  {
                          bufstart[0] = 0;              // verify retries #
                  }
                  written = ftdiwrite(bufstart,1);

                  for (track=1; track < format+1; track++)
                  {
                        int numsec;
                        if (format != 80)
                        {
                                numsec = sectorsPerTrack[track-1];
                        }
                        else
                        {
                                numsec = 40;
                        }
                        for (sector=numsec-1; sector >=0 ; sector--)
                        {
                                printf("T:%2d S:%2d%c%c%c%c%c%c%c%c%c",track,sector,8,8,8,8,8,8,8,8,8);
                                
                                bufstart[0] = 0xff;                     // indicate that we are transferring a sector
                                written = ftdiwrite(bufstart, 1);
                                
                                written = ftdiwrite(buf + off(track,sector), 256);      // send the sector over
                
                                bufstart[0] = (unsigned char) track;
                                bufstart[1] = (unsigned char) sector;                
                                written = ftdiwrite(bufstart, 2);       // send over the string containing track & sector
                                
                                sendindicator(format, track, sector);                                
                                
                                // get ack
                                written = ftdiread(bufread, 1);
                                if (bufread[0] != 0xff)
                                {
                                        printf("Error on the C64 side ... exiting...\n");
                                        goto exitpoint;
                                }
                        }
                  }
                  bufstart[0] = 0;        // end of transfer
                  written = ftdiwrite(bufstart, 1);
                  printf("\nDone\n");
                     
        }
  }
  else if (command == 3)
  {
        // READ IMAGE
        
        int fnamelen = strlen(fname);
        int format = 0;
        if (fnamelen < 4 || fname[fnamelen-4]!='.')
        {
              format = 0;
        }
        else if (fname[fnamelen-1]=='1' && fname[fnamelen-2]=='8')
        {
                mode =1;
                format = 80;
        }
        else if (fname[fnamelen-1]=='4' && fname[fnamelen-2]=='6')
        {
                if (mode40 == 1)
                {
                        format = 40;
                }
                else
                {
                        format = 35;
                }
        }
        if (format == 0 || (format == 80 && mode == 0))
        {
                printf("%d Unsupported format or mode!\n", format);
                goto exitpoint;
        }
        
        if (mode == 1 && format == 40)
        {
                printf("40 tracks D64 is not supported in Kernal mode!\n");
                goto exitpoint;
        }
        
        if (format == 35 || format == 40)
        {
                printf (" - .D64 format %d tracks.\n\n", format);
        }
        else
        {
                printf (" - .D81 format %d tracks.\n\n", format);        
        }
        
        int track;
        int sector;
        int pos = 0;
        
        printf("Transferring image from C64. ");  
        
        if (mode == 1)
        {
                  // KERNAL READ
                  
                  startcommand(0x03);
                  
                  bufstart[0] = 0x00;                   // kernal read
                  written = ftdiwrite(bufstart,1);
                  
                  for (track=1; track < format+1; track++)
                  {
                        int numsec;
                        if (format != 80)
                        {
                                numsec = sectorsPerTrack[track-1];
                        }
                        else
                        {
                                numsec = 40;
                        }
                        for (sector=0; sector < numsec; sector++)
                        {
                                printf("T:%2d S:%2d%c%c%c%c%c%c%c%c%c",track,sector,8,8,8,8,8,8,8,8,8);
                                
                                bufstart[0] = 0xff;                     // indicate that we are transferring a sector
                                written = ftdiwrite(bufstart, 1);
                                
                                sprintf(bufstart,"%2d %2d",track,sector);
                                written = ftdiwrite(bufstart, 5);       // send over the string containing track & sector
                                
                                written = ftdiread(buf+pos, 256);      // send the sector over
                                
                                // calc checksum                                                  
                                checksum = 0;
                                for (i=0; i < 256; i++)
                                {
                                        checksum = checksum + buf[pos+i];
                                }
                                bufstart[0] = checksum;
                                written = ftdiwrite(bufstart, 1);     // send our checksum over
                                
                                pos += 256;
                                
                                sendindicator(format, track, sector);
                                
                                // get ack
                                written = ftdiread(bufread, 1);
                                if (bufread[0] != 0xff)
                                {
                                        printf("Error on the C64 side ... exiting...\n");
                                        goto exitpoint;
                                }
                        }
                  }
                  bufstart[0] = 0;        // end of transfer
                  written = ftdiwrite(bufstart, 1);
                  printf("\nDone... Writing image with %d bytes length.\n", pos);
                
                
                   if (!(fp = fopen(fname, "wb"))) {
                    fprintf(stderr, "can't open %s\n", fname);
                    return 0;
                  }
                
                  written = fwrite (buf, 1, pos, fp);
                  fclose(fp);
                   
        }
        else
        {
                // TURBO READ

                  startcommand(0x03);
                  
                  bufstart[0] = 0xff;                   // turbo read
                  written = ftdiwrite(bufstart,1);
                  int size = 0;

                  for (track=1; track < format+1; track++)
                  {
                        int numsec;
                        if (format != 80)
                        {
                                numsec = sectorsPerTrack[track-1];
                        }
                        else
                        {
                                numsec = 40;
                        }
                        for (sector=numsec-1; sector >=0; sector--)
                        {
                                printf("T:%2d S:%2d%c%c%c%c%c%c%c%c%c",track,sector,8,8,8,8,8,8,8,8,8);
                                
                                bufstart[0] = 0xff;                     // indicate that we are transferring a sector
                                written = ftdiwrite(bufstart, 1);
                
                                bufstart[0] = (unsigned char) track;
                                bufstart[1] = (unsigned char) sector;                
                                written = ftdiwrite(bufstart, 2);       // send over the string containing track & sector
                                
                                written = ftdiread(buf + off(track,sector), 256);      // send the sector over
                                
                                size = size+256;
                                
                                sendindicator(format, track, sector);
                                
                                // get ack
                                written = ftdiread(bufread, 1);
                                if (bufread[0] != 0xff)
                                {
                                        printf("Error on the C64 side ... exiting...\n");
                                        goto exitpoint;
                                }
                        }
                  }
                  bufstart[0] = 0;        // end of transfer
                  written = ftdiwrite(bufstart, 1);
                  printf("\nDone... Writing image with %d bytes length.\n", size);  

                   if (!(fp = fopen(fname, "wb"))) {
                    fprintf(stderr, "can't open %s\n", fname);
                    return 0;
                  }
                
                  written = fwrite (buf, 1, size, fp);
                  fclose(fp);
                   
        }
                   
  }
  else if (command == 5)
  {
        // TEST
        
          buf2 = (unsigned char *) malloc(0x10); 
          printf("Started Testing... (make sure all 4 jumpers are in DATA position!)\n");
        
          startcommand(0x05);

          int j;
          
          written = ftdiread(buf, 1);

          for (j=0; j < 64; j++)
          {
                  for (i=0; i < 256; i++)
                  {
                        buf[0] = (unsigned char) i;
                        written = ftdi_write_data(&ftdic, buf, 1);
                        if (written != 1)
                        {
                                printf("ERROR - could not write all test bytes to the device!\n");
                                return 1;
                        }
                        written = ftdi_read_data(&ftdic, buf2, 1);
                        if (written != 1)
                        {
                                printf("ERROR - could not read back all test bytes to the device!\n");
                                return 1;
                        }
                        if (buf2[0] != (unsigned char) i)
                             {
                                printf("ERROR - Read byte ($%02X) does not match written byte ($%02X) !\n", buf2[0], i);
                                return 1;
                        }        
                  }
          }
          
          free(buf2); 
          printf("Testing was Succesfull ! Restart C64...\n");
     }
  else if (command == 0)
  {
        // EXECUTE

          // P00 ?
          int fnamelen = strlen(fname);
          if ((fname[fnamelen-3]=='P' || fname[fnamelen-3]=='p') && fname[fnamelen-2]=='0')
          {
            read = read-0x1a;    // new filelength
            for (i=0; i <read; i++)      // copy file to filebuf
            {
                buf[i] = buf[0x1A + i];
            }
          }

          buf2 = (unsigned char *) malloc(((int)read)*2);         
        
          checksum = 0;
          
          for (i=0; i < read; i++)
          {
                buf2[i*2] = buf[i] & 0xF2;
                buf2[i*2+1] = ((unsigned char) (buf[i] << 4)) & 0xF2;
                if (i>1)
                {
                        checksum = checksum + buf[i];
                }
          }
          
          startcommand(0x00);

          bufstart[0] = 0xFF;        // Check for 4 or 8 bit !
          bufstart[1] = 0x00;
        
          written = ftdi_write_data(&ftdic, bufstart, 2);
        
          if (written != 2)
          {
                printf("ERROR - could not initiate transfer!\n");
                return 1;
          } 
                          
          written = ftdiread(bufread, 1); 
          
          if (written != 1)
          {
                printf("ERROR - could not read back status byte!\n");
                return 1;
          } 
          
          bufread[0] = bufread[0] & 0xF0;       // just top 4 bits
          
          if (bufread[0] == 0x10)
          {
                // 8 bit transfer
        
                printf("Starting 8-bit transfer...\n");
        
                bufstart[0] = checksum;                                    // checksum
        
                written = ftdi_write_data(&ftdic, bufstart, 1);
        
                bufstart[0] = (unsigned char) (read&0xff);                 // len low
                bufstart[1] = (unsigned char) ((read>>8)&0xff);            // len high
        
                written = ftdi_write_data(&ftdic, bufstart, 2);
        
                written = ftdi_write_data(&ftdic, buf, read);
                
                if (written == -1)
                {
                      printf("ERROR - Could not transfer data !\n");
                      return 1;
                } 
                printf("Wrote %d bytes\n", written);
          }
          else
          {
                // 4 bit transfer
                
                printf("Starting 4-bit transfer...\n");
        
                bufstart[0] = checksum;                                    // checksum
                bufstart[1] = (unsigned char) (checksum<<4);
        
                written = ftdi_write_data(&ftdic, bufstart, 2);
        
                bufstart[0] = (unsigned char) (read&0xff);                 // len low
                bufstart[1] = (unsigned char) ((read&0xff)<<4);
                bufstart[2] = (unsigned char) ((read>>8)&0xff);            // len high
                bufstart[3] = (unsigned char) (((read>>8)&0xff)<<4);
        
                written = ftdi_write_data(&ftdic, bufstart, 4);
        
                written = ftdi_write_data(&ftdic, buf2, read*2);
                
                if (written == -1)
                {
                      printf("ERROR - Could not transfer data !\n");
                      return 1;
                } 
                printf("Wrote %d half-bytes\n", written);
        }                 
        free(buf2); 
  }
  else if (command == 1)
  {
        // COPY

          unsigned char nexttr = 18;
          unsigned char nextse = 1;
          
          int prgmode = 0;
          
          int fnamelen = strlen(fname);
          if (fnamelen < 5 || fname[fnamelen-4]!='.')
          {
                prgmode = 1;
          }
          else if (fname[fnamelen-1]=='1' && fname[fnamelen-2]=='8')
          {
                d81 = 1;
                nexttr = 40;
                nextse = 03;
                nrTracks = 80;
          }
          else if (fname[fnamelen-1]=='1' && fname[fnamelen-2]=='7')
          {
                nrTracks = 70;
          }
          else if ((fname[fnamelen-3]=='P' || fname[fnamelen-3]=='p') &&
                   (fname[fnamelen-2]=='R' || fname[fnamelen-2]=='r') &&
                   (fname[fnamelen-1]=='G' || fname[fnamelen-1]=='g'))
          {
                prgmode = 1;
          }
          else if ((fname[fnamelen-3]=='P' || fname[fnamelen-3]=='p') &&
                    fname[fnamelen-2]=='0')
          {
                prgmode = 2;
          }
          
          if (mode == 0)
          {
                  startcommand(0x01);
          }
          
          if (prgmode != 0)
          {
                if (mode != 0)
                {
                        printf("DIR only supported on disk images!\n");
                        goto exitpoint;
                }
                ft = 0x02;      // PRG filetype
                
                //buf+entoff+0x05 = filename
                
                if (prgmode == 2)
                {
                        // P00
                        entoff = 0x08 - 0x05; //filename
                        for (i=0; i < 16; i++)
                        {
                                if (buf[entoff+0x05+i] == 0)
                                {
                                        buf[entoff+0x05+i] = 0xA0;      // fix filename
                                }
                        }
                        fileptr = read-0x1a;    // filelength
                        for (i=0; i <fileptr; i++)      // copy file to filebuf
                        {
                                filebuf[i] = buf[0x1A + i];
                        }
                }
                else
                {
                        // PRG
                        fileptr = read;
                        entoff = fileptr;
                        int stop = 0;
                        for (i=0; i < 16; i++)
                        {
                                if (i>=strlen(fname) || stop)
                                {
                                        buf[entoff+0x05+i]=0xA0;            // pad
                                }
                                else
                                {
                                        if (fname[i] == '.' && i==strlen(fname)-4)
                                        {
                                                stop = 1;
                                                buf[entoff+0x05+i]=0xA0;            // pad
                                        }
                                        else if (fname[i] < 0x60)
                                        {
                                                buf[entoff+0x05+i] = fname[i];
                                        }
                                        else
                                        {
                                                buf[entoff+0x05+i] = fname[i]-0x20;
                                        }
                                }
                        }
                        for (i=0; i <fileptr; i++)      // copy file to filebuf
                        {
                                filebuf[i] = buf[i];
                        }
                }
                for (i=0; i < 16; i++)
                {
                        c64filename[i] = buf[entoff+0x05+i];
                        if (c64filename[i] == 0xA0)
                        {
                                c64filename[i] = ' ';
                        }
                }
                c64filename[i] = 0;
                
                printf(" PRG %s %3d", c64filename, fileptr/256);
        
                if (sendfile())
                {
                        goto exitpoint;
                }
          }
          else
          {
                  int tt = 0x90;
                  if (d81 == 1)
                  {
                        tt = 0x04;
                  }
                  for (i=0; i < 23; i++)
                  {
                          c64filename[i] = buf[off(nexttr,0)+tt+i];
                          if (c64filename[i] == 0xA0)
                          {
                                c64filename[i] = ' ';
                          }
                  }
                  c64filename[16] = '"';
                  c64filename[17] = ',';
                  printf("    \"%s\n",c64filename);
                  
                  while (nexttr != 0)
                  {
                          int diroff = off(nexttr,nextse);
                          if (diroff == -1)
                          {
                                goto exitpoint;
                          }
                          nexttr = buf[diroff+0];
                          nextse = buf[diroff+1];
                //          printf("lin: $%x next tr %d se %d\n", diroff, nexttr, nextse);
                          
                          int pos = 0;
                          while (pos < 8)
                          {
                                entoff = diroff + pos*0x20;
                                ft = buf[entoff+0x02];
                                int locked = 0;
                                int splat = 0;
                                if (ft&0x40)
                                {
                                        locked = 1;
                                }
                                if (ft&0x80)
                                {
                                        splat = 1;
                                }
                                ft = ft & 0x07;
                                unsigned char lc = ' ';
                                if (locked)
                                {
                                        lc = '>';
                                }
                                else if (splat)
                                {
                                        lc = ' ';
                                }
                                unsigned char filetr = buf[entoff+0x03];
                                unsigned char filese = buf[entoff+0x04];
                                int sizese = buf[entoff+0x1e] + buf[entoff+0x1f]*256;
                                
                                for (i=0; i < 16; i++)
                                {
                                        c64filename[i] = buf[entoff+0x05+i];
                //                        printf("%d\n", c64filename[i]);
                                        if (c64filename[i] == 0xA0)
                                        {
                                                c64filename[i] = ' ';
                                        }
                                }
                                c64filename[i] = 0;
                                
                                if (!(ft == 00 && !locked && !splat))
                                {                
                                        printf("%c%s %s %3d", lc, filetypes[ft], c64filename, sizese);
                                        int valid = 1;
                                        if (!d81 && filetr == 18 && (filese == 0 || filese == 1))
                                        {
                                                valid = 0;
                                        }
                                        if (valid && (ft == 0x02 || ft == 0x01))  // PRG or SEQ
                                        {
                                                usednum = 0;
                                                int ok = 1;
                                                int corrupted = 0;
                                                unsigned char currtr = filetr;
                                                unsigned char currse = filese;
                                                fileptr = 0;
                                                while (ok)
                                                {
                                                        for (i=0; i < usednum; i++)
                                                        {
                                                                if (usedtr[usednum] == filetr && usedse[usednum] == filese)
                                                                {
                                                                        corrupted = 1;
                                                                        ok = 0;
                                                                        break;
                                                                }
                                                        }
                                                        
                                                        if (!corrupted)
                                                        {
                                                                usedtr[usednum] = filetr;
                                                                usedse[usednum] = filese;
                                                                usednum++;
                                                        
                                                                int cs = off(filetr, filese);
                                                                if (cs == -1)
                                                                {
                                                                        corrupted = 2;
                                                                        ok = 0;
                                                                }
                                                                
                                                                // next file pointer
                                                                filetr = buf[cs+0x00];
                                                                filese = buf[cs+0x01];
                                                                
                                                                int secsize = 254;
                                                                
                                                                if (filetr == 0x00)     // last sector
                                                                {
                                                                        secsize = filese-1;        
                                                                        ok = 0;         // exit
                                                                }
                                                                for (i=0; i < secsize; i++)
                                                                {
                                                                        filebuf[fileptr] = buf[cs+0x02+i];
                                                                        fileptr++;
                                                                }
                                                         }
                                                }
                                                if (corrupted)
                                                {
                                                        if (corrupted == 1)
                                                        {
                                                                printf(" - File Loop detected - corrupted file!\n");
                                                        }
                                                }
                                                else
                                                {
                                                        if (mode == 0)
                                                        {
                                                                if (sendfile())
                                                                {
                                                                        goto exitpoint;
                                                                }
                                                                
                                                                //FILE * fp1 = fopen (c64filename, "wb");
                                                                //fwrite(filebuf, 1, fileptr, fp1);
                                                                //fclose(fp1);
                
                                                        }
                                                        else
                                                        {
                                                                printf("\n");
                                                        }
                                                }
                                        }
                                        else
                                        {
                                                if (mode != 1)
                                                {
                                                        printf(" - skipping\n");
                                                }
                                                else
                                                {
                                                        printf("\n");
                                                }
                                        }
                                }
                                
                                pos++;
                          }
                
                  }
          }  
          if (mode == 0)
          {
                   bufstart[0] = 0;        // end of transfer
                   written = ftdiwrite(bufstart, 1);
          }
          
  // END OF COPY
  }
          
exitpoint:  
  free(buf);
  free(filebuf);
  free(bufstart);
  free(bufread); 
  
  ftdi_usb_close(&ftdic);
}
