/******************************************************************
 * dtvmkfs - Make DTV flash filesystem                            *
 ******************************************************************
 * $Id: dirlist.h,v 1.6 2008-12-06 17:51:19 spiff Exp $
 * Create C64 directory listing                                   *
 ******************************************************************
 * Author: Mikkel Holm Olsen (dtv@symlink.dk)                     *
 ******************************************************************
 * dtvmkfs is free software; you can redistribute it and/or       *
 * modify it under the terms of the GNU General Public License    *
 * as published by the Free Software Foundation; either version 2 *
 * of the License, or (at your option) any later version.         *
 *                                                                *
 * dtvmkfs is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  *
 * GNU General Public License for more details.                   *
 *                                                                *
 * You should have received a copy of the GNU General Public      *
 * License along with dtvmkfs; if not, write to the Free Software *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,         *
 * MA  02110-1301  USA                                            *
 ******************************************************************/

#ifndef _DIRLIST_H
#define _DIRLIST_H

unsigned char *dir_start(unsigned char *mem, const char *header, int width);

unsigned char *dir_add_entry(unsigned char *mem, int filesize, 
                             const char *filename, int width);

unsigned char *dir_add_blocksfree(unsigned char *mem, int freeblocks);

void dir_add_to_list(int filesize, char *filename);

int dir_build_listing(char *header, int width, int freeblocks);

void dir_print_listing(char *header, int width, int freeblocks);

unsigned char *dir_return_buffer_ptr(void);

int dir_save_buffer_to_prg(char *filename);

void dir_free_listing_buffer(void);


#endif
