/******************************************************************
 * dtvmkfs - Make DTV flash filesystem                            *
 ******************************************************************
 * $Id: zipfile.h,v 1.3 2008-10-13 20:13:04 spiff Exp $
 * Access to ZIP archives                                         *
 ******************************************************************
 * Author: Mikkel Holm Olsen (dtv@symlink.dk)                     *
 ******************************************************************
 * dtvmkfs is free software; you can redistribute it and/or       *
 * modify it under the terms of the GNU General Public License    *
 * as published by the Free Software Foundation; either version 2 *
 * of the License, or (at your option) any later version.         *
 *                                                                *
 * dtvmkfs is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  *
 * GNU General Public License for more details.                   *
 *                                                                *
 * You should have received a copy of the GNU General Public      *
 * License along with dtvmkfs; if not, write to the Free Software *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,         *
 * MA  02110-1301  USA                                            *
 ******************************************************************
 * Although dtvmkfs is released under the terms of the GPL, this  *
 * part uses zlib and the unzip-library (by Gilles Vollant)       *
 * shipped with zlib. The license of both these libraries can be  *
 * found in the zlib directory, which contains an UNMODIFIED      *
 * version of the zlib source distribution.                       *
 ******************************************************************/

#ifndef _ZIPFILE_H
#define _ZIPFILE_H

#include <stdint.h>

void zip_initialize(void);

int zip_open_archive(const char *zipfilename);

int zip_close_archive(void);

int zip_open_file(const char *filename, uint32_t *crc32);

char* zip_buf_get_line(void);

int zip_get_file_size(void);

int zip_read_buffer(char *buf, int maxbytes);

int zip_close_file(void);

#endif
