/******************************************************************
 * dtvmkfs - Make DTV flash filesystem                            *
 ******************************************************************
 * $Id: clopts.h,v 1.9 2008-12-06 21:44:46 spiff Exp $
 * Command line options parsing                                   *
 ******************************************************************
 * Author: Mikkel Holm Olsen (dtv@symlink.dk)                     *
 ******************************************************************
 * dtvmkfs is free software; you can redistribute it and/or       *
 * modify it under the terms of the GNU General Public License    *
 * as published by the Free Software Foundation; either version 2 *
 * of the License, or (at your option) any later version.         *
 *                                                                *
 * dtvmkfs is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  *
 * GNU General Public License for more details.                   *
 *                                                                *
 * You should have received a copy of the GNU General Public      *
 * License along with dtvmkfs; if not, write to the Free Software *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,         *
 * MA  02110-1301  USA                                            *
 ******************************************************************/

#ifndef _CLOPTS_H
#define _CLOPTS_H

#define RETFLAG_USAGE 1
#define RETFLAG_PROGNAME 2
#define RETFLAG_VERSION 4

struct cmdline_opts {
  int debug;
  int verbose;
  int numentries; /* Number of entries reserved in the directory */
  int dirwidth; /* Max filename length in C64 dir list */
  int kernel; /* Dump the kernel region $0-$FFFF */
  int printlist, printdir; /* Output dir lists to stdout */
  int onefile, twofiles, chunked; /* Types of file to dump */
  int importlist; /* Should we import the directory list (or nuke it) */
  int importraw;
  char *dirhead;
  char *importfile;
  char *prgfile;
};

void clopts_clear_options(struct cmdline_opts *options);

int clopts_process_parameters(int argc, char **argv, 
                              struct cmdline_opts *opts);

#endif
