/******************************************************************
 * dtvmkfs - Make DTV flash filesystem                            *
 ******************************************************************
 * $Id: number.c,v 1.1 2008-10-13 20:11:14 spiff Exp $
 * Number parsing function                                        *
 ******************************************************************
 * Author: Mikkel Holm Olsen (dtv@symlink.dk)                     *
 ******************************************************************
 * dtvmkfs is free software; you can redistribute it and/or       *
 * modify it under the terms of the GNU General Public License    *
 * as published by the Free Software Foundation; either version 2 *
 * of the License, or (at your option) any later version.         *
 *                                                                *
 * dtvmkfs is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  *
 * GNU General Public License for more details.                   *
 *                                                                *
 * You should have received a copy of the GNU General Public      *
 * License along with dtvmkfs; if not, write to the Free Software *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,         *
 * MA  02110-1301  USA                                            *
 ******************************************************************/

#include "number.h"

#include <stdio.h>
#include <strings.h>
#include <ctype.h>

int64_t number_parse_from_string(char *strng) {
  unsigned int retval=-1;
  char *st=strng;
  while ((*st)&&(isspace(*st))) st++; // Skip leading space
  if (*st=='$') {
    st++;
    if (sscanf(st,"%x",&retval)!=1)
      return -1;
  } else if (strncasecmp(st,"0x",2)==0) {
    st+=2;
    if (sscanf(st,"%x",&retval)!=1)
      return -1;
  } else {
    while ((*st)&&(isdigit(*st))) st++; // Make sure we have only digits
    if (*st)
      return -1;
    st=strng;
    if (sscanf(st,"%u",&retval)!=1)
      return -1;
  }
  return retval;
}

