; -------------------------------------------------------------------------------------------------------------- ;
; Miner 2049er - Level 07
; -------------------------------------------------------------------------------------------------------------- ;
Level_07LifterScreen  = M2_ScreenGame + $0217       ; 
Level_07LifterColor   = COLORAM       + $0217       ; 
Level_07LifterWagon   = COLORAM       + $03a6       ; 
Level_07LifterWagonLen= $10                         ; 
Level_07LifterHeight  = $0b                         ; .hbu002.
; -------------------------------------------------------------------------------------------------------------- ;
Level_07            equ  *                  ; 1 very large kill flow tile / 1 lifter
                    dc.w M2_WaSprite_00     ; -> $5c
                    dc.w M2_WaSprite_01     ; 
                    dc.w M2_WaSprite_02     ; 
                    dc.w M2_WaSprite_03     ; 
                    dc.w M2_WaSprite_04     ; 
                    
                    dc.w M2_WaSprite_09     ; flickering sprites - scores
                    dc.w M2_WaSprite_0a     ; flickering sprites - death flow tile 1
                    dc.w M2_WaSprite_0b     ; flickering sprites - death flow tile 2
; -------------------------------------------------------------------------------------------------------------- ;
                    dc.w M2_WaSprite_00     ; -> $6c
                    dc.w M2_WaSprite_05     ; 
                    dc.w $0000              ; 
                    dc.w $0000              ; 
                    dc.w $0000              ; 
                    dc.w $0000              ; 
                    dc.w $0000              ; 
                    dc.w $0000              ; 
; -------------------------------------------------------------------------------------------------------------- ;
                    dc.w StructureLevel_07  ; -> $7c = ptr level structure data
                    dc.w ItemsLevel_07      ; -> $7e = ptr level item data
                    dc.w LaddersLevel_07    ; -> $80 = ptr level ladder pos
                    dc.w SlidesLevel_07     ; -> $82 = ptr level slide pos
                    dc.w SpritesLevel_07    ; -> $84 = ptr level sprite data
                    dc.w $0000              ; -> $86 = ptr level flow tile data
                    dc.w $0000              ; -> $88 = ptr level text data
                    dc.b $00                ; -> $8a = M2Z_LvlXmitBoothXpos
                    dc.b $00                ; -> $8b = M2Z_LvlXmitDigitXpos
                    dc.w $0000              ; -> $8c = ptr level stomper data
                    dc.w DeathTileLevel_07  ; -> $8e = ptr level death tile data
                    dc.b $70                ; -> $90 = M2Z_LvlFieldsToStep
                    dc.b $45                ; -> $91 = M2Z_LvlTimeDiscount
                    dc.b $b4                ; -> $92 = M2Z_LvlRasterIrqLine
; -------------------------------------------------------------------------------------------------------------- ;
StructureLevel_07   equ  *
                    dc.b $28 ; 
                    dc.b $00 ; 
                    dc.b $c7 ; 
                    dc.b $04 ; 
                    dc.b $28 ; 
                    
                    dc.b $26 ; 
                    dc.b $04 ; 
                    dc.b $28 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    
                    dc.b $05 ; 
                    dc.b $02 ; 
                    dc.b $48 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    
                    dc.b $0d ; 
                    dc.b $02 ; 
                    dc.b $68 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    
                    dc.b $0d ; 
                    dc.b $02 ; 
                    dc.b $7f ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    
                    dc.b $0a ; 
                    dc.b $02 ; 
                    dc.b $ae ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    
                    dc.b $0f ; 
                    dc.b $3a ; 
                    dc.b $48 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    
                    dc.b $02 ; 
                    dc.b $7e ; 
                    dc.b $66 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    
                    dc.b $05 ; 
                    dc.b $8a ; 
                    dc.b $66 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    
                    dc.b $03 ; 
                    dc.b $81 ; 
                    dc.b $7a ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    
                    dc.b $08 ; 
                    dc.b $7e ; 
                    dc.b $a9 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    
LifterPosX          set  $3e  ; Track
LifterPosY          set  $c3  ; Track
LifterStartFieldX   set  $0a  ; Starting point on track
LifterStartPosX     set  LifterPosX + LifterStartFieldX * LevelTileDirRi_04
LifterLevel_07      dc.b $0f                            ; length
                    dc.b LifterPosX                     ; $3e ; 
                    dc.b LifterPosY                     ; $c3 ; 
                    dc.b LevelTileDirRi_04              ; $04 ; 
                    dc.b NoLvlTileTrack                 ; $50 ; 
                    
                    dc.b $02 ; length
                    dc.b LifterStartPosX                ; $66 ; 
                    dc.b LifterPosY - $03               ; $c0 ; 
                    dc.b LevelTileDirRi_04 * $02 + $01  ; $09 ; 
                    dc.b NoLvlTileWheel                 ; $58 ; 
                    
                    dc.b $04 ; length
                    dc.b LifterStartPosX - $02          ; $64 ; 
                    dc.b LifterPosY - $06               ; $bd ; 
                    dc.b LevelTileDirRi_04              ; $04 ; 
                    dc.b NoLvlTileFlower                ; $48 ; 
                    
                    dc.b $03 ; length
                    dc.b LifterStartPosX                ; $66 ; 
                    dc.b LifterPosY - $0b               ; $b8 ; 
                    dc.b LevelTileDirRi_04              ; $04 ; 
                    dc.b NoLvlTileGroundFix             ; $30 ; 
                    
                    dc.b $02 ; length
                    dc.b LifterStartPosX                ; $66 ; 
                    dc.b LifterPosY - $0c               ; $b7 ; 
                    dc.b LevelTileDirRi_04 * $02 + $02  ; $0a ; 
                    dc.b NoLvlTileDot                   ; $60 ; 
                    
                    dc.b $02 ; length
                    dc.b LifterStartPosX - $02          ; $64 ; 
                    dc.b LifterPosY - $0d               ; $b6 ; 
                    dc.b LevelTileDirRi_04 * $03 + $02  ; $0e ; 
                    dc.b NoLvlTileDot                   ; $60 ; 
                    
                    dc.b $02 ; length
                    dc.b LifterStartPosX                ; $66 ; 
                    dc.b LifterPosY - $0e               ; $b5 ; 
                    dc.b LevelTileDirRi_04 * $02 + $02  ; $0a ; 
                    dc.b NoLvlTileDot                   ; $60 ; 
                    
                    dc.b $02 ; length
                    dc.b LifterStartPosX + $02          ; $68 ; 
                    dc.b LifterPosY - $0f               ; $b4 ; 
                    dc.b LevelTileDirRi_04 + $02        ; $06 ; 
                    dc.b NoLvlTileDot                   ; $60 ; 
                    
                    dc.b $02 ; length
                    dc.b LifterStartPosX + $04          ; $6a ; 
                    dc.b LifterPosY - $10               ; $b3 ; 
                    dc.b LevelTileDirRi_04 - $02        ; $02 ; 
                    dc.b NoLvlTileDot                   ; $60 ; 
                    
                    dc.b $02 ; length
                    dc.b LifterStartPosX + $04          ; $6a ; 
                    dc.b LifterPosY - $11               ; $b2 ; 
                    dc.b LevelTileDirRi_04 - $02        ; $02 ; 
                    dc.b NoLvlTileDot                   ; $60 ; 
                    
                    dc.b $02 ; length
                    dc.b LifterStartPosX + $02          ; $68 ; 
                    dc.b LifterPosY - $12               ; $b1 ; 
                    dc.b LevelTileDirRi_04 + $02        ; $06 ; 
                    dc.b NoLvlTileDot                   ; $60 ; 
                    
                    dc.b $02 ; length
                    dc.b LifterStartPosX                ; $66 ; 
                    dc.b LifterPosY - $13               ; $b0 ; 
                    dc.b LevelTileDirRi_04 * $02 + $02  ; $0a ; 
                    dc.b NoLvlTileDot                   ; $60 ; 
                    
                    dc.b $02 ; length
                    dc.b LifterStartPosX - $02          ; $64 ; 
                    dc.b LifterPosY - $14               ; $af ; 
                    dc.b LevelTileDirRi_04 * $03 + $02  ; $0e ; 
                    dc.b NoLvlTileDot                   ; $60 ; 
                    
                    dc.b $02 ; length
                    dc.b LifterStartPosX                ; $66 ; 
                    dc.b LifterPosY - $15               ; $ae ; 
                    dc.b LevelTileDirRi_04 * $02 + $02  ; $0a ; 
                    dc.b NoLvlTileDot                   ; $60 ; 
                    
                    dc.b $02 ; length
                    dc.b LifterStartPosX + $02          ; $68 ; 
                    dc.b LifterPosY - $16               ; $ad ; 
                    dc.b LevelTileDirRi_04 + $02        ; $06 ; 
                    dc.b NoLvlTileDot                   ; $60 ; 
                    
                    dc.b $02 ; length
                    dc.b LifterStartPosX + $04          ; $6a ; 
                    dc.b LifterPosY - $17               ; $ac ; 
                    dc.b LevelTileDirRi_04 - $02        ; $02 ; 
                    dc.b NoLvlTileDot                   ; $60 ; 
                    
                    dc.b $04 ; length
                    dc.b LifterStartPosX - $02          ; $64 ; 
                    dc.b LifterPosY - $1a               ; $a9 ; 
                    dc.b LevelTileDirRi_04              ; $04 ; 
                    dc.b NoLvlTileFlower                ; $48 ; 
                    
                    dc.b $04 ; 
                    dc.b $0a ; 
                    dc.b $28 ; 
                    dc.b $80 ; 
                    dc.b $15 ; 
                    
                    dc.b $04 ; 
                    dc.b $0e ; 
                    dc.b $28 ; 
                    dc.b $80 ; 
                    dc.b $1d ; 
                    
                    dc.b $04 ; 
                    dc.b $3c ; 
                    dc.b $28 ; 
                    dc.b $80 ; 
                    dc.b $15 ; 
                    
                    dc.b $04 ; 
                    dc.b $40 ; 
                    dc.b $28 ; 
                    dc.b $80 ; 
                    dc.b $1d ; 
                    
                    dc.b $02 ; 
                    dc.b $94 ; 
                    dc.b $2a ; 
                    dc.b $80 ; 
                    dc.b $13 ; 
                    
                    dc.b $02 ; 
                    dc.b $98 ; 
                    dc.b $2a ; 
                    dc.b $80 ; 
                    dc.b $1b ; 
                    
                    dc.b $04 ; 
                    dc.b $48 ; 
                    dc.b $48 ; 
                    dc.b $80 ; 
                    dc.b $15 ; 
                    
                    dc.b $04 ; 
                    dc.b $4c ; 
                    dc.b $48 ; 
                    dc.b $80 ; 
                    dc.b $1d ; 
                    
                    dc.b $05 ; 
                    dc.b $94 ; 
                    dc.b $3e ; 
                    dc.b $80 ; 
                    dc.b $12 ; 
                    
                    dc.b $05 ; 
                    dc.b $98 ; 
                    dc.b $3e ; 
                    dc.b $80 ; 
                    dc.b $1a ; 
                    
                    dc.b $08 ; 
                    dc.b $90 ; 
                    dc.b $69 ; 
                    dc.b $80 ; 
                    dc.b $12 ; 
                    
                    dc.b $08 ; 
                    dc.b $94 ; 
                    dc.b $69 ; 
                    dc.b $80 ; 
                    dc.b $1a ; 
                    
                    dc.b $20 ; 
                    dc.b $06 ; 
                    dc.b $48 ; 
                    dc.b $10 ; 
                    dc.b $20 ; 
                    
                    dc.b $20 ; 
                    dc.b $0a ; 
                    dc.b $48 ; 
                    dc.b $10 ; 
                    dc.b $20 ; 
                    
                    dc.b $2f ; 
                    dc.b $06 ; 
                    dc.b $7f ; 
                    dc.b $10 ; 
                    dc.b $20 ; 
                    
                    dc.b $2f ; 
                    dc.b $0a ; 
                    dc.b $7f ; 
                    dc.b $10 ; 
                    dc.b $20 ; 
                    
                    dc.b $20 ; 
                    dc.b $52 ; 
                    dc.b $28 ; 
                    dc.b $10 ; 
                    dc.b $20 ; 
                    
                    dc.b $20 ; 
                    dc.b $56 ; 
                    dc.b $28 ; 
                    dc.b $10 ; 
                    dc.b $20 ; 
                    
                    dc.b $1e ; 
                    dc.b $66 ; 
                    dc.b $48 ; 
                    dc.b $11 ; 
                    dc.b $20 ; 
                    
                    dc.b $1e ; 
                    dc.b $6a ; 
                    dc.b $48 ; 
                    dc.b $11 ; 
                    dc.b $20 ; 
                    
                    dc.b $14 ; 
                    dc.b $84 ; 
                    dc.b $66 ; 
                    dc.b $10 ; 
                    dc.b $20 ; 
                    
                    dc.b $14 ; 
                    dc.b $88 ; 
                    dc.b $66 ; 
                    dc.b $10 ; 
                    dc.b $20 ; 
                    
StructLevel_07_EOD  dc.b $00 ; End Of Level Structure
; -------------------------------------------------------------------------------------------------------------- ;
ItemsLevel_07       equ  *
                    dc.b $24 ; 
                    dc.b $16 ; 
                    dc.b $50 ; 
                    dc.b $22 ; 
                    dc.b $2a ; 
                    dc.b $36 ; 
                    dc.b $35 ; 
                    dc.b $55 ; 
                    
                    dc.b $70 ; 
                    dc.b $16 ; 
                    dc.b $88 ; 
                    dc.b $22 ; 
                    dc.b $76 ; 
                    dc.b $80 ; 
                    dc.b $35 ; 
                    dc.b $55 ; 
                    
                    dc.b $30 ; 
                    dc.b $4a ; 
                    dc.b $98 ; 
                    dc.b $43 ; 
                    dc.b $36 ; 
                    dc.b $42 ; 
                    dc.b $6b ; 
                    dc.b $89 ; 
                    
                    dc.b $86 ; 
                    dc.b $3c ; 
                    dc.b $58 ; 
                    dc.b $22 ; 
                    dc.b $8a ; 
                    dc.b $95 ; 
                    dc.b $59 ; 
                    dc.b $7c ; 
                    
                    dc.b $01 ; 
                    dc.b $6e ; 
                    dc.b $a0 ; 
                    dc.b $64 ; 
                    dc.b $05 ; 
                    dc.b $0f ; 
                    dc.b $94 ; 
                    dc.b $a9 ; 
                    
                    dc.b $30 ; 
                    dc.b $6e ; 
                    dc.b $48 ; 
                    dc.b $01 ; 
                    dc.b $36 ; 
                    dc.b $42 ; 
                    dc.b $92 ; 
                    dc.b $9d ; 
                    
ItemsLevel_07_EOD   dc.b $00 ; End Of Item Data
; -------------------------------------------------------------------------------------------------------------- ;
LaddersLevel_07     equ  *
                    dc.b $16 ; 
                    dc.b $45 ; 
                    dc.b $65 ; 
                    
                    dc.b $48 ; 
                    dc.b $45 ; 
                    dc.b $65 ; 
                    
                    dc.b $a0 ; 
                    dc.b $45 ; 
                    dc.b $57 ; 
                    
                    dc.b $54 ; 
                    dc.b $65 ; 
                    dc.b $84 ; 
                    
                    dc.b $a0 ; 
                    dc.b $5d ; 
                    dc.b $83 ; 
                    
                    dc.b $9c ; 
                    dc.b $83 ; 
                    dc.b $c6 ; 
                    
LaddersLevel_07_EOD dc.b $00 ; End Of Ladder Data
; -------------------------------------------------------------------------------------------------------------- ;
SlidesLevel_07      equ  *
                    dc.b $20 ; 
                    dc.b $12 ; 
                    dc.b $65 ; 
                    dc.b $00 ; 
                    
                    dc.b $2f ; 
                    dc.b $12 ; 
                    dc.b $9c ; 
                    dc.b $00 ; 
                    
                    dc.b $20 ; 
                    dc.b $5e ; 
                    dc.b $45 ; 
                    dc.b $00 ; 
                    
                    dc.b $1e ; 
                    dc.b $72 ; 
                    dc.b $65 ; 
                    dc.b $01 ; 
                    
                    dc.b $14 ; 
                    dc.b $90 ; 
                    dc.b $83 ; 
                    dc.b $00 ; 
                    
SlidesLevel_07_EOD  dc.b $00 ; End Of Slides Data
; -------------------------------------------------------------------------------------------------------------- ;
SpritesLevel_07     equ  *
Sprite_00_PlayerL07 dc.b $ff ; State - $00=dead $ff=alive
                    dc.b $90 ; PosX
                    dc.b $c6 ; PosY
                    dc.b PtrSprPlrMovLe03 ; Pointer
                    dc.b WHITE ; Color0
                    dc.b $00 ; Back Prio
                    dc.b $00 ; KingSize - $00=no $ff=yes
                    dc.b $ff ; MultiColor
                    dc.b $02 ; SpriteNumber
                    dc.b $01 ; SpriteCounter
                    dc.b $ff ; Direction
                    dc.b $00 ; MoveType
                    dc.b $00 ; MoveDirection x-axis
                    dc.b $00 ; MoveTime
                    
Sprite_01_EnemyL07  dc.b $ff ; State - $00=dead $ff=alive $fe=score
                    dc.b $1c ; PosX
                    dc.b $50 ; PosY
                    dc.b PtrSprEneMovRi01 ; Pointer
                    dc.b LT_GREEN ; Color0 .hbu002.
                    dc.b $00 ; BackPrio
                    dc.b $00 ; KingSize - $00=no $ff=yes           
                    dc.b $00 ; MultiColor
                    dc.b $03 ; StepWait
                    dc.b $01 ; Speed - $01=fastest $00=slowest
                    dc.b $01 ; MoveDir - $00=no $01=right $ff=left
                    dc.b $0f ; MoveMinX
                    dc.b $5c ; MoveMaxX
                    dc.b $00 ; SpriteNo
                    
Sprite_02_EnemyL07  dc.b $ff ; State - $00=dead $ff=alive $fe=score
                    dc.b $64 ; PosX
                    dc.b $50 ; PosY
                    dc.b PtrSprEneMovLe01 ; Pointer
                    dc.b PURPLE ; Color0
                    dc.b $00 ; BackPrio
                    dc.b $00 ; KingSize - $00=no $ff=yes
                    dc.b $00 ; MultiColor
                    dc.b $02 ; StepWait
                    dc.b $02 ; Speed - $01=fastest $00=slowest
                    dc.b $fe ; MoveDir - $00=no $01=right $ff=left
                    dc.b $50 ; MoveMinX
                    dc.b $a0 ; MoveMaxX
                    dc.b $00 ; SpriteNo
                    
Sprite_03_EnemyL07  dc.b $ff ; State - $00=dead $ff=alive $fe=score
                    dc.b $1c ; PosX
                    dc.b $90 ; PosY
                    dc.b PtrSprEneMovRi01 ; Pointer
                    dc.b ORANGE ; Color0
                    dc.b $00 ; BackPrio
                    dc.b $00 ; KingSize - $00=no $ff=yes
                    dc.b $00 ; MultiColor
                    dc.b $02 ; StepWait
                    dc.b $02 ; Speed - $01=fastest $00=slowest
                    dc.b $01 ; MoveDir - $00=no $01=right $ff=left
                    dc.b $14 ; MoveMinX
                    dc.b $3c ; MoveMaxX
                    dc.b $00 ; SpriteNo
                    
Sprite_04_EnemyL07  dc.b $ff ; State - $00=dead $ff=alive $fe=score
                    dc.b $1c ; PosX
                    dc.b $a7 ; PosY
                    dc.b PtrSprEneMovRi01 ; Pointer
                    dc.b YELLOW ; Color0 .hbu002.
                    dc.b $00 ; BackPrio
                    dc.b $00 ; KingSize - $00=no $ff=yes
                    dc.b $00 ; MultiColor
                    dc.b $06 ; StepWait
                    dc.b $03 ; Speed - $01=fastest $00=slowest
                    dc.b $01 ; MoveDir - $00=no $01=right $ff=left
                    dc.b $16 ; MoveMinX
                    dc.b $3c ; MoveMaxX
                    dc.b $00 ; SpriteNo
                    
Sprite_05_EnemyL07  dc.b $ff ; State - $00=dead $ff=alive $fe=score
                    dc.b $1c ; PosX
                    dc.b $d6 ; PosY
                    dc.b PtrSprEneMovRi01 ; Pointer
                    dc.b LT_RED ; Color0 .hbu002.
                    dc.b $00 ; BackPrio
                    dc.b $00 ; KingSize - $00=no $ff=yes
                    dc.b $00 ; MultiColor
                    dc.b $03 ; StepWait
                    dc.b $02 ; Speed - $01=fastest $00=slowest
                    dc.b $03 ; MoveDir - $00=no $01=right $ff=left
                    dc.b $10 ; .hbu004. - MoveMinX
                    dc.b $25 ; .hbu004. - MoveMaxX
                    dc.b $00 ; SpriteNo
                    
SpritesLevel_07_EOD dc.b $00 ; end of sprite data
; -------------------------------------------------------------------------------------------------------------- ;
DeathTileLevel_07   equ  *
Sprite_01_DeathL07  dc.b $ff ; State - $00=dead $ff=alive $fe=score
                    dc.b $2c ; PosX
                    dc.b $ec ; PosY
                    dc.b PtrSprFlowTile ; Pointer
                    dc.b CYAN ; Color0
                    dc.b $00 ; BackPrio
                    dc.b $ff ; KingSize - $00=no $ff=yes
                    dc.b $00 ; MultiColor
                    dc.b $00 ; StepWait
                    dc.b $00 ; Speed - $01=fastest $00=slowest
                    dc.b $00 ; MoveDir - $00=no $01=right $ff=left
                    dc.b $00 ; MoveMinX
                    dc.b $00 ; MoveMaxX
                    dc.b $00 ; SpriteNo
                    
Sprite_02_DeathL07  dc.b $ff ; State - $00=dead $ff=alive $fe=score
                    dc.b $37 ; PosX
                    dc.b $ec ; PosY
                    dc.b PtrSprFlowTile ; Pointer
                    dc.b CYAN ; Color0
                    dc.b $00 ; BackPrio
                    dc.b $ff ; KingSize - $00=no $ff=yes
                    dc.b $00 ; MultiColor
                    dc.b $00 ; StepWait
                    dc.b $00 ; Speed - $01=fastest $00=slowest
                    dc.b $00 ; MoveDir - $00=no $01=right $ff=left
                    dc.b $00 ; MoveMinX
                    dc.b $00 ; MoveMaxX
                    dc.b $00 ; SpriteNo
; -------------------------------------------------------------------------------------------------------------- ;
