; -------------------------------------------------------------------------------------------------------------- ;
; Miner 2049er - Zero Page Equates
; -------------------------------------------------------------------------------------------------------------- ;
M2Z_D6510             = $00                         ; 
M2Z_R6510             = $01                         ; 

M2Z_CountIRQs         = $05                         ; 
M2Z_CountIRQsInit       = $00                       ; 
M2Z_CountIRQs1st04      = $01                       ; 
M2Z_CountIRQs2nd07      = $02                       ; 
M2Z_WaitIRQs          = $06                         ; 
M2Z_SprSprColl04      = $07                         ; 
M2Z_SprSprColl07      = $08                         ; 
M2Z_SpriteWork        = $09                         ; 

M2Z_SpriteInfoStart   = $000b                       ; 
M2Z_SpriteInfoLen       = $08                       ; 
M2Z_SpriteEnable      = $0b                         ; 
M2Z_SpritePosX        = $0c                         ; 
M2Z_SpritePosY        = $0d                         ; 
M2Z_SpritePointer     = $0e                         ; 
M2Z_SpriteColor0      = $0f                         ; 
M2Z_SpriteBackPrio    = $10                         ; 
M2Z_SpriteKingSize    = $11                         ; 
M2Z_SpriteMultiColor  = $12                         ; 

M2Z_SpriteNo          = $13                         ; 
M2Z_SpriteNoDoubled   = $14                         ; 
M2Z_SpriteSelect      = $15                         ; 
M2Z_SpriteDeSelect    = $16                         ; 
M2Z_SpriteWAPtr       = $17                         ; 
M2Z_SpriteWAPtrLo     = $17                         ; 
M2Z_SpriteWAPtrHi     = $18                         ; 
M2Z_SpriteWAPosX      = $19                         ; 

M2Z_StatusScoreDecPt  = $19                         ; 
M2Z_StatusLives01     = $19                         ; 
M2Z_StatusLives02     = $1a                         ; 
M2Z_StatusLives03     = $1b                         ; 

M2Z_WorkLenBytes      = $19                         ; 
M2Z_WorkLenPages      = $1a                         ; 
M2Z_WorkTargetPtrLo   = $1b                         ; 
M2Z_WorkTargetPtrHi   = $1c                         ; 

M2Z_DoubleChar1st     = $19                         ; 
M2Z_DoubleChar2nd     = $1a                         ; 

M2Z_SprSprColFlags    = $19                         ; 
M2Z_PtrEnemyWaPtr     = $1a                         ; 
M2Z_EnemiesToHandle   = $1b                         ; 

M2Z_SlideDownHeight   = $19                         ; 
M2Z_OnLadderPos       = $19                         ; 
M2Z_OnLadderPosTop      = $ff                       ; 
M2Z_OnLadderPosBot      = $00                       ; 
M2Z_LadderPosX        = $1b                         ; 

M2Z_PlayerTilePosXMax = $19                         ; 
M2Z_PlayerTilePosXMin = $1a                         ; 
M2Z_PlayerTilePosY    = $1b                         ; 

M2Z_GameOverTextPosLo = $1d                         ; 
M2Z_GameOverTextCount = $1f                         ; 

M2Z_19                = $19                         ; 
M2Z_1a                = $1a                         ; 
M2Z_1b                = $1b                         ; 
M2Z_1c                = $1c                         ; 
M2Z_1d                = $1d                         ; 
M2Z_21                = $21                         ; 

M2Z_InfoTextPosX      = $20                         ; 
M2Z_InfoTextLen       = $21                         ; 

M2Z_22                = $22                         ; 
M2Z_23                = $23                         ; 

M2Z_LvlOddEvenFlag    = $1c                         ; 
M2Z_LvlTileWork       = $1d                         ; 
M2Z_LvlTileWorkLen      = $05                       ; 
M2Z_LvlTileCount        = M2Z_LvlTileWork + $00     ; $1d
M2Z_LvlTilePosX         = M2Z_LvlTileWork + $01     ; $1e
M2Z_LvlTileNextPosX     = M2Z_LvlTileWork + $03     ; $20
M2Z_LvlTilePosY         = M2Z_LvlTileWork + $02     ; $1f
M2Z_LvlTileNextPosY     = M2Z_LvlTileWork + $04     ; $21
M2Z_LvlTileDir          = M2Z_LvlTileWork + $03     ; $20
M2Z_LvlTileDirMaskX       = $0f                     ; 
M2Z_LvlTileDirMaskY       = $f0                     ; 
M2Z_LvlTile             = M2Z_LvlTileWork + $04     ; $21
M2Z_LvlTileMaskGrnd       = $80                     ; #.......  - 1=plain ground tile flip-flop
M2Z_LvlTileMaskNo         = $78                     ; .####...  - tile number
M2Z_LvlTileMaskClr        = $07                     ; .....###  - number of tile bytes to clear
M2Z_LvlTileDataPtrOdd = $22                         ; 
M2Z_LvlTileDataPtrEven= $23                         ; 
M2Z_LvlTileClearCount = $24                         ; 

M2Z_TileThickness     = $19                         ; 
M2Z_TileFillUpBits    = $1a                         ; 

M2Z_StompWorkStart    = $001b                       ; 
M2Z_StompPosX         = $1b                         ; 
M2Z_StompPosY         = $1c                         ; 
M2Z_StompTime         = $1d                         ; 

M2Z_FlowWorkStart     = $001b                       ; 
M2Z_FlowPosY          = $1b                         ; 
M2Z_FlowDelay         = $1c                         ; 
M2Z_FlowSpeed         = $1d                         ; 
M2Z_Flow_03           = $1e                         ; 
M2Z_FlowDir           = $1f                         ; 
M2Z_FlowMaxLeft       = $20                         ; 
M2Z_FlowMaxRight      = $21                         ; 
M2Z_FlowXpos          = $22                         ; 
M2Z_FlowLength        = $23                         ; 

M2Z_WaItemPtr         = $23                         ; 
M2Z_WaItemPtrLo       = $23                         ; 
M2Z_WaItemPtrHi       = $24                         ; 

M2Z_24                = $24                         ; 
M2Z_25                = $25                         ; 
M2Z_26                = $26                         ; 
M2Z_27                = $27                         ; 
M2Z_28                = $28                         ; 

M2Z_LevelTextType     = $27                         ; 
M2Z_LevelTextNormal     = $00                       ; 
M2Z_LevelTextReversed   = $ff                       ; 
M2Z_LevelTextColorPtr = $28                         ; 

M2Z_LiftHeight        = $19                         ; 
M2Z_LiftColorScrPtr   = $25                         ; 
M2Z_LiftColorScrPtrLo = $25                         ; 
M2Z_LiftColorScrPtrHi = $26                         ; 
M2Z_LiftColorRamPtr   = $27                         ; 
M2Z_LiftColorRamPtrLo = $27                         ; 
M2Z_LiftColorRamPtrHi = $28                         ; 

M2Z_LevelHeaderPtr    = $27                         ; 
M2Z_LevelHeaderPtrLo  = $27                         ; 
M2Z_LevelHeaderPtrHi  = $28                         ; 

M2Z_LvlHandlerPtr     = $0027                       ; 
M2Z_LvlHandlerPtrLo   = $27                         ; 
M2Z_LvlHandlerPtrHi   = $28                         ; 

M2Z_WaS_EnemyPtr      = $27                         ; 
M2Z_WaS_EnemyPtrLo    = $27                         ; 
M2Z_WaS_EnemyPtrHi    = $28                         ; 

M2Z_SlideDataPtr      = $27                         ; 
M2Z_SlideDataPtrLo    = $27                         ; 
M2Z_SlideDataPtrHi    = $28                         ; 
M2Z_SpriteWaPtr       = $27                         ; 
M2Z_SpriteWaPtrLo     = $27                         ; 
M2Z_SpriteWaPtrHi     = $28                         ; 
M2Z_FlowTileWaPtr     = $27                         ; 
M2Z_FlowTileWaPtrLo   = $27                         ; 
M2Z_FlowTileWaPtrHi   = $28                         ; 
M2Z_StomperWaPtr      = $27                         ; 
M2Z_StomperWaPtrLo    = $27                         ; 
M2Z_StomperWaPtrHi    = $28                         ; 
M2Z_ItemTabPtr        = $27                         ; 
M2Z_ItemTabPtrLo      = $27                         ; 
M2Z_ItemTabPtrHi      = $28                         ; 

M2Z_FillAreaPtr       = $29                         ; 
M2Z_FillAreaPtrLo     = $29                         ; 
M2Z_FillAreaPtrHi     = $2a                         ; 
M2Z_FromAreaPtr       = $2b                         ; 
M2Z_FromAreaPtrLo     = $2b                         ; 
M2Z_FromAreaPtrHi     = $2c                         ; 
M2Z_FillAreaLenBytes  = $2d                         ; 
M2Z_FillAreaLenPages  = $2e                         ; 

M2Z_TilePart1         = $2f                         ; up to $36
M2Z_TilePart1Start    = $002f                       ; 
M2Z_TilePart10          = M2Z_TilePart1 + $00       ; $2f
M2Z_TilePart11          = M2Z_TilePart1 + $01       ; $30
M2Z_TilePart12          = M2Z_TilePart1 + $02       ; $31
M2Z_TilePart13          = M2Z_TilePart1 + $03       ; $32
M2Z_TilePart14          = M2Z_TilePart1 + $04       ; $33
M2Z_TilePart15          = M2Z_TilePart1 + $05       ; $34
M2Z_TilePart16          = M2Z_TilePart1 + $06       ; $35
M2Z_TilePart17          = M2Z_TilePart1 + $07       ; $36
M2Z_TilePart1Mask     = $37                         ; 

M2Z_TilePart2         = $38                         ; up to $3f
M2Z_TilePart2Start    = $0038                       ; 
M2Z_TilePart20          = M2Z_TilePart2 + $00       ; $38
M2Z_TilePart21          = M2Z_TilePart2 + $01       ; $39
M2Z_TilePart22          = M2Z_TilePart2 + $02       ; $3a
M2Z_TilePart23          = M2Z_TilePart2 + $03       ; $3b
M2Z_TilePart24          = M2Z_TilePart2 + $04       ; $3c
M2Z_TilePart25          = M2Z_TilePart2 + $05       ; $3d
M2Z_TilePart26          = M2Z_TilePart2 + $06       ; $3e
M2Z_TilePart27          = M2Z_TilePart2 + $07       ; $3f
M2Z_TilePart2Mask     = $40                         ; 

M2Z_TileGfxPtr        = $41                         ; 
M2Z_TileGfxPtrLo      = $41                         ; 
M2Z_TileGfxPtrHi      = $42                         ; 

M2Z_TargetScreenPosX  = $43                         ; 
M2Z_TargetScreenPosY  = $44                         ; 
M2Z_HiResScreenPtr    = $45                         ; 
M2Z_HiResScreenPtrLo  = $45                         ; 
M2Z_HiResScreenPtrHi  = $46                         ; 

M2Z_LadderPosYTop     = $47                         ; 
M2Z_LadderPosYBot     = $48                         ; 

M2Z_JoystickMove      = $49                         ; 
M2Z_JoystickLeRi      = $49                         ; 
M2Z_JoystickMoveLe      = $ff                       ; -1
M2Z_JoystickMoveRi      = $01                       ; +1
M2Z_JoystickUpDo      = $4a                         ; 
M2Z_JoystickMoveUp      = $ff                       ; -1
M2Z_JoystickMoveDo      = $01                       ; +1
M2Z_JoystickFire      = $4b                         ; 
M2Z_JoystickPressFire   = $ff                       ; 
M2Z_JoystickReset       = $00                       ; 
M2Z_JoystickFireRev   = $4c                         ; 
M2Z_EnemySmileTime    = $4d                         ; 
M2Z_EnemySmileTimeInit  = $b4                       ; 
M2Z_EnemySmileTimeTNT   = $40                       ; 
M2Z_PlayerDeadSink    = $4e                         ; 
M2Z_PlayerDeadSinkNo    = $00                       ; 
M2Z_PlayerDeadSinkYes   = $ff                       ; 
M2Z_PlayerDeadWobble  = $4f                         ; 
M2Z_PlayerDeadWobbleYes = $ff                       ; 
M2Z_PlayerDeadWobbleNo  = $00                       ; 

M2Z_Score             = $50                         ; 
M2Z_ScoreLen            = $06                       ; 
M2Z_Score100000       = $50                         ; 
M2Z_Score10000        = $51                         ; 
M2Z_Score1000         = $52                         ; 
M2Z_Score100          = $53                         ; 
M2Z_Score10           = $54                         ; 
M2Z_Score1            = $55                         ; 

M2Z_ScoreToAdd        = $56                         ; 
M2Z_ScoreToAdd100000  = $56                         ; 
M2Z_ScoreToAdd10000   = $57                         ; 
M2Z_ScoreToAdd1000    = $58                         ; 
M2Z_ScoreToAdd100     = $59                         ; 
M2Z_ScoreToAdd10      = $5a                         ; 
M2Z_ScoreToAdd1       = $5b                         ;  
; -------------------------------------------------------------------------------------------------------------- ;
; Level SetUp and Control Values from Level Header - Copied in L__CopyHeader
; -------------------------------------------------------------------------------------------------------------- ;
M2Z_LvlHeaderStore    = $005c                       ; 
M2Z_LvlHeaderStoreLen   = $3f                       ; 
M2Z_LvlSprtWaPtrPart1 = $5c                         ; 
M2Z_LvlSprtWaPtrPart2 = $6c                         ; 
M2Z_LvlStructurePtrLo = $7c                         ; 
M2Z_LvlStructurePtrHi = $7d                         ; 
M2Z_LvlItemDataPtr    = $7e                         ; 
M2Z_LvlItemDataPtrLo  = $7e                         ; 
M2Z_LvlItemDataPtrHi  = $7f                         ; 
M2Z_LvlLadderDataPtr  = $80                         ; 
M2Z_LvlLadderDataPtrLo= $80                         ; 
M2Z_LvlLadderDataPtrHi= $81                         ; 
M2Z_LvlSlideDataPtr   = $82                         ; 
M2Z_LvlSlideDataPtrLo = $82                         ; 
M2Z_LvlSlideDataPtrHi = $83                         ; 
M2Z_LvlSpriteDataPtr  = $84                         ; 
M2Z_LvlSpriteDataPtrLo= $84                         ; 
M2Z_LvlSpriteDataPtrHi= $85                         ; 
M2Z_LvlFlowDataPtr    = $86                         ; 
M2Z_LvlFlowDataPtrLo  = $86                         ; 
M2Z_LvlFlowDataPtrHi  = $87                         ; 
M2Z_LvlTextPtr        = $88                         ; 
M2Z_LvlTextPtrLo      = $88                         ; 
M2Z_LvlTextPtrHi      = $89                         ; 
M2Z_LvlXmitBoothXpos  = $8a                         ; 
M2Z_LvlXmitDigitXpos  = $8b                         ; 
M2Z_LvlStompDataPtr   = $8c                         ; 
M2Z_LvlStompDataPtrLo = $8d                         ; 
M2Z_LvlStompDataPtrHi = $8e                         ; 
M2Z_LvlInXmitMinXpos  = $8c                         ; 
M2Z_LvlInXmitMaxXpos  = $8d                         ; 
M2Z_LvlXtraDataPtr    = $8e                         ; 
M2Z_LvlXtraDataPtrLo  = $8e                         ; 
M2Z_LvlXtraDataPtrHi  = $8f                         ; 
M2Z_LvlFieldsToStep   = $90                         ; 
M2Z_LvlTimeDiscount   = $91                         ; 
M2Z_LvlRasterIrqLine  = $92                         ; 
M2Z_LvlUnuse01        = $93                         ; 
M2Z_LvlUnuse02        = $94                         ; 
M2Z_LvlUnuse03        = $95                         ; 
M2Z_LvlUnuse04        = $96                         ; 
M2Z_LvlUnuse05        = $97                         ; 
M2Z_LvlUnuse06        = $98                         ; 
M2Z_LvlUnuse07        = $99                         ; 
M2Z_LvlUnuse08        = $9a                         ; 
M2Z_LvlUnuse09        = $9b                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
M2Z_TimeTen           = $9c                         ; 
M2Z_TimeOne           = $9d                         ; 
M2Z_TimeTics          = $9e                         ; 
M2Z_TimeTicsInit        = $5a                       ; 
M2Z_NoOfLives         = $9f                         ; 
M2Z_NoOfLivesInit       = $03                       ; 
M2Z_NoOfLivesDeath      = $00                       ; 
M2Z_NextLevel         = $a0                         ; 
M2Z_NextLevelNo         = $00                       ; 
M2Z_NextLevelYes        = $80                       ; 
M2Z_NextLevelCheatTime  = M2Z_NextLevelYes + $0c    ; 
M2Z_PlayerColor0      = $a1                         ; 
M2Z_LevelColorNo      = $a1                         ; 
M2Z_DemoMode          = $a2                         ; 
M2Z_DemoModeOn          = $ff                       ; 
M2Z_DemoModeExit        = $01                       ; 
M2Z_DemoModeOff         = $00                       ; 
M2Z_LevelNo           = $a3                         ; 
M2Z_LevelNoMin          = $05                       ; 
M2Z_LevelNoMax          = $09                       ;
M2Z_LevelNoDemo         = M2Z_LevelNoMax + $01      ;
M2Z_SinkSprtDatPtr    = $a4                         ; 
M2Z_SinkSprtDatPtrLo  = $a4                         ; 
M2Z_SinkSprtDatPtrHi  = $a5                         ; 
M2Z_SinkSprtDatLen    = $a6                         ; 
M2Z_SinkSprtDatLenHat   = $08                       ; 
M2Z_XmitLevel         = $a7                         ; 
M2Z_XmitLevelMin        = $01                       ; 
M2Z_XmitLevelMax        = $04                       ; 
M2Z_XmitState         = $a8                         ; 
M2Z_XmitStateOn         = $ff                       ; 
M2Z_XmitStateOff        = $00                       ; 
M2Z_XmitLevelTime     = $a9                         ; 
M2Z_XmitLevelTimeXmit   = $23                       ; 
M2Z_XmitLevelTimeWait   = $30                       ; 
M2Z_SaveSpritePtr     = $aa                         ; 
M2Z_SaveSpritePtrLo   = $aa                         ; 
M2Z_SaveSpritePtrHi   = $ab                         ; 
M2Z_SaveSpriteDataLen   = $40                       ; 
M2Z_RndPatternPtr     = $ac                         ; 
M2Z_RndPatternPtrLo   = $ac                         ; 
M2Z_RndPatternPtrHi   = $ad                         ; 
M2Z_XmitNonAct        = $ae                         ; 
M2Z_XmitNonActTime      = $3c                       ; 
M2Z_LifterPlatformPosX= $af                         ; 
M2Z_LifterPlatformPosY= $b0                         ; 
M2Z_LifterStatus      = $b1                         ; 
M2Z_LifterInActive       = $01                      ; 
M2Z_LifterActive         = $ff                      ; 
M2Z_CannonShotDist    = $b2                         ; 
M2Z_CannonAtPosX      = $b3                         ; 
M2Z_CannonAtPosXMin     = $41                       ; 
M2Z_CannonAtPosXMax     = $6e                       ; 
M2Z_CannonAtPosXMid     = M2Z_CannonAtPosXMin + ((M2Z_CannonAtPosXMax - M2Z_CannonAtPosXMin) / 2)
M2Z_CannonStatus      = $b4                         ; 
M2Z_CannonStatusEmpty   = $00                       ; 
M2Z_CannonStatusHasTNT  = $01                       ; 
M2Z_CannonStatusLoaded  = $02                       ; 
M2Z_CannonStatusFired   = $03                       ; 
M2Z_AmountHex         = $b5                         ; 
M2Z_AmountHexAlert      = $04                       ; 
M2Z_AmountTNT10       = $b6                         ; 
M2Z_AmountTNT100      = $b7                         ; 

M2Z_SoundCtrlArea     = $b8                         ; 
M2Z_SoundKillWobble   = $b8                         ; 
M2Z_SoundKill         = $b9                         ; 
M2Z_SoundKillOn         = $80                       ; 
M2Z_SoundKillTimeInit   = $1e                       ; 
M2Z_SoundLifterCannon = $ba                         ; 
M2Z_SoundLifterCannonOff = $00                      ; 
M2Z_SoundLifterCannonOn  = $80                      ;
 
M2Z_SoundPlayerAction = $bb                         ; 
M2Z_SoundPlayerPlays    = $01                       ; 
M2Z_SoundPlayerStep   = $bb                         ; $00
M2Z_SoundPlayerStepOn   = $80                       ; 
M2Z_SoundTimeLow      = $bc                         ; $01
M2Z_SoundTimeLowOn      = $80                       ; 
M2Z_SoundPickItem     = $bd                         ; $02
M2Z_SoundPickItemOn     = $80                       ; 
M2Z_SoundXmit         = $bf                         ; $03
M2Z_SoundXmitOn         = $80                       ; 

M2Z_SndActionTimes    = $c0                         ; 
M2Z_c0                  = $c0                       ; M2Z_SoundPlayerStep
M2Z_c1                  = $c1                       ; M2Z_SoundTimeLow
M2Z_c2                  = $c2                       ; M2Z_SoundPickItem
M2Z_c3                  = $c3                       ; jump up/fall down/slide down
M2Z_c4                  = $c4                       ; M2Z_SoundXmit
M2Z_SndActionFreqs    = $c5                         ; 
M2Z_c5                  = $c5                       ; 
M2Z_c6                  = $c6                       ; 
M2Z_c7                  = $c7                       ; 
M2Z_c8                  = $c8                       ; 
M2Z_c9                  = $c9                       ; 
M2Z_SndActionWaveWi   = $ca                         ; 
M2Z_ca                  = $ca                       ; 
M2Z_cb                  = $cb                       ; 
M2Z_cc                  = $cc                       ; 
M2Z_cd                  = $cd                       ; 
M2Z_ce                  = $ce                       ; 
M2Z_SndActionCtrl     = $cf                         ; 
M2Z_cf                  = $cf                       ; 
M2Z_d0                  = $d0                       ; 
M2Z_d1                  = $d1                       ; 
M2Z_d2                  = $d2                       ; 
M2Z_d3                  = $d3                       ; 

M2Z_DemoSpritePosX    = $d4                         ; 
M2Z_DemoSpritePosY    = $d5                         ; 
M2Z_DemoPtrMoveTab    = $d6                         ; 
M2Z_DemoJoyMove       = $d7                         ; 
M2Z_DemoJoyLeRi       = $d7                         ; 
M2Z_DemoJoyUpDo       = $d8                         ; 
M2Z_DemoJoyFire       = $d9                         ; 

M2Z_Digit100          = $da                         ; 
M2Z_Digit10           = $db                         ; 
M2Z_Digit1            = $dc                         ; 

M2Z_EnemyCount        = $dd                         ; 
M2Z_EnemyCountNo        = $ff                       ; 
M2Z_LevelInit         = $de                         ; 
M2Z_LevelInitYes        = $00                       ; init all
M2Z_LevelInitItems      = $40                       ; set bit6 - allow item reinit
M2Z_LevelInitDone       = $80                       ; set bit7 - no reinit
M2Z_CannonPos         = $df                         ; 
M2Z_CannonLeft          = $ff                       ; 
M2Z_CannonRight         = $00                       ; 
M2Z_TimeUp            = $e0                         ; 
M2Z_TimeUpYes           = $80                       ; 
M2Z_TimeUpNo            = $00                       ; 
M2Z_LifterAuto        = $e1                         ; 
M2Z_LifterAutoYes       = $ff                       ; 
M2Z_LifterAutoNo        = $00                       ; 
M2Z_LifterAutoMaxDo     = $f0                       ; 
M2Z_LifterAutoMaxRi     = $0f                       ; 
; -------------------------------------------------------------------------------------------------------------- ;
