; -------------------------------------------------------------------------------------------------------------- ;
; Miner 2049er - MINER.prg
; -------------------------------------------------------------------------------------------------------------- ;
; Memory Map
; -------------------------------------------------------------------------------------------------------------- ;
; $0000 - $00ff:  Zero Page Values
; $0200 - $02ff:  Work Values and C64 system
; $0300 - $03ff:  Work Values and C64 system
; -------------------------------------------------------------------------------------------------------------- ;
                    * equ $8000
; -------------------------------------------------------------------------------------------------------------- ;
; compiler settings
; -------------------------------------------------------------------------------------------------------------- ;
                    incdir  ..\..\inc               ; C64 System Includes

C64CIA1             include cia1.asm                ; Complex Interface Adapter (CIA) #1 Registers  $DC00-$DC0F
C64CIA2             include cia2.asm                ; Complex Interface Adapter (CIA) #2 Registers  $DD00-$DD0F
C64SID              include sid.asm                 ; Sound Interface Device (SID) Registers        $D400-$D41C
C64VicII            include vic.asm                 ; Video Interface Chip (VIC-II) Registers       $D000-$D02E
C64Kernel           include kernel.asm              ; Kernel Vectors
C64Colors           include color.asm               ; Colour RAM Address / Colours
C64Memory           include mem.asm                 ; Memory Layout

Game                include inc\M2_VarsGame.asm     ; Game Variables
Equates             include inc\M2_Equates.asm      ; External and Unresolved Addresses
ZeroPage            include inc\M2_Zpg.asm          ; Zero Page Addresses
; -------------------------------------------------------------------------------------------------------------- ;
A_8000              dc.b $10 ; 
                    dc.b $80 ; 
                    dc.b $10 ; 
                    dc.b $80 ; 
                    dc.b $c3 ; C
                    dc.b $c2 ; B
                    dc.b $cd ; M
                    dc.b $38 ; 8
                    dc.b $30 ; 0
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    sei                             ; 
                    cld                             ; 
                    ldx #$ff                        ; 
                    txs                             ; 
                    lda #$7f                        ; 
                    sta CIAICR                      ; CIA1($DC0D) Interrupt Control
                    sta CI2ICR                      ; CIA2($DD0D) Interrupt Control Register
                    lda #$2f                        ; 
                    sta M2Z_00                      ; 
                    lda #$fe                        ; 
                    sta M2Z_01                      ; 
                    lda C2DDRA                      ; CIA2($DD02) Data Dir A
                    ora #$03                        ; 
                    sta C2DDRA                      ; CIA2($DD02) Data Dir A
                    lda CI2PRA                      ; CIA2($DD00) Data Port A - Bits 0-1 = VIC mem bank
                    and #$fc                        ; 
                    ora #$02                        ; 
                    sta CI2PRA                      ; CIA2($DD00) Data Port A - Bits 0-1 = VIC mem bank
                    lda #$00                        ; 
                    sta IRQMASK                     ; VIC($D01A) IRQ Mask Register
                    sta EXTCOL                      ; VIC($D020) Border Color
                    sta BGCOL0                      ; VIC($D021) Background Color 0
                    sta CIDDRB                      ; CIA1($DC03) Data Direction Register B
                    lda #$0b                        ; 
                    sta SCROLY                      ; VIC($D011) VIC Control Register 1 (and Vertical Fine Scrolling)
                    jsr S_80a2                      ; 
                    lda #$00                        ; 
                    sta M2Z_2b                      ; 
                    lda #$d0                        ; 
                    sta M2Z_2c                      ; 
                    lda #$00                        ; 
                    sta M2Z_29                      ; 
                    lda #$70                        ; 
                    sta M2Z_2a                      ; 
                    lda #$00                        ; 
                    sta M2Z_2d                      ; 
                    lda #$02                        ; 
                    sta M2Z_2e                      ; 
                    lda M2Z_01                      ; 
                    and #$fb                        ; 
                    sta M2Z_01                      ; 
                    jsr S_8907                      ; 
                    lda M2Z_01                      ; 
                    ora #$04                        ; 
                    sta M2Z_01                      ; 
                    ldx #$07                        ; 
B_8076              lda T_809a,x                    ; 
                    sta XT_7000,x                   ; 
                    dex                             ; 
                    bpl B_8076                      ; 
                    jsr S_80d8                      ; 
                    lda #$00                        ; 
                    sta XT_0314                     ; 
                    lda #$83                        ; 
                    sta XT_0315                     ; 
                    lda #$10                        ; 
                    sta XT_0316                     ; 
                    lda #$80                        ; 
                    sta XT_0317                     ; 
                    cli                             ; 
                    jmp J_813f                      ; 
T_809a              dc.b $1c ; <RED>
                    dc.b $7f ; 
                    dc.b $26 ; &
                    dc.b $7e ; 
                    dc.b $36 ; 6
                    dc.b $06 ; 
A_80a0              dc.b $3c ; <
                    dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_80a2            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_80a2              subroutine                      ; 
                    lda #$40                        ; 
                    sta M2Z_19                      ; 
                    lda #$01                        ; 
                    sta M2Z_1a                      ; 
                    lda #$00                        ; 
                    sta M2Z_1b                      ; 
                    lda #$40                        ; 
                    sta M2Z_1c                      ; 
                    ldx #$00                        ; 
B_80b4              ldy #$08                        ; 
B_80b6              lda M2Z_1c                      ; 
                    sta XT_0ac8,x                   ; 
                    lda M2Z_1b                      ; 
                    sta XT_0a00,x                   ; 
                    inx                             ; 
                    inc M2Z_1b                      ; 
                    dey                             ; 
                    bne B_80b6                      ; 
                    and #$f0                        ; 
                    clc                             ; 
                    adc M2Z_19                      ; 
                    sta M2Z_1b                      ; 
                    lda M2Z_1a                      ; 
                    adc M2Z_1c                      ; 
                    sta M2Z_1c                      ; 
                    cpx #$c8                        ; 
                    bcc B_80b4                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_80d8            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_80d8              subroutine                      ; 
                    lda #$00                        ; 
                    sta M2Z_2b                      ; 
                    lda #$70                        ; 
                    sta M2Z_2c                      ; 
                    lda #$00                        ; 
                    sta M2Z_29                      ; 
                    lda #$72                        ; 
                    sta M2Z_2a                      ; 
                    lda #$40                        ; 
                    sta M2Z_2d                      ; 
B_80ec              ldy #$07                        ; 
B_80ee              lda (M2Z_2b),y                  ; 
                    jsr S_8126                      ; 
                    lda M2Z_19                      ; 
                    sta (M2Z_29),y                  ; 
                    lda M2Z_1a                      ; 
                    sta M2Z_0038,y                  ; 
                    dey                             ; 
                    bpl B_80ee                      ; 
                    ldy #$0f                        ; 
                    ldx #$07                        ; 
B_8103              lda M2Z_38,x                    ; 
                    sta (M2Z_29),y                  ; 
                    dey                             ; 
                    dex                             ; 
                    bpl B_8103                      ; 
                    clc                             ; 
                    lda #$08                        ; 
                    adc M2Z_2b                      ; 
                    sta M2Z_2b                      ; 
                    bcc B_8116                      ; 
                    inc M2Z_2c                      ; 
B_8116              clc                             ; 
                    lda #$10                        ; 
                    adc M2Z_29                      ; 
                    sta M2Z_29                      ; 
                    bcc B_8121                      ; 
                    inc M2Z_2a                      ; 
B_8121              dec M2Z_2d                      ; 
                    bne B_80ec                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8126            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8126              subroutine                      ; 
                    ldx #$04                        ; 
B_8128              asl a                           ; 
                    php                             ; 
                    rol M2Z_19                      ; 
                    plp                             ; 
                    rol M2Z_19                      ; 
                    dex                             ; 
                    bne B_8128                      ; 
                    ldx #$04                        ; 
B_8134              asl a                           ; 
                    php                             ; 
                    rol M2Z_1a                      ; 
                    plp                             ; 
                    rol M2Z_1a                      ; 
                    dex                             ; 
                    bne B_8134                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_813f              lda #$ff                        ; 
                    sta M2Z_a2                      ; 
                    bne B_814c                      ; 
B_8145              jsr S_9ea0                      ; 
                    lda M2Z_a2                      ; 
                    bpl B_8153                      ; 
B_814c              jsr S_815d                      ; 
J_814f              lda M2Z_a2                      ; 
                    bmi B_8145                      ; 
B_8153              lda #$00                        ; 
                    sta M2Z_a2                      ; 
                    jsr S_815d                      ; 
                    jmp J_814f                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_815d            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_815d              subroutine                      ; 
                    lda #$00                        ; 
                    ldx #$05                        ; 
B_8161              sta M2Z_50,x                    ; 
                    dex                             ; 
                    bpl B_8161                      ; 
                    lda #$03                        ; 
                    sta M2Z_9f                      ; 
                    lda #$00                        ; 
                    sta M2Z_a3                      ; 
J_816e              jsr S_9ea3                      ; 
                    jsr S_8919                      ; 
                    lda M2Z_a1                      ; 
                    inc M2Z_a1                      ; 
                    and #$07                        ; 
                    asl a                           ; 
                    tax                             ; 
                    lda T_82cb,x                    ; 
                    pha                             ; 
                    inx                             ; 
                    lda T_82cb,x                    ; 
                    jsr S_891c                      ; 
                    pla                             ; 
                    jsr S_891f                      ; 
                    lda #$00                        ; 
                    sta M2Z_07                      ; 
                    sta M2Z_08                      ; 
                    sta M2Z_06                      ; 
                    sta M2Z_05                      ; 
                    sta EXTCOL                      ; VIC($D020) Border Color
                    sta YXPAND                      ; VIC($D017) Sprite Scale Double Width
                    sta BGCOL0                      ; VIC($D021) Background Color 0
                    sta SPBGPR                      ; VIC($D01B) Sprite to Foreground Display Priority
                    lda SPSPCL                      ; VIC($D01E) Sprite-Sprite Collision - Cleared on read
                    lda #$08                        ; 
                    sta SPMC0                       ; VIC($D025) Sprite Multicolor Register 0
                    lda #$0e                        ; 
                    sta SPMC1                       ; VIC($D026) Sprite Multicolor Register 1
                    lda #$0a                        ; 
                    ldx M2Z_a2                      ; 
                    bmi B_81b6                      ; 
                    lda M2Z_a3                      ; 
B_81b6              asl a                           ; 
                    tax                             ; 
                    lda T_81cc,x                    ; 
                    sta M2Z_27                      ; 
                    inx                             ; 
                    lda T_81cc,x                    ; 
                    sta M2Z_28                      ; 
                    jsr S_81c9                      ; 
                    jmp J_81e2                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_81c9            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_81c9              subroutine                      ; 
                    jmp (M2Z_0027)                  ; 
T_81cc              dc.b $50 ; p
                    dc.b $84 ; 
                    dc.b $53 ; s
                    dc.b $84 ; 
A_81d0              dc.b $56 ; v
                    dc.b $84 ; 
                    dc.b $59 ; y
                    dc.b $84 ; 
                    dc.b $5c ; 
                    dc.b $84 ; 
                    dc.b $5f ; <arrow left>
                    dc.b $84 ; 
                    dc.b $62 ; B
                    dc.b $84 ; 
                    dc.b $65 ; E
                    dc.b $84 ; 
                    dc.b $68 ; H
                    dc.b $84 ; 
                    dc.b $6b ; K
                    dc.b $84 ; 
A_81e0              dc.b $6e ; N
                    dc.b $84 ; 
J_81e2              lda #$00                        ; split
                    sta SIGVOL                      ; SID($D418) Volume/Filter Select
B_81e7              lda M2Z_a2                      ; 
                    beq B_81f2                      ; 
                    lda #$00                        ; 
                    sta M2Z_9f                      ; 
                    jmp J_8282                      ; 
B_81f2              lda M2Z_06                      ; 
                    cmp #$41                        ; 
                    bne B_81e7                      ; 
                    lda M2Z_a0                      ; 
                    bpl B_821c                      ; 
                    and #$0f                        ; 
                    bne B_820f                      ; 
                    inc M2Z_a3                      ; 
                    lda M2Z_a3                      ; 
                    cmp #$0a                        ; 
                    bcc J_8282                      ; 
                    lda #$00                        ; 
                    sta M2Z_a3                      ; 
                    jmp J_8282                      ; 
B_820f              cmp #$0a                        ; 
                    sta M2Z_a3                      ; 
                    bcc J_8282                      ; 
                    lda #$00                        ; 
                    sta M2Z_a3                      ; 
                    jmp J_8282                      ; 
B_821c              dec M2Z_9f                      ; 
                    bne J_8282                      ; 
                    lda #$2c                        ; 
                    sta M2Z_1d                      ; 
                    lda #$48                        ; 
                    sta M2Z_1f                      ; 
                    ldx #$0a                        ; 
B_822a              lda T_82db,x                    ; 
                    sta FRELO3,x                    ; SID($D40E) Oscillator 3 Freq Ctrl (low byte)
                    dex                             ; 
                    bpl B_822a                      ; 
B_8233              lda #$20                        ; 
                    ldx #$60                        ; 
                    jsr S_82ba                      ; 
                    lda #$20                        ; 
                    ldx #$68                        ; 
                    jsr S_82ba                      ; 
                    inc M2Z_1d                      ; 
                    ldx #$08                        ; 
B_8245              ldy #$00                        ; 
B_8247              dey                             ; 
                    bne B_8247                      ; 
                    dex                             ; 
                    bne B_8245                      ; 
                    lda M2Z_1f                      ; 
                    lsr a                           ; 
                    sta FREHI3                      ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                    dec M2Z_1f                      ; 
                    bne B_8233                      ; 
                    sta SIGVOL                      ; SID($D418) Volume/Filter Select
                    lda #$e6                        ; 
                    sta M2Z_88                      ; 
                    lda #$82                        ; 
                    sta M2Z_89                      ; 
                    ldx #$ff                        ; 
                    ldy #$ff                        ; 
                    jsr S_955c                      ; 
                    lda #$00                        ; 
                    sta M2Z_19                      ; 
                    sta M2Z_1a                      ; 
B_826f              jsr S_8925                      ; 
                    lda M2Z_4b                      ; 
                    bne J_8282                      ; 
                    dec M2Z_19                      ; 
                    bne B_826f                      ; 
                    dec M2Z_1a                      ; 
                    bne B_826f                      ; 
                    lda #$ff                        ; 
                    sta M2Z_a2                      ; 
J_8282              lda #$00                        ; 
                    tax                             ; 
B_8285              sta XT_0d00,x                   ; 
                    dex                             ; 
                    bne B_8285                      ; 
                    lda #$c7                        ; 
                    sta M2Z_44                      ; 
B_828f              lda #$9f                        ; 
                    sta M2Z_43                      ; 
B_8293              jsr S_8910                      ; 
                    lda #$00                        ; 
                    tay                             ; 
                    sta (M2Z_45),y                  ; 
                    dec M2Z_43                      ; 
                    bne B_8293                      ; 
                    dec M2Z_44                      ; 
                    bne B_828f                      ; 
                    sei                             ; 
                    lda #$00                        ; 
                    sta IRQMASK                     ; VIC($D01A) IRQ Mask Register
                    lda SCROLY                      ; VIC($D011) VIC Control Register 1 (and Vertical Fine Scrolling)
                    and #$ef                        ; 
                    sta SCROLY                      ; VIC($D011) VIC Control Register 1 (and Vertical Fine Scrolling)
                    cli                             ; 
                    lda M2Z_9f                      ; 
                    beq B_82b9                      ; 
                    jmp J_816e                      ; 
B_82b9              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_82ba            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_82ba              subroutine                      ; 
                    stx M2Z_44                      ; 
                    ldx M2Z_1d                      ; 
                    stx M2Z_43                      ; 
                    jsr S_9c69                      ; 
                    ldx #$ff                        ; 
                    ldy #$ff                        ; 
                    jsr S_955f                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
T_82cb              dc.b $03 ; 
                    dc.b $42 ; b
                    dc.b $05 ; <WHITE>
                    dc.b $a9 ; 
                    dc.b $0e ; <to lower>
A_82d0              dc.b $86 ; <f3>
                    dc.b $0d ; <enter>
                    dc.b $78 ; X
                    dc.b $0c ; 
                    dc.b $a4 ; 
                    dc.b $06 ; 
                    dc.b $32 ; 2
                    dc.b $07 ; 
                    dc.b $4c ; l
                    dc.b $04 ; 
                    dc.b $7f ; 
T_82db              dc.b $80 ; 
                    dc.b $24 ; $
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $41 ; a
A_82e0              dc.b $2d ; -
                    dc.b $35 ; 5
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0c ; 
                    dc.b $30 ; 0
                    dc.b $64 ; D
                    dc.b $38 ; 8
                    dc.b $38 ; 8
                    dc.b $64 ; D
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $40 ; @
                    dc.b $64 ; D
                    dc.b $68 ; H
                    dc.b $48 ; h
A_82f0              dc.b $64 ; D
                    dc.b $28 ; (
                    dc.b $58 ; x
                    dc.b $64 ; D
                    dc.b $78 ; X
                    dc.b $60 ; 
                    dc.b $64 ; D
                    dc.b $b0 ; 
                    dc.b $68 ; H
                    dc.b $64 ; D
                    dc.b $28 ; (
                    dc.b $70 ; P
                    dc.b $64 ; D
                    dc.b $90 ; <BLACK>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    ldx M2Z_05                      ; 
                    bne B_831d                      ; 
                    lda #$18                        ; 
                    sta SCROLX                      ; VIC($D016) VIC Control Register 2 (and Horizontal Fine Scrolling)
                    lda #$80                        ; 
                    sta VMCSB                       ; VIC($D018) VIC Chip Memory Control
                    lda #$3b                        ; 
                    sta SCROLY                      ; VIC($D011) VIC Control Register 1 (and Vertical Fine Scrolling)
                    lda M2Z_92                      ; 
                    sta RASTER                      ; VIC($D012) Read : Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                    inc M2Z_05                      ; 
                    jmp J_83a7                      ; 
B_831d              dex                             ; 
                    bne B_8355                      ; 
                    lda #$fa                        ; 
                    sta RASTER                      ; VIC($D012) Read : Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                    inc M2Z_05                      ; 
                    lda M2Z_06                      ; 
                    lsr a                           ; 
                    bcc B_833a                      ; 
                    lda SPSPCL                      ; VIC($D01E) Sprite-Sprite Collision - Cleared on read
                    lsr a                           ; 
                    bcc B_833a                      ; 
                    and #$0f                        ; 
                    beq B_833a                      ; 
                    ora M2Z_07                      ; 
                    sta M2Z_07                      ; 
B_833a              ldy #$04                        ; 
B_833c              tya                             ; 
                    asl a                           ; 
                    tax                             ; 
                    lda M2Z_6c,x                    ; 
                    sta M2Z_17                      ; 
                    lda M2Z_6d,x                    ; 
                    sta M2Z_18                      ; 
                    tya                             ; 
                    tax                             ; 
                    pha                             ; 
                    jsr S_83b5                      ; 
                    pla                             ; 
                    tay                             ; 
                    dey                             ; 
                    bne B_833c                      ; 
                    jmp J_83a7                      ; 
B_8355              ldx #$00                        ; 
                    stx M2Z_05                      ; 
                    lda #$1b                        ; 
                    sta SCROLY                      ; VIC($D011) VIC Control Register 1 (and Vertical Fine Scrolling)
                    lda #$08                        ; 
                    sta SCROLX                      ; VIC($D016) VIC Control Register 2 (and Horizontal Fine Scrolling)
                    lda #$8c                        ; 
                    sta VMCSB                       ; VIC($D018) VIC Chip Memory Control
                    lda #$3a                        ; 
                    sta RASTER                      ; VIC($D012) Read : Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                    lda M2Z_06                      ; 
                    lsr a                           ; 
                    bcc B_8380                      ; 
                    lda SPSPCL                      ; VIC($D01E) Sprite-Sprite Collision - Cleared on read
                    lsr a                           ; 
                    bcc B_8380                      ; 
                    and #$0f                        ; 
                    beq B_8380                      ; 
                    ora M2Z_08                      ; 
                    sta M2Z_08                      ; 
B_8380              ldy #$07                        ; 
B_8382              tya                             ; 
                    asl a                           ; 
                    tax                             ; 
                    lda M2Z_5c,x                    ; 
                    sta M2Z_17                      ; 
                    lda M2Z_5d,x                    ; 
                    sta M2Z_18                      ; 
                    tya                             ; 
                    tax                             ; 
                    pha                             ; 
                    jsr S_83b5                      ; 
                    pla                             ; 
                    tay                             ; 
                    dey                             ; 
                    bpl B_8382                      ; 
                    lda M2Z_06                      ; 
                    lsr a                           ; 
                    bcs B_83a5                      ; 
                    lda SPENA                       ; VIC($D015) Sprite Enable Register
                    and #$1f                        ; 
                    sta SPENA                       ; VIC($D015) Sprite Enable Register
B_83a5              inc M2Z_06                      ; 
J_83a7              lda SPSPCL                      ; VIC($D01E) Sprite-Sprite Collision - Cleared on read
                    lda #$01                        ; 
                    sta VICIRQ                      ; VIC($D019) Interrupt Flags - Latched flags cleared if set to 1
                    pla                             ; 
                    tay                             ; 
                    pla                             ; 
                    tax                             ; 
                    pla                             ; 
                    rti                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_83b5            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_83b5              subroutine                      ; 
                    stx M2Z_13                      ; 
                    txa                             ; 
                    asl a                           ; 
                    sta M2Z_14                      ; 
                    lda T_8444,x                    ; 
                    sta M2Z_15                      ; 
                    eor #$ff                        ; 
                    sta M2Z_16                      ; 
                    ldy #$07                        ; 
B_83c6              lda (M2Z_17),y                  ; 
                    sta M2Z_000b,y                  ; 
                    dey                             ; 
                    bpl B_83c6                      ; 
                    lda M2Z_0b                      ; 
                    and M2Z_15                      ; 
                    sta M2Z_09                      ; 
                    lda SPENA                       ; VIC($D015) Sprite Enable Register
                    and M2Z_16                      ; 
                    ora M2Z_09                      ; 
                    sta SPENA                       ; VIC($D015) Sprite Enable Register
                    ldx M2Z_14                      ; 
                    lda M2Z_0d                      ; 
                    sta SP0Y,x                      ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                    ldy M2Z_0c                      ; 
                    lda M2Z_11                      ; 
                    and M2Z_15                      ; 
                    sta M2Z_11                      ; 
                    beq B_83f4                      ; 
                    tya                             ; 
                    sec                             ; 
                    sbc #$04                        ; 
                    tay                             ; 
B_83f4              tya                             ; 
                    asl a                           ; 
                    sta SP0X,x                      ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                    lda #$00                        ; 
                    bcc B_83ff                      ; 
                    lda #$ff                        ; 
B_83ff              and M2Z_15                      ; 
                    sta M2Z_09                      ; 
                    lda MSIGX                       ; VIC($D010) MSB X-Pos Sprites 0-7
                    and M2Z_16                      ; 
                    ora M2Z_09                      ; 
                    sta MSIGX                       ; VIC($D010) MSB X-Pos Sprites 0-7
                    lda M2Z_0e                      ; 
                    ldx M2Z_13                      ; 
                    sta XT_63f8,x                   ; 
                    lda M2Z_0f                      ; 
                    sta SP0COL,x                    ; VIC($D027) Color Sprite 0
                    lda M2Z_10                      ; 
                    and M2Z_15                      ; 
                    sta M2Z_09                      ; 
                    lda SPBGPR                      ; VIC($D01B) Sprite to Foreground Display Priority
                    and M2Z_16                      ; 
                    ora M2Z_09                      ; 
                    sta SPBGPR                      ; VIC($D01B) Sprite to Foreground Display Priority
                    lda XXPAND                      ; VIC($D01D) Sprite Double Height
                    and M2Z_16                      ; 
                    ora M2Z_11                      ; 
                    sta XXPAND                      ; VIC($D01D) Sprite Double Height
                    lda M2Z_12                      ; 
                    and M2Z_15                      ; 
                    sta M2Z_09                      ; 
                    lda SPMC                        ; VIC($D01C) Sprite Multicolor
                    and M2Z_16                      ; 
                    ora M2Z_09                      ; 
                    sta SPMC                        ; VIC($D01C) Sprite Multicolor
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
T_8444              dc.b $01 ; 
                    dc.b $02 ; 
                    dc.b $04 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $40 ; @
                    dc.b $80 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    jmp J_8471                      ; 
                    jmp J_84b7                      ; 
                    jmp J_84c1                      ; 
                    jmp J_84d4                      ; 
                    jmp J_84de                      ; 
                    jmp J_8531                      ; 
                    jmp J_85b4                      ; 
                    jmp J_85da                      ; 
                    jmp J_8664                      ; 
                    jmp J_8694                      ; 
                    jmp J_8710                      ; 
J_8471              ldx #$98                        ; 
                    ldy #$ad                        ; 
                    jsr S_8498                      ; 
J_8478              jsr S_8f49                      ; 
                    jsr S_87df                      ; 
B_847e              jsr S_8487                      ; 
                    jsr S_84a7                      ; 
                    bcc B_847e                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8487            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8487              subroutine                      ; 
                    lda M2Z_06                      ; 
                    cmp #$02                        ; 
                    bcc S_8487                      ; 
                    lda #$00                        ; 
                    sta M2Z_06                      ; 
                    jsr S_8f4c                      ; 
                    jsr S_8f5b                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8498            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8498              subroutine                      ; 
                    stx M2Z_27                      ; 
                    sty M2Z_28                      ; 
                    ldy #$3f                        ; 
B_849e              lda (M2Z_27),y                  ; 
                    sta M2Z_005c,y                  ; 
                    dey                             ; 
                    bpl B_849e                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_84a7            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_84a7              subroutine                      ; 
                    jsr S_8f55                      ; 
                    jsr S_8f58                      ; 
                    jsr S_87e2                      ; 
                    jsr S_8f4f                      ; 
                    jsr S_8f52                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_84b7              ldx #$62                        ; 
                    ldy #$af                        ; 
                    jsr S_8498                      ; 
                    jmp J_8478                      ; 
J_84c1              ldx #$99                        ; 
                    ldy #$af                        ; 
                    jsr S_8498                      ; 
                    jsr S_8f49                      ; 
                    jsr S_9550                      ; 
                    jsr S_87df                      ; 
                    jmp B_847e                      ; 
J_84d4              ldx #$86                        ; 
                    ldy #$b1                        ; 
                    jsr S_8498                      ; 
                    jmp J_8478                      ; 
J_84de              ldx #$2b                        ; 
                    ldy #$b3                        ; 
                    jsr S_8498                      ; 
                    jsr S_8f49                      ; 
                    ldy #$1b                        ; 
B_84ea              lda (M2Z_86),y                  ; 
                    sta XT_0c00,y                   ; 
                    dey                             ; 
                    bpl B_84ea                      ; 
                    jsr S_87df                      ; 
B_84f5              jsr S_8487                      ; 
                    jsr S_9559                      ; 
                    lda XT_0d01                     ; 
                    cmp #$12                        ; 
                    bcs B_8511                      ; 
                    lda XT_0d02                     ; 
                    cmp #$c0                        ; 
                    bcc B_8511                      ; 
                    cmp #$e0                        ; 
                    bcs B_8511                      ; 
                    lda #$ff                        ; 
                    sta M2Z_4f                      ; 
B_8511              lda RASTER                      ; VIC($D012) Read : Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                    and #$07                        ; 
                    sta M2Z_19                      ; 
                    lda XT_6320                     ; 
                    and #$f0                        ; 
                    ora M2Z_19                      ; 
                    sta XT_6320                     ; 
                    sta XT_6321                     ; 
                    sta XT_6348                     ; 
                    sta XT_6349                     ; 
                    jsr S_84a7                      ; 
                    bcc B_84f5                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8531              ldx #$57                        ; 
                    ldy #$b5                        ; 
                    jsr S_8498                      ; 
                    lda #$aa                        ; 
                    ldx #$f0                        ; 
B_853c              sta XT_5a67,x                   ; 
                    sta XT_5ba7,x                   ; 
                    sta XT_5ce7,x                   ; 
                    sta XT_5e27,x                   ; 
                    dex                             ; 
                    bne B_853c                      ; 
                    jsr S_8f49                      ; 
                    ldy #$09                        ; 
B_8550              lda (M2Z_86),y                  ; 
                    sta XT_0c00,y                   ; 
                    dey                             ; 
                    bpl B_8550                      ; 
                    ldx #$ff                        ; 
                    ldy #$aa                        ; 
                    jsr S_955c                      ; 
                    jsr S_87df                      ; 
B_8562              jsr S_8487                      ; 
                    jsr S_9559                      ; 
                    lda XT_0d02                     ; 
                    cmp #$c5                        ; 
                    bcc B_8599                      ; 
                    lda XT_0d01                     ; 
                    cmp #$17                        ; 
                    beq B_8587                      ; 
                    cmp #$1f                        ; 
                    beq B_8582                      ; 
                    cmp #$91                        ; 
                    beq B_8587                      ; 
                    cmp #$99                        ; 
                    bne B_858a                      ; 
B_8582              inc XT_0d01                     ; 
                    bne B_858a                      ; 
B_8587              dec XT_0d01                     ; 
B_858a              lda XT_0d01                     ; 
                    cmp #$1f                        ; 
                    bcc B_8599                      ; 
                    cmp #$99                        ; 
                    bcs B_8599                      ; 
                    lda #$ff                        ; 
                    sta M2Z_4f                      ; 
B_8599              lda XT_6348                     ; 
                    and #$0f                        ; 
                    cmp #$05                        ; 
                    bcc B_85a4                      ; 
                    lda #$00                        ; 
B_85a4              adc #$c1                        ; 
                    ldx #$a0                        ; 
B_85a8              sta XT_6347,x                   ; 
                    dex                             ; 
                    bne B_85a8                      ; 
                    jsr S_84a7                      ; 
                    bcc B_8562                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_85b4              ldy #$b7                        ; 
                    ldx #$14                        ; 
                    jsr S_8498                      ; 
                    jsr S_8f49                      ; 
                    jsr S_9550                      ; 
                    ldy #$24                        ; 
B_85c3              lda (M2Z_86),y                  ; 
                    sta XT_0c00,y                   ; 
                    dey                             ; 
                    bpl B_85c3                      ; 
                    jsr S_87df                      ; 
B_85ce              jsr S_8487                      ; 
                    jsr S_9559                      ; 
                    jsr S_84a7                      ; 
                    bcc B_85ce                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_85da              ldx #$80                        ; 
                    ldy #$b9                        ; 
                    jsr S_8498                      ; 
                    jsr S_8f49                      ; 
                    lda #$64                        ; 
                    sta M2Z_af                      ; 
                    lda #$a9                        ; 
                    sta M2Z_b0                      ; 
                    ldy #$1b                        ; 
B_85ee              lda (M2Z_8e),y                  ; 
                    sta XT_0d8c,y                   ; 
                    dey                             ; 
                    bpl B_85ee                      ; 
                    lda #$17                        ; 
                    sta M2Z_27                      ; 
                    lda #$62                        ; 
                    sta M2Z_28                      ; 
                    lda #$0c                        ; 
                    sta M2Z_19                      ; 
                    lda #$17                        ; 
                    sta M2Z_25                      ; 
                    lda #$da                        ; 
                    sta M2Z_26                      ; 
B_860a              ldy #$0f                        ; 
B_860c              lda #$11                        ; 
                    sta (M2Z_27),y                  ; 
                    sta (M2Z_25),y                  ; 
                    dey                             ; 
                    bpl B_860c                      ; 
                    clc                             ; 
                    lda #$28                        ; 
                    adc M2Z_27                      ; 
                    sta M2Z_27                      ; 
                    bcc B_8620                      ; 
                    inc M2Z_28                      ; 
B_8620              clc                             ; 
                    lda #$28                        ; 
                    adc M2Z_25                      ; 
                    sta M2Z_25                      ; 
                    bcc B_862b                      ; 
                    inc M2Z_26                      ; 
B_862b              dec M2Z_19                      ; 
                    bne B_860a                      ; 
                    jsr S_87df                      ; 
B_8632              lda M2Z_06                      ; 
                    cmp #$02                        ; 
                    bcc B_8632                      ; 
                    lda #$00                        ; 
                    sta M2Z_06                      ; 
                    jsr S_8f4c                      ; 
                    jsr S_997e                      ; 
                    lda M2Z_b1                      ; 
                    bpl B_864c                      ; 
                    jsr S_9981                      ; 
                    jmp J_8652                      ; 
B_864c              jsr S_8f5b                      ; 
                    jsr S_8f58                      ; 
J_8652              jsr S_8f55                      ; 
                    jsr S_9984                      ; 
                    jsr S_8f4f                      ; 
                    jsr S_87e2                      ; 
                    jsr S_8f52                      ; 
                    bcc B_8632                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8664              ldx #$7d                        ; 
                    ldy #$bb                        ; 
                    jsr S_8498                      ; 
                    ldy #$0e                        ; 
B_866d              lda (M2Z_8c),y                  ; 
                    sta XT_0c74,y                   ; 
                    dey                             ; 
                    bpl B_866d                      ; 
                    ldy #$36                        ; 
B_8677              lda (M2Z_86),y                  ; 
                    sta XT_0c00,y                   ; 
                    dey                             ; 
                    bpl B_8677                      ; 
                    jsr S_8f49                      ; 
                    jsr S_87df                      ; 
B_8685              jsr S_8487                      ; 
                    jsr S_9562                      ; 
                    jsr S_998d                      ; 
                    jsr S_84a7                      ; 
                    bcc B_8685                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8694              ldx #$99                        ; 
                    ldy #$bd                        ; 
                    jsr S_8498                      ; 
                    ldx #$00                        ; 
                    ldy #$aa                        ; 
                    jsr S_955c                      ; 
                    lda #$3d                        ; 
                    ldx #$52                        ; 
                    ldy #$10                        ; 
                    jsr S_9c66                      ; 
                    lda #$30                        ; 
                    ldx #$6a                        ; 
                    ldy #$10                        ; 
                    jsr S_9c66                      ; 
                    lda #$00                        ; 
                    ldx #$0d                        ; 
B_86b8              sta XT_6129,x                   ; 
                    dex                             ; 
                    bpl B_86b8                      ; 
                    lda XT_6330                     ; 
                    and #$0f                        ; 
                    ora #$b0                        ; 
                    tay                             ; 
                    ldx #$10                        ; 
                    tya                             ; 
B_86c9              lda #$bb                        ; 
                    sta XT_6330,x                   ; 
                    sta XT_6383,x                   ; 
                    sta XT_6380,x                   ; 
                    sta XT_63a8,x                   ; 
                    tya                             ; 
                    sta XT_63d0,x                   ; 
                    dex                             ; 
                    bpl B_86c9                      ; 
                    lda #$6e                        ; 
                    sta M2Z_b3                      ; 
                    lda #$00                        ; 
                    sta M2Z_b4                      ; 
                    sta M2Z_b5                      ; 
                    sta M2Z_b6                      ; 
                    sta M2Z_b7                      ; 
                    jsr S_8f49                      ; 
                    jsr S_87df                      ; 
B_86f2              jsr S_8487                      ; 
                    jsr S_9c5d                      ; 
                    jsr S_8f55                      ; 
                    jsr S_9c60                      ; 
                    jsr S_9c63                      ; 
                    jsr S_8f58                      ; 
                    jsr S_87e2                      ; 
                    jsr S_8f4f                      ; 
                    jsr S_8f52                      ; 
                    bcc B_86f2                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8710              ldx #$98                        ; 
                    ldy #$ad                        ; 
                    jsr S_8498                      ; 
                    jsr S_8f49                      ; 
                    jsr S_87df                      ; 
                    lda #$00                        ; 
                    sta M2Z_d6                      ; 
                    lda XT_0d01                     ; 
                    sta M2Z_d4                      ; 
B_8726              lda M2Z_06                      ; 
                    eor #$02                        ; 
                    bne B_8726                      ; 
                    sta M2Z_06                      ; 
                    jsr S_8f4c                      ; 
                    jsr S_8925                      ; 
                    lda M2Z_4b                      ; 
                    beq B_873d                      ; 
                    lda #$01                        ; 
                    sta M2Z_a2                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_873d              lda M2Z_d4                      ; 
                    beq B_8748                      ; 
                    cmp XT_0d01                     ; 
                    bne B_8782                      ; 
                    beq B_8755                      ; 
B_8748              ldx M2Z_d5                      ; 
                    cpx XT_0d02                     ; 
                    beq B_8755                      ; 
                    dex                             ; 
                    cpx XT_0d02                     ; 
                    bne B_8782                      ; 
B_8755              ldx M2Z_d6                      ; 
                    lda T_87ac,x                    ; 
                    sta M2Z_d4                      ; 
                    lda T_87c1,x                    ; 
                    sta M2Z_d5                      ; 
                    ldy #$00                        ; 
                    lda T_8797,x                    ; 
                    bpl B_8769                      ; 
                    dey                             ; 
B_8769              sty M2Z_d9                      ; 
                    and #$03                        ; 
                    tay                             ; 
                    lda T_8794,y                    ; 
                    sta M2Z_d7                      ; 
                    lda T_8797,x                    ; 
                    lsr a                           ; 
                    lsr a                           ; 
                    and #$03                        ; 
                    tay                             ; 
                    lda T_8794,y                    ; 
                    sta M2Z_d8                      ; 
                    inc M2Z_d6                      ; 
B_8782              ldx #$02                        ; 
B_8784              lda M2Z_d7,x                    ; 
                    sta M2Z_49,x                    ; 
                    dex                             ; 
                    bpl B_8784                      ; 
                    jsr S_8928                      ; 
                    jsr S_84a7                      ; 
                    bcc B_8726                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
T_8794              dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $ff ; 
T_8797              dc.b $01 ; 
                    dc.b $80 ; 
                    dc.b $01 ; 
                    dc.b $82 ; 
                    dc.b $01 ; 
                    dc.b $02 ; 
                    dc.b $09 ; <SHIFT C= on>
                    dc.b $0a ; 
                    dc.b $82 ; 
A_87a0              dc.b $02 ; 
                    dc.b $80 ; 
                    dc.b $81 ; <ORANGE>
                    dc.b $01 ; 
                    dc.b $0a ; 
                    dc.b $02 ; 
                    dc.b $01 ; 
                    dc.b $81 ; <ORANGE>
                    dc.b $01 ; 
                    dc.b $0a ; 
                    dc.b $09 ; <SHIFT C= on>
                    dc.b $02 ; 
T_87ac              dc.b $16 ; 
                    dc.b $00 ; 
                    dc.b $a4 ; 
                    dc.b $96 ; <LIGHT RED>
A_87b0              dc.b $98 ; <GREY 2>
                    dc.b $0c ; 
                    dc.b $00 ; 
                    dc.b $32 ; 2
                    dc.b $28 ; (
                    dc.b $13 ; <HOME>
                    dc.b $00 ; 
                    dc.b $19 ; 
                    dc.b $9b ; <GREY 3>
                    dc.b $4a ; j
                    dc.b $16 ; 
                    dc.b $25 ; %
                    dc.b $27 ; 
                    dc.b $9b ; <GREY 3>
                    dc.b $00 ; 
                    dc.b $9c ; <PURPLE>
A_87c0              dc.b $13 ; <HOME>
T_87c1              dc.b $00 ; 
                    dc.b $e2 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $b3 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_87d0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $5a ; z
                    dc.b $00 ; 
                    dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_87d6            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_87d6              subroutine                      ; 
                    jmp J_87e8                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_87d9            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_87d9              subroutine                      ; 
                    jmp J_883f                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_87dc            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_87dc              subroutine                      ; 
                    jmp J_8849                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_87df            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_87df              subroutine                      ; 
                    jmp J_88d7                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_87e2            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_87e2              subroutine                      ; 
                    jmp J_88f3                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_87e5            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_87e5              subroutine                      ; 
                    jmp J_88fd                      ; 
J_87e8              lda M2Z_43                      ; 
                    sta M2Z_21                      ; 
                    lda M2Z_44                      ; 
                    sta M2Z_22                      ; 
                    jsr S_890d                      ; 
                    jsr S_8916                      ; 
                    lda M2Z_22                      ; 
                    clc                             ; 
                    adc #$08                        ; 
                    sta M2Z_44                      ; 
                    jsr S_8833                      ; 
                    jsr S_890d                      ; 
                    jsr S_8916                      ; 
                    lda M2Z_22                      ; 
                    sta M2Z_44                      ; 
                    lda M2Z_21                      ; 
                    clc                             ; 
                    adc #$04                        ; 
                    sta M2Z_43                      ; 
                    jsr S_8833                      ; 
                    jsr S_890d                      ; 
                    jsr S_8916                      ; 
                    lda M2Z_22                      ; 
                    clc                             ; 
                    adc #$08                        ; 
                    sta M2Z_44                      ; 
                    jsr S_8833                      ; 
                    jsr S_890d                      ; 
                    jsr S_8916                      ; 
                    lda M2Z_21                      ; 
                    sta M2Z_43                      ; 
                    lda M2Z_22                      ; 
                    sta M2Z_44                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8833            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8833              subroutine                      ; 
                    clc                             ; 
                    lda #$08                        ; 
                    adc M2Z_41                      ; 
                    sta M2Z_41                      ; 
                    bcc B_883e                      ; 
                    inc M2Z_42                      ; 
B_883e              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_883f              lda #$00                        ; 
                    ldx #$05                        ; 
B_8843              sta M2Z_56,x                    ; 
                    dex                             ; 
                    bpl B_8843                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8849              ldx #$05                        ; 
                    clc                             ; 
B_884c              lda M2Z_50,x                    ; 
                    adc M2Z_56,x                    ; 
                    cmp #$0a                        ; 
                    bcc B_8859                      ; 
                    adc #$05                        ; 
                    and #$0f                        ; 
                    sec                             ; 
B_8859              sta M2Z_50,x                    ; 
                    dex                             ; 
                    bpl B_884c                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_885f            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_885f              subroutine                      ; 
                    ldx #$00                        ; 
                    stx M2Z_19                      ; 
B_8863              lda M2Z_50,x                    ; 
                    jsr S_8889                      ; 
                    sta XT_6000,x                   ; 
                    inx                             ; 
                    cpx #$03                        ; 
                    bcc B_8863                      ; 
                    lda #$20                        ; 
                    ldy M2Z_19                      ; 
                    beq B_8878                      ; 
                    lda #$2c                        ; 
B_8878              sta XT_6000,x                   ; 
B_887b              lda M2Z_50,x                    ; 
                    jsr S_8889                      ; 
                    sta XT_6001,x                   ; 
                    inx                             ; 
                    cpx #$06                        ; 
                    bcc B_887b                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8889            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8889              subroutine                      ; 
                    beq B_888d                      ; 
                    inc M2Z_19                      ; 
B_888d              cpx #$05                        ; 
                    bcs B_8898                      ; 
                    ldy M2Z_19                      ; 
                    bne B_8898                      ; 
                    lda #$20                        ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8898              ora #$30                        ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_889b            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_889b              subroutine                      ; 
                    lda #$20                        ; 
                    sta M2Z_19                      ; 
                    sta M2Z_1a                      ; 
                    sta M2Z_1b                      ; 
                    ldy M2Z_9f                      ; 
                    beq B_88b8                      ; 
                    dey                             ; 
                    beq B_88b8                      ; 
                    lda #$00                        ; 
                    sta M2Z_19                      ; 
                    dey                             ; 
                    beq B_88b8                      ; 
                    sta M2Z_1a                      ; 
                    dey                             ; 
                    beq B_88b8                      ; 
                    sta M2Z_1b                      ; 
B_88b8              lda M2Z_19                      ; 
                    sta XT_6008                     ; 
                    lda M2Z_1a                      ; 
                    sta XT_6009                     ; 
                    lda M2Z_1b                      ; 
                    sta XT_600a                     ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_88c8            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_88c8              subroutine                      ; 
                    lda M2Z_9c                      ; 
                    ora #$30                        ; 
                    sta XT_6014                     ; 
                    lda M2Z_9d                      ; 
                    ora #$30                        ; 
                    sta XT_6015                     ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_88d7              lda #$02                        ; 
                    sta M2Z_05                      ; 
B_88db              lda RASTER                      ; VIC($D012) Read : Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                    cmp #$fa                        ; 
                    bne B_88db                      ; 
                    lda #$fe                        ; 
                    sta RASTER                      ; VIC($D012) Read : Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                    lda #$01                        ; 
                    sta IRQMASK                     ; VIC($D01A) IRQ Mask Register
                    sta VICIRQ                      ; VIC($D019) Interrupt Flags - Latched flags cleared if set to 1
                    lda #$00                        ; 
                    sta M2Z_06                      ; 
J_88f3              jsr S_885f                      ; 
                    jsr S_889b                      ; 
                    jsr S_88c8                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_88fd              clc                             ; 
                    adc M2Z_27                      ; 
                    sta M2Z_27                      ; 
                    bcc B_8906                      ; 
                    inc M2Z_28                      ; 
B_8906              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8907            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8907              subroutine                      ; 
                    jmp J_892b                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_890a            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_890a              subroutine                      ; 
                    jmp J_8944                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_890d            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_890d              subroutine                      ; 
                    jmp J_8959                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8910            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8910              subroutine                      ; 
                    jmp J_8987                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8913            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8913              subroutine                      ; 
                    jmp J_89cb                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8916            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8916              subroutine                      ; 
                    jmp J_89a6                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8919            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8919              subroutine                      ; 
                    jmp J_8a61                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_891c            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_891c              subroutine                      ; 
                    jmp J_8a77                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_891f            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_891f              subroutine                      ; 
                    jmp J_8a8d                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8922            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8922              subroutine                      ; 
                    jmp J_8aa3                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8925            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8925              subroutine                      ; 
                    jmp J_8cf8                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8928            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8928              subroutine                      ; 
                    jmp J_8d1e                      ; 
J_892b              ldx #$00                        ; 
                    ldy #$00                        ; 
B_892f              lda (M2Z_2b),y                  ; 
                    sta (M2Z_29),y                  ; 
                    iny                             ; 
                    bne B_893b                      ; 
                    inx                             ; 
                    inc M2Z_2c                      ; 
                    inc M2Z_2a                      ; 
B_893b              cpy M2Z_2d                      ; 
                    bne B_892f                      ; 
                    cpx M2Z_2e                      ; 
                    bne B_892f                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8944              ldx #$00                        ; 
                    ldy #$00                        ; 
B_8948              sta (M2Z_29),y                  ; 
                    iny                             ; 
                    bne B_8950                      ; 
                    inx                             ; 
                    inc M2Z_2a                      ; 
B_8950              cpy M2Z_2d                      ; 
                    bne B_8948                      ; 
                    cpx M2Z_2e                      ; 
                    bne B_8948                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8959              lda #$00                        ; 
                    ldx #$08                        ; 
B_895d              sta M2Z_37,x                    ; 
                    dex                             ; 
                    bpl B_895d                      ; 
                    stx M2Z_40                      ; 
                    ldy #$07                        ; 
B_8966              lda (M2Z_41),y                  ; 
                    sta M2Z_002f,y                  ; 
                    dey                             ; 
                    bpl B_8966                      ; 
                    lda M2Z_43                      ; 
                    and #$03                        ; 
                    beq B_8986                      ; 
                    asl a                           ; 
                    tay                             ; 
B_8976              ldx #$07                        ; 
                    lsr M2Z_40                      ; 
                    ror M2Z_37                      ; 
B_897c              lsr M2Z_2f,x                    ; 
                    ror M2Z_38,x                    ; 
                    dex                             ; 
                    bpl B_897c                      ; 
                    dey                             ; 
                    bne B_8976                      ; 
B_8986              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8987              ldx M2Z_44                      ; 
                    lda XT_0a00,x                   ; 
                    sta M2Z_45                      ; 
                    lda XT_0ac8,x                   ; 
                    sta M2Z_46                      ; 
                    lda M2Z_43                      ; 
                    and #$fc                        ; 
                    asl a                           ; 
                    bcc B_899c                      ; 
                    inc M2Z_46                      ; 
B_899c              clc                             ; 
                    adc M2Z_45                      ; 
                    sta M2Z_45                      ; 
                    bcc B_89a5                      ; 
                    inc M2Z_46                      ; 
B_89a5              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_89a6              ldx #$00                        ; 
B_89a8              txa                             ; 
                    pha                             ; 
                    jsr S_8910                      ; 
                    pla                             ; 
                    tax                             ; 
                    ldy #$00                        ; 
                    lda (M2Z_45),y                  ; 
                    and M2Z_37                      ; 
                    ora M2Z_2f,x                    ; 
                    sta (M2Z_45),y                  ; 
                    ldy #$08                        ; 
                    lda (M2Z_45),y                  ; 
                    and M2Z_40                      ; 
                    ora M2Z_38,x                    ; 
                    sta (M2Z_45),y                  ; 
                    inc M2Z_44                      ; 
                    inx                             ; 
                    cpx #$08                        ; 
                    bne B_89a8                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_89cb              ldy #$04                        ; 
B_89cd              lda (M2Z_27),y                  ; 
                    sta M2Z_001d,y                  ; 
                    dey                             ; 
                    bpl B_89cd                      ; 
                    tay                             ; 
                    bne B_89d9                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_89d9              lda #$05                        ; 
                    jsr S_87e5                      ; 
                    lda M2Z_21                      ; 
                    and #$07                        ; 
                    sta M2Z_24                      ; 
                    lda M2Z_21                      ; 
                    and #$f8                        ; 
                    bpl B_89ef                      ; 
                    and #$78                        ; 
                    clc                             ; 
                    adc #$08                        ; 
B_89ef              sta M2Z_23                      ; 
                    lda M2Z_21                      ; 
                    jsr S_bfd0                      ; 
                    nop                             ; 
                    lda M2Z_20                      ; 
                    lsr a                           ; 
                    lsr a                           ; 
                    lsr a                           ; 
                    lsr a                           ; 
                    cmp #$0f                        ; 
                    bne B_8a03                      ; 
                    ora #$f0                        ; 
B_8a03              sta M2Z_21                      ; 
                    lda M2Z_20                      ; 
                    and #$0f                        ; 
                    cmp #$0f                        ; 
                    bne B_8a0f                      ; 
                    ora #$f0                        ; 
B_8a0f              sta M2Z_20                      ; 
                    lda #$00                        ; 
                    sta M2Z_1c                      ; 
J_8a15              inc M2Z_1c                      ; 
                    lda M2Z_1c                      ; 
                    lsr a                           ; 
                    ldx M2Z_22                      ; 
                    bcs B_8a20                      ; 
                    ldx M2Z_23                      ; 
B_8a20              stx M2Z_41                      ; 
                    lda #$a0                        ; 
                    sta M2Z_42                      ; 
                    lda M2Z_1e                      ; 
                    sta M2Z_43                      ; 
                    lda M2Z_1f                      ; 
                    sta M2Z_44                      ; 
                    jsr S_890d                      ; 
                    lda #$ff                        ; 
                    sta M2Z_37                      ; 
                    sta M2Z_40                      ; 
                    lda #$00                        ; 
                    ldx M2Z_24                      ; 
                    beq B_8a46                      ; 
B_8a3d              sta M2Z_2e,x                    ; 
                    sta M2Z_37,x                    ; 
                    dex                             ; 
                    bne B_8a3d                      ; 
                    stx M2Z_24                      ; 
B_8a46              jsr S_8916                      ; 
                    dec M2Z_1d                      ; 
                    bne B_8a50                      ; 
                    jmp J_89cb                      ; 
B_8a50              clc                             ; 
                    lda M2Z_1e                      ; 
                    adc M2Z_20                      ; 
                    sta M2Z_1e                      ; 
                    clc                             ; 
                    lda M2Z_1f                      ; 
                    adc M2Z_21                      ; 
                    sta M2Z_1f                      ; 
                    jmp J_8a15                      ; 
J_8a61              lda #$00                        ; 
                    sta M2Z_29                      ; 
                    lda #$40                        ; 
                    sta M2Z_2a                      ; 
                    lda #$00                        ; 
                    sta M2Z_2d                      ; 
                    lda #$20                        ; 
                    sta M2Z_2e                      ; 
                    lda #$00                        ; 
                    jsr S_890a                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8a77              pha                             ; 
                    lda #$e8                        ; 
                    sta M2Z_2d                      ; 
                    lda #$03                        ; 
                    sta M2Z_2e                      ; 
                    lda #$00                        ; 
                    sta M2Z_29                      ; 
                    lda #$60                        ; 
                    sta M2Z_2a                      ; 
                    pla                             ; 
                    jsr S_890a                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8a8d              pha                             ; 
                    lda #$e8                        ; 
                    sta M2Z_2d                      ; 
                    lda #$03                        ; 
                    sta M2Z_2e                      ; 
                    lda #$00                        ; 
                    sta M2Z_29                      ; 
                    lda #$d8                        ; 
                    sta M2Z_2a                      ; 
                    pla                             ; 
                    jsr S_890a                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8aa3              ldy #$08                        ; 
                    lda (M2Z_27),y                  ; 
                    tax                             ; 
                    dex                             ; 
                    txa                             ; 
                    sta (M2Z_27),y                  ; 
                    bne B_8b06                      ; 
                    iny                             ; 
                    lda (M2Z_27),y                  ; 
                    dey                             ; 
                    sta (M2Z_27),y                  ; 
                    ldy #$0d                        ; 
                    lda (M2Z_27),y                  ; 
                    sec                             ; 
                    adc #$00                        ; 
                    and #$01                        ; 
                    sta (M2Z_27),y                  ; 
                    ldy #$0a                        ; 
                    lda (M2Z_27),y                  ; 
                    tax                             ; 
                    clc                             ; 
                    ldy #$01                        ; 
                    adc (M2Z_27),y                  ; 
                    sta (M2Z_27),y                  ; 
                    sta M2Z_19                      ; 
                    txa                             ; 
                    bmi B_8ada                      ; 
                    ldy #$0c                        ; 
                    lda M2Z_19                      ; 
                    cmp (M2Z_27),y                  ; 
                    bcs B_8ae2                      ; 
                    bcc B_8aec                      ; 
B_8ada              ldy #$0b                        ; 
                    lda M2Z_19                      ; 
                    cmp (M2Z_27),y                  ; 
                    bcs B_8aec                      ; 
B_8ae2              txa                             ; 
                    eor #$ff                        ; 
                    sec                             ; 
                    adc #$00                        ; 
                    ldy #$0a                        ; 
                    sta (M2Z_27),y                  ; 
B_8aec              ldx #$a4                        ; 
                    lda M2Z_4d                      ; 
                    bne B_8afc                      ; 
                    ldx #$a2                        ; 
                    ldy #$0a                        ; 
                    lda (M2Z_27),y                  ; 
                    bpl B_8afc                      ; 
                    ldx #$a0                        ; 
B_8afc              txa                             ; 
                    ldy #$0d                        ; 
                    clc                             ; 
                    adc (M2Z_27),y                  ; 
                    ldy #$03                        ; 
                    sta (M2Z_27),y                  ; 
B_8b06              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8b07            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8b07              subroutine                      ; 
                    txa                             ; 
                    clc                             ; 
                    adc XT_0d01                     ; 
                    cmp #$a6                        ; 
                    bcs B_8b17                      ; 
                    cmp #$0b                        ; 
                    bcc B_8b17                      ; 
                    sta XT_0d01                     ; 
B_8b17              txa                             ; 
                    eor XT_0d0a                     ; 
                    stx XT_0d0a                     ; 
                    bpl B_8b2c                      ; 
                    lda #$02                        ; 
                    sta XT_0d08                     ; 
                    lda #$01                        ; 
                    sta XT_0d09                     ; 
                    bpl B_8b4b                      ; 
B_8b2c              lda XT_0d08                     ; 
                    clc                             ; 
                    adc XT_0d09                     ; 
                    sta XT_0d08                     ; 
                    beq B_8b3c                      ; 
                    cmp #$04                        ; 
                    bne B_8b4b                      ; 
B_8b3c              lda XT_0d09                     ; 
                    eor #$ff                        ; 
                    sec                             ; 
                    adc #$00                        ; 
                    sta XT_0d09                     ; 
                    lda #$80                        ; 
                    sta M2Z_bb                      ; 
B_8b4b              ldy #$90                        ; 
                    txa                             ; 
                    bmi B_8b52                      ; 
                    ldy #$95                        ; 
B_8b52              tya                             ; 
                    clc                             ; 
                    adc XT_0d08                     ; 
                    sta XT_0d03                     ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8b5b            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8b5b              subroutine                      ; 
                    dec XT_0d02                     ; 
                    lda XT_0d01                     ; 
                    clc                             ; 
                    adc XT_0d0c                     ; 
                    cmp #$a6                        ; 
                    bcs B_8b70                      ; 
                    cmp #$0b                        ; 
                    bcc B_8b70                      ; 
                    sta XT_0d01                     ; 
B_8b70              dec XT_0d0d                     ; 
                    lda XT_0d0d                     ; 
                    bne B_8b8a                      ; 
                    lda #$02                        ; 
                    sta XT_0d0b                     ; 
                    lda XT_0d02                     ; 
                    cmp #$19                        ; 
                    bcs B_8b89                      ; 
                    lda #$a6                        ; 
                    sta XT_0d03                     ; 
B_8b89              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8b8a              cmp #$06                        ; 
                    bcc B_8b94                      ; 
                    dec XT_0d0d                     ; 
                    dec XT_0d02                     ; 
B_8b94              ldx #$9a                        ; 
                    lda XT_0d0a                     ; 
                    bmi B_8b9d                      ; 
                    ldx #$9b                        ; 
B_8b9d              stx XT_0d03                     ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8ba1            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8ba1              subroutine                      ; 
                    inc XT_0d0d                     ; 
                    inc XT_0d02                     ; 
                    lda XT_0d01                     ; 
                    clc                             ; 
                    adc XT_0d0c                     ; 
                    cmp #$a6                        ; 
                    bcs B_8bb9                      ; 
                    cmp #$0b                        ; 
                    bcc B_8bb9                      ; 
                    sta XT_0d01                     ; 
B_8bb9              lda XT_0d01                     ; 
                    sec                             ; 
                    sbc #$09                        ; 
                    sta M2Z_43                      ; 
                    lda XT_0d02                     ; 
                    sbc #$1e                        ; 
                    bcc B_8bfa                      ; 
                    sta M2Z_44                      ; 
                    jsr S_8c44                      ; 
                    php                             ; 
                    inc M2Z_44                      ; 
                    plp                             ; 
                    beq B_8bd8                      ; 
                    jsr S_8c44                      ; 
                    beq B_8bfb                      ; 
B_8bd8              inc M2Z_43                      ; 
                    jsr S_8c44                      ; 
                    beq B_8bfb                      ; 
                    lda XT_0d0d                     ; 
                    cmp #$05                        ; 
                    bcc B_8bfa                      ; 
                    inc XT_0d02                     ; 
                    inc XT_0d0d                     ; 
                    inc M2Z_44                      ; 
                    jsr S_8c44                      ; 
                    beq B_8bfb                      ; 
                    dec M2Z_43                      ; 
                    jsr S_8c44                      ; 
                    beq B_8bfb                      ; 
B_8bfa              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8bfb              dec M2Z_44                      ; 
                    jsr S_8c44                      ; 
                    beq B_8bfa                      ; 
                    dec M2Z_44                      ; 
                    jsr S_8c44                      ; 
                    beq B_8bfa                      ; 
                    lda XT_0d0d                     ; 
                    cmp #$25                        ; 
                    bcc B_8c1e                      ; 
                    ldx #$ff                        ; 
                    stx M2Z_4e                      ; 
                    ldx #$80                        ; 
                    stx M2Z_b9                      ; 
B_8c18              ldx #$00                        ; 
                    stx XT_0d0b                     ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8c1e              lda M2Z_4e                      ; 
                    bne B_8c18                      ; 
                    jsr S_8c29                      ; 
                    jsr S_8e45                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8c29            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8c29              subroutine                      ; 
                    lda #$02                        ; 
                    sta XT_0d08                     ; 
                    lda #$00                        ; 
                    sta XT_0d0b                     ; 
                    ldx #$90                        ; 
                    lda XT_0d0a                     ; 
                    bmi B_8c3c                      ; 
                    ldx #$95                        ; 
B_8c3c              txa                             ; 
                    clc                             ; 
                    adc #$02                        ; 
                    sta XT_0d03                     ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8c44            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8c44              subroutine                      ; 
                    jsr S_8910                      ; 
                    lda M2Z_43                      ; 
                    and #$03                        ; 
                    tax                             ; 
                    ldy #$00                        ; 
                    lda (M2Z_45),y                  ; 
                    and T_8c57,x                    ; 
                    cmp T_8c57,x                    ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
T_8c57              dc.b $c0 ; 
                    dc.b $30 ; 0
                    dc.b $0c ; 
                    dc.b $03 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8c5b            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8c5b              subroutine                      ; 
                    inc XT_0d02                     ; 
                    lda XT_0d01                     ; 
                    clc                             ; 
                    adc XT_0d0c                     ; 
                    sta XT_0d01                     ; 
                    ldx XT_0d0d                     ; 
                    dex                             ; 
                    beq B_8c7e                      ; 
                    dec XT_0d0d                     ; 
                    inc XT_0d02                     ; 
                    lda XT_0d01                     ; 
                    clc                             ; 
                    adc XT_0d0c                     ; 
                    sta XT_0d01                     ; 
B_8c7e              ldx #$9a                        ; 
                    lda XT_0d0c                     ; 
                    bmi B_8c91                      ; 
                    inx                             ; 
                    lda XT_0d0c                     ; 
                    bne B_8c91                      ; 
                    lda XT_0d0a                     ; 
                    bpl B_8c91                      ; 
                    dex                             ; 
B_8c91              stx XT_0d03                     ; 
                    dec XT_0d0d                     ; 
                    bne B_8ca3                      ; 
                    jsr S_8c29                      ; 
                    lda M2Z_4e                      ; 
                    bne B_8ca3                      ; 
                    jsr S_8e45                      ; 
B_8ca3              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8ca4            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8ca4              subroutine                      ; 
                    lda M2Z_82                      ; 
                    sta M2Z_27                      ; 
                    lda M2Z_83                      ; 
                    sta M2Z_28                      ; 
B_8cac              ldy #$00                        ; 
                    lda (M2Z_27),y                  ; 
                    bne B_8cb4                      ; 
                    clc                             ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8cb4              iny                             ; 
                    lda (M2Z_27),y                  ; 
                    tax                             ; 
                    dex                             ; 
                    cpx XT_0d01                     ; 
                    beq B_8cd8                      ; 
                    inx                             ; 
                    cpx XT_0d01                     ; 
                    beq B_8cd8                      ; 
                    inx                             ; 
                    cpx XT_0d01                     ; 
                    beq B_8cd8                      ; 
B_8cca              clc                             ; 
                    lda #$04                        ; 
                    adc M2Z_27                      ; 
                    sta M2Z_27                      ; 
                    bcc B_8cac                      ; 
                    inc M2Z_28                      ; 
                    jmp B_8cac                      ; 
B_8cd8              tax                             ; 
                    iny                             ; 
                    lda (M2Z_27),y                  ; 
                    cmp XT_0d02                     ; 
                    bne B_8cca                      ; 
                    stx XT_0d01                     ; 
                    iny                             ; 
                    lda (M2Z_27),y                  ; 
                    sta XT_0d0c                     ; 
                    ldy #$00                        ; 
                    lda (M2Z_27),y                  ; 
                    sta XT_0d0d                     ; 
                    lda #$04                        ; 
                    sta XT_0d0b                     ; 
                    sec                             ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8cf8              lda CIAPRB                      ; CIA1($DC01) Data Port Register B
                    jsr S_8d13                      ; 
                    stx M2Z_4a                      ; 
                    jsr S_8d13                      ; 
                    stx M2Z_49                      ; 
                    jsr S_8d13                      ; 
                    txa                             ; 
                    and M2Z_4c                      ; 
                    sta M2Z_4b                      ; 
                    txa                             ; 
                    eor #$ff                        ; 
                    sta M2Z_4c                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8d13            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8d13              subroutine                      ; 
                    ldx #$00                        ; 
                    lsr a                           ; 
                    bcs B_8d19                      ; 
                    dex                             ; 
B_8d19              lsr a                           ; 
                    bcs B_8d1d                      ; 
                    inx                             ; 
B_8d1d              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8d1e              ldx XT_0d0b                     ; 
                    bne B_8d26                      ; 
                    jmp J_8d3f                      ; 
B_8d26              dex                             ; 
                    bne B_8d2c                      ; 
                    jmp J_8de5                      ; 
B_8d2c              dex                             ; 
                    bne B_8d32                      ; 
                    jmp J_8de9                      ; 
B_8d32              dex                             ; 
                    bne B_8d38                      ; 
                    jmp J_8d8f                      ; 
B_8d38              dex                             ; 
                    bne B_8d3e                      ; 
                    jmp J_8ded                      ; 
B_8d3e              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8d3f              lda M2Z_4b                      ; 
                    beq B_8d46                      ; 
                    jmp J_8dd6                      ; 
B_8d46              lda M2Z_4a                      ; 
                    beq B_8d60                      ; 
                    bpl B_8d53                      ; 
                    jsr S_8ed9                      ; 
                    beq B_8d60                      ; 
                    bne B_8d58                      ; 
B_8d53              jsr S_8ed0                      ; 
                    beq B_8d60                      ; 
B_8d58              lda #$03                        ; 
                    sta XT_0d0b                     ; 
                    jmp J_8d8f                      ; 
B_8d60              jsr S_8ca4                      ; 
                    bcc B_8d68                      ; 
                    jmp J_8ded                      ; 
B_8d68              ldx M2Z_49                      ; 
                    bne B_8d6d                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8d6d              jsr S_8b07                      ; 
                    jsr S_8df1                      ; 
                    lda XT_0d0b                     ; 
                    cmp #$02                        ; 
                    beq B_8d7e                      ; 
                    jsr S_8e45                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8d7e              jsr S_8c29                      ; 
                    lda #$02                        ; 
                    sta XT_0d0b                     ; 
                    lda #$00                        ; 
                    sta XT_0d0c                     ; 
                    sta XT_0d0d                     ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8d8f              lda M2Z_4a                      ; 
                    bmi B_8d96                      ; 
                    bne B_8da7                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8d96              dec XT_0d02                     ; 
                    lda M2Z_47                      ; 
                    cmp XT_0d02                     ; 
                    bcc B_8db1                      ; 
B_8da0              sta XT_0d02                     ; 
                    jsr S_8c29                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8da7              inc XT_0d02                     ; 
                    lda M2Z_48                      ; 
                    cmp XT_0d02                     ; 
                    bcc B_8da0                      ; 
B_8db1              lda XT_0d02                     ; 
                    sec                             ; 
                    sbc M2Z_47                      ; 
                    cmp #$06                        ; 
                    bcs B_8dc9                      ; 
                    lda XT_0d02                     ; 
                    lsr a                           ; 
                    lsr a                           ; 
                    ror a                           ; 
                    lda #$00                        ; 
                    adc #$9e                        ; 
                    sta XT_0d03                     ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8dc9              lda XT_0d02                     ; 
                    lsr a                           ; 
                    lsr a                           ; 
                    lda #$00                        ; 
                    adc #$9c                        ; 
                    sta XT_0d03                     ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8dd6              lda #$01                        ; 
                    sta XT_0d0b                     ; 
                    lda #$11                        ; 
                    sta XT_0d0d                     ; 
                    lda M2Z_49                      ; 
                    sta XT_0d0c                     ; 
J_8de5              jsr S_8b5b                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8de9              jsr S_8ba1                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_8ded              jsr S_8c5b                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8df1            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8df1              subroutine                      ; 
                    jsr S_8f21                      ; 
                    lda M2Z_1b                      ; 
                    sta M2Z_44                      ; 
                    dec M2Z_44                      ; 
                    lda M2Z_19                      ; 
                    sta M2Z_43                      ; 
                    jsr S_8c44                      ; 
                    bne B_8e09                      ; 
                    dec XT_0d02                     ; 
                    jmp J_8e44                      ; 
B_8e09              lda M2Z_1a                      ; 
                    sta M2Z_43                      ; 
                    jsr S_8c44                      ; 
                    bne B_8e18                      ; 
                    dec XT_0d02                     ; 
                    jmp J_8e44                      ; 
B_8e18              inc M2Z_44                      ; 
                    lda M2Z_19                      ; 
                    sta M2Z_43                      ; 
                    jsr S_8c44                      ; 
                    beq J_8e44                      ; 
                    lda M2Z_1a                      ; 
                    sta M2Z_43                      ; 
                    jsr S_8c44                      ; 
                    beq J_8e44                      ; 
                    inc XT_0d02                     ; 
                    inc M2Z_44                      ; 
                    jsr S_8c44                      ; 
                    beq J_8e44                      ; 
                    lda M2Z_19                      ; 
                    sta M2Z_43                      ; 
                    jsr S_8c44                      ; 
                    beq J_8e44                      ; 
                    lda #$02                        ; 
                    sta XT_0d0b                     ; 
J_8e44              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8e45            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8e45              subroutine                      ; 
                    jsr S_8f21                      ; 
                    lda M2Z_1b                      ; 
                    sta M2Z_44                      ; 
                    cmp #$c5                        ; 
                    bcc B_8e51                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8e51              lda M2Z_19                      ; 
                    sta M2Z_43                      ; 
                    jsr S_8c44                      ; 
                    bne B_8e71                      ; 
                    inc M2Z_44                      ; 
                    jsr S_8c44                      ; 
                    beq B_8e67                      ; 
                    jsr S_8e96                      ; 
                    jmp B_8e71                      ; 
B_8e67              inc M2Z_44                      ; 
                    jsr S_8c44                      ; 
                    beq B_8e71                      ; 
                    jsr S_8e96                      ; 
B_8e71              lda M2Z_1a                      ; 
                    sta M2Z_43                      ; 
                    lda M2Z_1b                      ; 
                    sta M2Z_44                      ; 
                    jsr S_8c44                      ; 
                    beq B_8e7f                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8e7f              inc M2Z_44                      ; 
                    jsr S_8c44                      ; 
                    beq B_8e8a                      ; 
                    jsr S_8e96                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8e8a              inc M2Z_44                      ; 
                    jsr S_8c44                      ; 
                    bne B_8e92                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8e92              jsr S_8e96                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8e96            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8e96              subroutine                      ; 
                    dec M2Z_43                      ; 
                    jsr S_8c44                      ; 
                    beq B_8ea9                      ; 
                    inc M2Z_44                      ; 
                    jsr S_8c44                      ; 
                    bne B_8ea9                      ; 
                    dec M2Z_44                      ; 
                    jmp S_8e96                      ; 
B_8ea9              inc M2Z_43                      ; 
                    lda M2Z_1b                      ; 
                    sta M2Z_44                      ; 
                    lda #$30                        ; 
                    sta M2Z_41                      ; 
                    lda #$a0                        ; 
                    sta M2Z_42                      ; 
                    jsr S_890d                      ; 
                    lda #$ff                        ; 
                    sta M2Z_37                      ; 
                    sta M2Z_40                      ; 
                    jsr S_8916                      ; 
                    dec M2Z_90                      ; 
                    jsr S_87d9                      ; 
                    lda #$05                        ; 
                    sta M2Z_5b                      ; 
                    jsr S_87dc                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8ed0            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8ed0              subroutine                      ; 
                    ldy #$ff                        ; 
                    sty M2Z_19                      ; 
                    ldy #$00                        ; 
                    jmp J_8edd                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8ed9            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8ed9              subroutine                      ; 
                    ldy #$00                        ; 
                    sty M2Z_19                      ; 
J_8edd              lda (M2Z_80),y                  ; 
                    bne B_8ee2                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_8ee2              sta M2Z_1b                      ; 
                    iny                             ; 
                    cmp XT_0d01                     ; 
                    beq B_8eff                      ; 
                    sec                             ; 
                    adc #$00                        ; 
                    cmp XT_0d01                     ; 
                    beq B_8eff                      ; 
                    clc                             ; 
                    adc #$fe                        ; 
                    cmp XT_0d01                     ; 
                    beq B_8eff                      ; 
                    iny                             ; 
                    iny                             ; 
                    jmp J_8edd                      ; 
B_8eff              lda (M2Z_80),y                  ; 
                    sta M2Z_47                      ; 
                    iny                             ; 
                    lda (M2Z_80),y                  ; 
                    sta M2Z_48                      ; 
                    iny                             ; 
                    ldx M2Z_19                      ; 
                    beq B_8f0f                      ; 
                    lda M2Z_47                      ; 
B_8f0f              sec                             ; 
                    sbc XT_0d02                     ; 
                    bpl B_8f17                      ; 
                    eor #$ff                        ; 
B_8f17              and #$fc                        ; 
                    bne J_8edd                      ; 
                    lda M2Z_1b                      ; 
                    sta XT_0d01                     ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8f21            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8f21              subroutine                      ; 
                    ldx #$0a                        ; 
                    ldy #$07                        ; 
                    lda XT_0d08                     ; 
                    cmp #$02                        ; 
                    bne B_8f2e                      ; 
                    dex                             ; 
                    iny                             ; 
B_8f2e              stx M2Z_19                      ; 
                    sty M2Z_1a                      ; 
                    sec                             ; 
                    lda XT_0d01                     ; 
                    sbc M2Z_19                      ; 
                    sta M2Z_19                      ; 
                    lda XT_0d01                     ; 
                    sbc M2Z_1a                      ; 
                    sta M2Z_1a                      ; 
                    lda XT_0d02                     ; 
                    sbc #$1d                        ; 
                    sta M2Z_1b                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8f49            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8f49              subroutine                      ; 
                    jmp J_8f5e                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8f4c            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8f4c              subroutine                      ; 
                    jmp J_905c                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8f4f            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8f4f              subroutine                      ; 
                    jmp J_907d                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8f52            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8f52              subroutine                      ; 
                    jmp J_90bc                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8f55            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8f55              subroutine                      ; 
                    jmp J_930d                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8f58            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8f58              subroutine                      ; 
                    jmp J_93e8                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_8f5b            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_8f5b              subroutine                      ; 
                    jmp J_94a0                      ; 
J_8f5e              lda #$0f                        ; 
                    sta XT_0c72                     ; 
                    sta XT_0c73                     ; 
                    lda #$00                        ; 
                    sta M2Z_a6                      ; 
                    sta M2Z_4e                      ; 
                    sta XT_0c51                     ; 
                    sta M2Z_4f                      ; 
                    sta M2Z_4d                      ; 
                    sta M2Z_a8                      ; 
                    ldx #$1b                        ; 
B_8f77              sta FRELO1,x                    ; SID($D400) Oscillator 1 Freq Ctrl (low byte)
                    sta M2Z_b8,x                    ; 
                    dex                             ; 
                    bpl B_8f77                      ; 
                    lda #$0f                        ; 
                    sta SIGVOL                      ; SID($D418) Volume/Filter Select
                    lda #$0a                        ; 
                    sta ATDCY3                      ; SID($D413) Oscillator 3 Attack/Decay
                    lda #$a0                        ; 
                    sta SUREL3                      ; SID($D414) Oscillator 3 Sustain/Release
                    lda #$8c                        ; 
                    sta M2Z_a0                      ; 
                    lda M2Z_7c                      ; 
                    sta M2Z_27                      ; 
                    lda M2Z_7d                      ; 
                    sta M2Z_28                      ; 
                    jsr S_8913                      ; 
                    ldy #$7f                        ; 
B_8f9f              lda (M2Z_7e),y                  ; 
                    sta XT_0e00,y                   ; 
                    dey                             ; 
                    bpl B_8f9f                      ; 
                    ldy #$20                        ; 
J_8fa9              lda XT_0e00,y                   ; 
                    beq B_8fb6                      ; 
                    tya                             ; 
                    clc                             ; 
                    adc #$08                        ; 
                    tay                             ; 
                    jmp J_8fa9                      ; 
B_8fb6              sta XT_0e00,y                   ; 
                    iny                             ; 
                    bpl B_8fb6                      ; 
                    lda #$00                        ; 
                    sta M2Z_23                      ; 
                    lda #$0e                        ; 
                    sta M2Z_24                      ; 
B_8fc4              ldy #$00                        ; 
                    lda (M2Z_23),y                  ; 
                    beq B_8ffb                      ; 
                    sta M2Z_43                      ; 
                    iny                             ; 
                    lda (M2Z_23),y                  ; 
                    sta M2Z_44                      ; 
                    iny                             ; 
                    lda (M2Z_23),y                  ; 
                    and #$f8                        ; 
                    ldy #$00                        ; 
                    sty M2Z_42                      ; 
                    asl a                           ; 
                    rol M2Z_42                      ; 
                    asl a                           ; 
                    rol M2Z_42                      ; 
                    adc #$80                        ; 
                    sta M2Z_41                      ; 
                    lda M2Z_42                      ; 
                    adc #$a8                        ; 
                    sta M2Z_42                      ; 
                    jsr S_87d6                      ; 
                    clc                             ; 
                    lda M2Z_23                      ; 
                    adc #$08                        ; 
                    sta M2Z_23                      ; 
                    bcc B_8fc4                      ; 
                    inc M2Z_24                      ; 
                    jmp B_8fc4                      ; 
B_8ffb              lda #$00                        ; 
                    tax                             ; 
B_8ffe              sta XT_0d00,x                   ; 
                    dex                             ; 
                    bne B_8ffe                      ; 
                    tay                             ; 
B_9005              ldx #$0e                        ; 
                    iny                             ; 
                    lda (M2Z_84),y                  ; 
                    beq B_9018                      ; 
                    dey                             ; 
B_900d              lda (M2Z_84),y                  ; 
                    sta XT_0d00,y                   ; 
                    iny                             ; 
                    dex                             ; 
                    bne B_900d                      ; 
                    beq B_9005                      ; 
B_9018              lda #$80                        ; 
                    sta M2Z_2b                      ; 
                    lda #$a0                        ; 
                    sta M2Z_2c                      ; 
                    lda #$00                        ; 
                    sta M2Z_29                      ; 
                    lda #$64                        ; 
                    sta M2Z_2a                      ; 
                    lda #$00                        ; 
                    sta M2Z_2d                      ; 
                    lda #$0c                        ; 
                    sta M2Z_2e                      ; 
                    jsr S_8907                      ; 
                    lda #$20                        ; 
                    ldx #$27                        ; 
B_9037              sta XT_6000,x                   ; 
                    dex                             ; 
                    bpl B_9037                      ; 
                    lda #$0e                        ; 
                    ldx #$27                        ; 
B_9041              sta CHR_LO,x                    ; Char ROM($d800) lower case
                    dex                             ; 
                    bpl B_9041                      ; 
                    lda M2Z_91                      ; 
                    and #$0f                        ; 
                    sta M2Z_9d                      ; 
                    lda M2Z_91                      ; 
                    lsr a                           ; 
                    lsr a                           ; 
                    lsr a                           ; 
                    lsr a                           ; 
                    and #$0f                        ; 
                    sta M2Z_9c                      ; 
                    lda #$5a                        ; 
                    sta M2Z_9e                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_905c              lda #$0e                        ; 
                    sta M2Z_27                      ; 
                    lda #$0d                        ; 
                    sta M2Z_28                      ; 
                    lda #$08                        ; 
B_9066              pha                             ; 
                    ldy #$00                        ; 
                    lda (M2Z_27),y                  ; 
                    lsr a                           ; 
                    bcc B_9071                      ; 
                    jsr S_8922                      ; 
B_9071              lda #$0e                        ; 
                    jsr S_87e5                      ; 
                    pla                             ; 
                    sec                             ; 
                    sbc #$01                        ; 
                    bne B_9066                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_907d              jsr S_914a                      ; 
                    jsr S_9475                      ; 
                    dec M2Z_9e                      ; 
                    bne B_90a1                      ; 
                    lda #$5a                        ; 
                    sta M2Z_9e                      ; 
                    lda M2Z_9d                      ; 
                    ora M2Z_9c                      ; 
                    beq B_90a1                      ; 
                    dec M2Z_9d                      ; 
                    bpl B_90a1                      ; 
                    lda #$09                        ; 
                    sta M2Z_9d                      ; 
                    dec M2Z_9c                      ; 
                    bpl B_90a1                      ; 
                    lda #$09                        ; 
                    sta M2Z_9c                      ; 
B_90a1              lda M2Z_4d                      ; 
                    beq B_90a7                      ; 
                    dec M2Z_4d                      ; 
B_90a7              lda M2Z_9c                      ; 
                    bne B_90bb                      ; 
                    lda M2Z_9d                      ; 
                    cmp #$07                        ; 
                    bcs B_90bb                      ; 
                    lda M2Z_9e                      ; 
                    and #$0f                        ; 
                    bne B_90bb                      ; 
                    lda #$80                        ; 
                    sta M2Z_bc                      ; 
B_90bb              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_90bc              lda M2Z_90                      ; 
                    beq B_90f0                      ; 
                    bit M2Z_9e                      ; 
                    bvs B_90ce                      ; 
                    lda M2Z_9d                      ; 
                    ora M2Z_9c                      ; 
                    bne B_90ce                      ; 
                    lda #$ff                        ; 
                    sta M2Z_4f                      ; 
B_90ce              lda M2Z_a6                      ; 
                    cmp #$08                        ; 
                    beq B_90ea                      ; 
                    ldx #$8c                        ; 
                    lda M2Z_4c                      ; 
                    bne B_90e0                      ; 
                    dec M2Z_a0                      ; 
                    beq B_90e4                      ; 
                    ldx M2Z_a0                      ; 
B_90e0              stx M2Z_a0                      ; 
                    clc                             ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_90e4              lda #$80                        ; 
                    sta M2Z_a0                      ; 
                    sec                             ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_90ea              lda #$00                        ; 
                    sta M2Z_a0                      ; 
                    sec                             ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_90f0              lda M2Z_9d                      ; 
                    ora M2Z_9c                      ; 
                    beq B_90e4                      ; 
                    dec M2Z_9d                      ; 
                    bpl B_9100                      ; 
                    lda #$09                        ; 
                    sta M2Z_9d                      ; 
                    dec M2Z_9c                      ; 
B_9100              jsr S_87d9                      ; 
                    lda #$01                        ; 
                    sta M2Z_59                      ; 
                    jsr S_87dc                      ; 
                    jsr S_87e2                      ; 
                    jsr S_913f                      ; 
                    ldx #$0a                        ; 
B_9112              lda T_9134,x                    ; 
                    sta FRELO3,x                    ; SID($D40E) Oscillator 3 Freq Ctrl (low byte)
                    dex                             ; 
                    bpl B_9112                      ; 
B_911b              lda M2Z_06                      ; 
                    eor #$05                        ; 
                    bne B_911b                      ; 
                    sta M2Z_06                      ; 
                    sta VCREG3                      ; SID($D412) Oscillator 3 Control
B_9126              lda M2Z_06                      ; 
                    eor #$04                        ; 
                    bne B_9126                      ; 
                    sta M2Z_06                      ; 
                    sta SIGVOL                      ; SID($D418) Volume/Filter Select
                    jmp B_90f0                      ; 
T_9134              dc.b $00 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $41 ; a
                    dc.b $0a ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0b ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_913f            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_913f              subroutine                      ; 
                    ldx #$17                        ; 
                    lda #$00                        ; 
B_9143              sta FRELO1,x                    ; SID($D400) Oscillator 1 Freq Ctrl (low byte)
                    dex                             ; 
                    bpl B_9143                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_914a            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_914a              subroutine                      ; 
                    ldx #$00                        ; 
                    jsr S_9292                      ; 
                    inx                             ; 
                    jsr S_9292                      ; 
                    beq B_9159                      ; 
                    lda #$02                        ; 
                    bne B_915b                      ; 
B_9159              lda #$08                        ; 
B_915b              sta SPMC0                       ; VIC($D025) Sprite Multicolor Register 0
                    inx                             ; 
                    jsr S_9292                      ; 
                    inx                             ; 
                    lda XT_0d0d                     ; 
                    ldy XT_0d0b                     ; 
                    dey                             ; 
                    beq B_917b                      ; 
                    dey                             ; 
                    beq B_9181                      ; 
                    dey                             ; 
                    dey                             ; 
                    beq B_91a9                      ; 
                    lda #$00                        ; 
                    sta M2Z_bb,x                    ; 
                    sta M2Z_cf,x                    ; 
                    beq B_91b9                      ; 
B_917b              eor #$ff                        ; 
                    adc #$32                        ; 
                    bne B_91b2                      ; 
B_9181              ldy #$32                        ; 
                    cmp #$06                        ; 
                    bcc B_919e                      ; 
                    sbc #$06                        ; 
                    lsr a                           ; 
                    ldy #$2c                        ; 
                    cmp #$08                        ; 
                    bcc B_919e                      ; 
                    sbc #$08                        ; 
                    lsr a                           ; 
                    ldy #$24                        ; 
                    cmp #$10                        ; 
                    bcc B_919e                      ; 
                    sbc #$10                        ; 
                    lsr a                           ; 
                    ldy #$14                        ; 
B_919e              eor #$ff                        ; 
                    sta M2Z_19                      ; 
                    tya                             ; 
                    clc                             ; 
                    adc M2Z_19                      ; 
                    jmp B_91b2                      ; 
B_91a9              lsr a                           ; 
                    adc #$14                        ; 
                    cmp #$46                        ; 
                    bcc B_91b2                      ; 
                    lda #$46                        ; 
B_91b2              tay                             ; 
                    jsr S_92a0                      ; 
                    tya                             ; 
                    sta M2Z_c5,x                    ; 
B_91b9              inx                             ; 
                    jsr S_9292                      ; 
                    beq B_91c9                      ; 
                    tya                             ; 
                    lsr a                           ; 
                    and #$07                        ; 
                    tay                             ; 
                    lda T_92db,y                    ; 
                    sta M2Z_c5,x                    ; 
B_91c9              jsr S_9262                      ; 
                    lda M2Z_4f                      ; 
                    bne B_91d4                      ; 
                    sta M2Z_b8                      ; 
                    beq B_9206                      ; 
B_91d4              lda M2Z_b8                      ; 
                    bne B_91f5                      ; 
                    dec M2Z_b8                      ; 
                    ldx #$0d                        ; 
B_91dc              lda T_92e3,x                    ; 
                    sta FRELO1,x                    ; SID($D400) Oscillator 1 Freq Ctrl (low byte)
                    dex                             ; 
                    bpl B_91dc                      ; 
                    lda #$7d                        ; 
                    sta CUTHI                       ; SID($D416) Filter Cutoff Frequency (high byte)
                    lda #$f3                        ; 
                    sta RESON                       ; SID($D417) Filter Resonance Ctrl
                    lda #$3f                        ; 
                    sta SIGVOL                      ; SID($D418) Volume/Filter Select
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_91f5              dec M2Z_b8                      ; 
                    ldx #$81                        ; 
                    stx VCREG1                      ; SID($D404) Oscillator 1 Control
                    lsr a                           ; 
                    lsr a                           ; 
                    bcc B_9202                      ; 
                    ldx #$00                        ; 
B_9202              stx VCREG2                      ; SID($D40B) Oscillator 2 Control
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9206              lda M2Z_b9                      ; 
                    beq B_923a                      ; 
                    bpl B_922b                      ; 
                    lda #$1e                        ; 
                    sta M2Z_b9                      ; 
                    ldx #$0d                        ; 
B_9212              lda T_92f1,x                    ; 
                    sta FRELO1,x                    ; SID($D400) Oscillator 1 Freq Ctrl (low byte)
                    dex                             ; 
                    bpl B_9212                      ; 
                    lda #$7d                        ; 
                    sta CUTHI                       ; SID($D416) Filter Cutoff Frequency (high byte)
                    lda #$f3                        ; 
                    sta RESON                       ; SID($D417) Filter Resonance Ctrl
                    lda #$3f                        ; 
                    sta SIGVOL                      ; SID($D418) Volume/Filter Select
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_922b              dec M2Z_b9                      ; 
                    lda M2Z_b9                      ; 
                    beq B_9233                      ; 
                    lda #$81                        ; 
B_9233              sta VCREG1                      ; SID($D404) Oscillator 1 Control
                    sta VCREG2                      ; SID($D40B) Oscillator 2 Control
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_923a              lda M2Z_ba                      ; 
                    beq B_925b                      ; 
                    ldx #$0d                        ; 
B_9240              lda T_92ff,x                    ; 
                    sta FRELO1,x                    ; SID($D400) Oscillator 1 Freq Ctrl (low byte)
                    dex                             ; 
                    bpl B_9240                      ; 
                    inx                             ; 
                    stx RESON                       ; SID($D417) Filter Resonance Ctrl
                    lda M2Z_9e                      ; 
                    ldx #$02                        ; 
                    and #$04                        ; 
                    beq B_9257                      ; 
                    ldx #$05                        ; 
B_9257              stx FREHI1                      ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_925b              sta VCREG1                      ; SID($D404) Oscillator 1 Control
                    sta VCREG2                      ; SID($D40B) Oscillator 2 Control
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9262            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9262              subroutine                      ; 
                    ldx #$01                        ; 
                    lda M2Z_bb,x                    ; 
                    bne B_9282                      ; 
                    inx                             ; 
                    lda M2Z_bb,x                    ; 
                    bne B_9282                      ; 
                    ldx #$00                        ; 
                    lda M2Z_bb,x                    ; 
                    bne B_9282                      ; 
                    ldx #$03                        ; 
                    lda M2Z_bb,x                    ; 
                    bne B_9282                      ; 
                    inx                             ; 
                    lda M2Z_bb,x                    ; 
                    bne B_9282                      ; 
                    sta VCREG3                      ; SID($D412) Oscillator 3 Control
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9282              lda M2Z_c5,x                    ; 
                    sta FREHI3                      ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                    lda M2Z_ca,x                    ; 
                    sta PWHI3                       ; SID($D411) Oscillator 3 Pulse Waveform Width (high nybble)
                    lda M2Z_cf,x                    ; 
                    sta VCREG3                      ; SID($D412) Oscillator 3 Control
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9292            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9292              subroutine                      ; 
                    lda M2Z_bb,x                    ; 
                    beq B_929f                      ; 
                    bpl B_929c                      ; 
                    jsr S_92a0                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_929c              jsr S_92b9                      ; 
B_929f              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_92a0            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_92a0              subroutine                      ; 
                    lda #$01                        ; 
                    sta M2Z_bb,x                    ; 
                    lda T_92c7,x                    ; 
                    sta M2Z_c0,x                    ; 
                    lda T_92cc,x                    ; 
                    sta M2Z_c5,x                    ; 
                    lda T_92d1,x                    ; 
                    sta M2Z_ca,x                    ; 
                    lda T_92d6,x                    ; 
                    sta M2Z_cf,x                    ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_92b9            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_92b9              subroutine                      ; 
                    lda M2Z_c0,x                    ; 
                    tay                             ; 
                    dey                             ; 
                    tya                             ; 
                    sta M2Z_c0,x                    ; 
                    bne B_92c6                      ; 
                    sta M2Z_bb,x                    ; 
                    sta M2Z_cf,x                    ; 
B_92c6              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
T_92c7              dc.b $02 ; 
                    dc.b $04 ; 
                    dc.b $07 ; 
                    dc.b $01 ; 
                    dc.b $23 ; #
T_92cc              dc.b $13 ; <HOME>
                    dc.b $19 ; 
                    dc.b $54 ; t
                    dc.b $2d ; -
A_92d0              dc.b $38 ; 8
T_92d1              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $02 ; 
T_92d6              dc.b $81 ; <ORANGE>
                    dc.b $11 ; <CRSR down>
                    dc.b $41 ; a
                    dc.b $41 ; a
                    dc.b $41 ; a
T_92db              dc.b $4f ; o
                    dc.b $64 ; D
                    dc.b $5e ; <arrow up>
                    dc.b $59 ; y
                    dc.b $70 ; P
A_92e0              dc.b $6a ; J
                    dc.b $54 ; t
                    dc.b $77 ; W
T_92e3              dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $1d ; <CRSR right>
                    dc.b $b0 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $1f ; <BLUE>
A_92f0              dc.b $f2 ; 
T_92f1              dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $5b ; [
                    dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $1c ; <RED>
                    dc.b $3b ; ;
T_92ff              dc.b $d2 ; R
A_9300              dc.b $02 ; 
                    dc.b $00 ; 
                    dc.b $04 ; 
                    dc.b $41 ; a
                    dc.b $0a ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $fa ; 
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $41 ; a
                    dc.b $0a ; 
                    dc.b $a0 ; <_ (shift)>
J_930d              lda #$00                        ; split
                    sta M2Z_27                      ; 
                    lda #$0e                        ; 
                    sta M2Z_28                      ; 
J_9315              ldy #$00                        ; 
                    lda (M2Z_27),y                  ; 
                    bne B_931c                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_931c              ldy #$03                        ; 
                    lda (M2Z_27),y                  ; 
                    beq B_933f                      ; 
                    iny                             ; 
                    lda XT_0d01                     ; 
                    cmp (M2Z_27),y                  ; 
                    bcc B_933f                      ; 
                    iny                             ; 
                    cmp (M2Z_27),y                  ; 
                    bcs B_933f                      ; 
                    iny                             ; 
                    lda XT_0d02                     ; 
                    cmp (M2Z_27),y                  ; 
                    bcc B_933f                      ; 
                    iny                             ; 
                    cmp (M2Z_27),y                  ; 
                    bcs B_933f                      ; 
                    jsr S_9347                      ; 
B_933f              lda #$08                        ; 
                    jsr S_87e5                      ; 
                    jmp J_9315                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9347            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9347              subroutine                      ; 
                    ldy #$00                        ; 
                    lda (M2Z_27),y                  ; 
                    sta M2Z_43                      ; 
                    iny                             ; 
                    lda (M2Z_27),y                  ; 
                    sta M2Z_44                      ; 
                    lda #$60                        ; 
                    sta M2Z_41                      ; 
                    lda #$ac                        ; 
                    sta M2Z_42                      ; 
                    jsr S_87d6                      ; 
                    jsr S_87d9                      ; 
                    ldy #$03                        ; 
                    lda (M2Z_27),y                  ; 
                    tax                             ; 
                    and #$0f                        ; 
                    sta M2Z_59                      ; 
                    txa                             ; 
                    lsr a                           ; 
                    lsr a                           ; 
                    lsr a                           ; 
                    lsr a                           ; 
                    and #$01                        ; 
                    sta M2Z_58                      ; 
                    jsr S_87dc                      ; 
                    ldx #$0d                        ; 
B_9377              lda T_93df,x                    ; 
                    sta XT_0c52,x                   ; 
                    dex                             ; 
                    bpl B_9377                      ; 
                    ldy #$00                        ; 
                    lda (M2Z_27),y                  ; 
                    adc #$0c                        ; 
                    sta XT_0c53                     ; 
                    iny                             ; 
                    lda (M2Z_27),y                  ; 
                    adc #$32                        ; 
                    sta XT_0c54                     ; 
                    iny                             ; 
                    iny                             ; 
                    lda (M2Z_27),y                  ; 
                    lsr a                           ; 
                    lsr a                           ; 
                    lsr a                           ; 
                    lsr a                           ; 
                    lsr a                           ; 
                    clc                             ; 
                    adc #$aa                        ; 
                    sta XT_0c55                     ; 
                    lda #$00                        ; 
                    sta (M2Z_27),y                  ; 
                    dey                             ; 
                    lda (M2Z_27),y                  ; 
                    and #$03                        ; 
                    bne B_93b9                      ; 
                    ldx #$0d                        ; 
B_93ad              lda XT_0c52,x                   ; 
                    sta XT_0d7e,x                   ; 
                    dex                             ; 
                    bpl B_93ad                      ; 
                    jmp J_93d6                      ; 
B_93b9              cmp #$01                        ; 
                    bne B_93cb                      ; 
                    ldx #$0d                        ; 
B_93bf              lda XT_0c52,x                   ; 
                    sta XT_0d8c,x                   ; 
                    dex                             ; 
                    bpl B_93bf                      ; 
                    jmp J_93d6                      ; 
B_93cb              ldx #$0d                        ; 
B_93cd              lda XT_0c52,x                   ; 
                    sta XT_0d9a,x                   ; 
                    dex                             ; 
                    bpl B_93cd                      ; 
J_93d6              lda #$b4                        ; 
                    sta M2Z_4d                      ; 
                    lda #$80                        ; 
                    sta M2Z_bd                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
T_93df              dc.b $fe ; 
A_93e0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0e ; <to lower>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $32 ; 2
J_93e8              lda M2Z_4f                      ; 
                    bne B_9427                      ; 
                    ldx M2Z_07                      ; 
                    sta M2Z_07                      ; 
                    txa                             ; 
                    and XT_0c72                     ; 
                    beq B_9409                      ; 
                    tax                             ; 
                    eor #$0f                        ; 
                    and XT_0c72                     ; 
                    sta XT_0c72                     ; 
                    lda M2Z_4d                      ; 
                    beq B_9428                      ; 
                    txa                             ; 
                    ldx #$5e                        ; 
                    jsr S_942d                      ; 
B_9409              lda M2Z_08                      ; 
                    ldx #$00                        ; 
                    stx M2Z_08                      ; 
                    and XT_0c73                     ; 
                    beq B_9427                      ; 
                    tax                             ; 
                    eor #$0f                        ; 
                    and XT_0c73                     ; 
                    sta XT_0c73                     ; 
                    lda M2Z_4d                      ; 
                    beq B_9428                      ; 
                    txa                             ; 
                    ldx #$6e                        ; 
                    jsr S_942d                      ; 
B_9427              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9428              lda #$ff                        ; 
                    sta M2Z_4f                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_942d            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_942d              subroutine                      ; 
                    sta M2Z_19                      ; 
                    stx M2Z_1a                      ; 
                    lda #$04                        ; 
                    sta M2Z_1b                      ; 
B_9435              lsr M2Z_19                      ; 
                    bcc B_946c                      ; 
                    ldx M2Z_1a                      ; 
                    lda M2Z_00,x                    ; 
                    sta M2Z_27                      ; 
                    lda M2Z_01,x                    ; 
                    sta M2Z_28                      ; 
                    ldy #$00                        ; 
                    lda (M2Z_27),y                  ; 
                    lsr a                           ; 
                    bcc B_946c                      ; 
                    asl a                           ; 
                    sta (M2Z_27),y                  ; 
                    ldy #$03                        ; 
                    lda #$a9                        ; 
                    sta (M2Z_27),y                  ; 
                    iny                             ; 
                    lda #$0e                        ; 
                    sta (M2Z_27),y                  ; 
                    ldy #$08                        ; 
                    lda #$32                        ; 
                    sta (M2Z_27),y                  ; 
                    jsr S_87d9                      ; 
                    lda #$09                        ; 
                    sta M2Z_5a                      ; 
                    jsr S_87dc                      ; 
                    lda #$80                        ; 
                    sta M2Z_b9                      ; 
B_946c              inc M2Z_1a                      ; 
                    inc M2Z_1a                      ; 
                    dec M2Z_1b                      ; 
                    bne B_9435                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9475            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9475              subroutine                      ; 
                    lda #$0e                        ; 
                    sta M2Z_27                      ; 
                    lda #$0d                        ; 
                    sta M2Z_28                      ; 
                    ldx #$0b                        ; 
B_947f              ldy #$00                        ; 
                    lda (M2Z_27),y                  ; 
                    beq B_9497                      ; 
                    lsr a                           ; 
                    bcs B_9497                      ; 
                    ldy #$08                        ; 
                    lda (M2Z_27),y                  ; 
                    adc #$ff                        ; 
                    sta (M2Z_27),y                  ; 
                    bne B_9497                      ; 
                    ldy #$00                        ; 
                    tya                             ; 
                    sta (M2Z_27),y                  ; 
B_9497              lda #$0e                        ; 
                    jsr S_87e5                      ; 
                    dex                             ; 
                    bne B_947f                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_94a0              jsr S_8925                      ; 
                    lda M2Z_4f                      ; 
                    beq B_94d4                      ; 
                    sta M2Z_4e                      ; 
                    lda #$04                        ; 
                    sta XT_0d04                     ; 
                    lda #$02                        ; 
                    sta SPMC0                       ; VIC($D025) Sprite Multicolor Register 0
                    lda XT_0d06                     ; 
                    eor #$ff                        ; 
                    sta XT_0d06                     ; 
                    lda XT_0d0b                     ; 
                    cmp #$03                        ; 
                    bne B_94d4                      ; 
                    lda #$02                        ; 
                    sta XT_0d0b                     ; 
                    sta XT_0d08                     ; 
                    lda #$00                        ; 
                    sta XT_0d0c                     ; 
                    lda #$9a                        ; 
                    sta XT_0d03                     ; 
B_94d4              lda M2Z_4e                      ; 
                    beq B_94e0                      ; 
                    lda #$00                        ; 
                    sta M2Z_49                      ; 
                    sta M2Z_4a                      ; 
                    sta M2Z_4b                      ; 
B_94e0              lda M2Z_8a                      ; 
                    beq B_94e7                      ; 
                    jsr S_9556                      ; 
B_94e7              lda M2Z_a6                      ; 
                    bne B_951c                      ; 
                    lda M2Z_4e                      ; 
                    beq B_94ff                      ; 
                    lda XT_0d0b                     ; 
                    beq B_9507                      ; 
                    cmp #$05                        ; 
                    bne B_94ff                      ; 
                    lda XT_0d02                     ; 
                    cmp #$ca                        ; 
                    beq B_9507                      ; 
B_94ff              lda M2Z_a8                      ; 
                    bne B_9506                      ; 
                    jsr S_8928                      ; 
B_9506              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9507              lda XT_0d03                     ; 
                    ldx #$00                        ; 
                    stx M2Z_a4                      ; 
                    lsr a                           ; 
                    ror M2Z_a4                      ; 
                    lsr a                           ; 
                    ror M2Z_a4                      ; 
                    ora #$40                        ; 
                    sta M2Z_a5                      ; 
                    lda #$3e                        ; 
                    sta M2Z_a6                      ; 
B_951c              inc XT_0d02                     ; 
                    inc XT_0c51                     ; 
                    ldx #$00                        ; 
                    ldy M2Z_a6                      ; 
                    dey                             ; 
                    lda (M2Z_a4),y                  ; 
                    sta M2Z_19                      ; 
                    txa                             ; 
                    sta (M2Z_a4),y                  ; 
                    sta XT_6fc0,y                   ; 
                    dey                             ; 
                    lda (M2Z_a4),y                  ; 
                    sta M2Z_1a                      ; 
                    txa                             ; 
                    sta (M2Z_a4),y                  ; 
                    sta XT_6fc0,y                   ; 
                    dey                             ; 
                    sty M2Z_a6                      ; 
                    dey                             ; 
                    lda (M2Z_a4),y                  ; 
                    ora M2Z_19                      ; 
                    sta (M2Z_a4),y                  ; 
                    dey                             ; 
                    lda (M2Z_a4),y                  ; 
                    ora M2Z_1a                      ; 
                    sta (M2Z_a4),y                  ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_954e              dc.b $ff ; 
                    dc.b $ff ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9550            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9550              subroutine                      ; 
                    jmp J_9565                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9553            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9553              subroutine                      ; 
                    jmp J_9601                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9556            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9556              subroutine                      ; 
                    jmp J_9650                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9559            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9559              subroutine                      ; 
                    jmp J_97c0                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_955c            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_955c              subroutine                      ; 
                    jmp J_98c3                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_955f            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_955f              subroutine                      ; 
                    jmp J_95c1                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9562            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9562              subroutine                      ; 
                    jmp J_98f6                      ; 
J_9565              lda M2Z_8b                      ; 
                    sta M2Z_43                      ; 
                    lda #$1b                        ; 
                    sta M2Z_44                      ; 
                    lda #$40                        ; 
                    sta M2Z_41                      ; 
                    lda #$75                        ; 
                    sta M2Z_42                      ; 
                    jsr S_95bd                      ; 
                    lda M2Z_8b                      ; 
                    sta M2Z_43                      ; 
                    lda #$49                        ; 
                    sta M2Z_44                      ; 
                    lda #$30                        ; 
                    sta M2Z_41                      ; 
                    lda #$75                        ; 
                    sta M2Z_42                      ; 
                    jsr S_95bd                      ; 
                    lda M2Z_8b                      ; 
                    sta M2Z_43                      ; 
                    lda #$77                        ; 
                    sta M2Z_44                      ; 
                    lda #$20                        ; 
                    sta M2Z_41                      ; 
                    lda #$75                        ; 
                    sta M2Z_42                      ; 
                    jsr S_95bd                      ; 
                    lda M2Z_8b                      ; 
                    sta M2Z_43                      ; 
                    lda #$a5                        ; 
                    sta M2Z_44                      ; 
                    lda #$10                        ; 
                    sta M2Z_41                      ; 
                    lda #$75                        ; 
                    sta M2Z_42                      ; 
                    jsr S_95bd                      ; 
                    lda #$00                        ; 
                    sta M2Z_ae                      ; 
                    sta M2Z_a7                      ; 
                    lda #$5a                        ; 
                    jsr S_9789                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_95bd            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_95bd              subroutine                      ; 
                    ldx #$00                        ; 
                    ldy #$aa                        ; 
J_95c1              stx M2Z_19                      ; 
                    sty M2Z_1a                      ; 
                    lda M2Z_44                      ; 
                    pha                             ; 
                    jsr S_890d                      ; 
                    jsr S_95eb                      ; 
                    jsr S_8916                      ; 
                    pla                             ; 
                    sta M2Z_44                      ; 
                    lda M2Z_43                      ; 
                    clc                             ; 
                    adc #$04                        ; 
                    sta M2Z_43                      ; 
                    lda M2Z_41                      ; 
                    adc #$08                        ; 
                    sta M2Z_41                      ; 
                    jsr S_890d                      ; 
                    jsr S_95eb                      ; 
                    jsr S_8916                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_95eb            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_95eb              subroutine                      ; 
                    ldx #$07                        ; 
B_95ed              lda M2Z_2f,x                    ; 
                    eor M2Z_19                      ; 
                    and M2Z_1a                      ; 
                    sta M2Z_2f,x                    ; 
                    lda M2Z_38,x                    ; 
                    eor M2Z_19                      ; 
                    and M2Z_1a                      ; 
                    sta M2Z_38,x                    ; 
                    dex                             ; 
                    bpl B_95ed                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_9601              and #$0f                        ; 
                    sta M2Z_19                      ; 
                    dex                             ; 
                    bne B_960f                      ; 
                    ldx #$20                        ; 
                    ldy #$63                        ; 
                    jmp J_9627                      ; 
B_960f              dex                             ; 
                    bne B_9619                      ; 
                    ldx #$30                        ; 
                    ldy #$62                        ; 
                    jmp J_9627                      ; 
B_9619              dex                             ; 
                    bne B_9623                      ; 
                    ldx #$68                        ; 
                    ldy #$61                        ; 
                    jmp J_9627                      ; 
B_9623              ldx #$78                        ; 
                    ldy #$60                        ; 
J_9627              sty M2Z_1b                      ; 
                    clc                             ; 
                    txa                             ; 
                    adc M2Z_8a                      ; 
                    sta M2Z_1a                      ; 
                    bcc B_9633                      ; 
                    inc M2Z_1b                      ; 
B_9633              lda M2Z_1a                      ; 
                    clc                             ; 
                    adc #$28                        ; 
                    sta M2Z_1c                      ; 
                    lda M2Z_1b                      ; 
                    adc #$00                        ; 
                    sta M2Z_1d                      ; 
                    ldy #$02                        ; 
B_9642              lda (M2Z_1a),y                  ; 
                    and #$f0                        ; 
                    ora M2Z_19                      ; 
                    sta (M2Z_1a),y                  ; 
                    sta (M2Z_1c),y                  ; 
                    dey                             ; 
                    bpl B_9642                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_9650              lda M2Z_ae                      ; 
                    beq B_965e                      ; 
                    dec M2Z_ae                      ; 
                    beq B_9659                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9659              lda #$5a                        ; 
                    jsr S_9789                      ; 
B_965e              lda XT_0d0b                     ; 
                    beq B_9664                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9664              lda XT_0d01                     ; 
                    cmp M2Z_8c                      ; 
                    bcc B_966f                      ; 
                    cmp M2Z_8d                      ; 
                    bcc B_9679                      ; 
B_966f              lda #$00                        ; 
                    sta M2Z_a8                      ; 
                    sta M2Z_a7                      ; 
                    jsr S_96d3                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9679              lda M2Z_a8                      ; 
                    bne B_9698                      ; 
                    lda M2Z_a7                      ; 
                    bne B_9684                      ; 
                    jsr S_9708                      ; 
B_9684              lda M2Z_4b                      ; 
                    beq B_9690                      ; 
                    lda M2Z_49                      ; 
                    bne B_9690                      ; 
                    jsr S_9734                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9690              dec M2Z_a9                      ; 
                    bne B_9697                      ; 
                    jsr S_9708                      ; 
B_9697              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9698              lda #$00                        ; 
                    sta M2Z_49                      ; 
                    sta M2Z_4a                      ; 
                    sta M2Z_4b                      ; 
                    ldy #$3f                        ; 
B_96a2              lda XT_6fc0,y                   ; 
                    sta (M2Z_aa),y                  ; 
                    dey                             ; 
                    bpl B_96a2                      ; 
                    dec M2Z_a9                      ; 
                    bne B_96c1                      ; 
                    lda #$00                        ; 
                    sta XT_0d7e                     ; 
                    sta M2Z_a8                      ; 
                    sta M2Z_a7                      ; 
                    lda #$3c                        ; 
                    sta M2Z_ae                      ; 
                    lda #$aa                        ; 
                    jsr S_9789                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_96c1              lda #$80                        ; 
                    sta M2Z_ad                      ; 
                    inc M2Z_ac                      ; 
                    ldy #$3f                        ; 
B_96c9              lda (M2Z_aa),y                  ; 
                    and (M2Z_ac),y                  ; 
                    sta (M2Z_aa),y                  ; 
                    dey                             ; 
                    bpl B_96c9                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_96d3            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_96d3              subroutine                      ; 
                    ldx #$01                        ; 
                    lda #$0a                        ; 
                    cpx M2Z_a7                      ; 
                    bne B_96dd                      ; 
                    lda #$01                        ; 
B_96dd              jsr S_9553                      ; 
                    ldx #$02                        ; 
                    lda #$0a                        ; 
                    cpx M2Z_a7                      ; 
                    bne B_96ea                      ; 
                    lda #$01                        ; 
B_96ea              jsr S_9553                      ; 
                    ldx #$03                        ; 
                    lda #$0a                        ; 
                    cpx M2Z_a7                      ; 
                    bne B_96f7                      ; 
                    lda #$01                        ; 
B_96f7              jsr S_9553                      ; 
                    ldx #$04                        ; 
                    lda #$0a                        ; 
                    cpx M2Z_a7                      ; 
                    bne B_9704                      ; 
                    lda #$01                        ; 
B_9704              jsr S_9553                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9708            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9708              subroutine                      ; 
                    ldx #$01                        ; 
                    lda XT_0d02                     ; 
                    cmp #$e4                        ; 
                    beq B_971c                      ; 
                    inx                             ; 
                    cmp #$b6                        ; 
                    beq B_971c                      ; 
                    inx                             ; 
                    cmp #$88                        ; 
                    beq B_971c                      ; 
                    inx                             ; 
B_971c              inc M2Z_a7                      ; 
                    lda M2Z_a7                      ; 
                    cmp #$05                        ; 
                    bcc B_9728                      ; 
                    lda #$01                        ; 
                    sta M2Z_a7                      ; 
B_9728              cpx M2Z_a7                      ; 
                    beq B_971c                      ; 
                    jsr S_96d3                      ; 
                    lda #$30                        ; 
                    sta M2Z_a9                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9734            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9734              subroutine                      ; 
                    lda #$80                        ; 
                    sta M2Z_bf                      ; 
                    lda #$23                        ; 
                    sta M2Z_a9                      ; 
                    lda #$ff                        ; 
                    sta M2Z_a8                      ; 
                    ldx #$0d                        ; 
B_9742              lda XT_0d00,x                   ; 
                    sta XT_0d7e,x                   ; 
                    dex                             ; 
                    bpl B_9742                      ; 
                    ldx M2Z_a7                      ; 
                    lda #$e4                        ; 
                    dex                             ; 
                    beq B_975e                      ; 
                    lda #$b6                        ; 
                    dex                             ; 
                    beq B_975e                      ; 
                    lda #$88                        ; 
                    dex                             ; 
                    beq B_975e                      ; 
                    lda #$5a                        ; 
B_975e              sta XT_0d02                     ; 
                    lda XT_0d03                     ; 
                    sta M2Z_ab                      ; 
                    lda #$00                        ; 
                    sta M2Z_49                      ; 
                    sta M2Z_4a                      ; 
                    sta M2Z_4b                      ; 
                    lsr M2Z_ab                      ; 
                    ror a                           ; 
                    lsr M2Z_ab                      ; 
                    ror a                           ; 
                    adc #$00                        ; 
                    sta M2Z_aa                      ; 
                    lda M2Z_ab                      ; 
                    adc #$40                        ; 
                    sta M2Z_ab                      ; 
                    ldy #$3f                        ; 
B_9780              lda (M2Z_aa),y                  ; 
                    sta XT_6fc0,y                   ; 
                    dey                             ; 
                    bpl B_9780                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9789            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9789              subroutine                      ; 
                    and #$f0                        ; 
                    sta M2Z_1a                      ; 
                    ldx #$18                        ; 
                    stx M2Z_19                      ; 
                    lda #$28                        ; 
                    sta M2Z_27                      ; 
                    lda #$60                        ; 
                    sta M2Z_28                      ; 
B_9799              ldx #$05                        ; 
                    ldy M2Z_8a                      ; 
                    dey                             ; 
B_979e              lda (M2Z_27),y                  ; 
                    and #$0f                        ; 
                    ora M2Z_1a                      ; 
                    sta (M2Z_27),y                  ; 
                    iny                             ; 
                    dex                             ; 
                    bne B_979e                      ; 
                    dec M2Z_19                      ; 
                    beq B_97bc                      ; 
                    lda M2Z_27                      ; 
                    clc                             ; 
                    adc #$28                        ; 
                    sta M2Z_27                      ; 
                    bcc B_9799                      ; 
                    inc M2Z_28                      ; 
                    jmp B_9799                      ; 
B_97bc              jsr S_96d3                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_97c0              lda #$00                        ; 
                    sta M2Z_27                      ; 
                    lda #$0c                        ; 
                    sta M2Z_28                      ; 
B_97c8              ldy #$00                        ; 
                    lda (M2Z_27),y                  ; 
                    bne B_97cf                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_97cf              iny                             ; 
                    lda (M2Z_27),y                  ; 
                    beq B_97dc                      ; 
                    sec                             ; 
                    sbc #$01                        ; 
                    sta (M2Z_27),y                  ; 
                    jmp J_9808                      ; 
B_97dc              ldy #$08                        ; 
B_97de              lda (M2Z_27),y                  ; 
                    sta M2Z_001b,y                  ; 
                    dey                             ; 
                    bpl B_97de                      ; 
                    lda M2Z_1d                      ; 
                    sta M2Z_1c                      ; 
                    jsr S_9816                      ; 
                    jsr S_98a6                      ; 
                    jsr S_98b5                      ; 
                    bcc B_97fe                      ; 
                    lda M2Z_1f                      ; 
                    eor #$ff                        ; 
                    sec                             ; 
                    adc #$00                        ; 
                    sta M2Z_1f                      ; 
B_97fe              ldy #$08                        ; 
B_9800              lda M2Z_001b,y                  ; 
                    sta (M2Z_27),y                  ; 
                    dey                             ; 
                    bpl B_9800                      ; 
J_9808              clc                             ; 
                    lda #$09                        ; 
                    adc M2Z_27                      ; 
                    sta M2Z_27                      ; 
                    bcc B_97c8                      ; 
                    inc M2Z_28                      ; 
                    jmp B_97c8                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9816            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9816              subroutine                      ; 
                    lda #$03                        ; 
                    sta M2Z_19                      ; 
                    lda M2Z_22                      ; 
                    clc                             ; 
                    adc M2Z_1f                      ; 
                    sta M2Z_22                      ; 
                    lda M2Z_1b                      ; 
                    sta M2Z_44                      ; 
                    lda M2Z_1f                      ; 
                    bne B_982a                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_982a              bmi B_985e                      ; 
                    ldx M2Z_22                      ; 
                    dex                             ; 
                    stx M2Z_43                      ; 
B_9831              jsr S_8910                      ; 
                    ldx M2Z_23                      ; 
                    inx                             ; 
                    ldy #$00                        ; 
                    sty M2Z_1a                      ; 
B_983b              lda (M2Z_45),y                  ; 
                    ror M2Z_1a                      ; 
                    ror a                           ; 
                    ror M2Z_1a                      ; 
                    ror a                           ; 
                    sta (M2Z_45),y                  ; 
                    rol M2Z_1a                      ; 
                    lda #$00                        ; 
                    bcc B_984d                      ; 
                    lda #$03                        ; 
B_984d              sta M2Z_1a                      ; 
                    clc                             ; 
                    tya                             ; 
                    adc #$08                        ; 
                    tay                             ; 
                    dex                             ; 
                    bne B_983b                      ; 
                    inc M2Z_44                      ; 
                    dec M2Z_19                      ; 
                    bne B_9831                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_985e              lda M2Z_22                      ; 
                    sta M2Z_43                      ; 
B_9862              jsr S_8910                      ; 
                    lda M2Z_23                      ; 
                    asl a                           ; 
                    asl a                           ; 
                    asl a                           ; 
                    tay                             ; 
                    lda #$00                        ; 
                    sta M2Z_1a                      ; 
B_986f              lda (M2Z_45),y                  ; 
                    rol M2Z_1a                      ; 
                    rol a                           ; 
                    rol M2Z_1a                      ; 
                    rol a                           ; 
                    sta (M2Z_45),y                  ; 
                    lda #$00                        ; 
                    bcc B_987f                      ; 
                    lda #$c0                        ; 
B_987f              sta M2Z_1a                      ; 
                    tya                             ; 
                    sec                             ; 
                    sbc #$08                        ; 
                    tay                             ; 
                    bpl B_986f                      ; 
                    inc M2Z_44                      ; 
                    dec M2Z_19                      ; 
                    bne B_9862                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_988f            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_988f              subroutine                      ; 
                    clc                             ; 
                    lda XT_0d0b                     ; 
                    bne B_98a5                      ; 
                    lda XT_0d02                     ; 
                    sec                             ; 
                    sbc XT_0c51                     ; 
                    sec                             ; 
                    sbc #$1d                        ; 
                    cmp M2Z_1b                      ; 
                    clc                             ; 
                    bne B_98a5                      ; 
                    sec                             ; 
B_98a5              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_98a6            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_98a6              subroutine                      ; 
                    jsr S_988f                      ; 
                    bcc B_98b4                      ; 
                    lda XT_0d01                     ; 
                    clc                             ; 
                    adc M2Z_1f                      ; 
                    sta XT_0d01                     ; 
B_98b4              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_98b5            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_98b5              subroutine                      ; 
                    lda M2Z_22                      ; 
                    ldx M2Z_1f                      ; 
                    bmi B_98be                      ; 
                    cmp M2Z_21                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_98be              lda M2Z_20                      ; 
                    cmp M2Z_22                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_98c3              stx M2Z_27                      ; 
                    sty M2Z_28                      ; 
B_98c7              ldy #$00                        ; 
                    lda (M2Z_88),y                  ; 
                    bne B_98ce                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_98ce              sta M2Z_43                      ; 
                    iny                             ; 
                    lda (M2Z_88),y                  ; 
                    sta M2Z_44                      ; 
                    iny                             ; 
                    lda (M2Z_88),y                  ; 
                    asl a                           ; 
                    sta M2Z_41                      ; 
                    lda #$00                        ; 
                    adc #$72                        ; 
                    sta M2Z_42                      ; 
                    ldx M2Z_27                      ; 
                    ldy M2Z_28                      ; 
                    jsr S_955f                      ; 
                    clc                             ; 
                    lda M2Z_88                      ; 
                    adc #$03                        ; 
                    sta M2Z_88                      ; 
                    bcc B_98c7                      ; 
                    inc M2Z_89                      ; 
                    jmp B_98c7                      ; 
J_98f6              lda #$00                        ; 
                    sta M2Z_27                      ; 
                    lda #$0c                        ; 
                    sta M2Z_28                      ; 
B_98fe              ldy #$00                        ; 
                    lda (M2Z_27),y                  ; 
                    beq B_9952                      ; 
                    sta M2Z_1b                      ; 
                    ldy #$04                        ; 
                    lda (M2Z_27),y                  ; 
                    bne B_9921                      ; 
                    jsr S_988f                      ; 
                    bcc B_9944                      ; 
                    ldx XT_0d01                     ; 
                    lda #$ff                        ; 
                    cpx #$64                        ; 
                    bcs B_991c                      ; 
                    lda #$01                        ; 
B_991c              sta (M2Z_27),y                  ; 
                    jmp B_9944                      ; 
B_9921              ldy #$08                        ; 
B_9923              lda (M2Z_27),y                  ; 
                    sta M2Z_001b,y                  ; 
                    dey                             ; 
                    bne B_9923                      ; 
                    jsr S_9816                      ; 
                    jsr S_98a6                      ; 
                    jsr S_98b5                      ; 
                    bcc B_993a                      ; 
                    lda #$00                        ; 
                    sta M2Z_1f                      ; 
B_993a              ldy #$08                        ; 
B_993c              lda M2Z_001b,y                  ; 
                    sta (M2Z_27),y                  ; 
                    dey                             ; 
                    bpl B_993c                      ; 
B_9944              clc                             ; 
                    lda M2Z_27                      ; 
                    adc #$09                        ; 
                    sta M2Z_27                      ; 
                    bcc B_98fe                      ; 
                    inc M2Z_28                      ; 
                    jmp B_98fe                      ; 
B_9952              lda #$80                        ; 
                    sta M2Z_27                      ; 
                    lda #$46                        ; 
                    sta M2Z_28                      ; 
                    lda #$10                        ; 
                    sta M2Z_19                      ; 
J_995e              ldy #$0f                        ; 
B_9960              lda (M2Z_27),y                  ; 
                    ora #$aa                        ; 
                    sta (M2Z_27),y                  ; 
                    dey                             ; 
                    bpl B_9960                      ; 
                    dec M2Z_19                      ; 
                    bne B_996e                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_996e              clc                             ; 
                    lda M2Z_27                      ; 
                    adc #$40                        ; 
                    sta M2Z_27                      ; 
                    lda M2Z_28                      ; 
                    adc #$01                        ; 
                    sta M2Z_28                      ; 
                    jmp J_995e                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_997e            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_997e              subroutine                      ; 
                    jmp J_9990                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9981            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9981              subroutine                      ; 
                    jmp J_99e8                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9984            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9984              subroutine                      ; 
                    jmp J_9af7                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9987            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9987              subroutine                      ; 
                    jmp J_9aa7                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_998a            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_998a              subroutine                      ; 
                    jmp J_9acf                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_998d            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_998d              subroutine                      ; 
                    jmp J_9b4d                      ; 
J_9990              lda XT_0d0b                     ; 
                    bne B_99e3                      ; 
                    lda M2Z_b0                      ; 
                    clc                             ; 
                    adc #$1d                        ; 
                    cmp XT_0d02                     ; 
                    bne B_99e3                      ; 
                    lda XT_0d01                     ; 
                    cmp #$44                        ; 
                    bcc B_99e3                      ; 
                    cmp #$80                        ; 
                    bcs B_99e3                      ; 
                    lda M2Z_4f                      ; 
                    ora M2Z_4e                      ; 
                    bne B_99e3                      ; 
                    lda CIAPRB                      ; CIA1($DC01) Data Port Register B
                    eor #$ff                        ; 
                    and #$10                        ; 
                    and M2Z_4c                      ; 
                    bne B_99bc                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_99bc              inc M2Z_b1                      ; 
                    lda M2Z_b1                      ; 
                    bne B_99cb                      ; 
                    sta M2Z_4c                      ; 
                    sta M2Z_ba                      ; 
                    lda #$01                        ; 
                    jmp J_99da                      ; 
B_99cb              cmp #$02                        ; 
                    beq B_99d0                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_99d0              lda #$80                        ; 
                    sta M2Z_ba                      ; 
                    lda #$ff                        ; 
                    sta M2Z_b1                      ; 
                    lda #$0a                        ; 
J_99da              ldx #$10                        ; 
B_99dc              sta XT_dba6,x                   ; 
                    dex                             ; 
                    bpl B_99dc                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_99e3              lda #$01                        ; 
                    sta M2Z_b1                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_99e8              jsr S_8925                      ; 
                    lda M2Z_49                      ; 
                    beq B_9a1d                      ; 
                    bmi B_9a08                      ; 
                    lda M2Z_af                      ; 
                    cmp #$68                        ; 
                    bcs B_9a1d                      ; 
                    sta M2Z_43                      ; 
                    lda M2Z_b0                      ; 
                    sta M2Z_44                      ; 
                    inc M2Z_af                      ; 
                    inc XT_0d01                     ; 
                    jsr S_9987                      ; 
                    jmp B_9a1d                      ; 
B_9a08              ldx M2Z_af                      ; 
                    cpx #$3f                        ; 
                    bcc B_9a1d                      ; 
                    dex                             ; 
                    stx M2Z_af                      ; 
                    stx M2Z_43                      ; 
                    lda M2Z_b0                      ; 
                    sta M2Z_44                      ; 
                    dec XT_0d01                     ; 
                    jsr S_998a                      ; 
B_9a1d              lda M2Z_4a                      ; 
                    bne B_9a22                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9a22              bpl B_9a6f                      ; 
                    ldx M2Z_b0                      ; 
                    cpx #$69                        ; 
                    bcs B_9a2b                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9a2b              dec XT_0d02                     ; 
                    dex                             ; 
                    stx M2Z_b0                      ; 
                    stx M2Z_44                      ; 
                    lda M2Z_af                      ; 
                    sta M2Z_43                      ; 
                    jsr S_8910                      ; 
                    lda M2Z_45                      ; 
                    sta M2Z_27                      ; 
                    lda M2Z_46                      ; 
                    sta M2Z_28                      ; 
                    inc M2Z_44                      ; 
                    inc M2Z_44                      ; 
                    inc M2Z_44                      ; 
                    jsr S_8910                      ; 
                    lda M2Z_45                      ; 
                    sta M2Z_25                      ; 
                    lda M2Z_46                      ; 
                    sta M2Z_26                      ; 
                    lda M2Z_44                      ; 
                    clc                             ; 
                    adc #$07                        ; 
                    sta M2Z_44                      ; 
                    jsr S_8910                      ; 
                    ldy #$20                        ; 
B_9a5f              lda (M2Z_25),y                  ; 
                    sta (M2Z_27),y                  ; 
                    lda (M2Z_45),y                  ; 
                    sta (M2Z_25),y                  ; 
                    tya                             ; 
                    sec                             ; 
                    sbc #$08                        ; 
                    tay                             ; 
                    bpl B_9a5f                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9a6f              ldx M2Z_b0                      ; 
                    cpx #$ad                        ; 
                    bcc B_9a76                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9a76              inc XT_0d02                     ; 
                    inc M2Z_b0                      ; 
                    stx M2Z_44                      ; 
                    lda M2Z_af                      ; 
                    sta M2Z_43                      ; 
                    jsr S_8910                      ; 
                    lda M2Z_45                      ; 
                    sta M2Z_27                      ; 
                    lda M2Z_46                      ; 
                    sta M2Z_28                      ; 
                    inc M2Z_44                      ; 
                    inc M2Z_44                      ; 
                    inc M2Z_44                      ; 
                    jsr S_8910                      ; 
                    ldy #$20                        ; 
B_9a97              lda (M2Z_27),y                  ; 
                    sta (M2Z_45),y                  ; 
                    lda #$00                        ; 
                    sta (M2Z_27),y                  ; 
                    tya                             ; 
                    sec                             ; 
                    sbc #$08                        ; 
                    tay                             ; 
                    bpl B_9a97                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_9aa7              jsr S_8910                      ; 
                    ldy #$00                        ; 
                    sty M2Z_19                      ; 
B_9aae              lda (M2Z_45),y                  ; 
                    ror M2Z_19                      ; 
                    ror a                           ; 
                    ror M2Z_19                      ; 
                    ror a                           ; 
                    rol M2Z_19                      ; 
                    rol M2Z_19                      ; 
                    sta (M2Z_45),y                  ; 
                    tya                             ; 
                    clc                             ; 
                    adc #$08                        ; 
                    tay                             ; 
                    cpy #$21                        ; 
                    bcc B_9aae                      ; 
                    ldx M2Z_44                      ; 
                    inx                             ; 
                    stx M2Z_44                      ; 
                    cpx #$c3                        ; 
                    bcc J_9aa7                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_9acf              jsr S_8910                      ; 
                    lda #$00                        ; 
                    sta M2Z_19                      ; 
                    ldy #$20                        ; 
B_9ad8              lda (M2Z_45),y                  ; 
                    rol M2Z_19                      ; 
                    rol a                           ; 
                    rol M2Z_19                      ; 
                    rol a                           ; 
                    ror M2Z_19                      ; 
                    ror M2Z_19                      ; 
                    sta (M2Z_45),y                  ; 
                    tya                             ; 
                    sec                             ; 
                    sbc #$08                        ; 
                    tay                             ; 
                    bpl B_9ad8                      ; 
                    ldx M2Z_44                      ; 
                    inx                             ; 
                    stx M2Z_44                      ; 
                    cpx #$c3                        ; 
                    bcc J_9acf                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_9af7              lda XT_0d90                     ; 
                    and #$07                        ; 
                    tax                             ; 
                    inx                             ; 
                    stx XT_0d90                     ; 
                    stx XT_0d9e                     ; 
                    lda XT_0d94                     ; 
                    bmi B_9b18                      ; 
                    inc XT_0d8d                     ; 
                    inc XT_0d9b                     ; 
                    lda XT_0d8d                     ; 
                    cmp #$6c                        ; 
                    bcc B_9b2d                      ; 
                    bcs B_9b25                      ; 
B_9b18              dec XT_0d8d                     ; 
                    dec XT_0d9b                     ; 
                    lda XT_0d8d                     ; 
                    cmp #$2c                        ; 
                    bcs B_9b2d                      ; 
B_9b25              lda XT_0d94                     ; 
                    eor #$ff                        ; 
                    sta XT_0d94                     ; 
B_9b2d              lda XT_0d02                     ; 
                    cmp #$d7                        ; 
                    bcs B_9b35                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9b35              lda XT_0d01                     ; 
                    sec                             ; 
                    sbc XT_0d8d                     ; 
                    bmi B_9b43                      ; 
                    cmp #$1e                        ; 
                    bcc B_9b48                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9b43              adc M2Z_06                      ; 
                    bpl B_9b48                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9b48              lda #$ff                        ; 
                    sta M2Z_4f                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_9b4d              lda #$74                        ; 
                    sta M2Z_27                      ; 
                    lda #$0c                        ; 
                    sta M2Z_28                      ; 
B_9b55              ldy #$02                        ; 
B_9b57              lda (M2Z_27),y                  ; 
                    sta M2Z_001b,y                  ; 
                    dey                             ; 
                    bpl B_9b57                      ; 
                    tax                             ; 
                    beq B_9bcc                      ; 
                    lda M2Z_1d                      ; 
                    bmi B_9b70                      ; 
                    dec M2Z_1d                      ; 
                    bne B_9b8f                      ; 
                    lda #$c0                        ; 
                    sta M2Z_1d                      ; 
                    bne B_9b8f                      ; 
B_9b70              asl a                           ; 
                    bpl B_9b82                      ; 
                    jsr S_9bee                      ; 
                    lda M2Z_1c                      ; 
                    cmp #$c0                        ; 
                    bne B_9b8f                      ; 
                    lda #$80                        ; 
                    sta M2Z_1d                      ; 
                    bne B_9b8f                      ; 
B_9b82              jsr S_9c18                      ; 
                    lda M2Z_1c                      ; 
                    cmp #$ac                        ; 
                    bne B_9b8f                      ; 
                    lda #$55                        ; 
                    sta M2Z_1d                      ; 
B_9b8f              lda M2Z_1b                      ; 
                    clc                             ; 
                    adc #$05                        ; 
                    cmp XT_0d01                     ; 
                    bcs B_9bb4                      ; 
                    adc #$13                        ; 
                    cmp XT_0d01                     ; 
                    bcc B_9bb4                      ; 
                    lda M2Z_1c                      ; 
                    adc #$2c                        ; 
                    cmp XT_0d02                     ; 
                    bcs B_9bb4                      ; 
                    adc #$04                        ; 
                    cmp XT_0d02                     ; 
                    bcc B_9bb4                      ; 
                    lda #$ff                        ; 
                    sta M2Z_4f                      ; 
B_9bb4              ldy #$02                        ; 
B_9bb6              lda M2Z_001b,y                  ; 
                    sta (M2Z_27),y                  ; 
                    dey                             ; 
                    bpl B_9bb6                      ; 
                    clc                             ; 
                    lda M2Z_27                      ; 
                    adc #$03                        ; 
                    sta M2Z_27                      ; 
                    bcc B_9b55                      ; 
                    inc M2Z_28                      ; 
                    jmp B_9b55                      ; 
B_9bcc              lda XT_6353                     ; 
                    and #$f0                        ; 
                    cmp #$60                        ; 
                    bcc B_9bd7                      ; 
                    lda #$10                        ; 
B_9bd7              clc                             ; 
                    adc #$10                        ; 
                    ora #$02                        ; 
                    ldx #$14                        ; 
B_9bde              sta XT_6353,x                   ; 
                    sta XT_637b,x                   ; 
                    sta XT_63a3,x                   ; 
                    sta XT_63cb,x                   ; 
                    dex                             ; 
                    bpl B_9bde                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9bee            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9bee              subroutine                      ; 
                    inc M2Z_1c                      ; 
                    lda M2Z_1c                      ; 
                    jsr S_9c35                      ; 
                    lda M2Z_45                      ; 
                    sta M2Z_21                      ; 
                    lda M2Z_46                      ; 
                    sta M2Z_22                      ; 
                    dec M2Z_44                      ; 
                    jsr S_8910                      ; 
                    ldy #$10                        ; 
B_9c04              lda (M2Z_23),y                  ; 
                    sta (M2Z_25),y                  ; 
                    lda (M2Z_21),y                  ; 
                    sta (M2Z_23),y                  ; 
                    lda (M2Z_45),y                  ; 
                    sta (M2Z_21),y                  ; 
                    tya                             ; 
                    sec                             ; 
                    sbc #$08                        ; 
                    tay                             ; 
                    bpl B_9c04                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9c18            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9c18              subroutine                      ; 
                    lda M2Z_1c                      ; 
                    dec M2Z_1c                      ; 
                    jsr S_9c35                      ; 
                    ldy #$10                        ; 
B_9c21              lda (M2Z_23),y                  ; 
                    sta (M2Z_45),y                  ; 
                    lda (M2Z_25),y                  ; 
                    sta (M2Z_23),y                  ; 
                    lda #$00                        ; 
                    sta (M2Z_25),y                  ; 
                    tya                             ; 
                    sec                             ; 
                    sbc #$08                        ; 
                    tay                             ; 
                    bpl B_9c21                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9c35            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9c35              subroutine                      ; 
                    sta M2Z_44                      ; 
                    lda M2Z_1b                      ; 
                    sta M2Z_43                      ; 
                    jsr S_8910                      ; 
                    lda M2Z_45                      ; 
                    sta M2Z_25                      ; 
                    lda M2Z_46                      ; 
                    sta M2Z_26                      ; 
                    dec M2Z_44                      ; 
                    dec M2Z_44                      ; 
                    jsr S_8910                      ; 
                    lda M2Z_45                      ; 
                    sta M2Z_23                      ; 
                    lda M2Z_46                      ; 
                    sta M2Z_24                      ; 
                    dec M2Z_44                      ; 
                    dec M2Z_44                      ; 
                    jsr S_8910                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9c5d            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9c5d              subroutine                      ; 
                    jmp J_9d42                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9c60            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9c60              subroutine                      ; 
                    jmp J_9ca9                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9c63            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9c63              subroutine                      ; 
                    jmp J_9c6c                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9c66            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9c66              subroutine                      ; 
                    jmp J_9d1a                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9c69            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9c69              subroutine                      ; 
                    jmp J_9d29                      ; 
J_9c6c              ldx XT_0d01                     ; 
                    ldy XT_0d02                     ; 
                    cpy #$87                        ; 
                    bcc B_9c82                      ; 
                    cpx #$41                        ; 
                    bne B_9c83                      ; 
                    cpy #$e4                        ; 
                    beq B_9c82                      ; 
                    inx                             ; 
                    stx XT_0d01                     ; 
B_9c82              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9c83              bcs B_9c82                      ; 
                    cpx #$39                        ; 
                    bcc B_9c92                      ; 
                    bne B_9ca4                      ; 
                    cpy #$e1                        ; 
                    bcs B_9ca4                      ; 
                    dex                             ; 
                    bne B_9c97                      ; 
B_9c92              cpx #$0e                        ; 
                    bcs B_9c9a                      ; 
                    inx                             ; 
B_9c97              stx XT_0d01                     ; 
B_9c9a              cpy #$9d                        ; 
                    bcs B_9ca3                      ; 
B_9c9e              ldy #$01                        ; 
                    sty XT_0d0d                     ; 
B_9ca3              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9ca4              cpy #$e4                        ; 
                    bcc B_9c9e                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_9ca9              ldx XT_0d7e                     ; 
                    ldy XT_0d86                     ; 
                    lda XT_0d81                     ; 
                    jsr S_9cce                      ; 
                    ldx XT_0d8c                     ; 
                    ldy XT_0d94                     ; 
                    lda XT_0d8f                     ; 
                    jsr S_9cce                      ; 
                    ldx XT_0d9a                     ; 
                    ldy XT_0da2                     ; 
                    lda XT_0d9d                     ; 
                    jsr S_9cce                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9cce            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9cce              subroutine                      ; 
                    cpy #$32                        ; 
                    bne B_9cd6                      ; 
                    cpx #$fe                        ; 
                    beq B_9cd7                      ; 
B_9cd6              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9cd7              sec                             ; 
                    sbc #$a9                        ; 
                    tax                             ; 
                    clc                             ; 
                    adc M2Z_b5                      ; 
                    sta M2Z_b5                      ; 
                    txa                             ; 
                    adc M2Z_b6                      ; 
                    sta M2Z_b6                      ; 
                    cmp #$0a                        ; 
                    bcc B_9cf1                      ; 
                    adc #$05                        ; 
                    and #$0f                        ; 
                    sta M2Z_b6                      ; 
                    inc M2Z_b7                      ; 
B_9cf1              lda M2Z_b7                      ; 
                    beq B_9cfe                      ; 
                    ora #$30                        ; 
                    ldx #$5a                        ; 
                    ldy #$10                        ; 
                    jsr S_9c66                      ; 
B_9cfe              lda M2Z_b6                      ; 
                    ora #$30                        ; 
                    ldx #$62                        ; 
                    ldy #$10                        ; 
                    jsr S_9c66                      ; 
                    lda M2Z_b5                      ; 
                    cmp #$04                        ; 
                    bcc B_9d19                      ; 
                    ldx #$0e                        ; 
                    lda #$aa                        ; 
B_9d13              sta XT_6129,x                   ; 
                    dex                             ; 
                    bpl B_9d13                      ; 
B_9d19              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_9d1a              stx M2Z_43                      ; 
                    sty M2Z_44                      ; 
                    jsr S_9c69                      ; 
                    ldx #$00                        ; 
                    ldy #$aa                        ; 
                    jsr S_955f                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_9d29              and #$3f                        ; 
                    ldx #$00                        ; 
                    stx M2Z_42                      ; 
                    asl a                           ; 
                    asl a                           ; 
                    asl a                           ; 
                    rol M2Z_42                      ; 
                    asl a                           ; 
                    rol M2Z_42                      ; 
                    adc #$00                        ; 
                    sta M2Z_41                      ; 
                    lda M2Z_42                      ; 
                    adc #$72                        ; 
                    sta M2Z_42                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_9d42              ldx M2Z_b4                      ; 
                    bne B_9d77                      ; 
                    jsr S_9e55                      ; 
                    lda XT_0d0b                     ; 
                    cmp #$02                        ; 
                    bne B_9d76                      ; 
                    lda XT_0d01                     ; 
                    cmp #$7f                        ; 
                    bcc B_9d76                      ; 
                    cmp #$82                        ; 
                    bcs B_9d76                      ; 
                    lda XT_0d02                     ; 
                    cmp #$b5                        ; 
                    bcc B_9d76                      ; 
                    cmp #$bd                        ; 
                    bcs B_9d76                      ; 
                    lda M2Z_b5                      ; 
                    beq B_9d76                      ; 
                    inc M2Z_b4                      ; 
                    lda #$ff                        ; 
                    sta XT_0d05                     ; 
                    lda #$80                        ; 
                    sta XT_0d01                     ; 
B_9d76              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9d77              dex                             ; 
                    bne B_9d89                      ; 
                    lda XT_0d02                     ; 
                    cmp #$ca                        ; 
                    bcc B_9d76                      ; 
                    lda #$05                        ; 
                    sta XT_0d0b                     ; 
                    inc M2Z_b4                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9d89              dex                             ; 
                    bne B_9dd4                      ; 
                    lda #$80                        ; 
                    sta M2Z_ba                      ; 
                    lda M2Z_4b                      ; 
                    beq B_9dc6                      ; 
                    lda #$00                        ; 
                    sta M2Z_ba                      ; 
                    lda #$80                        ; 
                    sta M2Z_b9                      ; 
                    lda #$20                        ; 
                    ldx #$5a                        ; 
                    ldy #$10                        ; 
                    jsr S_9c66                      ; 
                    lda #$20                        ; 
                    ldx #$62                        ; 
                    ldy #$10                        ; 
                    jsr S_9c66                      ; 
                    lda #$98                        ; 
                    ldx M2Z_b5                      ; 
                    dex                             ; 
                    beq B_9dc1                      ; 
                    lda #$6d                        ; 
                    dex                             ; 
                    beq B_9dc1                      ; 
                    lda #$45                        ; 
                    dex                             ; 
                    beq B_9dc1                      ; 
                    lda #$1b                        ; 
B_9dc1              sta M2Z_b2                      ; 
                    inc M2Z_b4                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9dc6              lda M2Z_49                      ; 
                    beq B_9dcf                      ; 
                    bmi B_9dd0                      ; 
                    jsr S_9e55                      ; 
B_9dcf              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9dd0              jsr S_9e18                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9dd4              lda XT_0d02                     ; 
                    sec                             ; 
                    sbc M2Z_b2                      ; 
                    bcc B_9e00                      ; 
                    ldx #$fd                        ; 
                    cmp #$0a                        ; 
                    bcc B_9dee                      ; 
                    dex                             ; 
                    cmp #$1e                        ; 
                    bcc B_9dee                      ; 
                    dex                             ; 
                    cmp #$50                        ; 
                    bcc B_9dee                      ; 
                    dex                             ; 
                    dex                             ; 
B_9dee              txa                             ; 
                    clc                             ; 
                    adc XT_0d02                     ; 
                    sta XT_0d02                     ; 
                    cmp #$b9                        ; 
                    bcs B_9dff                      ; 
                    lda #$00                        ; 
                    sta XT_0d05                     ; 
B_9dff              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9e00              lda #$01                        ; 
                    sta XT_0d0b                     ; 
                    lda #$10                        ; 
                    sta XT_0d0d                     ; 
                    lda #$00                        ; 
                    sta XT_0d0c                     ; 
                    sta M2Z_b4                      ; 
                    sta M2Z_b5                      ; 
                    sta M2Z_b6                      ; 
                    sta M2Z_b7                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9e18            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9e18              subroutine                      ; 
                    ldx M2Z_b3                      ; 
                    cpx #$41                        ; 
                    bcc B_9e54                      ; 
                    dec XT_0d01                     ; 
                    dex                             ; 
                    stx M2Z_b3                      ; 
                    stx M2Z_43                      ; 
                    lda #$a0                        ; 
                    sta M2Z_44                      ; 
                    jsr S_9e98                      ; 
B_9e2d              jsr S_8910                      ; 
                    ldy #$00                        ; 
                    sty M2Z_19                      ; 
                    ldy #$28                        ; 
B_9e36              lda (M2Z_45),y                  ; 
                    rol M2Z_19                      ; 
                    rol a                           ; 
                    rol M2Z_19                      ; 
                    rol a                           ; 
                    ror M2Z_19                      ; 
                    ror M2Z_19                      ; 
                    sta (M2Z_45),y                  ; 
                    tya                             ; 
                    sec                             ; 
                    sbc #$08                        ; 
                    tay                             ; 
                    bpl B_9e36                      ; 
                    ldx M2Z_44                      ; 
                    inx                             ; 
                    stx M2Z_44                      ; 
                    cpx #$c3                        ; 
                    bcc B_9e2d                      ; 
B_9e54              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9e55            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9e55              subroutine                      ; 
                    ldx M2Z_b3                      ; 
                    cpx #$6e                        ; 
                    bcs B_9e97                      ; 
                    stx M2Z_43                      ; 
                    inx                             ; 
                    stx M2Z_b3                      ; 
                    ldx #$a0                        ; 
                    stx M2Z_44                      ; 
                    lda M2Z_b4                      ; 
                    cmp #$02                        ; 
                    bne B_9e6d                      ; 
                    inc XT_0d01                     ; 
B_9e6d              jsr S_9e98                      ; 
B_9e70              jsr S_8910                      ; 
                    ldy #$00                        ; 
                    sty M2Z_19                      ; 
B_9e77              lda (M2Z_45),y                  ; 
                    ror M2Z_19                      ; 
                    ror a                           ; 
                    ror M2Z_19                      ; 
                    ror a                           ; 
                    rol M2Z_19                      ; 
                    rol M2Z_19                      ; 
                    sta (M2Z_45),y                  ; 
                    tya                             ; 
                    clc                             ; 
                    adc #$08                        ; 
                    tay                             ; 
                    cpy #$29                        ; 
                    bcc B_9e77                      ; 
                    ldx M2Z_44                      ; 
                    inx                             ; 
                    stx M2Z_44                      ; 
                    cpx #$c3                        ; 
                    bcc B_9e70                      ; 
B_9e97              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9e98            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9e98              subroutine                      ; 
                    lda RASTER                      ; VIC($D012) Read : Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                    cmp #$f5                        ; 
                    bcc S_9e98                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9ea0            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9ea0              subroutine                      ; 
                    jmp J_9ea7                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_9ea3            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_9ea3              subroutine                      ; 
                    jmp J_9ea6                      ; 
J_9ea6              rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_9ea7              sei                             ; 
                    jsr S_8919                      ; 
                    lda #$77                        ; 
                    jsr S_891c                      ; 
                    lda #$77                        ; 
                    jsr S_891f                      ; 
                    ldx #$00                        ; 
B_9eb7              lda #$20                        ; 
                    sta XT_6208,x                   ; 
                    sta XT_62f8,x                   ; 
                    lda #$08                        ; 
                    sta XT_da08,x                   ; 
                    sta XT_daf8,x                   ; 
                    dex                             ; 
                    bne B_9eb7                      ; 
                    lda #$8a                        ; 
                    sta M2Z_20                      ; 
                    lda #$11                        ; 
                    sta M2Z_21                      ; 
B_9ed2              ldx M2Z_20                      ; 
                    ldy M2Z_21                      ; 
                    lda T_9f9f,y                    ; 
                    ldy #$28                        ; 
                    jsr S_9c66                      ; 
                    lda M2Z_20                      ; 
                    sec                             ; 
                    sbc #$08                        ; 
                    sta M2Z_20                      ; 
                    dec M2Z_21                      ; 
                    bpl B_9ed2                      ; 
                    lda #$76                        ; 
                    sta M2Z_20                      ; 
                    lda #$0c                        ; 
                    sta M2Z_21                      ; 
B_9ef1              ldx M2Z_20                      ; 
                    ldy M2Z_21                      ; 
                    lda T_9fb1,y                    ; 
                    ldy #$38                        ; 
                    jsr S_9c66                      ; 
                    lda M2Z_20                      ; 
                    sec                             ; 
                    sbc #$08                        ; 
                    sta M2Z_20                      ; 
                    dec M2Z_21                      ; 
                    bpl B_9ef1                      ; 
                    ldx #$0f                        ; 
B_9f0a              lda T_9fbe,x                    ; 
                    sta XT_620c,x                   ; 
                    lda T_9fce,x                    ; 
                    sta XT_62dd,x                   ; 
                    lda T_9fde,x                    ; 
                    sta XT_6305,x                   ; 
                    lda T_9fee,x                    ; 
                    sta XT_6386,x                   ; 
                    dex                             ; 
                    bpl B_9f0a                      ; 
                    lda #$38                        ; 
                    sta SP0X                        ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                    lda #$aa                        ; 
                    sta SP0Y                        ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                    lda #$00                        ; 
                    sta MSIGX                       ; VIC($D010) MSB X-Pos Sprites 0-7
                    sta SPMC                        ; VIC($D01C) Sprite Multicolor
                    sta EXTCOL                      ; VIC($D020) Border Color
                    sta BGCOL0                      ; VIC($D021) Background Color 0
                    lda #$01                        ; 
                    sta SPENA                       ; VIC($D015) Sprite Enable Register
                    sta SP0COL                      ; VIC($D027) Color Sprite 0
                    sta XXPAND                      ; VIC($D01D) Sprite Double Height
                    sta YXPAND                      ; VIC($D017) Sprite Scale Double Width
                    lda #$a8                        ; 
                    sta XT_63f8                     ; 
                    lda #$04                        ; 
                    sta M2Z_23                      ; 
                    sta M2Z_24                      ; 
B_9f56              lda RASTER                      ; VIC($D012) Read : Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                    cmp #$fa                        ; 
                    bne B_9f56                      ; 
                    jsr S_8925                      ; 
                    lda M2Z_4b                      ; 
                    beq B_9f6f                      ; 
                    lda #$00                        ; 
                    sta M2Z_a2                      ; 
B_9f68              lda #$0b                        ; 
                    sta SCROLY                      ; VIC($D011) VIC Control Register 1 (and Vertical Fine Scrolling)
                    cli                             ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_9f6f              dec M2Z_23                      ; 
                    bne B_9f77                      ; 
                    dec M2Z_24                      ; 
                    beq B_9f68                      ; 
B_9f77              lda #$18                        ; 
                    sta SCROLX                      ; VIC($D016) VIC Control Register 2 (and Horizontal Fine Scrolling)
                    lda #$80                        ; 
                    sta VMCSB                       ; VIC($D018) VIC Chip Memory Control
                    lda #$3b                        ; 
                    sta SCROLY                      ; VIC($D011) VIC Control Register 1 (and Vertical Fine Scrolling)
B_9f86              lda RASTER                      ; VIC($D012) Read : Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                    cmp #$9a                        ; 
                    bne B_9f86                      ; 
                    lda #$1b                        ; 
                    sta SCROLY                      ; VIC($D011) VIC Control Register 1 (and Vertical Fine Scrolling)
                    lda #$08                        ; 
                    sta SCROLX                      ; VIC($D016) VIC Control Register 2 (and Horizontal Fine Scrolling)
                    lda #$8c                        ; 
                    sta VMCSB                       ; VIC($D018) VIC Chip Memory Control
                    jmp B_9f56                      ; 
T_9f9f              dc.b $0f ; 
A_9fa0              dc.b $0c ; 
                    dc.b $05 ; <WHITE>
                    dc.b $01 ; 
                    dc.b $0e ; <to lower>
                    dc.b $04 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $12 ; <REVERS on>
                    dc.b $20 ; _
                    dc.b $10 ; 
                    dc.b $12 ; <REVERS on>
                    dc.b $05 ; <WHITE>
                    dc.b $13 ; <HOME>
                    dc.b $05 ; <WHITE>
                    dc.b $0e ; <to lower>
                    dc.b $14 ; <DEL>
                    dc.b $13 ; <HOME>
A_9fb0              dc.b $3a ; :
T_9fb1              dc.b $0d ; <enter>
                    dc.b $09 ; <SHIFT C= on>
                    dc.b $0e ; <to lower>
                    dc.b $05 ; <WHITE>
                    dc.b $12 ; <REVERS on>
                    dc.b $20 ; _
                    dc.b $32 ; 2
                    dc.b $30 ; 0
                    dc.b $34 ; 4
                    dc.b $39 ; 9
                    dc.b $27 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $12 ; <REVERS on>
T_9fbe              dc.b $02 ; 
                    dc.b $19 ; 
A_9fc0              dc.b $20 ; _
                    dc.b $02 ; 
                    dc.b $09 ; <SHIFT C= on>
                    dc.b $0c ; 
                    dc.b $0c ; 
                    dc.b $20 ; _
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $0f ; 
                    dc.b $07 ; 
                    dc.b $15 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $20 ; _
                    dc.b $20 ; _
                    dc.b $20 ; _
T_9fce              dc.b $03 ; 
                    dc.b $12 ; <REVERS on>
A_9fd0              dc.b $01 ; 
                    dc.b $03 ; 
                    dc.b $0b ; 
                    dc.b $05 ; <WHITE>
                    dc.b $04 ; 
                    dc.b $20 ; _
                    dc.b $09 ; <SHIFT C= on>
                    dc.b $0e ; <to lower>
                    dc.b $20 ; _
                    dc.b $31 ; 1
                    dc.b $39 ; 9
                    dc.b $38 ; 8
                    dc.b $34 ; 4
                    dc.b $20 ; _
T_9fde              dc.b $02 ; 
                    dc.b $19 ; 
A_9fe0              dc.b $20 ; _
                    dc.b $0f ; 
                    dc.b $0c ; 
                    dc.b $05 ; <WHITE>
                    dc.b $01 ; 
                    dc.b $0e ; <to lower>
                    dc.b $04 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $12 ; <REVERS on>
                    dc.b $20 ; _
                    dc.b $20 ; _
                    dc.b $20 ; _
                    dc.b $20 ; _
                    dc.b $20 ; _
T_9fee              dc.b $08 ; <SHIFT C= off>
                    dc.b $09 ; <SHIFT C= on>
A_9ff0              dc.b $21 ; !
                    dc.b $20 ; _
                    dc.b $20 ; _
                    dc.b $0d ; <enter>
                    dc.b $12 ; <REVERS on>
                    dc.b $2e ; .
                    dc.b $0f ; 
                    dc.b $20 ; _
                    dc.b $26 ; &
                    dc.b $20 ; _
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $0f ; 
                    dc.b $0e ; <to lower>
                    dc.b $1a ; 
                    dc.b $20 ; _
                    dc.b $20 ; _
A_a000              dc.b $07 ; 
                    dc.b $11 ; <CRSR down>
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a010              dc.b $aa ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $a0 ; <_ (shift)>
                    dc.b $a0 ; <_ (shift)>
                    dc.b $aa ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $a0 ; <_ (shift)>
                    dc.b $a0 ; <_ (shift)>
                    dc.b $aa ; 
                    dc.b $0a ; 
                    dc.b $0a ; 
                    dc.b $0a ; 
                    dc.b $aa ; 
                    dc.b $0a ; 
                    dc.b $0a ; 
                    dc.b $0a ; 
A_a020              dc.b $aa ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a030              dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $50 ; p
                    dc.b $50 ; p
                    dc.b $50 ; p
                    dc.b $50 ; p
                    dc.b $50 ; p
                    dc.b $50 ; p
                    dc.b $50 ; p
                    dc.b $50 ; p
A_a040              dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a050              dc.b $aa ; 
                    dc.b $aa ; 
                    dc.b $aa ; 
                    dc.b $82 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $54 ; t
                    dc.b $54 ; t
                    dc.b $10 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a060              dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $aa ; 
                    dc.b $aa ; 
                    dc.b $aa ; 
                    dc.b $aa ; 
                    dc.b $aa ; 
                    dc.b $aa ; 
                    dc.b $aa ; 
                    dc.b $aa ; 
A_a070              dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a080              dc.b $03 ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $04 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $15 ; 
A_a090              dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $04 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $40 ; @
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $40 ; @
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $c0 ; 
A_a0a0              dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $94 ; <INST>
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $64 ; D
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $f8 ; 
                    dc.b $00 ; 
A_a0b0              dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $28 ; (
                    dc.b $a0 ; <_ (shift)>
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a0c0              dc.b $03 ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $04 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $15 ; 
A_a0d0              dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $04 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $40 ; @
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $40 ; @
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $c0 ; 
A_a0e0              dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $94 ; <INST>
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $64 ; D
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $ec ; 
                    dc.b $00 ; 
A_a0f0              dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $0a ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a100              dc.b $03 ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $04 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $15 ; 
A_a110              dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $04 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $40 ; @
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $40 ; @
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $c0 ; 
A_a120              dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $94 ; <INST>
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $64 ; D
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $bc ; 
                    dc.b $00 ; 
A_a130              dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $80 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $80 ; 
                    dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $80 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a140              dc.b $03 ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $04 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $15 ; 
A_a150              dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $04 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $40 ; @
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $40 ; @
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $c0 ; 
A_a160              dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $94 ; <INST>
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $94 ; <INST>
                    dc.b $00 ; 
                    dc.b $3e ; >
                    dc.b $fc ; 
                    dc.b $00 ; 
A_a170              dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $0a ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a180              dc.b $03 ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $04 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $15 ; 
A_a190              dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $04 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $40 ; @
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $40 ; @
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $c0 ; 
A_a1a0              dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $94 ; <INST>
                    dc.b $00 ; 
                    dc.b $16 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $3b ; ;
                    dc.b $fc ; 
                    dc.b $00 ; 
A_a1b0              dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $28 ; (
                    dc.b $a0 ; <_ (shift)>
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a1c0              dc.b $03 ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $10 ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
A_a1d0              dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $10 ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $00 ; 
A_a1e0              dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $16 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $19 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $2f ; /
                    dc.b $fc ; 
                    dc.b $00 ; 
A_a1f0              dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $0a ; 
                    dc.b $28 ; (
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a200              dc.b $03 ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $10 ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
A_a210              dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $10 ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $00 ; 
A_a220              dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $16 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $19 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $3b ; ;
                    dc.b $fc ; 
                    dc.b $00 ; 
A_a230              dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $80 ; 
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $80 ; 
                    dc.b $00 ; 
                    dc.b $0a ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a240              dc.b $03 ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $10 ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
A_a250              dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $10 ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $00 ; 
A_a260              dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $16 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $19 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $3e ; >
                    dc.b $fc ; 
                    dc.b $00 ; 
A_a270              dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $80 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a280              dc.b $03 ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $10 ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
A_a290              dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $10 ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $00 ; 
A_a2a0              dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $16 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $16 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $bc ; 
                    dc.b $00 ; 
A_a2b0              dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $80 ; 
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $80 ; 
                    dc.b $00 ; 
                    dc.b $0a ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a2c0              dc.b $03 ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $10 ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
A_a2d0              dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $10 ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $00 ; 
A_a2e0              dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $16 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $94 ; <INST>
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $ec ; 
                    dc.b $00 ; 
A_a2f0              dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $0a ; 
                    dc.b $28 ; (
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a300              dc.b $03 ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $04 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $15 ; 
A_a310              dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $04 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $40 ; @
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $40 ; @
                    dc.b $00 ; 
                    dc.b $20 ; _
                    dc.b $c2 ; B
A_a320              dc.b $00 ; 
                    dc.b $0b ; 
                    dc.b $f8 ; 
                    dc.b $00 ; 
                    dc.b $3e ; >
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $94 ; <INST>
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
A_a330              dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $8b ; <f6>
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $a8 ; 
                    dc.b $22 ; "
                    dc.b $00 ; 
                    dc.b $20 ; _
                    dc.b $2a ; *
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a340              dc.b $03 ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $10 ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
A_a350              dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $10 ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $83 ; <load+run>
                    dc.b $08 ; <SHIFT C= off>
A_a360              dc.b $00 ; 
                    dc.b $2f ; /
                    dc.b $e0 ; <_ (shift)>
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $bc ; 
                    dc.b $00 ; 
                    dc.b $16 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
A_a370              dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $e2 ; 
                    dc.b $00 ; 
                    dc.b $88 ; <f7>
                    dc.b $2a ; *
                    dc.b $00 ; 
                    dc.b $a8 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $00 ; 
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a380              dc.b $03 ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $15 ; 
A_a390              dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $a1 ; 
                    dc.b $40 ; @
                    dc.b $00 ; 
                    dc.b $83 ; <load+run>
                    dc.b $c0 ; 
A_a3a0              dc.b $00 ; 
                    dc.b $8f ; 
                    dc.b $fa ; 
                    dc.b $00 ; 
                    dc.b $bf ; 
                    dc.b $fe ; 
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
A_a3b0              dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $e0 ; <_ (shift)>
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $00 ; 
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a3c0              dc.b $03 ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $15 ; 
A_a3d0              dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $4a ; j
                    dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $c2 ; B
A_a3e0              dc.b $00 ; 
                    dc.b $af ; 
                    dc.b $f2 ; 
                    dc.b $00 ; 
                    dc.b $bf ; 
                    dc.b $fe ; 
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
A_a3f0              dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $0b ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $20 ; _
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a400              dc.b $03 ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $a5 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $bf ; 
A_a410              dc.b $fe ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $fe ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $fc ; 
A_a420              dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $3c ; <
                    dc.b $3c ; <
                    dc.b $00 ; 
                    dc.b $3c ; <
                    dc.b $3c ; <
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $3c ; <
                    dc.b $00 ; 
A_a430              dc.b $08 ; <SHIFT C= off>
                    dc.b $3c ; <
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $20 ; _
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a440              dc.b $03 ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $5a ; z
                    dc.b $00 ; 
                    dc.b $bf ; 
A_a450              dc.b $fe ; 
                    dc.b $00 ; 
                    dc.b $bf ; 
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $ff ; 
A_a460              dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $3c ; <
                    dc.b $3c ; <
                    dc.b $00 ; 
                    dc.b $3c ; <
                    dc.b $3c ; <
                    dc.b $00 ; 
                    dc.b $3c ; <
                    dc.b $20 ; _
                    dc.b $00 ; 
A_a470              dc.b $3c ; <
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $00 ; 
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a480              dc.b $03 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $c7 ; G
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $fe ; 
                    dc.b $30 ; 0
                    dc.b $00 ; 
                    dc.b $19 ; 
A_a490              dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $06 ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $06 ; 
                    dc.b $30 ; 0
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a4a0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a4b0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a4c0              dc.b $03 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $c7 ; G
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $fe ; 
                    dc.b $30 ; 0
                    dc.b $00 ; 
                    dc.b $19 ; 
A_a4d0              dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $80 ; 
                    dc.b $00 ; 
                    dc.b $31 ; 1
                    dc.b $80 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a4e0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a4f0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a500              dc.b $0c ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $3e ; >
                    dc.b $30 ; 0
                    dc.b $00 ; 
                    dc.b $c7 ; G
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $f9 ; 
A_a510              dc.b $80 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0c ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $36 ; 6
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $c6 ; F
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a520              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a530              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a540              dc.b $0c ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $3e ; >
                    dc.b $30 ; 0
                    dc.b $00 ; 
                    dc.b $c7 ; G
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $f9 ; 
A_a550              dc.b $80 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0c ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $1b ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $18 ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a560              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a570              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a580              dc.b $0c ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $c0 ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $cc ; L
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $e1 ; 
A_a590              dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0c ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $33 ; 3
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $c0 ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a5a0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a5b0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a5c0              dc.b $0c ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $c0 ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $cc ; L
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $e1 ; 
A_a5d0              dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0c ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0c ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $33 ; 3
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a5e0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a5f0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a600              dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $a8 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $00 ; 
                    dc.b $88 ; <f7>
                    dc.b $2a ; *
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $e2 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
A_a610              dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $16 ; 
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $bc ; 
                    dc.b $00 ; 
                    dc.b $2f ; /
                    dc.b $e0 ; <_ (shift)>
                    dc.b $00 ; 
                    dc.b $83 ; <load+run>
                    dc.b $08 ; <SHIFT C= off>
A_a620              dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $10 ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $54 ; t
                    dc.b $00 ; 
A_a630              dc.b $05 ; <WHITE>
                    dc.b $10 ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $c0 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a640              dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a650              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a660              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a670              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a680              dc.b $00 ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $0c ; 
                    dc.b $00 ; 
                    dc.b $0c ; 
                    dc.b $03 ; 
                    dc.b $00 ; 
                    dc.b $11 ; <CRSR down>
                    dc.b $f8 ; 
                    dc.b $80 ; 
                    dc.b $23 ; #
                    dc.b $fc ; 
                    dc.b $40 ; @
                    dc.b $27 ; 
A_a690              dc.b $fe ; 
                    dc.b $40 ; @
                    dc.b $47 ; g
                    dc.b $0e ; <to lower>
                    dc.b $20 ; _
                    dc.b $40 ; @
                    dc.b $00 ; 
                    dc.b $20 ; _
                    dc.b $87 ; <f5>
                    dc.b $0e ; <to lower>
                    dc.b $30 ; 0
                    dc.b $80 ; 
                    dc.b $00 ; 
                    dc.b $10 ; 
                    dc.b $87 ; <f5>
                    dc.b $0e ; <to lower>
A_a6a0              dc.b $10 ; 
                    dc.b $80 ; 
                    dc.b $00 ; 
                    dc.b $10 ; 
                    dc.b $78 ; X
                    dc.b $f1 ; 
                    dc.b $e0 ; <_ (shift)>
                    dc.b $78 ; X
                    dc.b $f1 ; 
                    dc.b $e0 ; <_ (shift)>
                    dc.b $38 ; 8
                    dc.b $01 ; 
                    dc.b $c0 ; 
                    dc.b $3c ; <
                    dc.b $03 ; 
                    dc.b $c0 ; 
A_a6b0              dc.b $1e ; <GREEN>
                    dc.b $07 ; 
                    dc.b $80 ; 
                    dc.b $0f ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $fc ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a6c0              dc.b $1e ; <GREEN>
                    dc.b $1e ; <GREEN>
                    dc.b $00 ; 
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $00 ; 
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $00 ; 
                    dc.b $1f ; <BLUE>
                    dc.b $33 ; 3
                    dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $33 ; 3
                    dc.b $00 ; 
                    dc.b $03 ; 
A_a6d0              dc.b $33 ; 3
                    dc.b $00 ; 
                    dc.b $06 ; 
                    dc.b $33 ; 3
                    dc.b $00 ; 
                    dc.b $0c ; 
                    dc.b $33 ; 3
                    dc.b $00 ; 
                    dc.b $18 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a6e0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a6f0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a700              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $1e ; <GREEN>
                    dc.b $03 ; 
A_a710              dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $03 ; 
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $03 ; 
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $03 ; 
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $03 ; 
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $03 ; 
                    dc.b $33 ; 3
A_a720              dc.b $33 ; 3
                    dc.b $03 ; 
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $03 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $1e ; <GREEN>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a730              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a740              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $1e ; <GREEN>
                    dc.b $1e ; <GREEN>
                    dc.b $33 ; 3
A_a750              dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $03 ; 
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $06 ; 
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $0c ; 
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $18 ; 
                    dc.b $33 ; 3
A_a760              dc.b $33 ; 3
                    dc.b $30 ; 0
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $3f ; ?
                    dc.b $1e ; <GREEN>
                    dc.b $1e ; <GREEN>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a770              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a780              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $1e ; <GREEN>
                    dc.b $1e ; <GREEN>
                    dc.b $33 ; 3
A_a790              dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $03 ; 
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $03 ; 
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $06 ; 
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $03 ; 
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $03 ; 
                    dc.b $33 ; 3
A_a7a0              dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $1e ; <GREEN>
                    dc.b $1e ; <GREEN>
                    dc.b $1e ; <GREEN>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a7b0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a7c0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $06 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $1e ; <GREEN>
                    dc.b $0e ; <to lower>
A_a7d0              dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $1e ; <GREEN>
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $36 ; 6
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $66 ; F
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $ff ; 
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $ff ; 
                    dc.b $33 ; 3
A_a7e0              dc.b $33 ; 3
                    dc.b $06 ; 
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $06 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $1e ; <GREEN>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a7f0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a800              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $3f ; ?
                    dc.b $1e ; <GREEN>
                    dc.b $1e ; <GREEN>
                    dc.b $30 ; 0
A_a810              dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $30 ; 0
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $3e ; >
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $03 ; 
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $03 ; 
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $03 ; 
                    dc.b $33 ; 3
A_a820              dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $1e ; <GREEN>
                    dc.b $1e ; <GREEN>
                    dc.b $1e ; <GREEN>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a830              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a840              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $33 ; 3
                    dc.b $1e ; <GREEN>
                    dc.b $1e ; <GREEN>
                    dc.b $33 ; 3
A_a850              dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
A_a860              dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $33 ; 3
                    dc.b $1e ; <GREEN>
                    dc.b $1e ; <GREEN>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a870              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a880              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $16 ; 
                    dc.b $aa ; 
                    dc.b $aa ; 
                    dc.b $aa ; 
                    dc.b $aa ; 
                    dc.b $14 ; <DEL>
                    dc.b $14 ; <DEL>
                    dc.b $14 ; <DEL>
                    dc.b $14 ; <DEL>
                    dc.b $14 ; <DEL>
                    dc.b $14 ; <DEL>
                    dc.b $14 ; <DEL>
                    dc.b $14 ; <DEL>
                    dc.b $14 ; <DEL>
A_a890              dc.b $20 ; _
                    dc.b $a8 ; 
                    dc.b $aa ; 
                    dc.b $aa ; 
                    dc.b $aa ; 
                    dc.b $aa ; 
                    dc.b $a8 ; 
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a8a0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $55 ; u
                    dc.b $aa ; 
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $aa ; 
                    dc.b $14 ; <DEL>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a8b0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $20 ; _
                    dc.b $88 ; <f7>
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $20 ; _
                    dc.b $80 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a8c0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $2a ; *
                    dc.b $aa ; 
                    dc.b $aa ; 
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $15 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a8d0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $a8 ; 
                    dc.b $a8 ; 
                    dc.b $54 ; t
                    dc.b $54 ; t
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a8e0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0a ; 
                    dc.b $5a ; z
                    dc.b $5a ; z
                    dc.b $0a ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a8f0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $a5 ; 
                    dc.b $a5 ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a900              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $28 ; (
                    dc.b $28 ; (
                    dc.b $aa ; 
                    dc.b $aa ; 
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a910              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a920              dc.b $2a ; *
                    dc.b $80 ; 
                    dc.b $22 ; "
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $15 ; 
                    dc.b $04 ; 
A_a930              dc.b $00 ; 
                    dc.b $80 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $40 ; @
                    dc.b $40 ; @
                    dc.b $40 ; @
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a940              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $6a ; J
                    dc.b $1a ; 
                    dc.b $06 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $02 ; 
                    dc.b $02 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $00 ; 
A_a950              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $a4 ; 
                    dc.b $90 ; <BLACK>
                    dc.b $40 ; @
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a960              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $2a ; *
                    dc.b $aa ; 
                    dc.b $15 ; 
                    dc.b $15 ; 
                    dc.b $aa ; 
                    dc.b $2a ; *
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a970              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $a8 ; 
                    dc.b $aa ; 
                    dc.b $54 ; t
                    dc.b $54 ; t
                    dc.b $aa ; 
                    dc.b $a8 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a980              dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $2a ; *
                    dc.b $22 ; "
                    dc.b $81 ; <ORANGE>
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $00 ; 
A_a990              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $20 ; _
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a9a0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $04 ; 
                    dc.b $10 ; 
                    dc.b $aa ; 
                    dc.b $aa ; 
                    dc.b $2a ; *
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a9b0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $40 ; @
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $aa ; 
                    dc.b $aa ; 
                    dc.b $a8 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a9c0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $20 ; _
                    dc.b $88 ; <f7>
                    dc.b $82 ; 
                    dc.b $15 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a9d0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $04 ; 
                    dc.b $10 ; 
                    dc.b $10 ; 
                    dc.b $10 ; 
                    dc.b $10 ; 
                    dc.b $10 ; 
                    dc.b $10 ; 
                    dc.b $10 ; 
                    dc.b $10 ; 
                    dc.b $55 ; u
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a9e0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $20 ; _
                    dc.b $80 ; 
                    dc.b $80 ; 
                    dc.b $2a ; *
                    dc.b $0a ; 
                    dc.b $20 ; _
                    dc.b $80 ; 
                    dc.b $80 ; 
                    dc.b $80 ; 
                    dc.b $80 ; 
                    dc.b $80 ; 
                    dc.b $80 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_a9f0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $80 ; 
                    dc.b $20 ; _
                    dc.b $20 ; _
                    dc.b $80 ; 
                    dc.b $00 ; 
                    dc.b $80 ; 
                    dc.b $20 ; _
                    dc.b $20 ; _
                    dc.b $20 ; _
                    dc.b $20 ; _
                    dc.b $20 ; _
                    dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $00 ; 
A_aa00              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $21 ; !
                    dc.b $21 ; !
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $00 ; 
                    dc.b $00 ; 
A_aa10              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $54 ; t
                    dc.b $40 ; @
                    dc.b $40 ; @
                    dc.b $40 ; @
                    dc.b $48 ; h
                    dc.b $48 ; h
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $00 ; 
                    dc.b $00 ; 
A_aa20              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $20 ; _
                    dc.b $95 ; <BROWN>
                    dc.b $95 ; <BROWN>
                    dc.b $21 ; !
                    dc.b $01 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $05 ; <WHITE>
                    dc.b $05 ; <WHITE>
                    dc.b $02 ; 
                    dc.b $02 ; 
                    dc.b $02 ; 
                    dc.b $02 ; 
                    dc.b $02 ; 
                    dc.b $00 ; 
A_aa30              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $56 ; v
                    dc.b $56 ; v
                    dc.b $48 ; h
                    dc.b $40 ; @
                    dc.b $50 ; p
                    dc.b $50 ; p
                    dc.b $50 ; p
                    dc.b $80 ; 
                    dc.b $80 ; 
                    dc.b $80 ; 
                    dc.b $80 ; 
                    dc.b $80 ; 
                    dc.b $00 ; 
A_aa40              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $41 ; a
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $15 ; 
                    dc.b $55 ; u
                    dc.b $00 ; 
A_aa50              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $55 ; u
                    dc.b $54 ; t
                    dc.b $50 ; p
                    dc.b $50 ; p
                    dc.b $50 ; p
                    dc.b $50 ; p
                    dc.b $50 ; p
                    dc.b $50 ; p
                    dc.b $50 ; p
                    dc.b $54 ; t
                    dc.b $55 ; u
                    dc.b $00 ; 
A_aa60              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $15 ; 
                    dc.b $41 ; a
                    dc.b $41 ; a
                    dc.b $41 ; a
                    dc.b $14 ; <DEL>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_aa70              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $54 ; t
                    dc.b $41 ; a
                    dc.b $41 ; a
                    dc.b $41 ; a
                    dc.b $14 ; <DEL>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_aa80              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $2a ; *
                    dc.b $80 ; 
                    dc.b $80 ; 
                    dc.b $20 ; _
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_aa90              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $80 ; 
                    dc.b $20 ; _
                    dc.b $20 ; _
                    dc.b $80 ; 
                    dc.b $54 ; t
                    dc.b $55 ; u
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_aaa0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $1a ; 
                    dc.b $1a ; 
                    dc.b $06 ; 
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $00 ; 
                    dc.b $00 ; 
A_aab0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $a9 ; 
                    dc.b $a9 ; 
                    dc.b $a4 ; 
                    dc.b $90 ; <BLACK>
                    dc.b $40 ; @
                    dc.b $40 ; @
                    dc.b $40 ; @
                    dc.b $40 ; @
                    dc.b $40 ; @
                    dc.b $50 ; p
                    dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $00 ; 
A_aac0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $11 ; <CRSR down>
                    dc.b $11 ; <CRSR down>
                    dc.b $2a ; *
                    dc.b $2a ; *
                    dc.b $15 ; 
                    dc.b $2a ; *
                    dc.b $2a ; *
                    dc.b $15 ; 
                    dc.b $2a ; *
                    dc.b $2a ; *
                    dc.b $00 ; 
                    dc.b $00 ; 
A_aad0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $10 ; 
                    dc.b $10 ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $a0 ; <_ (shift)>
                    dc.b $50 ; p
                    dc.b $a0 ; <_ (shift)>
                    dc.b $a0 ; <_ (shift)>
                    dc.b $50 ; p
                    dc.b $a0 ; <_ (shift)>
                    dc.b $a0 ; <_ (shift)>
                    dc.b $00 ; 
                    dc.b $00 ; 
A_aae0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $14 ; <DEL>
                    dc.b $69 ; I
                    dc.b $14 ; <DEL>
                    dc.b $0a ; 
                    dc.b $02 ; 
                    dc.b $15 ; 
                    dc.b $15 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $05 ; <WHITE>
                    dc.b $05 ; <WHITE>
                    dc.b $00 ; 
                    dc.b $00 ; 
A_aaf0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $04 ; 
                    dc.b $19 ; 
                    dc.b $04 ; 
                    dc.b $20 ; _
                    dc.b $a0 ; <_ (shift)>
                    dc.b $80 ; 
                    dc.b $54 ; t
                    dc.b $54 ; t
                    dc.b $50 ; p
                    dc.b $50 ; p
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $00 ; 
A_ab00              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $10 ; 
                    dc.b $15 ; 
                    dc.b $15 ; 
                    dc.b $15 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_ab10              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $40 ; @
                    dc.b $41 ; a
                    dc.b $41 ; a
                    dc.b $44 ; d
                    dc.b $41 ; a
                    dc.b $51 ; q
                    dc.b $5a ; z
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_ab20              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $55 ; u
                    dc.b $56 ; v
                    dc.b $5a ; z
                    dc.b $66 ; F
                    dc.b $66 ; F
                    dc.b $5a ; z
                    dc.b $56 ; v
                    dc.b $66 ; F
                    dc.b $5a ; z
                    dc.b $56 ; v
                    dc.b $55 ; u
                    dc.b $00 ; 
                    dc.b $00 ; 
A_ab30              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $55 ; u
                    dc.b $95 ; <BROWN>
                    dc.b $a5 ; 
                    dc.b $99 ; <LIGHT GREEN>
                    dc.b $95 ; <BROWN>
                    dc.b $a5 ; 
                    dc.b $99 ; <LIGHT GREEN>
                    dc.b $99 ; <LIGHT GREEN>
                    dc.b $a5 ; 
                    dc.b $95 ; <BROWN>
                    dc.b $55 ; u
                    dc.b $00 ; 
                    dc.b $00 ; 
A_ab40              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $04 ; 
                    dc.b $04 ; 
                    dc.b $04 ; 
                    dc.b $15 ; 
                    dc.b $15 ; 
                    dc.b $15 ; 
                    dc.b $15 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $00 ; 
                    dc.b $00 ; 
A_ab50              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $40 ; @
                    dc.b $40 ; @
                    dc.b $40 ; @
                    dc.b $40 ; @
                    dc.b $51 ; q
                    dc.b $54 ; t
                    dc.b $50 ; p
                    dc.b $50 ; p
                    dc.b $40 ; @
                    dc.b $00 ; 
                    dc.b $00 ; 
A_ab60              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $0a ; 
                    dc.b $22 ; "
                    dc.b $81 ; <ORANGE>
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $00 ; 
A_ab70              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $a0 ; <_ (shift)>
                    dc.b $a0 ; <_ (shift)>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_ab80              dc.b $20 ; _
                    dc.b $82 ; 
                    dc.b $82 ; 
                    dc.b $82 ; 
                    dc.b $42 ; b
                    dc.b $85 ; <f1>
                    dc.b $82 ; 
                    dc.b $82 ; 
                    dc.b $55 ; u
                    dc.b $05 ; <WHITE>
                    dc.b $02 ; 
                    dc.b $02 ; 
                    dc.b $02 ; 
                    dc.b $02 ; 
                    dc.b $15 ; 
                    dc.b $55 ; u
A_ab90              dc.b $82 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $04 ; 
                    dc.b $48 ; h
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $54 ; t
                    dc.b $40 ; @
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $50 ; p
                    dc.b $54 ; t
A_aba0              dc.b $aa ; 
                    dc.b $aa ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $a0 ; <_ (shift)>
                    dc.b $aa ; 
                    dc.b $aa ; 
                    dc.b $a2 ; 
                    dc.b $a2 ; 
                    dc.b $a2 ; 
                    dc.b $a2 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
A_abb0              dc.b $00 ; 
                    dc.b $80 ; 
                    dc.b $80 ; 
                    dc.b $80 ; 
                    dc.b $80 ; 
                    dc.b $00 ; 
                    dc.b $54 ; t
                    dc.b $55 ; u
                    dc.b $41 ; a
                    dc.b $41 ; a
                    dc.b $55 ; u
                    dc.b $55 ; u
                    dc.b $44 ; d
                    dc.b $45 ; e
                    dc.b $45 ; e
                    dc.b $45 ; e
A_abc0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $02 ; 
                    dc.b $0a ; 
                    dc.b $0a ; 
                    dc.b $0a ; 
                    dc.b $0a ; 
                    dc.b $0a ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_abd0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $80 ; 
                    dc.b $80 ; 
                    dc.b $80 ; 
                    dc.b $80 ; 
                    dc.b $80 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_abe0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $20 ; _
                    dc.b $20 ; _
                    dc.b $a8 ; 
                    dc.b $a8 ; 
                    dc.b $a8 ; 
                    dc.b $a8 ; 
                    dc.b $a8 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_abf0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $20 ; _
                    dc.b $20 ; _
                    dc.b $a8 ; 
                    dc.b $a8 ; 
                    dc.b $a8 ; 
                    dc.b $a8 ; 
                    dc.b $a8 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_ac00              dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $02 ; 
                    dc.b $0a ; 
                    dc.b $0a ; 
                    dc.b $0a ; 
                    dc.b $0a ; 
                    dc.b $0a ; 
                    dc.b $00 ; 
                    dc.b $20 ; _
                    dc.b $20 ; _
                    dc.b $a8 ; 
                    dc.b $a8 ; 
                    dc.b $a8 ; 
                    dc.b $a8 ; 
                    dc.b $a8 ; 
A_ac10              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $80 ; 
                    dc.b $80 ; 
                    dc.b $80 ; 
                    dc.b $80 ; 
                    dc.b $80 ; 
                    dc.b $00 ; 
                    dc.b $20 ; _
                    dc.b $20 ; _
                    dc.b $a8 ; 
                    dc.b $a8 ; 
                    dc.b $a8 ; 
                    dc.b $a8 ; 
                    dc.b $a8 ; 
A_ac20              dc.b $c9 ; I
                    dc.b $2c ; ,
                    dc.b $f0 ; 
                    dc.b $06 ; 
                    dc.b $20 ; _
                    dc.b $f1 ; 
                    dc.b $29 ; )
                    dc.b $4c ; l
                    dc.b $1b ; 
                    dc.b $2c ; ,
                    dc.b $20 ; _
                    dc.b $87 ; <f5>
                    dc.b $2c ; ,
                    dc.b $4c ; l
                    dc.b $1b ; 
                    dc.b $2c ; ,
A_ac30              dc.b $20 ; _
                    dc.b $87 ; <f5>
                    dc.b $2c ; ,
                    dc.b $60 ; 
                    dc.b $48 ; h
                    dc.b $ad ; 
                    dc.b $85 ; <f1>
                    dc.b $09 ; <SHIFT C= on>
                    dc.b $8d ; <shift return>
                    dc.b $78 ; X
                    dc.b $09 ; <SHIFT C= on>
                    dc.b $ad ; 
                    dc.b $86 ; <f3>
                    dc.b $09 ; <SHIFT C= on>
                    dc.b $8d ; <shift return>
                    dc.b $79 ; Y
A_ac40              dc.b $09 ; <SHIFT C= on>
                    dc.b $a9 ; 
                    dc.b $80 ; 
                    dc.b $8d ; <shift return>
                    dc.b $7f ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $68 ; H
                    dc.b $ae ; 
                    dc.b $6a ; J
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $a0 ; <_ (shift)>
                    dc.b $00 ; 
                    dc.b $4c ; l
                    dc.b $c8 ; H
                    dc.b $15 ; 
                    dc.b $ae ; 
A_ac50              dc.b $6e ; N
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $ec ; 
                    dc.b $77 ; W
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $f0 ; 
                    dc.b $02 ; 
                    dc.b $b0 ; 
                    dc.b $10 ; 
                    dc.b $bd ; 
                    dc.b $80 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $c9 ; I
                    dc.b $20 ; _
                    dc.b $f0 ; 
                    dc.b $09 ; <SHIFT C= on>
A_ac60              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_ac70              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_ac80              dc.b $28 ; (
                    dc.b $00 ; 
                    dc.b $c7 ; G
                    dc.b $04 ; 
                    dc.b $28 ; (
                    dc.b $04 ; 
                    dc.b $0c ; 
                    dc.b $c0 ; 
                    dc.b $f4 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $0c ; 
                    dc.b $1c ; <RED>
                    dc.b $bd ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $08 ; <SHIFT C= off>
A_ac90              dc.b $4c ; l
                    dc.b $bc ; 
                    dc.b $f4 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $0d ; <enter>
                    dc.b $6c ; L
                    dc.b $b5 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $70 ; P
                    dc.b $b7 ; 
                    dc.b $80 ; 
                    dc.b $13 ; <HOME>
                    dc.b $02 ; 
                    dc.b $74 ; T
A_aca0              dc.b $b7 ; 
                    dc.b $80 ; 
                    dc.b $1b ; 
                    dc.b $04 ; 
                    dc.b $22 ; "
                    dc.b $9d ; <CRSR left>
                    dc.b $80 ; 
                    dc.b $14 ; <DEL>
                    dc.b $04 ; 
                    dc.b $26 ; &
                    dc.b $9d ; <CRSR left>
                    dc.b $80 ; 
                    dc.b $1c ; <RED>
                    dc.b $12 ; <REVERS on>
                    dc.b $00 ; 
                    dc.b $9c ; <PURPLE>
A_acb0              dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $12 ; <REVERS on>
                    dc.b $48 ; h
                    dc.b $9d ; <CRSR left>
                    dc.b $14 ; <DEL>
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $02 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $8a ; <f4>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $0e ; <to lower>
                    dc.b $1c ; <RED>
                    dc.b $84 ; 
                    dc.b $f4 ; 
A_acc0              dc.b $08 ; <SHIFT C= off>
                    dc.b $10 ; 
                    dc.b $54 ; t
                    dc.b $78 ; X
                    dc.b $14 ; <DEL>
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $03 ; 
                    dc.b $4e ; n
                    dc.b $60 ; 
                    dc.b $80 ; 
                    dc.b $14 ; <DEL>
                    dc.b $03 ; 
                    dc.b $52 ; r
                    dc.b $60 ; 
                    dc.b $80 ; 
                    dc.b $1c ; <RED>
A_acd0              dc.b $11 ; <CRSR down>
                    dc.b $0c ; 
                    dc.b $4f ; o
                    dc.b $14 ; <DEL>
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $11 ; <CRSR down>
                    dc.b $50 ; p
                    dc.b $60 ; 
                    dc.b $f4 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $04 ; 
                    dc.b $2c ; ,
                    dc.b $38 ; 8
                    dc.b $80 ; 
                    dc.b $14 ; <DEL>
                    dc.b $04 ; 
A_ace0              dc.b $30 ; 0
                    dc.b $38 ; 8
                    dc.b $80 ; 
                    dc.b $1c ; <RED>
                    dc.b $24 ; $
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $37 ; 7
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $04 ; 
                    dc.b $34 ; 4
                    dc.b $7c ; 
                    dc.b $80 ; 
                    dc.b $16 ; 
                    dc.b $04 ; 
                    dc.b $38 ; 8
A_acf0              dc.b $7c ; 
                    dc.b $80 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $03 ; 
                    dc.b $80 ; 
                    dc.b $3c ; <
                    dc.b $80 ; 
                    dc.b $10 ; 
                    dc.b $03 ; 
                    dc.b $84 ; 
                    dc.b $3c ; <
                    dc.b $80 ; 
                    dc.b $18 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $78 ; X
                    dc.b $82 ; 
A_ad00              dc.b $80 ; 
                    dc.b $14 ; <DEL>
                    dc.b $05 ; <WHITE>
                    dc.b $7c ; 
                    dc.b $82 ; 
                    dc.b $80 ; 
                    dc.b $1c ; <RED>
                    dc.b $00 ; 
                    dc.b $7c ; 
                    dc.b $d2 ; R
                    dc.b $e4 ; 
                    dc.b $2e ; .
                    dc.b $b9 ; 
                    dc.b $da ; Z
                    dc.b $84 ; 
                    dc.b $9e ; <YELLOW>
A_ad10              dc.b $c6 ; F
                    dc.b $40 ; @
                    dc.b $9b ; <GREY 3>
                    dc.b $b9 ; 
                    dc.b $5a ; z
                    dc.b $7d ; 
                    dc.b $94 ; <INST>
                    dc.b $8c ; <f8>
                    dc.b $54 ; t
                    dc.b $71 ; Q
                    dc.b $38 ; 8
                    dc.b $54 ; t
                    dc.b $75 ; U
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $10 ; 
A_ad20              dc.b $e4 ; 
                    dc.b $97 ; <GREY 1>
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $02 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $80 ; 
                    dc.b $ef ; 
                    dc.b $a0 ; <_ (shift)>
A_ad30              dc.b $0a ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $06 ; 
                    dc.b $ff ; 
                    dc.b $10 ; 
                    dc.b $8c ; <f8>
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $28 ; (
                    dc.b $c4 ; D
                    dc.b $a2 ; 
                    dc.b $04 ; 
                    dc.b $00 ; 
A_ad40              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $20 ; _
                    dc.b $05 ; <WHITE>
                    dc.b $01 ; 
                    dc.b $1c ; <RED>
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $18 ; 
                    dc.b $5f ; <arrow left>
                    dc.b $a2 ; 
                    dc.b $0d ; <enter>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_ad50              dc.b $02 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $01 ; 
                    dc.b $18 ; 
                    dc.b $48 ; h
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $54 ; t
                    dc.b $5f ; <arrow left>
                    dc.b $a2 ; 
                    dc.b $0d ; <enter>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $06 ; 
A_ad60              dc.b $01 ; 
                    dc.b $54 ; t
                    dc.b $74 ; T
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $18 ; 
                    dc.b $21 ; !
                    dc.b $00 ; 
                    dc.b $64 ; D
                    dc.b $1e ; <GREEN>
                    dc.b $2a ; *
                    dc.b $3e ; >
                    dc.b $63 ; C
                    dc.b $8c ; <f8>
                    dc.b $40 ; @
A_ad70              dc.b $10 ; 
                    dc.b $01 ; 
                    dc.b $92 ; <REVERS off>
                    dc.b $9c ; <PURPLE>
                    dc.b $64 ; D
                    dc.b $7f ; 
                    dc.b $40 ; @
                    dc.b $4a ; j
                    dc.b $09 ; <SHIFT C= on>
                    dc.b $01 ; 
                    dc.b $46 ; f
                    dc.b $50 ; p
                    dc.b $6c ; L
                    dc.b $85 ; <f1>
                    dc.b $90 ; <BLACK>
                    dc.b $64 ; D
A_ad80              dc.b $28 ; (
                    dc.b $22 ; "
                    dc.b $96 ; <LIGHT RED>
                    dc.b $a3 ; 
                    dc.b $81 ; <ORANGE>
                    dc.b $a6 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $79 ; Y
                    dc.b $20 ; _
                    dc.b $01 ; 
                    dc.b $0e ; <to lower>
                    dc.b $16 ; 
                    dc.b $99 ; <LIGHT GREEN>
                    dc.b $b7 ; 
                    dc.b $86 ; <f3>
                    dc.b $92 ; <REVERS off>
A_ad90              dc.b $18 ; 
                    dc.b $22 ; "
                    dc.b $8b ; <f6>
                    dc.b $96 ; <LIGHT RED>
                    dc.b $b7 ; 
                    dc.b $d0 ; P
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $2a ; *
                    dc.b $0d ; <enter>
                    dc.b $38 ; 8
                    dc.b $0d ; <enter>
                    dc.b $46 ; f
                    dc.b $0d ; <enter>
A_ada0              dc.b $46 ; f
                    dc.b $0d ; <enter>
                    dc.b $7e ; 
                    dc.b $0d ; <enter>
                    dc.b $8c ; <f8>
                    dc.b $0d ; <enter>
                    dc.b $9a ; <LIGHT BLUE>
                    dc.b $0d ; <enter>
                    dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $0e ; <to lower>
                    dc.b $0d ; <enter>
                    dc.b $1c ; <RED>
                    dc.b $0d ; <enter>
                    dc.b $46 ; f
                    dc.b $0d ; <enter>
A_adb0              dc.b $46 ; f
                    dc.b $0d ; <enter>
                    dc.b $7e ; 
                    dc.b $0d ; <enter>
                    dc.b $8c ; <f8>
                    dc.b $0d ; <enter>
                    dc.b $9a ; <LIGHT BLUE>
                    dc.b $0d ; <enter>
                    dc.b $80 ; 
                    dc.b $ac ; 
                    dc.b $66 ; F
                    dc.b $ad ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $ad ; 
                    dc.b $97 ; <GREY 1>
                    dc.b $ad ; 
A_adc0              dc.b $1e ; <GREEN>
                    dc.b $ad ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $af ; 
                    dc.b $30 ; 0
                    dc.b $74 ; T
                    dc.b $28 ; (
A_add0              dc.b $00 ; 
                    dc.b $25 ; %
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $07 ; 
                    dc.b $00 ; 
                    dc.b $3d ; =
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $07 ; 
                    dc.b $28 ; (
                    dc.b $3d ; =
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $14 ; <DEL>
                    dc.b $50 ; p
A_ade0              dc.b $3d ; =
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $00 ; 
                    dc.b $6f ; O
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $0a ; 
                    dc.b $2c ; ,
                    dc.b $72 ; R
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $10 ; 
                    dc.b $60 ; 
                    dc.b $71 ; Q
A_adf0              dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $09 ; <SHIFT C= on>
                    dc.b $0e ; <to lower>
                    dc.b $a6 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $7c ; 
                    dc.b $59 ; y
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $19 ; 
                    dc.b $3c ; <
                    dc.b $a4 ; 
                    dc.b $04 ; 
A_ae00              dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $0a ; 
                    dc.b $25 ; %
                    dc.b $80 ; 
                    dc.b $16 ; 
                    dc.b $03 ; 
                    dc.b $0e ; <to lower>
                    dc.b $25 ; %
                    dc.b $80 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $03 ; 
                    dc.b $32 ; 2
                    dc.b $25 ; %
                    dc.b $80 ; 
                    dc.b $16 ; 
A_ae10              dc.b $03 ; 
                    dc.b $36 ; 6
                    dc.b $25 ; %
                    dc.b $80 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $03 ; 
                    dc.b $59 ; y
                    dc.b $25 ; %
                    dc.b $80 ; 
                    dc.b $16 ; 
                    dc.b $03 ; 
                    dc.b $5d ; ]
                    dc.b $25 ; %
                    dc.b $80 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $03 ; 
A_ae20              dc.b $88 ; <f7>
                    dc.b $25 ; %
                    dc.b $80 ; 
                    dc.b $16 ; 
                    dc.b $03 ; 
                    dc.b $8c ; <f8>
                    dc.b $25 ; %
                    dc.b $80 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $06 ; 
                    dc.b $02 ; 
                    dc.b $3f ; ?
                    dc.b $80 ; 
                    dc.b $14 ; <DEL>
                    dc.b $06 ; 
                    dc.b $06 ; 
A_ae30              dc.b $3f ; ?
                    dc.b $80 ; 
                    dc.b $1c ; <RED>
                    dc.b $07 ; 
                    dc.b $0e ; <to lower>
                    dc.b $6e ; N
                    dc.b $80 ; 
                    dc.b $16 ; 
                    dc.b $07 ; 
                    dc.b $12 ; <REVERS on>
                    dc.b $6e ; N
                    dc.b $80 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $06 ; 
                    dc.b $7a ; Z
                    dc.b $74 ; T
A_ae40              dc.b $80 ; 
                    dc.b $13 ; <HOME>
                    dc.b $06 ; 
                    dc.b $7e ; 
                    dc.b $74 ; T
                    dc.b $80 ; 
                    dc.b $1b ; 
                    dc.b $04 ; 
                    dc.b $46 ; f
                    dc.b $a7 ; 
                    dc.b $80 ; 
                    dc.b $13 ; <HOME>
                    dc.b $04 ; 
                    dc.b $4a ; j
                    dc.b $a7 ; 
                    dc.b $80 ; 
A_ae50              dc.b $1b ; 
                    dc.b $33 ; 3
                    dc.b $30 ; 0
                    dc.b $72 ; R
                    dc.b $11 ; <CRSR down>
                    dc.b $20 ; _
                    dc.b $33 ; 3
                    dc.b $34 ; 4
                    dc.b $72 ; R
                    dc.b $11 ; <CRSR down>
                    dc.b $20 ; _
                    dc.b $35 ; 5
                    dc.b $44 ; d
                    dc.b $72 ; R
                    dc.b $f1 ; 
                    dc.b $20 ; _
A_ae60              dc.b $35 ; 5
                    dc.b $48 ; h
                    dc.b $72 ; R
                    dc.b $f1 ; 
                    dc.b $20 ; _
                    dc.b $1a ; 
                    dc.b $98 ; <GREY 2>
                    dc.b $25 ; %
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $1a ; 
                    dc.b $9c ; <PURPLE>
                    dc.b $25 ; %
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $1c ; <RED>
A_ae70              dc.b $98 ; <GREY 2>
                    dc.b $3d ; =
                    dc.b $1f ; <BLUE>
                    dc.b $20 ; _
                    dc.b $1c ; <RED>
                    dc.b $9c ; <PURPLE>
                    dc.b $3d ; =
                    dc.b $1f ; <BLUE>
                    dc.b $20 ; _
                    dc.b $18 ; 
                    dc.b $7d ; 
                    dc.b $59 ; y
                    dc.b $11 ; <CRSR down>
                    dc.b $20 ; _
                    dc.b $18 ; 
                    dc.b $81 ; <ORANGE>
A_ae80              dc.b $59 ; y
                    dc.b $11 ; <CRSR down>
                    dc.b $20 ; _
                    dc.b $33 ; 3
                    dc.b $94 ; <INST>
                    dc.b $71 ; Q
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $33 ; 3
                    dc.b $98 ; <GREY 2>
                    dc.b $71 ; Q
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $24 ; $
                    dc.b $94 ; <INST>
                    dc.b $a4 ; 
A_ae90              dc.b $1f ; <BLUE>
                    dc.b $20 ; _
                    dc.b $24 ; $
                    dc.b $98 ; <GREY 2>
                    dc.b $a4 ; 
                    dc.b $1f ; <BLUE>
                    dc.b $20 ; _
                    dc.b $28 ; (
                    dc.b $00 ; 
                    dc.b $c7 ; G
                    dc.b $04 ; 
                    dc.b $28 ; (
                    dc.b $00 ; 
                    dc.b $16 ; 
                    dc.b $42 ; b
                    dc.b $5a ; z
A_aea0              dc.b $3e ; >
                    dc.b $42 ; b
                    dc.b $5a ; z
                    dc.b $65 ; E
                    dc.b $42 ; b
                    dc.b $5a ; z
                    dc.b $94 ; <INST>
                    dc.b $42 ; b
                    dc.b $5a ; z
                    dc.b $0e ; <to lower>
                    dc.b $5a ; z
                    dc.b $8c ; <f8>
                    dc.b $1a ; 
                    dc.b $8c ; <f8>
                    dc.b $c3 ; C
                    dc.b $86 ; <f3>
A_aeb0              dc.b $8e ; <to upper>
                    dc.b $c1 ; A
                    dc.b $52 ; r
                    dc.b $c1 ; A
                    dc.b $e4 ; 
                    dc.b $00 ; 
                    dc.b $32 ; 2
                    dc.b $3c ; <
                    dc.b $8f ; 
                    dc.b $01 ; 
                    dc.b $35 ; 5
                    dc.b $85 ; <f1>
                    dc.b $5a ; z
                    dc.b $ff ; 
                    dc.b $18 ; 
                    dc.b $a5 ; 
A_aec0              dc.b $42 ; b
                    dc.b $00 ; 
                    dc.b $1c ; <RED>
                    dc.b $a4 ; 
                    dc.b $5a ; z
                    dc.b $ff ; 
                    dc.b $18 ; 
                    dc.b $88 ; <f7>
                    dc.b $76 ; V
                    dc.b $01 ; 
                    dc.b $33 ; 3
                    dc.b $a0 ; <_ (shift)>
                    dc.b $8e ; <to upper>
                    dc.b $00 ; 
                    dc.b $23 ; #
                    dc.b $a0 ; <_ (shift)>
A_aed0              dc.b $c1 ; A
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $5a ; z
                    dc.b $e4 ; 
                    dc.b $92 ; <REVERS off>
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $02 ; 
                    dc.b $01 ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_aee0              dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $2c ; ,
                    dc.b $4d ; m
                    dc.b $a2 ; 
                    dc.b $04 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $04 ; 
                    dc.b $01 ; 
                    dc.b $1c ; <RED>
                    dc.b $4c ; l
                    dc.b $00 ; 
                    dc.b $ff ; 
A_aef0              dc.b $72 ; R
                    dc.b $4d ; m
                    dc.b $a0 ; <_ (shift)>
                    dc.b $0a ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $ff ; 
                    dc.b $64 ; D
                    dc.b $88 ; <f7>
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $8a ; <f4>
                    dc.b $81 ; <ORANGE>
A_af00              dc.b $a2 ; 
                    dc.b $0d ; <enter>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $01 ; 
                    dc.b $87 ; <f5>
                    dc.b $8b ; <f6>
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $28 ; (
                    dc.b $ef ; 
                    dc.b $a2 ; 
                    dc.b $04 ; 
A_af10              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $04 ; 
                    dc.b $04 ; 
                    dc.b $01 ; 
                    dc.b $24 ; $
                    dc.b $38 ; 8
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $80 ; 
                    dc.b $ef ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $05 ; <WHITE>
                    dc.b $00 ; 
                    dc.b $00 ; 
A_af20              dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $04 ; 
                    dc.b $ff ; 
                    dc.b $57 ; w
                    dc.b $a0 ; <_ (shift)>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $34 ; 4
                    dc.b $b4 ; 
                    dc.b $30 ; 0
                    dc.b $64 ; D
                    dc.b $3a ; :
                    dc.b $44 ; d
                    dc.b $d3 ; S
A_af30              dc.b $f5 ; 
                    dc.b $6c ; L
                    dc.b $59 ; y
                    dc.b $20 ; _
                    dc.b $01 ; 
                    dc.b $71 ; Q
                    dc.b $78 ; X
                    dc.b $79 ; Y
                    dc.b $97 ; <GREY 1>
                    dc.b $1c ; <RED>
                    dc.b $5c ; 
                    dc.b $38 ; 8
                    dc.b $43 ; c
                    dc.b $22 ; "
                    dc.b $2e ; .
                    dc.b $7e ; 
A_af40              dc.b $99 ; <LIGHT GREEN>
                    dc.b $3c ; <
                    dc.b $2c ; ,
                    dc.b $40 ; @
                    dc.b $22 ; "
                    dc.b $42 ; b
                    dc.b $4e ; n
                    dc.b $4a ; j
                    dc.b $6d ; M
                    dc.b $44 ; d
                    dc.b $14 ; <DEL>
                    dc.b $48 ; h
                    dc.b $01 ; 
                    dc.b $4a ; j
                    dc.b $56 ; v
                    dc.b $37 ; 7
A_af50              dc.b $53 ; s
                    dc.b $78 ; X
                    dc.b $2c ; ,
                    dc.b $50 ; p
                    dc.b $22 ; "
                    dc.b $7e ; 
                    dc.b $8a ; <f4>
                    dc.b $4c ; l
                    dc.b $6b ; K
                    dc.b $94 ; <INST>
                    dc.b $14 ; <DEL>
                    dc.b $58 ; x
                    dc.b $22 ; "
                    dc.b $9a ; <LIGHT BLUE>
                    dc.b $a4 ; 
                    dc.b $33 ; 3
A_af60              dc.b $54 ; t
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $0e ; <to lower>
                    dc.b $0d ; <enter>
                    dc.b $1c ; <RED>
                    dc.b $0d ; <enter>
                    dc.b $2a ; *
                    dc.b $0d ; <enter>
                    dc.b $62 ; B
                    dc.b $0d ; <enter>
                    dc.b $7e ; 
                    dc.b $0d ; <enter>
                    dc.b $8c ; <f8>
                    dc.b $0d ; <enter>
A_af70              dc.b $9a ; <LIGHT BLUE>
                    dc.b $0d ; <enter>
                    dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $38 ; 8
                    dc.b $0d ; <enter>
                    dc.b $46 ; f
                    dc.b $0d ; <enter>
                    dc.b $62 ; B
                    dc.b $0d ; <enter>
                    dc.b $62 ; B
                    dc.b $0d ; <enter>
                    dc.b $7e ; 
                    dc.b $0d ; <enter>
                    dc.b $8c ; <f8>
                    dc.b $0d ; <enter>
A_af80              dc.b $9a ; <LIGHT BLUE>
                    dc.b $0d ; <enter>
                    dc.b $cf ; O
                    dc.b $ad ; 
                    dc.b $29 ; )
                    dc.b $af ; 
                    dc.b $9d ; <CRSR left>
                    dc.b $ae ; 
                    dc.b $b6 ; 
                    dc.b $ae ; 
                    dc.b $d3 ; S
                    dc.b $ae ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_af90              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $90 ; <BLACK>
                    dc.b $35 ; 5
                    dc.b $90 ; <BLACK>
                    dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $0e ; <to lower>
                    dc.b $0d ; <enter>
                    dc.b $1c ; <RED>
                    dc.b $0d ; <enter>
                    dc.b $2a ; *
A_afa0              dc.b $0d ; <enter>
                    dc.b $38 ; 8
                    dc.b $0d ; <enter>
                    dc.b $7e ; 
                    dc.b $0d ; <enter>
                    dc.b $8c ; <f8>
                    dc.b $0d ; <enter>
                    dc.b $9a ; <LIGHT BLUE>
                    dc.b $0d ; <enter>
                    dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $46 ; f
                    dc.b $0d ; <enter>
                    dc.b $54 ; t
                    dc.b $0d ; <enter>
                    dc.b $62 ; B
A_afb0              dc.b $0d ; <enter>
                    dc.b $70 ; P
                    dc.b $0d ; <enter>
                    dc.b $7e ; 
                    dc.b $0d ; <enter>
                    dc.b $8c ; <f8>
                    dc.b $0d ; <enter>
                    dc.b $9a ; <LIGHT BLUE>
                    dc.b $0d ; <enter>
                    dc.b $d0 ; P
                    dc.b $af ; 
                    dc.b $cb ; K
                    dc.b $b0 ; 
                    dc.b $ff ; 
                    dc.b $b0 ; 
                    dc.b $fe ; 
A_afc0              dc.b $b0 ; 
                    dc.b $15 ; 
                    dc.b $b1 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $11 ; <CRSR down>
                    dc.b $46 ; f
                    dc.b $50 ; p
                    dc.b $55 ; u
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $7d ; 
                    dc.b $40 ; @
                    dc.b $91 ; <CRSR up>
A_afd0              dc.b $25 ; %
                    dc.b $06 ; 
                    dc.b $3d ; =
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $0a ; 
                    dc.b $02 ; 
                    dc.b $59 ; y
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $0a ; 
                    dc.b $78 ; X
                    dc.b $55 ; u
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $0c ; 
A_afe0              dc.b $36 ; 6
                    dc.b $6b ; K
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $0b ; 
                    dc.b $0c ; 
                    dc.b $8a ; <f4>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $0d ; <enter>
                    dc.b $62 ; B
                    dc.b $84 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $06 ; 
                    dc.b $3e ; >
A_aff0              dc.b $99 ; <LIGHT GREEN>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $07 ; 
                    dc.b $02 ; 
                    dc.b $a4 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $06 ; 
                    dc.b $22 ; "
                    dc.b $a9 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $07 ; 
                    dc.b $56 ; v
                    dc.b $aa ; 
A_b000              dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $06 ; 
                    dc.b $7e ; 
                    dc.b $a4 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $28 ; (
                    dc.b $00 ; 
                    dc.b $c7 ; G
                    dc.b $04 ; 
                    dc.b $28 ; (
                    dc.b $03 ; 
                    dc.b $14 ; <DEL>
                    dc.b $41 ; a
                    dc.b $80 ; 
A_b010              dc.b $11 ; <CRSR down>
                    dc.b $03 ; 
                    dc.b $18 ; 
                    dc.b $41 ; a
                    dc.b $80 ; 
                    dc.b $19 ; 
                    dc.b $06 ; 
                    dc.b $10 ; 
                    dc.b $5a ; z
                    dc.b $80 ; 
                    dc.b $14 ; <DEL>
                    dc.b $06 ; 
                    dc.b $14 ; <DEL>
                    dc.b $5a ; z
                    dc.b $80 ; 
                    dc.b $1c ; <RED>
A_b020              dc.b $06 ; 
                    dc.b $78 ; X
                    dc.b $55 ; u
                    dc.b $80 ; 
                    dc.b $15 ; 
                    dc.b $06 ; 
                    dc.b $7c ; 
                    dc.b $55 ; u
                    dc.b $80 ; 
                    dc.b $1d ; <CRSR right>
                    dc.b $04 ; 
                    dc.b $2e ; .
                    dc.b $89 ; <f2>
                    dc.b $80 ; 
                    dc.b $16 ; 
                    dc.b $04 ; 
A_b030              dc.b $32 ; 2
                    dc.b $89 ; <f2>
                    dc.b $80 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $04 ; 
                    dc.b $84 ; 
                    dc.b $84 ; 
                    dc.b $80 ; 
                    dc.b $16 ; 
                    dc.b $04 ; 
                    dc.b $88 ; <f7>
                    dc.b $84 ; 
                    dc.b $80 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $04 ; 
                    dc.b $04 ; 
A_b040              dc.b $a7 ; 
                    dc.b $80 ; 
                    dc.b $13 ; <HOME>
                    dc.b $04 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $a7 ; 
                    dc.b $80 ; 
                    dc.b $1b ; 
                    dc.b $03 ; 
                    dc.b $68 ; H
                    dc.b $af ; 
                    dc.b $80 ; 
                    dc.b $11 ; <CRSR down>
                    dc.b $03 ; 
                    dc.b $6c ; L
                    dc.b $af ; 
A_b050              dc.b $80 ; 
                    dc.b $19 ; 
                    dc.b $03 ; 
                    dc.b $42 ; b
                    dc.b $25 ; %
                    dc.b $80 ; 
                    dc.b $38 ; 8
                    dc.b $03 ; 
                    dc.b $42 ; b
                    dc.b $53 ; s
                    dc.b $80 ; 
                    dc.b $38 ; 8
                    dc.b $03 ; 
                    dc.b $42 ; b
                    dc.b $81 ; <ORANGE>
                    dc.b $80 ; 
A_b060              dc.b $38 ; 8
                    dc.b $03 ; 
                    dc.b $42 ; b
                    dc.b $af ; 
                    dc.b $80 ; 
                    dc.b $38 ; 8
                    dc.b $03 ; 
                    dc.b $50 ; p
                    dc.b $25 ; %
                    dc.b $80 ; 
                    dc.b $38 ; 8
                    dc.b $03 ; 
                    dc.b $50 ; p
                    dc.b $53 ; s
                    dc.b $80 ; 
                    dc.b $38 ; 8
A_b070              dc.b $03 ; 
                    dc.b $50 ; p
                    dc.b $81 ; <ORANGE>
                    dc.b $80 ; 
                    dc.b $38 ; 8
                    dc.b $03 ; 
                    dc.b $50 ; p
                    dc.b $af ; 
                    dc.b $80 ; 
                    dc.b $38 ; 8
                    dc.b $04 ; 
                    dc.b $42 ; b
                    dc.b $23 ; #
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $04 ; 
A_b080              dc.b $42 ; b
                    dc.b $51 ; q
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $04 ; 
                    dc.b $42 ; b
                    dc.b $7f ; 
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $04 ; 
                    dc.b $42 ; b
                    dc.b $ad ; 
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $02 ; 
                    dc.b $44 ; d
A_b090              dc.b $13 ; <HOME>
                    dc.b $80 ; 
                    dc.b $3d ; =
                    dc.b $02 ; 
                    dc.b $44 ; d
                    dc.b $41 ; a
                    dc.b $80 ; 
                    dc.b $3d ; =
                    dc.b $02 ; 
                    dc.b $44 ; d
                    dc.b $6f ; O
                    dc.b $80 ; 
                    dc.b $3d ; =
                    dc.b $02 ; 
                    dc.b $44 ; d
                    dc.b $9d ; <CRSR left>
A_b0a0              dc.b $80 ; 
                    dc.b $3d ; =
                    dc.b $02 ; 
                    dc.b $4e ; n
                    dc.b $13 ; <HOME>
                    dc.b $80 ; 
                    dc.b $3d ; =
                    dc.b $02 ; 
                    dc.b $4e ; n
                    dc.b $41 ; a
                    dc.b $80 ; 
                    dc.b $3d ; =
                    dc.b $02 ; 
                    dc.b $4e ; n
                    dc.b $6f ; O
                    dc.b $80 ; 
A_b0b0              dc.b $3d ; =
                    dc.b $02 ; 
                    dc.b $4e ; n
                    dc.b $9d ; <CRSR left>
                    dc.b $80 ; 
                    dc.b $3d ; =
                    dc.b $03 ; 
                    dc.b $44 ; d
                    dc.b $18 ; 
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $03 ; 
                    dc.b $44 ; d
                    dc.b $46 ; f
                    dc.b $04 ; 
                    dc.b $40 ; @
A_b0c0              dc.b $03 ; 
                    dc.b $44 ; d
                    dc.b $74 ; T
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $03 ; 
                    dc.b $44 ; d
                    dc.b $a2 ; 
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $00 ; 
                    dc.b $1c ; <RED>
                    dc.b $2b ; +
                    dc.b $60 ; 
                    dc.b $43 ; c
                    dc.b $21 ; !
A_b0d0              dc.b $2f ; /
                    dc.b $4a ; j
                    dc.b $6b ; K
                    dc.b $02 ; 
                    dc.b $43 ; c
                    dc.b $58 ; x
                    dc.b $22 ; "
                    dc.b $06 ; 
                    dc.b $12 ; <REVERS on>
                    dc.b $63 ; C
                    dc.b $83 ; <load+run>
                    dc.b $90 ; <BLACK>
                    dc.b $44 ; d
                    dc.b $68 ; H
                    dc.b $01 ; 
                    dc.b $95 ; <BROWN>
A_b0e0              dc.b $a3 ; 
                    dc.b $63 ; C
                    dc.b $83 ; <load+run>
                    dc.b $5c ; 
                    dc.b $45 ; e
                    dc.b $70 ; P
                    dc.b $43 ; c
                    dc.b $61 ; A
                    dc.b $6f ; O
                    dc.b $62 ; B
                    dc.b $86 ; <f3>
                    dc.b $82 ; 
                    dc.b $73 ; S
                    dc.b $78 ; X
                    dc.b $01 ; 
                    dc.b $87 ; <f5>
A_b0f0              dc.b $95 ; <BROWN>
                    dc.b $92 ; <REVERS off>
                    dc.b $ad ; 
                    dc.b $5c ; 
                    dc.b $b0 ; 
                    dc.b $80 ; 
                    dc.b $01 ; 
                    dc.b $61 ; A
                    dc.b $6f ; O
                    dc.b $d1 ; Q
                    dc.b $ee ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $20 ; _
A_b100              dc.b $5a ; z
                    dc.b $76 ; V
                    dc.b $1c ; <RED>
                    dc.b $76 ; V
                    dc.b $a7 ; 
                    dc.b $84 ; 
                    dc.b $72 ; R
                    dc.b $a1 ; 
                    dc.b $3a ; :
                    dc.b $a7 ; 
                    dc.b $c6 ; F
                    dc.b $90 ; <BLACK>
                    dc.b $a1 ; 
                    dc.b $c1 ; A
                    dc.b $10 ; 
                    dc.b $c1 ; A
A_b110              dc.b $e4 ; 
                    dc.b $74 ; T
                    dc.b $c7 ; G
                    dc.b $e4 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $8c ; <f8>
                    dc.b $e4 ; 
                    dc.b $92 ; <REVERS off>
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $02 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
A_b120              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $32 ; 2
                    dc.b $65 ; E
                    dc.b $a2 ; 
                    dc.b $04 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0a ; 
                    dc.b $05 ; <WHITE>
                    dc.b $01 ; 
                    dc.b $2c ; ,
                    dc.b $46 ; f
A_b130              dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $64 ; D
                    dc.b $65 ; E
                    dc.b $a0 ; <_ (shift)>
                    dc.b $0c ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $06 ; 
                    dc.b $ff ; 
                    dc.b $5c ; 
                    dc.b $78 ; X
                    dc.b $00 ; 
                    dc.b $ff ; 
A_b140              dc.b $19 ; 
                    dc.b $81 ; <ORANGE>
                    dc.b $a2 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $14 ; <DEL>
                    dc.b $05 ; <WHITE>
                    dc.b $01 ; 
                    dc.b $0e ; <to lower>
                    dc.b $2a ; *
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $8c ; <f8>
                    dc.b $7d ; 
A_b150              dc.b $a0 ; <_ (shift)>
                    dc.b $0f ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $04 ; 
                    dc.b $ff ; 
                    dc.b $84 ; 
                    dc.b $a2 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $37 ; 7
                    dc.b $b2 ; 
                    dc.b $a2 ; 
                    dc.b $04 ; 
A_b160              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $05 ; <WHITE>
                    dc.b $01 ; 
                    dc.b $2c ; ,
                    dc.b $3a ; :
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $7d ; 
                    dc.b $ac ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $05 ; <WHITE>
                    dc.b $00 ; 
                    dc.b $00 ; 
A_b170              dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $06 ; 
                    dc.b $ff ; 
                    dc.b $6e ; N
                    dc.b $91 ; <CRSR up>
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $28 ; (
                    dc.b $ef ; 
                    dc.b $a2 ; 
                    dc.b $0f ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0a ; 
A_b180              dc.b $03 ; 
                    dc.b $01 ; 
                    dc.b $14 ; <DEL>
                    dc.b $98 ; <GREY 2>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $0e ; <to lower>
                    dc.b $0d ; <enter>
                    dc.b $1c ; <RED>
                    dc.b $0d ; <enter>
                    dc.b $2a ; *
                    dc.b $0d ; <enter>
                    dc.b $38 ; 8
                    dc.b $0d ; <enter>
A_b190              dc.b $7e ; 
                    dc.b $0d ; <enter>
                    dc.b $8c ; <f8>
                    dc.b $0d ; <enter>
                    dc.b $9a ; <LIGHT BLUE>
                    dc.b $0d ; <enter>
                    dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $46 ; f
                    dc.b $0d ; <enter>
                    dc.b $54 ; t
                    dc.b $0d ; <enter>
                    dc.b $62 ; B
                    dc.b $0d ; <enter>
                    dc.b $70 ; P
                    dc.b $0d ; <enter>
A_b1a0              dc.b $7e ; 
                    dc.b $0d ; <enter>
                    dc.b $8c ; <f8>
                    dc.b $0d ; <enter>
                    dc.b $9a ; <LIGHT BLUE>
                    dc.b $0d ; <enter>
                    dc.b $bd ; 
                    dc.b $b1 ; 
                    dc.b $6d ; M
                    dc.b $b2 ; 
                    dc.b $ae ; 
                    dc.b $b2 ; 
                    dc.b $b8 ; 
                    dc.b $b2 ; 
                    dc.b $b9 ; 
                    dc.b $b2 ; 
A_b1b0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $99 ; <LIGHT GREEN>
                    dc.b $45 ; e
                    dc.b $a0 ; <_ (shift)>
                    dc.b $22 ; "
                    dc.b $0e ; <to lower>
                    dc.b $28 ; (
A_b1c0              dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $4e ; n
                    dc.b $3e ; >
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $0a ; 
                    dc.b $02 ; 
                    dc.b $46 ; f
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $04 ; 
                    dc.b $32 ; 2
                    dc.b $46 ; f
                    dc.b $04 ; 
A_b1d0              dc.b $80 ; 
                    dc.b $04 ; 
                    dc.b $6a ; J
                    dc.b $4a ; j
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $06 ; 
                    dc.b $7e ; 
                    dc.b $47 ; g
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $07 ; 
                    dc.b $02 ; 
                    dc.b $58 ; x
                    dc.b $04 ; 
                    dc.b $80 ; 
A_b1e0              dc.b $05 ; <WHITE>
                    dc.b $56 ; v
                    dc.b $59 ; y
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $04 ; 
                    dc.b $70 ; P
                    dc.b $5d ; ]
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $3c ; <
                    dc.b $63 ; C
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $04 ; 
A_b1f0              dc.b $86 ; <f3>
                    dc.b $61 ; A
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $12 ; <REVERS on>
                    dc.b $73 ; S
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $04 ; 
                    dc.b $34 ; 4
                    dc.b $70 ; P
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $04 ; 
                    dc.b $7a ; Z
A_b200              dc.b $6f ; O
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $04 ; 
                    dc.b $28 ; (
                    dc.b $7e ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $04 ; 
                    dc.b $64 ; D
                    dc.b $7a ; Z
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $0e ; <to lower>
                    dc.b $8f ; 
A_b210              dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $34 ; 4
                    dc.b $8a ; <f4>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $04 ; 
                    dc.b $52 ; r
                    dc.b $8f ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $7a ; Z
                    dc.b $83 ; <load+run>
                    dc.b $04 ; 
A_b220              dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $6c ; L
                    dc.b $92 ; <REVERS off>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $30 ; 0
                    dc.b $9b ; <GREY 3>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $04 ; 
                    dc.b $7e ; 
                    dc.b $98 ; <GREY 2>
                    dc.b $04 ; 
                    dc.b $80 ; 
A_b230              dc.b $05 ; <WHITE>
                    dc.b $16 ; 
                    dc.b $a8 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $82 ; 
                    dc.b $a4 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $06 ; 
                    dc.b $32 ; 2
                    dc.b $b5 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
A_b240              dc.b $54 ; t
                    dc.b $b9 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $04 ; 
                    dc.b $6a ; J
                    dc.b $b0 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $28 ; (
                    dc.b $00 ; 
                    dc.b $c7 ; G
                    dc.b $04 ; 
                    dc.b $28 ; (
                    dc.b $04 ; 
                    dc.b $14 ; <DEL>
A_b250              dc.b $26 ; &
                    dc.b $80 ; 
                    dc.b $17 ; 
                    dc.b $04 ; 
                    dc.b $18 ; 
                    dc.b $26 ; &
                    dc.b $80 ; 
                    dc.b $1f ; <BLUE>
                    dc.b $04 ; 
                    dc.b $84 ; 
                    dc.b $27 ; 
                    dc.b $80 ; 
                    dc.b $16 ; 
                    dc.b $04 ; 
                    dc.b $88 ; <f7>
                    dc.b $27 ; 
A_b260              dc.b $80 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $0e ; <to lower>
                    dc.b $02 ; 
                    dc.b $57 ; w
                    dc.b $80 ; 
                    dc.b $16 ; 
                    dc.b $0e ; <to lower>
                    dc.b $06 ; 
                    dc.b $57 ; w
                    dc.b $80 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $00 ; 
                    dc.b $32 ; 2
                    dc.b $14 ; <DEL>
                    dc.b $50 ; p
A_b270              dc.b $22 ; "
                    dc.b $38 ; 8
                    dc.b $44 ; d
                    dc.b $34 ; 4
                    dc.b $53 ; s
                    dc.b $50 ; p
                    dc.b $2e ; .
                    dc.b $38 ; 8
                    dc.b $43 ; c
                    dc.b $56 ; v
                    dc.b $62 ; B
                    dc.b $50 ; p
                    dc.b $6b ; K
                    dc.b $55 ; u
                    dc.b $46 ; f
                    dc.b $88 ; <f7>
A_b280              dc.b $22 ; "
                    dc.b $5a ; z
                    dc.b $67 ; G
                    dc.b $67 ; G
                    dc.b $86 ; <f3>
                    dc.b $8e ; <to upper>
                    dc.b $4f ; o
                    dc.b $90 ; <BLACK>
                    dc.b $43 ; c
                    dc.b $96 ; <LIGHT RED>
                    dc.b $9e ; <YELLOW>
                    dc.b $6f ; O
                    dc.b $8f ; 
                    dc.b $12 ; <REVERS on>
                    dc.b $5e ; <arrow up>
                    dc.b $10 ; 
A_b290              dc.b $01 ; 
                    dc.b $16 ; 
                    dc.b $24 ; $
                    dc.b $82 ; 
                    dc.b $9c ; <PURPLE>
                    dc.b $53 ; s
                    dc.b $68 ; H
                    dc.b $98 ; <GREY 2>
                    dc.b $43 ; c
                    dc.b $58 ; x
                    dc.b $65 ; E
                    dc.b $88 ; <f7>
                    dc.b $a7 ; 
                    dc.b $8f ; 
                    dc.b $91 ; <CRSR up>
                    dc.b $a0 ; <_ (shift)>
A_b2a0              dc.b $85 ; <f1>
                    dc.b $94 ; <INST>
                    dc.b $a3 ; 
                    dc.b $b3 ; 
                    dc.b $d5 ; U
                    dc.b $1e ; <GREEN>
                    dc.b $b0 ; 
                    dc.b $a8 ; 
                    dc.b $85 ; <f1>
                    dc.b $24 ; $
                    dc.b $30 ; 0
                    dc.b $d0 ; P
                    dc.b $f0 ; 
                    dc.b $00 ; 
                    dc.b $20 ; _
                    dc.b $45 ; e
A_b2b0              dc.b $63 ; C
                    dc.b $90 ; <BLACK>
                    dc.b $45 ; e
                    dc.b $64 ; D
                    dc.b $0e ; <to lower>
                    dc.b $75 ; U
                    dc.b $e5 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $18 ; 
                    dc.b $e4 ; 
                    dc.b $97 ; <GREY 1>
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_b2c0              dc.b $ff ; 
                    dc.b $02 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $1a ; 
                    dc.b $50 ; p
                    dc.b $a2 ; 
                    dc.b $04 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0a ; 
A_b2d0              dc.b $04 ; 
                    dc.b $01 ; 
                    dc.b $19 ; 
                    dc.b $52 ; r
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $78 ; X
                    dc.b $50 ; p
                    dc.b $a0 ; <_ (shift)>
                    dc.b $0c ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $14 ; <DEL>
                    dc.b $04 ; 
                    dc.b $ff ; 
A_b2e0              dc.b $52 ; r
                    dc.b $90 ; <BLACK>
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $48 ; h
                    dc.b $8b ; <f6>
                    dc.b $a2 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $06 ; 
                    dc.b $01 ; 
                    dc.b $48 ; h
                    dc.b $55 ; u
A_b2f0              dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $80 ; 
                    dc.b $85 ; <f1>
                    dc.b $a2 ; 
                    dc.b $0f ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $06 ; 
                    dc.b $01 ; 
                    dc.b $7c ; 
                    dc.b $86 ; <f3>
                    dc.b $00 ; 
                    dc.b $ff ; 
A_b300              dc.b $8c ; <f8>
                    dc.b $c0 ; 
                    dc.b $a2 ; 
                    dc.b $04 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $05 ; <WHITE>
                    dc.b $01 ; 
                    dc.b $8a ; <f4>
                    dc.b $94 ; <INST>
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $41 ; a
                    dc.b $dd ; 
A_b310              dc.b $a2 ; 
                    dc.b $0c ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $06 ; 
                    dc.b $01 ; 
                    dc.b $3e ; >
                    dc.b $50 ; p
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $a2 ; 
                    dc.b $ef ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $0f ; 
A_b320              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $03 ; 
                    dc.b $ff ; 
                    dc.b $12 ; <REVERS on>
                    dc.b $a2 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $0e ; <to lower>
                    dc.b $0d ; <enter>
                    dc.b $1c ; <RED>
A_b330              dc.b $0d ; <enter>
                    dc.b $2a ; *
                    dc.b $0d ; <enter>
                    dc.b $70 ; P
                    dc.b $0d ; <enter>
                    dc.b $7e ; 
                    dc.b $0d ; <enter>
                    dc.b $8c ; <f8>
                    dc.b $0d ; <enter>
                    dc.b $9a ; <LIGHT BLUE>
                    dc.b $0d ; <enter>
                    dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $38 ; 8
                    dc.b $0d ; <enter>
                    dc.b $46 ; f
A_b340              dc.b $0d ; <enter>
                    dc.b $70 ; P
                    dc.b $0d ; <enter>
                    dc.b $70 ; P
                    dc.b $0d ; <enter>
                    dc.b $7e ; 
                    dc.b $0d ; <enter>
                    dc.b $8c ; <f8>
                    dc.b $0d ; <enter>
                    dc.b $9a ; <LIGHT BLUE>
                    dc.b $0d ; <enter>
                    dc.b $62 ; B
                    dc.b $b3 ; 
                    dc.b $ab ; 
                    dc.b $b4 ; 
                    dc.b $aa ; 
A_b350              dc.b $b4 ; 
                    dc.b $85 ; <f1>
                    dc.b $b4 ; 
                    dc.b $e4 ; 
                    dc.b $b4 ; 
                    dc.b $3b ; ;
                    dc.b $b5 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $84 ; 
A_b360              dc.b $50 ; p
                    dc.b $9e ; <YELLOW>
                    dc.b $36 ; 6
                    dc.b $48 ; h
                    dc.b $2c ; ,
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $36 ; 6
                    dc.b $4c ; l
                    dc.b $2c ; ,
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $36 ; 6
                    dc.b $12 ; <REVERS on>
                    dc.b $2c ; ,
                    dc.b $11 ; <CRSR down>
A_b370              dc.b $20 ; _
                    dc.b $36 ; 6
                    dc.b $16 ; 
                    dc.b $2c ; ,
                    dc.b $11 ; <CRSR down>
                    dc.b $20 ; _
                    dc.b $24 ; $
                    dc.b $24 ; $
                    dc.b $2c ; ,
                    dc.b $11 ; <CRSR down>
                    dc.b $20 ; _
                    dc.b $24 ; $
                    dc.b $28 ; (
                    dc.b $2c ; ,
                    dc.b $11 ; <CRSR down>
                    dc.b $20 ; _
A_b380              dc.b $12 ; <REVERS on>
                    dc.b $36 ; 6
                    dc.b $2c ; ,
                    dc.b $11 ; <CRSR down>
                    dc.b $20 ; _
                    dc.b $12 ; <REVERS on>
                    dc.b $3a ; :
                    dc.b $2c ; ,
                    dc.b $11 ; <CRSR down>
                    dc.b $20 ; _
                    dc.b $12 ; <REVERS on>
                    dc.b $5a ; z
                    dc.b $2c ; ,
                    dc.b $1f ; <BLUE>
                    dc.b $20 ; _
                    dc.b $12 ; <REVERS on>
A_b390              dc.b $5e ; <arrow up>
                    dc.b $2c ; ,
                    dc.b $1f ; <BLUE>
                    dc.b $20 ; _
                    dc.b $24 ; $
                    dc.b $6c ; L
                    dc.b $2c ; ,
                    dc.b $1f ; <BLUE>
                    dc.b $20 ; _
                    dc.b $24 ; $
                    dc.b $70 ; P
                    dc.b $2c ; ,
                    dc.b $1f ; <BLUE>
                    dc.b $20 ; _
                    dc.b $36 ; 6
                    dc.b $7e ; 
A_b3a0              dc.b $2c ; ,
                    dc.b $1f ; <BLUE>
                    dc.b $20 ; _
                    dc.b $36 ; 6
                    dc.b $82 ; 
                    dc.b $2c ; ,
                    dc.b $1f ; <BLUE>
                    dc.b $20 ; _
                    dc.b $25 ; %
                    dc.b $02 ; 
                    dc.b $2c ; ,
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $48 ; h
                    dc.b $3e ; >
A_b3b0              dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $48 ; h
                    dc.b $50 ; p
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $04 ; 
                    dc.b $44 ; d
                    dc.b $62 ; B
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $02 ; 
                    dc.b $36 ; 6
                    dc.b $04 ; 
A_b3c0              dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $02 ; 
                    dc.b $41 ; a
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $02 ; 
                    dc.b $4c ; l
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $02 ; 
                    dc.b $57 ; w
                    dc.b $04 ; 
                    dc.b $80 ; 
A_b3d0              dc.b $04 ; 
                    dc.b $02 ; 
                    dc.b $63 ; C
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $5e ; <arrow up>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $22 ; "
                    dc.b $6b ; K
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
A_b3e0              dc.b $12 ; <REVERS on>
                    dc.b $77 ; W
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $36 ; 6
                    dc.b $73 ; S
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $02 ; 
                    dc.b $83 ; <load+run>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $2e ; .
A_b3f0              dc.b $81 ; <ORANGE>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $48 ; h
                    dc.b $84 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $02 ; 
                    dc.b $8f ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $20 ; _
                    dc.b $90 ; <BLACK>
A_b400              dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $4a ; j
                    dc.b $8f ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $0c ; 
                    dc.b $9a ; <LIGHT BLUE>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $4a ; j
                    dc.b $9b ; <GREY 3>
                    dc.b $04 ; 
A_b410              dc.b $80 ; 
                    dc.b $04 ; 
                    dc.b $24 ; $
                    dc.b $a6 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $3a ; :
                    dc.b $a8 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $0c ; 
                    dc.b $af ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
A_b420              dc.b $02 ; 
                    dc.b $24 ; $
                    dc.b $b3 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $46 ; f
                    dc.b $b3 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $36 ; 6
                    dc.b $bc ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
A_b430              dc.b $96 ; <LIGHT RED>
                    dc.b $36 ; 6
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $8e ; <to upper>
                    dc.b $49 ; i
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $8c ; <f8>
                    dc.b $56 ; v
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $8c ; <f8>
A_b440              dc.b $60 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $8e ; <to upper>
                    dc.b $6e ; N
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $7e ; 
                    dc.b $78 ; X
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $8a ; <f4>
                    dc.b $84 ; 
A_b450              dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $92 ; <REVERS off>
                    dc.b $91 ; <CRSR up>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $86 ; <f3>
                    dc.b $9e ; <YELLOW>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $62 ; B
                    dc.b $a2 ; 
                    dc.b $04 ; 
A_b460              dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $76 ; V
                    dc.b $a8 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $8e ; <to upper>
                    dc.b $ac ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $82 ; 
                    dc.b $b9 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
A_b470              dc.b $02 ; 
                    dc.b $84 ; 
                    dc.b $40 ; @
                    dc.b $04 ; 
                    dc.b $48 ; h
                    dc.b $03 ; 
                    dc.b $58 ; x
                    dc.b $6c ; L
                    dc.b $04 ; 
                    dc.b $48 ; h
                    dc.b $03 ; 
                    dc.b $50 ; p
                    dc.b $ba ; 
                    dc.b $04 ; 
                    dc.b $48 ; h
                    dc.b $28 ; (
A_b480              dc.b $00 ; 
                    dc.b $c7 ; G
                    dc.b $04 ; 
                    dc.b $28 ; (
                    dc.b $00 ; 
                    dc.b $12 ; <REVERS on>
                    dc.b $54 ; t
                    dc.b $49 ; i
                    dc.b $00 ; 
                    dc.b $12 ; <REVERS on>
                    dc.b $54 ; t
                    dc.b $5b ; [
                    dc.b $00 ; 
                    dc.b $12 ; <REVERS on>
                    dc.b $54 ; t
                    dc.b $6d ; M
A_b490              dc.b $00 ; 
                    dc.b $36 ; 6
                    dc.b $1e ; <GREEN>
                    dc.b $49 ; i
                    dc.b $01 ; 
                    dc.b $24 ; $
                    dc.b $30 ; 0
                    dc.b $49 ; i
                    dc.b $01 ; 
                    dc.b $12 ; <REVERS on>
                    dc.b $42 ; b
                    dc.b $49 ; i
                    dc.b $01 ; 
                    dc.b $12 ; <REVERS on>
                    dc.b $66 ; F
                    dc.b $49 ; i
A_b4a0              dc.b $ff ; 
                    dc.b $24 ; $
                    dc.b $78 ; X
                    dc.b $49 ; i
                    dc.b $ff ; 
                    dc.b $36 ; 6
                    dc.b $8a ; <f4>
                    dc.b $49 ; i
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $28 ; (
                    dc.b $1a ; 
                    dc.b $40 ; @
                    dc.b $22 ; "
                    dc.b $2d ; -
A_b4b0              dc.b $3a ; :
                    dc.b $39 ; 9
                    dc.b $5b ; [
                    dc.b $48 ; h
                    dc.b $1a ; 
                    dc.b $a8 ; 
                    dc.b $85 ; <f1>
                    dc.b $4d ; m
                    dc.b $5b ; [
                    dc.b $39 ; 9
                    dc.b $5b ; [
                    dc.b $60 ; 
                    dc.b $1a ; 
                    dc.b $b8 ; 
                    dc.b $43 ; c
                    dc.b $66 ; F
A_b4c0              dc.b $72 ; R
                    dc.b $39 ; 9
                    dc.b $5b ; [
                    dc.b $10 ; 
                    dc.b $48 ; h
                    dc.b $a0 ; <_ (shift)>
                    dc.b $85 ; <f1>
                    dc.b $16 ; 
                    dc.b $22 ; "
                    dc.b $6a ; J
                    dc.b $89 ; <f2>
                    dc.b $74 ; T
                    dc.b $44 ; d
                    dc.b $c0 ; 
                    dc.b $85 ; <f1>
                    dc.b $7a ; Z
A_b4d0              dc.b $86 ; <f3>
                    dc.b $61 ; A
                    dc.b $86 ; <f3>
                    dc.b $2c ; ,
                    dc.b $88 ; <f7>
                    dc.b $b0 ; 
                    dc.b $22 ; "
                    dc.b $32 ; 2
                    dc.b $3c ; <
                    dc.b $a8 ; 
                    dc.b $c7 ; G
                    dc.b $02 ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $88 ; <f7>
                    dc.b $22 ; "
                    dc.b $08 ; <SHIFT C= off>
A_b4e0              dc.b $12 ; <REVERS on>
                    dc.b $c0 ; 
                    dc.b $e0 ; <_ (shift)>
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $0e ; <to lower>
                    dc.b $e4 ; 
                    dc.b $97 ; <GREY 1>
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $02 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $00 ; 
A_b4f0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $18 ; 
                    dc.b $54 ; t
                    dc.b $a2 ; 
                    dc.b $03 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $28 ; (
                    dc.b $04 ; 
                    dc.b $01 ; 
                    dc.b $10 ; 
                    dc.b $4a ; j
                    dc.b $00 ; 
A_b500              dc.b $ff ; 
                    dc.b $78 ; X
                    dc.b $54 ; t
                    dc.b $a0 ; <_ (shift)>
                    dc.b $04 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $14 ; <DEL>
                    dc.b $04 ; 
                    dc.b $ff ; 
                    dc.b $5c ; 
                    dc.b $94 ; <INST>
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $10 ; 
A_b510              dc.b $8b ; <f6>
                    dc.b $a0 ; <_ (shift)>
                    dc.b $05 ; <WHITE>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $c8 ; H
                    dc.b $06 ; 
                    dc.b $ff ; 
                    dc.b $0e ; <to lower>
                    dc.b $14 ; <DEL>
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $1e ; <GREEN>
                    dc.b $ef ; 
                    dc.b $a2 ; 
A_b520              dc.b $08 ; <SHIFT C= off>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0a ; 
                    dc.b $03 ; 
                    dc.b $01 ; 
                    dc.b $18 ; 
                    dc.b $5c ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $82 ; 
                    dc.b $ef ; 
                    dc.b $a2 ; 
                    dc.b $04 ; 
                    dc.b $00 ; 
A_b530              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $04 ; 
                    dc.b $01 ; 
                    dc.b $3e ; >
                    dc.b $9c ; <PURPLE>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $40 ; @
                    dc.b $03 ; 
                    dc.b $03 ; 
                    dc.b $06 ; 
                    dc.b $01 ; 
A_b540              dc.b $84 ; 
                    dc.b $94 ; <INST>
                    dc.b $84 ; 
                    dc.b $02 ; 
                    dc.b $6c ; L
                    dc.b $03 ; 
                    dc.b $01 ; 
                    dc.b $0c ; 
                    dc.b $01 ; 
                    dc.b $58 ; x
                    dc.b $7c ; 
                    dc.b $58 ; x
                    dc.b $03 ; 
                    dc.b $ba ; 
                    dc.b $01 ; 
                    dc.b $00 ; 
A_b550              dc.b $0c ; 
                    dc.b $01 ; 
                    dc.b $50 ; p
                    dc.b $74 ; T
                    dc.b $50 ; p
                    dc.b $03 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $0e ; <to lower>
                    dc.b $0d ; <enter>
                    dc.b $1c ; <RED>
                    dc.b $0d ; <enter>
                    dc.b $70 ; P
                    dc.b $0d ; <enter>
                    dc.b $70 ; P
A_b560              dc.b $0d ; <enter>
                    dc.b $7e ; 
                    dc.b $0d ; <enter>
                    dc.b $8c ; <f8>
                    dc.b $0d ; <enter>
                    dc.b $9a ; <LIGHT BLUE>
                    dc.b $0d ; <enter>
                    dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $2a ; *
                    dc.b $0d ; <enter>
                    dc.b $38 ; 8
                    dc.b $0d ; <enter>
                    dc.b $70 ; P
                    dc.b $0d ; <enter>
                    dc.b $70 ; P
A_b570              dc.b $0d ; <enter>
                    dc.b $7e ; 
                    dc.b $0d ; <enter>
                    dc.b $8c ; <f8>
                    dc.b $0d ; <enter>
                    dc.b $9a ; <LIGHT BLUE>
                    dc.b $0d ; <enter>
                    dc.b $8e ; <to upper>
                    dc.b $b5 ; 
                    dc.b $3e ; >
                    dc.b $b6 ; 
                    dc.b $77 ; W
                    dc.b $b6 ; 
                    dc.b $7e ; 
                    dc.b $b6 ; 
                    dc.b $89 ; <f2>
A_b580              dc.b $b6 ; 
                    dc.b $7f ; 
                    dc.b $b6 ; 
                    dc.b $d1 ; Q
                    dc.b $b6 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $53 ; s
                    dc.b $55 ; u
                    dc.b $70 ; P
                    dc.b $06 ; 
                    dc.b $04 ; 
A_b590              dc.b $26 ; &
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $3e ; >
                    dc.b $26 ; &
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $52 ; r
                    dc.b $2d ; -
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $04 ; 
                    dc.b $66 ; F
                    dc.b $26 ; &
A_b5a0              dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $06 ; 
                    dc.b $86 ; <f3>
                    dc.b $26 ; &
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $04 ; 
                    dc.b $0e ; <to lower>
                    dc.b $52 ; r
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $3b ; ;
                    dc.b $44 ; d
                    dc.b $04 ; 
A_b5b0              dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $54 ; t
                    dc.b $49 ; i
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $66 ; F
                    dc.b $3d ; =
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $8a ; <f4>
                    dc.b $39 ; 9
                    dc.b $04 ; 
                    dc.b $80 ; 
A_b5c0              dc.b $02 ; 
                    dc.b $52 ; r
                    dc.b $58 ; x
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $62 ; B
                    dc.b $58 ; x
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $50 ; p
                    dc.b $67 ; G
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
A_b5d0              dc.b $6c ; L
                    dc.b $67 ; G
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $04 ; 
                    dc.b $48 ; h
                    dc.b $76 ; V
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $66 ; F
                    dc.b $78 ; X
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $82 ; 
A_b5e0              dc.b $7d ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $02 ; 
                    dc.b $b9 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $02 ; 
                    dc.b $ad ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $10 ; 
                    dc.b $a2 ; 
A_b5f0              dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $92 ; <REVERS off>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $32 ; 2
                    dc.b $85 ; <f1>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $52 ; r
                    dc.b $94 ; <INST>
                    dc.b $04 ; 
A_b600              dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $6c ; L
                    dc.b $94 ; <INST>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $86 ; <f3>
                    dc.b $a2 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $96 ; <LIGHT RED>
                    dc.b $ad ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
A_b610              dc.b $02 ; 
                    dc.b $96 ; <LIGHT RED>
                    dc.b $b9 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $10 ; 
                    dc.b $2a ; *
                    dc.b $80 ; 
                    dc.b $11 ; <CRSR down>
                    dc.b $05 ; <WHITE>
                    dc.b $14 ; <DEL>
                    dc.b $2a ; *
                    dc.b $80 ; 
                    dc.b $19 ; 
                    dc.b $08 ; <SHIFT C= off>
A_b620              dc.b $8c ; <f8>
                    dc.b $3d ; =
                    dc.b $80 ; 
                    dc.b $12 ; <REVERS on>
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $90 ; <BLACK>
                    dc.b $3d ; =
                    dc.b $80 ; 
                    dc.b $1a ; 
                    dc.b $04 ; 
                    dc.b $12 ; <REVERS on>
                    dc.b $a8 ; 
                    dc.b $80 ; 
                    dc.b $38 ; 8
                    dc.b $04 ; 
                    dc.b $8c ; <f8>
A_b630              dc.b $a8 ; 
                    dc.b $80 ; 
                    dc.b $38 ; 8
                    dc.b $02 ; 
                    dc.b $1c ; <RED>
                    dc.b $60 ; 
                    dc.b $04 ; 
                    dc.b $48 ; h
                    dc.b $28 ; (
                    dc.b $00 ; 
                    dc.b $c7 ; G
                    dc.b $04 ; 
                    dc.b $28 ; (
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $14 ; <DEL>
A_b640              dc.b $88 ; <f7>
                    dc.b $22 ; "
                    dc.b $0e ; <to lower>
                    dc.b $18 ; 
                    dc.b $34 ; 4
                    dc.b $54 ; t
                    dc.b $78 ; X
                    dc.b $14 ; <DEL>
                    dc.b $48 ; h
                    dc.b $01 ; 
                    dc.b $7e ; 
                    dc.b $88 ; <f7>
                    dc.b $38 ; 8
                    dc.b $54 ; t
                    dc.b $1a ; 
                    dc.b $3c ; <
A_b650              dc.b $20 ; _
                    dc.b $01 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $28 ; (
                    dc.b $5c ; 
                    dc.b $7a ; Z
                    dc.b $3c ; <
                    dc.b $30 ; 0
                    dc.b $b0 ; 
                    dc.b $43 ; c
                    dc.b $42 ; b
                    dc.b $4e ; n
                    dc.b $52 ; r
                    dc.b $6e ; N
                    dc.b $0c ; 
                    dc.b $78 ; X
A_b660              dc.b $50 ; p
                    dc.b $22 ; "
                    dc.b $11 ; <CRSR down>
                    dc.b $1e ; <GREEN>
                    dc.b $95 ; <BROWN>
                    dc.b $b6 ; 
                    dc.b $74 ; T
                    dc.b $82 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $01 ; 
                    dc.b $79 ; Y
                    dc.b $86 ; <f3>
                    dc.b $a5 ; 
                    dc.b $be ; 
                    dc.b $84 ; 
                    dc.b $8c ; <f8>
A_b670              dc.b $38 ; 8
                    dc.b $43 ; c
                    dc.b $89 ; <f2>
                    dc.b $96 ; <LIGHT RED>
                    dc.b $ae ; 
                    dc.b $be ; 
                    dc.b $00 ; 
                    dc.b $1c ; <RED>
                    dc.b $43 ; c
                    dc.b $6f ; O
                    dc.b $98 ; <GREY 2>
                    dc.b $56 ; v
                    dc.b $9a ; <LIGHT BLUE>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $60 ; 
A_b680              dc.b $03 ; 
                    dc.b $02 ; 
                    dc.b $1b ; 
                    dc.b $01 ; 
                    dc.b $1c ; <RED>
                    dc.b $80 ; 
                    dc.b $1c ; <RED>
                    dc.b $02 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $14 ; <DEL>
                    dc.b $e4 ; 
                    dc.b $97 ; <GREY 1>
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_b690              dc.b $ff ; 
                    dc.b $02 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $10 ; 
                    dc.b $4e ; n
                    dc.b $a2 ; 
                    dc.b $04 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $02 ; 
A_b6a0              dc.b $06 ; 
                    dc.b $01 ; 
                    dc.b $10 ; 
                    dc.b $22 ; "
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $92 ; <REVERS off>
                    dc.b $4e ; n
                    dc.b $a2 ; 
                    dc.b $03 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $01 ; 
A_b6b0              dc.b $92 ; <REVERS off>
                    dc.b $a4 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $3e ; >
                    dc.b $ad ; 
                    dc.b $a2 ; 
                    dc.b $0c ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $04 ; 
                    dc.b $01 ; 
                    dc.b $3e ; >
                    dc.b $44 ; d
A_b6c0              dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $a1 ; 
                    dc.b $d5 ; U
                    dc.b $a2 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $04 ; 
                    dc.b $06 ; 
                    dc.b $01 ; 
                    dc.b $a2 ; 
                    dc.b $a4 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_b6d0              dc.b $00 ; 
                    dc.b $38 ; 8
                    dc.b $aa ; 
                    dc.b $20 ; _
                    dc.b $40 ; @
                    dc.b $aa ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $48 ; h
                    dc.b $aa ; 
                    dc.b $70 ; P
                    dc.b $50 ; p
                    dc.b $aa ; 
                    dc.b $38 ; 8
                    dc.b $58 ; x
                    dc.b $aa ; 
                    dc.b $28 ; (
A_b6e0              dc.b $60 ; 
                    dc.b $aa ; 
                    dc.b $90 ; <BLACK>
                    dc.b $24 ; $
                    dc.b $b4 ; 
                    dc.b $90 ; <BLACK>
                    dc.b $2c ; ,
                    dc.b $b4 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $34 ; 4
                    dc.b $b4 ; 
                    dc.b $20 ; _
                    dc.b $3c ; <
                    dc.b $b4 ; 
                    dc.b $48 ; h
                    dc.b $44 ; d
A_b6f0              dc.b $b4 ; 
                    dc.b $78 ; X
                    dc.b $4c ; l
                    dc.b $b4 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $54 ; t
                    dc.b $b4 ; 
                    dc.b $18 ; 
                    dc.b $5c ; 
                    dc.b $b4 ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $64 ; D
                    dc.b $b4 ; 
                    dc.b $48 ; h
                    dc.b $6c ; L
                    dc.b $b4 ; 
A_b700              dc.b $b0 ; 
                    dc.b $74 ; T
                    dc.b $b4 ; 
                    dc.b $28 ; (
                    dc.b $3c ; <
                    dc.b $be ; 
                    dc.b $b8 ; 
                    dc.b $44 ; d
                    dc.b $be ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $4c ; l
                    dc.b $be ; 
                    dc.b $98 ; <GREY 2>
                    dc.b $54 ; t
                    dc.b $be ; 
                    dc.b $a0 ; <_ (shift)>
A_b710              dc.b $5c ; 
                    dc.b $be ; 
                    dc.b $28 ; (
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $0e ; <to lower>
                    dc.b $0d ; <enter>
                    dc.b $70 ; P
                    dc.b $0d ; <enter>
                    dc.b $70 ; P
                    dc.b $0d ; <enter>
                    dc.b $70 ; P
                    dc.b $0d ; <enter>
                    dc.b $7e ; 
                    dc.b $0d ; <enter>
A_b720              dc.b $8c ; <f8>
                    dc.b $0d ; <enter>
                    dc.b $9a ; <LIGHT BLUE>
                    dc.b $0d ; <enter>
                    dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $1c ; <RED>
                    dc.b $0d ; <enter>
                    dc.b $2a ; *
                    dc.b $0d ; <enter>
                    dc.b $38 ; 8
                    dc.b $0d ; <enter>
                    dc.b $70 ; P
                    dc.b $0d ; <enter>
                    dc.b $7e ; 
                    dc.b $0d ; <enter>
A_b730              dc.b $8c ; <f8>
                    dc.b $0d ; <enter>
                    dc.b $9a ; <LIGHT BLUE>
                    dc.b $0d ; <enter>
                    dc.b $4b ; k
                    dc.b $b7 ; 
                    dc.b $a5 ; 
                    dc.b $b8 ; 
                    dc.b $03 ; 
                    dc.b $b9 ; 
                    dc.b $de ; 
                    dc.b $b8 ; 
                    dc.b $04 ; 
                    dc.b $b9 ; 
                    dc.b $4c ; l
                    dc.b $b9 ; 
A_b740              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $0e ; <to lower>
                    dc.b $18 ; 
                    dc.b $1d ; <CRSR right>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $5a ; z
                    dc.b $65 ; E
                    dc.b $78 ; X
                    dc.b $07 ; 
                    dc.b $06 ; 
                    dc.b $3d ; =
                    dc.b $04 ; 
                    dc.b $80 ; 
A_b750              dc.b $07 ; 
                    dc.b $02 ; 
                    dc.b $6b ; K
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $07 ; 
                    dc.b $06 ; 
                    dc.b $99 ; <LIGHT GREEN>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $4c ; l
                    dc.b $3e ; >
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
A_b760              dc.b $44 ; d
                    dc.b $48 ; h
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $04 ; 
                    dc.b $52 ; r
                    dc.b $58 ; x
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $36 ; 6
                    dc.b $68 ; H
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $36 ; 6
A_b770              dc.b $97 ; <GREY 1>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $3a ; :
                    dc.b $b2 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $4e ; n
                    dc.b $9f ; <CYAN>
                    dc.b $14 ; <DEL>
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $03 ; 
                    dc.b $4e ; n
                    dc.b $af ; 
A_b780              dc.b $f4 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $09 ; <SHIFT C= on>
                    dc.b $7a ; Z
                    dc.b $26 ; &
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $94 ; <INST>
                    dc.b $3e ; >
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $72 ; R
                    dc.b $4c ; l
                    dc.b $04 ; 
A_b790              dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $7e ; 
                    dc.b $58 ; x
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $7e ; 
                    dc.b $68 ; H
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $94 ; <INST>
                    dc.b $64 ; D
                    dc.b $04 ; 
                    dc.b $80 ; 
A_b7a0              dc.b $02 ; 
                    dc.b $8d ; <shift return>
                    dc.b $71 ; Q
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $04 ; 
                    dc.b $68 ; H
                    dc.b $88 ; <f7>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $96 ; <LIGHT RED>
                    dc.b $80 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $04 ; 
A_b7b0              dc.b $8c ; <f8>
                    dc.b $8a ; <f4>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $04 ; 
                    dc.b $64 ; D
                    dc.b $95 ; <BROWN>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $04 ; 
                    dc.b $90 ; <BLACK>
                    dc.b $ac ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $72 ; R
A_b7c0              dc.b $b0 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $28 ; (
                    dc.b $00 ; 
                    dc.b $c7 ; G
                    dc.b $04 ; 
                    dc.b $28 ; (
                    dc.b $58 ; x
                    dc.b $0f ; 
                    dc.b $3d ; =
                    dc.b $11 ; <CRSR down>
                    dc.b $20 ; _
                    dc.b $58 ; x
                    dc.b $13 ; <HOME>
                    dc.b $3d ; =
A_b7d0              dc.b $11 ; <CRSR down>
                    dc.b $20 ; _
                    dc.b $32 ; 2
                    dc.b $8c ; <f8>
                    dc.b $26 ; &
                    dc.b $1f ; <BLUE>
                    dc.b $20 ; _
                    dc.b $32 ; 2
                    dc.b $90 ; <BLACK>
                    dc.b $26 ; &
                    dc.b $1f ; <BLUE>
                    dc.b $20 ; _
                    dc.b $32 ; 2
                    dc.b $5a ; z
                    dc.b $58 ; x
                    dc.b $11 ; <CRSR down>
A_b7e0              dc.b $20 ; _
                    dc.b $32 ; 2
                    dc.b $5e ; <arrow up>
                    dc.b $58 ; x
                    dc.b $11 ; <CRSR down>
                    dc.b $20 ; _
                    dc.b $18 ; 
                    dc.b $7c ; 
                    dc.b $26 ; &
                    dc.b $11 ; <CRSR down>
                    dc.b $20 ; _
                    dc.b $18 ; 
                    dc.b $80 ; 
                    dc.b $26 ; &
                    dc.b $11 ; <CRSR down>
                    dc.b $20 ; _
A_b7f0              dc.b $26 ; &
                    dc.b $94 ; <INST>
                    dc.b $3e ; >
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $26 ; &
                    dc.b $98 ; <GREY 2>
                    dc.b $3e ; >
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $24 ; $
                    dc.b $94 ; <INST>
                    dc.b $64 ; D
                    dc.b $1f ; <BLUE>
                    dc.b $20 ; _
                    dc.b $24 ; $
A_b800              dc.b $98 ; <GREY 2>
                    dc.b $64 ; D
                    dc.b $1f ; <BLUE>
                    dc.b $20 ; _
                    dc.b $24 ; $
                    dc.b $70 ; P
                    dc.b $88 ; <f7>
                    dc.b $11 ; <CRSR down>
                    dc.b $20 ; _
                    dc.b $24 ; $
                    dc.b $74 ; T
                    dc.b $88 ; <f7>
                    dc.b $11 ; <CRSR down>
                    dc.b $20 ; _
                    dc.b $1b ; 
                    dc.b $94 ; <INST>
A_b810              dc.b $ac ; 
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $1b ; 
                    dc.b $98 ; <GREY 2>
                    dc.b $ac ; 
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $03 ; 
                    dc.b $0a ; 
                    dc.b $25 ; %
                    dc.b $80 ; 
                    dc.b $38 ; 8
                    dc.b $03 ; 
                    dc.b $0a ; 
                    dc.b $53 ; s
A_b820              dc.b $80 ; 
                    dc.b $38 ; 8
                    dc.b $03 ; 
                    dc.b $0a ; 
                    dc.b $81 ; <ORANGE>
                    dc.b $80 ; 
                    dc.b $38 ; 8
                    dc.b $03 ; 
                    dc.b $0a ; 
                    dc.b $af ; 
                    dc.b $80 ; 
                    dc.b $38 ; 8
                    dc.b $03 ; 
                    dc.b $18 ; 
                    dc.b $25 ; %
                    dc.b $80 ; 
A_b830              dc.b $38 ; 8
                    dc.b $03 ; 
                    dc.b $18 ; 
                    dc.b $53 ; s
                    dc.b $80 ; 
                    dc.b $38 ; 8
                    dc.b $03 ; 
                    dc.b $18 ; 
                    dc.b $81 ; <ORANGE>
                    dc.b $80 ; 
                    dc.b $38 ; 8
                    dc.b $03 ; 
                    dc.b $18 ; 
                    dc.b $af ; 
                    dc.b $80 ; 
                    dc.b $38 ; 8
A_b840              dc.b $04 ; 
                    dc.b $0a ; 
                    dc.b $23 ; #
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $04 ; 
                    dc.b $0a ; 
                    dc.b $51 ; q
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $04 ; 
                    dc.b $0a ; 
                    dc.b $7f ; 
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $04 ; 
A_b850              dc.b $0a ; 
                    dc.b $ad ; 
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $02 ; 
                    dc.b $0c ; 
                    dc.b $13 ; <HOME>
                    dc.b $80 ; 
                    dc.b $3d ; =
                    dc.b $02 ; 
                    dc.b $0c ; 
                    dc.b $41 ; a
                    dc.b $80 ; 
                    dc.b $3d ; =
                    dc.b $02 ; 
                    dc.b $0c ; 
A_b860              dc.b $6f ; O
                    dc.b $80 ; 
                    dc.b $3d ; =
                    dc.b $02 ; 
                    dc.b $0c ; 
                    dc.b $9d ; <CRSR left>
                    dc.b $80 ; 
                    dc.b $3d ; =
                    dc.b $02 ; 
                    dc.b $16 ; 
                    dc.b $13 ; <HOME>
                    dc.b $80 ; 
                    dc.b $3d ; =
                    dc.b $02 ; 
                    dc.b $16 ; 
                    dc.b $41 ; a
A_b870              dc.b $80 ; 
                    dc.b $3d ; =
                    dc.b $02 ; 
                    dc.b $16 ; 
                    dc.b $6f ; O
                    dc.b $80 ; 
                    dc.b $3d ; =
                    dc.b $02 ; 
                    dc.b $16 ; 
                    dc.b $9d ; <CRSR left>
                    dc.b $80 ; 
                    dc.b $3d ; =
                    dc.b $03 ; 
                    dc.b $0c ; 
                    dc.b $18 ; 
                    dc.b $04 ; 
A_b880              dc.b $40 ; @
                    dc.b $03 ; 
                    dc.b $0c ; 
                    dc.b $46 ; f
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $03 ; 
                    dc.b $0c ; 
                    dc.b $74 ; T
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $03 ; 
                    dc.b $0c ; 
                    dc.b $a2 ; 
                    dc.b $04 ; 
                    dc.b $40 ; @
A_b890              dc.b $01 ; 
                    dc.b $1c ; <RED>
                    dc.b $31 ; 1
                    dc.b $04 ; 
                    dc.b $48 ; h
                    dc.b $01 ; 
                    dc.b $1c ; <RED>
                    dc.b $72 ; R
                    dc.b $04 ; 
                    dc.b $48 ; h
                    dc.b $01 ; 
                    dc.b $1c ; <RED>
                    dc.b $a3 ; 
                    dc.b $04 ; 
                    dc.b $48 ; h
                    dc.b $02 ; 
A_b8a0              dc.b $1c ; <RED>
                    dc.b $bc ; 
                    dc.b $04 ; 
                    dc.b $48 ; h
                    dc.b $00 ; 
                    dc.b $01 ; 
                    dc.b $54 ; t
                    dc.b $58 ; x
                    dc.b $22 ; "
                    dc.b $05 ; <WHITE>
                    dc.b $0f ; 
                    dc.b $73 ; S
                    dc.b $91 ; <CRSR up>
                    dc.b $36 ; 6
                    dc.b $4a ; j
                    dc.b $70 ; P
A_b8b0              dc.b $43 ; c
                    dc.b $3a ; :
                    dc.b $48 ; h
                    dc.b $6b ; K
                    dc.b $8a ; <f4>
                    dc.b $24 ; $
                    dc.b $84 ; 
                    dc.b $68 ; H
                    dc.b $01 ; 
                    dc.b $28 ; (
                    dc.b $36 ; 6
                    dc.b $a3 ; 
                    dc.b $c2 ; B
                    dc.b $63 ; C
                    dc.b $70 ; P
                    dc.b $78 ; X
A_b8c0              dc.b $01 ; 
                    dc.b $69 ; I
                    dc.b $75 ; U
                    dc.b $90 ; <BLACK>
                    dc.b $a9 ; 
                    dc.b $5c ; 
                    dc.b $9c ; <PURPLE>
                    dc.b $80 ; 
                    dc.b $01 ; 
                    dc.b $62 ; B
                    dc.b $6e ; N
                    dc.b $bd ; 
                    dc.b $d8 ; X
                    dc.b $80 ; 
                    dc.b $a4 ; 
                    dc.b $60 ; 
A_b8d0              dc.b $43 ; c
                    dc.b $86 ; <f3>
                    dc.b $90 ; <BLACK>
                    dc.b $c3 ; C
                    dc.b $e5 ; 
                    dc.b $54 ; t
                    dc.b $0a ; 
                    dc.b $c8 ; H
                    dc.b $b1 ; 
                    dc.b $5a ; z
                    dc.b $64 ; D
                    dc.b $28 ; (
                    dc.b $48 ; h
                    dc.b $00 ; 
                    dc.b $2b ; +
                    dc.b $1b ; 
A_b8e0              dc.b $5a ; z
                    dc.b $01 ; 
                    dc.b $2d ; -
                    dc.b $46 ; f
                    dc.b $85 ; <f1>
                    dc.b $01 ; 
                    dc.b $32 ; 2
                    dc.b $98 ; <GREY 2>
                    dc.b $43 ; c
                    dc.b $ff ; 
                    dc.b $32 ; 2
                    dc.b $66 ; F
                    dc.b $75 ; U
                    dc.b $01 ; 
                    dc.b $18 ; 
                    dc.b $88 ; <f7>
A_b8f0              dc.b $43 ; c
                    dc.b $01 ; 
                    dc.b $26 ; &
                    dc.b $a0 ; <_ (shift)>
                    dc.b $5b ; [
                    dc.b $00 ; 
                    dc.b $24 ; $
                    dc.b $a0 ; <_ (shift)>
                    dc.b $81 ; <ORANGE>
                    dc.b $ff ; 
                    dc.b $24 ; $
                    dc.b $7c ; 
                    dc.b $a5 ; 
                    dc.b $01 ; 
                    dc.b $1b ; 
                    dc.b $a0 ; <_ (shift)>
A_b900              dc.b $c9 ; I
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $0e ; <to lower>
                    dc.b $e4 ; 
                    dc.b $97 ; <GREY 1>
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $02 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $00 ; 
A_b910              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $58 ; x
                    dc.b $66 ; F
                    dc.b $a2 ; 
                    dc.b $03 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $06 ; 
                    dc.b $01 ; 
                    dc.b $58 ; x
                    dc.b $66 ; F
                    dc.b $00 ; 
A_b920              dc.b $ff ; 
                    dc.b $14 ; <DEL>
                    dc.b $c1 ; A
                    dc.b $a2 ; 
                    dc.b $04 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $01 ; 
                    dc.b $14 ; <DEL>
                    dc.b $28 ; (
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $2c ; ,
A_b930              dc.b $ef ; 
                    dc.b $a2 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $32 ; 2
                    dc.b $03 ; 
                    dc.b $01 ; 
                    dc.b $24 ; $
                    dc.b $60 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $48 ; h
                    dc.b $ef ; 
                    dc.b $a2 ; 
A_b940              dc.b $0c ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0a ; 
                    dc.b $05 ; <WHITE>
                    dc.b $01 ; 
                    dc.b $16 ; 
                    dc.b $60 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $31 ; 1
                    dc.b $02 ; 
                    dc.b $02 ; 
                    dc.b $17 ; 
A_b950              dc.b $01 ; 
                    dc.b $1c ; <RED>
                    dc.b $74 ; T
                    dc.b $1c ; <RED>
                    dc.b $01 ; 
                    dc.b $72 ; R
                    dc.b $04 ; 
                    dc.b $01 ; 
                    dc.b $07 ; 
                    dc.b $01 ; 
                    dc.b $1c ; <RED>
                    dc.b $34 ; 4
                    dc.b $1c ; <RED>
                    dc.b $01 ; 
                    dc.b $a3 ; 
                    dc.b $01 ; 
A_b960              dc.b $01 ; 
                    dc.b $07 ; 
                    dc.b $01 ; 
                    dc.b $1c ; <RED>
                    dc.b $34 ; 4
                    dc.b $1c ; <RED>
                    dc.b $01 ; 
                    dc.b $bc ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $15 ; 
                    dc.b $01 ; 
                    dc.b $1c ; <RED>
                    dc.b $68 ; H
                    dc.b $1c ; <RED>
                    dc.b $02 ; 
A_b970              dc.b $00 ; 
                    dc.b $56 ; v
                    dc.b $53 ; s
                    dc.b $58 ; x
                    dc.b $44 ; d
                    dc.b $42 ; b
                    dc.b $4c ; l
                    dc.b $d0 ; P
                    dc.b $1d ; <CRSR right>
                    dc.b $56 ; v
                    dc.b $53 ; s
                    dc.b $58 ; x
                    dc.b $54 ; t
                    dc.b $4e ; n
                    dc.b $44 ; d
                    dc.b $d0 ; P
A_b980              dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $0e ; <to lower>
                    dc.b $0d ; <enter>
                    dc.b $1c ; <RED>
                    dc.b $0d ; <enter>
                    dc.b $2a ; *
                    dc.b $0d ; <enter>
                    dc.b $38 ; 8
                    dc.b $0d ; <enter>
                    dc.b $7e ; 
                    dc.b $0d ; <enter>
                    dc.b $8c ; <f8>
                    dc.b $0d ; <enter>
                    dc.b $9a ; <LIGHT BLUE>
                    dc.b $0d ; <enter>
A_b990              dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $46 ; f
                    dc.b $0d ; <enter>
                    dc.b $70 ; P
                    dc.b $0d ; <enter>
                    dc.b $70 ; P
                    dc.b $0d ; <enter>
                    dc.b $70 ; P
                    dc.b $0d ; <enter>
                    dc.b $7e ; 
                    dc.b $0d ; <enter>
                    dc.b $8c ; <f8>
                    dc.b $0d ; <enter>
                    dc.b $9a ; <LIGHT BLUE>
                    dc.b $0d ; <enter>
A_b9a0              dc.b $b7 ; 
                    dc.b $b9 ; 
                    dc.b $da ; Z
                    dc.b $ba ; 
                    dc.b $c7 ; G
                    dc.b $ba ; 
                    dc.b $b2 ; 
                    dc.b $ba ; 
                    dc.b $0b ; 
                    dc.b $bb ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_b9b0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $61 ; A
                    dc.b $bb ; 
                    dc.b $70 ; P
                    dc.b $45 ; e
                    dc.b $b4 ; 
                    dc.b $28 ; (
                    dc.b $00 ; 
                    dc.b $c7 ; G
                    dc.b $04 ; 
                    dc.b $28 ; (
                    dc.b $26 ; &
                    dc.b $04 ; 
                    dc.b $28 ; (
                    dc.b $04 ; 
A_b9c0              dc.b $80 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $02 ; 
                    dc.b $48 ; h
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $0d ; <enter>
                    dc.b $02 ; 
                    dc.b $68 ; H
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $0d ; <enter>
                    dc.b $02 ; 
                    dc.b $7f ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
A_b9d0              dc.b $0a ; 
                    dc.b $02 ; 
                    dc.b $ae ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $0f ; 
                    dc.b $3a ; :
                    dc.b $48 ; h
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $7e ; 
                    dc.b $66 ; F
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $05 ; <WHITE>
A_b9e0              dc.b $8a ; <f4>
                    dc.b $66 ; F
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $03 ; 
                    dc.b $81 ; <ORANGE>
                    dc.b $7a ; Z
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $7e ; 
                    dc.b $a9 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $0f ; 
                    dc.b $3e ; >
A_b9f0              dc.b $c3 ; C
                    dc.b $04 ; 
                    dc.b $50 ; p
                    dc.b $02 ; 
                    dc.b $66 ; F
                    dc.b $c0 ; 
                    dc.b $09 ; <SHIFT C= on>
                    dc.b $58 ; x
                    dc.b $04 ; 
                    dc.b $64 ; D
                    dc.b $bd ; 
                    dc.b $04 ; 
                    dc.b $48 ; h
                    dc.b $03 ; 
                    dc.b $66 ; F
                    dc.b $b8 ; 
A_ba00              dc.b $04 ; 
                    dc.b $30 ; 0
                    dc.b $02 ; 
                    dc.b $66 ; F
                    dc.b $b7 ; 
                    dc.b $0a ; 
                    dc.b $60 ; 
                    dc.b $02 ; 
                    dc.b $64 ; D
                    dc.b $b6 ; 
                    dc.b $0e ; <to lower>
                    dc.b $60 ; 
                    dc.b $02 ; 
                    dc.b $66 ; F
                    dc.b $b5 ; 
                    dc.b $0a ; 
A_ba10              dc.b $60 ; 
                    dc.b $02 ; 
                    dc.b $68 ; H
                    dc.b $b4 ; 
                    dc.b $06 ; 
                    dc.b $60 ; 
                    dc.b $02 ; 
                    dc.b $6a ; J
                    dc.b $b3 ; 
                    dc.b $02 ; 
                    dc.b $60 ; 
                    dc.b $02 ; 
                    dc.b $6a ; J
                    dc.b $b2 ; 
                    dc.b $02 ; 
                    dc.b $60 ; 
A_ba20              dc.b $02 ; 
                    dc.b $68 ; H
                    dc.b $b1 ; 
                    dc.b $06 ; 
                    dc.b $60 ; 
                    dc.b $02 ; 
                    dc.b $66 ; F
                    dc.b $b0 ; 
                    dc.b $0a ; 
                    dc.b $60 ; 
                    dc.b $02 ; 
                    dc.b $64 ; D
                    dc.b $af ; 
                    dc.b $0e ; <to lower>
                    dc.b $60 ; 
                    dc.b $02 ; 
A_ba30              dc.b $66 ; F
                    dc.b $ae ; 
                    dc.b $0a ; 
                    dc.b $60 ; 
                    dc.b $02 ; 
                    dc.b $68 ; H
                    dc.b $ad ; 
                    dc.b $06 ; 
                    dc.b $60 ; 
                    dc.b $02 ; 
                    dc.b $6a ; J
                    dc.b $ac ; 
                    dc.b $02 ; 
                    dc.b $60 ; 
                    dc.b $04 ; 
                    dc.b $64 ; D
A_ba40              dc.b $a9 ; 
                    dc.b $04 ; 
                    dc.b $48 ; h
                    dc.b $04 ; 
                    dc.b $0a ; 
                    dc.b $28 ; (
                    dc.b $80 ; 
                    dc.b $15 ; 
                    dc.b $04 ; 
                    dc.b $0e ; <to lower>
                    dc.b $28 ; (
                    dc.b $80 ; 
                    dc.b $1d ; <CRSR right>
                    dc.b $04 ; 
                    dc.b $3c ; <
                    dc.b $28 ; (
A_ba50              dc.b $80 ; 
                    dc.b $15 ; 
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $28 ; (
                    dc.b $80 ; 
                    dc.b $1d ; <CRSR right>
                    dc.b $02 ; 
                    dc.b $94 ; <INST>
                    dc.b $2a ; *
                    dc.b $80 ; 
                    dc.b $13 ; <HOME>
                    dc.b $02 ; 
                    dc.b $98 ; <GREY 2>
                    dc.b $2a ; *
                    dc.b $80 ; 
A_ba60              dc.b $1b ; 
                    dc.b $04 ; 
                    dc.b $48 ; h
                    dc.b $48 ; h
                    dc.b $80 ; 
                    dc.b $15 ; 
                    dc.b $04 ; 
                    dc.b $4c ; l
                    dc.b $48 ; h
                    dc.b $80 ; 
                    dc.b $1d ; <CRSR right>
                    dc.b $05 ; <WHITE>
                    dc.b $94 ; <INST>
                    dc.b $3e ; >
                    dc.b $80 ; 
                    dc.b $12 ; <REVERS on>
A_ba70              dc.b $05 ; <WHITE>
                    dc.b $98 ; <GREY 2>
                    dc.b $3e ; >
                    dc.b $80 ; 
                    dc.b $1a ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $90 ; <BLACK>
                    dc.b $69 ; I
                    dc.b $80 ; 
                    dc.b $12 ; <REVERS on>
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $94 ; <INST>
                    dc.b $69 ; I
                    dc.b $80 ; 
                    dc.b $1a ; 
                    dc.b $20 ; _
A_ba80              dc.b $06 ; 
                    dc.b $48 ; h
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $20 ; _
                    dc.b $0a ; 
                    dc.b $48 ; h
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $2f ; /
                    dc.b $06 ; 
                    dc.b $7f ; 
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $2f ; /
                    dc.b $0a ; 
A_ba90              dc.b $7f ; 
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $20 ; _
                    dc.b $52 ; r
                    dc.b $28 ; (
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $20 ; _
                    dc.b $56 ; v
                    dc.b $28 ; (
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $1e ; <GREEN>
                    dc.b $66 ; F
                    dc.b $48 ; h
A_baa0              dc.b $11 ; <CRSR down>
                    dc.b $20 ; _
                    dc.b $1e ; <GREEN>
                    dc.b $6a ; J
                    dc.b $48 ; h
                    dc.b $11 ; <CRSR down>
                    dc.b $20 ; _
                    dc.b $14 ; <DEL>
                    dc.b $84 ; 
                    dc.b $66 ; F
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $14 ; <DEL>
                    dc.b $88 ; <f7>
                    dc.b $66 ; F
                    dc.b $10 ; 
A_bab0              dc.b $20 ; _
                    dc.b $00 ; 
                    dc.b $20 ; _
                    dc.b $12 ; <REVERS on>
                    dc.b $65 ; E
                    dc.b $00 ; 
                    dc.b $2f ; /
                    dc.b $12 ; <REVERS on>
                    dc.b $9c ; <PURPLE>
                    dc.b $00 ; 
                    dc.b $20 ; _
                    dc.b $5e ; <arrow up>
                    dc.b $45 ; e
                    dc.b $00 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $72 ; R
A_bac0              dc.b $65 ; E
                    dc.b $01 ; 
                    dc.b $14 ; <DEL>
                    dc.b $90 ; <BLACK>
                    dc.b $83 ; <load+run>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $16 ; 
                    dc.b $45 ; e
                    dc.b $65 ; E
                    dc.b $48 ; h
                    dc.b $45 ; e
                    dc.b $65 ; E
                    dc.b $a0 ; <_ (shift)>
                    dc.b $45 ; e
                    dc.b $57 ; w
A_bad0              dc.b $54 ; t
                    dc.b $65 ; E
                    dc.b $84 ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $5d ; ]
                    dc.b $83 ; <load+run>
                    dc.b $9c ; <PURPLE>
                    dc.b $83 ; <load+run>
                    dc.b $c6 ; F
                    dc.b $00 ; 
                    dc.b $24 ; $
                    dc.b $16 ; 
                    dc.b $50 ; p
                    dc.b $22 ; "
                    dc.b $2a ; *
                    dc.b $36 ; 6
A_bae0              dc.b $35 ; 5
                    dc.b $55 ; u
                    dc.b $70 ; P
                    dc.b $16 ; 
                    dc.b $88 ; <f7>
                    dc.b $22 ; "
                    dc.b $76 ; V
                    dc.b $80 ; 
                    dc.b $35 ; 5
                    dc.b $55 ; u
                    dc.b $30 ; 0
                    dc.b $4a ; j
                    dc.b $98 ; <GREY 2>
                    dc.b $43 ; c
                    dc.b $36 ; 6
                    dc.b $42 ; b
A_baf0              dc.b $6b ; K
                    dc.b $89 ; <f2>
                    dc.b $86 ; <f3>
                    dc.b $3c ; <
                    dc.b $58 ; x
                    dc.b $22 ; "
                    dc.b $8a ; <f4>
                    dc.b $95 ; <BROWN>
                    dc.b $59 ; y
                    dc.b $7c ; 
                    dc.b $01 ; 
                    dc.b $6e ; N
                    dc.b $a0 ; <_ (shift)>
                    dc.b $64 ; D
                    dc.b $05 ; <WHITE>
                    dc.b $0f ; 
A_bb00              dc.b $94 ; <INST>
                    dc.b $a9 ; 
                    dc.b $30 ; 0
                    dc.b $6e ; N
                    dc.b $48 ; h
                    dc.b $01 ; 
                    dc.b $36 ; 6
                    dc.b $42 ; b
                    dc.b $92 ; <REVERS off>
                    dc.b $9d ; <CRSR left>
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $90 ; <BLACK>
                    dc.b $c6 ; F
                    dc.b $92 ; <REVERS off>
                    dc.b $01 ; 
A_bb10              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $02 ; 
                    dc.b $01 ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $1c ; <RED>
                    dc.b $50 ; p
                    dc.b $a2 ; 
                    dc.b $03 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
A_bb20              dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $01 ; 
                    dc.b $01 ; 
                    dc.b $0f ; 
                    dc.b $5c ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $64 ; D
                    dc.b $50 ; p
                    dc.b $a0 ; <_ (shift)>
                    dc.b $04 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $02 ; 
A_bb30              dc.b $02 ; 
                    dc.b $fe ; 
                    dc.b $50 ; p
                    dc.b $a0 ; <_ (shift)>
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $1c ; <RED>
                    dc.b $90 ; <BLACK>
                    dc.b $a2 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $02 ; 
                    dc.b $01 ; 
A_bb40              dc.b $14 ; <DEL>
                    dc.b $3c ; <
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $1c ; <RED>
                    dc.b $a7 ; 
                    dc.b $a2 ; 
                    dc.b $0c ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $06 ; 
                    dc.b $03 ; 
                    dc.b $01 ; 
                    dc.b $16 ; 
                    dc.b $3c ; <
A_bb50              dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $1c ; <RED>
                    dc.b $d6 ; V
                    dc.b $a2 ; 
                    dc.b $04 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $03 ; 
                    dc.b $02 ; 
                    dc.b $03 ; 
                    dc.b $18 ; 
                    dc.b $30 ; 0
                    dc.b $00 ; 
                    dc.b $00 ; 
A_bb60              dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $2c ; ,
                    dc.b $ec ; 
                    dc.b $a7 ; 
                    dc.b $03 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
A_bb70              dc.b $37 ; 7
                    dc.b $ec ; 
                    dc.b $a7 ; 
                    dc.b $03 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $0e ; <to lower>
A_bb80              dc.b $0d ; <enter>
                    dc.b $1c ; <RED>
                    dc.b $0d ; <enter>
                    dc.b $2a ; *
                    dc.b $0d ; <enter>
                    dc.b $38 ; 8
                    dc.b $0d ; <enter>
                    dc.b $7e ; 
                    dc.b $0d ; <enter>
                    dc.b $8c ; <f8>
                    dc.b $0d ; <enter>
                    dc.b $9a ; <LIGHT BLUE>
                    dc.b $0d ; <enter>
                    dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $70 ; P
A_bb90              dc.b $0d ; <enter>
                    dc.b $62 ; B
                    dc.b $0d ; <enter>
                    dc.b $54 ; t
                    dc.b $0d ; <enter>
                    dc.b $46 ; f
                    dc.b $0d ; <enter>
                    dc.b $7e ; 
                    dc.b $0d ; <enter>
                    dc.b $8c ; <f8>
                    dc.b $0d ; <enter>
                    dc.b $9a ; <LIGHT BLUE>
                    dc.b $0d ; <enter>
                    dc.b $b4 ; 
                    dc.b $bb ; 
                    dc.b $df ; 
A_bba0              dc.b $bc ; 
                    dc.b $a1 ; 
                    dc.b $bc ; 
                    dc.b $8c ; <f8>
                    dc.b $bc ; 
                    dc.b $18 ; 
                    dc.b $bd ; 
                    dc.b $b1 ; 
                    dc.b $bc ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $8a ; <f4>
                    dc.b $bd ; 
                    dc.b $00 ; 
A_bbb0              dc.b $00 ; 
                    dc.b $43 ; c
                    dc.b $75 ; U
                    dc.b $ab ; 
                    dc.b $28 ; (
                    dc.b $00 ; 
                    dc.b $c7 ; G
                    dc.b $04 ; 
                    dc.b $28 ; (
                    dc.b $07 ; 
                    dc.b $02 ; 
                    dc.b $20 ; _
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $07 ; 
                    dc.b $02 ; 
A_bbc0              dc.b $3e ; >
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $07 ; 
                    dc.b $02 ; 
                    dc.b $5c ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $07 ; 
                    dc.b $02 ; 
                    dc.b $7a ; Z
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $07 ; 
                    dc.b $02 ; 
                    dc.b $98 ; <GREY 2>
A_bbd0              dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $07 ; 
                    dc.b $80 ; 
                    dc.b $20 ; _
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $06 ; 
                    dc.b $7e ; 
                    dc.b $3e ; >
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $06 ; 
                    dc.b $7c ; 
                    dc.b $5c ; 
                    dc.b $04 ; 
A_bbe0              dc.b $80 ; 
                    dc.b $06 ; 
                    dc.b $7e ; 
                    dc.b $7a ; Z
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $07 ; 
                    dc.b $82 ; 
                    dc.b $98 ; <GREY 2>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $9f ; <CYAN>
                    dc.b $20 ; _
                    dc.b $28 ; (
                    dc.b $10 ; 
                    dc.b $20 ; _
A_bbf0              dc.b $9f ; <CYAN>
                    dc.b $24 ; $
                    dc.b $28 ; (
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $04 ; 
                    dc.b $8c ; <f8>
                    dc.b $1e ; <GREEN>
                    dc.b $80 ; 
                    dc.b $17 ; 
                    dc.b $04 ; 
                    dc.b $90 ; <BLACK>
                    dc.b $1e ; <GREEN>
                    dc.b $80 ; 
                    dc.b $1f ; <BLUE>
                    dc.b $04 ; 
A_bc00              dc.b $89 ; <f2>
                    dc.b $3c ; <
                    dc.b $80 ; 
                    dc.b $17 ; 
                    dc.b $04 ; 
                    dc.b $8d ; <shift return>
                    dc.b $3c ; <
                    dc.b $80 ; 
                    dc.b $1f ; <BLUE>
                    dc.b $04 ; 
                    dc.b $86 ; <f3>
                    dc.b $5a ; z
                    dc.b $80 ; 
                    dc.b $17 ; 
                    dc.b $04 ; 
                    dc.b $8a ; <f4>
A_bc10              dc.b $5a ; z
                    dc.b $80 ; 
                    dc.b $1f ; <BLUE>
                    dc.b $04 ; 
                    dc.b $89 ; <f2>
                    dc.b $78 ; X
                    dc.b $80 ; 
                    dc.b $17 ; 
                    dc.b $04 ; 
                    dc.b $8d ; <shift return>
                    dc.b $78 ; X
                    dc.b $80 ; 
                    dc.b $1f ; <BLUE>
                    dc.b $06 ; 
                    dc.b $94 ; <INST>
                    dc.b $97 ; <GREY 1>
A_bc20              dc.b $80 ; 
                    dc.b $16 ; 
                    dc.b $06 ; 
                    dc.b $98 ; <GREY 2>
                    dc.b $97 ; <GREY 1>
                    dc.b $80 ; 
                    dc.b $1e ; <GREEN>
                    dc.b $01 ; 
                    dc.b $7d ; 
                    dc.b $28 ; (
                    dc.b $04 ; 
                    dc.b $48 ; h
                    dc.b $01 ; 
                    dc.b $7b ; 
                    dc.b $46 ; f
                    dc.b $04 ; 
A_bc30              dc.b $48 ; h
                    dc.b $01 ; 
                    dc.b $79 ; Y
                    dc.b $64 ; D
                    dc.b $04 ; 
                    dc.b $48 ; h
                    dc.b $01 ; 
                    dc.b $7b ; 
                    dc.b $82 ; 
                    dc.b $04 ; 
                    dc.b $48 ; h
                    dc.b $01 ; 
                    dc.b $7f ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $04 ; 
                    dc.b $48 ; h
A_bc40              dc.b $17 ; 
                    dc.b $29 ; )
                    dc.b $a5 ; 
                    dc.b $04 ; 
                    dc.b $48 ; h
                    dc.b $04 ; 
                    dc.b $29 ; )
                    dc.b $a7 ; 
                    dc.b $80 ; 
                    dc.b $38 ; 8
                    dc.b $04 ; 
                    dc.b $83 ; <load+run>
                    dc.b $a7 ; 
                    dc.b $80 ; 
                    dc.b $38 ; 8
                    dc.b $01 ; 
A_bc50              dc.b $30 ; 0
                    dc.b $a8 ; 
                    dc.b $04 ; 
                    dc.b $20 ; _
                    dc.b $01 ; 
                    dc.b $48 ; h
                    dc.b $a8 ; 
                    dc.b $04 ; 
                    dc.b $20 ; _
                    dc.b $01 ; 
                    dc.b $60 ; 
                    dc.b $a8 ; 
                    dc.b $04 ; 
                    dc.b $20 ; _
                    dc.b $01 ; 
                    dc.b $78 ; X
A_bc60              dc.b $a8 ; 
                    dc.b $04 ; 
                    dc.b $20 ; _
                    dc.b $02 ; 
                    dc.b $2e ; .
                    dc.b $a9 ; 
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $02 ; 
                    dc.b $46 ; f
                    dc.b $a9 ; 
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $02 ; 
                    dc.b $5e ; <arrow up>
                    dc.b $a9 ; 
A_bc70              dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $02 ; 
                    dc.b $76 ; V
                    dc.b $a9 ; 
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $03 ; 
                    dc.b $2c ; ,
                    dc.b $ab ; 
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $03 ; 
                    dc.b $44 ; d
                    dc.b $ab ; 
                    dc.b $04 ; 
A_bc80              dc.b $40 ; @
                    dc.b $03 ; 
                    dc.b $5c ; 
                    dc.b $ab ; 
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $03 ; 
                    dc.b $74 ; T
                    dc.b $ab ; 
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $00 ; 
                    dc.b $9f ; <CYAN>
                    dc.b $2c ; ,
                    dc.b $45 ; e
                    dc.b $00 ; 
A_bc90              dc.b $81 ; <ORANGE>
                    dc.b $2c ; ,
                    dc.b $63 ; C
                    dc.b $00 ; 
                    dc.b $63 ; C
                    dc.b $2c ; ,
                    dc.b $81 ; <ORANGE>
                    dc.b $00 ; 
                    dc.b $45 ; e
                    dc.b $2c ; ,
                    dc.b $9f ; <CYAN>
                    dc.b $00 ; 
                    dc.b $27 ; 
                    dc.b $2c ; ,
                    dc.b $bd ; 
                    dc.b $00 ; 
A_bca0              dc.b $00 ; 
                    dc.b $98 ; <GREY 2>
                    dc.b $3d ; =
                    dc.b $5b ; [
                    dc.b $95 ; <BROWN>
                    dc.b $5b ; [
                    dc.b $79 ; Y
                    dc.b $92 ; <REVERS off>
                    dc.b $79 ; Y
                    dc.b $97 ; <GREY 1>
                    dc.b $95 ; <BROWN>
                    dc.b $97 ; <GREY 1>
                    dc.b $b5 ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $b5 ; 
                    dc.b $e4 ; 
A_bcb0              dc.b $00 ; 
                    dc.b $28 ; (
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $1a ; 
                    dc.b $00 ; 
                    dc.b $1c ; <RED>
                    dc.b $7d ; 
                    dc.b $7d ; 
                    dc.b $01 ; 
                    dc.b $46 ; f
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $1a ; 
                    dc.b $00 ; 
                    dc.b $1c ; <RED>
A_bcc0              dc.b $7b ; 
                    dc.b $7b ; 
                    dc.b $01 ; 
                    dc.b $64 ; D
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $1a ; 
                    dc.b $00 ; 
                    dc.b $1c ; <RED>
                    dc.b $79 ; Y
                    dc.b $79 ; Y
                    dc.b $01 ; 
                    dc.b $82 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $1a ; 
A_bcd0              dc.b $00 ; 
                    dc.b $1c ; <RED>
                    dc.b $7b ; 
                    dc.b $7b ; 
                    dc.b $01 ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $1a ; 
                    dc.b $00 ; 
                    dc.b $1c ; <RED>
                    dc.b $7f ; 
                    dc.b $7f ; 
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $30 ; 0
A_bce0              dc.b $16 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $01 ; 
                    dc.b $34 ; 4
                    dc.b $41 ; a
                    dc.b $38 ; 8
                    dc.b $53 ; s
                    dc.b $30 ; 0
                    dc.b $34 ; 4
                    dc.b $51 ; q
                    dc.b $22 ; "
                    dc.b $34 ; 4
                    dc.b $41 ; a
                    dc.b $53 ; s
                    dc.b $73 ; S
                    dc.b $30 ; 0
A_bcf0              dc.b $52 ; r
                    dc.b $ba ; 
                    dc.b $43 ; c
                    dc.b $34 ; 4
                    dc.b $41 ; a
                    dc.b $72 ; R
                    dc.b $93 ; <CLR>
                    dc.b $30 ; 0
                    dc.b $70 ; P
                    dc.b $b0 ; 
                    dc.b $43 ; c
                    dc.b $34 ; 4
                    dc.b $41 ; a
                    dc.b $92 ; <REVERS off>
                    dc.b $b0 ; 
                    dc.b $30 ; 0
A_bd00              dc.b $8e ; <to upper>
                    dc.b $12 ; <REVERS on>
                    dc.b $01 ; 
                    dc.b $34 ; 4
                    dc.b $41 ; a
                    dc.b $b2 ; 
                    dc.b $cd ; M
                    dc.b $10 ; 
                    dc.b $ac ; 
                    dc.b $58 ; x
                    dc.b $22 ; "
                    dc.b $14 ; <DEL>
                    dc.b $20 ; _
                    dc.b $cb ; K
                    dc.b $e6 ; 
                    dc.b $86 ; <f3>
A_bd10              dc.b $ac ; 
                    dc.b $80 ; 
                    dc.b $01 ; 
                    dc.b $8a ; <f4>
                    dc.b $97 ; <GREY 1>
                    dc.b $cb ; K
                    dc.b $e6 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $a2 ; 
                    dc.b $3d ; =
                    dc.b $92 ; <REVERS off>
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
A_bd20              dc.b $02 ; 
                    dc.b $01 ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $0d ; <enter>
                    dc.b $48 ; h
                    dc.b $a2 ; 
                    dc.b $03 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $03 ; 
A_bd30              dc.b $01 ; 
                    dc.b $0d ; <enter>
                    dc.b $22 ; "
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $0d ; <enter>
                    dc.b $66 ; F
                    dc.b $a2 ; 
                    dc.b $04 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $10 ; 
                    dc.b $03 ; 
                    dc.b $01 ; 
                    dc.b $0d ; <enter>
A_bd40              dc.b $22 ; "
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $0d ; <enter>
                    dc.b $84 ; 
                    dc.b $a2 ; 
                    dc.b $06 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $18 ; 
                    dc.b $03 ; 
                    dc.b $01 ; 
                    dc.b $0d ; <enter>
                    dc.b $22 ; "
                    dc.b $00 ; 
A_bd50              dc.b $ff ; 
                    dc.b $0d ; <enter>
                    dc.b $a2 ; 
                    dc.b $a2 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0a ; 
                    dc.b $03 ; 
                    dc.b $01 ; 
                    dc.b $0d ; <enter>
                    dc.b $22 ; "
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $0d ; <enter>
A_bd60              dc.b $c0 ; 
                    dc.b $a2 ; 
                    dc.b $0c ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $1a ; 
                    dc.b $03 ; 
                    dc.b $01 ; 
                    dc.b $0d ; <enter>
                    dc.b $22 ; "
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $0e ; <to lower>
                    dc.b $ef ; 
                    dc.b $a2 ; 
A_bd70              dc.b $04 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $04 ; 
                    dc.b $01 ; 
                    dc.b $0e ; <to lower>
                    dc.b $22 ; "
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $8c ; <f8>
                    dc.b $ef ; 
                    dc.b $a2 ; 
                    dc.b $02 ; 
                    dc.b $00 ; 
A_bd80              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $04 ; 
                    dc.b $01 ; 
                    dc.b $3c ; <
                    dc.b $94 ; <INST>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $2c ; ,
                    dc.b $ac ; 
                    dc.b $7f ; 
                    dc.b $5c ; 
                    dc.b $ac ; 
                    dc.b $64 ; D
A_bd90              dc.b $74 ; T
                    dc.b $ac ; 
                    dc.b $46 ; f
                    dc.b $44 ; d
                    dc.b $ac ; 
                    dc.b $28 ; (
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $0e ; <to lower>
                    dc.b $0d ; <enter>
                    dc.b $1c ; <RED>
                    dc.b $0d ; <enter>
                    dc.b $2a ; *
A_bda0              dc.b $0d ; <enter>
                    dc.b $38 ; 8
                    dc.b $0d ; <enter>
                    dc.b $7e ; 
                    dc.b $0d ; <enter>
                    dc.b $8c ; <f8>
                    dc.b $0d ; <enter>
                    dc.b $9a ; <LIGHT BLUE>
                    dc.b $0d ; <enter>
                    dc.b $00 ; 
                    dc.b $0d ; <enter>
                    dc.b $46 ; f
                    dc.b $0d ; <enter>
                    dc.b $54 ; t
                    dc.b $0d ; <enter>
                    dc.b $70 ; P
A_bdb0              dc.b $0d ; <enter>
                    dc.b $70 ; P
                    dc.b $0d ; <enter>
                    dc.b $7e ; 
                    dc.b $0d ; <enter>
                    dc.b $8c ; <f8>
                    dc.b $0d ; <enter>
                    dc.b $9a ; <LIGHT BLUE>
                    dc.b $0d ; <enter>
                    dc.b $d0 ; P
                    dc.b $bd ; 
                    dc.b $c5 ; E
                    dc.b $be ; 
                    dc.b $a8 ; 
                    dc.b $be ; 
                    dc.b $ac ; 
A_bdc0              dc.b $be ; 
                    dc.b $26 ; &
                    dc.b $bf ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $8a ; <f4>
                    dc.b $bf ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $86 ; <f3>
                    dc.b $75 ; U
                    dc.b $87 ; <f5>
A_bdd0              dc.b $28 ; (
                    dc.b $00 ; 
                    dc.b $c7 ; G
                    dc.b $04 ; 
                    dc.b $28 ; (
                    dc.b $0b ; 
                    dc.b $02 ; 
                    dc.b $ae ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $0b ; 
                    dc.b $02 ; 
                    dc.b $97 ; <GREY 1>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $0b ; 
A_bde0              dc.b $02 ; 
                    dc.b $80 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $2c ; ,
                    dc.b $ba ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $2c ; ,
                    dc.b $a3 ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $02 ; 
                    dc.b $2c ; ,
A_bdf0              dc.b $8c ; <f8>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $07 ; 
                    dc.b $38 ; 8
                    dc.b $7b ; 
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $15 ; 
                    dc.b $00 ; 
                    dc.b $50 ; p
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $15 ; 
                    dc.b $00 ; 
                    dc.b $28 ; (
A_be00              dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $0d ; <enter>
                    dc.b $6c ; L
                    dc.b $28 ; (
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $0d ; <enter>
                    dc.b $6c ; L
                    dc.b $50 ; p
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $0d ; <enter>
                    dc.b $6c ; L
                    dc.b $7b ; 
                    dc.b $04 ; 
A_be10              dc.b $80 ; 
                    dc.b $07 ; 
                    dc.b $7a ; Z
                    dc.b $92 ; <REVERS off>
                    dc.b $04 ; 
                    dc.b $80 ; 
                    dc.b $28 ; (
                    dc.b $0e ; <to lower>
                    dc.b $28 ; (
                    dc.b $11 ; <CRSR down>
                    dc.b $20 ; _
                    dc.b $28 ; (
                    dc.b $12 ; <REVERS on>
                    dc.b $28 ; (
                    dc.b $11 ; <CRSR down>
                    dc.b $20 ; _
A_be20              dc.b $77 ; W
                    dc.b $36 ; 6
                    dc.b $50 ; p
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $77 ; W
                    dc.b $3a ; :
                    dc.b $50 ; p
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $6a ; J
                    dc.b $8c ; <f8>
                    dc.b $28 ; (
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $6a ; J
A_be30              dc.b $90 ; <BLACK>
                    dc.b $28 ; (
                    dc.b $10 ; 
                    dc.b $20 ; _
                    dc.b $06 ; 
                    dc.b $8c ; <f8>
                    dc.b $97 ; <GREY 1>
                    dc.b $80 ; 
                    dc.b $10 ; 
                    dc.b $06 ; 
                    dc.b $90 ; <BLACK>
                    dc.b $97 ; <GREY 1>
                    dc.b $80 ; 
                    dc.b $18 ; 
                    dc.b $0c ; 
                    dc.b $00 ; 
A_be40              dc.b $67 ; G
                    dc.b $80 ; 
                    dc.b $38 ; 8
                    dc.b $09 ; <SHIFT C= on>
                    dc.b $34 ; 4
                    dc.b $67 ; G
                    dc.b $80 ; 
                    dc.b $38 ; 8
                    dc.b $01 ; 
                    dc.b $0c ; 
                    dc.b $5f ; <arrow left>
                    dc.b $80 ; 
                    dc.b $38 ; 8
                    dc.b $01 ; 
                    dc.b $2a ; *
                    dc.b $5f ; <arrow left>
A_be50              dc.b $80 ; 
                    dc.b $38 ; 8
                    dc.b $0d ; <enter>
                    dc.b $02 ; 
                    dc.b $67 ; G
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $0c ; 
                    dc.b $5d ; ]
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $0f ; 
                    dc.b $40 ; @
                    dc.b $c3 ; C
                    dc.b $04 ; 
A_be60              dc.b $50 ; p
                    dc.b $04 ; 
                    dc.b $74 ; T
                    dc.b $99 ; <LIGHT GREEN>
                    dc.b $80 ; 
                    dc.b $6f ; O
                    dc.b $04 ; 
                    dc.b $78 ; X
                    dc.b $99 ; <LIGHT GREEN>
                    dc.b $80 ; 
                    dc.b $6f ; O
                    dc.b $02 ; 
                    dc.b $73 ; S
                    dc.b $a8 ; 
                    dc.b $80 ; 
                    dc.b $68 ; H
A_be70              dc.b $02 ; 
                    dc.b $79 ; Y
                    dc.b $a8 ; 
                    dc.b $80 ; 
                    dc.b $68 ; H
                    dc.b $03 ; 
                    dc.b $72 ; R
                    dc.b $ae ; 
                    dc.b $04 ; 
                    dc.b $68 ; H
                    dc.b $02 ; 
                    dc.b $77 ; W
                    dc.b $b9 ; 
                    dc.b $10 ; 
                    dc.b $60 ; 
                    dc.b $01 ; 
A_be80              dc.b $6e ; N
                    dc.b $b1 ; 
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $01 ; 
                    dc.b $7e ; 
                    dc.b $b1 ; 
                    dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $01 ; 
                    dc.b $6e ; N
                    dc.b $b1 ; 
                    dc.b $80 ; 
                    dc.b $38 ; 8
                    dc.b $01 ; 
                    dc.b $80 ; 
A_be90              dc.b $b1 ; 
                    dc.b $80 ; 
                    dc.b $38 ; 8
                    dc.b $06 ; 
                    dc.b $6e ; N
                    dc.b $b8 ; 
                    dc.b $11 ; <CRSR down>
                    dc.b $60 ; 
                    dc.b $06 ; 
                    dc.b $80 ; 
                    dc.b $b8 ; 
                    dc.b $1f ; <BLUE>
                    dc.b $60 ; 
                    dc.b $03 ; 
                    dc.b $72 ; R
                    dc.b $be ; 
A_bea0              dc.b $04 ; 
                    dc.b $40 ; @
                    dc.b $02 ; 
                    dc.b $73 ; S
                    dc.b $c0 ; 
                    dc.b $07 ; 
                    dc.b $58 ; x
                    dc.b $00 ; 
                    dc.b $98 ; <GREY 2>
                    dc.b $af ; 
                    dc.b $e4 ; 
                    dc.b $00 ; 
                    dc.b $28 ; (
                    dc.b $1a ; 
                    dc.b $45 ; e
                    dc.b $01 ; 
A_beb0              dc.b $77 ; W
                    dc.b $42 ; b
                    dc.b $6d ; M
                    dc.b $00 ; 
                    dc.b $4c ; l
                    dc.b $42 ; b
                    dc.b $98 ; <GREY 2>
                    dc.b $00 ; 
                    dc.b $6a ; J
                    dc.b $98 ; <GREY 2>
                    dc.b $45 ; e
                    dc.b $00 ; 
                    dc.b $42 ; b
                    dc.b $98 ; <GREY 2>
                    dc.b $6d ; M
                    dc.b $00 ; 
A_bec0              dc.b $17 ; 
                    dc.b $98 ; <GREY 2>
                    dc.b $98 ; <GREY 2>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $04 ; 
                    dc.b $b5 ; 
                    dc.b $d0 ; P
                    dc.b $01 ; 
                    dc.b $0b ; 
                    dc.b $14 ; <DEL>
                    dc.b $d7 ; W
                    dc.b $e5 ; 
                    dc.b $10 ; 
                    dc.b $b5 ; 
                    dc.b $d1 ; Q
A_bed0              dc.b $01 ; 
                    dc.b $17 ; 
                    dc.b $20 ; _
                    dc.b $d7 ; W
                    dc.b $e5 ; 
                    dc.b $1c ; <RED>
                    dc.b $b5 ; 
                    dc.b $d2 ; R
                    dc.b $01 ; 
                    dc.b $23 ; #
                    dc.b $2c ; ,
                    dc.b $d7 ; W
                    dc.b $e5 ; 
                    dc.b $04 ; 
                    dc.b $9d ; <CRSR left>
                    dc.b $da ; Z
A_bee0              dc.b $22 ; "
                    dc.b $09 ; <SHIFT C= on>
                    dc.b $16 ; 
                    dc.b $bf ; 
                    dc.b $db ; 
                    dc.b $10 ; 
                    dc.b $9d ; <CRSR left>
                    dc.b $d8 ; X
                    dc.b $22 ; "
                    dc.b $15 ; 
                    dc.b $22 ; "
                    dc.b $bf ; 
                    dc.b $db ; 
                    dc.b $1c ; <RED>
                    dc.b $9d ; <CRSR left>
                    dc.b $d9 ; Y
A_bef0              dc.b $22 ; "
                    dc.b $21 ; !
                    dc.b $2e ; .
                    dc.b $bf ; 
                    dc.b $db ; 
                    dc.b $04 ; 
                    dc.b $86 ; <f3>
                    dc.b $e1 ; 
                    dc.b $43 ; c
                    dc.b $09 ; <SHIFT C= on>
                    dc.b $16 ; 
                    dc.b $a8 ; 
                    dc.b $c4 ; D
                    dc.b $10 ; 
                    dc.b $86 ; <f3>
                    dc.b $e2 ; 
A_bf00              dc.b $43 ; c
                    dc.b $15 ; 
                    dc.b $22 ; "
                    dc.b $a8 ; 
                    dc.b $c4 ; D
                    dc.b $1c ; <RED>
                    dc.b $86 ; <f3>
                    dc.b $e0 ; <_ (shift)>
                    dc.b $43 ; c
                    dc.b $21 ; !
                    dc.b $2e ; .
                    dc.b $a8 ; 
                    dc.b $c4 ; D
                    dc.b $04 ; 
                    dc.b $6f ; O
                    dc.b $e0 ; <_ (shift)>
A_bf10              dc.b $43 ; c
                    dc.b $09 ; <SHIFT C= on>
                    dc.b $16 ; 
                    dc.b $91 ; <CRSR up>
                    dc.b $ad ; 
                    dc.b $10 ; 
                    dc.b $6f ; O
                    dc.b $e1 ; 
                    dc.b $43 ; c
                    dc.b $15 ; 
                    dc.b $22 ; "
                    dc.b $91 ; <CRSR up>
                    dc.b $ad ; 
                    dc.b $1c ; <RED>
                    dc.b $6f ; O
                    dc.b $e2 ; 
A_bf20              dc.b $43 ; c
                    dc.b $21 ; !
                    dc.b $2e ; .
                    dc.b $91 ; <CRSR up>
                    dc.b $ad ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $a4 ; 
                    dc.b $e4 ; 
                    dc.b $92 ; <REVERS off>
                    dc.b $01 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $02 ; 
                    dc.b $01 ; 
A_bf30              dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $0e ; <to lower>
                    dc.b $50 ; p
                    dc.b $a2 ; 
                    dc.b $03 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $04 ; 
                    dc.b $01 ; 
                    dc.b $0e ; <to lower>
A_bf40              dc.b $58 ; x
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $7a ; Z
                    dc.b $50 ; p
                    dc.b $a2 ; 
                    dc.b $02 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $04 ; 
                    dc.b $01 ; 
                    dc.b $7a ; Z
                    dc.b $a4 ; 
                    dc.b $00 ; 
A_bf50              dc.b $ff ; 
                    dc.b $32 ; 2
                    dc.b $78 ; X
                    dc.b $a2 ; 
                    dc.b $04 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $05 ; <WHITE>
                    dc.b $01 ; 
                    dc.b $0e ; <to lower>
                    dc.b $58 ; x
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $82 ; 
A_bf60              dc.b $78 ; X
                    dc.b $a2 ; 
                    dc.b $09 ; <SHIFT C= on>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $04 ; 
                    dc.b $05 ; <WHITE>
                    dc.b $01 ; 
                    dc.b $7a ; Z
                    dc.b $a4 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $46 ; f
                    dc.b $a3 ; 
                    dc.b $a2 ; 
A_bf70              dc.b $06 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0f ; 
                    dc.b $07 ; 
                    dc.b $01 ; 
                    dc.b $44 ; d
                    dc.b $59 ; y
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $a3 ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $03 ; 
                    dc.b $00 ; 
A_bf80              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $0a ; 
                    dc.b $06 ; 
                    dc.b $ff ; 
                    dc.b $7a ; Z
                    dc.b $a4 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $02 ; 
                    dc.b $10 ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $0a ; 
                    dc.b $10 ; 
                    dc.b $70 ; P
A_bf90              dc.b $12 ; <REVERS on>
                    dc.b $10 ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $22 ; "
                    dc.b $10 ; 
                    dc.b $18 ; 
                    dc.b $2a ; *
                    dc.b $10 ; 
                    dc.b $40 ; @
                    dc.b $32 ; 2
                    dc.b $10 ; 
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $3a ; :
                    dc.b $10 ; 
                    dc.b $90 ; <BLACK>
                    dc.b $42 ; b
A_bfa0              dc.b $10 ; 
                    dc.b $38 ; 8
                    dc.b $4a ; j
                    dc.b $10 ; 
                    dc.b $28 ; (
                    dc.b $7a ; Z
                    dc.b $10 ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $82 ; 
                    dc.b $10 ; 
                    dc.b $78 ; X
                    dc.b $8a ; <f4>
                    dc.b $10 ; 
                    dc.b $70 ; P
                    dc.b $92 ; <REVERS off>
                    dc.b $10 ; 
A_bfb0              dc.b $98 ; <GREY 2>
                    dc.b $48 ; h
                    dc.b $38 ; 8
                    dc.b $20 ; _
                    dc.b $50 ; p
                    dc.b $38 ; 8
                    dc.b $08 ; <SHIFT C= off>
                    dc.b $58 ; x
                    dc.b $38 ; 8
                    dc.b $70 ; P
                    dc.b $60 ; 
                    dc.b $38 ; 8
                    dc.b $38 ; 8
                    dc.b $68 ; H
                    dc.b $38 ; 8
                    dc.b $28 ; (
A_bfc0              dc.b $70 ; P
                    dc.b $38 ; 8
                    dc.b $90 ; <BLACK>
                    dc.b $10 ; 
                    dc.b $60 ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $18 ; 
                    dc.b $60 ; 
                    dc.b $70 ; P
                    dc.b $20 ; _
                    dc.b $60 ; 
                    dc.b $a0 ; <_ (shift)>
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_bfd0            Does    : 
;                   Expects : 
;                   Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_bfd0              subroutine                      ; 
                    and #$78                        ; 
                    bne B_bfd6                      ; 
                    lda #$70                        ; 
B_bfd6              sta M2Z_22                      ; 
                    rts                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_bfd9              dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
A_bfe0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
A_bff0              dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $00 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $80 ; 
                    dc.b $ff ; 
                    dc.b $ff ; 
                    dc.b $00 ; 
                    dc.b $04 ; 
                    dc.b $ff ; 
                    dc.b $7f ; 
; -------------------------------------------------------------------------------------------------------------- ;
