; -------------------------------------------------------------------------------------------------------------- ;
; Miner 2049er - External and Unresolved Addresses
; -------------------------------------------------------------------------------------------------------------- ;
C64_CINV_LO           = $0314                       ; Vector to IRQ Interrupt Routine - lo
C64_CINV_HI           = $0315                       ; Vector to IRQ Interrupt Routine - hi
C64_CBINV_LO          = $0316                       ; Vector to BRK Instruction Interrupt - lo
C64_CBINV_HI          = $0317                       ; Vector to BRK Instruction Interrupt - hi

TabPtrHiresLo         = $0a00                       ; 
TabPtrHiresHi         = $0ac8                       ; 

M2_Screen_HiRes       = $4000                       ; 
M2_Screen_HiResLen      = $2000                     ; 
M2_Screen_HiResRowLen   = $0140                     ; 
M2_ScreenGame         = $6000                       ; 
M2_ScreenGameLen        = $03e8                     ; 
M2_ScreenGameRowLen     = $28                       ; 

M2_SpritePointers     = M2_ScreenGame + $03f8       ; 
M2_SpritePointer00    = M2_ScreenGame + $03f8       ; 
M2_SpritePointer01    = M2_ScreenGame + $03f9       ; 
M2_SpritePointer02    = M2_ScreenGame + $03fa       ; 
M2_SpritePointer03    = M2_ScreenGame + $03fb       ; 
M2_SpritePointer04    = M2_ScreenGame + $03fc       ; 
M2_SpritePointer05    = M2_ScreenGame + $03fd       ; 
M2_SpritePointer06    = M2_ScreenGame + $03fe       ; 
M2_SpritePointer07    = M2_ScreenGame + $03ff       ; 

M2_ScreenStatusLine   = M2_ScreenGame               ; 
M2_ScreenStatusLives3 = M2_ScreenStatusLine + $08   ; 
M2_ScreenStatusLives2 = M2_ScreenStatusLine + $09   ; 
M2_ScreenStatusLives1 = M2_ScreenStatusLine + $0a   ; 
M2_ScreenStatusTime10 = M2_ScreenStatusLine + $14   ; 
M2_ScreenStatusTime1  = M2_ScreenStatusLine + $15   ; 

M2_ScreenLevel        = M2_ScreenGame + M2_ScreenGameRowLen ; 

M2_GameGfxStore       = M2_ScreenGame + $0400       ; 
M2_GameGfxStoreLen      = SpriteStoreLen + TileStoreLen + Unused1StoreLen + TileClearStoreLen
M2_GameSpriteStore    = M2_GameGfxStore
M2_GameTileStore      = M2_GameSpriteStore  + SpriteStoreLen
M2_GameUnused1Store   = M2_GameTileStore    + TileStoreLen
M2_GameTileClrStore   = M2_GameUnused1Store + Unused1StoreLen

M2_SavePlayerSprite   = M2_ScreenGame + $0fc0       ; 

M2_CharSet            = $7000                       ; 
M2_CharSetLen           = $0200                     ; 
M2_CharSetBig         = M2_CharSet + M2_CharSetLen  ; 

M2_ProgramStart       = $8000                       ; 
; -------------------------------------------------------------------------------------------------------------- ;
