; -------------------------------------------------------------------------------------------------------------- ;
; Miner 2049er - Work Areas
; -------------------------------------------------------------------------------------------------------------- ;
M2_WorkAreasStart       = $0c00                     ; 

M2_WaFlow               = M2_WorkAreasStart + $0000 ; flow   special data  - max $09 blocks of $09 bytes
M2_WaFlowLen            = $09                       ; length of each flow work area
M2_WaSprite             = M2_WorkAreasStart + $0100 ; sprites        data  - max $10 blocks of $0d bytes
M2_WaSpriteLen          = $0d                       ; length of each sprite work area
M2_WaSprite_BlocksMax   = $0c                       ; 
M2_WaItem               = M2_WorkAreasStart + $0200 ; object special data  - max $20 blocks of $08 bytes
M2_WaItemLen            = $08                       ; length of each item work area
M2_WaItem_BlocksMax     = $20                       ; 
; ------------------------------------------------------------------------------------------------------------- ;
; Special 
; ------------------------------------------------------------------------------------------------------------- ;
M2_Wa_SpriteSinkPosY    = M2_WorkAreasStart + $51   ; 

M2_Wa_SprColl04         = M2_WorkAreasStart + $72   ; 
M2_Wa_SprColl07         = M2_WorkAreasStart + $73   ; 
; ------------------------------------------------------------------------------------------------------------- ;
; Flow Tile Work Area Map - max $09 blocks of $09 bytes
; ------------------------------------------------------------------------------------------------------------- ;
M2_WaFlow_Ypos          = $00                       ; ypos tile to move
M2_WaFlow_Delay         = $01                       ; start delay time
M2_WaFlow_Speed         = $02                       ; speed
M2_WaFlow_SpeedSlow       = $03                     ; 
M2_WaFlow_SpeedMid        = $02                     ; 
M2_WaFlow_SpeedFast       = $01                     ; 
M2_WaFlow_03            = $03                       ; 
M2_WaFlow_Dir           = $04                       ; initial move dir $01=right $ff=left $00=stop
M2_WaFlow_DirLeft         = $ff                     ; 
M2_WaFlow_DirRight        = $01                     ; 
M2_WaFlow_DirStop         = $00                     ; 
M2_WaFlow_MaxLeft       = $05                       ; max left
M2_WaFlow_MaxRight      = $06                       ; max right
M2_WaFlow_XposStart     = $07                       ; xpos tile to move
M2_WaFlow_Length        = $08                       ; length tile to move
M2_WaFlow_LengthShort     = $01                     ; 
M2_WaFlow_LengthMid       = $02                     ; 
M2_WaFlow_LengthLong      = $03                     ; 
; ------------------------------------------------------------------------------------------------------------- ;
; Items Work Area Map - max $20 blocks of $08 bytes
; ------------------------------------------------------------------------------------------------------------- ;
M2_WaItem_PaintPosX     = $00                       ; level init
M2_WaItem_PaintPosY     = $01                       ; 
M2_WaItem_No            = $02                       ; 
M2_WaItem_NoMaskNo        = $f8                     ; mask out item number
M2_WaItem_NoMaskWa        = $03                     ; mask out sprite wa selector
M2_WaItem_NoMaskWa01        = $00                   ; select sprite wa 09
M2_WaItem_NoMaskWa02        = $01                   ; select sprite wa 0a
M2_WaItem_NoMaskWa03        = $02                   ; select sprite wa 0b
M2_WaItem_Score         = $03                       ; score to add
M2_WaItem_ScoreMask100    = $0f                     ; mask out score to add in 100th
M2_WaItem_ScoreMask1000   = $10                     ; mask out score to add in 1000th
M2_WaItem_ScoreMaskSpPtr  = $e0                     ; mask out score sprite ptr
M2_WaItem_ScoreSprt100      = $00                   ; sprite pointer part
M2_WaItem_ScoreSprt200      = $20                   ; 
M2_WaItem_ScoreSprt300      = $40                   ; 
M2_WaItem_ScoreSprt400      = $60                   ; 
M2_WaItem_ScoreSprt500      = $80                   ; 
M2_WaItem_ScoreSprt1100     = $a0                   ; 
M2_WaItem_ScoreHex100       = $01                   ; score part
M2_WaItem_ScoreHex200       = $02                   ; 
M2_WaItem_ScoreHex300       = $03                   ; 
M2_WaItem_ScoreHex400       = $04                   ; 
M2_WaItem_ScoreHex500       = $05                   ; 
M2_WaItem_ScoreHex1100      = $11                   ; 
M2_WaItem_Score100          = M2_WaItem_ScoreSprt100  + M2_WaItem_ScoreHex100
M2_WaItem_Score200          = M2_WaItem_ScoreSprt200  + M2_WaItem_ScoreHex200
M2_WaItem_Score300          = M2_WaItem_ScoreSprt300  + M2_WaItem_ScoreHex300
M2_WaItem_Score400          = M2_WaItem_ScoreSprt400  + M2_WaItem_ScoreHex400
M2_WaItem_Score500          = M2_WaItem_ScoreSprt500  + M2_WaItem_ScoreHex500
M2_WaItem_Score1100         = M2_WaItem_ScoreSprt1100 + M2_WaItem_ScoreHex1100
M2_WaItem_TouchPosXMin  = $04                       ; level play
M2_WaItem_TouchPosXMax  = $05                       ; 
M2_WaItem_TouchPosYMin  = $06                       ; 
M2_WaItem_TouchPosYMax  = $07                       ; 
; ------------------------------------------------------------------------------------------------------------- ;
; Sprite Work Area Map - max $0c blocks of $0e bytes
; ------------------------------------------------------------------------------------------------------------- ;
; Sprite Work Area - Common Part
; ------------------------------------------------------------------------------------------------------------- ;
M2_WaSprite_State       = M2_WaSprite + $00         ; 
M2_WaSprite_StateDead     = $00                     ; 
M2_WaSprite_StateScore    = $fe                     ; 
M2_WaSprite_StateAlive    = $ff                     ; 
M2_WaSprite_PosX        = M2_WaSprite + $01         ; 
M2_WaSprite_PosXMin       = $0b                     ; 
M2_WaSprite_PosXMax       = $a6                     ; 
M2_WaSprite_PosY        = M2_WaSprite + $02         ; 
M2_WaSprite_PosYMin       = $19                     ; 
M2_WaSprite_PosYMax       = $c5                     ; 
M2_WaSprite_PosYMaxSink   = $ca                     ; 
M2_WaSprite_XmitPosY1     = $e4                     ; 
M2_WaSprite_XmitPosDiff   = $2e                     ; 
M2_WaSprite_XmitPosY2     = M2_WaSprite_XmitPosY1 - M2_WaSprite_XmitPosDiff ; $b6
M2_WaSprite_XmitPosY3     = M2_WaSprite_XmitPosY2 - M2_WaSprite_XmitPosDiff ; $88
M2_WaSprite_XmitPosY4     = M2_WaSprite_XmitPosY3 - M2_WaSprite_XmitPosDiff ; $5a
M2_WaSprite_Pointer     = M2_WaSprite + $03         ; 
M2_WaSprite_Color0      = M2_WaSprite + $04         ; 
M2_WaSprite_BackPrio    = M2_WaSprite + $05         ; 
M2_WaSprite_KingSize    = M2_WaSprite + $06         ; 
M2_WaSprite_KingSizeNo    = $00                     ; 
M2_WaSprite_KingSizeYes   = $ff                     ; 
M2_WaSprite_MultiColor  = M2_WaSprite + $07         ; 
M2_WaSprite_MultiColorNo  = $00                     ; 
M2_WaSprite_MultiColorYes = $ff                     ; 
; ------------------------------------------------------------------------------------------------------------- ;
; Sprite Work Area - Enemy Part
; ------------------------------------------------------------------------------------------------------------- ;
M2_WaSprite_StepWait    = M2_WaSprite + $08         ; Enemy Special
M2_WaSprite_StepWaitScore = $32                     ; Scores show time
M2_WaSprite_Speed       = M2_WaSprite + $09         ; 
M2_WaSprite_SpeedMin      = $00                     ; 
M2_WaSprite_SpeedMax      = $01                     ; 
M2_WaSprite_MoveDir     = M2_WaSprite + $0a         ; 
M2_WaSprite_MoveDirNo     = $00                     ; 
M2_WaSprite_MoveDirRi     = $01                     ; 
M2_WaSprite_MoveDirLe     = $ff                     ; 
M2_WaSprite_MoveMinX    = M2_WaSprite + $0b         ; 
M2_WaSprite_MoveMaxX    = M2_WaSprite + $0c         ; 
M2_WaSprite_No          = M2_WaSprite + $0d         ; 
; ------------------------------------------------------------------------------------------------------------- ;
; Sprite Work Area - Players Part
; ------------------------------------------------------------------------------------------------------------- ;
M2_WaSprite_NoPlayer    = M2_WaSprite + $08         ; Player Special
M2_WaSprite_NoCounter   = M2_WaSprite + $09         ; 
M2_WaSprite_LastDir     = M2_WaSprite + $0a         ; 
M2_WaSprite_MoveType    = M2_WaSprite + $0b         ; 
M2_WaSprite_MoveClear     = $00                     ; 
M2_WaSprite_MoveJumpUp    = $01                     ; 
M2_WaSprite_MoveFallDo    = $02                     ; 
M2_WaSprite_MoveClimb     = $03                     ; 
M2_WaSprite_MoveSlide     = $04                     ; 
M2_WaSprite_MoveFly       = $05                     ; cannon shot/xmit
M2_WaSprite_MoveDirX    = M2_WaSprite + $0c         ; 
M2_WaSprite_MoveDirXNo    = $00                     ; 
M2_WaSprite_MoveDirXRi    = $01                     ; +1
M2_WaSprite_MoveDirXLe    = $ff                     ; -1
M2_WaSprite_MoveTime    = M2_WaSprite + $0d         ; 
M2_WaSprite_MoveTimeJump  = $11                     ; 
M2_WaSprite_MoveTimeJuUp  = $06                     ; 
M2_WaSprite_MoveTimeJuDo  = $25                     ; 
; ------------------------------------------------------------------------------------------------------------- ;
; Sprite Work Area Addresses
; ------------------------------------------------------------------------------------------------------------- ;
M2_WaSprite_00          = M2_WaSprite + (M2_WaSpriteLen + 1) * $00 ; $0d00 - player
M2_WaSprite_01          = M2_WaSprite + (M2_WaSpriteLen + 1) * $01 ; $0d0e - enemy
M2_WaSprite_02          = M2_WaSprite + (M2_WaSpriteLen + 1) * $02 ; $0d1c - enemy
M2_WaSprite_03          = M2_WaSprite + (M2_WaSpriteLen + 1) * $03 ; $0d2a - enemy
M2_WaSprite_04          = M2_WaSprite + (M2_WaSpriteLen + 1) * $04 ; $0d38 - enemy
M2_WaSprite_05          = M2_WaSprite + (M2_WaSpriteLen + 1) * $05 ; $0d46 - enemy
M2_WaSprite_06          = M2_WaSprite + (M2_WaSpriteLen + 1) * $06 ; $0d54 - enemy
M2_WaSprite_07          = M2_WaSprite + (M2_WaSpriteLen + 1) * $07 ; $0d62 - enemy
M2_WaSprite_08          = M2_WaSprite + (M2_WaSpriteLen + 1) * $08 ; $0d70 - enemy
M2_WaSprite_09          = M2_WaSprite + (M2_WaSpriteLen + 1) * $09 ; $0d7e - flicker sprites - scores/death tile
M2_WaSprite_0a          = M2_WaSprite + (M2_WaSpriteLen + 1) * $0a ; $0d8c - flicker sprites - scores/death tile
M2_WaSprite_0b          = M2_WaSprite + (M2_WaSpriteLen + 1) * $0b ; $0d9a - flicker sprites - scores/death tile

M2_WaSprite_0c          = M2_WaSprite + (M2_WaSpriteLen + 1) * $0c ; $0da8 - unused
M2_WaSprite_0d          = M2_WaSprite + (M2_WaSpriteLen + 1) * $0d ; $0db6 - unused
M2_WaSprite_0e          = M2_WaSprite + (M2_WaSpriteLen + 1) * $0e ; $0dc4 - unused
M2_WaSprite_0f          = M2_WaSprite + (M2_WaSpriteLen + 1) * $0f ; $0dd2 - unused
; ------------------------------------------------------------------------------------------------------------- ;
; Score Work Area Map - max $01 block of $08 bytes
; ------------------------------------------------------------------------------------------------------------- ;
M2_WaSprite_Score       = M2_WaFlow         + $52   ; 
M2_WaSprite_ScoreLen      = $08                     ; length of each item work area
M2_WaSprite_ScoreEnab   = M2_WaSprite_Score + $00   ; 
M2_WaSprite_ScorePosX   = M2_WaSprite_Score + $01   ; 
M2_WaSprite_ScorePosY   = M2_WaSprite_Score + $02   ; 
M2_WaSprite_ScoreSpPtr  = M2_WaSprite_Score + $03   ; 
M2_WaSprite_ScoreCol0   = M2_WaSprite_Score + $04   ; 
M2_WaSprite_ScoreBkPri  = M2_WaSprite_Score + $05   ; 
M2_WaSprite_ScoreBig    = M2_WaSprite_Score + $06   ; 
M2_WaSprite_Score7      = M2_WaSprite_Score + $07   ; 
M2_WaSprite_ScoreTime   = M2_WaSprite_Score + $08   ; 
; ------------------------------------------------------------------------------------------------------------- ;
; Misc Work Areas
; ------------------------------------------------------------------------------------------------------------- ;
; Stomper Work Area Map - max $05 block of $03 bytes
; ------------------------------------------------------------------------------------------------------------- ;
M2_WaMisc_Stomper       = M2_WorkAreasStart + $74   ; 
M2_WaMisc_StomperLen      = $03                     ; 
M2_WaMisc_StomperWaLen    = $0f                     ; 
M2_WaMisc_StomperPosX   = M2_WaMisc_Stomper + $00   ; 
M2_WaMisc_StomperPosY   = M2_WaMisc_Stomper + $01   ; 
M2_WaMisc_StomperTime   = M2_WaMisc_Stomper + $02   ; 
; ------------------------------------------------------------------------------------------------------------- ;
