; -------------------------------------------------------------------------------------------------------------- ;
; Miner 2049er - Level Structure Tiles
; -------------------------------------------------------------------------------------------------------------- ;
LevelTileStore      equ  *                        ; 
LevelTileStoreLen     = LevelTileStoreX - LevelTileStore
; -------------------------------------------------------------------------------------------------------------- ;
LevelStructTile00   dc.b $07 ; .....###           ; $00
                    dc.b $11 ; ...#...#
                    dc.b $00 ; ........
                    dc.b $ff ; ########
                    dc.b $00 ; ........
                    dc.b $ff ; ########
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelTileGroundNew1 dc.b $ff ; ########           ; $01
                    dc.b $00 ; ........
                    dc.b $ff ; ########
                    dc.b $00 ; ........
                    dc.b $ff ; ########
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelTileLadderLe   dc.b $aa ; #.#.#.#.           ; $02
                    dc.b $a0 ; #.#.....
                    dc.b $a0 ; #.#.....
                    dc.b $a0 ; #.#.....
                    dc.b $aa ; #.#.#.#.
                    dc.b $a0 ; #.#.....
                    dc.b $a0 ; #.#.....
                    dc.b $a0 ; #.#.....
                    
LevelTileLadderRi   dc.b $aa ; #.#.#.#.           ; $03
                    dc.b $0a ; ....#.#.
                    dc.b $0a ; ....#.#.
                    dc.b $0a ; ....#.#.
                    dc.b $aa ; #.#.#.#.
                    dc.b $0a ; ....#.#.
                    dc.b $0a ; ....#.#.
                    dc.b $0a ; ....#.#.
                    
LevelStructSlide    dc.b $aa ; #.#.#.#.           ; $04
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelTileGroundThin dc.b $ff ; ########           ; $05
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelTileGroundFix  dc.b $ff ; ########           ; $06
                    dc.b $ff ; ########
                    dc.b $ff ; ########
                    dc.b $ff ; ########
                    dc.b $ff ; ########
                    dc.b $ff ; ########
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelLineVert       dc.b $50 ; .#.#....           ; $07
                    dc.b $50 ; .#.#....
                    dc.b $50 ; .#.#....
                    dc.b $50 ; .#.#....
                    dc.b $50 ; .#.#....
                    dc.b $50 ; .#.#....
                    dc.b $50 ; .#.#....
                    dc.b $50 ; .#.#....
                    
LevelLineHoriz      dc.b $55 ; .#.#.#.#           ; $08
                    dc.b $55 ; .#.#.#.#
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelTileFlower     dc.b $ff ; ########           ; $09
                    dc.b $ff ; ########
                    dc.b $ff ; ########
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelStructTrack    dc.b $aa ; #.#.#.#.           ; $0a
                    dc.b $aa ; #.#.#.#.
                    dc.b $aa ; #.#.#.#.
                    dc.b $82 ; #.....#.
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelStructWheel    dc.b $54 ; .#.#.#..           ; $0b
                    dc.b $54 ; .##..#..
                    dc.b $10 ; ...#....
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelStructDot      dc.b $50 ; .#.#....           ; $0c
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelStructBlock    dc.b $aa ; #.#.#.#.           ; $0d
                    dc.b $aa ; #.#.#.#.
                    dc.b $aa ; #.#.#.#.
                    dc.b $aa ; #.#.#.#.
                    dc.b $aa ; #.#.#.#.
                    dc.b $aa ; #.#.#.#.
                    dc.b $aa ; #.#.#.#.
                    dc.b $aa ; #.#.#.#.
                    
LevelTileGroundNew2 dc.b $ff ; ########           ; $0e
                    dc.b $ff ; ########
                    dc.b $00 ; ........
                    dc.b $ff ; ########
                    dc.b $00 ; ........
                    dc.b $ff ; ########
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelStructTile0f   dc.b $00 ; ........           ; $0f
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelTileGroundNew3 dc.b $ff ; ########           ; .hbu003. - $10
                    dc.b $00 ; ........
                    dc.b $ff ; ########
                    dc.b $00 ; ........
                    dc.b $ff ; ########
                    dc.b $ff ; ########
                    dc.b $00 ; ........
                    dc.b $00 ; ........
; -------------------------------------------------------------------------------------------------------------- ;
LevelTileStoreX     equ  *
; -------------------------------------------------------------------------------------------------------------- ;
LevelTileNo_00      = (LevelStructTile00    - LevelTileStore) ; / $08 - $00
NoLvlTileGroundNew1 = (LevelTileGroundNew1  - LevelTileStore) ; / $08 - $08
NoLvlTileLadderLe   = (LevelTileLadderLe    - LevelTileStore) ; / $08 - $10
NoLvlTileLadderRi   = (LevelTileLadderRi    - LevelTileStore) ; / $08 - $18
NoLvlTileSlide      = (LevelStructSlide     - LevelTileStore) ; / $08 - $20
NoLvlTileGroundThin = (LevelTileGroundThin  - LevelTileStore) ; / $08 - $28
NoLvlTileGroundFix  = (LevelTileGroundFix   - LevelTileStore) ; / $08 - $30
NoLvlTileLineVert   = (LevelLineVert        - LevelTileStore) ; / $08 - $38
NoLvlTileLineHori   = (LevelLineHoriz       - LevelTileStore) ; / $08 - $40
NoLvlTileFlower     = (LevelTileFlower      - LevelTileStore) ; / $08 - $48
NoLvlTileTrack      = (LevelStructTrack     - LevelTileStore) ; / $08 - $50
NoLvlTileWheel      = (LevelStructWheel     - LevelTileStore) ; / $08 - $58
NoLvlTileDot        = (LevelStructDot       - LevelTileStore) ; / $08 - $60
NoLvlTileBlock      = (LevelStructBlock     - LevelTileStore) ; / $08 - $68
NoLvlTileGroundNew2 = (LevelTileGroundNew2  - LevelTileStore) ; / $08 - $70
LevelTileNo_0f      = (LevelStructTile0f    - LevelTileStore) ; / $08 - $78
NoLvlTileGroundNew3 = (LevelTileGroundNew3  - LevelTileStore) ; / $08 - $80 - .hbu003.
; -------------------------------------------------------------------------------------------------------------- ;
; Tile Types
; -------------------------------------------------------------------------------------------------------------- ;
LevelGrndNext       = LevelTileDirRi_04
LevelGrndNextRiUp   = LevelTileDirUp_01   + LevelTileDirRi_04
LevelGrndNextRiDo   = LevelTileDirDo_01   + LevelTileDirRi_04
LevelGrndBot        = NoLvlTileGroundThin + LevelTileTypeClear00
LevelGrndPlain      = LevelTileTypePlain  + (NoLvlTileGroundNew1 - 8) + LevelTileTypeClear00
LevelGrndSlope      = LevelTileTypeSlope  +  NoLvlTileGroundNew1      + LevelTileTypeClear00

LevelSlideNextDo    = LevelTileDirDo_01
LevelSlideNextDoRi  = LevelTileDirDo_01   + LevelTileDirRi_01
LevelSlideNextDoLe  = LevelTileDirDo_01   + LevelTileDirLe_01
LevelSlide          = NoLvlTileSlide      + LevelTileTypeClear00

LevelLadderNext     = LevelTileDirDo_08
LevelLadderPartLe   = NoLvlTileLadderLe   + LevelTileTypeClear00  ; $10
LevelLadderPartRi   = NoLvlTileLadderRi   + LevelTileTypeClear00  ; $18
; -------------------------------------------------------------------------------------------------------------- ;
; Tiles Control Block
; -------------------------------------------------------------------------------------------------------------- ;
LevelTileData       = $00     ; 
LevelTileDataLen      = $05   ; 
LevelTileCount      = $00     ; 
LevelTilePosX       = $01     ; 
LevelTilePosY       = $02     ; 
LevelTileDir        = $03     ; 
LevelTileDirMaskX     = $0f   ; 
LevelTileDirRi_01       = $01 ; +1
LevelTileDirRi_04       = $04 ; +4
LevelTileDirLe_01       = $0f ; -1
LevelTileDir___00       = $00 ; +0
LevelTileDirMaskY     = $f0   ; 
LevelTileDirUp_01       = $f0 ; -1
LevelTileDirDo_01       = $10 ; +1
LevelTileDirDo_08       = $80 ; +8
LevelTileType       = $04     ; 
LevelTileTypeMaskGrnd = $80   ; #.......
LevelTileTypePlain      = $80 ; 2 varying tiles make a plain ground
LevelTileTypeSlope      = $00 ; default
LevelTileTypeMaskNo   = $78   ; .####...
LevelTileTypeMaskClr  = $07   ; .....###
LevelTileTypeClear00    = $00 ; default
LevelTileTypeClear01    = $01 ; 
LevelTileTypeClear02    = $02 ; 
LevelTileTypeClear03    = $03 ; 
LevelTileTypeClear04    = $04 ; 
LevelTileTypeClear05    = $05 ; 
LevelTileTypeClear06    = $06 ; 
LevelTileTypeClear07    = $07 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Work Area Select
; -------------------------------------------------------------------------------------------------------------- ;
NoItemWa_00         = $00 ; M2_WaSprite_09
NoItemWa_01         = $01 ; M2_WaSprite_0a
NoItemWa_02         = $02 ; M2_WaSprite_0b
; -------------------------------------------------------------------------------------------------------------- ;
; Item Control Block
; -------------------------------------------------------------------------------------------------------------- ;
ItemData            = $00 ; 
ItemDataLen           = $08
ItemPaintPosX       = $00 ; level init
ItemPaintPosY       = $01 ; 
ItemNo              = $02 ; #####.oo = item no/unused/wa number ($00-$02 - $09-$0b)
ItemScore           = $03 ; ###ooooo = sprite ptr/score to add
ItemTouchPosXMin    = $04 ; level play
ItemTouchPosXMax    = $05 ; 
ItemTouchPosYMin    = $06 ; 
ItemTouchPosYMax    = $07 ; 
; ------------------------------------------------------------------------------------------------------------- ;
; Slide Control Block
; -------------------------------------------------------------------------------------------------------------- ;
LevelSlideData      = $00
LevelSlideDataLen     = $04
LevelSlideLength    = $00
LevelSlidePosX      = $01
LevelSlidePosY      = $02
LevelSlideMove      = $03
LevelSlideMoveDo      = $00
LevelSlideMoveDoRi    = $01
LevelSlideMoveDoLe    = $ff
; -------------------------------------------------------------------------------------------------------------- ;
; Ladder Control Block
; -------------------------------------------------------------------------------------------------------------- ;
LevelLadderData     = $00
LevelLadderDataLen    = $03
LevelLadderPosX     = $00
LevelLadderPosYTop  = $01
LevelLadderPosYBot  = $02
; -------------------------------------------------------------------------------------------------------------- ;
; Text Control Block
; -------------------------------------------------------------------------------------------------------------- ;
TextData            = $00 ; 
TextDataLen           = $03
TextPosX            = $00 ; 
TextPosY            = $01 ; 
TextChrNo           = $02 ; 
; -------------------------------------------------------------------------------------------------------------- ;
