; ------------------------------------------------------------------------------------------------------------- ;
; Miner 2049er - MINER.PRG from $8000 to $BFFF
; ------------------------------------------------------------------------------------------------------------- ;
; Memory Map
; ------------------------------------------------------------------------------------------------------------- ;
; $8000 - $87ff:  Sprite Move Control Screen
; vnmi                       ; kernal - $fffa = non-maskable interrupt hardware vector - $fffb:  Vector: NMI
; vres                       ; kernal - $fffc = system reset (res) hardware vecto - $fffd:  Vector: System Reset <not set>
; vbrk                       ; kernal - $fffe = maskable interrupt request and break hardware vectors - $ffff:  Vector: IRQ
; ------------------------------------------------------------------------------------------------------------- ;
                  * = $8000                       ; Start address
; ------------------------------------------------------------------------------------------------------------- ;
; compiler settings                                                                                             ;
; ------------------------------------------------------------------------------------------------------------- ;
C64CIA1           .include  inc\cia1.asm          ; Complex Interface Adapter (CIA) #1 Registers  $DC00-$DC0F
C64CIA2           .include  inc\cia2.asm          ; Complex Interface Adapter (CIA) #2 Registers  $DD00-$DD0F
C64SID            .include  inc\sid.asm           ; Sound Interface Device (SID) Registers        $D400-$D41C
C64VicII          .include  inc\vic.asm           ; Video Interface Chip (VIC-II) Registers       $D000-$D02E
C64Kernel         .include  inc\kernel.asm        ; Kernel Vectors
C64Colors         .include  inc\Color.asm         ; Colour RAM Address / Colours
;
;InGameVars        .include  inc\MM_Vars.asm       ; Level Variables / Best Times  Mapping
;
Report            .opt      R=miner.txt           ; Report file
BinaryOut         .opt      O=miner.prg           ; Compiled binary output file
;
Switches          .opt      T                     ; Summary report
                  .opt      S                     ; Symbol table
;                  .opt      L                    ; Compiler listing
; ------------------------------------------------------------------------------------------------------------- ;
                  .word I_8010
                  .word I_8010
; ------------------------------------------------------------------------------------------------------------- ;
                  .byte $c3
                  .byte $c2
                  .byte $cd
                  .byte $38
                  .byte $30
                  .byte $ff
                  .byte $00
                  .byte $00
                  .byte $ff
                  .byte $ff
                  .byte $00
                  .byte $00
; ------------------------------------------------------------------------------------------------------------- ;
I_8010            sei
                  cld
                  ldx #$ff
                  txs
                  lda #$7f
                  sta CIAICR                      ; CIA 1 - $dc0d = Iterrupt Control
                  sta CI2ICR                      ; CIA 2 - $dd0d = Iterrupt Control
                  lda #$2f
                  sta $00
                  lda #$fe
                  sta $01
                  lda C2DDRA                      ; CIA 2 - $dd02 = Data Direction A
                  ora #$03
                  sta C2DDRA                      ; CIA 2 - $dd02 = Data Direction A
                  lda CI2PRA                      ; CIA 2 - $dd00 = Data Port A
                  and #$fc
                  ora #$02
                  sta CI2PRA                      ; CIA 2 - $dd00 = Data Port A
                  lda #$00
                  sta IRQMASK                     ; VIC 2 - $d01a = IRQ Mask
                  sta EXTCOL                      ; VIC 2 - $d020 = Border Color
                  sta BGCOL0                      ; VIC 2 - $d021 = Background Color 0
                  sta CIDDRB                      ; CIA 1 - $dc03 = Data Direction B
                  lda #$0b
                  sta SCROLY                      ; VIC 2 - $d011 = Control 1 (and vertical fine scrolling)
                  
                  jsr S_80a2
                  
                  lda #$00
                  sta $2b
                  lda #$d0
                  sta $2c
                  
                  lda #$00
                  sta $29
                  lda #$70
                  sta $2a                         ; ($29/$2a) point to $7000
    
                  lda #$00
                  sta $2d
                  lda #$02
                  sta $2e                         ; ($2d/$2e) point to $0200
    
                  lda $01
                  and #$fb
                  sta $01
                  
                  jsr S_8907
                  
                  lda $01
                  ora #$04
                  sta $01
                  ldx #$07
B_8076            lda T_809a,x
                  sta $7000,x
                  dex
                  bpl B_8076
                  
                  jsr S_80d8
                  
                  lda #$00
                  sta $0314
                  lda #$83
                  sta $0315                       ; $8300
    
                  lda #$10
                  sta $0316
                  lda #$80
                  sta $0317                       ; $8010
                  cli
    
                  jmp J_813f
; ------------------------------------------------------------------------------------------------------------- ;
T_809a            .byte $1c
                  .byte $7f
                  .byte $26
                  .byte $7e
                  .byte $36
                  .byte $06
                  .byte $3c
                  .byte $00
; ------------------------------------------------------------------------------------------------------------- ;
S_80a2            lda #$40
                  sta $19
                  lda #$01
                  sta $1a                         ; ($1a/$1b) point to $0140
    
                  lda #$00
                  sta $1b
                  lda #$40
                  sta $1c                         ; ($29/$2a) point to $4000
    
                  ldx #$00
B_80b4            ldy #$08
B_80b6            lda $1c
                  sta $0ac8,x
                  lda $1b
                  sta $0a00,x
                  inx
                  inc $1b
                  dey
                  bne B_80b6
                  
                  and #$f0
                  clc
                  adc $19
                  sta $1b
                  lda $1a
                  adc $1c
                  sta $1c
                  cpx #$c8
                  bcc B_80b4

                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_80d8            lda #$00
                  sta $2b
                  lda #$70
                  sta $2c
                  
                  lda #$00
                  sta $29
                  lda #$72
                  sta $2a
                  
                  lda #$40
                  sta $2d
B_80ec            ldy #$07
B_80ee            lda ($2b),y
                  
                  jsr S_8126
                  
                  lda $19
                  sta ($29),y
                  lda $1a
                  sta $0038,y
                  dey
                  bpl B_80ee
                  
                  ldy #$0f
                  ldx #$07
B_8103            lda $38,x
                  sta ($29),y
                  dey
                  dex
                  bpl B_8103
                  
                  clc
                  lda #$08
                  adc $2b
                  sta $2b
                  bcc B_8116
                  
                  inc $2c
B_8116            clc
                  lda #$10
                  adc $29
                  sta $29
                  bcc B_8121
                  
                  inc $2a
B_8121            dec $2d
                  bne B_80ec
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_8126            ldx #$04
B_8128            asl a
                  php
                  rol $19
                  plp
                  rol $19
                  dex
                  bne B_8128
                  
                  ldx #$04
B_8134            asl a
                  php
                  rol $1a
                  plp
                  rol $1a
                  dex
                  bne B_8134
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
J_813f            lda #$ff
                  sta $a2
                  bne B_814c
                  
B_8145            jsr S_9ea0
                  
                  lda $a2
                  bpl B_8153
                  
B_814c            jsr S_815d
                  
B_814f            lda $a2
                  bmi B_8145
                  
B_8153            lda #$00
                  sta $a2
                  
                  jsr S_815d
                  
                  jmp B_814f
                  
S_815d            lda #$00
                  ldx #$05
B_8161            sta $50,x
                  dex
                  bpl B_8161
                  
                  lda #$03
                  sta $9f
                  lda #$00
                  sta $a3
                  
B_816e            jsr S_9ea3
                  
                  jsr S_8919
                  
                  lda $a1
                  inc $a1
                  and #$07
                  asl a
                  tax
                  lda T_82cb,x
                  pha
                  inx
                  lda T_82cb,x
                  
                  jsr S_891c
                  
                  pla
                  
                  jsr S_891f
                  
                  lda #$00
                  sta $07
                  sta $08
                  sta $06
                  sta $05
                  sta EXTCOL                      ; VIC 2 - $d020 = Border Color
                  sta YXPAND                      ; VIC 2 - $d017 = Sprite Y Expansion
                  sta BGCOL0                      ; VIC 2 - $d021 = Background Color 0
                  sta SPBGPR                      ; VIC 2 - $d01b = Sprite to Foreground Priority
                  lda SPSPCL                      ; VIC 2 - $d01e = Sprite/Sprite Collision
                  lda #$08
                  sta SPMC0                       ; VIC 2 - $d025 = Sprite MultiColor 0
                  lda #$0e
                  sta SPMC1                       ; VIC 2 - $d026 = Sprite MultiColor 1
                  lda #$0a
                  ldx $a2
                  bmi B_81b6
                  
                  lda $a3
B_81b6            asl a
                  tax
                  lda T_81cc,x
                  sta $27
                  inx
                  lda T_81cc,x
                  sta $28
                  
                  jsr S_81c9
                  
                  jmp B_81e2
                  
S_81c9            jmp ($0027)
; ------------------------------------------------------------------------------------------------------------- ;
T_81cc            .word T_8450
                  .word T_8453
                  .word T_8456
                  .word T_8459
                  .word T_845c
                  .word T_845f
                  .word T_8462
                  .word T_8465
                  .word T_8468
                  .word T_846b
                  .word T_846e
; ------------------------------------------------------------------------------------------------------------- ;
B_81e2            lda #$00
                  sta SIGVOL                      ; SID - $d418 = Volume and Filter Select
B_81e7            lda $a2
                  beq B_81f2
                  
                  lda #$00
                  sta $9f
                  jmp B_8282
                  
B_81f2            lda $06
                  cmp #$41
                  bne B_81e7
                  
                  lda $a0
                  bpl B_821c
                  
                  and #$0f
                  bne B_820f
                  
                  inc $a3
                  lda $a3
                  cmp #$0a
                  bcc B_8282
                  
                  lda #$00
                  sta $a3
                  jmp B_8282
                  
B_820f            cmp #$0a
                  sta $a3
                  bcc B_8282
                  
                  lda #$00
                  sta $a3
                  jmp B_8282
                  
B_821c            dec $9f
                  bne B_8282
                  
                  lda #$2c
                  sta $1d
                  lda #$48
                  sta $1f
                  ldx #$0a
B_822a            lda T_82db,x
                  sta FRELO3,x                    ; SID - $d40e = Oscillator 3 Frequency Control (low byte)
                  dex
                  bpl B_822a
                  
B_8233            lda #$20
                  ldx #$60
                  
                  jsr S_82ba
                  
                  lda #$20
                  ldx #$68
                  jsr S_82ba
                  
                  inc $1d
                  ldx #$08
B_8245            ldy #$00
B_8247            dey
                  bne B_8247
                  
                  dex
                  bne B_8245
                  
                  lda $1f
                  lsr a
                  sta FREHI3                      ; SID - $d40f = Oscillator 3 Frequency Control (high byte)
                  dec $1f
                  bne B_8233
                  
                  sta SIGVOL                      ; SID - $d418 = Volume and Filter Select
                  lda #$e6
                  sta $88
                  lda #$82
                  sta $89                         ; ($88/$89) point to $82e6
     
                  ldx #$ff
                  ldy #$ff
                  
                  jsr S_955c
                  
                  lda #$00
                  sta $19
                  sta $1a
B_826f            jsr S_8925
                  
                  lda $4b
                  bne B_8282
                  
                  dec $19
                  bne B_826f
                  
                  dec $1a
                  bne B_826f
                  
                  lda #$ff
                  sta $a2
B_8282            lda #$00
                  tax
B_8285            sta $0d00,x
                  dex
                  bne B_8285
                  
                  lda #$c7
                  sta $44
B_828f            lda #$9f
                  sta $43                         ; ($43/$44) point to $9fc7
                  
B_8293            jsr S_8910
                  
                  lda #$00
                  tay
                  sta ($45),y
                  dec $43
                  bne B_8293
                  
                  dec $44
                  bne B_828f
                  
                  sei
                  lda #$00
                  sta IRQMASK                     ; VIC 2 - $d01a = IRQ Mask
                  lda SCROLY                      ; VIC 2 - $d011 = Control 1 (and vertical fine scrolling)
                  and #$ef
                  sta SCROLY                      ; VIC 2 - $d011 = Control 1 (and vertical fine scrolling)
                  cli
     
                  lda $9f
                  beq B_82b9
                  
                  jmp B_816e
                  
B_82b9            rts
; ------------------------------------------------------------------------------------------------------------- ;
S_82ba            stx $44
                  ldx $1d
                  stx $43
                  
                  jsr S_9c69
                  
                  ldx #$ff
                  ldy #$ff
                  jsr S_955f
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
T_82cb            .byte $03
                  .byte $42
                  .byte $05
                  .byte $a9
                  .byte $0e
                  .byte $86
                  .byte $0d
                  .byte $78
                  .byte $0c
                  .byte $a4
                  .byte $06
                  .byte $32
                  .byte $07
                  .byte $4c
                  .byte $04
                  .byte $7f
T_82db            .byte $80
                  .byte $24
                  .byte $00
                  .byte $08
                  .byte $41
                  .byte $2d
                  .byte $35
                  .byte $00
                  .byte $00
                  .byte $00
                  .byte $0c
    
T_82e6            .byte $30
                  .byte $64
                  .byte $38
                  .byte $38
                  .byte $64
                  .byte $08
                  .byte $40
                  .byte $64
                  .byte $68
                  .byte $48
                  .byte $64
                  .byte $28
                  .byte $58
                  .byte $64
                  .byte $78
                  .byte $60
                  .byte $64
                  .byte $b0
                  .byte $68
                  .byte $64
                  .byte $28
                  .byte $70
                  .byte $64
                  .byte $90
                  .byte $00
                  .byte $00
; ------------------------------------------------------------------------------------------------------------- ;
I_8300            ldx $05
                  bne B_831d
                  
                  lda #$18
                  sta SCROLX                      ; VIC 2 - $d016 = Control Register 2 (and horizontal fine scrolling)
                  lda #$80
                  sta VMCSB                       ; VIC 2 - $d018 = Chip Memory Control
                  lda #$3b
                  sta SCROLY                      ; VIC 2 - $d011 = Control 1 (and vertical fine scrolling)
                  lda $92
                  sta RASTER                      ; VIC 2 - $d012 = Read: Raster Scan Line / Write: Line for Raster IRQ
                  inc $05
                  jmp B_83a7
                  
B_831d            dex
                  bne B_8355
                  
                  lda #$fa
                  sta RASTER                      ; VIC 2 - $d012 = Read: Raster Scan Line / Write: Line for Raster IRQ
                  inc $05
                  lda $06
                  lsr a
                  bcc B_833a
                  
                  lda SPSPCL                      ; VIC 2 - $d01e = Sprite/Sprite Collision
                  lsr a
                  bcc B_833a
                  
                  and #$0f
                  beq B_833a
                  
                  ora $07
                  sta $07
B_833a            ldy #$04
B_833c            tya
                  asl a
                  tax
                  lda $6c,x
                  sta $17
                  lda $6d,x
                  sta $18
                  tya
                  tax
                  pha
                  
                  jsr S_83b5
                  
                  pla
                  tay
                  dey
                  bne B_833c
                  
                  jmp B_83a7
                  
B_8355            ldx #$00
                  stx $05
                  lda #$1b
                  sta SCROLY                      ; VIC 2 - $d011 = Control 1 (and vertical fine scrolling)
                  lda #$08
                  sta SCROLX                      ; VIC 2 - $d016 = Control Register 2 (and horizontal fine scrolling)
                  lda #$8c
                  sta VMCSB                       ; VIC 2 - $d018 = Chip Memory Control
                  lda #$3a
                  sta RASTER                      ; VIC 2 - $d012 = Read: Raster Scan Line / Write: Line for Raster IRQ
                  lda $06
                  lsr a
                  bcc B_8380
                  
                  lda SPSPCL                      ; VIC 2 - $d01e = Sprite/Sprite Collision
                  lsr a
                  bcc B_8380
                  
                  and #$0f
                  beq B_8380
                  
                  ora $08
                  sta $08
B_8380            ldy #$07
B_8382            tya
                  asl a
                  tax
                  lda $5c,x
                  sta $17
                  lda $5d,x
                  sta $18
                  tya
                  tax
                  pha
                  
                  jsr S_83b5
                  
                  pla
                  tay
                  dey
                  bpl B_8382
                  
                  lda $06
                  lsr a
                  bcs B_83a5
                  
                  lda SPENA                       ; VIC 2 - $d015 = Sprite Enable
                  and #$1f
                  sta SPENA                       ; VIC 2 - $d015 = Sprite Enable
B_83a5            inc $06
B_83a7            lda SPSPCL                      ; VIC 2 - $d01e = Sprite/Sprite Collision
                  lda #$01
                  sta VICIRQ                      ; VIC 2 - $d019 = Interrupt Flag - 1=clear latched flag
    
                  pla
                  tay
                  pla
                  tax
                  pla
                  
                  rti
; ------------------------------------------------------------------------------------------------------------- ;
S_83b5            stx $13
                  txa
                  asl a
                  sta $14
                  lda T_8444,x
                  sta $15
                  eor #$ff
                  sta $16
                  ldy #$07
B_83c6            lda ($17),y
                  sta $000b,y
                  dey
                  bpl B_83c6
                  
                  lda $0b
                  and $15
                  sta $09
                  lda SPENA                       ; VIC 2 - $d015 = Sprite Enable
                  and $16
                  ora $09
                  sta SPENA                       ; VIC 2 - $d015 = Sprite Enable
                  ldx $14
                  lda $0d
                  sta SP0Y,x                      ; VIC 2 - $d001 = Sprite 0 posy
                  ldy $0c
                  lda $11
                  and $15
                  sta $11
                  beq B_83f4
                  
                  tya
                  sec
                  sbc #$04
                  tay
B_83f4            tya
                  asl a
                  sta SP0X,x
                  lda #$00
                  bcc B_83ff
                  
                  lda #$ff
B_83ff            and $15
                  sta $09
                  lda MSIGX                       ; VIC 2 - $d010 = MSBs Sprites 0-7 posx
                  and $16
                  ora $09
                  sta MSIGX                       ; VIC 2 - $d010 = MSBs Sprites 0-7 posx
                  lda $0e
                  ldx $13
                  sta $63f8,x
                  lda $0f
                  sta SP0COL,x                    ; VIC 2 - $d027 = Color Sprite 0
                  lda $10
                  and $15
                  sta $09
                  lda SPBGPR                      ; VIC 2 - $d01b = Sprite to Foreground Priority
                  and $16
                  ora $09
                  sta SPBGPR                      ; VIC 2 - $d01b = Sprite to Foreground Priority
                  lda XXPAND                      ; VIC 2 - $d01d = Sprite x expansion
                  and $16
                  ora $11
                  sta XXPAND                      ; VIC 2 - $d01d = Sprite x expansion
                  lda $12
                  and $15
                  sta $09
                  lda SPMC                        ; VIC 2 - $d01c = Sprite multiColor
                  and $16
                  ora $09
                  sta SPMC                        ; VIC 2 - $d01c = Sprite multiColor
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
T_8444            .byte $01
                  .byte $02
                  .byte $04
                  .byte $08
                  .byte $10
                  .byte $20
                  .byte $40
                  .byte $80
                  .byte $ff
                  .byte $ff
                  .byte $00
                  .byte $00
; ------------------------------------------------------------------------------------------------------------- ;
T_8450            jmp B_8471
T_8453            jmp B_84b7
T_8456            jmp B_84c1
T_8459            jmp B_84d4
T_845c            jmp B_84de
T_845f            jmp B_8531
T_8462            jmp B_85b4
T_8465            jmp B_85da
T_8468            jmp B_8664
T_846b            jmp B_8694
T_846e            jmp B_8710
                  
B_8471            ldx #$98
                  ldy #$ad
                  
                  jsr S_8498
B_8478            jsr S_8f49
                  jsr S_87df
B_847e            jsr S_8487
                  jsr S_84a7
                  
                  bcc B_847e
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_8487            lda $06
                  cmp #$02
                  bcc S_8487
                  
                  lda #$00
                  sta $06
                  jsr S_8f4c
                  jsr S_8f5b
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_8498            stx $27
                  sty $28
                  ldy #$3f
B_849e            lda ($27),y
                  sta $005c,y
                  dey
                  bpl B_849e
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_84a7            jsr S_8f55
                  jsr S_8f58
                  jsr S_87e2
                  jsr S_8f4f
                  jsr S_8f52
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_84b7            ldx #$62
                  ldy #$af
                  jsr S_8498
                  
                  jmp B_8478
                  
B_84c1            ldx #$99
                  ldy #$af
                  
                  jsr S_8498
                  jsr S_8f49
                  jsr S_9550
                  jsr S_87df
                  jmp B_847e
                  
B_84d4            ldx #$86
                  ldy #$b1
                  jsr S_8498
                  
                  jmp B_8478
                  
B_84de            ldx #$2b
                  ldy #$b3
                  jsr S_8498
                  jsr S_8f49
                  
                  ldy #$1b
B_84ea            lda ($86),y
                  sta $0c00,y
                  dey
                  bpl B_84ea
                  
                  jsr S_87df
B_84f5            jsr S_8487
                  jsr S_9559
                  
                  lda $0d01
                  cmp #$12
                  bcs B_8511
                  
                  lda $0d02
                  cmp #$c0
                  bcc B_8511
                  
                  cmp #$e0
                  bcs B_8511
                  
                  lda #$ff
                  sta $4f
B_8511            lda RASTER                      ; VIC 2 - $d012 = Read: Raster Scan Line / Write: Line for Raster IRQ
                  and #$07
                  sta $19
                  lda $6320
                  and #$f0
                  ora $19
                  sta $6320
                  sta $6321
                  sta $6348
                  sta $6349
                  jsr S_84a7
                  
                  bcc B_84f5
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8531            ldx #$57
                  ldy #$b5
                  jsr S_8498
                  
                  lda #$aa
                  ldx #$f0
B_853c            sta $5a67,x
                  sta $5ba7,x
                  sta $5ce7,x
                  sta $5e27,x
                  dex
                  bne B_853c
                  
                  jsr S_8f49
                  
                  ldy #$09
B_8550            lda ($86),y
                  sta $0c00,y
                  dey
                  bpl B_8550
                  
                  ldx #$ff
                  ldy #$aa
                  
                  jsr S_955c
                  
                  jsr S_87df
B_8562            jsr S_8487
                  jsr S_9559
                  
                  lda $0d02
                  cmp #$c5
                  bcc B_8599
                  
                  lda $0d01
                  cmp #$17
                  beq B_8587
                  
                  cmp #$1f
                  beq B_8582
                  
                  cmp #$91
                  beq B_8587
                  
                  cmp #$99
                  bne B_858a
                  
B_8582            inc $0d01
                  bne B_858a
                  
B_8587            dec $0d01
B_858a            lda $0d01
                  cmp #$1f
                  bcc B_8599
                  
                  cmp #$99
                  bcs B_8599
                  
                  lda #$ff
                  sta $4f
B_8599            lda $6348
                  and #$0f
                  cmp #$05
                  bcc B_85a4
                  
                  lda #$00
B_85a4            adc #$c1
                  ldx #$a0
B_85a8            sta $6347,x
                  dex
                  bne B_85a8
                  
                  jsr S_84a7
                  
                  bcc B_8562
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_85b4            ldy #$b7
                  ldx #$14
                  
                  jsr S_8498
                  jsr S_8f49
                  jsr S_9550
                  
                  ldy #$24
B_85c3            lda ($86),y
                  sta $0c00,y
                  dey
                  bpl B_85c3
                  
                  jsr S_87df
B_85ce            jsr S_8487
                  jsr S_9559
                  jsr S_84a7
                  
                  bcc B_85ce
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_85da            ldx #$80
                  ldy #$b9
                  
                  jsr S_8498
                  
                  jsr S_8f49
                  
                  lda #$64
                  sta $af
                  lda #$a9
                  sta $b0
                  ldy #$1b
B_85ee            lda ($8e),y
                  sta $0d8c,y
                  dey
                  bpl B_85ee
                  
                  lda #$17
                  sta $27
                  lda #$62
                  sta $28                         ; ($17/$18) point to $6217
    
                  lda #$0c
                  sta $19
    
                  lda #$17
                  sta $25
                  lda #$da
                  sta $26                         ; ($26/$27) point to $da17

B_860a            ldy #$0f
B_860c            lda #$11
                  sta ($27),y
                  sta ($25),y
                  dey
                  bpl B_860c
                  
                  clc
                  lda #$28
                  adc $27
                  sta $27
                  bcc B_8620
                  
                  inc $28
B_8620            clc
                  lda #$28
                  adc $25
                  sta $25
                  bcc B_862b
                  
                  inc $26
B_862b            dec $19
                  bne B_860a
                  
                  jsr S_87df
                  
B_8632            lda $06
                  cmp #$02
                  bcc B_8632
                  
                  lda #$00
                  sta $06
                  
                  jsr S_8f4c
                  jsr S_997e
                  
                  lda $b1
                  bpl B_864c
                  
                  jsr S_9981
                  
                  jmp B_8652
                  
B_864c            jsr S_8f5b
                  jsr S_8f58
B_8652            jsr S_8f55
                  jsr S_9984
                  jsr S_8f4f
                  jsr S_87e2
                  jsr S_8f52
                  
                  bcc B_8632
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8664            ldx #$7d
                  ldy #$bb
                  jsr S_8498
                  
                  ldy #$0e
B_866d            lda ($8c),y
                  sta $0c74,y
                  dey
                  bpl B_866d
                  
                  ldy #$36
B_8677            lda ($86),y
                  sta $0c00,y
                  dey
                  bpl B_8677
                  
                  jsr S_8f49
                  
                  jsr S_87df
B_8685            jsr S_8487
                  jsr S_9562
                  jsr S_998d
                  jsr S_84a7
                  
                  bcc B_8685
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8694            ldx #$99
                  ldy #$bd
                  jsr S_8498
                  
                  ldx #$00
                  ldy #$aa
                  jsr S_955c
                  
                  lda #$3d
                  ldx #$52
                  ldy #$10
                  jsr S_9c66
                  
                  lda #$30
                  ldx #$6a
                  ldy #$10
                  jsr S_9c66
                  
                  lda #$00
                  ldx #$0d
B_86b8            sta $6129,x
                  dex
                  bpl B_86b8
                  
                  lda $6330
                  and #$0f
                  ora #$b0
                  tay
                  ldx #$10
                  tya
B_86c9            lda #$bb
                  sta $6330,x
                  sta $6383,x
                  sta $6380,x
                  sta $63a8,x
                  tya
                  sta $63d0,x
                  dex
                  bpl B_86c9
                  
                  lda #$6e
                  sta $b3
                  lda #$00
                  sta $b4
                  sta $b5
                  sta $b6
                  sta $b7
                  
                  jsr S_8f49
                  jsr S_87df
B_86f2            jsr S_8487
                  jsr S_9c5d
                  jsr S_8f55
                  jsr S_9c60
                  jsr S_9c63
                  jsr S_8f58
                  jsr S_87e2
                  jsr S_8f4f
                  jsr S_8f52
                  
                  bcc B_86f2
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8710            ldx #$98
                  ldy #$ad
                  jsr S_8498
                  jsr S_8f49
                  jsr S_87df
                  
                  lda #$00
                  sta $d6
                  lda $0d01
                  sta $d4
B_8726            lda $06
                  eor #$02
                  bne B_8726
                  
                  sta $06
                  jsr S_8f4c
                  jsr S_8925
                  
                  lda $4b
                  beq B_873d
                  
                  lda #$01
                  sta $a2
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_873d            lda $d4
                  beq B_8748
                  
                  cmp $0d01
                  bne B_8782
                  
                  beq B_8755
                  
B_8748            ldx $d5
                  cpx $0d02
                  beq B_8755
                  
                  dex
                  cpx $0d02
                  bne B_8782
                  
B_8755            ldx $d6
                  lda T_87ac,x
                  sta $d4
                  lda T_87c1,x
                  sta $d5
                  ldy #$00
                  lda T_8797,x
                  bpl B_8769
                  
                  dey
B_8769            sty $d9
                  and #$03
                  tay
                  lda T_8794,y
                  sta $d7
                  lda T_8797,x
                  lsr a
                  lsr a
                  and #$03
                  tay
                  lda T_8794,y
                  sta $d8
                  inc $d6
B_8782            ldx #$02
B_8784            lda $d7,x
                  sta $49,x
                  dex
                  bpl B_8784
                  
                  jsr S_8928
                  jsr S_84a7
                  
                  bcc B_8726
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
T_8794            .byte $00
                  .byte $01
                  .byte $ff
                  
T_8797            .byte $01
                  .byte $80
                  .byte $01
                  .byte $82
                  .byte $01
                  .byte $02
                  .byte $09
                  .byte $0a
                  .byte $82
                  .byte $02
                  .byte $80
                  .byte $81
                  .byte $01
                  .byte $0a
                  .byte $02
                  .byte $01
                  .byte $81
                  .byte $01
                  .byte $0a
                  .byte $09
                  .byte $02
                  
T_87ac            .byte $16
                  .byte $00
                  .byte $a4
                  .byte $96
                  .byte $98
                  .byte $0c
                  .byte $00
                  .byte $32
                  .byte $28
                  .byte $13
                  .byte $00
                  .byte $19
                  .byte $9b
                  .byte $4a
                  .byte $16
                  .byte $25
                  .byte $27
                  .byte $9b
                  .byte $00
                  .byte $9c
                  .byte $13
                  
T_87c1            .byte $00
                  .byte $e2
                  .byte $00
                  .byte $00
                  .byte $00
                  .byte $00
                  .byte $b3
                  .byte $00
                  .byte $00
                  .byte $00
                  .byte $a0
                  .byte $00
                  .byte $00
                  .byte $00
                  .byte $00
                  .byte $00
                  .byte $00
                  .byte $00
                  .byte $5a
                  .byte $00
                  .byte $00
; ------------------------------------------------------------------------------------------------------------- ;
S_87d6            jmp S_87e8
S_87d9            jmp S_883f
S_87dc            jmp S_8849
S_87df            jmp S_88d7
S_87e2            jmp S_88f3
S_87e5            jmp S_88fd
; ------------------------------------------------------------------------------------------------------------- ;
S_87e8            lda $43
                  sta $21
                  lda $44
                  sta $22
                  
                  jsr S_890d
                  jsr S_8916
                  
                  lda $22
                  clc
                  adc #$08
                  sta $44
                  
                  jsr S_8833
                  jsr S_890d
                  jsr S_8916
                  
                  lda $22
                  sta $44
                  lda $21
                  clc
                  adc #$04
                  sta $43
                  jsr S_8833
                  jsr S_890d
                  jsr S_8916
                  
                  lda $22
                  clc
                  adc #$08
                  sta $44
                  jsr S_8833
                  jsr S_890d
                  jsr S_8916
                  
                  lda $21
                  sta $43
                  lda $22
                  sta $44
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_8833            clc
                  lda #$08
                  adc $41
                  sta $41
                  bcc B_883e
                  
                  inc $42
B_883e            rts
; ------------------------------------------------------------------------------------------------------------- ;
S_883f            lda #$00
                  ldx #$05
B_8843            sta $56,x
                  dex
                  bpl B_8843
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_8849            ldx #$05
                  clc
B_884c            lda $50,x
                  adc $56,x
                  cmp #$0a
                  bcc B_8859
                  
                  adc #$05
                  and #$0f
                  sec
B_8859            sta $50,x
                  dex
                  bpl B_884c
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_885f            ldx #$00
                  stx $19
B_8863            lda $50,x
                  
                  jsr S_8889
                  
                  sta $6000,x
                  inx
                  cpx #$03
                  bcc B_8863
                  
                  lda #$20
                  ldy $19
                  beq B_8878
                  
                  lda #$2c
B_8878            sta $6000,x
B_887b            lda $50,x
                  
                  jsr S_8889
                  
                  sta $6001,x
                  inx
                  cpx #$06
                  bcc B_887b
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_8889            beq B_888d
                  
                  inc $19
B_888d            cpx #$05
                  bcs B_8898
                  
                  ldy $19
                  bne B_8898
                  
                  lda #$20
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8898            ora #$30
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_889b            lda #$20
                  sta $19
                  sta $1a
                  sta $1b
                  ldy $9f
                  beq B_88b8
                  
                  dey
                  beq B_88b8
                  
                  lda #$00
                  sta $19
                  dey
                  beq B_88b8
                  
                  sta $1a
                  dey
                  beq B_88b8
                  
                  sta $1b
B_88b8            lda $19
                  sta $6008
                  lda $1a
                  sta $6009
                  lda $1b
                  sta $600a
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_88c8            lda $9c
                  ora #$30
                  sta $6014
                  lda $9d
                  ora #$30
                  sta $6015
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_88d7            lda #$02
                  sta $05
B_88db            lda RASTER                      ; VIC 2 - $d012 = Read: Raster Scan Line / Write: Line for Raster IRQ
                  cmp #$fa
                  bne B_88db
                  
                  lda #$fe
                  sta RASTER                      ; VIC 2 - $d012 = Read: Raster Scan Line / Write: Line for Raster IRQ
                  lda #$01
                  sta IRQMASK                     ; VIC 2 - $d01a = IRQ Mask
                  sta VICIRQ                      ; VIC 2 - $d019 = Interrupt Flag - 1=clear latched flag
                  lda #$00
                  sta $06
                  
S_88f3            jsr S_885f
                  jsr S_889b
                  jsr S_88c8
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_88fd            clc
                  adc $27
                  sta $27
                  bcc B_8906
                  
                  inc $28
B_8906            rts
; ------------------------------------------------------------------------------------------------------------- ;
S_8907            jmp B_892b
S_890a            jmp B_8944
S_890d            jmp B_8959
S_8910            jmp B_8987
S_8913            jmp B_89cb
S_8916            jmp B_89a6
S_8919            jmp B_8a61
S_891c            jmp B_8a77
S_891f            jmp B_8a8d
S_8922            jmp B_8aa3
S_8925            jmp B_8cf8
S_8928            jmp B_8d1e
; ------------------------------------------------------------------------------------------------------------- ;
B_892b            ldx #$00
                  ldy #$00
B_892f            lda ($2b),y
                  sta ($29),y
                  iny
                  bne B_893b
                  
                  inx
                  inc $2c
                  inc $2a
B_893b            cpy $2d
                  bne B_892f
                  
                  cpx $2e
                  bne B_892f
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8944            ldx #$00
                  ldy #$00
B_8948            sta ($29),y
                  iny
                  bne B_8950
                  
                  inx
                  inc $2a
B_8950            cpy $2d
                  bne B_8948
                  
                  cpx $2e
                  bne B_8948
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8959            lda #$00
                  ldx #$08
B_895d            sta $37,x
                  dex
                  bpl B_895d
                  
                  stx $40
                  ldy #$07
B_8966            lda ($41),y
                  sta $002f,y
                  dey
                  bpl B_8966
                  
                  lda $43
                  and #$03
                  beq B_8986
                  
                  asl a
                  tay
B_8976            ldx #$07
                  lsr $40
                  ror $37
B_897c            lsr $2f,x
                  ror $38,x
                  dex
                  bpl B_897c
                  
                  dey
                  bne B_8976
                  
B_8986            rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8987            ldx $44
                  lda $0a00,x
                  sta $45
                  lda $0ac8,x
                  sta $46
                  lda $43
                  and #$fc
                  asl a
                  bcc B_899c
                  
                  inc $46
B_899c            clc
                  adc $45
                  sta $45
                  bcc B_89a5
                  
                  inc $46
B_89a5            rts
; ------------------------------------------------------------------------------------------------------------- ;
B_89a6            ldx #$00
B_89a8            txa
                  pha
                  
                  jsr S_8910
                  
                  pla
                  tax
                  ldy #$00
                  lda ($45),y
                  and $37
                  ora $2f,x
                  sta ($45),y
                  ldy #$08
                  lda ($45),y
                  and $40
                  ora $38,x
                  sta ($45),y
                  inc $44
                  inx
                  cpx #$08
                  bne B_89a8
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_89cb            ldy #$04
B_89cd            lda ($27),y
                  sta $001d,y
                  dey
                  bpl B_89cd
                  
                  tay
                  bne B_89d9
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_89d9            lda #$05
                  
                  jsr S_87e5
                  
                  lda $21
                  and #$07
                  sta $24
                  lda $21
                  and #$f8
                  bpl B_89ef
                  
                  and #$78
                  clc
                  adc #$08
B_89ef            sta $23
                  lda $21
                  
                  jsr S_bfd0
                  
                  nop
                  lda $20
                  lsr a
                  lsr a
                  lsr a
                  lsr a
                  cmp #$0f
                  bne B_8a03
                  
                  ora #$f0
B_8a03            sta $21
                  lda $20
                  and #$0f
                  cmp #$0f
                  bne B_8a0f
                  
                  ora #$f0
B_8a0f            sta $20
                  lda #$00
                  sta $1c
B_8a15            inc $1c
                  lda $1c
                  lsr a
                  ldx $22
                  bcs B_8a20
                  
                  ldx $23
B_8a20            stx $41
                  lda #$a0
                  sta $42
                  lda $1e
                  sta $43
                  lda $1f
                  sta $44
                  
                  jsr S_890d
                  
                  lda #$ff
                  sta $37
                  sta $40
                  lda #$00
                  ldx $24
                  beq B_8a46
                  
B_8a3d            sta $2e,x
                  sta $37,x
                  dex
                  bne B_8a3d
                  
                  stx $24
                  
B_8a46            jsr S_8916
                  
                  dec $1d
                  bne B_8a50
                  
                  jmp B_89cb
                  
B_8a50            clc
                  lda $1e
                  adc $20
                  sta $1e
                  clc
                  lda $1f
                  adc $21
                  sta $1f
                  jmp B_8a15
                  
B_8a61            lda #$00
                  sta $29
                  lda #$40
                  sta $2a
                  lda #$00
                  sta $2d
                  lda #$20
                  sta $2e
                  lda #$00
                  
                  jsr S_890a
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8a77            pha
                  lda #$e8
                  sta $2d
                  lda #$03
                  sta $2e
                  lda #$00
                  sta $29
                  lda #$60
                  sta $2a
                  pla
                  
                  jsr S_890a
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8a8d            pha
                  lda #$e8
                  sta $2d
                  lda #$03
                  sta $2e
                  lda #$00
                  sta $29
                  lda #$d8
                  sta $2a
                  pla
                  
                  jsr S_890a
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8aa3            ldy #$08
                  lda ($27),y
                  tax
                  dex
                  txa
                  sta ($27),y
                  bne B_8b06
                  
                  iny
                  lda ($27),y
                  dey
                  sta ($27),y
                  ldy #$0d
                  lda ($27),y
                  sec
                  adc #$00
                  and #$01
                  sta ($27),y
                  ldy #$0a
                  lda ($27),y
                  tax
                  clc
                  ldy #$01
                  adc ($27),y
                  sta ($27),y
                  sta $19
                  txa
                  bmi B_8ada
                  
                  ldy #$0c
                  lda $19
                  cmp ($27),y
                  bcs B_8ae2
                  bcc B_8aec
B_8ada            ldy #$0b
                  lda $19
                  cmp ($27),y
                  bcs B_8aec
                  
B_8ae2            txa
                  eor #$ff
                  sec
                  adc #$00
                  ldy #$0a
                  sta ($27),y
B_8aec            ldx #$a4
                  lda $4d
                  bne B_8afc
                  
                  ldx #$a2
                  ldy #$0a
                  lda ($27),y
                  bpl B_8afc
                  
                  ldx #$a0
B_8afc            txa
                  ldy #$0d
                  clc
                  adc ($27),y
                  ldy #$03
                  sta ($27),y
B_8b06            rts
; ------------------------------------------------------------------------------------------------------------- ;
S_8b07            txa
                  clc
                  adc $0d01
                  cmp #$a6
                  bcs B_8b17
                  
                  cmp #$0b
                  bcc B_8b17
                  
                  sta $0d01
B_8b17            txa
                  eor $0d0a
                  stx $0d0a
                  bpl B_8b2c
                  
                  lda #$02
                  sta $0d08
                  lda #$01
                  sta $0d09
                  bpl B_8b4b
                  
B_8b2c            lda $0d08
                  clc
                  adc $0d09
                  sta $0d08
                  beq B_8b3c
                  
                  cmp #$04
                  bne B_8b4b
                  
B_8b3c            lda $0d09
                  eor #$ff
                  sec
                  adc #$00
                  sta $0d09
                  lda #$80
                  sta $bb
B_8b4b            ldy #$90
                  txa
                  bmi B_8b52
                  
                  ldy #$95
B_8b52            tya
                  clc
                  adc $0d08
                  sta $0d03
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_8b5b            dec $0d02
                  lda $0d01
                  clc
                  adc $0d0c
                  cmp #$a6
                  bcs B_8b70
                  
                  cmp #$0b
                  bcc B_8b70
                  
                  sta $0d01
B_8b70            dec $0d0d
                  lda $0d0d
                  bne B_8b8a
                  
                  lda #$02
                  sta $0d0b
                  lda $0d02
                  cmp #$19
                  bcs B_8b89
                  
                  lda #$a6
                  sta $0d03
B_8b89            rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8b8a            cmp #$06
                  bcc B_8b94
                  
                  dec $0d0d
                  dec $0d02
B_8b94            ldx #$9a
                  lda $0d0a
                  bmi B_8b9d
                  
                  ldx #$9b
B_8b9d            stx $0d03
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_8ba1            inc $0d0d
                  inc $0d02
                  lda $0d01
                  clc
                  adc $0d0c
                  cmp #$a6
                  bcs B_8bb9
                  
                  cmp #$0b
                  bcc B_8bb9
                  
                  sta $0d01
B_8bb9            lda $0d01
                  sec
                  sbc #$09
                  sta $43
                  lda $0d02
                  sbc #$1e
                  bcc B_8bfa
                  
                  sta $44
                  
                  jsr S_8c44
                  
                  php
                  inc $44
                  plp
                  beq B_8bd8
                  
                  jsr S_8c44
                  
                  beq B_8bfb
                  
B_8bd8            inc $43
                  
                  jsr S_8c44
                  
                  beq B_8bfb
                  
                  lda $0d0d
                  cmp #$05
                  bcc B_8bfa
                  
                  inc $0d02
                  inc $0d0d
                  inc $44
                  jsr S_8c44
                  
                  beq B_8bfb
                  
                  dec $43
                  jsr S_8c44
                  
                  beq B_8bfb
                  
B_8bfa            rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8bfb            dec $44
                  jsr S_8c44
                  
                  beq B_8bfa
                  
                  dec $44
                  jsr S_8c44
                  
                  beq B_8bfa
                  
                  lda $0d0d
                  cmp #$25
                  bcc B_8c1e
                  
                  ldx #$ff
                  stx $4e
                  ldx #$80
                  stx $b9
B_8c18            ldx #$00
                  stx $0d0b
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8c1e            lda $4e
                  bne B_8c18
                  
                  jsr S_8c29
                  jsr S_8e45
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_8c29            lda #$02
                  sta $0d08
                  lda #$00
                  sta $0d0b
                  ldx #$90
                  lda $0d0a
                  bmi B_8c3c
                  
                  ldx #$95
B_8c3c            txa
                  clc
                  adc #$02
                  sta $0d03
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_8c44            jsr S_8910
                  lda $43
                  and #$03
                  tax
                  ldy #$00
                  lda ($45),y
                  and T_8c57,x
                  cmp T_8c57,x
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
T_8c57            .byte $c0
                  .byte $30
                  .byte $0c
                  .byte $03
; ------------------------------------------------------------------------------------------------------------- ;
S_8c5b            inc $0d02
                  lda $0d01
                  clc
                  adc $0d0c
                  sta $0d01
                  ldx $0d0d
                  dex
                  beq B_8c7e
                  
                  dec $0d0d
                  inc $0d02
                  lda $0d01
                  clc
                  adc $0d0c
                  sta $0d01
B_8c7e            ldx #$9a
                  lda $0d0c
                  bmi B_8c91
                  
                  inx
                  lda $0d0c
                  bne B_8c91
                  
                  lda $0d0a
                  bpl B_8c91
                  
                  dex
B_8c91            stx $0d03
                  dec $0d0d
                  bne B_8ca3
                  
                  jsr S_8c29
                  
                  lda $4e
                  bne B_8ca3
                  
                  jsr S_8e45
                  
B_8ca3            rts
; ------------------------------------------------------------------------------------------------------------- ;
S_8ca4            lda $82
                  sta $27
                  lda $83
                  sta $28
B_8cac            ldy #$00
                  lda ($27),y
                  bne B_8cb4
                  
                  clc
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8cb4            iny
                  lda ($27),y
                  tax
                  dex
                  cpx $0d01
                  beq B_8cd8
                  
                  inx
                  cpx $0d01
                  beq B_8cd8
                  
                  inx
                  cpx $0d01
                  beq B_8cd8
                  
B_8cca            clc
                  lda #$04
                  adc $27
                  sta $27
                  bcc B_8cac
                  
                  inc $28
                  jmp B_8cac
                  
B_8cd8            tax
                  iny
                  lda ($27),y
                  cmp $0d02
                  bne B_8cca
                  
                  stx $0d01
                  iny
                  lda ($27),y
                  sta $0d0c
                  ldy #$00
                  lda ($27),y
                  sta $0d0d
                  lda #$04
                  sta $0d0b
                  sec
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8cf8            lda CIAPRB                      ; CIA 1 - $dc01 = Data Port B
                  
                  jsr S_8d13
                  
                  stx $4a
                  
                  jsr S_8d13
                  
                  stx $49
                  
                  jsr S_8d13
                  
                  txa
                  and $4c
                  sta $4b
                  txa
                  eor #$ff
                  sta $4c
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_8d13            ldx #$00
                  lsr a
                  bcs B_8d19
                  
                  dex
B_8d19            lsr a
                  bcs B_8d1d
                  
                  inx
B_8d1d            rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8d1e            ldx $0d0b
                  bne B_8d26
                  
                  jmp B_8d3f
                  
B_8d26            dex
                  bne B_8d2c
                  
                  jmp B_8de5
                  
B_8d2c            dex
                  bne B_8d32
                  
                  jmp B_8de9
                  
B_8d32            dex
                  bne B_8d38
                  
                  jmp B_8d8f
                  
B_8d38            dex
                  bne B_8d3e
                  
                  jmp B_8ded
                  
B_8d3e            rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8d3f            lda $4b
                  beq B_8d46
                  
                  jmp B_8dd6
                  
B_8d46            lda $4a
                  beq B_8d60
                  
                  bpl B_8d53
                  
                  jsr S_8ed9
                  
                  beq B_8d60
                  
                  bne B_8d58
                  
B_8d53            jsr S_8ed0
                  
                  beq B_8d60
                  
B_8d58            lda #$03
                  sta $0d0b
                  jmp B_8d8f
                  
B_8d60            jsr S_8ca4
                  
                  bcc B_8d68
                  
                  jmp B_8ded
                  
B_8d68            ldx $49
                  bne B_8d6d
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8d6d            jsr S_8b07
                  jsr S_8df1
                  
                  lda $0d0b
                  cmp #$02
                  beq B_8d7e
                  
                  jsr S_8e45
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8d7e            jsr S_8c29
                  
                  lda #$02
                  sta $0d0b
                  lda #$00
                  sta $0d0c
                  sta $0d0d
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8d8f            lda $4a
                  bmi B_8d96
                  bne B_8da7
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8d96            dec $0d02
                  lda $47
                  cmp $0d02
                  bcc B_8db1
                  
B_8da0            sta $0d02
                  jsr S_8c29
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8da7            inc $0d02
                  lda $48
                  cmp $0d02
                  bcc B_8da0
                  
B_8db1            lda $0d02
                  sec
                  sbc $47
                  cmp #$06
                  bcs B_8dc9
                  
                  lda $0d02
                  lsr a
                  lsr a
                  ror a
                  lda #$00
                  adc #$9e
                  sta $0d03
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8dc9            lda $0d02
                  lsr a
                  lsr a
                  lda #$00
                  adc #$9c
                  sta $0d03
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8dd6            lda #$01
                  sta $0d0b
                  lda #$11
                  sta $0d0d
                  lda $49
                  sta $0d0c
                  
B_8de5            jsr S_8b5b
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8de9            jsr S_8ba1
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8ded            jsr S_8c5b
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_8df1            jsr S_8f21
                  
                  lda $1b
                  sta $44
                  dec $44
                  lda $19
                  sta $43
                  
                  jsr S_8c44
                  
                  bne B_8e09
                  
                  dec $0d02
                  jmp B_8e44
                  
B_8e09            lda $1a
                  sta $43
                  jsr S_8c44
                  
                  bne B_8e18
                  
                  dec $0d02
                  jmp B_8e44
                  
B_8e18            inc $44
                  lda $19
                  sta $43
                  jsr S_8c44
                  
                  beq B_8e44
                  
                  lda $1a
                  sta $43
                  jsr S_8c44
                  
                  beq B_8e44
                  
                  inc $0d02
                  inc $44
                  jsr S_8c44
                  
                  beq B_8e44
                  
                  lda $19
                  sta $43
                  jsr S_8c44
                  
                  beq B_8e44
                  
                  lda #$02
                  sta $0d0b
B_8e44            rts
; ------------------------------------------------------------------------------------------------------------- ;
S_8e45            jsr S_8f21
                  
                  lda $1b
                  sta $44
                  cmp #$c5
                  bcc B_8e51
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8e51            lda $19
                  sta $43
                  jsr S_8c44
                  
                  bne B_8e71
                  
                  inc $44
                  jsr S_8c44
                  
                  beq B_8e67
                  
                  jsr S_8e96
                  
                  jmp B_8e71
                  
B_8e67            inc $44
                  jsr S_8c44
                  
                  beq B_8e71
                  
                  jsr S_8e96
                  
B_8e71            lda $1a
                  sta $43
                  lda $1b
                  sta $44
                  jsr S_8c44
                  
                  beq B_8e7f
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8e7f            inc $44
                  jsr S_8c44
                  
                  beq B_8e8a
                  
                  jsr S_8e96
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8e8a            inc $44
                  jsr S_8c44
                  
                  bne B_8e92
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8e92            jsr S_8e96
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_8e96            dec $43
                  jsr S_8c44
                  
                  beq B_8ea9
                  
                  inc $44
                  jsr S_8c44
                  
                  bne B_8ea9
                  
                  dec $44
                  jmp S_8e96
                  
B_8ea9            inc $43
                  lda $1b
                  sta $44
                  lda #$30
                  sta $41
                  lda #$a0
                  sta $42
                  jsr S_890d
                  
                  lda #$ff
                  sta $37
                  sta $40
                  jsr S_8916
                  
                  dec $90
                  jsr S_87d9
                  
                  lda #$05
                  sta $5b
                  
                  jsr S_87dc
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_8ed0            ldy #$ff
                  sty $19
                  ldy #$00
                  jmp B_8edd
                  
S_8ed9            ldy #$00
                  sty $19
B_8edd            lda ($80),y
                  bne B_8ee2
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_8ee2            sta $1b
                  iny
                  cmp $0d01
                  beq B_8eff
                  
                  sec
                  adc #$00
                  cmp $0d01
                  beq B_8eff
                  
                  clc
                  adc #$fe
                  cmp $0d01
                  beq B_8eff
                  
                  iny
                  iny
                  jmp B_8edd
                  
B_8eff            lda ($80),y
                  sta $47
                  iny
                  lda ($80),y
                  sta $48
                  iny
                  ldx $19
                  beq B_8f0f
                  
                  lda $47
B_8f0f            sec
                  sbc $0d02
                  bpl B_8f17
                  
                  eor #$ff
B_8f17            and #$fc
                  bne B_8edd
                  
                  lda $1b
                  sta $0d01
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_8f21            ldx #$0a
                  ldy #$07
                  lda $0d08
                  cmp #$02
                  bne B_8f2e
                  
                  dex
                  iny
B_8f2e            stx $19
                  sty $1a
                  sec
                  lda $0d01
                  sbc $19
                  sta $19
                  lda $0d01
                  sbc $1a
                  sta $1a
                  lda $0d02
                  sbc #$1d
                  sta $1b
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_8f49            jmp B_8f5e
S_8f4c            jmp B_905c
S_8f4f            jmp B_907d
S_8f52            jmp B_90bc
S_8f55            jmp B_930d
S_8f58            jmp B_93e8
S_8f5b            jmp B_94a0
; ------------------------------------------------------------------------------------------------------------- ;
B_8f5e            lda #$0f
                  sta $0c72
                  sta $0c73
                  lda #$00
                  sta $a6
                  sta $4e
                  sta $0c51
                  sta $4f
                  sta $4d
                  sta $a8
                  ldx #$1b
B_8f77            sta FRELO1,x                    ; SID - $d400 = Oscillator 1 Frequency Control (low byte)
                  sta $b8,x
                  dex
                  bpl B_8f77
                  
                  lda #$0f
                  sta SIGVOL                      ; SID - $d418 = Volume and Filter Select
                  lda #$0a
                  sta ATDCY3                      ; SID - $d413 = Oscillator 3 Attack/Decay
                  lda #$a0
                  sta SUREL3                      ; SID - $d414 = Oscillator 3 Sustain/Release
                  lda #$8c
                  sta $a0
                  lda $7c
                  sta $27
                  lda $7d
                  sta $28
                  
                  jsr S_8913
                  
                  ldy #$7f
B_8f9f            lda ($7e),y
                  sta $0e00,y
                  dey
                  bpl B_8f9f
                  
                  ldy #$20
B_8fa9            lda $0e00,y
                  beq B_8fb6
                  
                  tya
                  clc
                  adc #$08
                  tay
                  jmp B_8fa9
                  
B_8fb6            sta $0e00,y
                  iny
                  bpl B_8fb6
                  
                  lda #$00
                  sta $23
                  lda #$0e
                  sta $24
B_8fc4            ldy #$00
                  lda ($23),y
                  beq B_8ffb
                  
                  sta $43
                  iny
                  lda ($23),y
                  sta $44
                  iny
                  lda ($23),y
                  and #$f8
                  ldy #$00
                  sty $42
                  asl a
                  rol $42
                  asl a
                  rol $42
                  adc #$80
                  sta $41
                  lda $42
                  adc #$a8
                  sta $42
                  
                  jsr S_87d6
                  
                  clc
                  lda $23
                  adc #$08
                  sta $23
                  bcc B_8fc4
                  
                  inc $24
                  jmp B_8fc4
                  
B_8ffb            lda #$00
                  tax
B_8ffe            sta $0d00,x
                  dex
                  bne B_8ffe
                  
                  tay
B_9005            ldx #$0e
                  iny
                  lda ($84),y
                  beq B_9018
                  
                  dey
B_900d            lda ($84),y
                  sta $0d00,y
                  iny
                  dex
                  bne B_900d
                  beq B_9005
                  
B_9018            lda #$80
                  sta $2b
                  lda #$a0
                  sta $2c
                  lda #$00
                  sta $29
                  lda #$64
                  sta $2a
                  lda #$00
                  sta $2d
                  lda #$0c
                  sta $2e
                  
                  jsr S_8907
                  
                  lda #$20
                  ldx #$27
B_9037            sta $6000,x
                  dex
                  bpl B_9037
                  
                  lda #$0e
                  ldx #$27
B_9041            sta $d800,x
                  dex
                  bpl B_9041
                  
                  lda $91
                  and #$0f
                  sta $9d
                  lda $91
                  lsr a
                  lsr a
                  lsr a
                  lsr a
                  and #$0f
                  sta $9c
                  lda #$5a
                  sta $9e
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_905c            lda #$0e
                  sta $27
                  lda #$0d
                  sta $28
                  lda #$08
                  pha
                  ldy #$00
                  lda ($27),y
                  lsr a
                  bcc B_9071
                  
                  jsr S_8922
                  
B_9071            lda #$0e
                  jsr S_87e5
                  
                  pla
                  sec
                  sbc #$01
                  bne $9066
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_907d            jsr S_914a
                  jsr S_9475
                  
                  dec $9e
                  bne B_90a1
                  
                  lda #$5a
                  sta $9e
                  lda $9d
                  ora $9c
                  beq B_90a1
                  
                  dec $9d
                  bpl B_90a1
                  
                  lda #$09
                  sta $9d
                  dec $9c
                  bpl B_90a1
                  
                  lda #$09
                  sta $9c
B_90a1            lda $4d
                  beq B_90a7
                  
                  dec $4d
B_90a7            lda $9c
                  bne B_90bb
                  
                  lda $9d
                  cmp #$07
                  bcs B_90bb
                  
                  lda $9e
                  and #$0f
                  bne B_90bb
                  
                  lda #$80
                  sta $bc
B_90bb            rts
; ------------------------------------------------------------------------------------------------------------- ;
B_90bc            lda $90
                  beq B_90f0
                  
                  bit $9e
                  bvs B_90ce
                  
                  lda $9d
                  ora $9c
                  bne B_90ce
                  
                  lda #$ff
                  sta $4f
B_90ce            lda $a6
                  cmp #$08
                  beq B_90ea
                  
                  ldx #$8c
                  lda $4c
                  bne B_90e0
                  
                  dec $a0
                  beq B_90e4
                  
                  ldx $a0
B_90e0            stx $a0
                  clc
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_90e4            lda #$80
                  sta $a0
                  sec
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_90ea            lda #$00
                  sta $a0
                  sec
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_90f0            lda $9d
                  ora $9c
                  beq B_90e4
                  
                  dec $9d
                  bpl B_9100
                  
                  lda #$09
                  sta $9d
                  dec $9c
B_9100            jsr S_87d9
                  
                  lda #$01
                  sta $59
                  jsr S_87dc
                  jsr S_87e2
                  jsr S_913f
                  
                  ldx #$0a
B_9112            lda T_9134,x
                  sta FRELO3,x                    ; SID - $d40e = Oscillator 3 Frequency Control (low byte)
                  dex
                  bpl B_9112
                  
B_911b            lda $06
                  eor #$05
                  bne B_911b
                  
                  sta $06
                  sta VCREG3                      ; SID - $d412 = Oscillator 3 Control
B_9126            lda $06
                  eor #$04
                  bne B_9126
                  
                  sta $06
                  sta SIGVOL                      ; SID - $d418 = Volume and Filter Select
                  jmp B_90f0
; ------------------------------------------------------------------------------------------------------------- ;
T_9134            .byte $00
                  .byte $1e
                  .byte $00
                  .byte $08
                  .byte $41
                  .byte $0a
                  .byte $a0
                  .byte $00
                  .byte $00
                  .byte $00
                  .byte $0b
; ------------------------------------------------------------------------------------------------------------- ;
S_913f            ldx #$17
                  lda #$00
B_9143            sta FRELO1,x                    ; SID - $d400 = Oscillator 1 Frequency Control (low byte)
                  dex
                  bpl B_9143
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_914a            ldx #$00
                  
                  jsr S_9292
                  
                  inx
                  jsr S_9292
                  
                  beq B_9159
                  
                  lda #$02
                  bne B_915b
                  
B_9159            lda #$08
B_915b            sta SPMC0                       ; VIC 2 - $d025 = Sprite MultiColor 0
                  inx
                  
                  jsr S_9292
                  
                  inx
                  lda $0d0d
                  ldy $0d0b
                  dey
                  beq B_917b
                  
                  dey
                  beq B_9181
                  
                  
                  dey
                  dey
                  beq B_91a9
                  
                  lda #$00
                  sta $bb,x
                  sta $cf,x
                  beq B_91b9
                  
B_917b            eor #$ff
                  adc #$32
                  bne B_91b2
                  
B_9181            ldy #$32
                  cmp #$06
                  bcc B_919e
                  
                  sbc #$06
                  lsr a
                  ldy #$2c
                  cmp #$08
                  bcc B_919e
                  
                  sbc #$08
                  lsr a
                  ldy #$24
                  cmp #$10
                  bcc B_919e
                  
                  sbc #$10
                  lsr a
                  ldy #$14
B_919e            eor #$ff
                  sta $19
                  tya
                  clc
                  adc $19
                  jmp B_91b2
                  
B_91a9            lsr a
                  adc #$14
                  cmp #$46
                  bcc B_91b2
                  
                  lda #$46
B_91b2            tay
                  
                  jsr S_92a0
                  
                  tya
                  sta $c5,x
B_91b9            inx
                  
                  jsr S_9292
                  
                  beq B_91c9
                  
                  tya
                  lsr a
                  and #$07
                  tay
                  lda T_92db,y
                  sta $c5,x
                  
B_91c9            jsr S_9262
                  
                  lda $4f
                  bne B_91d4
                  
                  sta $b8
                  beq B_9206
                  
B_91d4            lda $b8
                  bne B_91f5
                  
                  dec $b8
                  ldx #$0d
B_91dc            lda T_92e3,x
                  sta FRELO1,x                    ; SID - $d400 = Oscillator 1 Frequency Control (low byte)
                  dex
                  bpl B_91dc
                  
                  lda #$7d
                  sta CUTHI                       ; SID - $d416 = Filter CutOff Frequency (high byte)
                  lda #$f3
                  sta RESON                       ; SID - $d417 = Filter Resonance Control
                  lda #$3f
                  sta SIGVOL                      ; SID - $d418 = Volume and Filter Select
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_91f5            dec $b8
                  ldx #$81
                  stx VCREG1                      ; SID - $d404 = Oscillator 1 Control
                  lsr a
                  lsr a
                  bcc B_9202
                  
                  ldx #$00
B_9202            stx VCREG2                      ; SID - $d40b = Oscillator 2 Control
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9206            lda $b9
                  beq B_923a
                  bpl B_922b
                  
                  lda #$1e
                  sta $b9
                  ldx #$0d
B_9212            lda T_92f1,x
                  sta FRELO1,x                    ; SID - $d400 = Oscillator 1 Frequency Control (low byte)
                  dex
                  bpl B_9212
                  
                  lda #$7d
                  sta CUTHI                       ; SID - $d416 = Filter CutOff Frequency (high byte)
                  lda #$f3
                  sta RESON                       ; SID - $d417 = Filter Resonance Control
                  lda #$3f
                  sta SIGVOL                      ; SID - $d418 = Volume and Filter Select
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_922b            dec $b9
                  lda $b9
                  beq B_9233
                  
                  lda #$81
B_9233            sta VCREG1                      ; SID - $d404 = Oscillator 1 Control
                  sta VCREG2                      ; SID - $d40b = Oscillator 2 Control
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_923a            lda $ba
                  beq B_925b
                  
                  ldx #$0d
B_9240            lda T_92ff,x
                  sta FRELO1,x                    ; SID - $d400 = Oscillator 1 Frequency Control (low byte)
                  dex
                  bpl B_9240
                  
                  inx
                  stx RESON                       ; SID - $d417 = Filter Resonance Control
                  lda $9e
                  ldx #$02
                  and #$04
                  beq B_9257
                  
                  ldx #$05
B_9257            stx FREHI1                      ; SID - $d401 = Oscillator 1 Frequency Control (high byte)
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_925b            sta vcreg1                      ; SID - $d404 = Oscillator 1 Control
                  sta vcreg2                      ; SID - $d40b = Oscillator 2 Control
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_9262            ldx #$01
                  lda $bb,x
                  bne B_9282
                  
                  inx
                  lda $bb,x
                  bne B_9282
                  
                  ldx #$00
                  lda $bb,x
                  bne B_9282
                  
                  ldx #$03
                  lda $bb,x
                  bne B_9282
                  
                  inx
                  lda $bb,x
                  bne B_9282
                  
                  sta VCREG3                      ; SID - $d412 = Oscillator 3 Control
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9282            lda $c5,x
                  sta FREHI3                      ; SID - $d40f = Oscillator 3 Frequency Control (high byte)
                  lda $ca,x
                  sta PWHI3                       ; SID - $d411 = Oscillator 3 Pulse WaveForm Width (high nybble)
                  lda $cf,x
                  sta VCREG3                      ; SID - $d412 = Oscillator 3 Control
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_9292            lda $bb,x
                  beq B_929f
                  bpl B_929c
                  
                  jsr S_92a0
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_929c            jsr S_92b9
B_929f            rts
; ------------------------------------------------------------------------------------------------------------- ;
S_92a0            lda #$01
                  sta $bb,x
                  lda T_92c7,x
                  sta $c0,x
                  lda T_92cc,x
                  sta $c5,x
                  lda T_92d1,x
                  sta $ca,x
                  lda T_92d6,x
                  sta $cf,x
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_92b9            lda $c0,x
                  tay
                  dey
                  tya
                  sta $c0,x
                  bne B_92c6
                  
                  sta $bb,x
                  sta $cf,x
B_92c6            rts
; ------------------------------------------------------------------------------------------------------------- ;
T_92c7            .byte $02
                  .byte $04
                  .byte $07
                  .byte $01
                  .byte $23
                  
T_92cc            .byte $13
                  .byte $19
                  .byte $54
                  .byte $2d
                  .byte $38
                  
T_92d1            .byte $00
                  .byte $00
                  .byte $02
                  .byte $08
                  .byte $02
                  
T_92d6            .byte $81
                  .byte $11
                  .byte $41
                  .byte $41
                  .byte $41
                  
T_92db            .byte $4f
                  .byte $64
                  .byte $5e
                  .byte $59
                  .byte $70
                  .byte $6a
                  .byte $54
                  .byte $77
                  
T_92e3            .byte $00
                  .byte $03
                  .byte $00
                  .byte $00
                  .byte $00
                  .byte $1d
                  .byte $b0
                  .byte $80
                  .byte $02
                  .byte $00
                  .byte $00
                  .byte $00
                  .byte $1f
                  .byte $f2
                  
T_92f1            .byte $80
                  .byte $03
                  .byte $00
                  .byte $00
                  .byte $00
                  .byte $0d
                  .byte $5b
                  .byte $00
                  .byte $03
                  .byte $00
                  .byte $00
                  .byte $00
                  .byte $1c
                  .byte $3b
                  
T_92ff            .byte $d2
                  .byte $02
                  .byte $00
                  .byte $04
                  .byte $41
                  .byte $0a
                  .byte $a0
                  .byte $fa
                  .byte $01
                  .byte $00
                  .byte $08
                  .byte $41
                  .byte $0a
                  .byte $a0
; ------------------------------------------------------------------------------------------------------------- ;
B_930d            lda #$00
                  sta $27
                  lda #$0e
                  sta $28
B_9315            ldy #$00
                  lda ($27),y
                  bne B_931c
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_931c            ldy #$03
                  lda ($27),y
                  beq B_933f
                  
                  iny
                  lda $0d01
                  cmp ($27),y
                  bcc B_933f
                  
                  iny
                  cmp ($27),y
                  bcs B_933f
                  
                  iny
                  lda $0d02
                  cmp ($27),y
                  bcc B_933f
                  
                  iny
                  cmp ($27),y
                  bcs B_933f
                  
                  jsr S_9347
                  
B_933f            lda #$08
                  jsr S_87e5
                  
                  jmp B_9315
                  
S_9347            ldy #$00
                  lda ($27),y
                  sta $43
                  iny
                  lda ($27),y
                  sta $44
                  lda #$60
                  sta $41
                  lda #$ac
                  sta $42
                  
                  jsr S_87d6
                  jsr S_87d9
                  
                  ldy #$03
                  lda ($27),y
                  tax
                  and #$0f
                  sta $59
                  txa
                  lsr a
                  lsr a
                  lsr a
                  lsr a
                  and #$01
                  sta $58
                  
                  jsr S_87dc
                  
                  ldx #$0d
B_9377            lda T_93df,x
                  sta $0c52,x
                  dex
                  bpl B_9377
                  
                  ldy #$00
                  lda ($27),y
                  adc #$0c
                  sta $0c53
                  iny
                  lda ($27),y
                  adc #$32
                  sta $0c54
                  iny
                  iny
                  lda ($27),y
                  lsr a
                  lsr a
                  lsr a
                  lsr a
                  lsr a
                  clc
                  adc #$aa
                  sta $0c55
                  lda #$00
                  sta ($27),y
                  dey
                  lda ($27),y
                  and #$03
                  bne B_93b9
                  
                  ldx #$0d
B_93ad            lda $0c52,x
                  sta $0d7e,x
                  dex
                  bpl B_93ad
                  
                  jmp B_93d6
                  
B_93b9            cmp #$01
                  bne B_93cb
                  
                  ldx #$0d
B_93bf            lda $0c52,x
                  sta $0d8c,x
                  dex
                  bpl B_93bf
                  
                  jmp B_93d6
                  
B_93cb            ldx #$0d
B_93cd            lda $0c52,x
                  sta $0d9a,x
                  dex
                  bpl B_93cd
                  
B_93d6            lda #$b4
                  sta $4d
                  lda #$80
                  sta $bd
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
T_93df            .byte $fe
                  .byte $00
                  .byte $00
                  .byte $00
                  .byte $0e
                  .byte $00
                  .byte $00
                  .byte $00
                  .byte $32
; ------------------------------------------------------------------------------------------------------------- ;
B_93e8            lda $4f
                  bne B_9427
                  ldx $07
                  sta $07
                  txa
                  and $0c72
                  beq B_9409
                  
                  tax
                  eor #$0f
                  and $0c72
                  sta $0c72
                  lda $4d
                  beq B_9428
                  
                  txa
                  ldx #$5e
                  
                  jsr S_942d
                  
B_9409            lda $08
                  ldx #$00
                  stx $08
                  and $0c73
                  beq B_9427
                  
                  tax
                  eor #$0f
                  and $0c73
                  sta $0c73
                  lda $4d
                  beq B_9428
                  
                  txa
                  ldx #$6e
                  jsr S_942d
                  
B_9427            rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9428            lda #$ff
                  sta $4f
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_942d            sta $19
                  stx $1a
                  lda #$04
                  sta $1b
B_9435            lsr $19
                  bcc B_946c
                  
                  ldx $1a
                  lda $00,x
                  sta $27
                  lda $01,x
                  sta $28
                  ldy #$00
                  lda ($27),y
                  lsr a
                  bcc B_946c
                  
                  asl a
                  sta ($27),y
                  ldy #$03
                  lda #$a9
                  sta ($27),y
                  iny
                  lda #$0e
                  sta ($27),y
                  ldy #$08
                  lda #$32
                  sta ($27),y
                  
                  jsr S_87d9
                  
                  lda #$09
                  sta $5a
                  
                  jsr S_87dc
                  
                  lda #$80
                  sta $b9
B_946c            inc $1a
                  inc $1a
                  dec $1b
                  bne B_9435
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_9475            lda #$0e
                  sta $27
                  lda #$0d
                  sta $28
                  ldx #$0b
B_947f            ldy #$00
                  lda ($27),y
                  beq B_9497
                  
                  lsr a
                  bcs B_9497
                  
                  ldy #$08
                  lda ($27),y
                  adc #$ff
                  sta ($27),y
                  bne B_9497
                  
                  ldy #$00
                  tya
                  sta ($27),y
B_9497            lda #$0e
                  
                  jsr S_87e5
                  
                  dex
                  bne B_947f
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_94a0            jsr S_8925
                  
                  lda $4f
                  beq B_94d4
                  
                  sta $4e
                  lda #$04
                  sta $0d04
                  lda #$02
                  sta SPMC0                       ; VIC 2 - $d025 = Sprite MultiColor 0
                  lda $0d06
                  eor #$ff
                  sta $0d06
                  lda $0d0b
                  cmp #$03
                  bne B_94d4
                  
                  lda #$02
                  sta $0d0b
                  sta $0d08
                  lda #$00
                  sta $0d0c
                  lda #$9a
                  sta $0d03
B_94d4            lda $4e
                  beq B_94e0
                  
                  lda #$00
                  sta $49
                  sta $4a
                  sta $4b
B_94e0            lda $8a
                  beq B_94e7
                  
                  jsr S_9556
                  
B_94e7            lda $a6
                  bne B_951c
                  
                  lda $4e
                  beq B_94ff
                  
                  lda $0d0b
                  beq B_9507
                  
                  cmp #$05
                  bne B_94ff
                  
                  lda $0d02
                  cmp #$ca
                  beq B_9507
                  
B_94ff            lda $a8
                  bne B_9506
                  
                  jsr S_8928
                  
B_9506            rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9507            lda $0d03
                  ldx #$00
                  stx $a4
                  lsr a
                  ror $a4
                  lsr a
                  ror $a4
                  ora #$40
                  sta $a5
                  lda #$3e
                  sta $a6
B_951c            inc $0d02
                  inc $0c51
                  ldx #$00
                  ldy $a6
                  dey
                  lda ($a4),y
                  sta $19
                  txa
                  sta ($a4),y
                  sta $6fc0,y
                  dey
                  lda ($a4),y
                  sta $1a
                  txa
                  sta ($a4),y
                  sta $6fc0,y
                  dey
                  sty $a6
                  dey
                  lda ($a4),y
                  ora $19
                  sta ($a4),y
                  dey
                  lda ($a4),y
                  ora $1a
                  sta ($a4),y
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
                  .byte $ff
                  .byte $ff
; ------------------------------------------------------------------------------------------------------------- ;
S_9550            jmp B_9565
S_9553            jmp B_9601
S_9556            jmp B_9650
S_9559            jmp B_97c0
S_955c            jmp B_98c3
S_955f            jmp B_95c1
S_9562            jmp B_98f6
; ------------------------------------------------------------------------------------------------------------- ;
B_9565            lda $8b
                  sta $43
                  lda #$1b
                  sta $44
                  lda #$40
                  sta $41
                  lda #$75
                  sta $42
                  
                  jsr S_95bd
                  
                  lda $8b
                  sta $43
                  lda #$49
                  sta $44
                  lda #$30
                  sta $41
                  lda #$75
                  sta $42
                  
                  jsr S_95bd
                  
                  lda $8b
                  sta $43
                  lda #$77
                  sta $44
                  lda #$20
                  sta $41
                  lda #$75
                  sta $42
                  
                  jsr S_95bd
                  
                  lda $8b
                  sta $43
                  lda #$a5
                  sta $44
                  lda #$10
                  sta $41
                  lda #$75
                  sta $42
                  
                  jsr S_95bd
                  
                  lda #$00
                  sta $ae
                  sta $a7
                  lda #$5a
                  
                  jsr S_9789
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_95bd            ldx #$00
                  ldy #$aa
                  
B_95c1            stx $19
                  sty $1a
                  lda $44
                  pha
                  
                  jsr S_890d
                  jsr S_95eb
                  jsr S_8916
                  
                  pla
                  sta $44
                  lda $43
                  clc
                  adc #$04
                  sta $43
                  lda $41
                  adc #$08
                  sta $41
                  jsr S_890d
                  jsr S_95eb
                  jsr S_8916
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_95eb            ldx #$07
B_95ed            lda $2f,x
                  eor $19
                  and $1a
                  sta $2f,x
                  lda $38,x
                  eor $19
                  and $1a
                  sta $38,x
                  dex
                  bpl B_95ed
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9601            and #$0f
                  sta $19
                  dex
                  bne B_960f
                  
                  ldx #$20
                  ldy #$63
                  jmp B_9627
                  
B_960f            dex
                  bne B_9619
                  
                  ldx #$30
                  ldy #$62
                  jmp B_9627
                  
B_9619            dex
                  bne B_9623
                  
                  ldx #$68
                  ldy #$61
                  jmp B_9627
                  
B_9623            ldx #$78
                  ldy #$60
B_9627            sty $1b
                  clc
                  txa
                  adc $8a
                  sta $1a
                  bcc B_9633
                  
                  inc $1b
B_9633            lda $1a
                  clc
                  adc #$28
                  sta $1c
                  lda $1b
                  adc #$00
                  sta $1d
                  ldy #$02
B_9642            lda ($1a),y
                  and #$f0
                  ora $19
                  sta ($1a),y
                  sta ($1c),y
                  dey
                  bpl B_9642
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9650            lda $ae
                  beq B_965e
                  
                  dec $ae
                  beq B_9659
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9659            lda #$5a
                  
                  jsr S_9789
                  
B_965e            lda $0d0b
                  beq B_9664
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9664            lda $0d01
                  cmp $8c
                  bcc B_966f
                  
                  cmp $8d
                  bcc B_9679
                  
B_966f            lda #$00
                  sta $a8
                  sta $a7
                  
                  jsr S_96d3
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9679            lda $a8
                  bne B_9698
                  
                  lda $a7
                  bne B_9684
                  
                  jsr S_9708
                  
B_9684            lda $4b
                  beq B_9690
                  
                  lda $49
                  bne B_9690
                  
                  jsr S_9734
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9690            dec $a9
                  bne B_9697
                  
                  jsr S_9708
                  
B_9697            rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9698            lda #$00
                  sta $49
                  sta $4a
                  sta $4b
                  ldy #$3f
B_96a2            lda $6fc0,y
                  sta ($aa),y
                  dey
                  bpl B_96a2
                  
                  dec $a9
                  bne B_96c1
                  
                  lda #$00
                  sta $0d7e
                  sta $a8
                  sta $a7
                  lda #$3c
                  sta $ae
                  lda #$aa
                  
                  jsr S_9789
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_96c1            lda #$80
                  sta $ad
                  inc $ac
                  ldy #$3f
B_96c9            lda ($aa),y
                  and ($ac),y
                  sta ($aa),y
                  dey
                  bpl B_96c9
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_96d3            ldx #$01
                  lda #$0a
                  cpx $a7
                  bne B_96dd
                  
                  lda #$01
B_96dd            jsr S_9553
                  
                  ldx #$02
                  lda #$0a
                  cpx $a7
                  bne B_96ea
                  
                  lda #$01
B_96ea            jsr S_9553
                  
                  ldx #$03
                  lda #$0a
                  cpx $a7
                  bne B_96f7
                  
                  lda #$01
B_96f7            jsr S_9553
                  
                  ldx #$04
                  lda #$0a
                  cpx $a7
                  bne B_9704
                  
                  lda #$01
B_9704            jsr S_9553
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_9708            ldx #$01
                  lda $0d02
                  cmp #$e4
                  beq B_971c
                  
                  inx
                  cmp #$b6
                  beq B_971c
                  
                  inx
                  cmp #$88
                  beq B_971c
                  
                  inx
B_971c            inc $a7
                  lda $a7
                  cmp #$05
                  bcc B_9728
                  
                  lda #$01
                  sta $a7
B_9728            cpx $a7
                  beq B_971c
                  
                  jsr S_96d3
                  
                  lda #$30
                  sta $a9
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_9734            lda #$80
                  sta $bf
                  lda #$23
                  sta $a9
                  lda #$ff
                  sta $a8
                  ldx #$0d
B_9742            lda $0d00,x
                  sta $0d7e,x
                  dex
                  bpl B_9742
                  
                  ldx $a7
                  lda #$e4
                  dex
                  beq B_975e
                  
                  lda #$b6
                  dex
                  beq B_975e
                  
                  lda #$88
                  dex
                  beq B_975e
                  
                  lda #$5a
B_975e            sta $0d02
                  lda $0d03
                  sta $ab
                  lda #$00
                  sta $49
                  sta $4a
                  sta $4b
                  lsr $ab
                  ror a
                  lsr $ab
                  ror a
                  adc #$00
                  sta $aa
                  lda $ab
                  adc #$40
                  sta $ab
                  ldy #$3f
B_9780            lda ($aa),y
                  sta $6fc0,y
                  dey
                  bpl B_9780
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_9789            and #$f0
                  sta $1a
                  ldx #$18
                  stx $19
                  lda #$28
                  sta $27
                  lda #$60
                  sta $28
B_9799            ldx #$05
                  ldy $8a
                  dey
B_979e            lda ($27),y
                  and #$0f
                  ora $1a
                  sta ($27),y
                  iny
                  dex
                  bne B_979e
                  
                  dec $19
                  beq B_97bc
                  
                  lda $27
                  clc
                  adc #$28
                  sta $27
                  bcc B_9799
                  
                  inc $28
                  jmp B_9799
                  
B_97bc            jsr S_96d3
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_97c0            lda #$00
                  sta $27
                  lda #$0c
                  sta $28
B_97c8            ldy #$00
                  lda ($27),y
                  bne B_97cf
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_97cf            iny
                  lda ($27),y
                  beq B_97dc
                  
                  sec
                  sbc #$01
                  sta ($27),y
                  jmp B_9808
                  
B_97dc            ldy #$08
B_97de            lda ($27),y
                  sta $001b,y
                  dey
                  bpl B_97de
                  
                  lda $1d
                  sta $1c
                  
                  jsr S_9816
                  jsr S_98a6
                  jsr S_98b5
                  
                  bcc B_97fe
                  
                  lda $1f
                  eor #$ff
                  sec
                  adc #$00
                  sta $1f
B_97fe            ldy #$08
B_9800            lda $001b,y
                  sta ($27),y
                  dey
                  bpl B_9800
                  
B_9808            clc
                  lda #$09
                  adc $27
                  sta $27
                  bcc B_97c8
                  
                  inc $28
                  jmp B_97c8
                  
S_9816            lda #$03
                  sta $19
                  lda $22
                  clc
                  adc $1f
                  sta $22
                  lda $1b
                  sta $44
                  lda $1f
                  bne B_982a
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_982a            bmi B_985e
                  
                  ldx $22
                  dex
                  stx $43
                  
B_9831            jsr S_8910
                  
                  ldx $23
                  inx
                  ldy #$00
                  sty $1a
B_983b            lda ($45),y
                  ror $1a
                  ror a
                  ror $1a
                  ror a
                  sta ($45),y
                  rol $1a
                  lda #$00
                  bcc B_984d
                  
                  lda #$03
B_984d            sta $1a
                  clc
                  tya
                  adc #$08
                  tay
                  dex
                  bne B_983b
                  
                  inc $44
                  dec $19
                  bne B_9831
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_985e            lda $22
                  sta $43
                  
B_9862            jsr S_8910
                  
                  lda $23
                  asl a
                  asl a
                  asl a
                  tay
                  lda #$00
                  sta $1a
B_986f            lda ($45),y
                  rol $1a
                  rol a
                  rol $1a
                  rol a
                  sta ($45),y
                  lda #$00
                  bcc B_987f
                  
                  lda #$c0
B_987f            sta $1a
                  tya
                  sec
                  sbc #$08
                  tay
                  bpl B_986f
                  
                  inc $44
                  dec $19
                  bne B_9862
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_988f            clc
                  lda $0d0b
                  bne B_98a5
                  
                  lda $0d02
                  sec
                  sbc $0c51
                  sec
                  sbc #$1d
                  cmp $1b
                  clc
                  bne B_98a5
                  
                  sec
B_98a5            rts
; ------------------------------------------------------------------------------------------------------------- ;
S_98a6            jsr S_988f
                  
                  bcc B_98b4
                  
                  lda $0d01
                  clc
                  adc $1f
                  sta $0d01
B_98b4            rts
; ------------------------------------------------------------------------------------------------------------- ;
S_98b5            lda $22
                  ldx $1f
                  bmi B_98be
                  
                  cmp $21
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_98be            lda $20
                  cmp $22
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_98c3            stx $27
                  sty $28
B_98c7            ldy #$00
                  lda ($88),y
                  bne B_98ce
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_98ce            sta $43
                  iny
                  lda ($88),y
                  sta $44
                  iny
                  lda ($88),y
                  asl a
                  sta $41
                  lda #$00
                  adc #$72
                  sta $42
                  ldx $27
                  ldy $28
                  jsr S_955f
                  
                  clc
                  lda $88
                  adc #$03
                  sta $88
                  bcc B_98c7
                  
                  inc $89
                  jmp B_98c7
                  
B_98f6            lda #$00
                  sta $27
                  lda #$0c
                  sta $28
B_98fe            ldy #$00
                  lda ($27),y
                  beq B_9952
                  
                  sta $1b
                  ldy #$04
                  lda ($27),y
                  bne B_9921
                  
                  jsr S_988f
                  
                  bcc B_9944
                  
                  ldx $0d01
                  lda #$ff
                  cpx #$64
                  bcs B_991c
                  
                  lda #$01
B_991c            sta ($27),y
                  jmp B_9944
                  
B_9921            ldy #$08
B_9923            lda ($27),y
                  sta $001b,y
                  dey
                  bne B_9923
                  
                  jsr S_9816
                  jsr S_98a6
                  jsr S_98b5
                  
                  bcc B_993a
                  
                  lda #$00
                  sta $1f
B_993a            ldy #$08
B_993c            lda $001b,y
                  sta ($27),y
                  dey
                  bpl B_993c
                  
B_9944            clc
                  lda $27
                  adc #$09
                  sta $27
                  bcc B_98fe
                  
                  inc $28
                  jmp B_98fe
                  
B_9952            lda #$80
                  sta $27
                  lda #$46
                  sta $28
                  lda #$10
                  sta $19
                  
B_995e            ldy #$0f
B_9960            lda ($27),y
                  ora #$aa
                  sta ($27),y
                  dey
                  bpl B_9960
                  
                  dec $19
                  bne B_996e
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_996e            clc
                  lda $27
                  adc #$40
                  sta $27
                  lda $28
                  adc #$01
                  sta $28
                  jmp B_995e
S_997e            jmp B_9990
S_9981            jmp B_99e8
S_9984            jmp B_9af7
S_9987            jmp B_9aa7
S_998a            jmp B_9acf
S_998d            jmp B_9b4d
; ------------------------------------------------------------------------------------------------------------- ;
B_9990            lda $0d0b
                  bne B_99e3
                  
                  lda $b0
                  clc
                  adc #$1d
                  cmp $0d02
                  bne B_99e3
                  
                  lda $0d01
                  cmp #$44
                  bcc B_99e3
                  
                  cmp #$80
                  bcs B_99e3
                  
                  lda $4f
                  ora $4e
                  bne B_99e3
                  
                  lda CIAPRB                      ; CIA 1 - $dc01 = Data Port B
                  eor #$ff
                  and #$10
                  and $4c
                  bne B_99bc
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_99bc            inc $b1
                  lda $b1
                  bne B_99cb
                  
                  sta $4c
                  sta $ba
                  lda #$01
                  jmp B_99da
                  
B_99cb            cmp #$02
                  beq B_99d0
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_99d0            lda #$80
                  sta $ba
                  lda #$ff
                  sta $b1
                  lda #$0a
B_99da            ldx #$10
B_99dc            sta $dba6,x
                  dex
                  bpl B_99dc
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_99e3            lda #$01
                  sta $b1
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_99e8            jsr S_8925
                  
                  lda $49
                  beq B_9a1d
                  bmi B_9a08
                  
                  lda $af
                  cmp #$68
                  bcs B_9a1d
                  
                  sta $43
                  lda $b0
                  sta $44
                  inc $af
                  inc $0d01
                  
                  jsr S_9987
                  
                  jmp B_9a1d
                  
B_9a08            ldx $af
                  cpx #$3f
                  bcc B_9a1d
                  
                  dex
                  stx $af
                  stx $43
                  lda $b0
                  sta $44
                  dec $0d01
                  
                  jsr S_998a
                  
B_9a1d            lda $4a
                  bne B_9a22
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9a22            bpl B_9a6f
                  
                  ldx $b0
                  cpx #$69
                  bcs B_9a2b
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9a2b            dec $0d02
                  dex
                  stx $b0
                  stx $44
                  lda $af
                  sta $43
                  
                  jsr S_8910
                  
                  lda $45
                  sta $27
                  lda $46
                  sta $28
                  inc $44
                  inc $44
                  inc $44
                  
                  jsr S_8910
                  
                  lda $45
                  sta $25
                  lda $46
                  sta $26
                  lda $44
                  clc
                  adc #$07
                  sta $44
                  
                  jsr S_8910
                  
                  ldy #$20
B_9a5f            lda ($25),y
                  sta ($27),y
                  lda ($45),y
                  sta ($25),y
                  tya
                  sec
                  sbc #$08
                  tay
                  bpl B_9a5f
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9a6f            ldx $b0
                  cpx #$ad
                  bcc B_9a76
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9a76            inc $0d02
                  inc $b0
                  stx $44
                  lda $af
                  sta $43
                  
                  jsr S_8910
                  
                  lda $45
                  sta $27
                  lda $46
                  sta $28
                  inc $44
                  inc $44
                  inc $44
                  
                  jsr S_8910
                  
                  ldy #$20
B_9a97            lda ($27),y
                  sta ($45),y
                  lda #$00
                  sta ($27),y
                  tya
                  sec
                  sbc #$08
                  tay
                  bpl B_9a97
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9aa7            jsr S_8910
                  
                  ldy #$00
                  sty $19
B_9aae            lda ($45),y
                  ror $19
                  ror a
                  ror $19
                  ror a
                  rol $19
                  rol $19
                  sta ($45),y
                  tya
                  clc
                  adc #$08
                  tay
                  cpy #$21
                  bcc B_9aae
                  
                  ldx $44
                  inx
                  stx $44
                  cpx #$c3
                  bcc B_9aa7
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9acf            jsr S_8910
                  
                  lda #$00
                  sta $19
                  ldy #$20
B_9ad8            lda ($45),y
                  rol $19
                  rol a
                  rol $19
                  rol a
                  ror $19
                  ror $19
                  sta ($45),y
                  tya
                  sec
                  sbc #$08
                  tay
                  bpl B_9ad8
                  
                  ldx $44
                  inx
                  stx $44
                  cpx #$c3
                  bcc B_9acf
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9af7            lda $0d90
                  and #$07
                  tax
                  inx
                  stx $0d90
                  stx $0d9e
                  lda $0d94
                  bmi B_9b18
                  
                  inc $0d8d
                  inc $0d9b
                  lda $0d8d
                  cmp #$6c
                  bcc B_9b2d
                  bcs B_9b25
                  
B_9b18            dec $0d8d
                  dec $0d9b
                  lda $0d8d
                  cmp #$2c
                  bcs B_9b2d
                  
B_9b25            lda $0d94
                  eor #$ff
                  sta $0d94
B_9b2d            lda $0d02
                  cmp #$d7
                  bcs B_9b35
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9b35            lda $0d01
                  sec
                  sbc $0d8d
                  bmi B_9b43
                  
                  cmp #$1e
                  bcc B_9b48
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9b43            adc $06
                  bpl B_9b48
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9b48            lda #$ff
                  sta $4f
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9b4d            lda #$74
                  sta $27
                  lda #$0c
                  sta $28
B_9b55            ldy #$02
B_9b57            lda ($27),y
                  sta $001b,y
                  dey
                  bpl B_9b57
                  
                  tax
                  beq B_9bcc
                  
                  lda $1d
                  bmi B_9b70
                  
                  dec $1d
                  bne B_9b8f
                  
                  lda #$c0
                  sta $1d
                  bne B_9b8f
                  
B_9b70            asl a
                  bpl B_9b82
                  
                  jsr S_9bee
                  
                  lda $1c
                  cmp #$c0
                  bne B_9b8f
                  
                  lda #$80
                  sta $1d
                  bne B_9b8f
                  
B_9b82            jsr S_9c18
                  
                  lda $1c
                  cmp #$ac
                  bne B_9b8f
                  
                  lda #$55
                  sta $1d
B_9b8f            lda $1b
                  clc
                  adc #$05
                  cmp $0d01
                  bcs B_9bb4
                  
                  adc #$13
                  cmp $0d01
                  bcc B_9bb4
                  
                  lda $1c
                  adc #$2c
                  cmp $0d02
                  bcs B_9bb4
                  
                  adc #$04
                  cmp $0d02
                  bcc B_9bb4
                  
                  lda #$ff
                  sta $4f
B_9bb4            ldy #$02
B_9bb6            lda $001b,y
                  sta ($27),y
                  dey
                  bpl B_9bb6
                  
                  clc
                  lda $27
                  adc #$03
                  sta $27
                  bcc B_9b55
                  
                  inc $28
                  jmp B_9b55
                  
B_9bcc            lda $6353
                  and #$f0
                  cmp #$60
                  bcc B_9bd7
                  
                  lda #$10
B_9bd7            clc
                  adc #$10
                  ora #$02
                  ldx #$14
B_9bde            sta $6353,x
                  sta $637b,x
                  sta $63a3,x
                  sta $63cb,x
                  dex
                  bpl B_9bde
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_9bee            inc $1c
                  lda $1c
                  
                  jsr S_9c35
                  
                  lda $45
                  sta $21
                  lda $46
                  sta $22
                  dec $44
                  
                  jsr S_8910
                  
                  ldy #$10
B_9c04            lda ($23),y
                  sta ($25),y
                  lda ($21),y
                  sta ($23),y
                  lda ($45),y
                  sta ($21),y
                  tya
                  sec
                  sbc #$08
                  tay
                  bpl B_9c04
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_9c18            lda $1c
                  dec $1c
                  
                  jsr S_9c35
                  
                  ldy #$10
B_9c21            lda ($23),y
                  sta ($45),y
                  lda ($25),y
                  sta ($23),y
                  lda #$00
                  sta ($25),y
                  tya
                  sec
                  sbc #$08
                  tay
                  bpl B_9c21
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_9c35            sta $44
                  lda $1b
                  sta $43
                  
                  jsr S_8910
                  
                  lda $45
                  sta $25
                  lda $46
                  sta $26
                  dec $44
                  dec $44
                  
                  jsr S_8910
                  
                  lda $45
                  sta $23
                  lda $46
                  sta $24
                  dec $44
                  dec $44
                  
                  jsr S_8910
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_9c5d            jmp B_9d42
S_9c60            jmp B_9ca9
S_9c63            jmp B_9c6c
S_9c66            jmp B_9d1a
S_9c69            jmp B_9d29
; ------------------------------------------------------------------------------------------------------------- ;
B_9c6c            ldx $0d01
                  ldy $0d02
                  cpy #$87
                  bcc B_9c82
                  
                  cpx #$41
                  bne B_9c83
                  
                  cpy #$e4
                  beq B_9c82
                  
                  inx
                  stx $0d01
B_9c82            rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9c83            bcs B_9c82
                  
                  cpx #$39
                  bcc B_9c92
                  bne B_9ca4
                  
                  cpy #$e1
                  bcs B_9ca4
                  
                  dex
                  bne B_9c97
                  
B_9c92            cpx #$0e
                  bcs B_9c9a
                  
                  inx
B_9c97            stx $0d01
B_9c9a            cpy #$9d
                  bcs B_9ca3
                  
B_9c9e            ldy #$01
                  sty $0d0d
B_9ca3            rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9ca4            cpy #$e4
                  bcc B_9c9e
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9ca9            ldx $0d7e
                  ldy $0d86
                  lda $0d81
                  
                  jsr S_9cce
                  
                  ldx $0d8c
                  ldy $0d94
                  lda $0d8f
                  
                  jsr S_9cce
                  
                  ldx $0d9a
                  ldy $0da2
                  lda $0d9d
                  
                  jsr S_9cce
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_9cce            cpy #$32
                  bne B_9cd6
                  
                  cpx #$fe
                  beq B_9cd7
                  
B_9cd6            rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9cd7            sec
                  sbc #$a9
                  tax
                  clc
                  adc $b5
                  sta $b5
                  txa
                  adc $b6
                  sta $b6
                  cmp #$0a
                  bcc B_9cf1
                  
                  adc #$05
                  and #$0f
                  sta $b6
                  inc $b7
B_9cf1            lda $b7
                  beq B_9cfe
                  
                  ora #$30
                  ldx #$5a
                  ldy #$10
                  
                  jsr S_9c66
                  
B_9cfe            lda $b6
                  ora #$30
                  ldx #$62
                  ldy #$10
                  
                  jsr S_9c66
                  
                  lda $b5
                  cmp #$04
                  bcc B_9d19
                  
                  ldx #$0e
                  lda #$aa
B_9d13            sta $6129,x
                  dex
                  bpl B_9d13
                  
B_9d19            rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9d1a            stx $43
                  sty $44
                  
                  jsr S_9c69
                  
                  ldx #$00
                  ldy #$aa
                  
                  jsr S_955f
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9d29            and #$3f
                  ldx #$00
                  stx $42
                  asl a
                  asl a
                  asl a
                  rol $42
                  asl a
                  rol $42
                  adc #$00
                  sta $41
                  lda $42
                  adc #$72
                  sta $42
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9d42            ldx $b4
                  bne B_9d77
                  
                  jsr S_9e55
                  
                  lda $0d0b
                  cmp #$02
                  bne B_9d76
                  
                  lda $0d01
                  cmp #$7f
                  bcc B_9d76
                  
                  cmp #$82
                  bcs B_9d76
                  
                  lda $0d02
                  cmp #$b5
                  bcc B_9d76
                  
                  cmp #$bd
                  bcs B_9d76
                  
                  lda $b5
                  beq B_9d76
                  
                  inc $b4
                  lda #$ff
                  sta $0d05
                  lda #$80
                  sta $0d01
B_9d76            rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9d77            dex
                  bne B_9d89
                  
                  lda $0d02
                  cmp #$ca
                  bcc B_9d76
                  
                  lda #$05
                  sta $0d0b
                  inc $b4
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9d89            dex
                  bne B_9dd4
                  
                  lda #$80
                  sta $ba
                  lda $4b
                  beq B_9dc6
                  
                  lda #$00
                  sta $ba
                  lda #$80
                  sta $b9
                  lda #$20
                  ldx #$5a
                  ldy #$10
                  
                  jsr S_9c66
                  
                  lda #$20
                  ldx #$62
                  ldy #$10
                  
                  jsr S_9c66
                  
                  lda #$98
                  ldx $b5
                  dex
                  beq B_9dc1
                  
                  lda #$6d
                  dex
                  beq B_9dc1
                  
                  lda #$45
                  dex
                  beq B_9dc1
                  
                  lda #$1b
B_9dc1            sta $b2
                  inc $b4
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9dc6            lda $49
                  beq B_9dcf
                  bmi B_9dd0
                  
                  jsr S_9e55
                  
B_9dcf            rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9dd0            jsr S_9e18
                  
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9dd4            lda $0d02
                  sec
                  sbc $b2
                  bcc B_9e00
                  
                  ldx #$fd
                  cmp #$0a
                  bcc B_9dee
                  
                  dex
                  cmp #$1e
                  bcc B_9dee
                  
                  dex
                  cmp #$50
                  bcc B_9dee
                  
                  dex
                  dex
B_9dee            txa
                  clc
                  adc $0d02
                  sta $0d02
                  cmp #$b9
                  bcs B_9dff
                  
                  lda #$00
                  sta $0d05
B_9dff            rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9e00            lda #$01
                  sta $0d0b
                  lda #$10
                  sta $0d0d
                  lda #$00
                  sta $0d0c
                  sta $b4
                  sta $b5
                  sta $b6
                  sta $b7
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_9e18            ldx $b3
                  cpx #$41
                  bcc B_9e54
                  
                  dec $0d01
                  dex
                  stx $b3
                  stx $43
                  lda #$a0
                  sta $44
                  
                  jsr S_9e98
B_9e2d            jsr S_8910
                  
                  ldy #$00
                  sty $19
                  ldy #$28
B_9e36            lda ($45),y
                  rol $19
                  rol a
                  rol $19
                  rol a
                  ror $19
                  ror $19
                  sta ($45),y
                  tya
                  sec
                  sbc #$08
                  tay
                  bpl B_9e36
                  
                  ldx $44
                  inx
                  stx $44
                  cpx #$c3
                  bcc B_9e2d
                  
B_9e54            rts
; ------------------------------------------------------------------------------------------------------------- ;
S_9e55            ldx $b3
                  cpx #$6e
                  bcs B_9e97
                  
                  stx $43
                  inx
                  stx $b3
                  ldx #$a0
                  stx $44
                  lda $b4
                  cmp #$02
                  bne B_9e6d
                  
                  inc $0d01
                  
B_9e6d            jsr S_9e98
B_9e70            jsr S_8910
                  
                  ldy #$00
                  sty $19
B_9e77            lda ($45),y
                  ror $19
                  ror a
                  ror $19
                  ror a
                  rol $19
                  rol $19
                  sta ($45),y
                  tya
                  clc
                  adc #$08
                  tay
                  cpy #$29
                  bcc B_9e77
                  
                  ldx $44
                  inx
                  stx $44
                  cpx #$c3
                  bcc B_9e70
                  
B_9e97            rts
; ------------------------------------------------------------------------------------------------------------- ;
S_9e98            lda RASTER                      ; VIC 2 - $d012 = Read: Raster Scan Line / Write: Line for Raster IRQ
                  cmp #$f5
                  bcc S_9e98
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
S_9ea0            jmp B_9ea7
S_9ea3            jmp B_9ea6
B_9ea6            rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9ea7            sei
                  jsr S_8919
                  
                  lda #$77
                  
                  jsr S_891c
                  
                  lda #$77
                  
                  jsr S_891f
                  
                  ldx #$00
B_9eb7            lda #$20
                  sta $6208,x
                  sta $62f8,x
                  lda #$08
                  sta $da08,x
                  sta $daf8,x
                  dex
                  bne B_9eb7
                  
                  lda #$8a
                  sta $20
                  lda #$11
                  sta $21
B_9ed2            ldx $20
                  ldy $21
                  lda T_9f9f,y
                  ldy #$28
                  
                  jsr S_9c66
                  
                  lda $20
                  sec
                  sbc #$08
                  sta $20
                  dec $21
                  bpl B_9ed2
                  
                  lda #$76
                  sta $20
                  lda #$0c
                  sta $21
B_9ef1            ldx $20
                  ldy $21
                  lda T_9fb1,y
                  ldy #$38
                  
                  jsr S_9c66
                  
                  lda $20
                  sec
                  sbc #$08
                  sta $20
                  dec $21
                  bpl B_9ef1
                  
                  ldx #$0f
B_9f0a            lda T_9fbe,x
                  sta $620c,x
                  lda T_9fce,x
                  sta $62dd,x
                  lda T_9fde,x
                  sta $6305,x
                  lda T_9fee,x
                  sta $6386,x
                  dex
                  bpl B_9f0a
                  
                  lda #$38
                  sta SP0X                        ; VIC 2 - $d000 = Sprite 0 posx
                  lda #$aa
                  sta SP0Y                        ; VIC 2 - $d001 = Sprite 0 posy
                  lda #$00
                  sta MSIGX                       ; VIC 2 - $d010 = MSBs Sprites 0-7 posx
                  sta SPMC                        ; VIC 2 - $d01c = Sprite multiColor
                  sta EXTCOL                      ; VIC 2 - $d020 = Border Color
                  sta BGCOL0                      ; VIC 2 - $d021 = Background Color 0
                  lda #$01
                  sta SPENA                       ; VIC 2 - $d015 = Sprite Enable
                  sta SP0COL                      ; VIC 2 - $d027 = Color Sprite 0
                  sta XXPAND                      ; VIC 2 - $d01d = Sprite x expansion
                  sta YXPAND                      ; VIC 2 - $d017 = Sprite y expansion
                  lda #$a8
                  sta $63f8
                  lda #$04
                  sta $23
                  sta $24
B_9f56            lda RASTER                      ; VIC 2 - $d012 = Read: Raster Scan Line / Write: Line for Raster IRQ
                  cmp #$fa
                  bne B_9f56
                  
                  jsr S_8925
                  
                  lda $4b
                  beq B_9f6f
                  
                  lda #$00
                  sta $a2
B_9f68            lda #$0b
                  sta SCROLY                      ; VIC 2 - $d011 = Control 1 (and vertical fine scrolling)
                  cli
                  rts
; ------------------------------------------------------------------------------------------------------------- ;
B_9f6f            dec $23
                  bne B_9f77
                  
                  dec $24
                  beq B_9f68
                  
B_9f77            lda #$18
                  sta SCROLX                      ; VIC 2 - $d016 = Control Register 2 (and horizontal fine scrolling)
                  lda #$80
                  sta VMCSB                       ; VIC 2 - $d018 = Chip Memory Control
                  lda #$3b
                  sta SCROLY                      ; VIC 2 - $d011 = Control 1 (and vertical fine scrolling)
B_9f86            lda RASTER                      ; VIC 2 - $d012 = Read: Raster Scan Line / Write: Line for Raster IRQ
                  cmp #$9a
                  bne B_9f86
                  
                  lda #$1b
                  sta SCROLY                      ; VIC 2 - $d011 = Control 1 (and vertical fine scrolling)
                  lda #$08
                  sta SCROLX                      ; VIC 2 - $d016 = Control Register 2 (and horizontal fine scrolling)
                  lda #$8c
                  sta VMCSB                       ; VIC 2 - $d018 = Chip Memory Control
                  jmp B_9f56
; ------------------------------------------------------------------------------------------------------------- ;
T_9f9f            .byte $0f
                  .byte $0c
                  .byte $05
                  .byte $01
                  .byte $0e
                  .byte $04
                  .byte $05
                  .byte $12
                  .byte $20
                  .byte $10
                  .byte $12
                  .byte $05
                  .byte $13
                  .byte $05
                  .byte $0e
                  .byte $14
                  .byte $13
                  .byte $3a
T_9fb1            .byte $0d
                  .byte $09
                  .byte $0e
                  .byte $05
                  .byte $12
                  .byte $20
                  .byte $32
                  .byte $30
                  .byte $34
                  .byte $39
                  .byte $27
                  .byte $05
                  .byte $12
T_9fbe            .byte $02
                  .byte $19
                  .byte $20
                  .byte $02
                  .byte $09
                  .byte $0c
                  .byte $0c
                  .byte $20
                  .byte $08
    
T_9fc7            .byte $0f
                  .byte $07
                  .byte $15
                  .byte $05
                  .byte $20
                  .byte $20
                  .byte $20
T_9fce            .byte $03
                  .byte $12
                  .byte $01
                  .byte $03
                  .byte $0b
                  .byte $05
                  .byte $04
                  .byte $20
                  .byte $09
                  .byte $0e
                  .byte $20
                  .byte $31
                  .byte $39
                  .byte $38
                  .byte $34
                  .byte $20
                  
T_9fde            .byte $02
                  .byte $19
                  .byte $20
                  .byte $0f
                  .byte $0c
                  .byte $05
                  .byte $01
                  .byte $0e
                  .byte $04
                  .byte $05
                  .byte $12
                  .byte $20
                  .byte $20
                  .byte $20
                  .byte $20
                  .byte $20
                  
T_9fee            .byte $08
                  .byte $09
                  .byte $21
                  .byte $20
                  .byte $20
                  .byte $0d
                  .byte $12
                  .byte $2e
                  .byte $0f
                  .byte $20
                  .byte $26
                  .byte $20
                  .byte $08
                  .byte $0f
                  .byte $0e
                  .byte $1a
                  .byte $20
                  .byte $20

a000              .byte $07
a001              .byte $11
a002              .byte $00
a003              .byte $ff
a004              .byte $00
a005              .byte $ff
a006              .byte $00
a007              .byte $00
a008              .byte $ff
a009              .byte $00
a00a              .byte $ff
a00b              .byte $00
a00c              .byte $ff
a00d              .byte $00
a00e              .byte $00
a00f              .byte $00
a010              .byte $aa
a011              .byte $a0
                  .byte $a0
a013              .byte $a0
                  .byte $aa
a015              .byte $a0
                  .byte $a0
a017              .byte $a0
                  .byte $aa
a019              .byte $0a
a01a              .byte $0a
a01b              .byte $0a
a01c              .byte $aa
a01d              .byte $0a
a01e              .byte $0a
a01f              .byte $0a
a020              .byte $aa
a021              .byte $00
a022              .byte $00
a023              .byte $00
a024              .byte $00
a025              .byte $00
a026              .byte $00
a027              .byte $00
a028              .byte $ff
a029              .byte $00
a02a              .byte $00
a02b              .byte $00
a02c              .byte $00
a02d              .byte $00
a02e              .byte $00
a02f              .byte $00
a030              .byte $ff
a031              .byte $ff
a032              .byte $ff
a033              .byte $ff
a034              .byte $ff
a035              .byte $ff
a036              .byte $00
a037              .byte $00
a038              .byte $50
                  .byte $50
a03a              .byte $50
                  .byte $50
a03c              .byte $50
                  .byte $50
a03e              .byte $50
                  .byte $50
a040              .byte $55
                  .byte $55
a042              .byte $00
a043              .byte $00
a044              .byte $00
a045              .byte $00
a046              .byte $00
a047              .byte $00
a048              .byte $ff
a049              .byte $ff
a04a              .byte $ff
a04b              .byte $00
a04c              .byte $00
a04d              .byte $00
a04e              .byte $00
a04f              .byte $00
a050              .byte $aa
a051              .byte $aa
a052              .byte $aa
a053              .byte $82
a054              .byte $00
a055              .byte $00
a056              .byte $00
a057              .byte $00
a058              .byte $54
a059              .byte $54
a05a              .byte $10
                  .byte $00
a05c              .byte $00
a05d              .byte $00
a05e              .byte $00
a05f              .byte $00
a060              .byte $50
                  .byte $00
a062              .byte $00
a063              .byte $00
a064              .byte $00
a065              .byte $00
a066              .byte $00
a067              .byte $00
a068              .byte $aa
a069              .byte $aa
a06a              .byte $aa
a06b              .byte $aa
a06c              .byte $aa
a06d              .byte $aa
a06e              .byte $aa
a06f              .byte $aa
a070              .byte $ff
a071              .byte $ff
a072              .byte $00
a073              .byte $ff
a074              .byte $00
a075              .byte $ff
a076              .byte $00
a077              .byte $00
a078              .byte $00
a079              .byte $00
a07a              .byte $00
a07b              .byte $00
a07c              .byte $00
a07d              .byte $00
a07e              .byte $00
a07f              .byte $00
a080              .byte $03
a081              .byte $c0
                  .byte $00
a083              .byte $0f
a084              .byte $f0
                  .byte $00
a086              .byte $ff
a087              .byte $ff
a088              .byte $00
a089              .byte $05
                  .byte $50
a08b              .byte $00
a08c              .byte $04
a08d              .byte $50
                  .byte $00
a08f              .byte $15
                  .byte $50
a091              .byte $00
a092              .byte $04
a093              .byte $50
                  .byte $00
a095              .byte $00
a096              .byte $50
                  .byte $00
a098              .byte $05
                  .byte $40
a09a              .byte $00
a09b              .byte $00
a09c              .byte $40
a09d              .byte $00
a09e              .byte $00
a09f              .byte $c0
                  .byte $00
a0a1              .byte $0f
a0a2              .byte $f0
                  .byte $00
a0a4              .byte $3f
a0a5              .byte $fc
a0a6              .byte $00
a0a7              .byte $15
                  .byte $94
a0a9              .byte $00
a0aa              .byte $15
                  .byte $64
a0ac              .byte $00
a0ad              .byte $3f
a0ae              .byte $f8
a0af              .byte $00
a0b0              .byte $3f
a0b1              .byte $fc
a0b2              .byte $00
a0b3              .byte $0f
a0b4              .byte $f0
                  .byte $00
a0b6              .byte $08
a0b7              .byte $20
                  .byte $00
                  .byte $08
a0ba              .byte $20
                  .byte $00
                  .byte $28
a0bd              .byte $a0
                  .byte $00
a0bf              .byte $00
a0c0              .byte $03
a0c1              .byte $c0
                  .byte $00
a0c3              .byte $0f
a0c4              .byte $f0
                  .byte $00
a0c6              .byte $ff
a0c7              .byte $ff
a0c8              .byte $00
a0c9              .byte $05
                  .byte $50
a0cb              .byte $00
a0cc              .byte $04
a0cd              .byte $50
                  .byte $00
a0cf              .byte $15
                  .byte $50
a0d1              .byte $00
a0d2              .byte $04
a0d3              .byte $50
                  .byte $00
a0d5              .byte $00
a0d6              .byte $50
                  .byte $00
a0d8              .byte $05
                  .byte $40
a0da              .byte $00
a0db              .byte $00
a0dc              .byte $40
a0dd              .byte $00
a0de              .byte $00
a0df              .byte $c0
                  .byte $00
a0e1              .byte $0f
a0e2              .byte $f0
                  .byte $00
a0e4              .byte $3f
a0e5              .byte $fc
a0e6              .byte $00
a0e7              .byte $15
                  .byte $94
a0e9              .byte $00
a0ea              .byte $15
                  .byte $64
a0ec              .byte $00
a0ed              .byte $3f
a0ee              .byte $ec
                  .byte $00
                  .byte $3f
a0f1              .byte $fc
a0f2              .byte $00
a0f3              .byte $0f
a0f4              .byte $f0
                  .byte $00
a0f6              .byte $02
a0f7              .byte $20
                  .byte $00
                  .byte $02
a0fa              .byte $20
                  .byte $00
                  .byte $0a
a0fd              .byte $a0
                  .byte $00
a0ff              .byte $00
a100              .byte $03
a101              .byte $c0
                  .byte $00
a103              .byte $0f
a104              .byte $f0
                  .byte $00
a106              .byte $ff
a107              .byte $ff
a108              .byte $00
a109              .byte $05
                  .byte $50
a10b              .byte $00
a10c              .byte $04
a10d              .byte $50
                  .byte $00
a10f              .byte $15
                  .byte $50
a111              .byte $00
a112              .byte $04
a113              .byte $50
                  .byte $00
a115              .byte $00
a116              .byte $50
                  .byte $00
a118              .byte $05
                  .byte $40
a11a              .byte $00
a11b              .byte $00
a11c              .byte $40
a11d              .byte $00
a11e              .byte $00
a11f              .byte $c0
                  .byte $00
a121              .byte $0f
a122              .byte $f0
                  .byte $00
a124              .byte $3f
a125              .byte $fc
a126              .byte $00
a127              .byte $15
                  .byte $94
a129              .byte $00
a12a              .byte $15
                  .byte $64
a12c              .byte $00
a12d              .byte $3f
a12e              .byte $bc
                  .byte $00
                  .byte $3f
a131              .byte $fc
a132              .byte $00
a133              .byte $0f
a134              .byte $f0
                  .byte $00
a136              .byte $00
a137              .byte $80
a138              .byte $00
a139              .byte $00
a13a              .byte $80
a13b              .byte $00
a13c              .byte $02
a13d              .byte $80
a13e              .byte $00
a13f              .byte $00
a140              .byte $03
a141              .byte $c0
                  .byte $00
a143              .byte $0f
a144              .byte $f0
                  .byte $00
a146              .byte $ff
a147              .byte $ff
a148              .byte $00
a149              .byte $05
                  .byte $50
a14b              .byte $00
a14c              .byte $04
a14d              .byte $50
                  .byte $00
a14f              .byte $15
                  .byte $50
a151              .byte $00
a152              .byte $04
a153              .byte $50
                  .byte $00
a155              .byte $00
a156              .byte $50
                  .byte $00
a158              .byte $05
                  .byte $40
a15a              .byte $00
a15b              .byte $00
a15c              .byte $40
a15d              .byte $00
a15e              .byte $00
a15f              .byte $c0
                  .byte $00
a161              .byte $0f
a162              .byte $f0
                  .byte $00
a164              .byte $3f
a165              .byte $fc
a166              .byte $00
a167              .byte $15
                  .byte $94
a169              .byte $00
a16a              .byte $15
                  .byte $94
a16c              .byte $00
a16d              .byte $3e
                  .byte $fc
                  .byte $00
a170              .byte $3f
a171              .byte $fc
a172              .byte $00
a173              .byte $0f
a174              .byte $f0
                  .byte $00
a176              .byte $02
a177              .byte $20
                  .byte $00
                  .byte $02
a17a              .byte $20
                  .byte $00
                  .byte $0a
a17d              .byte $a0
                  .byte $00
a17f              .byte $00
a180              .byte $03
a181              .byte $c0
                  .byte $00
a183              .byte $0f
a184              .byte $f0
                  .byte $00
a186              .byte $ff
a187              .byte $ff
a188              .byte $00
a189              .byte $05
                  .byte $50
a18b              .byte $00
a18c              .byte $04
a18d              .byte $50
                  .byte $00
a18f              .byte $15
                  .byte $50
a191              .byte $00
a192              .byte $04
a193              .byte $50
                  .byte $00
a195              .byte $00
a196              .byte $50
                  .byte $00
a198              .byte $05
                  .byte $40
a19a              .byte $00
a19b              .byte $00
a19c              .byte $40
a19d              .byte $00
a19e              .byte $00
a19f              .byte $c0
                  .byte $00
a1a1              .byte $0f
a1a2              .byte $f0
                  .byte $00
a1a4              .byte $3f
a1a5              .byte $fc
a1a6              .byte $00
a1a7              .byte $15
                  .byte $94
a1a9              .byte $00
a1aa              .byte $16
                  .byte $54
a1ac              .byte $00
a1ad              .byte $3b
a1ae              .byte $fc
a1af              .byte $00
a1b0              .byte $3f
a1b1              .byte $fc
a1b2              .byte $00
a1b3              .byte $0f
a1b4              .byte $f0
                  .byte $00
a1b6              .byte $08
a1b7              .byte $20
                  .byte $00
                  .byte $08
a1ba              .byte $20
                  .byte $00
                  .byte $28
a1bd              .byte $a0
                  .byte $00
a1bf              .byte $00
a1c0              .byte $03
a1c1              .byte $c0
                  .byte $00
a1c3              .byte $0f
a1c4              .byte $f0
                  .byte $00
a1c6              .byte $ff
a1c7              .byte $ff
a1c8              .byte $00
a1c9              .byte $05
                  .byte $50
a1cb              .byte $00
a1cc              .byte $05
                  .byte $10
a1ce              .byte $00
a1cf              .byte $05
                  .byte $54
a1d1              .byte $00
a1d2              .byte $05
                  .byte $10
a1d4              .byte $00
a1d5              .byte $05
                  .byte $00
a1d7              .byte $00
a1d8              .byte $01
                  .byte $50
a1da              .byte $00
a1db              .byte $01
                  .byte $00
a1dd              .byte $00
a1de              .byte $03
a1df              .byte $00
a1e0              .byte $00
a1e1              .byte $0f
a1e2              .byte $f0
                  .byte $00
a1e4              .byte $3f
a1e5              .byte $fc
a1e6              .byte $00
a1e7              .byte $16
                  .byte $54
a1e9              .byte $00
a1ea              .byte $19
                  .byte $54
                  .byte $00
a1ed              .byte $2f
a1ee              .byte $fc
a1ef              .byte $00
a1f0              .byte $3f
a1f1              .byte $fc
a1f2              .byte $00
a1f3              .byte $0f
a1f4              .byte $f0
                  .byte $00
a1f6              .byte $08
a1f7              .byte $20
                  .byte $00
                  .byte $08
a1fa              .byte $20
                  .byte $00
                  .byte $0a
a1fd              .byte $28
a1fe              .byte $00
a1ff              .byte $00
a200              .byte $03
a201              .byte $c0
                  .byte $00
a203              .byte $0f
a204              .byte $f0
                  .byte $00
a206              .byte $ff
a207              .byte $ff
a208              .byte $00
a209              .byte $05
                  .byte $50
a20b              .byte $00
a20c              .byte $05
                  .byte $10
a20e              .byte $00
a20f              .byte $05
                  .byte $54
a211              .byte $00
a212              .byte $05
                  .byte $10
a214              .byte $00
a215              .byte $05
                  .byte $00
a217              .byte $00
a218              .byte $01
                  .byte $50
a21a              .byte $00
a21b              .byte $01
                  .byte $00
a21d              .byte $00
a21e              .byte $03
a21f              .byte $00
a220              .byte $00
a221              .byte $0f
a222              .byte $f0
                  .byte $00
a224              .byte $3f
a225              .byte $fc
a226              .byte $00
a227              .byte $16
                  .byte $54
a229              .byte $00
a22a              .byte $19
                  .byte $54
                  .byte $00
a22d              .byte $3b
a22e              .byte $fc
a22f              .byte $00
a230              .byte $3f
a231              .byte $fc
a232              .byte $00
a233              .byte $0f
a234              .byte $f0
                  .byte $00
a236              .byte $08
a237              .byte $80
a238              .byte $00
a239              .byte $08
a23a              .byte $80
a23b              .byte $00
a23c              .byte $0a
a23d              .byte $a0
                  .byte $00
a23f              .byte $00
a240              .byte $03
a241              .byte $c0
                  .byte $00
a243              .byte $0f
a244              .byte $f0
                  .byte $00
a246              .byte $ff
a247              .byte $ff
a248              .byte $00
a249              .byte $05
                  .byte $50
a24b              .byte $00
a24c              .byte $05
                  .byte $10
a24e              .byte $00
a24f              .byte $05
                  .byte $54
a251              .byte $00
a252              .byte $05
                  .byte $10
a254              .byte $00
a255              .byte $05
                  .byte $00
a257              .byte $00
a258              .byte $01
                  .byte $50
a25a              .byte $00
a25b              .byte $01
                  .byte $00
a25d              .byte $00
a25e              .byte $03
a25f              .byte $00
a260              .byte $00
a261              .byte $0f
a262              .byte $f0
                  .byte $00
a264              .byte $3f
a265              .byte $fc
a266              .byte $00
a267              .byte $16
                  .byte $54
a269              .byte $00
a26a              .byte $19
                  .byte $54
                  .byte $00
a26d              .byte $3e
                  .byte $fc
                  .byte $00
a270              .byte $3f
a271              .byte $fc
a272              .byte $00
a273              .byte $0f
a274              .byte $f0
                  .byte $00
a276              .byte $02
a277              .byte $00
a278              .byte $00
a279              .byte $02
a27a              .byte $00
a27b              .byte $00
a27c              .byte $02
a27d              .byte $80
a27e              .byte $00
a27f              .byte $00
a280              .byte $03
a281              .byte $c0
                  .byte $00
a283              .byte $0f
a284              .byte $f0
                  .byte $00
a286              .byte $ff
a287              .byte $ff
a288              .byte $00
a289              .byte $05
                  .byte $50
a28b              .byte $00
a28c              .byte $05
                  .byte $10
a28e              .byte $00
a28f              .byte $05
                  .byte $54
a291              .byte $00
a292              .byte $05
                  .byte $10
a294              .byte $00
a295              .byte $05
                  .byte $00
a297              .byte $00
a298              .byte $01
                  .byte $50
a29a              .byte $00
a29b              .byte $01
                  .byte $00
a29d              .byte $00
a29e              .byte $03
a29f              .byte $00
a2a0              .byte $00
a2a1              .byte $0f
a2a2              .byte $f0
                  .byte $00
a2a4              .byte $3f
a2a5              .byte $fc
a2a6              .byte $00
a2a7              .byte $16
                  .byte $54
a2a9              .byte $00
a2aa              .byte $16
                  .byte $54
a2ac              .byte $00
a2ad              .byte $3f
a2ae              .byte $bc
                  .byte $00
                  .byte $3f
a2b1              .byte $fc
a2b2              .byte $00
a2b3              .byte $0f
a2b4              .byte $f0
                  .byte $00
a2b6              .byte $08
a2b7              .byte $80
a2b8              .byte $00
a2b9              .byte $08
a2ba              .byte $80
a2bb              .byte $00
a2bc              .byte $0a
a2bd              .byte $a0
                  .byte $00
a2bf              .byte $00
a2c0              .byte $03
a2c1              .byte $c0
                  .byte $00
a2c3              .byte $0f
a2c4              .byte $f0
                  .byte $00
a2c6              .byte $ff
a2c7              .byte $ff
a2c8              .byte $00
a2c9              .byte $05
                  .byte $50
a2cb              .byte $00
a2cc              .byte $05
                  .byte $10
a2ce              .byte $00
a2cf              .byte $05
                  .byte $54
a2d1              .byte $00
a2d2              .byte $05
                  .byte $10
a2d4              .byte $00
a2d5              .byte $05
                  .byte $00
a2d7              .byte $00
a2d8              .byte $01
                  .byte $50
a2da              .byte $00
a2db              .byte $01
                  .byte $00
a2dd              .byte $00
a2de              .byte $03
a2df              .byte $00
a2e0              .byte $00
a2e1              .byte $0f
a2e2              .byte $f0
                  .byte $00
a2e4              .byte $3f
a2e5              .byte $fc
a2e6              .byte $00
a2e7              .byte $16
                  .byte $54
a2e9              .byte $00
a2ea              .byte $15
                  .byte $94
a2ec              .byte $00
a2ed              .byte $3f
a2ee              .byte $ec
                  .byte $00
                  .byte $3f
a2f1              .byte $fc
a2f2              .byte $00
a2f3              .byte $0f
a2f4              .byte $f0
                  .byte $00
a2f6              .byte $08
a2f7              .byte $20
                  .byte $00
                  .byte $08
a2fa              .byte $20
                  .byte $00
                  .byte $0a
a2fd              .byte $28
a2fe              .byte $00
a2ff              .byte $00
a300              .byte $03
a301              .byte $c0
                  .byte $00
a303              .byte $0f
a304              .byte $f0
                  .byte $00
a306              .byte $ff
a307              .byte $ff
a308              .byte $00
a309              .byte $05
                  .byte $50
a30b              .byte $00
a30c              .byte $04
a30d              .byte $50
                  .byte $00
a30f              .byte $15
                  .byte $50
a311              .byte $00
a312              .byte $04
a313              .byte $50
                  .byte $00
a315              .byte $00
a316              .byte $50
                  .byte $00
a318              .byte $05
                  .byte $40
a31a              .byte $00
a31b              .byte $00
a31c              .byte $40
a31d              .byte $00
a31e              .byte $20
                  .byte $c2
                  .byte $00
a321              .byte $0b
a322              .byte $f8
a323              .byte $00
a324              .byte $3e
                  .byte $fc
                  .byte $00
a327              .byte $15
                  .byte $94
a329              .byte $00
a32a              .byte $15
                  .byte $54
a32c              .byte $00
a32d              .byte $3f
a32e              .byte $fc
a32f              .byte $00
a330              .byte $3f
a331              .byte $fc
a332              .byte $00
a333              .byte $8b
a334              .byte $f0
                  .byte $00
a336              .byte $a8
a337              .byte $22
a338              .byte $00
a339              .byte $20
                  .byte $2a
                  .byte $00
a33c              .byte $00
a33d              .byte $08
a33e              .byte $00
a33f              .byte $00
a340              .byte $03
a341              .byte $c0
                  .byte $00
a343              .byte $0f
a344              .byte $f0
                  .byte $00
a346              .byte $ff
a347              .byte $ff
a348              .byte $00
a349              .byte $05
                  .byte $50
a34b              .byte $00
a34c              .byte $05
                  .byte $10
a34e              .byte $00
a34f              .byte $05
                  .byte $54
a351              .byte $00
a352              .byte $05
                  .byte $10
a354              .byte $00
a355              .byte $05
                  .byte $00
a357              .byte $00
a358              .byte $01
                  .byte $50
a35a              .byte $00
a35b              .byte $01
                  .byte $00
a35d              .byte $00
a35e              .byte $83
a35f              .byte $08
a360              .byte $00
a361              .byte $2f
a362              .byte $e0
                  .byte $00
a364              .byte $3f
a365              .byte $bc
                  .byte $00
                  .byte $16
a368              .byte $54
a369              .byte $00
a36a              .byte $15
                  .byte $54
a36c              .byte $00
a36d              .byte $3f
a36e              .byte $fc
a36f              .byte $00
a370              .byte $3f
a371              .byte $fc
a372              .byte $00
a373              .byte $0f
a374              .byte $e2
a375              .byte $00
a376              .byte $88
a377              .byte $2a
a378              .byte $00
a379              .byte $a8
a37a              .byte $08
a37b              .byte $00
a37c              .byte $20
                  .byte $00
                  .byte $00
a37f              .byte $00
a380              .byte $03
a381              .byte $c0
                  .byte $00
a383              .byte $0f
a384              .byte $f0
                  .byte $00
a386              .byte $ff
a387              .byte $ff
a388              .byte $00
a389              .byte $05
                  .byte $50
a38b              .byte $00
a38c              .byte $15
                  .byte $54
a38e              .byte $00
a38f              .byte $15
                  .byte $54
a391              .byte $00
a392              .byte $15
                  .byte $54
a394              .byte $00
a395              .byte $05
                  .byte $50
a397              .byte $00
a398              .byte $05
                  .byte $50
a39a              .byte $00
a39b              .byte $a1
                  .byte $40
a39d              .byte $00
a39e              .byte $83
a39f              .byte $c0
                  .byte $00
a3a1              .byte $8f
a3a2              .byte $fa
a3a3              .byte $00
a3a4              .byte $bf
a3a5              .byte $fe
                  .byte $00
                  .byte $15
a3a8              .byte $54
a3a9              .byte $00
a3aa              .byte $15
                  .byte $54
a3ac              .byte $00
a3ad              .byte $3f
a3ae              .byte $fc
a3af              .byte $00
a3b0              .byte $3f
a3b1              .byte $fc
a3b2              .byte $00
a3b3              .byte $0f
a3b4              .byte $e0
                  .byte $00
a3b6              .byte $08
a3b7              .byte $20
                  .byte $00
                  .byte $08
a3ba              .byte $08
a3bb              .byte $00
a3bc              .byte $20
                  .byte $00
                  .byte $00
a3bf              .byte $00
a3c0              .byte $03
a3c1              .byte $c0
                  .byte $00
a3c3              .byte $0f
a3c4              .byte $f0
                  .byte $00
a3c6              .byte $ff
a3c7              .byte $ff
a3c8              .byte $00
a3c9              .byte $05
                  .byte $50
a3cb              .byte $00
a3cc              .byte $15
                  .byte $54
a3ce              .byte $00
a3cf              .byte $15
                  .byte $54
a3d1              .byte $00
a3d2              .byte $15
                  .byte $54
a3d4              .byte $00
a3d5              .byte $05
                  .byte $50
a3d7              .byte $00
a3d8              .byte $05
                  .byte $50
a3da              .byte $00
a3db              .byte $01
                  .byte $4a
a3dd              .byte $00
a3de              .byte $03
a3df              .byte $c2
a3e0              .byte $00
a3e1              .byte $af
a3e2              .byte $f2
a3e3              .byte $00
a3e4              .byte $bf
a3e5              .byte $fe
                  .byte $00
                  .byte $15
a3e8              .byte $54
a3e9              .byte $00
a3ea              .byte $15
                  .byte $54
a3ec              .byte $00
a3ed              .byte $3f
a3ee              .byte $fc
a3ef              .byte $00
a3f0              .byte $3f
a3f1              .byte $fc
a3f2              .byte $00
a3f3              .byte $0b
a3f4              .byte $f0
                  .byte $00
a3f6              .byte $08
a3f7              .byte $20
                  .byte $00
                  .byte $20
a3fa              .byte $20
                  .byte $00
                  .byte $00
a3fd              .byte $08
a3fe              .byte $00
a3ff              .byte $00
a400              .byte $03
a401              .byte $c0
                  .byte $00
a403              .byte $0f
a404              .byte $f0
                  .byte $00
a406              .byte $ff
a407              .byte $ff
a408              .byte $00
a409              .byte $15
                  .byte $54
a40b              .byte $00
a40c              .byte $a5
                  .byte $50
a40e              .byte $00
a40f              .byte $bf
a410              .byte $fe
                  .byte $00
                  .byte $3f
a413              .byte $fe
                  .byte $00
                  .byte $3f
a416              .byte $fc
a417              .byte $00
a418              .byte $15
                  .byte $54
a41a              .byte $00
a41b              .byte $15
                  .byte $54
a41d              .byte $00
a41e              .byte $ff
a41f              .byte $fc
a420              .byte $00
a421              .byte $ff
a422              .byte $fc
a423              .byte $00
a424              .byte $3f
a425              .byte $fc
a426              .byte $00
a427              .byte $3c
a428              .byte $3c
a429              .byte $00
a42a              .byte $3c
a42b              .byte $3c
a42c              .byte $00
a42d              .byte $08
a42e              .byte $3c
a42f              .byte $00
a430              .byte $08
a431              .byte $3c
a432              .byte $00
a433              .byte $08
a434              .byte $20
                  .byte $00
                  .byte $20
a437              .byte $20
                  .byte $00
                  .byte $00
a43a              .byte $08
a43b              .byte $00
a43c              .byte $00
a43d              .byte $00
a43e              .byte $00
a43f              .byte $00
a440              .byte $03
a441              .byte $c0
                  .byte $00
a443              .byte $0f
a444              .byte $f0
                  .byte $00
a446              .byte $ff
a447              .byte $ff
a448              .byte $00
a449              .byte $15
                  .byte $54
a44b              .byte $00
a44c              .byte $05
                  .byte $5a
a44e              .byte $00
a44f              .byte $bf
a450              .byte $fe
                  .byte $00
                  .byte $bf
a453              .byte $fc
a454              .byte $00
a455              .byte $3f
a456              .byte $fc
a457              .byte $00
a458              .byte $15
                  .byte $54
a45a              .byte $00
a45b              .byte $15
                  .byte $54
a45d              .byte $00
a45e              .byte $3f
a45f              .byte $ff
a460              .byte $00
a461              .byte $3f
a462              .byte $ff
a463              .byte $00
a464              .byte $3f
a465              .byte $fc
a466              .byte $00
a467              .byte $3c
a468              .byte $3c
a469              .byte $00
a46a              .byte $3c
a46b              .byte $3c
a46c              .byte $00
a46d              .byte $3c
a46e              .byte $20
                  .byte $00
                  .byte $3c
a471              .byte $20
                  .byte $00
                  .byte $08
a474              .byte $20
                  .byte $00
                  .byte $08
a477              .byte $08
a478              .byte $00
a479              .byte $20
                  .byte $00
                  .byte $00
a47c              .byte $00
a47d              .byte $00
a47e              .byte $00
a47f              .byte $00
a480              .byte $03
a481              .byte $00
a482              .byte $00
a483              .byte $3f
a484              .byte $00
a485              .byte $00
a486              .byte $3f
a487              .byte $c0
                  .byte $00
a489              .byte $c7
a48a              .byte $c0
                  .byte $00
a48c              .byte $fe
                  .byte $30
                  .byte $00
a48f              .byte $19
                  .byte $f0
                  .byte $00
a492              .byte $0f
a493              .byte $c0
                  .byte $00
a495              .byte $03
a496              .byte $00
a497              .byte $00
a498              .byte $06
                  .byte $c0
a49a              .byte $00
a49b              .byte $06
                  .byte $30
a49d              .byte $00
a49e              .byte $00
a49f              .byte $00
a4a0              .byte $00
a4a1              .byte $00
a4a2              .byte $00
a4a3              .byte $00
a4a4              .byte $00
a4a5              .byte $00
a4a6              .byte $00
a4a7              .byte $00
a4a8              .byte $00
a4a9              .byte $00
a4aa              .byte $00
a4ab              .byte $00
a4ac              .byte $00
a4ad              .byte $00
a4ae              .byte $00
a4af              .byte $00
a4b0              .byte $00
a4b1              .byte $00
a4b2              .byte $00
a4b3              .byte $00
a4b4              .byte $00
a4b5              .byte $00
a4b6              .byte $00
a4b7              .byte $00
a4b8              .byte $00
a4b9              .byte $00
a4ba              .byte $00
a4bb              .byte $00
a4bc              .byte $00
a4bd              .byte $00
a4be              .byte $00
a4bf              .byte $00
a4c0              .byte $03
a4c1              .byte $00
a4c2              .byte $00
a4c3              .byte $3f
a4c4              .byte $00
a4c5              .byte $00
a4c6              .byte $3f
a4c7              .byte $c0
                  .byte $00
a4c9              .byte $c7
a4ca              .byte $c0
                  .byte $00
a4cc              .byte $fe
                  .byte $30
                  .byte $00
a4cf              .byte $19
                  .byte $f0
                  .byte $00
a4d2              .byte $0f
a4d3              .byte $c0
                  .byte $00
a4d5              .byte $03
a4d6              .byte $00
a4d7              .byte $00
a4d8              .byte $0d
                  .byte $80
                  .byte $00
a4db              .byte $31
                  .byte $80
a4dd              .byte $00
a4de              .byte $00
a4df              .byte $00
a4e0              .byte $00
a4e1              .byte $00
a4e2              .byte $00
a4e3              .byte $00
a4e4              .byte $00
a4e5              .byte $00
a4e6              .byte $00
a4e7              .byte $00
a4e8              .byte $00
a4e9              .byte $00
a4ea              .byte $00
a4eb              .byte $00
a4ec              .byte $00
a4ed              .byte $00
a4ee              .byte $00
a4ef              .byte $00
a4f0              .byte $00
a4f1              .byte $00
a4f2              .byte $00
a4f3              .byte $00
a4f4              .byte $00
a4f5              .byte $00
a4f6              .byte $00
a4f7              .byte $00
a4f8              .byte $00
a4f9              .byte $00
a4fa              .byte $00
a4fb              .byte $00
a4fc              .byte $00
a4fd              .byte $00
a4fe              .byte $00
a4ff              .byte $00
a500              .byte $0c
a501              .byte $00
a502              .byte $00
a503              .byte $0f
a504              .byte $c0
                  .byte $00
a506              .byte $3f
a507              .byte $c0
                  .byte $00
a509              .byte $3e
                  .byte $30
                  .byte $00
a50c              .byte $c7
a50d              .byte $f0
                  .byte $00
a50f              .byte $f9
                  .byte $80
                  .byte $00
a512              .byte $3f
a513              .byte $00
a514              .byte $00
a515              .byte $0c
a516              .byte $00
a517              .byte $00
a518              .byte $36
                  .byte $00
a51a              .byte $00
a51b              .byte $c6
                  .byte $00
a51d              .byte $00
a51e              .byte $00
a51f              .byte $00
a520              .byte $00
a521              .byte $00
a522              .byte $00
a523              .byte $00
a524              .byte $00
a525              .byte $00
a526              .byte $00
a527              .byte $00
a528              .byte $00
a529              .byte $00
a52a              .byte $00
a52b              .byte $00
a52c              .byte $00
a52d              .byte $00
a52e              .byte $00
a52f              .byte $00
a530              .byte $00
a531              .byte $00
a532              .byte $00
a533              .byte $00
a534              .byte $00
a535              .byte $00
a536              .byte $00
a537              .byte $00
a538              .byte $00
a539              .byte $00
a53a              .byte $00
a53b              .byte $00
a53c              .byte $00
a53d              .byte $00
a53e              .byte $00
a53f              .byte $00
a540              .byte $0c
a541              .byte $00
a542              .byte $00
a543              .byte $0f
a544              .byte $c0
                  .byte $00
a546              .byte $3f
a547              .byte $c0
                  .byte $00
a549              .byte $3e
                  .byte $30
                  .byte $00
a54c              .byte $c7
a54d              .byte $f0
                  .byte $00
a54f              .byte $f9
                  .byte $80
                  .byte $00
a552              .byte $3f
a553              .byte $00
a554              .byte $00
a555              .byte $0c
a556              .byte $00
a557              .byte $00
a558              .byte $1b
a559              .byte $00
a55a              .byte $00
a55b              .byte $18
a55c              .byte $c0
                  .byte $00
a55e              .byte $00
a55f              .byte $00
a560              .byte $00
a561              .byte $00
a562              .byte $00
a563              .byte $00
a564              .byte $00
a565              .byte $00
a566              .byte $00
a567              .byte $00
a568              .byte $00
a569              .byte $00
a56a              .byte $00
a56b              .byte $00
a56c              .byte $00
a56d              .byte $00
a56e              .byte $00
a56f              .byte $00
a570              .byte $00
a571              .byte $00
a572              .byte $00
a573              .byte $00
a574              .byte $00
a575              .byte $00
a576              .byte $00
a577              .byte $00
a578              .byte $00
a579              .byte $00
a57a              .byte $00
a57b              .byte $00
a57c              .byte $00
a57d              .byte $00
a57e              .byte $00
a57f              .byte $00
a580              .byte $0c
a581              .byte $00
a582              .byte $00
a583              .byte $3f
a584              .byte $00
a585              .byte $00
a586              .byte $c0
                  .byte $c0
a588              .byte $00
a589              .byte $ff
a58a              .byte $c0
                  .byte $00
a58c              .byte $cc
                  .byte $c0
                  .byte $00
a58f              .byte $e1
                  .byte $c0
a591              .byte $00
a592              .byte $3f
a593              .byte $00
a594              .byte $00
a595              .byte $0c
a596              .byte $00
a597              .byte $00
a598              .byte $33
a599              .byte $00
a59a              .byte $00
a59b              .byte $c0
                  .byte $c0
a59d              .byte $00
a59e              .byte $00
a59f              .byte $00
a5a0              .byte $00
a5a1              .byte $00
a5a2              .byte $00
a5a3              .byte $00
a5a4              .byte $00
a5a5              .byte $00
a5a6              .byte $00
a5a7              .byte $00
a5a8              .byte $00
a5a9              .byte $00
a5aa              .byte $00
a5ab              .byte $00
a5ac              .byte $00
a5ad              .byte $00
a5ae              .byte $00
a5af              .byte $00
a5b0              .byte $00
a5b1              .byte $00
a5b2              .byte $00
a5b3              .byte $00
a5b4              .byte $00
a5b5              .byte $00
a5b6              .byte $00
a5b7              .byte $00
a5b8              .byte $00
a5b9              .byte $00
a5ba              .byte $00
a5bb              .byte $00
a5bc              .byte $00
a5bd              .byte $00
a5be              .byte $00
a5bf              .byte $00
a5c0              .byte $0c
a5c1              .byte $00
a5c2              .byte $00
a5c3              .byte $3f
a5c4              .byte $00
a5c5              .byte $00
a5c6              .byte $c0
                  .byte $c0
a5c8              .byte $00
a5c9              .byte $ff
a5ca              .byte $c0
                  .byte $00
a5cc              .byte $cc
                  .byte $c0
                  .byte $00
a5cf              .byte $e1
                  .byte $c0
a5d1              .byte $00
a5d2              .byte $3f
a5d3              .byte $00
a5d4              .byte $00
a5d5              .byte $0c
a5d6              .byte $00
a5d7              .byte $00
a5d8              .byte $0c
a5d9              .byte $00
a5da              .byte $00
a5db              .byte $33
a5dc              .byte $00
a5dd              .byte $00
a5de              .byte $00
a5df              .byte $00
a5e0              .byte $00
a5e1              .byte $00
a5e2              .byte $00
a5e3              .byte $00
a5e4              .byte $00
a5e5              .byte $00
a5e6              .byte $00
a5e7              .byte $00
a5e8              .byte $00
a5e9              .byte $00
a5ea              .byte $00
a5eb              .byte $00
a5ec              .byte $00
a5ed              .byte $00
a5ee              .byte $00
a5ef              .byte $00
a5f0              .byte $00
a5f1              .byte $00
a5f2              .byte $00
a5f3              .byte $00
a5f4              .byte $00
a5f5              .byte $00
a5f6              .byte $00
a5f7              .byte $00
a5f8              .byte $00
a5f9              .byte $00
a5fa              .byte $00
a5fb              .byte $00
a5fc              .byte $00
a5fd              .byte $00
a5fe              .byte $00
a5ff              .byte $00
a600              .byte $20
                  .byte $00
                  .byte $00
a603              .byte $a8
a604              .byte $08
a605              .byte $00
a606              .byte $88
a607              .byte $2a
a608              .byte $00
a609              .byte $0f
a60a              .byte $e2
a60b              .byte $00
a60c              .byte $3f
a60d              .byte $fc
a60e              .byte $00
a60f              .byte $3f
a610              .byte $fc
a611              .byte $00
a612              .byte $15
                  .byte $54
a614              .byte $00
a615              .byte $16
                  .byte $54
a617              .byte $00
a618              .byte $3f
a619              .byte $bc
                  .byte $00
                  .byte $2f
a61c              .byte $e0
                  .byte $00
a61e              .byte $83
a61f              .byte $08
a620              .byte $00
a621              .byte $01
                  .byte $00
a623              .byte $00
a624              .byte $01
                  .byte $50
a626              .byte $00
a627              .byte $05
                  .byte $00
a629              .byte $00
a62a              .byte $05
                  .byte $10
a62c              .byte $00
a62d              .byte $05
                  .byte $54
a62f              .byte $00
a630              .byte $05
                  .byte $10
a632              .byte $00
a633              .byte $05
                  .byte $50
a635              .byte $00
a636              .byte $ff
a637              .byte $ff
a638              .byte $00
a639              .byte $0f
a63a              .byte $f0
                  .byte $00
a63c              .byte $03
a63d              .byte $c0
                  .byte $00
a63f              .byte $00
a640              .byte $ff
a641              .byte $ff
a642              .byte $ff
a643              .byte $ff
a644              .byte $ff
a645              .byte $ff
a646              .byte $ff
a647              .byte $ff
a648              .byte $ff
a649              .byte $00
a64a              .byte $00
a64b              .byte $00
a64c              .byte $00
a64d              .byte $00
a64e              .byte $00
a64f              .byte $00
a650              .byte $00
a651              .byte $00
a652              .byte $00
a653              .byte $00
a654              .byte $00
a655              .byte $00
a656              .byte $00
a657              .byte $00
a658              .byte $00
a659              .byte $00
a65a              .byte $00
a65b              .byte $00
a65c              .byte $00
a65d              .byte $00
a65e              .byte $00
a65f              .byte $00
a660              .byte $00
a661              .byte $00
a662              .byte $00
a663              .byte $00
a664              .byte $00
a665              .byte $00
a666              .byte $00
a667              .byte $00
a668              .byte $00
a669              .byte $00
a66a              .byte $00
a66b              .byte $00
a66c              .byte $00
a66d              .byte $00
a66e              .byte $00
a66f              .byte $00
a670              .byte $00
a671              .byte $00
a672              .byte $00
a673              .byte $00
a674              .byte $00
a675              .byte $00
a676              .byte $00
a677              .byte $00
a678              .byte $00
a679              .byte $00
a67a              .byte $00
a67b              .byte $00
a67c              .byte $00
a67d              .byte $00
a67e              .byte $00
a67f              .byte $00
a680              .byte $00
a681              .byte $f0
                  .byte $00
a683              .byte $03
a684              .byte $0c
a685              .byte $00
a686              .byte $0c
a687              .byte $03
a688              .byte $00
a689              .byte $11
                  .byte $f8
a68b              .byte $80
a68c              .byte $23
a68d              .byte $fc
a68e              .byte $40
a68f              .byte $27
a690              .byte $fe
                  .byte $40
                  .byte $47
a693              .byte $0e
                  .byte $20
                  .byte $40
a696              .byte $00
a697              .byte $20
                  .byte $87
                  .byte $0e
a69a              .byte $30
                  .byte $80
a69c              .byte $00
a69d              .byte $10
                  .byte $87
a69f              .byte $0e
                  .byte $10
                  .byte $80
a6a2              .byte $00
a6a3              .byte $10
                  .byte $78
a6a5              .byte $f1
                  .byte $e0
a6a7              .byte $78
a6a8              .byte $f1
                  .byte $e0
a6aa              .byte $38
a6ab              .byte $01
                  .byte $c0
a6ad              .byte $3c
a6ae              .byte $03
a6af              .byte $c0
                  .byte $1e
a6b1              .byte $07
a6b2              .byte $80
a6b3              .byte $0f
a6b4              .byte $ff
a6b5              .byte $00
a6b6              .byte $03
a6b7              .byte $fc
a6b8              .byte $00
a6b9              .byte $00
a6ba              .byte $f0
                  .byte $00
a6bc              .byte $00
a6bd              .byte $00
a6be              .byte $00
a6bf              .byte $00
a6c0              .byte $1e
                  .byte $1e
                  .byte $00
a6c3              .byte $33
a6c4              .byte $33
a6c5              .byte $00
a6c6              .byte $33
a6c7              .byte $33
a6c8              .byte $00
a6c9              .byte $1f
a6ca              .byte $33
a6cb              .byte $00
a6cc              .byte $03
a6cd              .byte $33
a6ce              .byte $00
a6cf              .byte $03
a6d0              .byte $33
a6d1              .byte $00
a6d2              .byte $06
                  .byte $33
a6d4              .byte $00
a6d5              .byte $0c
a6d6              .byte $33
a6d7              .byte $00
a6d8              .byte $18
a6d9              .byte $1e
                  .byte $00
                  .byte $00
a6dc              .byte $00
a6dd              .byte $00
a6de              .byte $00
a6df              .byte $00
a6e0              .byte $00
a6e1              .byte $00
a6e2              .byte $00
a6e3              .byte $00
a6e4              .byte $00
a6e5              .byte $00
a6e6              .byte $00
a6e7              .byte $00
a6e8              .byte $00
a6e9              .byte $00
a6ea              .byte $00
a6eb              .byte $00
a6ec              .byte $00
a6ed              .byte $00
a6ee              .byte $00
a6ef              .byte $00
a6f0              .byte $00
a6f1              .byte $00
a6f2              .byte $00
a6f3              .byte $00
a6f4              .byte $00
a6f5              .byte $00
a6f6              .byte $00
a6f7              .byte $00
a6f8              .byte $00
a6f9              .byte $00
a6fa              .byte $00
a6fb              .byte $00
a6fc              .byte $00
a6fd              .byte $00
a6fe              .byte $00
a6ff              .byte $00
a700              .byte $00
a701              .byte $00
a702              .byte $00
a703              .byte $00
a704              .byte $00
a705              .byte $00
a706              .byte $00
a707              .byte $00
a708              .byte $00
a709              .byte $00
a70a              .byte $00
a70b              .byte $00
a70c              .byte $03
a70d              .byte $1e
                  .byte $1e
                  .byte $03
a710              .byte $33
a711              .byte $33
a712              .byte $03
a713              .byte $33
a714              .byte $33
a715              .byte $03
a716              .byte $33
a717              .byte $33
a718              .byte $03
a719              .byte $33
a71a              .byte $33
a71b              .byte $03
a71c              .byte $33
a71d              .byte $33
a71e              .byte $03
a71f              .byte $33
a720              .byte $33
a721              .byte $03
a722              .byte $33
a723              .byte $33
a724              .byte $03
a725              .byte $1e
                  .byte $1e
                  .byte $00
a728              .byte $00
a729              .byte $00
a72a              .byte $00
a72b              .byte $00
a72c              .byte $00
a72d              .byte $00
a72e              .byte $00
a72f              .byte $00
a730              .byte $00
a731              .byte $00
a732              .byte $00
a733              .byte $00
a734              .byte $00
a735              .byte $00
a736              .byte $00
a737              .byte $00
a738              .byte $00
a739              .byte $00
a73a              .byte $00
a73b              .byte $00
a73c              .byte $00
a73d              .byte $00
a73e              .byte $00
a73f              .byte $00
a740              .byte $00
a741              .byte $00
a742              .byte $00
a743              .byte $00
a744              .byte $00
a745              .byte $00
a746              .byte $00
a747              .byte $00
a748              .byte $00
a749              .byte $00
a74a              .byte $00
a74b              .byte $00
a74c              .byte $1e
                  .byte $1e
                  .byte $1e
a74f              .byte $33
a750              .byte $33
a751              .byte $33
a752              .byte $33
a753              .byte $33
a754              .byte $33
a755              .byte $03
a756              .byte $33
a757              .byte $33
a758              .byte $06
                  .byte $33
a75a              .byte $33
a75b              .byte $0c
a75c              .byte $33
a75d              .byte $33
a75e              .byte $18
a75f              .byte $33
a760              .byte $33
a761              .byte $30
                  .byte $33
a763              .byte $33
a764              .byte $3f
a765              .byte $1e
                  .byte $1e
                  .byte $00
a768              .byte $00
a769              .byte $00
a76a              .byte $00
a76b              .byte $00
a76c              .byte $00
a76d              .byte $00
a76e              .byte $00
a76f              .byte $00
a770              .byte $00
a771              .byte $00
a772              .byte $00
a773              .byte $00
a774              .byte $00
a775              .byte $00
a776              .byte $00
a777              .byte $00
a778              .byte $00
a779              .byte $00
a77a              .byte $00
a77b              .byte $00
a77c              .byte $00
a77d              .byte $00
a77e              .byte $00
a77f              .byte $00
a780              .byte $00
a781              .byte $00
a782              .byte $00
a783              .byte $00
a784              .byte $00
a785              .byte $00
a786              .byte $00
a787              .byte $00
a788              .byte $00
a789              .byte $00
a78a              .byte $00
a78b              .byte $00
a78c              .byte $1e
                  .byte $1e
                  .byte $1e
a78f              .byte $33
a790              .byte $33
a791              .byte $33
a792              .byte $03
a793              .byte $33
a794              .byte $33
a795              .byte $03
a796              .byte $33
a797              .byte $33
a798              .byte $06
                  .byte $33
a79a              .byte $33
a79b              .byte $03
a79c              .byte $33
a79d              .byte $33
a79e              .byte $03
a79f              .byte $33
a7a0              .byte $33
a7a1              .byte $33
a7a2              .byte $33
a7a3              .byte $33
a7a4              .byte $1e
                  .byte $1e
                  .byte $1e
a7a7              .byte $00
a7a8              .byte $00
a7a9              .byte $00
a7aa              .byte $00
a7ab              .byte $00
a7ac              .byte $00
a7ad              .byte $00
a7ae              .byte $00
a7af              .byte $00
a7b0              .byte $00
a7b1              .byte $00
a7b2              .byte $00
a7b3              .byte $00
a7b4              .byte $00
a7b5              .byte $00
a7b6              .byte $00
a7b7              .byte $00
a7b8              .byte $00
a7b9              .byte $00
a7ba              .byte $00
a7bb              .byte $00
a7bc              .byte $00
a7bd              .byte $00
a7be              .byte $00
a7bf              .byte $00
a7c0              .byte $00
a7c1              .byte $00
a7c2              .byte $00
a7c3              .byte $00
a7c4              .byte $00
a7c5              .byte $00
a7c6              .byte $00
a7c7              .byte $00
a7c8              .byte $00
a7c9              .byte $00
a7ca              .byte $00
a7cb              .byte $00
a7cc              .byte $06
                  .byte $1e
a7ce              .byte $1e
                  .byte $0e
                  .byte $33
a7d1              .byte $33
a7d2              .byte $1e
                  .byte $33
                  .byte $33
a7d5              .byte $36
                  .byte $33
a7d7              .byte $33
a7d8              .byte $66
                  .byte $33
a7da              .byte $33
a7db              .byte $ff
a7dc              .byte $33
a7dd              .byte $33
a7de              .byte $ff
a7df              .byte $33
a7e0              .byte $33
a7e1              .byte $06
                  .byte $33
a7e3              .byte $33
a7e4              .byte $06
                  .byte $1e
a7e6              .byte $1e
                  .byte $00
                  .byte $00
a7e9              .byte $00
a7ea              .byte $00
a7eb              .byte $00
a7ec              .byte $00
a7ed              .byte $00
a7ee              .byte $00
a7ef              .byte $00
a7f0              .byte $00
a7f1              .byte $00
a7f2              .byte $00
a7f3              .byte $00
a7f4              .byte $00
a7f5              .byte $00
a7f6              .byte $00
a7f7              .byte $00
a7f8              .byte $00
a7f9              .byte $00
a7fa              .byte $00
a7fb              .byte $00
a7fc              .byte $00
a7fd              .byte $00
a7fe              .byte $00
a7ff              .byte $00
a800              .byte $00
a801              .byte $00
a802              .byte $00
a803              .byte $00
a804              .byte $00
a805              .byte $00
a806              .byte $00
a807              .byte $00
a808              .byte $00
a809              .byte $00
a80a              .byte $00
a80b              .byte $00
a80c              .byte $3f
a80d              .byte $1e
                  .byte $1e
                  .byte $30
a810              .byte $33
a811              .byte $33
a812              .byte $30
                  .byte $33
a814              .byte $33
a815              .byte $3e
                  .byte $33
                  .byte $33
a818              .byte $03
a819              .byte $33
a81a              .byte $33
a81b              .byte $03
a81c              .byte $33
a81d              .byte $33
a81e              .byte $03
a81f              .byte $33
a820              .byte $33
a821              .byte $33
a822              .byte $33
a823              .byte $33
a824              .byte $1e
                  .byte $1e
                  .byte $1e
a827              .byte $00
a828              .byte $00
a829              .byte $00
a82a              .byte $00
a82b              .byte $00
a82c              .byte $00
a82d              .byte $00
a82e              .byte $00
a82f              .byte $00
a830              .byte $00
a831              .byte $00
a832              .byte $00
a833              .byte $00
a834              .byte $00
a835              .byte $00
a836              .byte $00
a837              .byte $00
a838              .byte $00
a839              .byte $00
a83a              .byte $00
a83b              .byte $00
a83c              .byte $00
a83d              .byte $00
a83e              .byte $00
a83f              .byte $00
a840              .byte $00
a841              .byte $00
a842              .byte $00
a843              .byte $00
a844              .byte $00
a845              .byte $00
a846              .byte $00
a847              .byte $00
a848              .byte $00
a849              .byte $00
a84a              .byte $00
a84b              .byte $00
a84c              .byte $33
a84d              .byte $1e
                  .byte $1e
                  .byte $33
a850              .byte $33
a851              .byte $33
a852              .byte $33
a853              .byte $33
a854              .byte $33
a855              .byte $33
a856              .byte $33
a857              .byte $33
a858              .byte $33
a859              .byte $33
a85a              .byte $33
a85b              .byte $33
a85c              .byte $33
a85d              .byte $33
a85e              .byte $33
a85f              .byte $33
a860              .byte $33
a861              .byte $33
a862              .byte $33
a863              .byte $33
a864              .byte $33
a865              .byte $1e
                  .byte $1e
                  .byte $00
a868              .byte $00
a869              .byte $00
a86a              .byte $00
a86b              .byte $00
a86c              .byte $00
a86d              .byte $00
a86e              .byte $00
a86f              .byte $00
a870              .byte $00
a871              .byte $00
a872              .byte $00
a873              .byte $00
a874              .byte $00
a875              .byte $00
a876              .byte $00
a877              .byte $00
a878              .byte $00
a879              .byte $00
a87a              .byte $00
a87b              .byte $00
a87c              .byte $00
a87d              .byte $00
a87e              .byte $00
a87f              .byte $00
a880              .byte $00
a881              .byte $00
a882              .byte $16
                  .byte $aa
a884              .byte $aa
a885              .byte $aa
a886              .byte $aa
a887              .byte $14
a888              .byte $14
a889              .byte $14
a88a              .byte $14
a88b              .byte $14
a88c              .byte $14
a88d              .byte $14
a88e              .byte $14
a88f              .byte $14
a890              .byte $20
                  .byte $a8
                  .byte $aa
a893              .byte $aa
a894              .byte $aa
a895              .byte $aa
a896              .byte $a8
a897              .byte $20
                  .byte $00
                  .byte $00
a89a              .byte $00
a89b              .byte $00
a89c              .byte $00
a89d              .byte $00
a89e              .byte $00
a89f              .byte $00
a8a0              .byte $00
a8a1              .byte $00
a8a2              .byte $00
a8a3              .byte $00
a8a4              .byte $00
a8a5              .byte $55
                  .byte $aa
a8a7              .byte $55
                  .byte $55
a8a9              .byte $aa
a8aa              .byte $14
a8ab              .byte $00
a8ac              .byte $00
a8ad              .byte $00
a8ae              .byte $00
a8af              .byte $00
a8b0              .byte $00
a8b1              .byte $00
a8b2              .byte $00
a8b3              .byte $00
a8b4              .byte $00
a8b5              .byte $20
                  .byte $88
                  .byte $08
a8b8              .byte $20
                  .byte $80
                  .byte $00
a8bb              .byte $00
a8bc              .byte $00
a8bd              .byte $00
a8be              .byte $00
a8bf              .byte $00
a8c0              .byte $00
a8c1              .byte $00
a8c2              .byte $00
a8c3              .byte $00
a8c4              .byte $00
a8c5              .byte $00
a8c6              .byte $00
a8c7              .byte $2a
a8c8              .byte $aa
a8c9              .byte $aa
a8ca              .byte $55
                  .byte $55
a8cc              .byte $15
                  .byte $00
a8ce              .byte $00
a8cf              .byte $00
a8d0              .byte $00
a8d1              .byte $00
a8d2              .byte $00
a8d3              .byte $00
a8d4              .byte $00
a8d5              .byte $00
a8d6              .byte $00
a8d7              .byte $a0
                  .byte $a8
a8d9              .byte $a8
a8da              .byte $54
a8db              .byte $54
a8dc              .byte $50
                  .byte $00
a8de              .byte $00
a8df              .byte $00
a8e0              .byte $00
a8e1              .byte $00
a8e2              .byte $00
a8e3              .byte $00
a8e4              .byte $00
a8e5              .byte $00
a8e6              .byte $00
a8e7              .byte $00
a8e8              .byte $0a
a8e9              .byte $5a
a8ea              .byte $5a
a8eb              .byte $0a
a8ec              .byte $00
a8ed              .byte $00
a8ee              .byte $00
a8ef              .byte $00
a8f0              .byte $00
a8f1              .byte $00
a8f2              .byte $00
a8f3              .byte $00
a8f4              .byte $00
a8f5              .byte $00
a8f6              .byte $00
a8f7              .byte $00
a8f8              .byte $a0
                  .byte $a5
a8fa              .byte $a5
                  .byte $a0
a8fc              .byte $00
a8fd              .byte $00
a8fe              .byte $00
a8ff              .byte $00
a900              .byte $00
a901              .byte $00
a902              .byte $00
a903              .byte $28
a904              .byte $28
a905              .byte $aa
a906              .byte $aa
a907              .byte $55
                  .byte $55
a909              .byte $55
                  .byte $55
a90b              .byte $55
                  .byte $00
a90d              .byte $00
a90e              .byte $00
a90f              .byte $00
a910              .byte $00
a911              .byte $00
a912              .byte $00
a913              .byte $00
a914              .byte $00
a915              .byte $00
a916              .byte $00
a917              .byte $00
a918              .byte $00
a919              .byte $00
a91a              .byte $00
a91b              .byte $00
a91c              .byte $00
a91d              .byte $00
a91e              .byte $00
a91f              .byte $00
a920              .byte $2a
a921              .byte $80
a922              .byte $22
a923              .byte $08
a924              .byte $08
a925              .byte $08
a926              .byte $08
a927              .byte $08
a928              .byte $08
a929              .byte $08
a92a              .byte $08
a92b              .byte $55
                  .byte $55
a92d              .byte $55
                  .byte $15
a92f              .byte $04
a930              .byte $00
a931              .byte $80
a932              .byte $00
a933              .byte $00
a934              .byte $00
a935              .byte $00
a936              .byte $00
a937              .byte $00
a938              .byte $00
a939              .byte $00
a93a              .byte $00
a93b              .byte $40
a93c              .byte $40
a93d              .byte $40
a93e              .byte $00
a93f              .byte $00
a940              .byte $00
a941              .byte $00
a942              .byte $6a
a943              .byte $1a
a944              .byte $06
                  .byte $01
a946              .byte $01
                  .byte $02
a948              .byte $02
a949              .byte $01
                  .byte $01
a94b              .byte $01
                  .byte $01
a94d              .byte $01
                  .byte $01
a94f              .byte $00
a950              .byte $00
a951              .byte $00
a952              .byte $a4
                  .byte $90
a954              .byte $40
a955              .byte $00
a956              .byte $00
a957              .byte $a0
                  .byte $00
a959              .byte $00
a95a              .byte $00
a95b              .byte $00
a95c              .byte $00
a95d              .byte $00
a95e              .byte $00
a95f              .byte $00
a960              .byte $00
a961              .byte $00
a962              .byte $00
a963              .byte $00
a964              .byte $00
a965              .byte $2a
a966              .byte $aa
a967              .byte $15
                  .byte $15
a969              .byte $aa
a96a              .byte $2a
a96b              .byte $00
a96c              .byte $00
a96d              .byte $00
a96e              .byte $00
a96f              .byte $00
a970              .byte $00
a971              .byte $00
a972              .byte $00
a973              .byte $00
a974              .byte $00
a975              .byte $a8
a976              .byte $aa
a977              .byte $54
a978              .byte $54
a979              .byte $aa
a97a              .byte $a8
a97b              .byte $00
a97c              .byte $00
a97d              .byte $00
a97e              .byte $00
a97f              .byte $00
a980              .byte $00
a981              .byte $02
a982              .byte $2a
a983              .byte $22
a984              .byte $81
                  .byte $01
a986              .byte $01
                  .byte $01
a988              .byte $01
                  .byte $01
a98a              .byte $01
                  .byte $01
a98c              .byte $01
                  .byte $01
a98e              .byte $01
                  .byte $00
a990              .byte $00
a991              .byte $00
a992              .byte $a0
                  .byte $20
a994              .byte $08
a995              .byte $00
a996              .byte $00
a997              .byte $00
a998              .byte $00
a999              .byte $00
a99a              .byte $00
a99b              .byte $00
a99c              .byte $00
a99d              .byte $00
a99e              .byte $00
a99f              .byte $00
a9a0              .byte $00
a9a1              .byte $00
a9a2              .byte $00
a9a3              .byte $00
a9a4              .byte $00
a9a5              .byte $00
a9a6              .byte $00
a9a7              .byte $01
                  .byte $04
a9a9              .byte $10
                  .byte $aa
a9ab              .byte $aa
a9ac              .byte $2a
a9ad              .byte $00
a9ae              .byte $00
a9af              .byte $00
a9b0              .byte $00
a9b1              .byte $00
a9b2              .byte $00
a9b3              .byte $00
a9b4              .byte $00
a9b5              .byte $00
a9b6              .byte $40
a9b7              .byte $00
a9b8              .byte $00
a9b9              .byte $00
a9ba              .byte $aa
a9bb              .byte $aa
a9bc              .byte $a8
a9bd              .byte $00
a9be              .byte $00
a9bf              .byte $00
a9c0              .byte $00
a9c1              .byte $00
a9c2              .byte $00
a9c3              .byte $00
a9c4              .byte $00
a9c5              .byte $00
a9c6              .byte $00
a9c7              .byte $00
a9c8              .byte $00
a9c9              .byte $20
                  .byte $88
                  .byte $82
a9cc              .byte $15
                  .byte $00
a9ce              .byte $00
a9cf              .byte $00
a9d0              .byte $00
a9d1              .byte $00
a9d2              .byte $00
a9d3              .byte $04
a9d4              .byte $10
                  .byte $10
a9d6              .byte $10
                  .byte $10
a9d8              .byte $10
                  .byte $10
a9da              .byte $10
                  .byte $10
a9dc              .byte $55
                  .byte $00
a9de              .byte $00
a9df              .byte $00
a9e0              .byte $00
a9e1              .byte $00
a9e2              .byte $20
                  .byte $80
                  .byte $80
a9e5              .byte $2a
a9e6              .byte $0a
a9e7              .byte $20
                  .byte $80
                  .byte $80
a9ea              .byte $80
a9eb              .byte $80
a9ec              .byte $80
a9ed              .byte $80
a9ee              .byte $00
a9ef              .byte $00
a9f0              .byte $00
a9f1              .byte $00
a9f2              .byte $80
a9f3              .byte $20
                  .byte $20
                  .byte $80
a9f6              .byte $00
a9f7              .byte $80
a9f8              .byte $20
                  .byte $20
                  .byte $20
a9fb              .byte $20
                  .byte $20
                  .byte $20
a9fe              .byte $00
a9ff              .byte $00
aa00              .byte $00
aa01              .byte $00
aa02              .byte $15
                  .byte $01
aa04              .byte $01
                  .byte $01
aa06              .byte $21
                  .byte $21
aa08              .byte $55
                  .byte $55
aa0a              .byte $55
                  .byte $55
aa0c              .byte $55
                  .byte $55
aa0e              .byte $00
aa0f              .byte $00
aa10              .byte $00
aa11              .byte $00
aa12              .byte $54
aa13              .byte $40
aa14              .byte $40
aa15              .byte $40
aa16              .byte $48
aa17              .byte $48
aa18              .byte $55
                  .byte $55
aa1a              .byte $55
                  .byte $55
aa1c              .byte $55
                  .byte $55
aa1e              .byte $00
aa1f              .byte $00
aa20              .byte $00
aa21              .byte $00
aa22              .byte $20
                  .byte $95
                  .byte $95
aa25              .byte $21
                  .byte $01
aa27              .byte $05
                  .byte $05
aa29              .byte $05
                  .byte $02
aa2b              .byte $02
aa2c              .byte $02
aa2d              .byte $02
aa2e              .byte $02
aa2f              .byte $00
aa30              .byte $00
aa31              .byte $00
aa32              .byte $08
aa33              .byte $56
                  .byte $56
aa35              .byte $48
aa36              .byte $40
aa37              .byte $50
                  .byte $50
aa39              .byte $50
                  .byte $80
aa3b              .byte $80
aa3c              .byte $80
aa3d              .byte $80
aa3e              .byte $80
aa3f              .byte $00
aa40              .byte $00
aa41              .byte $00
aa42              .byte $00
aa43              .byte $00
aa44              .byte $55
                  .byte $55
aa46              .byte $55
                  .byte $55
aa48              .byte $55
                  .byte $41
aa4a              .byte $01
                  .byte $01
aa4c              .byte $01
                  .byte $15
aa4e              .byte $55
                  .byte $00
aa50              .byte $00
aa51              .byte $00
aa52              .byte $00
aa53              .byte $00
aa54              .byte $55
                  .byte $54
aa56              .byte $50
                  .byte $50
aa58              .byte $50
                  .byte $50
aa5a              .byte $50
                  .byte $50
aa5c              .byte $50
                  .byte $54
aa5e              .byte $55
                  .byte $00
aa60              .byte $00
aa61              .byte $00
aa62              .byte $00
aa63              .byte $15
                  .byte $41
aa65              .byte $41
                  .byte $41
aa67              .byte $14
aa68              .byte $00
aa69              .byte $00
aa6a              .byte $00
aa6b              .byte $00
aa6c              .byte $00
aa6d              .byte $00
aa6e              .byte $00
aa6f              .byte $00
aa70              .byte $00
aa71              .byte $00
aa72              .byte $00
aa73              .byte $54
aa74              .byte $41
                  .byte $41
aa76              .byte $41
                  .byte $14
aa78              .byte $00
aa79              .byte $00
aa7a              .byte $00
aa7b              .byte $00
aa7c              .byte $00
aa7d              .byte $00
aa7e              .byte $00
aa7f              .byte $00
aa80              .byte $00
aa81              .byte $00
aa82              .byte $00
aa83              .byte $00
aa84              .byte $2a
aa85              .byte $80
aa86              .byte $80
aa87              .byte $20
                  .byte $55
                  .byte $55
aa8a              .byte $00
aa8b              .byte $00
aa8c              .byte $00
aa8d              .byte $00
aa8e              .byte $00
aa8f              .byte $00
aa90              .byte $00
aa91              .byte $00
aa92              .byte $00
aa93              .byte $00
aa94              .byte $80
aa95              .byte $20
                  .byte $20
                  .byte $80
aa98              .byte $54
aa99              .byte $55
                  .byte $00
aa9b              .byte $00
aa9c              .byte $00
aa9d              .byte $00
aa9e              .byte $00
aa9f              .byte $00
aaa0              .byte $00
aaa1              .byte $00
aaa2              .byte $00
aaa3              .byte $1a
aaa4              .byte $1a
aaa5              .byte $06
                  .byte $01
aaa7              .byte $00
aaa8              .byte $00
aaa9              .byte $00
aaaa              .byte $00
aaab              .byte $00
aaac              .byte $01
                  .byte $05
aaae              .byte $00
aaaf              .byte $00
aab0              .byte $00
aab1              .byte $00
aab2              .byte $00
aab3              .byte $a9
                  .byte $a9
aab5              .byte $a4
                  .byte $90
aab7              .byte $40
aab8              .byte $40
aab9              .byte $40
aaba              .byte $40
aabb              .byte $40
aabc              .byte $50
                  .byte $54
aabe              .byte $00
aabf              .byte $00
aac0              .byte $00
aac1              .byte $00
aac2              .byte $00
aac3              .byte $01
                  .byte $11
aac5              .byte $11
                  .byte $2a
aac7              .byte $2a
aac8              .byte $15
                  .byte $2a
aaca              .byte $2a
aacb              .byte $15
                  .byte $2a
aacd              .byte $2a
aace              .byte $00
aacf              .byte $00
aad0              .byte $00
aad1              .byte $00
aad2              .byte $00
aad3              .byte $00
aad4              .byte $10
                  .byte $10
aad6              .byte $a0
                  .byte $a0
aad8              .byte $50
                  .byte $a0
aada              .byte $a0
                  .byte $50
aadc              .byte $a0
                  .byte $a0
aade              .byte $00
aadf              .byte $00
aae0              .byte $00
aae1              .byte $00
aae2              .byte $00
aae3              .byte $00
aae4              .byte $14
aae5              .byte $69
                  .byte $14
aae7              .byte $0a
aae8              .byte $02
aae9              .byte $15
                  .byte $15
aaeb              .byte $05
                  .byte $05
aaed              .byte $05
                  .byte $00
aaef              .byte $00
aaf0              .byte $00
aaf1              .byte $00
aaf2              .byte $00
aaf3              .byte $04
aaf4              .byte $19
                  .byte $04
                  .byte $20
aaf7              .byte $a0
                  .byte $80
aaf9              .byte $54
aafa              .byte $54
aafb              .byte $50
                  .byte $50
aafd              .byte $50
                  .byte $00
aaff              .byte $00
ab00              .byte $00
ab01              .byte $00
ab02              .byte $00
ab03              .byte $00
ab04              .byte $00
ab05              .byte $00
ab06              .byte $00
ab07              .byte $00
ab08              .byte $00
ab09              .byte $10
                  .byte $15
ab0b              .byte $15
                  .byte $15
ab0d              .byte $00
ab0e              .byte $00
ab0f              .byte $00
ab10              .byte $00
ab11              .byte $00
ab12              .byte $00
ab13              .byte $00
ab14              .byte $00
ab15              .byte $40
ab16              .byte $41
                  .byte $41
ab18              .byte $44
ab19              .byte $41
                  .byte $51
ab1b              .byte $5a
ab1c              .byte $50
                  .byte $00
ab1e              .byte $00
ab1f              .byte $00
ab20              .byte $00
ab21              .byte $00
ab22              .byte $00
ab23              .byte $55
                  .byte $56
ab25              .byte $5a
ab26              .byte $66
                  .byte $66
ab28              .byte $5a
ab29              .byte $56
                  .byte $66
ab2b              .byte $5a
ab2c              .byte $56
                  .byte $55
ab2e              .byte $00
ab2f              .byte $00
ab30              .byte $00
ab31              .byte $00
ab32              .byte $00
ab33              .byte $55
                  .byte $95
ab35              .byte $a5
                  .byte $99
ab37              .byte $95
                  .byte $a5
ab39              .byte $99
                  .byte $99
                  .byte $a5
ab3c              .byte $95
                  .byte $55
ab3e              .byte $00
ab3f              .byte $00
ab40              .byte $00
ab41              .byte $00
ab42              .byte $00
ab43              .byte $00
ab44              .byte $00
ab45              .byte $05
                  .byte $04
ab47              .byte $04
ab48              .byte $04
ab49              .byte $15
                  .byte $15
ab4b              .byte $15
                  .byte $15
ab4d              .byte $05
                  .byte $00
ab4f              .byte $00
ab50              .byte $00
ab51              .byte $00
ab52              .byte $00
ab53              .byte $00
ab54              .byte $00
ab55              .byte $40
ab56              .byte $40
ab57              .byte $40
ab58              .byte $40
ab59              .byte $51
                  .byte $54
ab5b              .byte $50
                  .byte $50
ab5d              .byte $40
ab5e              .byte $00
ab5f              .byte $00
ab60              .byte $00
ab61              .byte $00
ab62              .byte $00
ab63              .byte $02
ab64              .byte $0a
ab65              .byte $22
ab66              .byte $81
                  .byte $01
ab68              .byte $01
                  .byte $01
ab6a              .byte $01
                  .byte $01
ab6c              .byte $01
                  .byte $01
ab6e              .byte $01
                  .byte $00
ab70              .byte $00
ab71              .byte $00
ab72              .byte $00
ab73              .byte $a0
                  .byte $a0
ab75              .byte $a0
                  .byte $00
ab77              .byte $00
ab78              .byte $00
ab79              .byte $00
ab7a              .byte $00
ab7b              .byte $00
ab7c              .byte $00
ab7d              .byte $00
ab7e              .byte $00
ab7f              .byte $00
ab80              .byte $20
                  .byte $82
                  .byte $82
ab83              .byte $82
ab84              .byte $42
ab85              .byte $85
                  .byte $82
ab87              .byte $82
ab88              .byte $55
                  .byte $05
ab8a              .byte $02
ab8b              .byte $02
ab8c              .byte $02
ab8d              .byte $02
ab8e              .byte $15
                  .byte $55
ab90              .byte $82
ab91              .byte $08
ab92              .byte $08
ab93              .byte $08
ab94              .byte $04
ab95              .byte $48
ab96              .byte $08
ab97              .byte $08
ab98              .byte $54
ab99              .byte $40
ab9a              .byte $00
ab9b              .byte $00
ab9c              .byte $00
ab9d              .byte $00
ab9e              .byte $50
                  .byte $54
aba0              .byte $aa
aba1              .byte $aa
aba2              .byte $a0
                  .byte $a0
aba4              .byte $aa
aba5              .byte $aa
aba6              .byte $a2
                  .byte $a2
aba8              .byte $a2
                  .byte $a2
abaa              .byte $01
                  .byte $01
abac              .byte $01
                  .byte $01
abae              .byte $01
                  .byte $01
abb0              .byte $00
abb1              .byte $80
abb2              .byte $80
abb3              .byte $80
abb4              .byte $80
abb5              .byte $00
abb6              .byte $54
abb7              .byte $55
                  .byte $41
abb9              .byte $41
                  .byte $55
abbb              .byte $55
                  .byte $44
abbd              .byte $45
                  .byte $45
abbf              .byte $45
                  .byte $00
abc1              .byte $00
abc2              .byte $00
abc3              .byte $00
abc4              .byte $00
abc5              .byte $02
abc6              .byte $02
abc7              .byte $0a
abc8              .byte $0a
abc9              .byte $0a
abca              .byte $0a
abcb              .byte $0a
abcc              .byte $00
abcd              .byte $00
abce              .byte $00
abcf              .byte $00
abd0              .byte $00
abd1              .byte $00
abd2              .byte $00
abd3              .byte $00
abd4              .byte $00
abd5              .byte $00
abd6              .byte $00
abd7              .byte $80
abd8              .byte $80
abd9              .byte $80
abda              .byte $80
abdb              .byte $80
abdc              .byte $00
abdd              .byte $00
abde              .byte $00
abdf              .byte $00
abe0              .byte $00
abe1              .byte $00
abe2              .byte $00
abe3              .byte $00
abe4              .byte $00
abe5              .byte $20
                  .byte $20
                  .byte $a8
abe8              .byte $a8
abe9              .byte $a8
abea              .byte $a8
abeb              .byte $a8
abec              .byte $00
abed              .byte $00
abee              .byte $00
abef              .byte $00
abf0              .byte $00
abf1              .byte $00
abf2              .byte $00
abf3              .byte $00
abf4              .byte $00
abf5              .byte $20
                  .byte $20
                  .byte $a8
abf8              .byte $a8
abf9              .byte $a8
abfa              .byte $a8
abfb              .byte $a8
abfc              .byte $00
abfd              .byte $00
abfe              .byte $00
abff              .byte $00
ac00              .byte $00
ac01              .byte $02
ac02              .byte $02
ac03              .byte $0a
ac04              .byte $0a
ac05              .byte $0a
ac06              .byte $0a
ac07              .byte $0a
ac08              .byte $00
ac09              .byte $20
                  .byte $20
                  .byte $a8
ac0c              .byte $a8
ac0d              .byte $a8
ac0e              .byte $a8
ac0f              .byte $a8
ac10              .byte $00
ac11              .byte $00
ac12              .byte $00
ac13              .byte $80
ac14              .byte $80
ac15              .byte $80
ac16              .byte $80
ac17              .byte $80
ac18              .byte $00
ac19              .byte $20
                  .byte $20
                  .byte $a8
ac1c              .byte $a8
ac1d              .byte $a8
ac1e              .byte $a8
ac1f              .byte $a8
ac20              .byte $c9
                  .byte $2c
ac22              .byte $f0
                  .byte $06
ac24              .byte $20
                  .byte $f1
                  .byte $29
ac27              .byte $4c
                  .byte $1b
                  .byte $2c
ac2a              .byte $20
                  .byte $87
                  .byte $2c
ac2d              .byte $4c
                  .byte $1b
                  .byte $2c
ac30              .byte $20
                  .byte $87
                  .byte $2c 
ac33              .byte $60
ac34              .byte $48

ac35              .byte $ad
                  .byte $85
                  .byte $09
ac38              .byte $8d
                  .byte $78
                  .byte $09
ac3b              .byte $ad
                  .byte $86
                  .byte $09
ac3e              .byte $8d
ac41              .byte $79
ac43              .byte $09
ac46              .byte $a9
ac47              .byte $80
ac4a              .byte $8d
ac4c              .byte $7f
ac4f              .byte $08
ac52              .byte $68
ac55              .byte $ae
ac57              .byte $6a
ac59              .byte $08
ac5c              .byte $a0
ac5e              .byte $00
                  .byte $4c
                  .byte $c8
                  .byte $15
                  .byte $ae
                  .byte $6e
                  .byte $08
                  .byte $ec
                  .byte $77
                  .byte $08
                  .byte $f0
                  .byte $02
                  .byte $b0
                  .byte $10
                  .byte $bd
                  .byte $80
                  .byte $08
                  .byte $c9
                  .byte $20
                  .byte $f0
                  .byte $09
                  
ac60              .byte $00  
ac61              .byte $00  
ac62              .byte $00  
ac63              .byte $00  
ac64              .byte $00  
ac65              .byte $00  
ac66              .byte $00  
ac67              .byte $00  
ac68              .byte $00  
ac69              .byte $00
ac6a              .byte $00
ac6b              .byte $00
ac6c              .byte $00
ac6d              .byte $00
ac6e              .byte $00
ac6f              .byte $00
ac70              .byte $00
ac71              .byte $00
ac72              .byte $00
ac73              .byte $00
ac74              .byte $00
ac75              .byte $00
ac76              .byte $00
ac77              .byte $00
ac78              .byte $00
ac79              .byte $00
ac7a              .byte $00
ac7b              .byte $00
ac7c              .byte $00
ac7d              .byte $00
ac7e              .byte $00
ac7f              .byte $00
ac80              .byte $28
ac81              .byte $00
ac82              .byte $c7
ac83              .byte $04
ac84              .byte $28
ac85              .byte $04
ac86              .byte $0c
ac87              .byte $c0
                  .byte $f4
ac89              .byte $08
ac8a              .byte $0c
ac8b              .byte $1c
ac8c              .byte $bd
                  .byte $04
                  .byte $80
ac8f              .byte $08
ac90              .byte $4c
                  .byte $bc
                  .byte $f4
ac93              .byte $08
ac94              .byte $0d
                  .byte $6c
                  .byte $b5
ac97              .byte $04
ac98              .byte $80
ac99              .byte $02
ac9a              .byte $70
                  .byte $b7
ac9c              .byte $80
ac9d              .byte $13
ac9e              .byte $02
ac9f              .byte $74
aca0              .byte $b7
aca1              .byte $80
aca2              .byte $1b
aca3              .byte $04
aca4              .byte $22
aca5              .byte $9d
                  .byte $80
                  .byte $14
aca8              .byte $04
aca9              .byte $26
                  .byte $9d
acab              .byte $80
acac              .byte $1c
acad              .byte $12
acae              .byte $00
acaf              .byte $9c
acb0              .byte $04
acb1              .byte $80
acb2              .byte $12
acb3              .byte $48
acb4              .byte $9d
                  .byte $14
                  .byte $08
acb7              .byte $02
acb8              .byte $08
acb9              .byte $8a
acba              .byte $04
acbb              .byte $80
acbc              .byte $0e
                  .byte $1c
                  .byte $84
acbf              .byte $f4
acc0              .byte $08
acc1              .byte $10
                  .byte $54
acc3              .byte $78
acc4              .byte $14
acc5              .byte $08
acc6              .byte $03
acc7              .byte $4e
                  .byte $60
                  .byte $80
acca              .byte $14
accb              .byte $03
accc              .byte $52
accd              .byte $60
acce              .byte $80
accf              .byte $1c
acd0              .byte $11
                  .byte $0c
acd2              .byte $4f
acd3              .byte $14
acd4              .byte $08
acd5              .byte $11
                  .byte $50
acd7              .byte $60
acd8              .byte $f4
acd9              .byte $08
acda              .byte $04
acdb              .byte $2c
                  .byte $38
                  .byte $80
acde              .byte $14
acdf              .byte $04
ace0              .byte $30
                  .byte $38
ace2              .byte $80
ace3              .byte $1c
ace4              .byte $24
                  .byte $08
ace6              .byte $37
ace7              .byte $04
ace8              .byte $80
ace9              .byte $04
acea              .byte $34
aceb              .byte $7c
acec              .byte $80
aced              .byte $16
                  .byte $04
acef              .byte $38
acf0              .byte $7c
acf1              .byte $80
acf2              .byte $1e
                  .byte $03
                  .byte $80
acf5              .byte $3c
acf6              .byte $80
acf7              .byte $10
                  .byte $03
acf9              .byte $84
                  .byte $3c
acfb              .byte $80
acfc              .byte $18
acfd              .byte $05
                  .byte $78
acff              .byte $82
ad00              .byte $80
ad01              .byte $14
ad02              .byte $05
                  .byte $7c
ad04              .byte $82
ad05              .byte $80
ad06              .byte $1c
ad07              .byte $00
ad08              .byte $7c
ad09              .byte $d2
ad0a              .byte $e4
                  .byte $2e
ad0c              .byte $b9
                  .byte $da
                  .byte $84
ad0f              .byte $9e
ad10              .byte $c6
                  .byte $40
ad12              .byte $9b
ad13              .byte $b9
                  .byte $5a
                  .byte $7d
ad16              .byte $94
                  .byte $8c
ad18              .byte $54
ad19              .byte $71
                  .byte $38
ad1b              .byte $54
ad1c              .byte $75
                  .byte $00
ad1e              .byte $ff
ad1f              .byte $10
                  .byte $e4
ad21              .byte $97
ad22              .byte $01
                  .byte $00
ad24              .byte $00
ad25              .byte $ff
ad26              .byte $02
ad27              .byte $01
                  .byte $01
ad29              .byte $00
ad2a              .byte $01
                  .byte $00
ad2c              .byte $ff
ad2d              .byte $80
ad2e              .byte $ef
ad2f              .byte $a0
                  .byte $0a
ad31              .byte $00
ad32              .byte $00
ad33              .byte $00
ad34              .byte $03
ad35              .byte $06
                  .byte $ff
ad37              .byte $10
                  .byte $8c
ad39              .byte $00
ad3a              .byte $ff
ad3b              .byte $28
ad3c              .byte $c4
                  .byte $a2
ad3e              .byte $04
ad3f              .byte $00
ad40              .byte $00
ad41              .byte $00
ad42              .byte $20
                  .byte $05
                  .byte $01
ad45              .byte $1c
ad46              .byte $50
                  .byte $00
ad48              .byte $ff
ad49              .byte $18
ad4a              .byte $5f
ad4b              .byte $a2
                  .byte $0d
ad4d              .byte $00
ad4e              .byte $00
ad4f              .byte $00
ad50              .byte $02
ad51              .byte $05
                  .byte $01
ad53              .byte $18
ad54              .byte $48
ad55              .byte $00
ad56              .byte $ff
ad57              .byte $54
ad58              .byte $5f
ad59              .byte $a2
                  .byte $0d
ad5b              .byte $00
ad5c              .byte $00
ad5d              .byte $00
ad5e              .byte $02
ad5f              .byte $06
                  .byte $01
ad61              .byte $54
ad62              .byte $74
ad63              .byte $00
ad64              .byte $00
ad65              .byte $00
ad66              .byte $18
ad67              .byte $21
                  .byte $00
ad69              .byte $64
ad6a              .byte $1e
                  .byte $2a
                  .byte $3e
ad6d              .byte $63
ad6e              .byte $8c
                  .byte $40
                  .byte $10
ad71              .byte $01
                  .byte $92
ad73              .byte $9c
ad74              .byte $64
ad75              .byte $7f
ad76              .byte $40
ad77              .byte $4a
ad78              .byte $09
                  .byte $01
ad7a              .byte $46
                  .byte $50
ad7c              .byte $6c
                  .byte $85
                  .byte $90
ad7f              .byte $64
ad80              .byte $28
ad81              .byte $22
ad82              .byte $96
                  .byte $a3
ad84              .byte $81
                  .byte $a6
ad86              .byte $08
ad87              .byte $79
                  .byte $20
                  .byte $01
ad8a              .byte $0e
                  .byte $16
                  .byte $99
ad8d              .byte $b7
ad8e              .byte $86
                  .byte $92
ad90              .byte $18
ad91              .byte $22
ad92              .byte $8b
ad93              .byte $96
                  .byte $b7
ad95              .byte $d0
                  .byte $00
ad97              .byte $00
ad98              .byte $00
ad99              .byte $0d
                  .byte $2a
                  .byte $0d
ad9c              .byte $38
ad9d              .byte $0d
                  .byte $46
                  .byte $0d
ada0              .byte $46
                  .byte $0d
ada2              .byte $7e
                  .byte $0d
                  .byte $8c
ada5              .byte $0d
                  .byte $9a
                  .byte $0d
ada8              .byte $00
ada9              .byte $0d
                  .byte $0e
                  .byte $0d
adac              .byte $1c
adad              .byte $0d
                  .byte $46
                  .byte $0d
adb0              .byte $46
                  .byte $0d
adb2              .byte $7e
                  .byte $0d
                  .byte $8c
adb5              .byte $0d
                  .byte $9a
                  .byte $0d
adb8              .byte $80
adb9              .byte $ac
                  .byte $66
                  .byte $ad
adbc              .byte $08
adbd              .byte $ad
                  .byte $97
                  .byte $ad
adc0              .byte $1e
                  .byte $ad
                  .byte $00
adc3              .byte $00
adc4              .byte $00
adc5              .byte $00
adc6              .byte $00
adc7              .byte $00
adc8              .byte $00
adc9              .byte $00
adca              .byte $00
adcb              .byte $00
adcc              .byte $af
adcd              .byte $30
                  .byte $74
adcf              .byte $28
add0              .byte $00
add1              .byte $25
                  .byte $04
add3              .byte $80
add4              .byte $07
add5              .byte $00
add6              .byte $3d
                  .byte $04
                  .byte $80
add9              .byte $07
adda              .byte $28
addb              .byte $3d
                  .byte $04
                  .byte $80
adde              .byte $14
addf              .byte $50
                  .byte $3d
ade1              .byte $04
ade2              .byte $80
ade3              .byte $08
ade4              .byte $00
ade5              .byte $6f
ade6              .byte $04
ade7              .byte $80
ade8              .byte $0a
ade9              .byte $2c
                  .byte $72
                  .byte $04
adec              .byte $80
aded              .byte $10
                  .byte $60
adef              .byte $71
                  .byte $04
adf1              .byte $80
adf2              .byte $09
                  .byte $0e
adf4              .byte $a6
                  .byte $04
adf6              .byte $80
adf7              .byte $02
adf8              .byte $7c
adf9              .byte $59
                  .byte $04
                  .byte $80
adfc              .byte $19
                  .byte $3c
                  .byte $a4
adff              .byte $04
ae00              .byte $80
ae01              .byte $03
ae02              .byte $0a
ae03              .byte $25
                  .byte $80
ae05              .byte $16
                  .byte $03
ae07              .byte $0e
                  .byte $25
                  .byte $80
ae0a              .byte $1e
                  .byte $03
                  .byte $32
ae0d              .byte $25
                  .byte $80
ae0f              .byte $16
                  .byte $03
ae11              .byte $36
                  .byte $25
ae13              .byte $80
ae14              .byte $1e
                  .byte $03
                  .byte $59
ae17              .byte $25
                  .byte $80
ae19              .byte $16
                  .byte $03
ae1b              .byte $5d
                  .byte $25
                  .byte $80
ae1e              .byte $1e
                  .byte $03
                  .byte $88
ae21              .byte $25
                  .byte $80
ae23              .byte $16
                  .byte $03
ae25              .byte $8c
                  .byte $25
                  .byte $80
ae28              .byte $1e
                  .byte $06
                  .byte $02
ae2b              .byte $3f
ae2c              .byte $80
ae2d              .byte $14
ae2e              .byte $06
                  .byte $06
ae30              .byte $3f
ae31              .byte $80
ae32              .byte $1c
ae33              .byte $07
ae34              .byte $0e
                  .byte $6e
                  .byte $80
ae37              .byte $16
                  .byte $07
ae39              .byte $12
ae3a              .byte $6e
                  .byte $80
                  .byte $1e
ae3d              .byte $06
                  .byte $7a
ae3f              .byte $74
ae40              .byte $80
ae41              .byte $13
ae42              .byte $06
                  .byte $7e
ae44              .byte $74
ae45              .byte $80
ae46              .byte $1b
ae47              .byte $04
ae48              .byte $46
                  .byte $a7
ae4a              .byte $80
ae4b              .byte $13
ae4c              .byte $04
ae4d              .byte $4a
ae4e              .byte $a7
ae4f              .byte $80
ae50              .byte $1b
ae51              .byte $33
ae52              .byte $30
                  .byte $72
ae54              .byte $11
                  .byte $20
ae56              .byte $33
ae57              .byte $34
ae58              .byte $72
ae59              .byte $11
                  .byte $20
ae5b              .byte $35
                  .byte $44
ae5d              .byte $72
ae5e              .byte $f1
                  .byte $20
ae60              .byte $35
                  .byte $48
ae62              .byte $72
ae63              .byte $f1
                  .byte $20
ae65              .byte $1a
ae66              .byte $98
ae67              .byte $25
                  .byte $10
ae69              .byte $20
                  .byte $1a
                  .byte $9c
ae6c              .byte $25
                  .byte $10
ae6e              .byte $20
                  .byte $1c
                  .byte $98
ae71              .byte $3d
                  .byte $1f
                  .byte $20
ae74              .byte $1c
ae75              .byte $9c
ae76              .byte $3d
                  .byte $1f
                  .byte $20
ae79              .byte $18
ae7a              .byte $7d
                  .byte $59
                  .byte $11
ae7d              .byte $20
                  .byte $18
                  .byte $81
ae80              .byte $59
                  .byte $11
                  .byte $20
ae83              .byte $33
ae84              .byte $94
                  .byte $71
ae86              .byte $10
                  .byte $20
ae88              .byte $33
ae89              .byte $98
ae8a              .byte $71
                  .byte $10
ae8c              .byte $20
                  .byte $24
                  .byte $94
ae8f              .byte $a4
                  .byte $1f
ae91              .byte $20
                  .byte $24
                  .byte $98
ae94              .byte $a4
                  .byte $1f
ae96              .byte $20
                  .byte $28
                  .byte $00
ae99              .byte $c7
ae9a              .byte $04
ae9b              .byte $28
ae9c              .byte $00
ae9d              .byte $16
                  .byte $42
ae9f              .byte $5a
aea0              .byte $3e
                  .byte $42
                  .byte $5a
aea3              .byte $65
                  .byte $42
aea5              .byte $5a
aea6              .byte $94
                  .byte $42
aea8              .byte $5a
aea9              .byte $0e
                  .byte $5a
                  .byte $8c
aeac              .byte $1a
aead              .byte $8c
                  .byte $c3
                  .byte $86
aeb0              .byte $8e
                  .byte $c1
                  .byte $52
aeb3              .byte $c1
                  .byte $e4
aeb5              .byte $00
aeb6              .byte $32
aeb7              .byte $3c
aeb8              .byte $8f
aeb9              .byte $01
                  .byte $35
aebb              .byte $85
                  .byte $5a
aebd              .byte $ff
aebe              .byte $18
aebf              .byte $a5
                  .byte $42
aec1              .byte $00
aec2              .byte $1c
aec3              .byte $a4
                  .byte $5a
aec5              .byte $ff
aec6              .byte $18
aec7              .byte $88
aec8              .byte $76
                  .byte $01
aeca              .byte $33
aecb              .byte $a0
                  .byte $8e
aecd              .byte $00
aece              .byte $23
aecf              .byte $a0
                  .byte $c1
aed1              .byte $ff
aed2              .byte $00
aed3              .byte $ff
aed4              .byte $5a
aed5              .byte $e4
                  .byte $92
aed7              .byte $01
                  .byte $00
aed9              .byte $00
aeda              .byte $ff
aedb              .byte $02
aedc              .byte $01
                  .byte $ff
aede              .byte $00
aedf              .byte $00
aee0              .byte $00
aee1              .byte $ff
aee2              .byte $2c
                  .byte $4d
                  .byte $a2
aee5              .byte $04
aee6              .byte $00
aee7              .byte $00
aee8              .byte $00
aee9              .byte $02
aeea              .byte $04
aeeb              .byte $01
                  .byte $1c
aeed              .byte $4c
                  .byte $00
                  .byte $ff
aef0              .byte $72
aef1              .byte $4d
                  .byte $a0
                  .byte $0a
aef4              .byte $00
aef5              .byte $00
aef6              .byte $00
aef7              .byte $02
aef8              .byte $05
                  .byte $ff
aefa              .byte $64
aefb              .byte $88
aefc              .byte $00
aefd              .byte $ff
aefe              .byte $8a
aeff              .byte $81
                  .byte $a2
af01              .byte $0d
                  .byte $00
                  .byte $00
af04              .byte $00
af05              .byte $03
af06              .byte $05
                  .byte $01
af08              .byte $87
af09              .byte $8b
af0a              .byte $00
af0b              .byte $ff
af0c              .byte $28
af0d              .byte $ef
af0e              .byte $a2
                  .byte $04
af10              .byte $00
af11              .byte $00
af12              .byte $00
af13              .byte $04
af14              .byte $04
af15              .byte $01
                  .byte $24
af17              .byte $38
af18              .byte $00
af19              .byte $ff
af1a              .byte $80
af1b              .byte $ef
af1c              .byte $a0
                  .byte $05
af1e              .byte $00
af1f              .byte $00
af20              .byte $00
af21              .byte $05
                  .byte $04
af23              .byte $ff
af24              .byte $57
af25              .byte $a0
                  .byte $00
af27              .byte $00
af28              .byte $00
af29              .byte $34
af2a              .byte $b4
                  .byte $30
af2c              .byte $64
af2d              .byte $3a
af2e              .byte $44
af2f              .byte $d3
af30              .byte $f5
                  .byte $6c
af32              .byte $59
                  .byte $20
                  .byte $01
af35              .byte $71
                  .byte $78
af37              .byte $79
                  .byte $97
                  .byte $1c
af3a              .byte $5c
af3b              .byte $38
af3c              .byte $43
af3d              .byte $22
af3e              .byte $2e
                  .byte $7e
                  .byte $99
af41              .byte $3c
af42              .byte $2c
                  .byte $40
                  .byte $22
af45              .byte $42
af46              .byte $4e
                  .byte $4a
                  .byte $6d
af49              .byte $44
af4a              .byte $14
af4b              .byte $48
af4c              .byte $01
                  .byte $4a
af4e              .byte $56
                  .byte $37
af50              .byte $53
af51              .byte $78
af52              .byte $2c
                  .byte $50
                  .byte $22
af55              .byte $7e
                  .byte $8a
                  .byte $4c
af58              .byte $6b
af59              .byte $94
                  .byte $14
af5b              .byte $58
af5c              .byte $22
af5d              .byte $9a
af5e              .byte $a4
                  .byte $33
af60              .byte $54
af61              .byte $00
af62              .byte $00
af63              .byte $0d
                  .byte $0e
                  .byte $0d
af66              .byte $1c
af67              .byte $0d
                  .byte $2a
                  .byte $0d
af6a              .byte $62
af6b              .byte $0d
                  .byte $7e
                  .byte $0d
af6e              .byte $8c
                  .byte $0d
                  .byte $9a
af71              .byte $0d
                  .byte $00
                  .byte $0d
af74              .byte $38
af75              .byte $0d
                  .byte $46
                  .byte $0d
af78              .byte $62
af79              .byte $0d
                  .byte $62
                  .byte $0d
af7c              .byte $7e
                  .byte $0d
                  .byte $8c
af7f              .byte $0d
                  .byte $9a
                  .byte $0d
af82              .byte $cf
af83              .byte $ad
                  .byte $29
                  .byte $af
af86              .byte $9d
                  .byte $ae
                  .byte $b6
af89              .byte $ae
                  .byte $d3
                  .byte $ae
af8c              .byte $00
af8d              .byte $00
af8e              .byte $00
af8f              .byte $00
af90              .byte $00
af91              .byte $00
af92              .byte $00
af93              .byte $00
af94              .byte $00
af95              .byte $00
af96              .byte $90
                  .byte $35
af98              .byte $90
                  .byte $00
af9a              .byte $0d
                  .byte $0e
                  .byte $0d
af9d              .byte $1c
af9e              .byte $0d
                  .byte $2a
                  .byte $0d
afa1              .byte $38
afa2              .byte $0d
                  .byte $7e
                  .byte $0d
afa5              .byte $8c
                  .byte $0d
                  .byte $9a
afa8              .byte $0d
                  .byte $00
                  .byte $0d
afab              .byte $46
                  .byte $0d
afad              .byte $54
afae              .byte $0d
                  .byte $62
                  .byte $0d
afb1              .byte $70
                  .byte $0d
afb3              .byte $7e
                  .byte $0d
                  .byte $8c
afb6              .byte $0d
                  .byte $9a
                  .byte $0d
afb9              .byte $d0
                  .byte $af
afbb              .byte $cb
afbc              .byte $b0
                  .byte $ff
afbe              .byte $b0
                  .byte $fe
afc0              .byte $b0
                  .byte $15
afc2              .byte $b1
                  .byte $00
afc4              .byte $00
afc5              .byte $00
afc6              .byte $00
afc7              .byte $11
                  .byte $46
afc9              .byte $50
                  .byte $55
afcb              .byte $00
afcc              .byte $00
afcd              .byte $7d
                  .byte $40
                  .byte $91
afd0              .byte $25
                  .byte $06
afd2              .byte $3d
                  .byte $04
                  .byte $80
afd5              .byte $0a
afd6              .byte $02
afd7              .byte $59
                  .byte $04
                  .byte $80
afda              .byte $0a
afdb              .byte $78
afdc              .byte $55
                  .byte $04
afde              .byte $80
afdf              .byte $0c
afe0              .byte $36
                  .byte $6b
afe2              .byte $04
afe3              .byte $80
afe4              .byte $0b
afe5              .byte $0c
afe6              .byte $8a
afe7              .byte $04
afe8              .byte $80
afe9              .byte $0d
                  .byte $62
                  .byte $84
afec              .byte $04
afed              .byte $80
afee              .byte $06
                  .byte $3e
aff0              .byte $99
                  .byte $04
                  .byte $80
aff3              .byte $07
aff4              .byte $02
aff5              .byte $a4
                  .byte $04
aff7              .byte $80
aff8              .byte $06
                  .byte $22
affa              .byte $a9
                  .byte $04
affc              .byte $80
affd              .byte $07
affe              .byte $56
                  .byte $aa
b000              .byte $04
b001              .byte $80
b002              .byte $06
                  .byte $7e
b004              .byte $a4
                  .byte $04
b006              .byte $80
b007              .byte $28
b008              .byte $00
b009              .byte $c7
b00a              .byte $04
b00b              .byte $28
b00c              .byte $03
b00d              .byte $14
b00e              .byte $41
                  .byte $80
b010              .byte $11
                  .byte $03
b012              .byte $18
b013              .byte $41
                  .byte $80
b015              .byte $19
                  .byte $06
                  .byte $10
b018              .byte $5a
b019              .byte $80
b01a              .byte $14
b01b              .byte $06
                  .byte $14
b01d              .byte $5a
b01e              .byte $80
b01f              .byte $1c
b020              .byte $06
                  .byte $78
b022              .byte $55
                  .byte $80
b024              .byte $15
                  .byte $06
b026              .byte $7c
b027              .byte $55
                  .byte $80
b029              .byte $1d
                  .byte $04
                  .byte $2e
b02c              .byte $89
b02d              .byte $80
b02e              .byte $16
                  .byte $04
b030              .byte $32
b031              .byte $89
b032              .byte $80
b033              .byte $1e
                  .byte $04
                  .byte $84
b036              .byte $84
                  .byte $80
b038              .byte $16
                  .byte $04
b03a              .byte $88
b03b              .byte $84
                  .byte $80
b03d              .byte $1e
                  .byte $04
                  .byte $04
b040              .byte $a7
b041              .byte $80
b042              .byte $13
b043              .byte $04
b044              .byte $08
b045              .byte $a7
b046              .byte $80
b047              .byte $1b
b048              .byte $03
b049              .byte $68
b04a              .byte $af
b04b              .byte $80
b04c              .byte $11
                  .byte $03
b04e              .byte $6c
                  .byte $af
                  .byte $80
b051              .byte $19
                  .byte $03
                  .byte $42
b054              .byte $25
                  .byte $80
b056              .byte $38
b057              .byte $03
b058              .byte $42
b059              .byte $53
b05a              .byte $80
b05b              .byte $38
b05c              .byte $03
b05d              .byte $42
b05e              .byte $81
                  .byte $80
b060              .byte $38
b061              .byte $03
b062              .byte $42
b063              .byte $af
b064              .byte $80
b065              .byte $38
b066              .byte $03
b067              .byte $50
                  .byte $25
b069              .byte $80
b06a              .byte $38
b06b              .byte $03
b06c              .byte $50
                  .byte $53
b06e              .byte $80
b06f              .byte $38
b070              .byte $03
b071              .byte $50
                  .byte $81
b073              .byte $80
b074              .byte $38
b075              .byte $03
b076              .byte $50
                  .byte $af
b078              .byte $80
b079              .byte $38
b07a              .byte $04
b07b              .byte $42
b07c              .byte $23
b07d              .byte $04
b07e              .byte $40
b07f              .byte $04
b080              .byte $42
b081              .byte $51
                  .byte $04
b083              .byte $40
b084              .byte $04
b085              .byte $42
b086              .byte $7f
b087              .byte $04
b088              .byte $40
b089              .byte $04
b08a              .byte $42
b08b              .byte $ad
                  .byte $04
                  .byte $40
b08e              .byte $02
b08f              .byte $44
b090              .byte $13
b091              .byte $80
b092              .byte $3d
                  .byte $02
                  .byte $44
b095              .byte $41
                  .byte $80
b097              .byte $3d
                  .byte $02
                  .byte $44
b09a              .byte $6f
b09b              .byte $80
b09c              .byte $3d
                  .byte $02
                  .byte $44
b09f              .byte $9d
                  .byte $80
                  .byte $3d
b0a2              .byte $02
b0a3              .byte $4e
                  .byte $13
                  .byte $80
b0a6              .byte $3d
                  .byte $02
                  .byte $4e
b0a9              .byte $41
                  .byte $80
b0ab              .byte $3d
                  .byte $02
                  .byte $4e
b0ae              .byte $6f
b0af              .byte $80
b0b0              .byte $3d
                  .byte $02
                  .byte $4e
b0b3              .byte $9d
                  .byte $80
                  .byte $3d
b0b6              .byte $03
b0b7              .byte $44
b0b8              .byte $18
b0b9              .byte $04
b0ba              .byte $40
b0bb              .byte $03
b0bc              .byte $44
b0bd              .byte $46
                  .byte $04
b0bf              .byte $40
b0c0              .byte $03
b0c1              .byte $44
b0c2              .byte $74
b0c3              .byte $04
b0c4              .byte $40
b0c5              .byte $03
b0c6              .byte $44
b0c7              .byte $a2
                  .byte $04
b0c9              .byte $40
b0ca              .byte $00
b0cb              .byte $1c
b0cc              .byte $2b
b0cd              .byte $60
b0ce              .byte $43
b0cf              .byte $21
                  .byte $2f
b0d1              .byte $4a
b0d2              .byte $6b
b0d3              .byte $02
b0d4              .byte $43
b0d5              .byte $58
b0d6              .byte $22
b0d7              .byte $06
                  .byte $12
b0d9              .byte $63
b0da              .byte $83
b0db              .byte $90
                  .byte $44
b0dd              .byte $68
b0de              .byte $01
                  .byte $95
b0e0              .byte $a3
b0e1              .byte $63
b0e2              .byte $83
b0e3              .byte $5c
b0e4              .byte $45
                  .byte $70
b0e6              .byte $43
b0e7              .byte $61
                  .byte $6f
b0e9              .byte $62
b0ea              .byte $86
                  .byte $82
b0ec              .byte $73
b0ed              .byte $78
b0ee              .byte $01
                  .byte $87
b0f0              .byte $95
                  .byte $92
b0f2              .byte $ad
                  .byte $5c
                  .byte $b0
b0f5              .byte $80
b0f6              .byte $01
                  .byte $61
b0f8              .byte $6f
b0f9              .byte $d1
                  .byte $ee
b0fb              .byte $00
b0fc              .byte $00
b0fd              .byte $00
b0fe              .byte $00
b0ff              .byte $20
                  .byte $5a
                  .byte $76
b102              .byte $1c
b103              .byte $76
                  .byte $a7
b105              .byte $84
                  .byte $72
b107              .byte $a1
                  .byte $3a
b109              .byte $a7
b10a              .byte $c6
                  .byte $90
b10c              .byte $a1
                  .byte $c1
b10e              .byte $10
                  .byte $c1
b110              .byte $e4
                  .byte $74
b112              .byte $c7
b113              .byte $e4
                  .byte $00
b115              .byte $ff
b116              .byte $8c
                  .byte $e4
                  .byte $92
b119              .byte $01
                  .byte $00
b11b              .byte $00
b11c              .byte $01
                  .byte $02
b11e              .byte $01
                  .byte $01
b120              .byte $00
b121              .byte $00
b122              .byte $00
b123              .byte $ff
b124              .byte $32
b125              .byte $65
                  .byte $a2
b127              .byte $04
b128              .byte $00
b129              .byte $00
b12a              .byte $00
b12b              .byte $0a
b12c              .byte $05
                  .byte $01
b12e              .byte $2c
                  .byte $46
                  .byte $00
b131              .byte $ff
b132              .byte $64
b133              .byte $65
                  .byte $a0
b135              .byte $0c
b136              .byte $00
b137              .byte $00
b138              .byte $00
b139              .byte $02
b13a              .byte $06
                  .byte $ff
b13c              .byte $5c
b13d              .byte $78
b13e              .byte $00
b13f              .byte $ff
b140              .byte $19
                  .byte $81
                  .byte $a2
b143              .byte $05
                  .byte $00
b145              .byte $00
b146              .byte $00
b147              .byte $14
b148              .byte $05
                  .byte $01
b14a              .byte $0e
                  .byte $2a
                  .byte $00
b14d              .byte $ff
b14e              .byte $8c
                  .byte $7d
                  .byte $a0
b151              .byte $0f
b152              .byte $00
b153              .byte $00
b154              .byte $00
b155              .byte $03
b156              .byte $04
b157              .byte $ff
b158              .byte $84
                  .byte $a2
b15a              .byte $00
b15b              .byte $ff
b15c              .byte $37
b15d              .byte $b2
b15e              .byte $a2
                  .byte $04
b160              .byte $00
b161              .byte $00
b162              .byte $00
b163              .byte $08
b164              .byte $05
                  .byte $01
b166              .byte $2c
                  .byte $3a
                  .byte $00
b169              .byte $ff
b16a              .byte $7d
                  .byte $ac
                  .byte $a0
b16d              .byte $05
                  .byte $00
b16f              .byte $00
b170              .byte $00
b171              .byte $03
b172              .byte $06
                  .byte $ff
b174              .byte $6e
                  .byte $91
                  .byte $00
b177              .byte $ff
b178              .byte $28
b179              .byte $ef
b17a              .byte $a2
                  .byte $0f
b17c              .byte $00
b17d              .byte $00
b17e              .byte $00
b17f              .byte $0a
b180              .byte $03
b181              .byte $01
                  .byte $14
b183              .byte $98
b184              .byte $00
b185              .byte $00
b186              .byte $00
b187              .byte $0d
                  .byte $0e
                  .byte $0d
b18a              .byte $1c
b18b              .byte $0d
                  .byte $2a
                  .byte $0d
b18e              .byte $38
b18f              .byte $0d
                  .byte $7e
                  .byte $0d
b192              .byte $8c
                  .byte $0d
                  .byte $9a
b195              .byte $0d
                  .byte $00
                  .byte $0d
b198              .byte $46
                  .byte $0d
b19a              .byte $54
b19b              .byte $0d
                  .byte $62
                  .byte $0d
b19e              .byte $70
                  .byte $0d
b1a0              .byte $7e
                  .byte $0d
                  .byte $8c
b1a3              .byte $0d
                  .byte $9a
                  .byte $0d
b1a6              .byte $bd
                  .byte $b1
                  .byte $6d
b1a9              .byte $b2
b1aa              .byte $ae
                  .byte $b2
                  .byte $b8
b1ad              .byte $b2
b1ae              .byte $b9
                  .byte $b2
                  .byte $00
b1b1              .byte $00
b1b2              .byte $00
b1b3              .byte $00
b1b4              .byte $00
b1b5              .byte $00
b1b6              .byte $00
b1b7              .byte $00
b1b8              .byte $00
b1b9              .byte $00
b1ba              .byte $99
                  .byte $45
                  .byte $a0
b1bd              .byte $22
b1be              .byte $0e
                  .byte $28
                  .byte $04
b1c1              .byte $80
b1c2              .byte $02
b1c3              .byte $4e
                  .byte $3e
                  .byte $04
b1c6              .byte $80
b1c7              .byte $0a
b1c8              .byte $02
b1c9              .byte $46
                  .byte $04
b1cb              .byte $80
b1cc              .byte $04
b1cd              .byte $32
b1ce              .byte $46
                  .byte $04
b1d0              .byte $80
b1d1              .byte $04
b1d2              .byte $6a
b1d3              .byte $4a
b1d4              .byte $04
b1d5              .byte $80
b1d6              .byte $06
                  .byte $7e
b1d8              .byte $47
b1d9              .byte $04
b1da              .byte $80
b1db              .byte $07
b1dc              .byte $02
b1dd              .byte $58
b1de              .byte $04
b1df              .byte $80
b1e0              .byte $05
                  .byte $56
b1e2              .byte $59
                  .byte $04
                  .byte $80
b1e5              .byte $04
b1e6              .byte $70
                  .byte $5d
b1e8              .byte $04
b1e9              .byte $80
b1ea              .byte $05
                  .byte $3c
b1ec              .byte $63
b1ed              .byte $04
b1ee              .byte $80
b1ef              .byte $04
b1f0              .byte $86
                  .byte $61
b1f2              .byte $04
b1f3              .byte $80
b1f4              .byte $03
b1f5              .byte $12
b1f6              .byte $73
b1f7              .byte $04
b1f8              .byte $80
b1f9              .byte $04
b1fa              .byte $34
b1fb              .byte $70
                  .byte $04
b1fd              .byte $80
b1fe              .byte $04
b1ff              .byte $7a
b200              .byte $6f
b201              .byte $04
b202              .byte $80
b203              .byte $04
b204              .byte $28
b205              .byte $7e
                  .byte $04
                  .byte $80
b208              .byte $04
b209              .byte $64
b20a              .byte $7a
b20b              .byte $04
b20c              .byte $80
b20d              .byte $02
b20e              .byte $0e
                  .byte $8f
                  .byte $04
b211              .byte $80
b212              .byte $05
                  .byte $34
b214              .byte $8a
b215              .byte $04
b216              .byte $80
b217              .byte $04
b218              .byte $52
b219              .byte $8f
b21a              .byte $04
b21b              .byte $80
b21c              .byte $03
b21d              .byte $7a
b21e              .byte $83
b21f              .byte $04
b220              .byte $80
b221              .byte $03
b222              .byte $6c
                  .byte $92
                  .byte $04
b225              .byte $80
b226              .byte $05
                  .byte $30
b228              .byte $9b
b229              .byte $04
b22a              .byte $80
b22b              .byte $04
b22c              .byte $7e
                  .byte $98
                  .byte $04
b22f              .byte $80
b230              .byte $05
                  .byte $16
b232              .byte $a8
b233              .byte $04
b234              .byte $80
b235              .byte $05
                  .byte $82
b237              .byte $a4
                  .byte $04
b239              .byte $80
b23a              .byte $06
                  .byte $32
b23c              .byte $b5
                  .byte $04
b23e              .byte $80
b23f              .byte $03
b240              .byte $54
b241              .byte $b9
                  .byte $04
                  .byte $80
b244              .byte $04
b245              .byte $6a
b246              .byte $b0
                  .byte $04
b248              .byte $80
b249              .byte $28
b24a              .byte $00
b24b              .byte $c7
b24c              .byte $04
b24d              .byte $28
b24e              .byte $04
b24f              .byte $14
b250              .byte $26
                  .byte $80
b252              .byte $17
b253              .byte $04
b254              .byte $18
b255              .byte $26
                  .byte $80
b257              .byte $1f
b258              .byte $04
b259              .byte $84
                  .byte $27
b25b              .byte $80
b25c              .byte $16
                  .byte $04
b25e              .byte $88
b25f              .byte $27
b260              .byte $80
b261              .byte $1e
                  .byte $0e
                  .byte $02
b264              .byte $57
b265              .byte $80
b266              .byte $16
                  .byte $0e
b268              .byte $06
                  .byte $57
b26a              .byte $80
b26b              .byte $1e
                  .byte $00
                  .byte $32
b26e              .byte $14
b26f              .byte $50
                  .byte $22
b271              .byte $38
b272              .byte $44
b273              .byte $34
b274              .byte $53
b275              .byte $50
                  .byte $2e
b277              .byte $38
b278              .byte $43
b279              .byte $56
                  .byte $62
b27b              .byte $50
                  .byte $6b
b27d              .byte $55
                  .byte $46
b27f              .byte $88
b280              .byte $22
b281              .byte $5a
b282              .byte $67
b283              .byte $67
b284              .byte $86
                  .byte $8e
b286              .byte $4f
b287              .byte $90
                  .byte $43
b289              .byte $96
                  .byte $9e
b28b              .byte $6f
b28c              .byte $8f
b28d              .byte $12
b28e              .byte $5e
                  .byte $10
                  .byte $01
b291              .byte $16
                  .byte $24
b293              .byte $82
b294              .byte $9c
b295              .byte $53
b296              .byte $68
b297              .byte $98
b298              .byte $43
b299              .byte $58
b29a              .byte $65
                  .byte $88
b29c              .byte $a7
b29d              .byte $8f
b29e              .byte $91
                  .byte $a0
b2a0              .byte $85
                  .byte $94
b2a2              .byte $a3
b2a3              .byte $b3
b2a4              .byte $d5
                  .byte $1e
b2a6              .byte $b0
                  .byte $a8
b2a8              .byte $85
                  .byte $24
b2aa              .byte $30
                  .byte $d0
b2ac              .byte $f0
                  .byte $00
b2ae              .byte $20
                  .byte $45
                  .byte $63
b2b1              .byte $90
                  .byte $45
b2b3              .byte $64
b2b4              .byte $0e
                  .byte $75
                  .byte $e5
b2b7              .byte $00
b2b8              .byte $00
b2b9              .byte $ff
b2ba              .byte $18
b2bb              .byte $e4
                  .byte $97
b2bd              .byte $01
                  .byte $00
b2bf              .byte $00
b2c0              .byte $ff
b2c1              .byte $02
b2c2              .byte $01
                  .byte $01
b2c4              .byte $00
b2c5              .byte $00
b2c6              .byte $00
b2c7              .byte $ff
b2c8              .byte $1a
b2c9              .byte $50
                  .byte $a2
b2cb              .byte $04
b2cc              .byte $00
b2cd              .byte $00
b2ce              .byte $00
b2cf              .byte $0a
b2d0              .byte $04
b2d1              .byte $01
                  .byte $19
b2d3              .byte $52
b2d4              .byte $00
b2d5              .byte $ff
b2d6              .byte $78
b2d7              .byte $50
                  .byte $a0
b2d9              .byte $0c
b2da              .byte $00
b2db              .byte $00
b2dc              .byte $00
b2dd              .byte $14
b2de              .byte $04
b2df              .byte $ff
b2e0              .byte $52
b2e1              .byte $90
                  .byte $00
b2e3              .byte $ff
b2e4              .byte $48
b2e5              .byte $8b
b2e6              .byte $a2
                  .byte $05
b2e8              .byte $00
b2e9              .byte $00
b2ea              .byte $00
b2eb              .byte $01
                  .byte $06
b2ed              .byte $01
                  .byte $48
b2ef              .byte $55
                  .byte $00
b2f1              .byte $ff
b2f2              .byte $80
b2f3              .byte $85
                  .byte $a2
b2f5              .byte $0f
b2f6              .byte $00
b2f7              .byte $00
b2f8              .byte $00
b2f9              .byte $03
b2fa              .byte $06
                  .byte $01
b2fc              .byte $7c
b2fd              .byte $86
                  .byte $00
b2ff              .byte $ff
b300              .byte $8c
                  .byte $c0
                  .byte $a2
b303              .byte $04
b304              .byte $00
b305              .byte $00
b306              .byte $00
b307              .byte $0f
b308              .byte $05
                  .byte $01
b30a              .byte $8a
b30b              .byte $94
                  .byte $00
b30d              .byte $ff
b30e              .byte $41
                  .byte $dd
b310              .byte $a2
                  .byte $0c
b312              .byte $00
b313              .byte $00
b314              .byte $00
b315              .byte $08
b316              .byte $06
                  .byte $01
b318              .byte $3e
                  .byte $50
                  .byte $00
b31b              .byte $ff
b31c              .byte $a2
                  .byte $ef
b31e              .byte $a0
                  .byte $0f
b320              .byte $00
b321              .byte $00
b322              .byte $00
b323              .byte $0d
                  .byte $03
                  .byte $ff
b326              .byte $12
b327              .byte $a2
                  .byte $00
b329              .byte $00
b32a              .byte $00
b32b              .byte $00
b32c              .byte $0d
                  .byte $0e
                  .byte $0d
b32f              .byte $1c
b330              .byte $0d
                  .byte $2a
                  .byte $0d
b333              .byte $70
                  .byte $0d
b335              .byte $7e
                  .byte $0d
                  .byte $8c
b338              .byte $0d
                  .byte $9a
                  .byte $0d
b33b              .byte $00
b33c              .byte $0d
                  .byte $38
                  .byte $0d
b33f              .byte $46
                  .byte $0d
b341              .byte $70
                  .byte $0d
b343              .byte $70
                  .byte $0d
b345              .byte $7e
                  .byte $0d
                  .byte $8c
b348              .byte $0d
                  .byte $9a
                  .byte $0d
b34b              .byte $62
b34c              .byte $b3
b34d              .byte $ab
b34e              .byte $b4
                  .byte $aa
b350              .byte $b4
                  .byte $85
b352              .byte $b4
                  .byte $e4
b354              .byte $b4
                  .byte $3b
b356              .byte $b5
                  .byte $00
b358              .byte $00
b359              .byte $00
b35a              .byte $00
b35b              .byte $00
b35c              .byte $00
b35d              .byte $00
b35e              .byte $00
b35f              .byte $84
                  .byte $50
b361              .byte $9e
b362              .byte $36
                  .byte $48
b364              .byte $2c
                  .byte $10
                  .byte $20
b367              .byte $36
                  .byte $4c
b369              .byte $2c
                  .byte $10
                  .byte $20
b36c              .byte $36
                  .byte $12
b36e              .byte $2c
                  .byte $11
                  .byte $20
b371              .byte $36
                  .byte $16
b373              .byte $2c
                  .byte $11
                  .byte $20
b376              .byte $24
                  .byte $24
b378              .byte $2c
                  .byte $11
                  .byte $20
b37b              .byte $24
                  .byte $28
b37d              .byte $2c
                  .byte $11
                  .byte $20
b380              .byte $12
b381              .byte $36
                  .byte $2c
b383              .byte $11
                  .byte $20
b385              .byte $12
b386              .byte $3a
b387              .byte $2c
                  .byte $11
                  .byte $20
b38a              .byte $12
b38b              .byte $5a
b38c              .byte $2c
                  .byte $1f
                  .byte $20
b38f              .byte $12
b390              .byte $5e
                  .byte $2c
                  .byte $1f
b393              .byte $20
                  .byte $24
                  .byte $6c
b396              .byte $2c
                  .byte $1f
                  .byte $20
b399              .byte $24
                  .byte $70
b39b              .byte $2c
                  .byte $1f
                  .byte $20
b39e              .byte $36
                  .byte $7e
b3a0              .byte $2c
                  .byte $1f
                  .byte $20
b3a3              .byte $36
                  .byte $82
b3a5              .byte $2c
                  .byte $1f
                  .byte $20
b3a8              .byte $25
                  .byte $02
b3aa              .byte $2c
                  .byte $04
                  .byte $80
b3ad              .byte $02
b3ae              .byte $48
b3af              .byte $3e
                  .byte $04
                  .byte $80
b3b2              .byte $02
b3b3              .byte $48
b3b4              .byte $50
                  .byte $04
b3b6              .byte $80
b3b7              .byte $04
b3b8              .byte $44
b3b9              .byte $62
b3ba              .byte $04
b3bb              .byte $80
b3bc              .byte $02
b3bd              .byte $02
b3be              .byte $36
                  .byte $04
b3c0              .byte $80
b3c1              .byte $02
b3c2              .byte $02
b3c3              .byte $41
                  .byte $04
b3c5              .byte $80
b3c6              .byte $02
b3c7              .byte $02
b3c8              .byte $4c
                  .byte $04
                  .byte $80
b3cb              .byte $02
b3cc              .byte $02
b3cd              .byte $57
b3ce              .byte $04
b3cf              .byte $80
b3d0              .byte $04
b3d1              .byte $02
b3d2              .byte $63
b3d3              .byte $04
b3d4              .byte $80
b3d5              .byte $02
b3d6              .byte $1e
                  .byte $5e
                  .byte $04
b3d9              .byte $80
b3da              .byte $03
b3db              .byte $22
b3dc              .byte $6b
b3dd              .byte $04
b3de              .byte $80
b3df              .byte $03
b3e0              .byte $12
b3e1              .byte $77
b3e2              .byte $04
b3e3              .byte $80
b3e4              .byte $02
b3e5              .byte $36
                  .byte $73
b3e7              .byte $04
b3e8              .byte $80
b3e9              .byte $03
b3ea              .byte $02
b3eb              .byte $83
b3ec              .byte $04
b3ed              .byte $80
b3ee              .byte $03
b3ef              .byte $2e
                  .byte $81
                  .byte $04
b3f2              .byte $80
b3f3              .byte $03
b3f4              .byte $48
b3f5              .byte $84
                  .byte $04
b3f7              .byte $80
b3f8              .byte $02
b3f9              .byte $02
b3fa              .byte $8f
b3fb              .byte $04
b3fc              .byte $80
b3fd              .byte $03
b3fe              .byte $20
                  .byte $90
                  .byte $04
b401              .byte $80
b402              .byte $02
b403              .byte $4a
b404              .byte $8f
b405              .byte $04
b406              .byte $80
b407              .byte $03
b408              .byte $0c
b409              .byte $9a
b40a              .byte $04
b40b              .byte $80
b40c              .byte $02
b40d              .byte $4a
b40e              .byte $9b
b40f              .byte $04
b410              .byte $80
b411              .byte $04
b412              .byte $24
                  .byte $a6
b414              .byte $04
b415              .byte $80
b416              .byte $02
b417              .byte $3a
b418              .byte $a8
b419              .byte $04
b41a              .byte $80
b41b              .byte $02
b41c              .byte $0c
b41d              .byte $af
b41e              .byte $04
b41f              .byte $80
b420              .byte $02
b421              .byte $24
                  .byte $b3
b423              .byte $04
b424              .byte $80
b425              .byte $03
b426              .byte $46
                  .byte $b3
b428              .byte $04
b429              .byte $80
b42a              .byte $03
b42b              .byte $36
                  .byte $bc
b42d              .byte $04
b42e              .byte $80
b42f              .byte $02
b430              .byte $96
                  .byte $36
b432              .byte $04
b433              .byte $80
b434              .byte $02
b435              .byte $8e
                  .byte $49
                  .byte $04
b438              .byte $80
b439              .byte $02
b43a              .byte $8c
                  .byte $56
                  .byte $04
b43d              .byte $80
b43e              .byte $03
b43f              .byte $8c
                  .byte $60
                  .byte $04
b442              .byte $80
b443              .byte $02
b444              .byte $8e
                  .byte $6e
                  .byte $04
b447              .byte $80
b448              .byte $02
b449              .byte $7e
                  .byte $78
                  .byte $04
b44c              .byte $80
b44d              .byte $02
b44e              .byte $8a
b44f              .byte $84
                  .byte $04
b451              .byte $80
b452              .byte $02
b453              .byte $92
b454              .byte $91
                  .byte $04
b456              .byte $80
b457              .byte $03
b458              .byte $86
                  .byte $9e
b45a              .byte $04
b45b              .byte $80
b45c              .byte $02
b45d              .byte $62
b45e              .byte $a2
                  .byte $04
b460              .byte $80
b461              .byte $02
b462              .byte $76
                  .byte $a8
b464              .byte $04
b465              .byte $80
b466              .byte $02
b467              .byte $8e
                  .byte $ac
                  .byte $04
b46a              .byte $80
b46b              .byte $02
b46c              .byte $82
b46d              .byte $b9
                  .byte $04
                  .byte $80
b470              .byte $02
b471              .byte $84
                  .byte $40
b473              .byte $04
b474              .byte $48
b475              .byte $03
b476              .byte $58
b477              .byte $6c
                  .byte $04
                  .byte $48
b47a              .byte $03
b47b              .byte $50
                  .byte $ba
b47d              .byte $04
b47e              .byte $48
b47f              .byte $28
b480              .byte $00
b481              .byte $c7
b482              .byte $04
b483              .byte $28
b484              .byte $00
b485              .byte $12
b486              .byte $54
b487              .byte $49
                  .byte $00
b489              .byte $12
b48a              .byte $54
b48b              .byte $5b
b48c              .byte $00
b48d              .byte $12
b48e              .byte $54
b48f              .byte $6d
                  .byte $00
                  .byte $36
b492              .byte $1e
                  .byte $49
                  .byte $01
b495              .byte $24
                  .byte $30
b497              .byte $49
                  .byte $01
b499              .byte $12
b49a              .byte $42
b49b              .byte $49
                  .byte $01
b49d              .byte $12
b49e              .byte $66
                  .byte $49
b4a0              .byte $ff
b4a1              .byte $24
                  .byte $78
b4a3              .byte $49
                  .byte $ff
b4a5              .byte $36
                  .byte $8a
b4a7              .byte $49
                  .byte $ff
b4a9              .byte $00
b4aa              .byte $00
b4ab              .byte $28
b4ac              .byte $1a
b4ad              .byte $40
b4ae              .byte $22
b4af              .byte $2d
                  .byte $3a
                  .byte $39
b4b2              .byte $5b
b4b3              .byte $48
b4b4              .byte $1a
b4b5              .byte $a8
b4b6              .byte $85
                  .byte $4d
b4b8              .byte $5b
b4b9              .byte $39
                  .byte $5b
                  .byte $60
b4bc              .byte $1a
b4bd              .byte $b8
b4be              .byte $43
b4bf              .byte $66
                  .byte $72
b4c1              .byte $39
                  .byte $5b
                  .byte $10
b4c4              .byte $48
b4c5              .byte $a0
                  .byte $85
b4c7              .byte $16
                  .byte $22
b4c9              .byte $6a
b4ca              .byte $89
b4cb              .byte $74
b4cc              .byte $44
b4cd              .byte $c0
                  .byte $85
b4cf              .byte $7a
b4d0              .byte $86
                  .byte $61
b4d2              .byte $86
                  .byte $2c
b4d4              .byte $88
b4d5              .byte $b0
                  .byte $22
b4d7              .byte $32
b4d8              .byte $3c
b4d9              .byte $a8
b4da              .byte $c7
b4db              .byte $02
b4dc              .byte $a0
                  .byte $88
b4de              .byte $22
b4df              .byte $08
b4e0              .byte $12
b4e1              .byte $c0
                  .byte $e0
b4e3              .byte $00
b4e4              .byte $ff
b4e5              .byte $0e
                  .byte $e4
                  .byte $97
b4e8              .byte $01
                  .byte $00
b4ea              .byte $00
b4eb              .byte $ff
b4ec              .byte $02
b4ed              .byte $01
                  .byte $01
b4ef              .byte $00
b4f0              .byte $00
b4f1              .byte $00
b4f2              .byte $ff
b4f3              .byte $18
b4f4              .byte $54
b4f5              .byte $a2
                  .byte $03
b4f7              .byte $00
b4f8              .byte $00
b4f9              .byte $00
b4fa              .byte $28
b4fb              .byte $04
b4fc              .byte $01
                  .byte $10
b4fe              .byte $4a
b4ff              .byte $00
b500              .byte $ff
b501              .byte $78
b502              .byte $54
b503              .byte $a0
                  .byte $04
b505              .byte $00
b506              .byte $00
b507              .byte $00
b508              .byte $14
b509              .byte $04
b50a              .byte $ff
b50b              .byte $5c
b50c              .byte $94
                  .byte $00
b50e              .byte $ff
b50f              .byte $10
                  .byte $8b
b511              .byte $a0
                  .byte $05
b513              .byte $00
b514              .byte $00
b515              .byte $00
b516              .byte $c8
b517              .byte $06
                  .byte $ff
b519              .byte $0e
                  .byte $14
                  .byte $00
b51c              .byte $ff
b51d              .byte $1e
                  .byte $ef
                  .byte $a2
b520              .byte $08
b521              .byte $00
b522              .byte $00
b523              .byte $00
b524              .byte $0a
b525              .byte $03
b526              .byte $01
                  .byte $18
b528              .byte $5c
b529              .byte $00
b52a              .byte $ff
b52b              .byte $82
b52c              .byte $ef
b52d              .byte $a2
                  .byte $04
b52f              .byte $00
b530              .byte $00
b531              .byte $00
b532              .byte $05
                  .byte $04
b534              .byte $01
                  .byte $3e
b536              .byte $9c
b537              .byte $00
b538              .byte $00
b539              .byte $00
b53a              .byte $00
b53b              .byte $40
b53c              .byte $03
b53d              .byte $03
b53e              .byte $06
                  .byte $01
b540              .byte $84
                  .byte $94
b542              .byte $84
                  .byte $02
b544              .byte $6c
                  .byte $03
                  .byte $01
b547              .byte $0c
b548              .byte $01
                  .byte $58
b54a              .byte $7c
b54b              .byte $58
b54c              .byte $03
b54d              .byte $ba
b54e              .byte $01
                  .byte $00
b550              .byte $0c
b551              .byte $01
                  .byte $50
b553              .byte $74
b554              .byte $50
                  .byte $03
b556              .byte $00
b557              .byte $00
b558              .byte $0d
                  .byte $0e
                  .byte $0d
b55b              .byte $1c
b55c              .byte $0d
                  .byte $70
                  .byte $0d
b55f              .byte $70
                  .byte $0d
b561              .byte $7e
                  .byte $0d
                  .byte $8c
b564              .byte $0d
                  .byte $9a
                  .byte $0d
b567              .byte $00
b568              .byte $0d
                  .byte $2a
                  .byte $0d
b56b              .byte $38
b56c              .byte $0d
                  .byte $70
                  .byte $0d
b56f              .byte $70
                  .byte $0d
b571              .byte $7e
                  .byte $0d
                  .byte $8c
b574              .byte $0d
                  .byte $9a
                  .byte $0d
b577              .byte $8e
                  .byte $b5
                  .byte $3e
b57a              .byte $b6
                  .byte $77
b57c              .byte $b6
                  .byte $7e
b57e              .byte $b6
                  .byte $89
b580              .byte $b6
                  .byte $7f
b582              .byte $b6
                  .byte $d1
b584              .byte $b6
                  .byte $00
b586              .byte $00
b587              .byte $00
b588              .byte $00
b589              .byte $00
b58a              .byte $00
b58b              .byte $53
b58c              .byte $55
                  .byte $70
b58e              .byte $06
                  .byte $04
b590              .byte $26
                  .byte $04
b592              .byte $80
b593              .byte $05
                  .byte $3e
b595              .byte $26
                  .byte $04
b597              .byte $80
b598              .byte $02
b599              .byte $52
b59a              .byte $2d
                  .byte $04
                  .byte $80
b59d              .byte $04
b59e              .byte $66
                  .byte $26
b5a0              .byte $04
b5a1              .byte $80
b5a2              .byte $06
                  .byte $86
b5a4              .byte $26
                  .byte $04
b5a6              .byte $80
b5a7              .byte $04
b5a8              .byte $0e
                  .byte $52
                  .byte $04
b5ab              .byte $80
b5ac              .byte $03
b5ad              .byte $3b
b5ae              .byte $44
b5af              .byte $04
b5b0              .byte $80
b5b1              .byte $02
b5b2              .byte $54
b5b3              .byte $49
                  .byte $04
b5b5              .byte $80
b5b6              .byte $03
b5b7              .byte $66
                  .byte $3d
b5b9              .byte $04
b5ba              .byte $80
b5bb              .byte $05
                  .byte $8a
b5bd              .byte $39
                  .byte $04
                  .byte $80
b5c0              .byte $02
b5c1              .byte $52
b5c2              .byte $58
b5c3              .byte $04
b5c4              .byte $80
b5c5              .byte $03
b5c6              .byte $62
b5c7              .byte $58
b5c8              .byte $04
b5c9              .byte $80
b5ca              .byte $02
b5cb              .byte $50
                  .byte $67
b5cd              .byte $04
b5ce              .byte $80
b5cf              .byte $02
b5d0              .byte $6c
                  .byte $67
                  .byte $04
b5d3              .byte $80
b5d4              .byte $04
b5d5              .byte $48
b5d6              .byte $76
                  .byte $04
b5d8              .byte $80
b5d9              .byte $03
b5da              .byte $66
                  .byte $78
b5dc              .byte $04
b5dd              .byte $80
b5de              .byte $05
                  .byte $82
b5e0              .byte $7d
                  .byte $04
                  .byte $80
b5e3              .byte $02
b5e4              .byte $02
b5e5              .byte $b9
                  .byte $04
                  .byte $80
b5e8              .byte $02
b5e9              .byte $02
b5ea              .byte $ad
                  .byte $04
                  .byte $80
b5ed              .byte $02
b5ee              .byte $10
                  .byte $a2
b5f0              .byte $04
b5f1              .byte $80
b5f2              .byte $02
b5f3              .byte $1e
                  .byte $92
                  .byte $04
b5f6              .byte $80
b5f7              .byte $03
b5f8              .byte $32
b5f9              .byte $85
                  .byte $04
b5fb              .byte $80
b5fc              .byte $02
b5fd              .byte $52
b5fe              .byte $94
                  .byte $04
b600              .byte $80
b601              .byte $02
b602              .byte $6c
                  .byte $94
                  .byte $04
b605              .byte $80
b606              .byte $03
b607              .byte $86
                  .byte $a2
b609              .byte $04
b60a              .byte $80
b60b              .byte $02
b60c              .byte $96
                  .byte $ad
b60e              .byte $04
b60f              .byte $80
b610              .byte $02
b611              .byte $96
                  .byte $b9
b613              .byte $04
b614              .byte $80
b615              .byte $05
                  .byte $10
b617              .byte $2a
b618              .byte $80
b619              .byte $11
                  .byte $05
b61b              .byte $14
b61c              .byte $2a
b61d              .byte $80
b61e              .byte $19
                  .byte $08
                  .byte $8c
b621              .byte $3d
                  .byte $80
                  .byte $12
b624              .byte $08
b625              .byte $90
                  .byte $3d
b627              .byte $80
b628              .byte $1a
b629              .byte $04
b62a              .byte $12
b62b              .byte $a8
b62c              .byte $80
b62d              .byte $38
b62e              .byte $04
b62f              .byte $8c
                  .byte $a8
                  .byte $80
b632              .byte $38
b633              .byte $02
b634              .byte $1c
b635              .byte $60
b636              .byte $04
b637              .byte $48
b638              .byte $28
b639              .byte $00
b63a              .byte $c7
b63b              .byte $04
b63c              .byte $28
b63d              .byte $00
b63e              .byte $08
b63f              .byte $14
b640              .byte $88
b641              .byte $22
b642              .byte $0e
                  .byte $18
                  .byte $34
b645              .byte $54
b646              .byte $78
b647              .byte $14
b648              .byte $48
b649              .byte $01
                  .byte $7e
b64b              .byte $88
b64c              .byte $38
b64d              .byte $54
b64e              .byte $1a
b64f              .byte $3c
b650              .byte $20
                  .byte $01
                  .byte $1e
b653              .byte $28
b654              .byte $5c
b655              .byte $7a
b656              .byte $3c
b657              .byte $30
                  .byte $b0
b659              .byte $43
b65a              .byte $42
b65b              .byte $4e
                  .byte $52
                  .byte $6e
b65e              .byte $0c
b65f              .byte $78
b660              .byte $50
                  .byte $22
b662              .byte $11
                  .byte $1e
b664              .byte $95
                  .byte $b6
b666              .byte $74
b667              .byte $82
b668              .byte $08
b669              .byte $01
                  .byte $79
b66b              .byte $86
                  .byte $a5
b66d              .byte $be
                  .byte $84
                  .byte $8c
b670              .byte $38
b671              .byte $43
b672              .byte $89
b673              .byte $96
                  .byte $ae
b675              .byte $be
                  .byte $00
                  .byte $1c
b678              .byte $43
b679              .byte $6f
b67a              .byte $98
b67b              .byte $56
                  .byte $9a
b67d              .byte $00
b67e              .byte $00
b67f              .byte $60
b680              .byte $03
b681              .byte $02
b682              .byte $1b
b683              .byte $01
                  .byte $1c
b685              .byte $80
b686              .byte $1c
b687              .byte $02
b688              .byte $00
b689              .byte $ff
b68a              .byte $14
b68b              .byte $e4
                  .byte $97
b68d              .byte $01
                  .byte $00
b68f              .byte $00
b690              .byte $ff
b691              .byte $02
b692              .byte $01
                  .byte $01
b694              .byte $00
b695              .byte $00
b696              .byte $00
b697              .byte $ff
b698              .byte $10
                  .byte $4e
b69a              .byte $a2
                  .byte $04
b69c              .byte $00
b69d              .byte $00
b69e              .byte $00
b69f              .byte $02
b6a0              .byte $06
                  .byte $01
b6a2              .byte $10
                  .byte $22
b6a4              .byte $00
b6a5              .byte $ff
b6a6              .byte $92
b6a7              .byte $4e
                  .byte $a2
                  .byte $03
b6aa              .byte $00
b6ab              .byte $00
b6ac              .byte $00
b6ad              .byte $03
b6ae              .byte $05
                  .byte $01
b6b0              .byte $92
b6b1              .byte $a4
                  .byte $00
b6b3              .byte $ff
b6b4              .byte $3e
                  .byte $ad
                  .byte $a2
b6b7              .byte $0c
b6b8              .byte $00
b6b9              .byte $00
b6ba              .byte $00
b6bb              .byte $03
b6bc              .byte $04
b6bd              .byte $01
                  .byte $3e
b6bf              .byte $44
b6c0              .byte $00
b6c1              .byte $ff
b6c2              .byte $a1
                  .byte $d5
b6c4              .byte $a2
                  .byte $08
b6c6              .byte $00
b6c7              .byte $00
b6c8              .byte $00
b6c9              .byte $04
b6ca              .byte $06
                  .byte $01
b6cc              .byte $a2
                  .byte $a4
b6ce              .byte $00
b6cf              .byte $00
b6d0              .byte $00
b6d1              .byte $38
b6d2              .byte $aa
b6d3              .byte $20
                  .byte $40
                  .byte $aa
b6d6              .byte $08
b6d7              .byte $48
b6d8              .byte $aa
b6d9              .byte $70
                  .byte $50
b6db              .byte $aa
b6dc              .byte $38
b6dd              .byte $58
b6de              .byte $aa
b6df              .byte $28
b6e0              .byte $60
b6e1              .byte $aa
b6e2              .byte $90
                  .byte $24
b6e4              .byte $b4
                  .byte $90
b6e6              .byte $2c
                  .byte $b4
                  .byte $08
b6e9              .byte $34
b6ea              .byte $b4
                  .byte $20
b6ec              .byte $3c
b6ed              .byte $b4
                  .byte $48
b6ef              .byte $44
b6f0              .byte $b4
                  .byte $78
b6f2              .byte $4c
                  .byte $b4
                  .byte $08
b6f5              .byte $54
b6f6              .byte $b4
                  .byte $18
b6f8              .byte $5c
b6f9              .byte $b4
                  .byte $a0
b6fb              .byte $64
b6fc              .byte $b4
                  .byte $48
b6fe              .byte $6c
                  .byte $b4
                  .byte $b0
b701              .byte $74
b702              .byte $b4
                  .byte $28
b704              .byte $3c
b705              .byte $be
                  .byte $b8
                  .byte $44
b708              .byte $be
                  .byte $08
                  .byte $4c
b70b              .byte $be
                  .byte $98
                  .byte $54
b70e              .byte $be
                  .byte $a0
                  .byte $5c
b711              .byte $be
                  .byte $28
                  .byte $00
b714              .byte $00
b715              .byte $0d
                  .byte $0e
                  .byte $0d
b718              .byte $70
                  .byte $0d
b71a              .byte $70
                  .byte $0d
b71c              .byte $70
                  .byte $0d
b71e              .byte $7e
                  .byte $0d
                  .byte $8c
b721              .byte $0d
                  .byte $9a
                  .byte $0d
b724              .byte $00
b725              .byte $0d
                  .byte $1c
                  .byte $0d
b728              .byte $2a
b729              .byte $0d
                  .byte $38
                  .byte $0d
b72c              .byte $70
                  .byte $0d
b72e              .byte $7e
                  .byte $0d
                  .byte $8c
b731              .byte $0d
                  .byte $9a
                  .byte $0d
b734              .byte $4b
b735              .byte $b7
b736              .byte $a5
                  .byte $b8
b738              .byte $03
b739              .byte $b9
                  .byte $de
                  .byte $b8
b73c              .byte $04
b73d              .byte $b9
                  .byte $4c
                  .byte $b9
b740              .byte $00
b741              .byte $00
b742              .byte $03
b743              .byte $0e
                  .byte $18
                  .byte $1d
b746              .byte $00
b747              .byte $00
b748              .byte $5a
b749              .byte $65
                  .byte $78
b74b              .byte $07
b74c              .byte $06
                  .byte $3d
b74e              .byte $04
b74f              .byte $80
b750              .byte $07
b751              .byte $02
b752              .byte $6b
b753              .byte $04
b754              .byte $80
b755              .byte $07
b756              .byte $06
                  .byte $99
b758              .byte $04
b759              .byte $80
b75a              .byte $05
                  .byte $4c
b75c              .byte $3e
                  .byte $04
                  .byte $80
b75f              .byte $02
b760              .byte $44
b761              .byte $48
b762              .byte $04
b763              .byte $80
b764              .byte $04
b765              .byte $52
b766              .byte $58
b767              .byte $04
b768              .byte $80
b769              .byte $05
                  .byte $36
b76b              .byte $68
b76c              .byte $04
b76d              .byte $80
b76e              .byte $03
b76f              .byte $36
                  .byte $97
b771              .byte $04
b772              .byte $80
b773              .byte $02
b774              .byte $3a
b775              .byte $b2
b776              .byte $04
b777              .byte $80
b778              .byte $03
b779              .byte $4e
                  .byte $9f
                  .byte $14
b77c              .byte $08
b77d              .byte $03
b77e              .byte $4e
                  .byte $af
                  .byte $f4
b781              .byte $08
b782              .byte $09
                  .byte $7a
b784              .byte $26
                  .byte $04
b786              .byte $80
b787              .byte $02
b788              .byte $94
                  .byte $3e
b78a              .byte $04
b78b              .byte $80
b78c              .byte $02
b78d              .byte $72
b78e              .byte $4c
                  .byte $04
                  .byte $80
b791              .byte $02
b792              .byte $7e
                  .byte $58
                  .byte $04
b795              .byte $80
b796              .byte $02
b797              .byte $7e
                  .byte $68
                  .byte $04
b79a              .byte $80
b79b              .byte $02
b79c              .byte $94
                  .byte $64
b79e              .byte $04
b79f              .byte $80
b7a0              .byte $02
b7a1              .byte $8d
                  .byte $71
                  .byte $04
b7a4              .byte $80
b7a5              .byte $04
b7a6              .byte $68
b7a7              .byte $88
b7a8              .byte $04
b7a9              .byte $80
b7aa              .byte $02
b7ab              .byte $96
                  .byte $80
b7ad              .byte $04
b7ae              .byte $80
b7af              .byte $04
b7b0              .byte $8c
                  .byte $8a
                  .byte $04
b7b3              .byte $80
b7b4              .byte $04
b7b5              .byte $64
b7b6              .byte $95
                  .byte $04
b7b8              .byte $80
b7b9              .byte $04
b7ba              .byte $90
                  .byte $ac
b7bc              .byte $04
b7bd              .byte $80
b7be              .byte $03
b7bf              .byte $72
b7c0              .byte $b0
                  .byte $04
b7c2              .byte $80
b7c3              .byte $28
b7c4              .byte $00
b7c5              .byte $c7
b7c6              .byte $04
b7c7              .byte $28
b7c8              .byte $58
b7c9              .byte $0f
b7ca              .byte $3d
                  .byte $11
                  .byte $20
b7cd              .byte $58
b7ce              .byte $13
b7cf              .byte $3d
                  .byte $11
                  .byte $20
b7d2              .byte $32
b7d3              .byte $8c
                  .byte $26
                  .byte $1f
b7d6              .byte $20
                  .byte $32
                  .byte $90
b7d9              .byte $26
                  .byte $1f
b7db              .byte $20
                  .byte $32
                  .byte $5a
b7de              .byte $58
b7df              .byte $11
                  .byte $20
b7e1              .byte $32
b7e2              .byte $5e
                  .byte $58
                  .byte $11
b7e5              .byte $20
                  .byte $18
                  .byte $7c
b7e8              .byte $26
                  .byte $11
b7ea              .byte $20
                  .byte $18
                  .byte $80
b7ed              .byte $26
                  .byte $11
b7ef              .byte $20
                  .byte $26
                  .byte $94
b7f2              .byte $3e
                  .byte $10
                  .byte $20
b7f5              .byte $26
                  .byte $98
b7f7              .byte $3e
                  .byte $10
                  .byte $20
b7fa              .byte $24
                  .byte $94
b7fc              .byte $64
b7fd              .byte $1f
b7fe              .byte $20
                  .byte $24
                  .byte $98
b801              .byte $64
b802              .byte $1f
b803              .byte $20
                  .byte $24
                  .byte $70
b806              .byte $88
b807              .byte $11
                  .byte $20
b809              .byte $24
                  .byte $74
b80b              .byte $88
b80c              .byte $11
                  .byte $20
b80e              .byte $1b
b80f              .byte $94
                  .byte $ac
b811              .byte $10
                  .byte $20
b813              .byte $1b
b814              .byte $98
b815              .byte $ac
                  .byte $10
                  .byte $20
b818              .byte $03
b819              .byte $0a
b81a              .byte $25
                  .byte $80
b81c              .byte $38
b81d              .byte $03
b81e              .byte $0a
b81f              .byte $53
b820              .byte $80
b821              .byte $38
b822              .byte $03
b823              .byte $0a
b824              .byte $81
                  .byte $80
b826              .byte $38
b827              .byte $03
b828              .byte $0a
b829              .byte $af
b82a              .byte $80
b82b              .byte $38
b82c              .byte $03
b82d              .byte $18
b82e              .byte $25
                  .byte $80
b830              .byte $38
b831              .byte $03
b832              .byte $18
b833              .byte $53
b834              .byte $80
b835              .byte $38
b836              .byte $03
b837              .byte $18
b838              .byte $81
                  .byte $80
b83a              .byte $38
b83b              .byte $03
b83c              .byte $18
b83d              .byte $af
b83e              .byte $80
b83f              .byte $38
b840              .byte $04
b841              .byte $0a
b842              .byte $23
b843              .byte $04
b844              .byte $40
b845              .byte $04
b846              .byte $0a
b847              .byte $51
                  .byte $04
b849              .byte $40
b84a              .byte $04
b84b              .byte $0a
b84c              .byte $7f
b84d              .byte $04
b84e              .byte $40
b84f              .byte $04
b850              .byte $0a
b851              .byte $ad
                  .byte $04
                  .byte $40
b854              .byte $02
b855              .byte $0c
b856              .byte $13
b857              .byte $80
b858              .byte $3d
                  .byte $02
                  .byte $0c
b85b              .byte $41
                  .byte $80
b85d              .byte $3d
                  .byte $02
                  .byte $0c
b860              .byte $6f
b861              .byte $80
b862              .byte $3d
                  .byte $02
                  .byte $0c
b865              .byte $9d
                  .byte $80
                  .byte $3d
b868              .byte $02
b869              .byte $16
                  .byte $13
b86b              .byte $80
b86c              .byte $3d
                  .byte $02
                  .byte $16
b86f              .byte $41
                  .byte $80
b871              .byte $3d
                  .byte $02
                  .byte $16
b874              .byte $6f
b875              .byte $80
b876              .byte $3d
                  .byte $02
                  .byte $16
b879              .byte $9d
                  .byte $80
                  .byte $3d
b87c              .byte $03
b87d              .byte $0c
b87e              .byte $18
b87f              .byte $04
b880              .byte $40
b881              .byte $03
b882              .byte $0c
b883              .byte $46
                  .byte $04
b885              .byte $40
b886              .byte $03
b887              .byte $0c
b888              .byte $74
b889              .byte $04
b88a              .byte $40
b88b              .byte $03
b88c              .byte $0c
b88d              .byte $a2
                  .byte $04
b88f              .byte $40
b890              .byte $01
                  .byte $1c
b892              .byte $31
                  .byte $04
b894              .byte $48
b895              .byte $01
                  .byte $1c
b897              .byte $72
b898              .byte $04
b899              .byte $48
b89a              .byte $01
                  .byte $1c
b89c              .byte $a3
b89d              .byte $04
b89e              .byte $48
b89f              .byte $02
b8a0              .byte $1c
b8a1              .byte $bc
                  .byte $04
                  .byte $48
b8a4              .byte $00
b8a5              .byte $01
                  .byte $54
b8a7              .byte $58
b8a8              .byte $22
b8a9              .byte $05
                  .byte $0f
b8ab              .byte $73
b8ac              .byte $91
                  .byte $36
b8ae              .byte $4a
b8af              .byte $70
                  .byte $43
b8b1              .byte $3a
b8b2              .byte $48
b8b3              .byte $6b
b8b4              .byte $8a
b8b5              .byte $24
                  .byte $84
b8b7              .byte $68
b8b8              .byte $01
                  .byte $28
b8ba              .byte $36
                  .byte $a3
b8bc              .byte $c2
b8bd              .byte $63
b8be              .byte $70
                  .byte $78
b8c0              .byte $01
                  .byte $69
b8c2              .byte $75
                  .byte $90
b8c4              .byte $a9
                  .byte $5c
b8c6              .byte $9c
b8c7              .byte $80
b8c8              .byte $01
                  .byte $62
b8ca              .byte $6e
                  .byte $bd
                  .byte $d8
b8cd              .byte $80
b8ce              .byte $a4
                  .byte $60
b8d0              .byte $43
b8d1              .byte $86
                  .byte $90
b8d3              .byte $c3
b8d4              .byte $e5
                  .byte $54
b8d6              .byte $0a
b8d7              .byte $c8
b8d8              .byte $b1
                  .byte $5a
b8da              .byte $64
b8db              .byte $28
b8dc              .byte $48
b8dd              .byte $00
b8de              .byte $2b
b8df              .byte $1b
b8e0              .byte $5a
b8e1              .byte $01
                  .byte $2d
b8e3              .byte $46
                  .byte $85
b8e5              .byte $01
                  .byte $32
b8e7              .byte $98
b8e8              .byte $43
b8e9              .byte $ff
b8ea              .byte $32
b8eb              .byte $66
                  .byte $75
b8ed              .byte $01
                  .byte $18
b8ef              .byte $88
b8f0              .byte $43
b8f1              .byte $01
                  .byte $26
b8f3              .byte $a0
                  .byte $5b
b8f5              .byte $00
b8f6              .byte $24
                  .byte $a0
b8f8              .byte $81
                  .byte $ff
b8fa              .byte $24
                  .byte $7c
b8fc              .byte $a5
                  .byte $01
b8fe              .byte $1b
b8ff              .byte $a0
                  .byte $c9
b901              .byte $00
b902              .byte $00
b903              .byte $00
b904              .byte $ff
b905              .byte $0e
                  .byte $e4
                  .byte $97
b908              .byte $01
                  .byte $00
b90a              .byte $00
b90b              .byte $ff
b90c              .byte $02
b90d              .byte $01
                  .byte $01
b90f              .byte $00
b910              .byte $00
b911              .byte $00
b912              .byte $ff
b913              .byte $58
b914              .byte $66
                  .byte $a2
b916              .byte $03
b917              .byte $00
b918              .byte $00
b919              .byte $00
b91a              .byte $02
b91b              .byte $06
                  .byte $01
b91d              .byte $58
b91e              .byte $66
                  .byte $00
b920              .byte $ff
b921              .byte $14
b922              .byte $c1
                  .byte $a2
b924              .byte $04
b925              .byte $00
b926              .byte $00
b927              .byte $00
b928              .byte $02
b929              .byte $05
                  .byte $01
b92b              .byte $14
b92c              .byte $28
b92d              .byte $00
b92e              .byte $ff
b92f              .byte $2c
                  .byte $ef
                  .byte $a2
b932              .byte $08
b933              .byte $00
b934              .byte $00
b935              .byte $00
b936              .byte $32
b937              .byte $03
b938              .byte $01
                  .byte $24
b93a              .byte $60
b93b              .byte $00
b93c              .byte $ff
b93d              .byte $48
b93e              .byte $ef
b93f              .byte $a2
                  .byte $0c
b941              .byte $00
b942              .byte $00
b943              .byte $00
b944              .byte $0a
b945              .byte $05
                  .byte $01
b947              .byte $16
                  .byte $60
b949              .byte $00
b94a              .byte $00
b94b              .byte $00
b94c              .byte $31
                  .byte $02
b94e              .byte $02
b94f              .byte $17
b950              .byte $01
                  .byte $1c
b952              .byte $74
b953              .byte $1c
b954              .byte $01
                  .byte $72
b956              .byte $04
b957              .byte $01
                  .byte $07
b959              .byte $01
                  .byte $1c
b95b              .byte $34
b95c              .byte $1c
b95d              .byte $01
                  .byte $a3
b95f              .byte $01
                  .byte $01
b961              .byte $07
b962              .byte $01
                  .byte $1c
b964              .byte $34
b965              .byte $1c
b966              .byte $01
                  .byte $bc
b968              .byte $01
                  .byte $01
b96a              .byte $15
                  .byte $01
b96c              .byte $1c
b96d              .byte $68
b96e              .byte $1c
b96f              .byte $02
b970              .byte $00
b971              .byte $56
                  .byte $53
b973              .byte $58
b974              .byte $44
b975              .byte $42
b976              .byte $4c
                  .byte $d0
                  .byte $1d
b979              .byte $56
                  .byte $53
b97b              .byte $58
b97c              .byte $54
b97d              .byte $4e
                  .byte $44
                  .byte $d0
b980              .byte $00
b981              .byte $0d
                  .byte $0e
                  .byte $0d
b984              .byte $1c
b985              .byte $0d
                  .byte $2a
                  .byte $0d
b988              .byte $38
b989              .byte $0d
                  .byte $7e
                  .byte $0d
b98c              .byte $8c
                  .byte $0d
                  .byte $9a
b98f              .byte $0d
                  .byte $00
                  .byte $0d
b992              .byte $46
                  .byte $0d
b994              .byte $70
                  .byte $0d
b996              .byte $70
                  .byte $0d
b998              .byte $70
                  .byte $0d
b99a              .byte $7e
                  .byte $0d
                  .byte $8c
b99d              .byte $0d
                  .byte $9a
                  .byte $0d
b9a0              .byte $b7
b9a1              .byte $b9
                  .byte $da
                  .byte $ba
b9a4              .byte $c7
b9a5              .byte $ba
b9a6              .byte $b2
b9a7              .byte $ba
b9a8              .byte $0b
b9a9              .byte $bb
b9aa              .byte $00
b9ab              .byte $00
b9ac              .byte $00
b9ad              .byte $00
b9ae              .byte $00
b9af              .byte $00
b9b0              .byte $00
b9b1              .byte $00
b9b2              .byte $61
                  .byte $bb
b9b4              .byte $70
                  .byte $45
b9b6              .byte $b4
                  .byte $28
b9b8              .byte $00
b9b9              .byte $c7
b9ba              .byte $04
b9bb              .byte $28
b9bc              .byte $26
                  .byte $04
b9be              .byte $28
b9bf              .byte $04
b9c0              .byte $80
b9c1              .byte $05
                  .byte $02
b9c3              .byte $48
b9c4              .byte $04
b9c5              .byte $80
b9c6              .byte $0d
                  .byte $02
                  .byte $68
b9c9              .byte $04
b9ca              .byte $80
b9cb              .byte $0d
                  .byte $02
                  .byte $7f
b9ce              .byte $04
b9cf              .byte $80
b9d0              .byte $0a
b9d1              .byte $02
b9d2              .byte $ae
                  .byte $04
                  .byte $80
b9d5              .byte $0f
b9d6              .byte $3a
b9d7              .byte $48
b9d8              .byte $04
b9d9              .byte $80
b9da              .byte $02
b9db              .byte $7e
                  .byte $66
                  .byte $04
b9de              .byte $80
b9df              .byte $05
                  .byte $8a
b9e1              .byte $66
                  .byte $04
b9e3              .byte $80
b9e4              .byte $03
b9e5              .byte $81
                  .byte $7a
b9e7              .byte $04
b9e8              .byte $80
b9e9              .byte $08
b9ea              .byte $7e
                  .byte $a9
                  .byte $04
b9ed              .byte $80
b9ee              .byte $0f
b9ef              .byte $3e
                  .byte $c3
                  .byte $04
b9f2              .byte $50
                  .byte $02
b9f4              .byte $66
                  .byte $c0
b9f6              .byte $09
                  .byte $58
b9f8              .byte $04
b9f9              .byte $64
b9fa              .byte $bd
                  .byte $04
                  .byte $48
b9fd              .byte $03
b9fe              .byte $66
                  .byte $b8
ba00              .byte $04
ba01              .byte $30
                  .byte $02
ba03              .byte $66
                  .byte $b7
ba05              .byte $0a
ba06              .byte $60
ba07              .byte $02
ba08              .byte $64
ba09              .byte $b6
                  .byte $0e
ba0b              .byte $60
ba0c              .byte $02
ba0d              .byte $66
                  .byte $b5
ba0f              .byte $0a
ba10              .byte $60
ba11              .byte $02
ba12              .byte $68
ba13              .byte $b4
                  .byte $06
ba15              .byte $60
ba16              .byte $02
ba17              .byte $6a
ba18              .byte $b3
ba19              .byte $02
ba1a              .byte $60
ba1b              .byte $02
ba1c              .byte $6a
ba1d              .byte $b2
ba1e              .byte $02
ba1f              .byte $60
ba20              .byte $02
ba21              .byte $68
ba22              .byte $b1
                  .byte $06
ba24              .byte $60
ba25              .byte $02
ba26              .byte $66
                  .byte $b0
ba28              .byte $0a
ba29              .byte $60
ba2a              .byte $02
ba2b              .byte $64
ba2c              .byte $af
ba2d              .byte $0e
                  .byte $60
                  .byte $02
ba30              .byte $66
                  .byte $ae
ba32              .byte $0a
ba33              .byte $60
ba34              .byte $02
ba35              .byte $68
ba36              .byte $ad
                  .byte $06
                  .byte $60
ba39              .byte $02
ba3a              .byte $6a
ba3b              .byte $ac
                  .byte $02
                  .byte $60
ba3e              .byte $04
ba3f              .byte $64
ba40              .byte $a9
                  .byte $04
ba42              .byte $48
ba43              .byte $04
ba44              .byte $0a
ba45              .byte $28
ba46              .byte $80
ba47              .byte $15
                  .byte $04
ba49              .byte $0e
                  .byte $28
                  .byte $80
ba4c              .byte $1d
                  .byte $04
                  .byte $3c
ba4f              .byte $28
ba50              .byte $80
ba51              .byte $15
                  .byte $04
ba53              .byte $40
ba54              .byte $28
ba55              .byte $80
ba56              .byte $1d
                  .byte $02
                  .byte $94
ba59              .byte $2a
ba5a              .byte $80
ba5b              .byte $13
ba5c              .byte $02
ba5d              .byte $98
ba5e              .byte $2a
ba5f              .byte $80
ba60              .byte $1b
ba61              .byte $04
ba62              .byte $48
ba63              .byte $48
ba64              .byte $80
ba65              .byte $15
                  .byte $04
ba67              .byte $4c
                  .byte $48
                  .byte $80
ba6a              .byte $1d
                  .byte $05
                  .byte $94
ba6d              .byte $3e
                  .byte $80
                  .byte $12
ba70              .byte $05
                  .byte $98
ba72              .byte $3e
                  .byte $80
                  .byte $1a
ba75              .byte $08
ba76              .byte $90
                  .byte $69
ba78              .byte $80
ba79              .byte $12
ba7a              .byte $08
ba7b              .byte $94
                  .byte $69
ba7d              .byte $80
ba7e              .byte $1a
ba7f              .byte $20
                  .byte $06
                  .byte $48
ba82              .byte $10
                  .byte $20
ba84              .byte $20
                  .byte $0a
                  .byte $48
ba87              .byte $10
                  .byte $20
ba89              .byte $2f
ba8a              .byte $06
                  .byte $7f
ba8c              .byte $10
                  .byte $20
ba8e              .byte $2f
ba8f              .byte $0a
ba90              .byte $7f
ba91              .byte $10
                  .byte $20
ba93              .byte $20
                  .byte $52
                  .byte $28
ba96              .byte $10
                  .byte $20
ba98              .byte $20
                  .byte $56
                  .byte $28
ba9b              .byte $10
                  .byte $20
ba9d              .byte $1e
                  .byte $66
                  .byte $48
baa0              .byte $11
                  .byte $20
baa2              .byte $1e
                  .byte $6a
                  .byte $48
baa5              .byte $11
                  .byte $20
baa7              .byte $14
baa8              .byte $84
                  .byte $66
baaa              .byte $10
                  .byte $20
baac              .byte $14
baad              .byte $88
baae              .byte $66
                  .byte $10
bab0              .byte $20
                  .byte $00
                  .byte $20
bab3              .byte $12
bab4              .byte $65
                  .byte $00
bab6              .byte $2f
bab7              .byte $12
bab8              .byte $9c
bab9              .byte $00
baba              .byte $20
                  .byte $5e
                  .byte $45
babd              .byte $00
babe              .byte $1e
                  .byte $72
                  .byte $65
bac1              .byte $01
                  .byte $14
bac3              .byte $90
                  .byte $83
bac5              .byte $00
bac6              .byte $00
bac7              .byte $16
                  .byte $45
bac9              .byte $65
                  .byte $48
bacb              .byte $45
                  .byte $65
bacd              .byte $a0
                  .byte $45
bacf              .byte $57
bad0              .byte $54
bad1              .byte $65
                  .byte $84
bad3              .byte $a0
                  .byte $5d
bad5              .byte $83
bad6              .byte $9c
bad7              .byte $83
bad8              .byte $c6
                  .byte $00
bada              .byte $24
                  .byte $16
badc              .byte $50
                  .byte $22
bade              .byte $2a
badf              .byte $36
                  .byte $35
bae1              .byte $55
                  .byte $70
bae3              .byte $16
                  .byte $88
bae5              .byte $22
bae6              .byte $76
                  .byte $80
bae8              .byte $35
                  .byte $55
baea              .byte $30
                  .byte $4a
baec              .byte $98
baed              .byte $43
baee              .byte $36
                  .byte $42
baf0              .byte $6b
baf1              .byte $89
baf2              .byte $86
                  .byte $3c
baf4              .byte $58
baf5              .byte $22
baf6              .byte $8a
baf7              .byte $95
                  .byte $59
baf9              .byte $7c
bafa              .byte $01
                  .byte $6e
bafc              .byte $a0
                  .byte $64
bafe              .byte $05
                  .byte $0f
bb00              .byte $94
                  .byte $a9
bb02              .byte $30
                  .byte $6e
bb04              .byte $48
bb05              .byte $01
                  .byte $36
bb07              .byte $42
bb08              .byte $92
bb09              .byte $9d
                  .byte $00
                  .byte $ff
bb0c              .byte $90
                  .byte $c6
bb0e              .byte $92
bb0f              .byte $01
                  .byte $00
bb11              .byte $00
bb12              .byte $ff
bb13              .byte $02
bb14              .byte $01
                  .byte $ff
bb16              .byte $00
bb17              .byte $00
bb18              .byte $00
bb19              .byte $ff
bb1a              .byte $1c
bb1b              .byte $50
                  .byte $a2
bb1d              .byte $03
bb1e              .byte $00
bb1f              .byte $00
bb20              .byte $00
bb21              .byte $03
bb22              .byte $01
                  .byte $01
bb24              .byte $0f
bb25              .byte $5c
bb26              .byte $00
bb27              .byte $ff
bb28              .byte $64
bb29              .byte $50
                  .byte $a0
bb2b              .byte $04
bb2c              .byte $00
bb2d              .byte $00
bb2e              .byte $00
bb2f              .byte $02
bb30              .byte $02
bb31              .byte $fe
                  .byte $50
                  .byte $a0
bb34              .byte $00
bb35              .byte $ff
bb36              .byte $1c
bb37              .byte $90
                  .byte $a2
bb39              .byte $08
bb3a              .byte $00
bb3b              .byte $00
bb3c              .byte $00
bb3d              .byte $02
bb3e              .byte $02
bb3f              .byte $01
                  .byte $14
bb41              .byte $3c
bb42              .byte $00
bb43              .byte $ff
bb44              .byte $1c
bb45              .byte $a7
bb46              .byte $a2
                  .byte $0c
bb48              .byte $00
bb49              .byte $00
bb4a              .byte $00
bb4b              .byte $06
                  .byte $03
bb4d              .byte $01
                  .byte $16
bb4f              .byte $3c
bb50              .byte $00
bb51              .byte $ff
bb52              .byte $1c
bb53              .byte $d6
                  .byte $a2
bb55              .byte $04
bb56              .byte $00
bb57              .byte $00
bb58              .byte $00
bb59              .byte $03
bb5a              .byte $02
bb5b              .byte $03
bb5c              .byte $18
bb5d              .byte $30
                  .byte $00
bb5f              .byte $00
bb60              .byte $00
bb61              .byte $ff
bb62              .byte $2c
                  .byte $ec
                  .byte $a7
bb65              .byte $03
bb66              .byte $00
bb67              .byte $ff
bb68              .byte $00
bb69              .byte $00
bb6a              .byte $00
bb6b              .byte $00
bb6c              .byte $00
bb6d              .byte $00
bb6e              .byte $00
bb6f              .byte $ff
bb70              .byte $37
bb71              .byte $ec
                  .byte $a7
                  .byte $03
bb74              .byte $00
bb75              .byte $ff
bb76              .byte $00
bb77              .byte $00
bb78              .byte $00
bb79              .byte $00
bb7a              .byte $00
bb7b              .byte $00
bb7c              .byte $00
bb7d              .byte $00
bb7e              .byte $0d
                  .byte $0e
                  .byte $0d
bb81              .byte $1c
bb82              .byte $0d
                  .byte $2a
                  .byte $0d
bb85              .byte $38
bb86              .byte $0d
                  .byte $7e
                  .byte $0d
bb89              .byte $8c
                  .byte $0d
                  .byte $9a
bb8c              .byte $0d
                  .byte $00
                  .byte $0d
bb8f              .byte $70
                  .byte $0d
bb91              .byte $62
bb92              .byte $0d
                  .byte $54
                  .byte $0d
bb95              .byte $46
                  .byte $0d
bb97              .byte $7e
                  .byte $0d
                  .byte $8c
bb9a              .byte $0d
                  .byte $9a
                  .byte $0d
bb9d              .byte $b4
                  .byte $bb
bb9f              .byte $df
bba0              .byte $bc
                  .byte $a1
                  .byte $bc
bba3              .byte $8c
                  .byte $bc
                  .byte $18
bba6              .byte $bd
                  .byte $b1
                  .byte $bc
bba9              .byte $00
bbaa              .byte $00
bbab              .byte $00
bbac              .byte $00
bbad              .byte $8a
bbae              .byte $bd
                  .byte $00
                  .byte $00
bbb1              .byte $43
bbb2              .byte $75
                  .byte $ab
bbb4              .byte $28
bbb5              .byte $00
bbb6              .byte $c7
bbb7              .byte $04
bbb8              .byte $28
bbb9              .byte $07
bbba              .byte $02
bbbb              .byte $20
                  .byte $04
                  .byte $80
bbbe              .byte $07
bbbf              .byte $02
bbc0              .byte $3e
                  .byte $04
                  .byte $80
bbc3              .byte $07
bbc4              .byte $02
bbc5              .byte $5c
bbc6              .byte $04
bbc7              .byte $80
bbc8              .byte $07
bbc9              .byte $02
bbca              .byte $7a
bbcb              .byte $04
bbcc              .byte $80
bbcd              .byte $07
bbce              .byte $02
bbcf              .byte $98
bbd0              .byte $04
bbd1              .byte $80
bbd2              .byte $07
bbd3              .byte $80
bbd4              .byte $20
                  .byte $04
                  .byte $80
bbd7              .byte $06
                  .byte $7e
bbd9              .byte $3e
                  .byte $04
                  .byte $80
bbdc              .byte $06
                  .byte $7c
bbde              .byte $5c
bbdf              .byte $04
bbe0              .byte $80
bbe1              .byte $06
                  .byte $7e
bbe3              .byte $7a
bbe4              .byte $04
bbe5              .byte $80
bbe6              .byte $07
bbe7              .byte $82
bbe8              .byte $98
bbe9              .byte $04
bbea              .byte $80
bbeb              .byte $9f
bbec              .byte $20
                  .byte $28
                  .byte $10
bbef              .byte $20
                  .byte $9f
                  .byte $24
bbf2              .byte $28
bbf3              .byte $10
                  .byte $20
bbf5              .byte $04
bbf6              .byte $8c
                  .byte $1e
                  .byte $80
bbf9              .byte $17
bbfa              .byte $04
bbfb              .byte $90
                  .byte $1e
bbfd              .byte $80
bbfe              .byte $1f
bbff              .byte $04
bc00              .byte $89
bc01              .byte $3c
bc02              .byte $80
bc03              .byte $17
bc04              .byte $04
bc05              .byte $8d
                  .byte $3c
                  .byte $80
bc08              .byte $1f
bc09              .byte $04
bc0a              .byte $86
                  .byte $5a
bc0c              .byte $80
bc0d              .byte $17
bc0e              .byte $04
bc0f              .byte $8a
bc10              .byte $5a
bc11              .byte $80
bc12              .byte $1f
bc13              .byte $04
bc14              .byte $89
bc15              .byte $78
bc16              .byte $80
bc17              .byte $17
bc18              .byte $04
bc19              .byte $8d
                  .byte $78
                  .byte $80
bc1c              .byte $1f
bc1d              .byte $06
                  .byte $94
bc1f              .byte $97
bc20              .byte $80
bc21              .byte $16
                  .byte $06
bc23              .byte $98
bc24              .byte $97
bc25              .byte $80
bc26              .byte $1e
                  .byte $01
                  .byte $7d
bc29              .byte $28
bc2a              .byte $04
bc2b              .byte $48
bc2c              .byte $01
                  .byte $7b
bc2e              .byte $46
                  .byte $04
bc30              .byte $48
bc31              .byte $01
                  .byte $79
bc33              .byte $64
bc34              .byte $04
bc35              .byte $48
bc36              .byte $01
                  .byte $7b
bc38              .byte $82
bc39              .byte $04
bc3a              .byte $48
bc3b              .byte $01
                  .byte $7f
bc3d              .byte $a0
                  .byte $04
bc3f              .byte $48
bc40              .byte $17
bc41              .byte $29
                  .byte $a5
bc43              .byte $04
bc44              .byte $48
bc45              .byte $04
bc46              .byte $29
                  .byte $a7
bc48              .byte $80
bc49              .byte $38
bc4a              .byte $04
bc4b              .byte $83
bc4c              .byte $a7
bc4d              .byte $80
bc4e              .byte $38
bc4f              .byte $01
                  .byte $30
bc51              .byte $a8
bc52              .byte $04
bc53              .byte $20
                  .byte $01
                  .byte $48
bc56              .byte $a8
bc57              .byte $04
bc58              .byte $20
                  .byte $01
                  .byte $60
bc5b              .byte $a8
bc5c              .byte $04
bc5d              .byte $20
                  .byte $01
                  .byte $78
bc60              .byte $a8
bc61              .byte $04
bc62              .byte $20
                  .byte $02
                  .byte $2e
bc65              .byte $a9
                  .byte $04
bc67              .byte $40
bc68              .byte $02
bc69              .byte $46
                  .byte $a9
bc6b              .byte $04
bc6c              .byte $40
bc6d              .byte $02
bc6e              .byte $5e
                  .byte $a9
                  .byte $04
bc71              .byte $40
bc72              .byte $02
bc73              .byte $76
                  .byte $a9
bc75              .byte $04
bc76              .byte $40
bc77              .byte $03
bc78              .byte $2c
                  .byte $ab
                  .byte $04
bc7b              .byte $40
bc7c              .byte $03
bc7d              .byte $44
bc7e              .byte $ab
bc7f              .byte $04
bc80              .byte $40
bc81              .byte $03
bc82              .byte $5c
bc83              .byte $ab
bc84              .byte $04
bc85              .byte $40
bc86              .byte $03
bc87              .byte $74
bc88              .byte $ab
bc89              .byte $04
bc8a              .byte $40
bc8b              .byte $00
bc8c              .byte $9f
bc8d              .byte $2c
                  .byte $45
                  .byte $00
bc90              .byte $81
                  .byte $2c
bc92              .byte $63
bc93              .byte $00
bc94              .byte $63
bc95              .byte $2c
                  .byte $81
                  .byte $00
bc98              .byte $45
                  .byte $2c
bc9a              .byte $9f
bc9b              .byte $00
bc9c              .byte $27
bc9d              .byte $2c
                  .byte $bd
                  .byte $00
bca0              .byte $00
bca1              .byte $98
bca2              .byte $3d
                  .byte $5b
                  .byte $95
bca5              .byte $5b
bca6              .byte $79
                  .byte $92
bca8              .byte $79
bca9              .byte $97
bcaa              .byte $95
                  .byte $97
bcac              .byte $b5
                  .byte $a0
bcae              .byte $b5
                  .byte $e4
bcb0              .byte $00
bcb1              .byte $28
bcb2              .byte $00
bcb3              .byte $00
bcb4              .byte $1a
bcb5              .byte $00
bcb6              .byte $1c
bcb7              .byte $7d
                  .byte $7d
                  .byte $01
bcba              .byte $46
                  .byte $00
bcbc              .byte $00
bcbd              .byte $1a
bcbe              .byte $00
bcbf              .byte $1c
bcc0              .byte $7b
bcc1              .byte $7b
bcc2              .byte $01
                  .byte $64
bcc4              .byte $00
bcc5              .byte $00
bcc6              .byte $1a
bcc7              .byte $00
bcc8              .byte $1c
bcc9              .byte $79
                  .byte $79
                  .byte $01
bccc              .byte $82
bccd              .byte $00
bcce              .byte $00
bccf              .byte $1a
bcd0              .byte $00
bcd1              .byte $1c
bcd2              .byte $7b
bcd3              .byte $7b
bcd4              .byte $01
                  .byte $a0
bcd6              .byte $00
bcd7              .byte $00
bcd8              .byte $1a
bcd9              .byte $00
bcda              .byte $1c
bcdb              .byte $7f
bcdc              .byte $7f
bcdd              .byte $01
                  .byte $00
bcdf              .byte $30
                  .byte $16
bce1              .byte $08
bce2              .byte $01
                  .byte $34
bce4              .byte $41
                  .byte $38
bce6              .byte $53
bce7              .byte $30
                  .byte $34
bce9              .byte $51
                  .byte $22
bceb              .byte $34
bcec              .byte $41
                  .byte $53
bcee              .byte $73
bcef              .byte $30
                  .byte $52
bcf1              .byte $ba
bcf2              .byte $43
bcf3              .byte $34
bcf4              .byte $41
                  .byte $72
bcf6              .byte $93
bcf7              .byte $30
                  .byte $70
bcf9              .byte $b0
                  .byte $43
bcfb              .byte $34
bcfc              .byte $41
                  .byte $92
bcfe              .byte $b0
                  .byte $30
bd00              .byte $8e
                  .byte $12
                  .byte $01
bd03              .byte $34
bd04              .byte $41
                  .byte $b2
bd06              .byte $cd
                  .byte $10
                  .byte $ac
bd09              .byte $58
bd0a              .byte $22
bd0b              .byte $14
bd0c              .byte $20
                  .byte $cb
                  .byte $e6
bd0f              .byte $86
                  .byte $ac
bd11              .byte $80
bd12              .byte $01
                  .byte $8a
bd14              .byte $97
bd15              .byte $cb
bd16              .byte $e6
                  .byte $00
bd18              .byte $ff
bd19              .byte $a2
                  .byte $3d
bd1b              .byte $92
bd1c              .byte $01
                  .byte $00
bd1e              .byte $00
bd1f              .byte $ff
bd20              .byte $02
bd21              .byte $01
                  .byte $ff
bd23              .byte $00
bd24              .byte $00
bd25              .byte $00
bd26              .byte $ff
bd27              .byte $0d
                  .byte $48
                  .byte $a2
bd2a              .byte $03
bd2b              .byte $00
bd2c              .byte $00
bd2d              .byte $00
bd2e              .byte $08
bd2f              .byte $03
bd30              .byte $01
                  .byte $0d
bd32              .byte $22
bd33              .byte $00
bd34              .byte $ff
bd35              .byte $0d
                  .byte $66
                  .byte $a2
bd38              .byte $04
bd39              .byte $00
bd3a              .byte $00
bd3b              .byte $00
bd3c              .byte $10
                  .byte $03
bd3e              .byte $01
                  .byte $0d
bd40              .byte $22
bd41              .byte $00
bd42              .byte $ff
bd43              .byte $0d
                  .byte $84
                  .byte $a2
bd46              .byte $06
                  .byte $00
bd48              .byte $00
bd49              .byte $00
bd4a              .byte $18
bd4b              .byte $03
bd4c              .byte $01
                  .byte $0d
bd4e              .byte $22
bd4f              .byte $00
bd50              .byte $ff
bd51              .byte $0d
                  .byte $a2
                  .byte $a2
bd54              .byte $08
bd55              .byte $00
bd56              .byte $00
bd57              .byte $00
bd58              .byte $0a
bd59              .byte $03
bd5a              .byte $01
                  .byte $0d
bd5c              .byte $22
bd5d              .byte $00
bd5e              .byte $ff
bd5f              .byte $0d
                  .byte $c0
                  .byte $a2
bd62              .byte $0c
bd63              .byte $00
bd64              .byte $00
bd65              .byte $00
bd66              .byte $1a
bd67              .byte $03
bd68              .byte $01
                  .byte $0d
bd6a              .byte $22
bd6b              .byte $00
bd6c              .byte $ff
bd6d              .byte $0e
                  .byte $ef
                  .byte $a2
bd70              .byte $04
bd71              .byte $00
bd72              .byte $00
bd73              .byte $00
bd74              .byte $02
bd75              .byte $04
bd76              .byte $01
                  .byte $0e
bd78              .byte $22
bd79              .byte $00
bd7a              .byte $ff
bd7b              .byte $8c
                  .byte $ef
                  .byte $a2
bd7e              .byte $02
bd7f              .byte $00
bd80              .byte $00
bd81              .byte $00
bd82              .byte $0f
bd83              .byte $04
bd84              .byte $01
                  .byte $3c
bd86              .byte $94
                  .byte $00
bd88              .byte $00
bd89              .byte $00
bd8a              .byte $2c
                  .byte $ac
                  .byte $7f
bd8d              .byte $5c
bd8e              .byte $ac
                  .byte $64
                  .byte $74
bd91              .byte $ac
                  .byte $46
                  .byte $44
bd94              .byte $ac
                  .byte $28
                  .byte $00
bd97              .byte $00
bd98              .byte $00
bd99              .byte $00
bd9a              .byte $0d
                  .byte $0e
                  .byte $0d
bd9d              .byte $1c
bd9e              .byte $0d
                  .byte $2a
                  .byte $0d
bda1              .byte $38
bda2              .byte $0d
                  .byte $7e
                  .byte $0d
bda5              .byte $8c
                  .byte $0d
                  .byte $9a
bda8              .byte $0d
                  .byte $00
                  .byte $0d
bdab              .byte $46
                  .byte $0d
bdad              .byte $54
bdae              .byte $0d
                  .byte $70
                  .byte $0d
bdb1              .byte $70
                  .byte $0d
bdb3              .byte $7e
                  .byte $0d
                  .byte $8c
bdb6              .byte $0d
                  .byte $9a
                  .byte $0d
bdb9              .byte $d0
                  .byte $bd
bdbb              .byte $c5
                  .byte $be
bdbd              .byte $a8
bdbe              .byte $be
                  .byte $ac
                  .byte $be
bdc1              .byte $26
                  .byte $bf
bdc3              .byte $00
bdc4              .byte $00
bdc5              .byte $8a
bdc6              .byte $bf
bdc7              .byte $00
bdc8              .byte $00
bdc9              .byte $00
bdca              .byte $00
bdcb              .byte $00
bdcc              .byte $00
bdcd              .byte $86
                  .byte $75
bdcf              .byte $87
bdd0              .byte $28
bdd1              .byte $00
bdd2              .byte $c7
bdd3              .byte $04
bdd4              .byte $28
bdd5              .byte $0b
bdd6              .byte $02
bdd7              .byte $ae
                  .byte $04
                  .byte $80
bdda              .byte $0b
bddb              .byte $02
bddc              .byte $97
bddd              .byte $04
bdde              .byte $80
bddf              .byte $0b
bde0              .byte $02
bde1              .byte $80
bde2              .byte $04
bde3              .byte $80
bde4              .byte $02
bde5              .byte $2c
                  .byte $ba
                  .byte $04
bde8              .byte $80
bde9              .byte $02
bdea              .byte $2c
                  .byte $a3
                  .byte $04
bded              .byte $80
bdee              .byte $02
bdef              .byte $2c
                  .byte $8c
                  .byte $04
bdf2              .byte $80
bdf3              .byte $07
bdf4              .byte $38
bdf5              .byte $7b
bdf6              .byte $04
bdf7              .byte $80
bdf8              .byte $15
                  .byte $00
bdfa              .byte $50
                  .byte $04
bdfc              .byte $80
bdfd              .byte $15
                  .byte $00
bdff              .byte $28
be00              .byte $04
be01              .byte $80
be02              .byte $0d
                  .byte $6c
                  .byte $28
be05              .byte $04
be06              .byte $80
be07              .byte $0d
                  .byte $6c
                  .byte $50
be0a              .byte $04
be0b              .byte $80
be0c              .byte $0d
                  .byte $6c
                  .byte $7b
be0f              .byte $04
be10              .byte $80
be11              .byte $07
be12              .byte $7a
be13              .byte $92
be14              .byte $04
be15              .byte $80
be16              .byte $28
be17              .byte $0e
                  .byte $28
                  .byte $11
be1a              .byte $20
                  .byte $28
                  .byte $12
be1d              .byte $28
be1e              .byte $11
                  .byte $20
be20              .byte $77
be21              .byte $36
                  .byte $50
be23              .byte $10
                  .byte $20
be25              .byte $77
be26              .byte $3a
be27              .byte $50
                  .byte $10
be29              .byte $20
                  .byte $6a
                  .byte $8c
be2c              .byte $28
be2d              .byte $10
                  .byte $20
be2f              .byte $6a
be30              .byte $90
                  .byte $28
be32              .byte $10
                  .byte $20
be34              .byte $06
                  .byte $8c
be36              .byte $97
be37              .byte $80
be38              .byte $10
                  .byte $06
be3a              .byte $90
                  .byte $97
be3c              .byte $80
be3d              .byte $18
be3e              .byte $0c
be3f              .byte $00
be40              .byte $67
be41              .byte $80
be42              .byte $38
be43              .byte $09
                  .byte $34
be45              .byte $67
be46              .byte $80
be47              .byte $38
be48              .byte $01
                  .byte $0c
be4a              .byte $5f
be4b              .byte $80
be4c              .byte $38
be4d              .byte $01
                  .byte $2a
be4f              .byte $5f
be50              .byte $80
be51              .byte $38
be52              .byte $0d
                  .byte $02
                  .byte $67
be55              .byte $04
be56              .byte $40
be57              .byte $08
be58              .byte $0c
be59              .byte $5d
                  .byte $04
                  .byte $40
be5c              .byte $0f
be5d              .byte $40
be5e              .byte $c3
be5f              .byte $04
be60              .byte $50
                  .byte $04
be62              .byte $74
be63              .byte $99
                  .byte $80
                  .byte $6f
be66              .byte $04
be67              .byte $78
be68              .byte $99
                  .byte $80
                  .byte $6f
be6b              .byte $02
be6c              .byte $73
be6d              .byte $a8
be6e              .byte $80
be6f              .byte $68
be70              .byte $02
be71              .byte $79
                  .byte $a8
                  .byte $80
be74              .byte $68
be75              .byte $03
be76              .byte $72
be77              .byte $ae
                  .byte $04
                  .byte $68
be7a              .byte $02
be7b              .byte $77
be7c              .byte $b9
                  .byte $10
                  .byte $60
be7f              .byte $01
                  .byte $6e
be81              .byte $b1
                  .byte $04
be83              .byte $40
be84              .byte $01
                  .byte $7e
be86              .byte $b1
                  .byte $04
be88              .byte $40
be89              .byte $01
                  .byte $6e
be8b              .byte $b1
                  .byte $80
be8d              .byte $38
be8e              .byte $01
                  .byte $80
be90              .byte $b1
                  .byte $80
be92              .byte $38
be93              .byte $06
                  .byte $6e
be95              .byte $b8
be96              .byte $11
                  .byte $60
be98              .byte $06
                  .byte $80
be9a              .byte $b8
be9b              .byte $1f
be9c              .byte $60
be9d              .byte $03
be9e              .byte $72
be9f              .byte $be
                  .byte $04
                  .byte $40
bea2              .byte $02
bea3              .byte $73
bea4              .byte $c0
                  .byte $07
bea6              .byte $58
bea7              .byte $00
bea8              .byte $98
bea9              .byte $af
beaa              .byte $e4
                  .byte $00
beac              .byte $28
bead              .byte $1a
beae              .byte $45
                  .byte $01
beb0              .byte $77
beb1              .byte $42
beb2              .byte $6d
                  .byte $00
                  .byte $4c
beb5              .byte $42
beb6              .byte $98
beb7              .byte $00
beb8              .byte $6a
beb9              .byte $98
beba              .byte $45
                  .byte $00
bebc              .byte $42
bebd              .byte $98
bebe              .byte $6d
                  .byte $00
                  .byte $17
bec1              .byte $98
bec2              .byte $98
bec3              .byte $00
bec4              .byte $00
bec5              .byte $04
bec6              .byte $b5
                  .byte $d0
bec8              .byte $01
                  .byte $0b
beca              .byte $14
becb              .byte $d7
becc              .byte $e5
                  .byte $10
bece              .byte $b5
                  .byte $d1
bed0              .byte $01
                  .byte $17
bed2              .byte $20
                  .byte $d7
                  .byte $e5
bed5              .byte $1c
bed6              .byte $b5
                  .byte $d2
bed8              .byte $01
                  .byte $23
beda              .byte $2c
                  .byte $d7
                  .byte $e5
bedd              .byte $04
bede              .byte $9d
                  .byte $da
                  .byte $22
bee1              .byte $09
                  .byte $16
bee3              .byte $bf
bee4              .byte $db
bee5              .byte $10
                  .byte $9d
bee7              .byte $d8
bee8              .byte $22
bee9              .byte $15
                  .byte $22
beeb              .byte $bf
beec              .byte $db
beed              .byte $1c
beee              .byte $9d
                  .byte $d9
                  .byte $22
bef1              .byte $21
                  .byte $2e
bef3              .byte $bf
bef4              .byte $db
bef5              .byte $04
bef6              .byte $86
                  .byte $e1
bef8              .byte $43
bef9              .byte $09
                  .byte $16
befb              .byte $a8
befc              .byte $c4
                  .byte $10
befe              .byte $86
                  .byte $e2
bf00              .byte $43
bf01              .byte $15
                  .byte $22
bf03              .byte $a8
bf04              .byte $c4
                  .byte $1c
bf06              .byte $86
                  .byte $e0
bf08              .byte $43
bf09              .byte $21
                  .byte $2e
bf0b              .byte $a8
bf0c              .byte $c4
                  .byte $04
bf0e              .byte $6f
bf0f              .byte $e0
                  .byte $43
bf11              .byte $09
                  .byte $16
bf13              .byte $91
                  .byte $ad
bf15              .byte $10
                  .byte $6f
bf17              .byte $e1
                  .byte $43
bf19              .byte $15
                  .byte $22
bf1b              .byte $91
                  .byte $ad
bf1d              .byte $1c
bf1e              .byte $6f
bf1f              .byte $e2
bf20              .byte $43
bf21              .byte $21
                  .byte $2e
bf23              .byte $91
                  .byte $ad
bf25              .byte $00
bf26              .byte $ff
bf27              .byte $a4
                  .byte $e4
bf29              .byte $92
bf2a              .byte $01
                  .byte $00
bf2c              .byte $00
bf2d              .byte $ff
bf2e              .byte $02
bf2f              .byte $01
                  .byte $ff
bf31              .byte $00
bf32              .byte $00
bf33              .byte $00
bf34              .byte $ff
bf35              .byte $0e
                  .byte $50
                  .byte $a2
bf38              .byte $03
bf39              .byte $00
bf3a              .byte $00
bf3b              .byte $00
bf3c              .byte $02
bf3d              .byte $04
bf3e              .byte $01
                  .byte $0e
bf40              .byte $58
bf41              .byte $00
bf42              .byte $ff
bf43              .byte $7a
bf44              .byte $50
                  .byte $a2
bf46              .byte $02
bf47              .byte $00
bf48              .byte $00
bf49              .byte $00
bf4a              .byte $02
bf4b              .byte $04
bf4c              .byte $01
                  .byte $7a
bf4e              .byte $a4
                  .byte $00
bf50              .byte $ff
bf51              .byte $32
bf52              .byte $78
bf53              .byte $a2
                  .byte $04
bf55              .byte $00
bf56              .byte $00
bf57              .byte $00
bf58              .byte $05
                  .byte $05
bf5a              .byte $01
                  .byte $0e
bf5c              .byte $58
bf5d              .byte $00
bf5e              .byte $ff
bf5f              .byte $82
bf60              .byte $78
bf61              .byte $a2
                  .byte $09
bf63              .byte $00
bf64              .byte $00
bf65              .byte $00
bf66              .byte $04
bf67              .byte $05
                  .byte $01
bf69              .byte $7a
bf6a              .byte $a4
                  .byte $00
bf6c              .byte $ff
bf6d              .byte $46
                  .byte $a3
bf6f              .byte $a2
                  .byte $06
bf71              .byte $00
bf72              .byte $00
bf73              .byte $00
bf74              .byte $0f
bf75              .byte $07
bf76              .byte $01
                  .byte $44
bf78              .byte $59
                  .byte $00
                  .byte $ff
bf7b              .byte $a0
                  .byte $a3
bf7d              .byte $a0
                  .byte $03
bf7f              .byte $00
bf80              .byte $00
bf81              .byte $00
bf82              .byte $0a
bf83              .byte $06
                  .byte $ff
bf85              .byte $7a
bf86              .byte $a4
                  .byte $00
bf88              .byte $00
bf89              .byte $00
bf8a              .byte $02
bf8b              .byte $10
                  .byte $a0
bf8d              .byte $0a
bf8e              .byte $10
                  .byte $70
bf90              .byte $12
bf91              .byte $10
                  .byte $a0
bf93              .byte $22
bf94              .byte $10
                  .byte $18
bf96              .byte $2a
bf97              .byte $10
                  .byte $40
bf99              .byte $32
bf9a              .byte $10
                  .byte $08
bf9c              .byte $3a
bf9d              .byte $10
                  .byte $90
bf9f              .byte $42
bfa0              .byte $10
                  .byte $38
bfa2              .byte $4a
bfa3              .byte $10
                  .byte $28
bfa5              .byte $7a
bfa6              .byte $10
                  .byte $a0
bfa8              .byte $82
bfa9              .byte $10
                  .byte $78
bfab              .byte $8a
bfac              .byte $10
                  .byte $70
bfae              .byte $92
bfaf              .byte $10
                  .byte $98
bfb1              .byte $48
bfb2              .byte $38
bfb3              .byte $20
                  .byte $50
                  .byte $38
bfb6              .byte $08
bfb7              .byte $58
bfb8              .byte $38
bfb9              .byte $70
                  .byte $60
bfbb              .byte $38
bfbc              .byte $38
bfbd              .byte $68
bfbe              .byte $38
bfbf              .byte $28
bfc0              .byte $70
                  .byte $38
bfc2              .byte $90
                  .byte $10
bfc4              .byte $60
bfc5              .byte $a0
                  .byte $18
bfc7              .byte $60
bfc8              .byte $70
                  .byte $20
bfca              .byte $60
bfcb              .byte $a0
                  .byte $00
bfcd              .byte $00
bfce              .byte $ff
bfcf              .byte $ff
                  
S_bfd0            and #$78
bfd2              bne $bfd6
bfd4              lda #$70
bfd6              sta $22
bfd8              rts
                  
bfd9              .byte $00
bfda              .byte $ff
bfdb              .byte $ff
bfdc              .byte $00
bfdd              .byte $00
bfde              .byte $ff
bfdf              .byte $ff
bfe0              .byte $00
bfe1              .byte $00
bfe2              .byte $ff
bfe3              .byte $ff
bfe4              .byte $00
bfe5              .byte $00
bfe6              .byte $ff
bfe7              .byte $ff
bfe8              .byte $00
bfe9              .byte $00
bfea              .byte $ff
bfeb              .byte $ff
bfec              .byte $00
bfed              .byte $00
bfee              .byte $ff
bfef              .byte $ff
bff0              .byte $00
bff1              .byte $00
bff2              .byte $ff
bff3              .byte $ff
bff4              .byte $00
bff5              .byte $00
bff6              .byte $ff
bff7              .byte $ff
bff8              .byte $00
bff9              .byte $80
bffa              .byte $ff
bffb              .byte $ff
bffc              .byte $00
bffd              .byte $04
bffe              .byte $ff
bfff              .byte $7f
