; -------------------------------------------------------------------------------------------------------------- ;
; Miner 2049er - Level Structure Tiles
; -------------------------------------------------------------------------------------------------------------- ;
LevelStructureTiles equ  *                        ; 
                    
LevelStructTile00   dc.b $07 ; .....###           ; $00 - $a000
                    dc.b $11 ; ...#...#
                    dc.b $00 ; ........
                    dc.b $ff ; ########
                    dc.b $00 ; ........
                    dc.b $ff ; ########
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelTileGroundNew1 dc.b $ff ; ########           ; $01 - $a008
                    dc.b $00 ; ........
                    dc.b $ff ; ########
                    dc.b $00 ; ........
                    dc.b $ff ; ########
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelTileLadderLe   dc.b $aa ; #.#.#.#.           ; $02 - $a010
                    dc.b $a0 ; #.#.....
                    dc.b $a0 ; #.#.....
                    dc.b $a0 ; #.#.....
                    dc.b $aa ; #.#.#.#.
                    dc.b $a0 ; #.#.....
                    dc.b $a0 ; #.#.....
                    dc.b $a0 ; #.#.....
                    
LevelTileLadderRi   dc.b $aa ; #.#.#.#.           ; $03 - $a018
                    dc.b $0a ; ....#.#.
                    dc.b $0a ; ....#.#.
                    dc.b $0a ; ....#.#.
                    dc.b $aa ; #.#.#.#.
                    dc.b $0a ; ....#.#.
                    dc.b $0a ; ....#.#.
                    dc.b $0a ; ....#.#.
                    
LevelStructTile04   dc.b $aa ; #.#.#.#.           ; $04 - $a020
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelTileGroundThin dc.b $ff ; ########           ; $05 - $a028
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelTileGroundFix  dc.b $ff ; ########           ; $06 - $a030
                    dc.b $ff ; ########
                    dc.b $ff ; ########
                    dc.b $ff ; ########
                    dc.b $ff ; ########
                    dc.b $ff ; ########
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelStructTile07   dc.b $50 ; .#.#....           ; $07 - $a038
                    dc.b $50 ; .#.#....
                    dc.b $50 ; .#.#....
                    dc.b $50 ; .#.#....
                    dc.b $50 ; .#.#....
                    dc.b $50 ; .#.#....
                    dc.b $50 ; .#.#....
                    dc.b $50 ; .#.#....
                    
LevelStructTile08   dc.b $55 ; .#.#.#.#           ; $08 - $a040
                    dc.b $55 ; .#.#.#.#
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelStructTile09   dc.b $ff ; ########           ; $09 - $a048
                    dc.b $ff ; ########
                    dc.b $ff ; ########
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelStructTile0a   dc.b $aa ; #.#.#.#.           ; $0a - $a050
                    dc.b $aa ; #.#.#.#.
                    dc.b $aa ; #.#.#.#.
                    dc.b $82 ; #.....#.
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelStructTile0b   dc.b $54 ; .#.#.#..           ; $0b - $a058
                    dc.b $54 ; .##..#..
                    dc.b $10 ; ...#....
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelStructTile0c   dc.b $50 ; .#.#....           ; $0c - $a060
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelStructTile0d   dc.b $aa ; #.#.#.#.           ; $0d - $a068
                    dc.b $aa ; #.#.#.#.
                    dc.b $aa ; #.#.#.#.
                    dc.b $aa ; #.#.#.#.
                    dc.b $aa ; #.#.#.#.
                    dc.b $aa ; #.#.#.#.
                    dc.b $aa ; #.#.#.#.
                    dc.b $aa ; #.#.#.#.
                    
LevelTileGroundNew2 dc.b $ff ; ########           ; $0e - $a070
                    dc.b $ff ; ########
                    dc.b $00 ; ........
                    dc.b $ff ; ########
                    dc.b $00 ; ........
                    dc.b $ff ; ########
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    
LevelStructTile0f   dc.b $00 ; ........           ; $0f - $a078
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
                    dc.b $00 ; ........
; -------------------------------------------------------------------------------------------------------------- ;
LevelTileNo_00      = (LevelStructTile00    - LevelStructureTiles) ; / $08 - $00
NoLvlTileGroundNew1 = (LevelTileGroundNew1  - LevelStructureTiles) ; / $08 - $08
NoLvlTileLadderLe   = (LevelTileLadderLe    - LevelStructureTiles) ; / $08 - $10
NoLvlTileLadderRi   = (LevelTileLadderRi    - LevelStructureTiles) ; / $08 - $18
LevelTileNo_04      = (LevelStructTile04    - LevelStructureTiles) ; / $08 - $20
NoLvlTileGroundThin = (LevelTileGroundThin  - LevelStructureTiles) ; / $08 - $28
NoLvlTileGroundFix  = (LevelTileGroundFix   - LevelStructureTiles) ; / $08 - $30
LevelTileNo_07      = (LevelStructTile07    - LevelStructureTiles) ; / $08 - $38
LevelTileNo_08      = (LevelStructTile08    - LevelStructureTiles) ; / $08 - $40
LevelTileNo_09      = (LevelStructTile09    - LevelStructureTiles) ; / $08 - $48
LevelTileNo_0a      = (LevelStructTile0a    - LevelStructureTiles) ; / $08 - $50
LevelTileNo_0b      = (LevelStructTile0b    - LevelStructureTiles) ; / $08 - $58
LevelTileNo_0c      = (LevelStructTile0c    - LevelStructureTiles) ; / $08 - $60
LevelTileNo_0d      = (LevelStructTile0d    - LevelStructureTiles) ; / $08 - $68
NoLvlTileGroundNew2 = (LevelTileGroundNew2  - LevelStructureTiles) ; / $08 - $70
LevelTileNo_0f      = (LevelStructTile0f    - LevelStructureTiles) ; / $08 - $78
; -------------------------------------------------------------------------------------------------------------- ;
LevelTileData       = $00     ; 
LevelTileDataLen      = $05   ; 
LevelTileCount      = $00     ; 
LevelTilePosX       = $01     ; 
LevelTilePosY       = $02     ; 
LevelTileDir        = $03     ; 
LevelTileDirMaskX     = $0f   ; 
LevelTileDirRiX         = $04 ; +4
LevelTileDirLeX         = $0f ; -1
LevelTileDirMaskY     = $f0   ; 
LevelTileDirNoY         = $00 ; +0
LevelTileDirUpY         = $f0 ; -1
LevelTileDirDoY         = $10 ; +1
LevelTileDirDoY8        = $80 ; +8
LevelTileDirRi        = LevelTileDirNoY + LevelTileDirRiX
LevelTileDirRiUp      = LevelTileDirUpY + LevelTileDirRiX
LevelTileDirRiDo      = LevelTileDirDoY + LevelTileDirRiX
LevelTileType       = $04     ; 
LevelTileTypeMaskGrnd = $80   ; #.......
LevelTileTypePlain      = $80 ; 2 varying tiles make a plain ground
LevelTileTypeDiag       = $00 ; 
LevelTileTypeMaskNo   = $78   ; .####...
LevelTileTypeMaskClr  = $07   ; .....###
LevelTileTypeClear00    = $00 ; 
LevelTileTypeClear01    = $01 ; 
LevelTileTypeClear02    = $02 ; 
LevelTileTypeClear03    = $03 ; 
LevelTileTypeClear04    = $04 ; 
LevelTileTypeClear05    = $05 ; 
LevelTileTypeClear06    = $06 ; 
LevelTileTypeClear07    = $07 ; 
; -------------------------------------------------------------------------------------------------------------- ;
LevelSlideData      = $00
LevelSlideDataLen     = $04
LevelSlideLength    = $00
LevelSlidePosX      = $01
LevelSlidePosY      = $02
LevelSlideDir       = $03
LevelSlideDirDo       = $00
LevelSlideDirRi       = $01
LevelSlideDirLe       = $ff
; -------------------------------------------------------------------------------------------------------------- ;
LevelLadderData     = $00
LevelLadderDataLen    = $03
LevelLadderPosX     = $00
LevelLadderPosYTop  = $01
LevelLadderPosYBot  = $02
; -------------------------------------------------------------------------------------------------------------- ;
