#!/usr/bin/env python
# -*- coding: utf-8 -*-
# TAPgen v0.1 - TAP file and loader generator by enthusi (onslaught)
# (c) Martin 'enthusi' Wendt 05/2012
# please credit any usage of this loader, enjoy :)
#not all SID files thatat init/play at $1000/$1003 will work, but most probably
import io
import sys
import os
from optparse import OptionParser
import base64

#CHANGE this line if you have to. Caution: the loader launches result at $80d (2061)
#'n2cload.bin' is generated on the fly and can be deleted afterwards
exomizer_command='exomizer sfx sys n2cload.bin -o n2cload.exo -q'

parser = OptionParser(usage="%prog -g game -k koala -s sid -t text -o outfile.tap", version="%prog 0.1")
parser.add_option("-g", "--gamefile", dest="game_filename",help="GAME file to load (exomized, $80d)", metavar="GAMEFILE")
parser.add_option("-k", "--koalafile", dest="koala_filename",help="10003 Bytes (bitmap,colmap,attrib,BGcol)", metavar="KOALAFILE")
parser.add_option("-s", "--sidfile", dest="sid_filename",help="SID file (.sid, init/play $1000/$1003)", metavar="SIDFILE")
parser.add_option("-t", "--textfile", dest="text_filename",help="Scrolltext file (plain ASCII)", metavar="SCROLLTEXTFILE")
parser.add_option("-o", "--outfile", dest="out_filename",help="TAP filename", metavar="TAPFILE")
(options, args) = parser.parse_args()
petscreen='''@abcdefghijklmnopqrstuvwxyz[~]^< !"#$%&'()*+,-./0123456789:;<=>?'''
ttloader=base64.b64decode("""SQOqeG4R0OYBqR2FAY4F3YYQqf6NBN2FAiDJA4bBIKUDqCClA5XC6OAD0PYgpQPGAZHBRRCFEOYB
yNAC5sLEw6XC5cSQ5iClA8UQ8AXuINBQ+6k3hQGpAI0g0EwNCKkBhb0gswMmvZD5pb1gqRAsDdzw
+60N3UipGY0O3WiNINBKYCCzAya9pb3JAtD1ogggpQPJAvD55L3Q6CClA8rQ9mA=""")
loader_bin=base64.b64decode("""AQgLCAAAnjIwNjEAAAB4qQCFAo0g0I0h0KkBjYYCIETlLhHQqR2FASC+CiCFCyD4CyBmCyB4DKkd
hQGiAKAAqQAgABB4qQCF8KkNhfGpAI0a0K0Z0I0Z0Kl/jQ3cjQ3dqZCNDdypkKIBjQbcjgfcrQ3c
rQ3dqauiCo36/477/6mtogmN/v+O//+pCIWjWKkAhcGFwoWLpYvJAvA3yQHwA0y4CK0S0Mn6MAzJ
/xAIIAMQqRiNFtBMlQitEtDJ+jAQyf8QDCADECDFCq33Co0W0EyVCKIAoAC9gAmdAASYnQDY6NDz
qQCNFdCpF40A3akUjRjQqYuNEdCpCI0W0KkAjRjUTAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAndl3lVVUldVV3V1XAAAAAAAA
////gAABgAABgAAB////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHipNIUBrQAgjQEI7gYE
0APuBwTuCQTQA+4KBK0HBMnw0OOpN4UBWCCE/0wNCI2qCo6mCoyoCq0N3KIZjg/cSkomvaW9psHw
H8ajpqPwA0yiCqIIhqOmweAB8BXgAvAt4APwQeAE8DrJAtAz5sFMogrJAvAqyVrwB6kAhcFMogrm
wamsogCFAoYDTKIKoACRAuYCpQLJsNAG5sFMogoBTKIKTKwKoAB4ohyGAZGsoh2GAVjmrNAC5q3u
INDOINDOsgrQU6kJjbIK7rEKrbEKyR7QBaIAjrEKSqq9qAyNJ9DOswrQMqmLjbMKrrQKrVgJHbUK
jVgJjVsJjV4J7rQKrbQKyQnQEakAjbQK7nMK7nYK7nkK7m0KpazFrqWt5a+QAubBrQ3cogCgAKkA
QOaLTKIKAAEBAACAwODw+Pz+/60RR41lCmCt9wo46QGQBI33CmApB433CqIAvQkGnQgG6OAo0PWg
ALHwyf/wDY0vBubwpfDQAubxYACpAI0h0OaLrXMKGGmAjXMKrXQKacKNdAqtdgoYaYCNdgqtdwpp
wo13Cq15ChhpgI15Cq16CmnCjXoKrXMKjW0KrXQKjW4Koj+9QAmdwMvKEPepL434zyDhC6kAjQDd
qbuNEdCpOI0Y0KkYjRbQYKkBjRXQqQGNJ9CpH40A0KnmjQHQqQCNENCpJY34B2CgH6IAvQAgnQDg
ytD37osL7o4LiNDuokC9AD+dAP/KEPegBKIAvUA/nQDMytD37qwL7q8LiNDuoASiAL0oQ50Ax6kA
nQDYytDy7sIL7sUL7soLiNDmrRBHjfkKYKAEogC9AMedANjK0Pfu5wvu6guI0O5geKkZqRCNGNCp
M4UBqQCohfup0IX8mIX9qQSF/qAAsfsYapH9yLH7GGqR/cix+5H9yLH7kf3IsfuR/cix+xgqkf3I
sfsYKpH9yLH7GCqR/cil+xhpCIX7pfxpAIX8pf0YaQiF/aX+aQCF/qX7yQjQDaX8ydKQB6kdqTeF
AWBMFAyiFKATvZQMnQjamQjayMrQ86mgnQgG6OAo0PhgCQIEDAMNAQEBAQEBAQEBAQEBAQEJAgQM
Aw0BAQ0DDAwCCQAABQ4UCBUTCS8PDhMMARUHCBQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA""")
core=base64.b64decode("""AAABAAIAAAEAAgAAAQACAAABAAIAAAEAAgAAAQACAAABAAIAAAEAAj4+Pz8+Pz8/Pj4+Pj8/Pz8+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""")
tap_filename=options.out_filename
game_filename=options.game_filename
koala_filename=options.koala_filename
sid_filename=options.sid_filename
text_filename=options.text_filename
print
print "TAPgen v0.1 by enthusi/onslaught"
print "================================"
print "game file to load : %s" % game_filename
print "loader pic (koa)  : %s" % koala_filename
print "loader tune (.sid): %s" % sid_filename
print "scrolltext in file: %s" % text_filename
print
if game_filename==None or tap_filename==None or koala_filename==None or sid_filename==None or text_filename==None:
  sys.exit('Too few arguments given. Use -h or --help for help! ')
if len(open(game_filename,'rb').read())>44032:
  print "ERROR"
  sys.exit("game size exceeds ~ 172 Blocks!")
if len(open(koala_filename,'rb').read())!=10003:
  print "ERROR"
  sys.exit("loader pic not in standard KOALA format (10003 Bytes)!")
if len(open(sid_filename,'rb').read())>4220:
  print "ERROR"
  sys.exit("SID file too long ($1000=4096 Bytes)!")
if len(open(text_filename,'rb').read())>760:
  print "ERROR"
  sys.exit("scrolltext way too long!")
if open(sid_filename,'rb').read()[:4]!='PSID':
  print "ERROR"
  sys.exit("SID file not in proper PSID format!")
tap_file=open(tap_filename,'wb')
BIT_s=47
BIT_m=65
BIT_l=85
BIT_0=26
BIT_1=40
IRQBIT_0=30
IRQBIT_1=70
tap_id_string="C64-TAPE-RAW";
tap_version=1;
tap_file.write("%s" % tap_id_string)
tap_file.write("%c" % tap_version)
tap_file.write("%c%c%c" % (0,0,0))
tap_file.write("%c%c%c%c" % (0,0,0,0))
def write_byte_irq(value):
    for i in reversed(range(8)):
        flag=((value) & (1<<(i)))
        if (flag):
            store=tap_file.write("%c" % IRQBIT_1)
        else:
            store=tap_file.write("%c" % IRQBIT_0)
def write_byte_tt(value):
    for i in reversed(range(8)):
        flag=((value) & (1<<(i)))
        if (flag):
            store=tap_file.write("%c" % BIT_1)
        else:
            store=tap_file.write("%c" % BIT_0)
def write_byte_cbm(value,end):
  parity=1
  for i in range(8):
    flag=((value) & (1<<(i)))
    parity^=(flag>0);
    if (flag):
        store=tap_file.write("%c" % BIT_m)
        store=tap_file.write("%c" % BIT_s)
    else:
        store=tap_file.write("%c" % BIT_s)
        store=tap_file.write("%c" % BIT_m)
  if (parity):
        store=tap_file.write("%c" % BIT_m)
        store=tap_file.write("%c" % BIT_s)
  else:
        store=tap_file.write("%c" % BIT_s)
        store=tap_file.write("%c" % BIT_m)
  if (end):
        store=tap_file.write("%c" % BIT_l)
        store=tap_file.write("%c" % BIT_s)
  else:
        store=tap_file.write("%c" % BIT_l)
        store=tap_file.write("%c" % BIT_m)
code_start=0x0349
load_start=0x0302
load_end=0x0304
#sync
for i in range(2048):
  tap_file.write("%c" % BIT_s)
  
tap_file.write("%c" % BIT_l)
tap_file.write("%c" % BIT_m)
sync=[0x89,0x88,0x87,0x86,0x85,0x84,0x83,0x82,0x81]
for i in sync:
  write_byte_cbm(i,0)
parity=0  
write_byte_cbm(0x03,0)  #3 is PRG id
parity^=0x03
write_byte_cbm(load_start&0xff,0)
parity^=load_start&0xff
write_byte_cbm(load_start>>8,0)
parity^=load_start>>8
write_byte_cbm(load_end&0xff,0)
parity^=load_end&0xff
write_byte_cbm(load_end>>8,0)
parity^=load_end>>8
filename=[0x93,0x05,0x11,0x20,0x4e,0x32,0x43,0x1f] #filename clr,codes, n2c
for i in filename:
  write_byte_cbm(i,0)
  parity^=i
for i in range(179): #187-ttload-filename (8)
  if i<(len(ttloader)-2):
    value=ord(ttloader[i+2])
    write_byte_cbm(value,0)
    parity^=value
  else:
    write_byte_cbm(0x20,0)
    parity^=0x20
write_byte_cbm(parity,1)
parity=0
for i in range(1024):
  tap_file.write("%c" % BIT_s)
tap_file.write("%c" % BIT_l)
tap_file.write("%c" % BIT_m)
sync=[0x09,0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01]
for i in sync:
  write_byte_cbm(i,0)
parity=0  
write_byte_cbm(0x03,0)  #3 is PRG id
parity^=0x03
write_byte_cbm(load_start&0xff,0)
parity^=load_start&0xff
write_byte_cbm(load_start>>8,0)
parity^=load_start>>8
write_byte_cbm(load_end&0xff,0)
parity^=load_end&0xff
write_byte_cbm(load_end>>8,0)
parity^=load_end>>8
filename=[0x93,0x05,0x11,0x20,0x4e,0x32,0x43,0x1f] #filename clr,codes, n2c
for i in filename:
  write_byte_cbm(i,0)
  parity^=i
for i in range(179): #187-ttload-filename (8)
  if i<(len(ttloader)-2):
    value=ord(ttloader[i+2])
    write_byte_cbm(value,0)
    parity^=value
  else:
    write_byte_cbm(0x20,0)
    parity^=0x20
write_byte_cbm(parity,1)
for i in range(5024):
  tap_file.write("%c" % BIT_s)
tap_file.write("%c" % BIT_l)
tap_file.write("%c" % BIT_m)
parity=0  
sync=[0x89,0x88,0x87,0x86,0x85,0x84,0x83,0x82,0x81]
for i in sync:
  write_byte_cbm(i,0)
write_byte_cbm(code_start&0xff,0)
parity^=code_start&0xff
write_byte_cbm(code_start>>8,0)
parity^=code_start>>8
write_byte_cbm(parity,1)
for i in range(5024):
  tap_file.write("%c" % BIT_s)
tap_file.write("%c" % BIT_l)
tap_file.write("%c" % BIT_m)
parity=0  
sync=[0x09,0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01]
for i in sync:
  write_byte_cbm(i,0)
write_byte_cbm(code_start&0xff,0)
parity^=code_start&0xff
write_byte_cbm(code_start>>8,0)
parity^=code_start>>8
write_byte_cbm(parity,1)
scroll_message=open(text_filename,'rb').read()
for i in range(len(scroll_message)):
  loader_bin+='%c' % (petscreen.index(scroll_message[i].lower())+0x80)
rest=0x1000-(0x801+0x501+i)
for i in range(rest+1):
  loader_bin+='%c' % 0xff
sid_data=open(sid_filename,'rb').read()[126:]
for i in sid_data:
  loader_bin+='%c' % i
rest=0x2000-(0x1000+len(sid_data))
for i in range(rest):
  loader_bin+='%c' % 0x00
koala_data=open(koala_filename,'rb').read()[2:]
for i in koala_data:
  loader_bin+='%c' % i
size=len(open(game_filename,'rb').read())-2
timing=int(size//(23*10))
loader_bin+='%c' % timing
irqloader_file=open('n2cload.bin','wb')
irqloader_file.write(loader_bin)
irqloader_file.close()
print 'packing...'
os.system(exomizer_command)
print 'writing "%s"' % tap_filename
tt_data=open('n2cload.exo','rb').read()
tt_start_lsb=ord(tt_data[0])
tt_start_msb=ord(tt_data[1])
tt_length=len(tt_data)-2
tt_end_lsb  =(tt_start_lsb + tt_start_msb*256+tt_length)&0xff
tt_end_msb  =(tt_start_lsb + tt_start_msb*256+tt_length)>>8
for i in range(256):
  write_byte_tt(2)
for i in reversed(range(1,9)):
  write_byte_tt(i)
write_byte_tt(0x02)
write_byte_tt(tt_start_lsb)
write_byte_tt(tt_start_msb)
write_byte_tt(tt_end_lsb)
write_byte_tt(tt_end_msb)
turbo_tape_compatible=0
if turbo_tape_compatible==1:
    write_byte_tt(0)
    for i in range(187):
      write_byte_tt(0x20)
    for i in range(256-1):
      write_byte_tt(2)
    for i in reversed(range(1,9)):
      write_byte_tt(i)
    write_byte_tt(0x00)
chksum=0x00
for i in range(tt_length):
  value=ord(tt_data[i+2])
  write_byte_tt(value)
  chksum=chksum^value
write_byte_tt(chksum)
offset=0x2000
irq_data=open(game_filename,'rb').read()
irq_start_lsb=offset&0xff
irq_start_msb=offset>>8
irq_length=len(irq_data)-2
irq_end_lsb  =(irq_start_lsb + irq_start_msb*256+irq_length)&0xff
irq_end_msb  =(irq_start_lsb + irq_start_msb*256+irq_length)>>8
for i in range(256):
  write_byte_irq(2)
write_byte_irq(0x5a)
write_byte_irq(irq_start_lsb)
write_byte_irq(irq_start_msb)
write_byte_irq(irq_end_lsb)
write_byte_irq(irq_end_msb)
for i in range(irq_length):
  value=ord(irq_data[i+2])
  write_byte_irq(value)
for i in core:
  tap_file.write("%c" % i)
tap_file.seek(0,2)
tap_len=tap_file.tell()-0x14
tap_file.seek(0x10,0)
tap_file.write("%c%c%c%c" % ((tap_len)&0xff,(tap_len>>8)&0xff,(tap_len>>16)&0xff,(tap_len>>24)&0xff))
print 'done!\n'
sys.exit(0)

