/*
 * Decompiled with CFR 0.152.
 */
package atari.cartridge.bankswitching;

import atari.cartridge.bankswitching.CartridgeBanked;

public final class Cartridge28K
extends CartridgeBanked {
    public static final int SIZE = 28672;
    public static final long serialVersionUID = 1L;

    public Cartridge28K(byte[] content) {
        super(content, true, 256);
        if (content.length != 28672) {
            throw new IllegalStateException("Invalid size for " + this.getClass().getName() + ": " + content.length);
        }
    }

    @Override
    protected int maskAddress(int address) {
        int add = super.maskAddress(address);
        switch (add) {
            case 4085: {
                this.bankAddressOffset = 0;
                break;
            }
            case 4086: {
                this.bankAddressOffset = 4096;
                break;
            }
            case 4087: {
                this.bankAddressOffset = 8192;
                break;
            }
            case 4088: {
                this.bankAddressOffset = 12288;
                break;
            }
            case 4089: {
                this.bankAddressOffset = 16384;
                break;
            }
            case 4090: {
                this.bankAddressOffset = 20480;
                break;
            }
            case 4091: {
                this.bankAddressOffset = 24576;
            }
        }
        return add;
    }
}

