/*
 * Decompiled with CFR 0.152.
 */
package atari.cartridge.bankswitching;

import atari.cartridge.Cartridge;

public class Cartridge8KSliced
extends Cartridge {
    private int slice0AddressOffset = 0;
    private int slice1AddressOffset = 0;
    private int slice2AddressOffset = 0;
    public static final int SIZE = 8192;
    public static final long serialVersionUID = 1L;

    public Cartridge8KSliced(byte[] content) {
        if (content.length != 8192) {
            throw new IllegalStateException("Invalid size for " + this.getClass().getName() + ": " + content.length);
        }
        this.setContent(content);
    }

    @Override
    public byte readByte(int address) {
        int add = this.maskAddress(address);
        add = add < 1024 ? (add += this.slice0AddressOffset) : (add < 2048 ? (add += this.slice1AddressOffset - 1024) : (add < 3072 ? (add += this.slice2AddressOffset - 2048) : (add += 4096)));
        return this.bytes[add];
    }

    @Override
    public void writeByte(int address, byte b) {
        this.maskAddress(address);
    }

    @Override
    protected int maskAddress(int address) {
        int add = super.maskAddress(address);
        switch (add) {
            case 4064: 
            case 4065: 
            case 4066: 
            case 4067: 
            case 4068: 
            case 4069: 
            case 4070: 
            case 4071: {
                this.slice0AddressOffset = (add - 4064) * 1024;
                break;
            }
            case 4072: 
            case 4073: 
            case 4074: 
            case 4075: 
            case 4076: 
            case 4077: 
            case 4078: 
            case 4079: {
                this.slice1AddressOffset = (add - 4072) * 1024;
                break;
            }
            case 4080: 
            case 4081: 
            case 4082: 
            case 4083: 
            case 4084: 
            case 4085: 
            case 4086: 
            case 4087: {
                this.slice2AddressOffset = (add - 4080) * 1024;
            }
        }
        return add;
    }
}

