/*
 * Decompiled with CFR 0.152.
 */
package atari.network.socket;

import atari.network.ClientConsole;
import atari.network.RemoteReceiver;
import atari.network.ServerUpdate;
import atari.network.socket.SocketRemoteTransmitter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.concurrent.ConcurrentLinkedQueue;
import parameters.Parameters;

public class SocketRemoteReceiver
implements RemoteReceiver {
    private ClientConsole console;
    private ConcurrentLinkedQueue<ServerUpdate> serverUpdates = new ConcurrentLinkedQueue();
    private UpdatesConsumer updatesConsumer;
    private UpdatesReceiver updatesReceiver;
    private OutputStream socketOutputStream;
    private InputStream socketInputStream;
    private ObjectOutputStream outputStream;
    private ObjectInputStream inputStream;
    private static final int MAX_UPDATES_PENDING = Parameters.CLIENT_MAX_UPDATES_PENDING;

    @Override
    public void clientConsole(ClientConsole console) {
        this.console = console;
    }

    public void connect(String server) throws UnknownHostException, IOException {
        Socket socket = new Socket(server, SocketRemoteTransmitter.SERVICE_PORT);
        socket.setTcpNoDelay(true);
        this.socketOutputStream = socket.getOutputStream();
        this.outputStream = new ObjectOutputStream(this.socketOutputStream);
        this.socketInputStream = socket.getInputStream();
        this.inputStream = new ObjectInputStream(this.socketInputStream);
        this.updatesReceiver = new UpdatesReceiver();
        this.updatesReceiver.start();
        this.updatesConsumer = new UpdatesConsumer();
        this.updatesConsumer.start();
        this.console.connected();
    }

    private void disconnect() {
        this.outputStream = null;
        this.inputStream = null;
        this.console.disconnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void receiveServerUpdate(ServerUpdate update) {
        ConcurrentLinkedQueue<ServerUpdate> concurrentLinkedQueue = this.serverUpdates;
        synchronized (concurrentLinkedQueue) {
            while (true) {
                if (this.serverUpdates.size() <= MAX_UPDATES_PENDING) {
                    this.serverUpdates.add(update);
                    this.serverUpdates.notifyAll();
                    return;
                }
                try {
                    this.serverUpdates.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public boolean askUserForConnection(String server) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private class UpdatesConsumer
    extends Thread {
        private UpdatesConsumer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (SocketRemoteReceiver.this.inputStream != null) {
                ServerUpdate update;
                block9: {
                    ConcurrentLinkedQueue concurrentLinkedQueue = SocketRemoteReceiver.this.serverUpdates;
                    synchronized (concurrentLinkedQueue) {
                        while (true) {
                            while (true) {
                                if ((update = (ServerUpdate)SocketRemoteReceiver.this.serverUpdates.poll()) != null) {
                                    SocketRemoteReceiver.this.serverUpdates.notifyAll();
                                    break block9;
                                }
                                try {
                                    SocketRemoteReceiver.this.serverUpdates.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            break;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                SocketRemoteReceiver.this.console.receiveServerUpdate(update);
                UpdatesConsumer.yield();
            }
        }
    }

    private class UpdatesReceiver
    extends Thread {
        private UpdatesReceiver() {
        }

        @Override
        public void run() {
            try {
                while (SocketRemoteReceiver.this.inputStream != null) {
                    ServerUpdate update = (ServerUpdate)SocketRemoteReceiver.this.inputStream.readObject();
                    SocketRemoteReceiver.this.outputStream.writeObject(SocketRemoteReceiver.this.console.controlChangesToSend());
                    SocketRemoteReceiver.this.outputStream.flush();
                    SocketRemoteReceiver.this.socketOutputStream.flush();
                    SocketRemoteReceiver.this.receiveServerUpdate(update);
                }
            }
            catch (IOException e) {
                SocketRemoteReceiver.this.disconnect();
            }
            catch (ClassNotFoundException e) {
                SocketRemoteReceiver.this.disconnect();
            }
        }
    }
}

