/*
 * Decompiled with CFR 0.152.
 */
package atari.network.socket;

import atari.network.RemoteTransmitter;
import atari.network.ServerConsole;
import atari.network.ServerUpdate;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JOptionPane;
import parameters.Parameters;

public class SocketRemoteTransmitter
implements RemoteTransmitter {
    private ServerConsole console;
    private ConcurrentLinkedQueue<ServerUpdate> updates = new ConcurrentLinkedQueue();
    private UpdatesSender updatesSender;
    private OutputStream socketOutputStream;
    private InputStream socketInputStream;
    private ObjectOutputStream outputStream;
    private ObjectInputStream inputStream;
    private static final int MAX_UPDATES_PENDING = Parameters.SERVER_MAX_UPDATES_PENDING;
    public static final String SERVICE_NAME = Parameters.SERVER_SERVICE_NAME;
    public static final int SERVICE_PORT = Parameters.SERVER_SERVICE_PORT;

    @Override
    public void serverConsole(ServerConsole console) {
        this.console = console;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sendUpdate(ServerUpdate update) {
        if (this.outputStream == null) {
            return;
        }
        ConcurrentLinkedQueue<ServerUpdate> concurrentLinkedQueue = this.updates;
        synchronized (concurrentLinkedQueue) {
            while (true) {
                if (this.updates.size() <= MAX_UPDATES_PENDING) {
                    this.updates.add(update);
                    this.updates.notifyAll();
                    return;
                }
                try {
                    this.updates.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean isClientConnected() {
        return this.outputStream != null;
    }

    public boolean listen() {
        try {
            ServerSocket serverSocket = new ServerSocket(SERVICE_PORT);
            this.connectReceiver(serverSocket.accept());
            serverSocket.close();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Server start failed: unable to open socket\n" + ex, "Atari P1 Server", 0);
            return false;
        }
        return true;
    }

    private void connectReceiver(Socket socket) throws IOException {
        socket.setTcpNoDelay(true);
        this.socketOutputStream = socket.getOutputStream();
        this.outputStream = new ObjectOutputStream(this.socketOutputStream);
        this.socketInputStream = socket.getInputStream();
        this.inputStream = new ObjectInputStream(this.socketInputStream);
        this.resetUpdatesPending();
        this.updatesSender = new UpdatesSender();
        this.updatesSender.start();
        this.console.clientConnected();
    }

    private void disconnectReceiver() {
        this.outputStream = null;
        this.inputStream = null;
        this.resetUpdatesPending();
        this.console.clientDisconnected();
        this.listen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetUpdatesPending() {
        ConcurrentLinkedQueue<ServerUpdate> concurrentLinkedQueue = this.updates;
        synchronized (concurrentLinkedQueue) {
            this.updates.clear();
            this.updates.notifyAll();
        }
    }

    private class UpdatesSender
    extends Thread {
        private UpdatesSender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    ServerUpdate update;
                    ConcurrentLinkedQueue concurrentLinkedQueue = SocketRemoteTransmitter.this.updates;
                    synchronized (concurrentLinkedQueue) {
                        while (true) {
                            if ((update = (ServerUpdate)SocketRemoteTransmitter.this.updates.poll()) != null) {
                                SocketRemoteTransmitter.this.updates.notifyAll();
                                break;
                            }
                            try {
                                SocketRemoteTransmitter.this.updates.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    if (SocketRemoteTransmitter.this.outputStream == null) continue;
                    SocketRemoteTransmitter.this.outputStream.writeObject(update);
                    SocketRemoteTransmitter.this.outputStream.flush();
                    SocketRemoteTransmitter.this.socketOutputStream.flush();
                    List clientControlChanges = (List)SocketRemoteTransmitter.this.inputStream.readObject();
                    if (clientControlChanges == null) continue;
                    SocketRemoteTransmitter.this.console.receiveClientControlChanges(clientControlChanges);
                }
            }
            catch (IOException e) {
                SocketRemoteTransmitter.this.disconnectReceiver();
                return;
            }
            catch (ClassNotFoundException e) {
                SocketRemoteTransmitter.this.disconnectReceiver();
            }
        }
    }
}

