/*
 * Decompiled with CFR 0.152.
 */
package atari.tia;

import atari.controls.ConsoleControls;
import atari.controls.ConsoleControlsInput;
import atari.pia.PIA;
import atari.tia.audio.AudioGenerator;
import atari.tia.audio.AudioMonoGenerator;
import atari.tia.video.NTSCPalette;
import atari.tia.video.PALPalette;
import atari.tia.video.VideoGenerator;
import general.av.video.VideoStandard;
import general.board.BUS16Bits;
import general.board.ClockDriven;
import general.m6502.M6502;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import parameters.Parameters;
import utils.Array2DCopy;

public final class TIA
implements BUS16Bits,
ClockDriven,
ConsoleControlsInput {
    private final VideoGenerator videoOutput;
    private final AudioGenerator audioOutput;
    private int clock = 0;
    private final M6502 cpu;
    private final PIA pia;
    private boolean powerOn = false;
    private final int[] debugPixels = new int[228];
    private int[] palette;
    private int vSyncColor = -2236963;
    private int vBlankColor = 0;
    private int hBlankColor = 0;
    private boolean debugPause = false;
    private int debugPauseMoreFrames = 0;
    private boolean debug = false;
    private int debugLevel = 0;
    private boolean debugNoCollisions = false;
    private int[] linePixels = new int[228];
    private int lastObservableChangeClock = -1;
    private boolean repeatLastLine;
    private boolean vSyncOn = false;
    private boolean vBlankOn = false;
    private VBlankDecode vBlankDecode = new VBlankDecode();
    private boolean hMoveHitBlank = false;
    private boolean[] playfieldPattern = new boolean[40];
    private boolean playfieldPatternInvalid = true;
    private boolean playfieldCurrentPixel = false;
    private int playfieldColor = -16777216;
    private int playfieldBackground = -16777216;
    private boolean playfieldReflected = false;
    private boolean playfieldScoreMode = false;
    private boolean playfieldPriority = false;
    private int playfieldDelayedChangeClock = -1;
    private int playfieldDelayedChangePart = -1;
    private int playfieldDelayedChangePattern = -1;
    private int player0ActiveSprite = 0;
    private int player0DelayedSprite = 0;
    private int player0Color = -16777216;
    private boolean player0RecentResetHit = false;
    private int player0Counter = 0;
    private int player0ScanStartCountdown = -1;
    private int player0ScanCounter = -1;
    private int player0ScanSpeed = 1;
    private int player0ScanSubCounter = 1;
    private boolean player0VerticalDelay = false;
    private boolean player0CloseCopy = false;
    private boolean player0MediumCopy = false;
    private boolean player0WideCopy = false;
    private boolean player0Reflected = false;
    private int player1ActiveSprite = 0;
    private int player1DelayedSprite = 0;
    private int player1Color = -16777216;
    private boolean player1RecentResetHit = false;
    private int player1Counter = 0;
    private int player1ScanStartCountdown = -1;
    private int player1ScanCounter = -1;
    private int player1ScanSpeed = 1;
    private int player1ScanSubCounter = 1;
    private boolean player1VerticalDelay = false;
    private boolean player1CloseCopy = false;
    private boolean player1MediumCopy = false;
    private boolean player1WideCopy = false;
    private boolean player1Reflected = false;
    private boolean missile0Enabled = false;
    private int missile0Color = -16777216;
    private boolean missile0RecentResetHit = false;
    private int missile0Counter = 0;
    private int missile0ScanCounter = -1;
    private int missile0ScanSpeed = 1;
    private int missile0ScanSubCounter = 1;
    private boolean missile0ResetToPlayer = false;
    private boolean missile1Enabled = false;
    private int missile1Color = -16777216;
    private boolean missile1RecentResetHit = false;
    private int missile1Counter = 0;
    private int missile1ScanCounter = -1;
    private int missile1ScanSpeed = 1;
    private int missile1ScanSubCounter = 1;
    private boolean missile1ResetToPlayer = false;
    private boolean ballEnabled = false;
    private boolean ballDelayedEnablement = false;
    private int ballColor = -16777216;
    private int ballCounter = 0;
    private int ballScanCounter = -1;
    private int ballScanSpeed = 1;
    private int ballScanSubCounter = 1;
    private boolean ballVerticalDelay = false;
    private int[][] playersDelayedSpriteChanges = new int[50][3];
    private int playersDelayedSpriteChangesCount = 0;
    private boolean controlsButtonsLatched = false;
    private boolean controlsJOY0ButtonPressed = false;
    private boolean controlsJOY1ButtonPressed = false;
    private boolean paddleCapacitorsGrounded = false;
    private int paddle0Position = -1;
    private int paddle0CapacitorCharge = 0;
    private int paddle1Position = -1;
    private int paddle1CapacitorCharge = 0;
    private int CXM0P;
    private int CXM1P;
    private int CXP0FB;
    private int CXP1FB;
    private int CXM0FB;
    private int CXM1FB;
    private int CXBLPF;
    private int CXPPMM;
    private int INPT0;
    private int INPT1;
    private int INPT2;
    private int INPT3;
    private int INPT4;
    private int INPT5;
    private int VSYNC;
    private int VBLANK;
    private int WSYNC;
    private int RSYNC;
    private int NUSIZ0;
    private int NUSIZ1;
    private int COLUP0;
    private int COLUP1;
    private int COLUPF;
    private int COLUBK;
    private int CTRLPF;
    private int REFP0;
    private int REFP1;
    private int PF0;
    private int PF1;
    private int PF2;
    private int RESP0;
    private int RESP1;
    private int RESM0;
    private int RESM1;
    private int RESBL;
    private int AUDC0;
    private int AUDC1;
    private int AUDF0;
    private int AUDF1;
    private int AUDV0;
    private int AUDV1;
    private int GRP0;
    private int GRP1;
    private int ENAM0;
    private int ENAM1;
    private int ENABL;
    private int HMP0;
    private int HMP1;
    private int HMM0;
    private int HMM1;
    private int HMBL;
    private int VDELP0;
    private int VDELP1;
    private int VDELBL;
    private int RESMP0;
    private int RESMP1;
    private int HMOVE;
    private int HMCLR;
    private int CXCLR;
    private static final int HBLANK_COLOR = 0;
    private static final int VBLANK_COLOR = 0;
    private static final int HBLANK_DURATION = 68;
    private static final int LINE_WIDTH = 228;
    private static final int DEBUG_MARKS_COLOR = -14671840;
    private static final int DEBUG_HBLANK_COLOR = -12303292;
    private static final int DEBUG_VBLANK_COLOR = -14013910;
    private static final int DEBUG_WSYNC_COLOR = -8978313;
    private static final int DEBUG_HMOVE_COLOR = -1;
    private static final int DEBUG_P0_COLOR = -16776961;
    private static final int DEBUG_P0_RES_COLOR = -14540101;
    private static final int DEBUG_P0_GR_COLOR = -15658633;
    private static final int DEBUG_P1_COLOR = -65536;
    private static final int DEBUG_P1_RES_COLOR = -4513246;
    private static final int DEBUG_P1_GR_COLOR = -8974063;
    private static final int DEBUG_M0_COLOR = -10066177;
    private static final int DEBUG_M1_COLOR = -39322;
    private static final int DEBUG_PF_COLOR = -12285884;
    private static final int DEBUG_BK_COLOR = -13421790;
    private static final int DEBUG_BL_COLOR = -256;
    private static final int DEBUG_SPECIAL_COLOR = -16711681;
    private static final int DEBUG_SPECIAL_COLOR2 = -16711936;
    private static final int READ_ADDRESS_MASK = 15;
    private static final int WRITE_ADDRESS_MASK = 63;
    private static final int PLAYERS_DELAYED_SPRITE_GHANGES_MAX_COUNT = 50;
    private static final boolean SYNC_WITH_AUDIO_MONITOR = Parameters.TIA_SYNC_WITH_AUDIO_MONITOR;
    private static final boolean SYNC_WITH_VIDEO_MONITOR = Parameters.TIA_SYNC_WITH_VIDEO_MONITOR;
    private static final double FORCED_CLOCK = Parameters.TIA_FORCED_CLOCK;
    public static final double DEFAUL_CLOCK_NTSC = Parameters.TIA_DEFAULT_CLOCK_NTSC;
    public static final double DEFAUL_CLOCK_PAL = Parameters.TIA_DEFAULT_CLOCK_PAL;

    public TIA(M6502 cpu, PIA pia) {
        this.cpu = cpu;
        this.pia = pia;
        this.videoOutput = new VideoGenerator();
        this.audioOutput = new AudioMonoGenerator();
    }

    public VideoGenerator videoOutput() {
        return this.videoOutput;
    }

    public AudioGenerator audioOutput() {
        return this.audioOutput;
    }

    public void videoStandard(VideoStandard standard) {
        this.videoOutput.standard = standard;
        this.palette = standard.equals((Object)VideoStandard.NTSC) ? NTSCPalette.getPalette() : PALPalette.getPalette();
    }

    public double desiredClockForVideoStandard() {
        if (FORCED_CLOCK != 0.0) {
            return FORCED_CLOCK;
        }
        return this.videoOutput.standard().equals((Object)VideoStandard.NTSC) ? DEFAUL_CLOCK_NTSC : DEFAUL_CLOCK_PAL;
    }

    public void powerOn() {
        Arrays.fill(this.linePixels, 0);
        Arrays.fill(this.debugPixels, 0);
        this.initLatchesAtPowerOn();
        this.observableChange();
        this.powerOn = true;
    }

    public void powerOff() {
        this.powerOn = false;
        this.videoOutput.newLine(null, false);
    }

    @Override
    public void clockPulse() {
        if (!this.powerOn || this.debugPaused()) {
            return;
        }
        boolean videoOutputVSynched = false;
        do {
            this.cpu.RDY = true;
            this.clock = 3;
            while (this.clock < 68) {
                if (this.clock == this.lastObservableChangeClock) {
                    this.repeatLastLine = true;
                    this.lastObservableChangeClock = -1;
                }
                this.pia.clockPulse();
                this.cpu.clockPulse();
                this.clock += 3;
            }
            this.audioOutput.generateNextSamples(1);
            this.clock = 68;
            while (this.clock < 228) {
                if (this.vBlankDecode.isActive) {
                    this.vBlankDecode.clockPulse();
                }
                if (this.clock == this.lastObservableChangeClock) {
                    this.repeatLastLine = true;
                    this.lastObservableChangeClock = -1;
                }
                if (this.clock % 3 == 0) {
                    this.pia.clockPulse();
                    this.cpu.clockPulse();
                }
                this.objectsTriggerScanCounters();
                if (!this.repeatLastLine) {
                    this.setPixelValue();
                }
                this.objectsIncrementCounters();
                ++this.clock;
            }
            this.clock = 0;
            this.pia.clockPulse();
            this.cpu.clockPulse();
            if (!this.paddleCapacitorsGrounded && this.paddle0Position != -1) {
                this.chargePaddleCapacitors();
            }
            this.adjustLineAtEnd();
            videoOutputVSynched = this.videoOutput.newLine(this.linePixels, this.vSyncOn);
            this.audioOutput.generateNextSamples(1);
        } while (!videoOutputVSynched && this.powerOn);
        if (this.powerOn) {
            this.audioOutput.sendGeneratedSamplesToMonitor();
            if (SYNC_WITH_AUDIO_MONITOR) {
                this.audioOutput.monitor.synchOutput();
            }
            if (SYNC_WITH_VIDEO_MONITOR) {
                this.videoOutput.monitor.synchOutput();
            }
        }
    }

    private boolean debugPaused() {
        if (!this.debugPause) {
            return false;
        }
        if (this.debugPauseMoreFrames <= 0) {
            return true;
        }
        --this.debugPauseMoreFrames;
        return false;
    }

    private void setPixelValue() {
        int sprite;
        if (this.clock % 4 == 0 || this.clock == this.lastObservableChangeClock) {
            this.playfieldUpdateCurrentPixel();
        }
        if (this.vBlankOn) {
            this.linePixels[this.clock] = this.vSyncOn ? this.vSyncColor : this.vBlankColor;
            return;
        }
        int color = -1;
        boolean P0 = false;
        boolean P1 = false;
        boolean M0 = false;
        boolean M1 = false;
        boolean FL = false;
        boolean BL = false;
        if (this.playfieldPriority) {
            if (this.ballScanCounter == 0) {
                this.playersPerformDelayedSpriteChanges();
                if (this.ballEnabled) {
                    BL = true;
                    color = this.ballColor;
                }
            }
            if (this.playfieldCurrentPixel) {
                FL = true;
                if (color == -1) {
                    int n = !this.playfieldScoreMode ? this.playfieldColor : (color = this.clock < 148 ? this.player0Color : this.player1Color);
                }
            }
        }
        if (this.player0ScanCounter >= 0) {
            this.playersPerformDelayedSpriteChanges();
            int n = sprite = this.player0VerticalDelay ? this.player0ActiveSprite : this.player0DelayedSprite;
            if (sprite != 0 && (sprite >> (this.player0Reflected ? 7 - this.player0ScanCounter : this.player0ScanCounter) & 1) != 0) {
                P0 = true;
                if (color == -1) {
                    color = this.player0Color;
                }
            }
        }
        if (this.missile0ScanCounter == 0 && this.missile0Enabled && !this.missile0ResetToPlayer) {
            M0 = true;
            if (color == -1) {
                color = this.missile0Color;
            }
        }
        if (this.player1ScanCounter >= 0) {
            this.playersPerformDelayedSpriteChanges();
            int n = sprite = this.player1VerticalDelay ? this.player1ActiveSprite : this.player1DelayedSprite;
            if (sprite != 0 && (sprite >> (this.player1Reflected ? 7 - this.player1ScanCounter : this.player1ScanCounter) & 1) != 0) {
                P1 = true;
                if (color == -1) {
                    color = this.player1Color;
                }
            }
        }
        if (this.missile1ScanCounter == 0 && this.missile1Enabled && !this.missile1ResetToPlayer) {
            M1 = true;
            if (color == -1) {
                color = this.missile1Color;
            }
        }
        if (!this.playfieldPriority) {
            if (this.ballScanCounter == 0) {
                this.playersPerformDelayedSpriteChanges();
                if (this.ballEnabled) {
                    BL = true;
                    if (color == -1) {
                        color = this.ballColor;
                    }
                }
            }
            if (this.playfieldCurrentPixel) {
                FL = true;
                if (color == -1) {
                    int n = !this.playfieldScoreMode ? this.playfieldColor : (color = this.clock < 148 ? this.player0Color : this.player1Color);
                }
            }
        }
        if (color == -1) {
            color = this.playfieldBackground;
        }
        this.linePixels[this.clock] = color;
        if (this.debugNoCollisions) {
            return;
        }
        if (P0 && FL) {
            this.CXP0FB |= 0x80;
        }
        if (P1) {
            if (FL) {
                this.CXP1FB |= 0x80;
            }
            if (P0) {
                this.CXPPMM |= 0x80;
            }
        }
        if (BL) {
            if (FL) {
                this.CXBLPF |= 0x80;
            }
            if (P0) {
                this.CXP0FB |= 0x40;
            }
            if (P1) {
                this.CXP1FB |= 0x40;
            }
        }
        if (M0) {
            if (P1) {
                this.CXM0P |= 0x80;
            }
            if (P0) {
                this.CXM0P |= 0x40;
            }
            if (FL) {
                this.CXM0FB |= 0x80;
            }
            if (BL) {
                this.CXM0FB |= 0x40;
            }
        }
        if (M1) {
            if (P0) {
                this.CXM1P |= 0x80;
            }
            if (P1) {
                this.CXM1P |= 0x40;
            }
            if (FL) {
                this.CXM1FB |= 0x80;
            }
            if (BL) {
                this.CXM1FB |= 0x40;
            }
            if (M0) {
                this.CXPPMM |= 0x40;
            }
        }
    }

    private void playfieldUpdateCurrentPixel() {
        this.playfieldPerformDelayedSpriteChange(false);
        if (this.playfieldPatternInvalid) {
            int i;
            int s;
            if (this.PF0 == 0 && this.PF1 == 0 && this.PF2 == 0) {
                Arrays.fill(this.playfieldPattern, false);
                this.playfieldPatternInvalid = false;
                this.playfieldCurrentPixel = false;
                return;
            }
            if (this.playfieldReflected) {
                s = 40;
                i = -1;
            } else {
                s = 19;
                i = 1;
            }
            boolean bl = (this.PF0 & 0x10) != 0;
            this.playfieldPattern[s += i] = bl;
            this.playfieldPattern[0] = bl;
            boolean bl2 = (this.PF0 & 0x20) != 0;
            this.playfieldPattern[s += i] = bl2;
            this.playfieldPattern[1] = bl2;
            boolean bl3 = (this.PF0 & 0x40) != 0;
            this.playfieldPattern[s += i] = bl3;
            this.playfieldPattern[2] = bl3;
            boolean bl4 = (this.PF0 & 0x80) != 0;
            this.playfieldPattern[s += i] = bl4;
            this.playfieldPattern[3] = bl4;
            boolean bl5 = (this.PF1 & 0x80) != 0;
            this.playfieldPattern[s += i] = bl5;
            this.playfieldPattern[4] = bl5;
            boolean bl6 = (this.PF1 & 0x40) != 0;
            this.playfieldPattern[s += i] = bl6;
            this.playfieldPattern[5] = bl6;
            boolean bl7 = (this.PF1 & 0x20) != 0;
            this.playfieldPattern[s += i] = bl7;
            this.playfieldPattern[6] = bl7;
            boolean bl8 = (this.PF1 & 0x10) != 0;
            this.playfieldPattern[s += i] = bl8;
            this.playfieldPattern[7] = bl8;
            boolean bl9 = (this.PF1 & 8) != 0;
            this.playfieldPattern[s += i] = bl9;
            this.playfieldPattern[8] = bl9;
            boolean bl10 = (this.PF1 & 4) != 0;
            this.playfieldPattern[s += i] = bl10;
            this.playfieldPattern[9] = bl10;
            boolean bl11 = (this.PF1 & 2) != 0;
            this.playfieldPattern[s += i] = bl11;
            this.playfieldPattern[10] = bl11;
            boolean bl12 = (this.PF1 & 1) != 0;
            this.playfieldPattern[s += i] = bl12;
            this.playfieldPattern[11] = bl12;
            boolean bl13 = (this.PF2 & 1) != 0;
            this.playfieldPattern[s += i] = bl13;
            this.playfieldPattern[12] = bl13;
            boolean bl14 = (this.PF2 & 2) != 0;
            this.playfieldPattern[s += i] = bl14;
            this.playfieldPattern[13] = bl14;
            boolean bl15 = (this.PF2 & 4) != 0;
            this.playfieldPattern[s += i] = bl15;
            this.playfieldPattern[14] = bl15;
            boolean bl16 = (this.PF2 & 8) != 0;
            this.playfieldPattern[s += i] = bl16;
            this.playfieldPattern[15] = bl16;
            boolean bl17 = (this.PF2 & 0x10) != 0;
            this.playfieldPattern[s += i] = bl17;
            this.playfieldPattern[16] = bl17;
            boolean bl18 = (this.PF2 & 0x20) != 0;
            this.playfieldPattern[s += i] = bl18;
            this.playfieldPattern[17] = bl18;
            boolean bl19 = (this.PF2 & 0x40) != 0;
            this.playfieldPattern[s += i] = bl19;
            this.playfieldPattern[18] = bl19;
            boolean bl20 = (this.PF2 & 0x80) != 0;
            this.playfieldPattern[s += i] = bl20;
            this.playfieldPattern[19] = bl20;
            this.playfieldPatternInvalid = false;
        }
        this.playfieldCurrentPixel = this.playfieldPattern[(this.clock - 68) / 4 % 40];
    }

    private void playfieldDelaySpriteChange(int part, int sprite) {
        this.observableChange();
        this.playfieldPerformDelayedSpriteChange(true);
        this.playfieldDelayedChangeClock = this.clock;
        this.playfieldDelayedChangePart = part;
        this.playfieldDelayedChangePattern = sprite;
        if (this.debug) {
            this.debugPixel(-16711936);
        }
    }

    private void playfieldPerformDelayedSpriteChange(boolean force) {
        int dif;
        if (this.playfieldDelayedChangePart == -1) {
            return;
        }
        if (!force && (dif = this.clock - this.playfieldDelayedChangeClock) >= 0 && dif <= 1) {
            return;
        }
        switch (this.playfieldDelayedChangePart) {
            case 0: {
                this.PF0 = this.playfieldDelayedChangePattern;
                break;
            }
            case 1: {
                this.PF1 = this.playfieldDelayedChangePattern;
                break;
            }
            case 2: {
                this.PF2 = this.playfieldDelayedChangePattern;
            }
        }
        this.playfieldPatternInvalid = true;
        this.playfieldDelayedChangePart = -1;
    }

    private void playfieldAndBallSetShape(int shape) {
        boolean reflect;
        this.observableChange();
        boolean bl = reflect = (shape & 1) != 0;
        if (this.playfieldReflected != reflect) {
            this.playfieldReflected = reflect;
            this.playfieldPatternInvalid = true;
        }
        this.playfieldScoreMode = (shape & 2) != 0;
        this.playfieldPriority = (shape & 4) != 0;
        switch (shape & 0x30) {
            case 0: {
                this.ballScanSpeed = 1;
                break;
            }
            case 16: {
                this.ballScanSpeed = 2;
                break;
            }
            case 32: {
                this.ballScanSpeed = 4;
                break;
            }
            case 48: {
                this.ballScanSpeed = 8;
            }
        }
    }

    private void objectsTriggerScanCounters() {
        switch (this.player0Counter) {
            case 156: {
                if (this.player0RecentResetHit) {
                    this.player0RecentResetHit = false;
                    break;
                }
                this.player0ScanStartCountdown = this.player0ScanSpeed == 1 ? 5 : 6;
                break;
            }
            case 12: {
                if (!this.player0CloseCopy) break;
                this.player0ScanStartCountdown = 5;
                break;
            }
            case 28: {
                if (!this.player0MediumCopy) break;
                this.player0ScanStartCountdown = 5;
                break;
            }
            case 60: {
                if (!this.player0WideCopy) break;
                this.player0ScanStartCountdown = 5;
            }
        }
        if (this.player0ScanStartCountdown >= 0 && --this.player0ScanStartCountdown < 0) {
            this.player0ScanCounter = 7;
            this.player0ScanSubCounter = this.player0ScanSpeed;
        }
        switch (this.player1Counter) {
            case 156: {
                if (this.player1RecentResetHit) {
                    this.player1RecentResetHit = false;
                    break;
                }
                this.player1ScanStartCountdown = this.player1ScanSpeed == 1 ? 5 : 6;
                break;
            }
            case 12: {
                if (!this.player1CloseCopy) break;
                this.player1ScanStartCountdown = 5;
                break;
            }
            case 28: {
                if (!this.player1MediumCopy) break;
                this.player1ScanStartCountdown = 5;
                break;
            }
            case 60: {
                if (!this.player1WideCopy) break;
                this.player1ScanStartCountdown = 5;
            }
        }
        if (this.player1ScanStartCountdown >= 0 && --this.player1ScanStartCountdown < 0) {
            this.player1ScanCounter = 7;
            this.player1ScanSubCounter = this.player1ScanSpeed;
        }
        switch (this.missile0Counter) {
            case 0: {
                if (this.missile0RecentResetHit) {
                    this.missile0RecentResetHit = false;
                    break;
                }
                this.missile0ScanCounter = 0;
                this.missile0ScanSubCounter = this.missile0ScanSpeed;
                break;
            }
            case 16: {
                if (!this.player0CloseCopy) break;
                this.missile0ScanCounter = 0;
                this.missile0ScanSubCounter = this.missile0ScanSpeed;
                break;
            }
            case 32: {
                if (!this.player0MediumCopy) break;
                this.missile0ScanCounter = 0;
                this.missile0ScanSubCounter = this.missile0ScanSpeed;
                break;
            }
            case 64: {
                if (!this.player0WideCopy) break;
                this.missile0ScanCounter = 0;
                this.missile0ScanSubCounter = this.missile0ScanSpeed;
            }
        }
        switch (this.missile1Counter) {
            case 0: {
                if (this.missile1RecentResetHit) {
                    this.missile1RecentResetHit = false;
                    break;
                }
                this.missile1ScanCounter = 0;
                this.missile1ScanSubCounter = this.missile1ScanSpeed;
                break;
            }
            case 16: {
                if (!this.player1CloseCopy) break;
                this.missile1ScanCounter = 0;
                this.missile1ScanSubCounter = this.missile1ScanSpeed;
                break;
            }
            case 32: {
                if (!this.player1MediumCopy) break;
                this.missile1ScanCounter = 0;
                this.missile1ScanSubCounter = this.missile1ScanSpeed;
                break;
            }
            case 64: {
                if (!this.player1WideCopy) break;
                this.missile1ScanCounter = 0;
                this.missile1ScanSubCounter = this.missile1ScanSpeed;
            }
        }
        if (this.ballCounter == 0) {
            this.ballScanCounter = 0;
            this.ballScanSubCounter = this.ballScanSpeed;
        }
    }

    private void objectsIncrementCounters() {
        if (++this.player0Counter == 160) {
            this.player0Counter = 0;
        }
        if (this.player0ScanCounter >= 0) {
            if (this.player0ScanCounter == 7 && this.missile0ResetToPlayer && this.player0Counter < 12) {
                this.missile0Counter = 156;
            }
            if (this.player0ScanSpeed == 1) {
                --this.player0ScanCounter;
            } else if (--this.player0ScanSubCounter == 0) {
                --this.player0ScanCounter;
                this.player0ScanSubCounter = this.player0ScanSpeed;
            }
        }
        if (++this.player1Counter == 160) {
            this.player1Counter = 0;
        }
        if (this.player1ScanCounter >= 0) {
            if (this.player1ScanCounter == 7 && this.missile1ResetToPlayer && this.player1Counter < 12) {
                this.missile1Counter = 156;
            }
            if (this.player1ScanSpeed == 1) {
                --this.player1ScanCounter;
            } else if (--this.player1ScanSubCounter == 0) {
                --this.player1ScanCounter;
                this.player1ScanSubCounter = this.player1ScanSpeed;
            }
        }
        if (++this.missile0Counter == 160) {
            this.missile0Counter = 0;
        }
        if (this.missile0ScanCounter >= 0) {
            if (this.missile0ScanSpeed == 1) {
                --this.missile0ScanCounter;
            } else if (--this.missile0ScanSubCounter == 0) {
                --this.missile0ScanCounter;
                this.missile0ScanSubCounter = this.missile0ScanSpeed;
            }
        }
        if (++this.missile1Counter == 160) {
            this.missile1Counter = 0;
        }
        if (this.missile1ScanCounter >= 0) {
            if (this.missile1ScanSpeed == 1) {
                --this.missile1ScanCounter;
            } else if (--this.missile1ScanSubCounter == 0) {
                --this.missile1ScanCounter;
                this.missile1ScanSubCounter = this.missile1ScanSpeed;
            }
        }
        if (++this.ballCounter == 160) {
            this.ballCounter = 0;
        }
        if (this.ballScanCounter >= 0) {
            if (this.ballScanSpeed == 1) {
                --this.ballScanCounter;
            } else if (--this.ballScanSubCounter == 0) {
                --this.ballScanCounter;
                this.ballScanSubCounter = this.ballScanSpeed;
            }
        }
    }

    private void adjustLineAtEnd() {
        if (this.hMoveHitBlank) {
            this.linePixels[74] = this.linePixels[75] = this.hBlankColor;
            this.linePixels[73] = this.linePixels[75];
            this.linePixels[72] = this.linePixels[75];
            this.linePixels[71] = this.linePixels[75];
            this.linePixels[70] = this.linePixels[75];
            this.linePixels[69] = this.linePixels[75];
            this.linePixels[68] = this.linePixels[75];
            this.hMoveHitBlank = false;
        }
        if (this.debugLevel >= 2) {
            this.processDebugPixelsInLine();
        }
    }

    private void observableChange() {
        this.lastObservableChangeClock = this.clock;
        this.repeatLastLine = false;
    }

    private void playerDelaySpriteChange(int player, int sprite) {
        this.observableChange();
        if (this.debug) {
            this.debugPixel(player == 0 ? -15658633 : -8974063);
        }
        if (this.playersDelayedSpriteChangesCount >= 50) {
            this.debugInfo(">>> Max player delayed changes reached: 50");
            return;
        }
        this.playersDelayedSpriteChanges[this.playersDelayedSpriteChangesCount][0] = this.clock;
        this.playersDelayedSpriteChanges[this.playersDelayedSpriteChangesCount][1] = player;
        this.playersDelayedSpriteChanges[this.playersDelayedSpriteChangesCount][2] = sprite;
        ++this.playersDelayedSpriteChangesCount;
    }

    private void playersPerformDelayedSpriteChanges() {
        if (this.playersDelayedSpriteChangesCount == 0 || this.playersDelayedSpriteChanges[0][0] == this.clock) {
            return;
        }
        int i = 0;
        while (i < this.playersDelayedSpriteChangesCount) {
            int[] change = this.playersDelayedSpriteChanges[i];
            switch (change[1]) {
                case 0: {
                    this.player0DelayedSprite = change[2];
                    this.player1ActiveSprite = this.player1DelayedSprite;
                    break;
                }
                case 1: {
                    this.player1DelayedSprite = change[2];
                    this.player0ActiveSprite = this.player0DelayedSprite;
                    this.ballEnabled = this.ballDelayedEnablement;
                }
            }
            ++i;
        }
        this.playersDelayedSpriteChangesCount = 0;
    }

    private void ballSetGraphic(int value) {
        this.observableChange();
        boolean bl = this.ballDelayedEnablement = (value & 2) != 0;
        if (!this.ballVerticalDelay) {
            this.ballEnabled = this.ballDelayedEnablement;
        }
    }

    private void player0SetShape(int shape) {
        this.observableChange();
        switch (shape & 0x30) {
            case 0: {
                this.missile0ScanSpeed = 1;
                break;
            }
            case 16: {
                this.missile0ScanSpeed = 2;
                break;
            }
            case 32: {
                this.missile0ScanSpeed = 4;
                break;
            }
            case 48: {
                this.missile0ScanSpeed = 8;
            }
        }
        if ((shape & 7) == 5) {
            this.player0ScanSpeed = 2;
            this.player0ScanSubCounter = 2;
            this.player0WideCopy = false;
            this.player0MediumCopy = false;
            this.player0CloseCopy = false;
            return;
        }
        if ((shape & 7) == 7) {
            this.player0ScanSpeed = 4;
            this.player0ScanSubCounter = 4;
            this.player0WideCopy = false;
            this.player0MediumCopy = false;
            this.player0CloseCopy = false;
            return;
        }
        this.player0ScanSpeed = 1;
        this.player0ScanSubCounter = 1;
        this.player0CloseCopy = (shape & 1) != 0;
        this.player0MediumCopy = (shape & 2) != 0;
        this.player0WideCopy = (shape & 4) != 0;
    }

    private void player1SetShape(int shape) {
        this.observableChange();
        switch (shape & 0x30) {
            case 0: {
                this.missile1ScanSpeed = 1;
                break;
            }
            case 16: {
                this.missile1ScanSpeed = 2;
                break;
            }
            case 32: {
                this.missile1ScanSpeed = 4;
                break;
            }
            case 48: {
                this.missile1ScanSpeed = 8;
            }
        }
        if ((shape & 7) == 5) {
            this.player1ScanSpeed = 2;
            this.player1ScanSubCounter = 2;
            this.player1WideCopy = false;
            this.player1MediumCopy = false;
            this.player1CloseCopy = false;
            return;
        }
        if ((shape & 7) == 7) {
            this.player1ScanSpeed = 4;
            this.player1ScanSubCounter = 4;
            this.player1WideCopy = false;
            this.player1MediumCopy = false;
            this.player1CloseCopy = false;
            return;
        }
        this.player1ScanSpeed = 1;
        this.player1ScanSubCounter = 1;
        this.player1CloseCopy = (shape & 1) != 0;
        this.player1MediumCopy = (shape & 2) != 0;
        this.player1WideCopy = (shape & 4) != 0;
    }

    private void hitHMOVE() {
        int add;
        if (this.clock >= 68 && this.clock < 210) {
            return;
        }
        boolean bl = this.hMoveHitBlank = this.clock < 68;
        if (this.debug) {
            this.debugPixel(-1);
        }
        boolean inv = false;
        int n = add = this.hMoveHitBlank ? this.HMP0 : this.HMP0 + 8;
        if (add != 0) {
            this.player0Counter += add;
            if (this.player0Counter > 159) {
                this.player0Counter -= 160;
            }
            inv = true;
        }
        int n2 = add = this.hMoveHitBlank ? this.HMM0 : this.HMM0 + 8;
        if (add != 0) {
            this.missile0Counter += add;
            if (this.missile0Counter > 159) {
                this.missile0Counter -= 160;
            }
            inv = true;
        }
        int n3 = add = this.hMoveHitBlank ? this.HMP1 : this.HMP1 + 8;
        if (add != 0) {
            this.player1Counter += add;
            if (this.player1Counter > 159) {
                this.player1Counter -= 160;
            }
            inv = true;
        }
        int n4 = add = this.hMoveHitBlank ? this.HMM1 : this.HMM1 + 8;
        if (add != 0) {
            this.missile1Counter += add;
            if (this.missile1Counter > 159) {
                this.missile1Counter -= 160;
            }
            inv = true;
        }
        int n5 = add = this.hMoveHitBlank ? this.HMBL : this.HMBL + 8;
        if (add != 0) {
            this.ballCounter += add;
            if (this.ballCounter > 159) {
                this.ballCounter -= 160;
            }
            inv = true;
        }
        if (inv) {
            this.observableChange();
        }
    }

    private void hitRESP0() {
        this.observableChange();
        this.player0RecentResetHit = this.player0Counter != 156;
        int n = this.player0Counter = this.clock < 68 ? 158 : 156;
        if (this.debug) {
            this.debugPixel(-14540101);
        }
    }

    private void hitRESP1() {
        this.observableChange();
        this.player1RecentResetHit = this.player1Counter != 156;
        int n = this.player1Counter = this.clock < 68 ? 158 : 156;
        if (this.debug) {
            this.debugPixel(-4513246);
        }
    }

    private void hitRESM0() {
        this.observableChange();
        this.missile0Counter = this.clock < 68 ? 158 : 156;
        this.missile0RecentResetHit = true;
        if (this.debug) {
            this.debugPixel(-10066177);
        }
    }

    private void hitRESM1() {
        this.observableChange();
        this.missile1Counter = this.clock < 68 ? 158 : 156;
        this.missile1RecentResetHit = true;
        if (this.debug) {
            this.debugPixel(-39322);
        }
    }

    private void hitRESBL() {
        this.observableChange();
        int n = this.ballCounter = this.clock < 68 ? 158 : 156;
        if (this.debug) {
            this.debugPixel(-256);
        }
    }

    private void missile0SetResetToPlayer(int res) {
        this.observableChange();
        this.missile0ResetToPlayer = (res & 2) != 0;
        if (this.missile0ResetToPlayer) {
            this.missile0Enabled = false;
        }
    }

    private void missile1SetResetToPlayer(int res) {
        this.observableChange();
        this.missile1ResetToPlayer = (res & 2) != 0;
        if (this.missile1ResetToPlayer) {
            this.missile1Enabled = false;
        }
    }

    private void vBlankSet(int blank) {
        this.observableChange();
        this.vBlankDecode.start((blank & 2) != 0);
        if ((blank & 0x40) != 0) {
            this.controlsButtonsLatched = true;
        } else {
            this.controlsButtonsLatched = false;
            this.INPT4 = this.controlsJOY0ButtonPressed ? (this.INPT4 &= 0x7F) : (this.INPT4 |= 0x80);
            this.INPT5 = this.controlsJOY1ButtonPressed ? (this.INPT5 &= 0x7F) : (this.INPT5 |= 0x80);
        }
        if ((blank & 0x80) != 0) {
            this.paddleCapacitorsGrounded = true;
            this.paddle1CapacitorCharge = 0;
            this.paddle0CapacitorCharge = 0;
            this.INPT0 &= 0x7F;
            this.INPT1 &= 0x7F;
            this.INPT2 &= 0x7F;
            this.INPT3 &= 0x7F;
        } else {
            this.paddleCapacitorsGrounded = false;
        }
    }

    private void debug(int level) {
        this.debugLevel = level > 4 ? 0 : level;
        this.cpu.debug = this.debug = this.debugLevel != 0;
        this.pia.debug = this.debug;
        this.hBlankColor = this.debugLevel >= 2 ? -12303292 : 0;
        int n = this.vBlankColor = this.debugLevel >= 2 ? -14013910 : 0;
        if (this.debug) {
            this.debugSetColors();
        } else {
            Arrays.fill(this.linePixels, this.hBlankColor);
            this.observableChange();
        }
    }

    private void debugSetColors() {
        this.player0Color = -16776961;
        this.player1Color = -65536;
        this.missile0Color = -10066177;
        this.missile1Color = -39322;
        this.ballColor = -256;
        this.playfieldColor = -12285884;
        this.playfieldBackground = -13421790;
    }

    private void debugInfo(String str) {
        if (this.debug) {
            System.out.printf("Line: %3d, Pixel: %3d, " + str + "\n", this.videoOutput.monitor.currentLine(), this.clock);
        }
    }

    private void debugPixel(int color) {
        this.debugPixels[this.clock] = color;
    }

    private void processDebugPixelsInLine() {
        int i;
        Arrays.fill(this.linePixels, 0, 68, this.hBlankColor);
        if (this.debugLevel >= 4 && this.videoOutput.monitor.currentLine() % 10 == 0) {
            i = 0;
            while (i < 228) {
                if (this.debugPixels[i] == 0) {
                    if (i < 68) {
                        if (i % 6 == 0 || i == 66 || i == 63) {
                            this.debugPixels[i] = -14671840;
                        }
                    } else if ((i - 68 - 1) % 6 == 0) {
                        this.debugPixels[i] = -14671840;
                    }
                }
                ++i;
            }
        }
        if (this.debugLevel >= 3) {
            i = 0;
            while (i < 228) {
                if (this.debugPixels[i] != 0) {
                    this.linePixels[i] = this.debugPixels[i];
                    this.debugPixels[i] = 0;
                }
                ++i;
            }
        }
        this.observableChange();
    }

    private void chargePaddleCapacitors() {
        if (this.INPT0 < 128 && ++this.paddle0CapacitorCharge >= this.paddle0Position) {
            this.INPT0 |= 0x80;
        }
        if (this.INPT1 < 128 && ++this.paddle1CapacitorCharge >= this.paddle1Position) {
            this.INPT1 |= 0x80;
        }
    }

    private void initLatchesAtPowerOn() {
        this.CXPPMM = 0;
        this.CXBLPF = 0;
        this.CXM1FB = 0;
        this.CXM0FB = 0;
        this.CXP1FB = 0;
        this.CXP0FB = 0;
        this.CXM1P = 0;
        this.CXM0P = 0;
        this.INPT3 = 0;
        this.INPT2 = 0;
        this.INPT1 = 0;
        this.INPT0 = 0;
        this.INPT5 = 128;
        this.INPT4 = 128;
    }

    @Override
    public byte readByte(int address) {
        switch (address & 0xF) {
            case 0: {
                return (byte)this.CXM0P;
            }
            case 1: {
                return (byte)this.CXM1P;
            }
            case 2: {
                return (byte)this.CXP0FB;
            }
            case 3: {
                return (byte)this.CXP1FB;
            }
            case 4: {
                return (byte)this.CXM0FB;
            }
            case 5: {
                return (byte)this.CXM1FB;
            }
            case 6: {
                return (byte)this.CXBLPF;
            }
            case 7: {
                return (byte)this.CXPPMM;
            }
            case 8: {
                return (byte)this.INPT0;
            }
            case 9: {
                return (byte)this.INPT1;
            }
            case 10: {
                return (byte)this.INPT2;
            }
            case 11: {
                return (byte)this.INPT3;
            }
            case 12: {
                return (byte)this.INPT4;
            }
            case 13: {
                return (byte)this.INPT5;
            }
        }
        this.debugInfo(String.format("Invalid TIA read register address: %04x", address));
        return 0;
    }

    @Override
    public void writeByte(int address, byte b) {
        int i = b & 0xFF;
        switch (address & 0x3F) {
            case 0: {
                this.VSYNC = i;
                this.observableChange();
                this.vSyncOn = (i & 2) != 0;
                return;
            }
            case 1: {
                this.VBLANK = i;
                this.vBlankSet(i);
                return;
            }
            case 2: {
                this.WSYNC = i;
                this.cpu.RDY = false;
                if (this.debug) {
                    this.debugPixel(-8978313);
                }
                return;
            }
            case 3: {
                this.RSYNC = i;
                return;
            }
            case 4: {
                this.NUSIZ0 = i;
                this.player0SetShape(i);
                return;
            }
            case 5: {
                this.NUSIZ1 = i;
                this.player1SetShape(i);
                return;
            }
            case 6: {
                this.COLUP0 = i;
                this.observableChange();
                if (!this.debug) {
                    this.player0Color = this.missile0Color = this.palette[i];
                }
                return;
            }
            case 7: {
                this.COLUP1 = i;
                this.observableChange();
                if (!this.debug) {
                    this.player1Color = this.missile1Color = this.palette[i];
                }
                return;
            }
            case 8: {
                this.COLUPF = i;
                this.observableChange();
                if (!this.debug) {
                    this.playfieldColor = this.ballColor = this.palette[i];
                }
                return;
            }
            case 9: {
                this.COLUBK = i;
                this.observableChange();
                if (!this.debug) {
                    this.playfieldBackground = this.palette[i];
                }
                return;
            }
            case 10: {
                this.CTRLPF = i;
                this.playfieldAndBallSetShape(i);
                return;
            }
            case 11: {
                this.REFP0 = i;
                this.observableChange();
                this.player0Reflected = (i & 8) != 0;
                return;
            }
            case 12: {
                this.REFP1 = i;
                this.observableChange();
                this.player1Reflected = (i & 8) != 0;
                return;
            }
            case 13: {
                if (this.PF0 != i || this.playfieldDelayedChangePart == 0) {
                    this.playfieldDelaySpriteChange(0, i);
                }
                return;
            }
            case 14: {
                if (this.PF1 != i || this.playfieldDelayedChangePart == 1) {
                    this.playfieldDelaySpriteChange(1, i);
                }
                return;
            }
            case 15: {
                if (this.PF2 != i || this.playfieldDelayedChangePart == 2) {
                    this.playfieldDelaySpriteChange(2, i);
                }
                return;
            }
            case 16: {
                this.RESP0 = i;
                this.hitRESP0();
                return;
            }
            case 17: {
                this.RESP1 = i;
                this.hitRESP1();
                return;
            }
            case 18: {
                this.RESM0 = i;
                this.hitRESM0();
                return;
            }
            case 19: {
                this.RESM1 = i;
                this.hitRESM1();
                return;
            }
            case 20: {
                this.RESBL = i;
                this.hitRESBL();
                return;
            }
            case 21: {
                this.AUDC0 = i;
                this.audioOutput.channel0().setControl(i & 0xF);
                return;
            }
            case 22: {
                this.AUDC1 = i;
                this.audioOutput.channel1().setControl(i & 0xF);
                return;
            }
            case 23: {
                this.AUDF0 = i;
                this.audioOutput.channel0().setDivider((i & 0x1F) + 1);
                return;
            }
            case 24: {
                this.AUDF1 = i;
                this.audioOutput.channel1().setDivider((i & 0x1F) + 1);
                return;
            }
            case 25: {
                this.AUDV0 = i;
                this.audioOutput.channel0().setVolume(i & 0xF);
                return;
            }
            case 26: {
                this.AUDV1 = i;
                this.audioOutput.channel1().setVolume(i & 0xF);
                return;
            }
            case 27: {
                this.GRP0 = i;
                this.playerDelaySpriteChange(0, i);
                return;
            }
            case 28: {
                this.GRP1 = i;
                this.playerDelaySpriteChange(1, i);
                return;
            }
            case 29: {
                this.ENAM0 = i;
                this.observableChange();
                this.missile0Enabled = (i & 2) != 0;
                return;
            }
            case 30: {
                this.ENAM1 = i;
                this.observableChange();
                this.missile1Enabled = (i & 2) != 0;
                return;
            }
            case 31: {
                this.ENABL = i;
                this.ballSetGraphic(i);
                return;
            }
            case 32: {
                this.HMP0 = b >> 4;
                return;
            }
            case 33: {
                this.HMP1 = b >> 4;
                return;
            }
            case 34: {
                this.HMM0 = b >> 4;
                return;
            }
            case 35: {
                this.HMM1 = b >> 4;
                return;
            }
            case 36: {
                this.HMBL = b >> 4;
                return;
            }
            case 37: {
                this.VDELP0 = i;
                this.observableChange();
                this.player0VerticalDelay = (i & 1) != 0;
                return;
            }
            case 38: {
                this.VDELP1 = i;
                this.observableChange();
                this.player1VerticalDelay = (i & 1) != 0;
                return;
            }
            case 39: {
                this.VDELBL = i;
                this.observableChange();
                this.ballVerticalDelay = (i & 1) != 0;
                return;
            }
            case 40: {
                this.RESMP0 = i;
                this.missile0SetResetToPlayer(i);
                return;
            }
            case 41: {
                this.RESMP1 = i;
                this.missile1SetResetToPlayer(i);
                return;
            }
            case 42: {
                this.HMOVE = i;
                this.hitHMOVE();
                return;
            }
            case 43: {
                this.HMCLR = i;
                this.HMBL = 0;
                this.HMM1 = 0;
                this.HMM0 = 0;
                this.HMP1 = 0;
                this.HMP0 = 0;
                return;
            }
            case 44: {
                this.CXCLR = i;
                this.observableChange();
                this.CXPPMM = 0;
                this.CXBLPF = 0;
                this.CXM1FB = 0;
                this.CXM0FB = 0;
                this.CXP1FB = 0;
                this.CXP0FB = 0;
                this.CXM1P = 0;
                this.CXM0P = 0;
                return;
            }
        }
        this.debugInfo(String.format("Invalid TIA write register address: %04x value %d", address, b));
    }

    @Override
    public void controlStateChanged(ConsoleControls.Control control, boolean state) {
        switch (control) {
            case JOY0_BUTTON: {
                if (state) {
                    this.controlsJOY0ButtonPressed = true;
                    this.INPT4 &= 0x7F;
                } else {
                    this.controlsJOY0ButtonPressed = false;
                    if (!this.controlsButtonsLatched) {
                        this.INPT4 |= 0x80;
                    }
                }
                return;
            }
            case JOY1_BUTTON: {
                if (state) {
                    this.controlsJOY1ButtonPressed = true;
                    this.INPT5 &= 0x7F;
                } else {
                    this.controlsJOY1ButtonPressed = false;
                    if (!this.controlsButtonsLatched) {
                        this.INPT5 |= 0x80;
                    }
                }
                return;
            }
        }
        if (!state) {
            return;
        }
        switch (control) {
            case DEBUG: {
                this.debug(this.debugLevel + 1);
                return;
            }
            case NO_COLLISIONS: {
                this.debugNoCollisions = !this.debugNoCollisions;
                return;
            }
            case PAUSE: {
                this.debugPause = !this.debugPause;
                this.debugPauseMoreFrames = 0;
                return;
            }
            case FRAME: {
                ++this.debugPauseMoreFrames;
                return;
            }
            case TRACE: {
                this.cpu.trace = !this.cpu.trace;
                return;
            }
        }
    }

    @Override
    public void controlStateChanged(ConsoleControls.Control control, int position) {
        switch (control) {
            case PADDLE0_POSITION: {
                this.paddle0Position = position;
                return;
            }
            case PADDLE1_POSITION: {
                this.paddle1Position = position;
                return;
            }
        }
    }

    @Override
    public void controlsStateReport(Map<ConsoleControls.Control, Boolean> report) {
    }

    public TIAState saveState() {
        TIAState state = new TIAState();
        state.debug = this.debug;
        state.debugLevel = this.debugLevel;
        state.debugNoCollisions = this.debugNoCollisions;
        state.linePixels = (int[])this.linePixels.clone();
        state.lastObservableChangeClock = this.lastObservableChangeClock;
        state.repeatLastLine = this.repeatLastLine;
        state.vSyncOn = this.vSyncOn;
        state.vBlankOn = this.vBlankOn;
        state.playfieldPattern = (boolean[])this.playfieldPattern.clone();
        state.playfieldPatternInvalid = this.playfieldPatternInvalid;
        state.playfieldCurrentPixel = this.playfieldCurrentPixel;
        state.playfieldColor = this.playfieldColor;
        state.playfieldBackground = this.playfieldBackground;
        state.playfieldReflected = this.playfieldReflected;
        state.playfieldScoreMode = this.playfieldScoreMode;
        state.playfieldPriority = this.playfieldPriority;
        state.player0ActiveSprite = this.player0ActiveSprite;
        state.player0DelayedSprite = this.player0DelayedSprite;
        state.player0Color = this.player0Color;
        state.player0RecentResetHit = this.player0RecentResetHit;
        state.player0Counter = this.player0Counter;
        state.player0ScanStartCountdown = this.player0ScanStartCountdown;
        state.player0ScanCounter = this.player0ScanCounter;
        state.player0ScanSpeed = this.player0ScanSpeed;
        state.player0ScanSubCounter = this.player0ScanSubCounter;
        state.player0VerticalDelay = this.player0VerticalDelay;
        state.player0CloseCopy = this.player0CloseCopy;
        state.player0MediumCopy = this.player0MediumCopy;
        state.player0WideCopy = this.player0WideCopy;
        state.player0Reflected = this.player0Reflected;
        state.player1ActiveSprite = this.player1ActiveSprite;
        state.player1DelayedSprite = this.player1DelayedSprite;
        state.player1Color = this.player1Color;
        state.player1RecentResetHit = this.player1RecentResetHit;
        state.player1Counter = this.player1Counter;
        state.player1ScanStartCountdown = this.player1ScanStartCountdown;
        state.player1ScanCounter = this.player1ScanCounter;
        state.player1ScanSpeed = this.player1ScanSpeed;
        state.player1ScanSubCounter = this.player1ScanSubCounter;
        state.player1VerticalDelay = this.player1VerticalDelay;
        state.player1CloseCopy = this.player1CloseCopy;
        state.player1MediumCopy = this.player1MediumCopy;
        state.player1WideCopy = this.player1WideCopy;
        state.player1Reflected = this.player1Reflected;
        state.missile0Enabled = this.missile0Enabled;
        state.missile0Color = this.missile0Color;
        state.missile0RecentResetHit = this.missile0RecentResetHit;
        state.missile0Counter = this.missile0Counter;
        state.missile0ScanCounter = this.missile0ScanCounter;
        state.missile0ScanSpeed = this.missile0ScanSpeed;
        state.missile0ScanSubCounter = this.missile0ScanSubCounter;
        state.missile0ResetToPlayer = this.missile0ResetToPlayer;
        state.missile1Enabled = this.missile1Enabled;
        state.missile1Color = this.missile1Color;
        state.missile1RecentResetHit = this.missile1RecentResetHit;
        state.missile1Counter = this.missile1Counter;
        state.missile1ScanCounter = this.missile1ScanCounter;
        state.missile1ScanSpeed = this.missile1ScanSpeed;
        state.missile1ScanSubCounter = this.missile1ScanSubCounter;
        state.missile1ResetToPlayer = this.missile1ResetToPlayer;
        state.ballEnabled = this.ballEnabled;
        state.ballDelayedEnablement = this.ballDelayedEnablement;
        state.ballColor = this.ballColor;
        state.ballCounter = this.ballCounter;
        state.ballScanCounter = this.ballScanCounter;
        state.ballScanSpeed = this.ballScanSpeed;
        state.ballScanSubCounter = this.ballScanSubCounter;
        state.ballVerticalDelay = this.ballVerticalDelay;
        state.playfieldDelayedChangeClock = this.playfieldDelayedChangeClock;
        state.playfieldDelayedChangePart = this.playfieldDelayedChangePart;
        state.playfieldDelayedChangePattern = this.playfieldDelayedChangePattern;
        state.playersDelayedSpriteChanges = Array2DCopy.copy(this.playersDelayedSpriteChanges);
        state.playersDelayedSpriteChangesCount = this.playersDelayedSpriteChangesCount;
        state.controlsButtonsLatched = this.controlsButtonsLatched;
        state.controlsJOY0ButtonPressed = this.controlsJOY0ButtonPressed;
        state.controlsJOY1ButtonPressed = this.controlsJOY1ButtonPressed;
        state.paddle0Position = this.paddle0Position;
        state.paddle0CapacitorCharge = this.paddle0CapacitorCharge;
        state.paddle1Position = this.paddle1Position;
        state.paddle1CapacitorCharge = this.paddle1CapacitorCharge;
        state.PF0 = this.PF0;
        state.PF1 = this.PF1;
        state.PF2 = this.PF2;
        state.AUDC0 = this.AUDC0;
        state.AUDC1 = this.AUDC1;
        state.AUDF0 = this.AUDF0;
        state.AUDF1 = this.AUDF1;
        state.AUDV0 = this.AUDV0;
        state.AUDV1 = this.AUDV1;
        state.HMP0 = this.HMP0;
        state.HMP1 = this.HMP1;
        state.HMM0 = this.HMM0;
        state.HMM1 = this.HMM1;
        state.HMBL = this.HMBL;
        state.CXM0P = this.CXM0P;
        state.CXM1P = this.CXM1P;
        state.CXP0FB = this.CXP0FB;
        state.CXP1FB = this.CXP1FB;
        state.CXM0FB = this.CXM0FB;
        state.CXM1FB = this.CXM1FB;
        state.CXBLPF = this.CXBLPF;
        state.CXPPMM = this.CXPPMM;
        state.INPT0 = this.INPT0;
        state.INPT1 = this.INPT1;
        state.INPT2 = this.INPT2;
        state.INPT3 = this.INPT3;
        state.INPT4 = this.INPT4;
        state.INPT5 = this.INPT5;
        return state;
    }

    public void loadState(TIAState state) {
        this.linePixels = state.linePixels;
        this.lastObservableChangeClock = state.lastObservableChangeClock;
        this.repeatLastLine = state.repeatLastLine;
        this.vSyncOn = state.vSyncOn;
        this.vBlankOn = state.vBlankOn;
        this.playfieldPattern = state.playfieldPattern;
        this.playfieldPatternInvalid = state.playfieldPatternInvalid;
        this.playfieldCurrentPixel = state.playfieldCurrentPixel;
        this.playfieldColor = state.playfieldColor;
        this.playfieldBackground = state.playfieldBackground;
        this.playfieldReflected = state.playfieldReflected;
        this.playfieldScoreMode = state.playfieldScoreMode;
        this.playfieldPriority = state.playfieldPriority;
        this.player0ActiveSprite = state.player0ActiveSprite;
        this.player0DelayedSprite = state.player0DelayedSprite;
        this.player0Color = state.player0Color;
        this.player0RecentResetHit = state.player0RecentResetHit;
        this.player0Counter = state.player0Counter;
        this.player0ScanStartCountdown = state.player0ScanStartCountdown;
        this.player0ScanCounter = state.player0ScanCounter;
        this.player0ScanSpeed = state.player0ScanSpeed;
        this.player0ScanSubCounter = state.player0ScanSubCounter;
        this.player0VerticalDelay = state.player0VerticalDelay;
        this.player0CloseCopy = state.player0CloseCopy;
        this.player0MediumCopy = state.player0MediumCopy;
        this.player0WideCopy = state.player0WideCopy;
        this.player0Reflected = state.player0Reflected;
        this.player1ActiveSprite = state.player1ActiveSprite;
        this.player1DelayedSprite = state.player1DelayedSprite;
        this.player1Color = state.player1Color;
        this.player1RecentResetHit = state.player1RecentResetHit;
        this.player1Counter = state.player1Counter;
        this.player1ScanStartCountdown = state.player1ScanStartCountdown;
        this.player1ScanCounter = state.player1ScanCounter;
        this.player1ScanSpeed = state.player1ScanSpeed;
        this.player1ScanSubCounter = state.player1ScanSubCounter;
        this.player1VerticalDelay = state.player1VerticalDelay;
        this.player1CloseCopy = state.player1CloseCopy;
        this.player1MediumCopy = state.player1MediumCopy;
        this.player1WideCopy = state.player1WideCopy;
        this.player1Reflected = state.player1Reflected;
        this.missile0Enabled = state.missile0Enabled;
        this.missile0Color = state.missile0Color;
        this.missile0RecentResetHit = state.missile0RecentResetHit;
        this.missile0Counter = state.missile0Counter;
        this.missile0ScanCounter = state.missile0ScanCounter;
        this.missile0ScanSpeed = state.missile0ScanSpeed;
        this.missile0ScanSubCounter = state.missile0ScanSubCounter;
        this.missile0ResetToPlayer = state.missile0ResetToPlayer;
        this.missile1Enabled = state.missile1Enabled;
        this.missile1Color = state.missile1Color;
        this.missile1RecentResetHit = state.missile1RecentResetHit;
        this.missile1Counter = state.missile1Counter;
        this.missile1ScanCounter = state.missile1ScanCounter;
        this.missile1ScanSpeed = state.missile1ScanSpeed;
        this.missile1ScanSubCounter = state.missile1ScanSubCounter;
        this.missile1ResetToPlayer = state.missile1ResetToPlayer;
        this.ballEnabled = state.ballEnabled;
        this.ballDelayedEnablement = state.ballDelayedEnablement;
        this.ballColor = state.ballColor;
        this.ballCounter = state.ballCounter;
        this.ballScanCounter = state.ballScanCounter;
        this.ballScanSpeed = state.ballScanSpeed;
        this.ballScanSubCounter = state.ballScanSubCounter;
        this.ballVerticalDelay = state.ballVerticalDelay;
        this.playfieldDelayedChangeClock = state.playfieldDelayedChangeClock;
        this.playfieldDelayedChangePart = state.playfieldDelayedChangePart;
        this.playfieldDelayedChangePattern = state.playfieldDelayedChangePattern;
        this.playersDelayedSpriteChanges = state.playersDelayedSpriteChanges;
        this.playersDelayedSpriteChangesCount = state.playersDelayedSpriteChangesCount;
        this.controlsButtonsLatched = state.controlsButtonsLatched;
        this.PF0 = state.PF0;
        this.PF1 = state.PF1;
        this.PF2 = state.PF2;
        this.AUDC0 = state.AUDC0;
        this.audioOutput.channel0().setControl(this.AUDC0 & 0xF);
        this.AUDC1 = state.AUDC1;
        this.audioOutput.channel1().setControl(this.AUDC1 & 0xF);
        this.AUDF0 = state.AUDF0;
        this.audioOutput.channel0().setDivider((this.AUDF0 & 0x1F) + 1);
        this.AUDF1 = state.AUDF1;
        this.audioOutput.channel1().setDivider((this.AUDF1 & 0x1F) + 1);
        this.AUDV0 = state.AUDV0;
        this.audioOutput.channel0().setVolume(this.AUDV0 & 0xF);
        this.AUDV1 = state.AUDV1;
        this.audioOutput.channel1().setVolume(this.AUDV1 & 0xF);
        this.HMP0 = state.HMP0;
        this.HMP1 = state.HMP1;
        this.HMM0 = state.HMM0;
        this.HMM1 = state.HMM1;
        this.HMBL = state.HMBL;
        this.CXM0P = state.CXM0P;
        this.CXM1P = state.CXM1P;
        this.CXP0FB = state.CXP0FB;
        this.CXP1FB = state.CXP1FB;
        this.CXM0FB = state.CXM0FB;
        this.CXM1FB = state.CXM1FB;
        this.CXBLPF = state.CXBLPF;
        this.CXPPMM = state.CXPPMM;
        if (this.debug) {
            this.debugSetColors();
        }
    }

    public static class TIAState
    implements Serializable {
        boolean debug;
        int debugLevel;
        boolean debugNoCollisions;
        int[] linePixels;
        int lastObservableChangeClock;
        boolean repeatLastLine;
        boolean vSyncOn;
        boolean vBlankOn;
        boolean[] playfieldPattern;
        boolean playfieldPatternInvalid;
        boolean playfieldCurrentPixel;
        int playfieldColor;
        int playfieldBackground;
        boolean playfieldReflected;
        boolean playfieldScoreMode;
        boolean playfieldPriority;
        int player0ActiveSprite;
        int player0DelayedSprite;
        int player0Color;
        boolean player0RecentResetHit;
        int player0Counter;
        int player0ScanStartCountdown;
        int player0ScanCounter;
        int player0ScanSpeed;
        int player0ScanSubCounter;
        boolean player0VerticalDelay;
        boolean player0CloseCopy;
        boolean player0MediumCopy;
        boolean player0WideCopy;
        boolean player0Reflected;
        int player1ActiveSprite;
        int player1DelayedSprite;
        int player1Color;
        boolean player1RecentResetHit;
        int player1Counter;
        int player1ScanStartCountdown;
        int player1ScanCounter;
        int player1ScanSpeed;
        int player1ScanSubCounter;
        boolean player1VerticalDelay;
        boolean player1CloseCopy;
        boolean player1MediumCopy;
        boolean player1WideCopy;
        boolean player1Reflected;
        boolean missile0Enabled;
        int missile0Color;
        boolean missile0RecentResetHit;
        int missile0Counter;
        int missile0ScanCounter;
        int missile0ScanSpeed;
        int missile0ScanSubCounter;
        boolean missile0ResetToPlayer;
        boolean missile1Enabled;
        int missile1Color;
        boolean missile1RecentResetHit;
        int missile1Counter;
        int missile1ScanCounter;
        int missile1ScanSpeed;
        int missile1ScanSubCounter;
        boolean missile1ResetToPlayer;
        boolean ballEnabled;
        boolean ballDelayedEnablement;
        int ballColor;
        int ballCounter;
        int ballScanCounter;
        int ballScanSpeed;
        int ballScanSubCounter;
        boolean ballVerticalDelay;
        int playfieldDelayedChangeClock;
        int playfieldDelayedChangePart;
        int playfieldDelayedChangePattern;
        int[][] playersDelayedSpriteChanges;
        int playersDelayedSpriteChangesCount;
        boolean controlsButtonsLatched;
        boolean controlsJOY0ButtonPressed;
        boolean controlsJOY1ButtonPressed;
        int paddle0Position;
        int paddle0CapacitorCharge;
        int paddle1Position;
        int paddle1CapacitorCharge;
        int PF0;
        int PF1;
        int PF2;
        int AUDC0;
        int AUDC1;
        int AUDF0;
        int AUDF1;
        int AUDV0;
        int AUDV1;
        int HMP0;
        int HMP1;
        int HMM0;
        int HMM1;
        int HMBL;
        int CXM0P;
        int CXM1P;
        int CXP0FB;
        int CXP1FB;
        int CXM0FB;
        int CXM1FB;
        int CXBLPF;
        int CXPPMM;
        int INPT0;
        int INPT1;
        int INPT2;
        int INPT3;
        int INPT4;
        int INPT5;
        public static final long serialVersionUID = 2L;
    }

    private class VBlankDecode {
        private boolean isActive = false;
        private boolean newState;

        private VBlankDecode() {
        }

        private void start(boolean state) {
            this.newState = state;
            this.isActive = true;
        }

        private void clockPulse() {
            this.isActive = false;
            TIA.this.vBlankOn = this.newState;
        }
    }
}

