/*
 * Decompiled with CFR 0.152.
 */
package general.m6502;

import general.board.BUS16Bits;
import general.board.Clock;
import general.board.ClockDriven;
import general.m6502.Instruction;
import general.m6502.OperandType;
import general.m6502.Register;
import general.m6502.StatusBit;
import general.m6502.instructions.ADC;
import general.m6502.instructions.AND;
import general.m6502.instructions.ASL;
import general.m6502.instructions.BIT;
import general.m6502.instructions.BRK;
import general.m6502.instructions.Bxx;
import general.m6502.instructions.CLx;
import general.m6502.instructions.CPx;
import general.m6502.instructions.DEC;
import general.m6502.instructions.DEx;
import general.m6502.instructions.EOR;
import general.m6502.instructions.INC;
import general.m6502.instructions.INx;
import general.m6502.instructions.JMP;
import general.m6502.instructions.JSR;
import general.m6502.instructions.LDx;
import general.m6502.instructions.LSR;
import general.m6502.instructions.NOP;
import general.m6502.instructions.ORA;
import general.m6502.instructions.PHA;
import general.m6502.instructions.PHP;
import general.m6502.instructions.PLA;
import general.m6502.instructions.PLP;
import general.m6502.instructions.ROL;
import general.m6502.instructions.ROR;
import general.m6502.instructions.RTI;
import general.m6502.instructions.RTS;
import general.m6502.instructions.SBC;
import general.m6502.instructions.SEx;
import general.m6502.instructions.STx;
import general.m6502.instructions.Txx;
import general.m6502.instructions.uANC;
import general.m6502.instructions.uANE;
import general.m6502.instructions.uARR;
import general.m6502.instructions.uASR;
import general.m6502.instructions.uDCP;
import general.m6502.instructions.uISB;
import general.m6502.instructions.uKIL;
import general.m6502.instructions.uLAS;
import general.m6502.instructions.uLAX;
import general.m6502.instructions.uLXA;
import general.m6502.instructions.uNOP;
import general.m6502.instructions.uRLA;
import general.m6502.instructions.uRRA;
import general.m6502.instructions.uSAX;
import general.m6502.instructions.uSBX;
import general.m6502.instructions.uSHA;
import general.m6502.instructions.uSHS;
import general.m6502.instructions.uSHX;
import general.m6502.instructions.uSHY;
import general.m6502.instructions.uSLO;
import general.m6502.instructions.uSRE;
import java.io.Serializable;
import utils.Debugger;

public final class M6502
implements ClockDriven {
    public byte A;
    public byte X;
    public byte Y;
    public byte SP;
    public char PC;
    public boolean CARRY;
    public boolean ZERO;
    public boolean OVERFLOW;
    public boolean NEGATIVE;
    public boolean DECIMAL_MODE;
    public boolean INTERRUPT_DISABLE;
    public boolean BREAK_COMMAND;
    public boolean RDY;
    public BUS16Bits memory;
    public boolean trace = false;
    public boolean debug = false;
    public boolean pageCrossed = false;
    private int cyclesToExecute = 0;
    private Instruction instructionToExecute;
    public final Instruction[] instructions = new Instruction[]{new BRK(this), new ORA(this, OperandType.IND_X), new uKIL(this), new uSLO(this, OperandType.IND_X), new uNOP(this, OperandType.Z_PAGE), new ORA(this, OperandType.Z_PAGE), new ASL(this, OperandType.Z_PAGE), new uSLO(this, OperandType.Z_PAGE), new PHP(this), new ORA(this, OperandType.IMM), new ASL(this, OperandType.ACC), new uANC(this), new uNOP(this, OperandType.ABS), new ORA(this, OperandType.ABS), new ASL(this, OperandType.ABS), new uSLO(this, OperandType.ABS), new Bxx(this, StatusBit.bNEGATIVE, false), new ORA(this, OperandType.IND_Y), new uKIL(this), new uSLO(this, OperandType.IND_Y), new uNOP(this, OperandType.Z_PAGE_X), new ORA(this, OperandType.Z_PAGE_X), new ASL(this, OperandType.Z_PAGE_X), new uSLO(this, OperandType.Z_PAGE_X), new CLx(this, StatusBit.bCARRY), new ORA(this, OperandType.ABS_Y), new NOP(this), new uSLO(this, OperandType.ABS_Y), new uNOP(this, OperandType.ABS_X), new ORA(this, OperandType.ABS_X), new ASL(this, OperandType.ABS_X), new uSLO(this, OperandType.ABS_X), new JSR(this), new AND(this, OperandType.IND_X), new uKIL(this), new uRLA(this, OperandType.IND_X), new BIT(this, OperandType.Z_PAGE), new AND(this, OperandType.Z_PAGE), new ROL(this, OperandType.Z_PAGE), new uRLA(this, OperandType.Z_PAGE), new PLP(this), new AND(this, OperandType.IMM), new ROL(this, OperandType.ACC), new uANC(this), new BIT(this, OperandType.ABS), new AND(this, OperandType.ABS), new ROL(this, OperandType.ABS), new uRLA(this, OperandType.ABS), new Bxx(this, StatusBit.bNEGATIVE, true), new AND(this, OperandType.IND_Y), new uKIL(this), new uRLA(this, OperandType.IND_Y), new uNOP(this, OperandType.Z_PAGE_X), new AND(this, OperandType.Z_PAGE_X), new ROL(this, OperandType.Z_PAGE_X), new uRLA(this, OperandType.Z_PAGE_X), new SEx(this, StatusBit.bCARRY), new AND(this, OperandType.ABS_Y), new NOP(this), new uRLA(this, OperandType.ABS_Y), new uNOP(this, OperandType.ABS_X), new AND(this, OperandType.ABS_X), new ROL(this, OperandType.ABS_X), new uRLA(this, OperandType.ABS_X), new RTI(this), new EOR(this, OperandType.IND_X), new uKIL(this), new uSRE(this, OperandType.IND_X), new uNOP(this, OperandType.Z_PAGE), new EOR(this, OperandType.Z_PAGE), new LSR(this, OperandType.Z_PAGE), new uSRE(this, OperandType.Z_PAGE), new PHA(this), new EOR(this, OperandType.IMM), new LSR(this, OperandType.ACC), new uASR(this), new JMP(this, OperandType.ABS), new EOR(this, OperandType.ABS), new LSR(this, OperandType.ABS), new uSRE(this, OperandType.ABS), new Bxx(this, StatusBit.bOVERFLOW, false), new EOR(this, OperandType.IND_Y), new uKIL(this), new uSRE(this, OperandType.IND_Y), new uNOP(this, OperandType.Z_PAGE_X), new EOR(this, OperandType.Z_PAGE_X), new LSR(this, OperandType.Z_PAGE_X), new uSRE(this, OperandType.Z_PAGE_X), new CLx(this, StatusBit.bINTERRUPT_DISABLE), new EOR(this, OperandType.ABS_Y), new NOP(this), new uSRE(this, OperandType.ABS_Y), new uNOP(this, OperandType.ABS_X), new EOR(this, OperandType.ABS_X), new LSR(this, OperandType.ABS_X), new uSRE(this, OperandType.ABS_X), new RTS(this), new ADC(this, OperandType.IND_X), new uKIL(this), new uRRA(this, OperandType.IND_X), new uNOP(this, OperandType.Z_PAGE), new ADC(this, OperandType.Z_PAGE), new ROR(this, OperandType.Z_PAGE), new uRRA(this, OperandType.Z_PAGE), new PLA(this), new ADC(this, OperandType.IMM), new ROR(this, OperandType.ACC), new uARR(this), new JMP(this, OperandType.IND), new ADC(this, OperandType.ABS), new ROR(this, OperandType.ABS), new uRRA(this, OperandType.ABS), new Bxx(this, StatusBit.bOVERFLOW, true), new ADC(this, OperandType.IND_Y), new uKIL(this), new uRRA(this, OperandType.IND_Y), new uNOP(this, OperandType.Z_PAGE_X), new ADC(this, OperandType.Z_PAGE_X), new ROR(this, OperandType.Z_PAGE_X), new uRRA(this, OperandType.Z_PAGE_X), new SEx(this, StatusBit.bINTERRUPT_DISABLE), new ADC(this, OperandType.ABS_Y), new NOP(this), new uRRA(this, OperandType.ABS_Y), new uNOP(this, OperandType.ABS_X), new ADC(this, OperandType.ABS_X), new ROR(this, OperandType.ABS_X), new uRRA(this, OperandType.ABS_X), new uNOP(this, OperandType.IMM), new STx(this, Register.rA, OperandType.IND_X), new uNOP(this, OperandType.IMM), new uSAX(this, OperandType.IND_X), new STx(this, Register.rY, OperandType.Z_PAGE), new STx(this, Register.rA, OperandType.Z_PAGE), new STx(this, Register.rX, OperandType.Z_PAGE), new uSAX(this, OperandType.Z_PAGE), new DEx(this, Register.rY), new uNOP(this, OperandType.IMM), new Txx(this, Register.rX, Register.rA), new uANE(this), new STx(this, Register.rY, OperandType.ABS), new STx(this, Register.rA, OperandType.ABS), new STx(this, Register.rX, OperandType.ABS), new uSAX(this, OperandType.ABS), new Bxx(this, StatusBit.bCARRY, false), new STx(this, Register.rA, OperandType.IND_Y), new uKIL(this), new uSHA(this, OperandType.IND_Y), new STx(this, Register.rY, OperandType.Z_PAGE_X), new STx(this, Register.rA, OperandType.Z_PAGE_X), new STx(this, Register.rX, OperandType.Z_PAGE_Y), new uSAX(this, OperandType.Z_PAGE_Y), new Txx(this, Register.rY, Register.rA), new STx(this, Register.rA, OperandType.ABS_Y), new Txx(this, Register.rX, Register.rSP), new uSHS(this), new uSHY(this), new STx(this, Register.rA, OperandType.ABS_X), new uSHX(this), new uSHA(this, OperandType.ABS_Y), new LDx(this, Register.rY, OperandType.IMM), new LDx(this, Register.rA, OperandType.IND_X), new LDx(this, Register.rX, OperandType.IMM), new uLAX(this, OperandType.IND_X), new LDx(this, Register.rY, OperandType.Z_PAGE), new LDx(this, Register.rA, OperandType.Z_PAGE), new LDx(this, Register.rX, OperandType.Z_PAGE), new uLAX(this, OperandType.Z_PAGE), new Txx(this, Register.rA, Register.rY), new LDx(this, Register.rA, OperandType.IMM), new Txx(this, Register.rA, Register.rX), new uLXA(this), new LDx(this, Register.rY, OperandType.ABS), new LDx(this, Register.rA, OperandType.ABS), new LDx(this, Register.rX, OperandType.ABS), new uLAX(this, OperandType.ABS), new Bxx(this, StatusBit.bCARRY, true), new LDx(this, Register.rA, OperandType.IND_Y), new uKIL(this), new uLAX(this, OperandType.IND_Y), new LDx(this, Register.rY, OperandType.Z_PAGE_X), new LDx(this, Register.rA, OperandType.Z_PAGE_X), new LDx(this, Register.rX, OperandType.Z_PAGE_Y), new uLAX(this, OperandType.Z_PAGE_Y), new CLx(this, StatusBit.bOVERFLOW), new LDx(this, Register.rA, OperandType.ABS_Y), new Txx(this, Register.rSP, Register.rX), new uLAS(this), new LDx(this, Register.rY, OperandType.ABS_X), new LDx(this, Register.rA, OperandType.ABS_X), new LDx(this, Register.rX, OperandType.ABS_Y), new uLAX(this, OperandType.ABS_Y), new CPx(this, Register.rY, OperandType.IMM), new CPx(this, Register.rA, OperandType.IND_X), new uNOP(this, OperandType.IMM), new uDCP(this, OperandType.IND_X), new CPx(this, Register.rY, OperandType.Z_PAGE), new CPx(this, Register.rA, OperandType.Z_PAGE), new DEC(this, OperandType.Z_PAGE), new uDCP(this, OperandType.Z_PAGE), new INx(this, Register.rY), new CPx(this, Register.rA, OperandType.IMM), new DEx(this, Register.rX), new uSBX(this), new CPx(this, Register.rY, OperandType.ABS), new CPx(this, Register.rA, OperandType.ABS), new DEC(this, OperandType.ABS), new uDCP(this, OperandType.ABS), new Bxx(this, StatusBit.bZERO, false), new CPx(this, Register.rA, OperandType.IND_Y), new uKIL(this), new uDCP(this, OperandType.IND_Y), new uNOP(this, OperandType.Z_PAGE_X), new CPx(this, Register.rA, OperandType.Z_PAGE_X), new DEC(this, OperandType.Z_PAGE_X), new uDCP(this, OperandType.Z_PAGE_X), new CLx(this, StatusBit.bDECIMAL_MODE), new CPx(this, Register.rA, OperandType.ABS_Y), new NOP(this), new uDCP(this, OperandType.ABS_Y), new uNOP(this, OperandType.ABS_X), new CPx(this, Register.rA, OperandType.ABS_X), new DEC(this, OperandType.ABS_X), new uDCP(this, OperandType.ABS_X), new CPx(this, Register.rX, OperandType.IMM), new SBC(this, OperandType.IND_X), new uNOP(this, OperandType.IMM), new uISB(this, OperandType.IND_X), new CPx(this, Register.rX, OperandType.Z_PAGE), new SBC(this, OperandType.Z_PAGE), new INC(this, OperandType.Z_PAGE), new uISB(this, OperandType.Z_PAGE), new INx(this, Register.rX), new SBC(this, OperandType.IMM), new NOP(this), new SBC(this, OperandType.IMM), new CPx(this, Register.rX, OperandType.ABS), new SBC(this, OperandType.ABS), new INC(this, OperandType.ABS), new uISB(this, OperandType.ABS), new Bxx(this, StatusBit.bZERO, true), new SBC(this, OperandType.IND_Y), new uKIL(this), new uISB(this, OperandType.IND_Y), new uNOP(this, OperandType.Z_PAGE_X), new SBC(this, OperandType.Z_PAGE_X), new INC(this, OperandType.Z_PAGE_X), new uISB(this, OperandType.Z_PAGE_X), new SEx(this, StatusBit.bDECIMAL_MODE), new SBC(this, OperandType.ABS_Y), new NOP(this), new uISB(this, OperandType.ABS_Y), new uNOP(this, OperandType.ABS_X), new SBC(this, OperandType.ABS_X), new INC(this, OperandType.ABS_X), new uISB(this, OperandType.ABS_X)};
    public static char NMI_HANDLER_ADDRESS = (char)65530;
    public static char POWER_ON_RESET_ADDRESS = (char)65532;
    public static char IRQ_HANDLER_ADDRESS = (char)65534;
    public static byte STACK_INITIAL_SP = (byte)-1;
    public static char STACK_PAGE = (char)256;

    public M6502() {
    }

    public M6502(BUS16Bits memory) {
        this.connectBus(memory);
    }

    public void connectBus(BUS16Bits bus) {
        this.memory = bus;
    }

    public void reset() {
        this.resetAt(this.memoryReadWord(POWER_ON_RESET_ADDRESS));
    }

    public void resetAt(char initialPC) {
        this.PC = initialPC;
        this.INTERRUPT_DISABLE = true;
        this.cyclesToExecute = 0;
        this.instructionToExecute = null;
    }

    @Override
    public void clockPulse() {
        if (this.cyclesToExecute == 1) {
            this.instructionToExecute.execute();
        } else if (!this.RDY) {
            return;
        }
        if (--this.cyclesToExecute >= 0) {
            return;
        }
        if (this.trace) {
            this.showTrace();
        }
        char c = this.PC;
        this.PC = (char)(c + '\u0001');
        this.instructionToExecute = this.instructions[M6502.toUnsignedByte(this.memory.readByte(c))];
        this.cyclesToExecute = this.instructionToExecute.fetch() - 1;
    }

    public void powerOn() {
        this.PC = '\u0000';
        this.SP = STACK_INITIAL_SP;
        this.Y = 0;
        this.X = 0;
        this.A = 0;
        this.PS((byte)0);
        this.INTERRUPT_DISABLE = true;
        this.RDY = true;
        this.reset();
    }

    public void powerOff() {
    }

    public char fetchImmediateAddress() {
        char c = this.PC;
        this.PC = (char)(c + '\u0001');
        return c;
    }

    public char fetchRelativeAddress() {
        char c = this.PC;
        this.PC = (char)(c + '\u0001');
        char res = (char)(this.memory.readByte(c) + this.PC);
        this.pageCrossed = (res & 0xFF00) != (this.PC & 0xFF00);
        return res;
    }

    public char fetchZeroPageAddress() {
        char c = this.PC;
        this.PC = (char)(c + '\u0001');
        return (char)M6502.toUnsignedByte(this.memory.readByte(c));
    }

    public char fetchZeroPageXAddress() {
        char c = this.PC;
        this.PC = (char)(c + '\u0001');
        return (char)M6502.toUnsignedByte(this.memory.readByte(c) + this.X);
    }

    public int fetchZeroPageYAddress() {
        char c = this.PC;
        this.PC = (char)(c + '\u0001');
        return (char)M6502.toUnsignedByte(this.memory.readByte(c) + this.Y);
    }

    public char fetchAbsoluteAddress() {
        this.PC = (char)(this.PC + 2);
        return this.memoryReadWord(this.PC - 2);
    }

    public char fetchAbsoluteXAddress() {
        char addr = this.fetchAbsoluteAddress();
        char res = (char)(addr + M6502.toUunsignedByte(this.X));
        this.pageCrossed = (res & 0xFF00) != (addr & 0xFF00);
        return res;
    }

    public char fetchAbsoluteYAddress() {
        char addr = this.fetchAbsoluteAddress();
        char res = (char)(addr + M6502.toUunsignedByte(this.Y));
        this.pageCrossed = (res & 0xFF00) != (addr & 0xFF00);
        return res;
    }

    public int fetchIndirectAddress() {
        return this.memoryReadWordWrappingPage(this.fetchAbsoluteAddress());
    }

    public int fetchIndirectXAddress() {
        return this.memoryReadWordWrappingPage(this.fetchZeroPageXAddress());
    }

    public char fetchIndirectYAddress() {
        char addr = this.memoryReadWordWrappingPage(this.fetchZeroPageAddress());
        char res = (char)(addr + M6502.toUunsignedByte(this.Y));
        this.pageCrossed = (res & 0xFF00) != (addr & 0xFF00);
        return res;
    }

    public char memoryReadWord(int address) {
        return (char)(M6502.toUnsignedByte(this.memory.readByte(address)) + (M6502.toUnsignedByte(this.memory.readByte(address + 1)) << 8));
    }

    public char memoryReadWordWrappingPage(int address) {
        if ((address & 0xFF) == 255) {
            return (char)(M6502.toUnsignedByte(this.memory.readByte(address)) + (M6502.toUnsignedByte(this.memory.readByte(address & 0xFF00)) << 8));
        }
        return this.memoryReadWord(address);
    }

    public void pushByte(byte b) {
        byte by = this.SP;
        this.SP = (byte)(by - 1);
        this.memory.writeByte(STACK_PAGE + M6502.toUunsignedByte(by), b);
    }

    public byte pullByte() {
        this.SP = (byte)(this.SP + 1);
        return this.memory.readByte(STACK_PAGE + M6502.toUunsignedByte(this.SP));
    }

    public void pushWord(char w) {
        this.pushByte((byte)(w >>> 8 & 0xFF));
        this.pushByte((byte)(w & 0xFF));
    }

    public char pullWord() {
        return (char)((this.pullByte() & 0xFF) + ((this.pullByte() & 0xFF) << 8));
    }

    public byte PS() {
        byte b = (byte)((this.NEGATIVE ? 128 : 0) + (this.OVERFLOW ? 64 : 0) + (this.BREAK_COMMAND ? 16 : 0) + (this.DECIMAL_MODE ? 8 : 0) + (this.INTERRUPT_DISABLE ? 4 : 0) + (this.ZERO ? 2 : 0) + (this.CARRY ? 1 : 0));
        return b;
    }

    public void PS(byte b) {
        int i = b & 0xFF;
        this.NEGATIVE = (i & 0x80) > 0;
        this.OVERFLOW = (i & 0x40) > 0;
        this.BREAK_COMMAND = (i & 0x10) > 0;
        this.DECIMAL_MODE = (i & 8) > 0;
        this.INTERRUPT_DISABLE = (i & 4) > 0;
        this.ZERO = (i & 2) > 0;
        this.CARRY = (i & 1) > 0;
    }

    public String printState() {
        String str = "";
        str = String.valueOf(str) + "A: " + String.format("%02x", this.A) + ", X: " + String.format("%02x", this.X) + ", Y: " + String.format("%02x", this.Y) + ", SP: " + String.format("%02x", this.SP) + ", PC: " + String.format("%04x", this.PC) + ",  Flags: " + String.format("%08d", Integer.parseInt(Integer.toBinaryString(this.PS() & 0xFF)));
        return str;
    }

    public String printMemory(int fromAddress, int count) {
        String str = "";
        int i = 0;
        while (i < count) {
            str = String.valueOf(str) + String.format("%02x ", this.memory.readByte(fromAddress + i));
            ++i;
        }
        return str;
    }

    public void debug(String title) {
        if (this.trace) {
            this.showDebug(title);
        } else if (this.debug) {
            System.out.println(title);
        }
    }

    public void showDebug(String title) {
        int res;
        System.out.println("PROCESSOR PAUSED\n" + this.printState());
        do {
            if ((res = Debugger.show(title, "PROCESSOR STATUS:\n\n" + this.printState() + "\n\n", new String[]{"Continue", this.trace ? "Stop Trace" : "Start Trace", "Abort"})) != 1) continue;
            boolean bl = this.trace = !this.trace;
        } while (res != 0 && res != 2);
        if (res == 2) {
            ((Clock)Thread.currentThread()).terminate();
        }
    }

    private void showTrace() {
        this.showDebug(">>> TRACE");
    }

    public M6502State saveState() {
        M6502State state = new M6502State();
        state.PC = this.PC;
        state.A = this.A;
        state.X = this.X;
        state.Y = this.Y;
        state.SP = this.SP;
        state.CARRY = this.CARRY;
        state.ZERO = this.ZERO;
        state.OVERFLOW = this.OVERFLOW;
        state.NEGATIVE = this.NEGATIVE;
        state.DECIMAL_MODE = this.DECIMAL_MODE;
        state.INTERRUPT_DISABLE = this.INTERRUPT_DISABLE;
        state.BREAK_COMMAND = this.BREAK_COMMAND;
        state.RDY = this.RDY;
        state.trace = this.trace;
        state.debug = this.debug;
        state.pageCrossed = this.pageCrossed;
        state.instructionToExecute = this.instructionToExecute;
        state.cyclesToExecute = this.cyclesToExecute;
        return state;
    }

    public void loadState(M6502State state) {
        this.PC = state.PC;
        this.A = state.A;
        this.X = state.X;
        this.Y = state.Y;
        this.SP = state.SP;
        this.CARRY = state.CARRY;
        this.ZERO = state.ZERO;
        this.OVERFLOW = state.OVERFLOW;
        this.NEGATIVE = state.NEGATIVE;
        this.DECIMAL_MODE = state.DECIMAL_MODE;
        this.INTERRUPT_DISABLE = state.INTERRUPT_DISABLE;
        this.BREAK_COMMAND = state.BREAK_COMMAND;
        this.RDY = state.RDY;
        this.trace = state.trace;
        this.debug = state.debug;
        this.pageCrossed = state.pageCrossed;
        this.instructionToExecute = state.instructionToExecute;
        if (this.instructionToExecute != null) {
            this.instructionToExecute.cpu = this;
        }
        this.cyclesToExecute = state.cyclesToExecute;
    }

    public static int toUunsignedByte(byte b) {
        return b & 0xFF;
    }

    public static int toUnsignedByte(int i) {
        return M6502.toUunsignedByte((byte)i);
    }

    public static class M6502State
    implements Serializable {
        byte A;
        byte X;
        byte Y;
        byte SP;
        char PC;
        boolean CARRY;
        boolean ZERO;
        boolean OVERFLOW;
        boolean NEGATIVE;
        boolean DECIMAL_MODE;
        boolean INTERRUPT_DISABLE;
        boolean BREAK_COMMAND;
        boolean RDY;
        boolean trace;
        boolean debug;
        boolean pageCrossed;
        Instruction instructionToExecute;
        int cyclesToExecute;
        public static final long serialVersionUID = 2L;
    }
}

