/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.Instruction;
import general.m6502.M6502;
import general.m6502.OperandType;

public class BIT
extends Instruction {
    private final OperandType type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public BIT(M6502 cpu, OperandType type) {
        super(cpu);
        this.type = type;
    }

    @Override
    public int fetch() {
        switch (this.type) {
            case Z_PAGE: {
                this.ea = this.cpu.fetchZeroPageAddress();
                return 3;
            }
            case ABS: {
                this.ea = this.cpu.fetchAbsoluteAddress();
                return 4;
            }
        }
        throw new IllegalStateException("BIT Invalid Operand Type: " + (Object)((Object)this.type));
    }

    @Override
    public void execute() {
        byte val = this.cpu.memory.readByte(this.ea);
        this.cpu.ZERO = (val & this.cpu.A) == 0;
        this.cpu.OVERFLOW = (val & 0x40) != 0;
        this.cpu.NEGATIVE = (val & 0x80) != 0;
    }
}

