/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.Instruction;
import general.m6502.M6502;
import general.m6502.StatusBit;

public class Bxx
extends Instruction {
    private final StatusBit bit;
    private final boolean cond;
    private char newPC;
    private boolean branch;
    public static final long serialVersionUID = 1L;

    public Bxx(M6502 cpu, StatusBit bit, boolean cond) {
        super(cpu);
        this.bit = bit;
        this.cond = cond;
    }

    @Override
    public int fetch() {
        this.newPC = this.cpu.fetchRelativeAddress();
        switch (this.bit) {
            case bZERO: {
                this.branch = this.cpu.ZERO == this.cond;
                break;
            }
            case bNEGATIVE: {
                this.branch = this.cpu.NEGATIVE == this.cond;
                break;
            }
            case bCARRY: {
                this.branch = this.cpu.CARRY == this.cond;
                break;
            }
            case bOVERFLOW: {
                this.branch = this.cpu.OVERFLOW == this.cond;
                break;
            }
            default: {
                throw new IllegalStateException("Bxx Invalid StatusBit: " + (Object)((Object)this.bit));
            }
        }
        return this.branch ? (this.cpu.pageCrossed ? 4 : 3) : 2;
    }

    @Override
    public void execute() {
        if (this.branch) {
            this.cpu.PC = this.newPC;
        }
    }
}

