/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.Instruction;
import general.m6502.M6502;
import general.m6502.OperandType;

public class DEC
extends Instruction {
    private final OperandType type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public DEC(M6502 cpu, OperandType type) {
        super(cpu);
        this.type = type;
    }

    @Override
    public int fetch() {
        switch (this.type) {
            case Z_PAGE: {
                this.ea = this.cpu.fetchZeroPageAddress();
                return 5;
            }
            case Z_PAGE_X: {
                this.ea = this.cpu.fetchZeroPageXAddress();
                return 6;
            }
            case ABS: {
                this.ea = this.cpu.fetchAbsoluteAddress();
                return 6;
            }
            case ABS_X: {
                this.ea = this.cpu.fetchAbsoluteXAddress();
                return 7;
            }
        }
        throw new IllegalStateException("DEC Invalid Operand Type: " + (Object)((Object)this.type));
    }

    @Override
    public void execute() {
        byte val = (byte)(this.cpu.memory.readByte(this.ea) - 1);
        this.cpu.memory.writeByte(this.ea, val);
        this.cpu.ZERO = val == 0;
        this.cpu.NEGATIVE = val < 0;
    }
}

