/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.M6502;
import general.m6502.OperandType;
import general.m6502.UndocumentedInstruction;

public class uLAX
extends UndocumentedInstruction {
    private final OperandType type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public uLAX(M6502 cpu, OperandType type) {
        super(cpu);
        this.type = type;
    }

    @Override
    public int fetch() {
        switch (this.type) {
            case Z_PAGE: {
                this.ea = this.cpu.fetchZeroPageAddress();
                return 3;
            }
            case Z_PAGE_Y: {
                this.ea = this.cpu.fetchZeroPageYAddress();
                return 4;
            }
            case ABS: {
                this.ea = this.cpu.fetchAbsoluteAddress();
                return 4;
            }
            case ABS_Y: {
                this.ea = this.cpu.fetchAbsoluteYAddress();
                return 4 + (this.cpu.pageCrossed ? 1 : 0);
            }
            case IND_X: {
                this.ea = this.cpu.fetchIndirectXAddress();
                return 6;
            }
            case IND_Y: {
                this.ea = this.cpu.fetchIndirectYAddress();
                return 5 + (this.cpu.pageCrossed ? 1 : 0);
            }
        }
        throw new IllegalStateException("uLAX Invalid Operand Type: " + (Object)((Object)this.type));
    }

    @Override
    public void execute() {
        byte val;
        this.cpu.A = val = this.cpu.memory.readByte(this.ea);
        this.cpu.X = val;
        this.cpu.ZERO = val == 0;
        this.cpu.NEGATIVE = val < 0;
    }
}

