/*
 * Decompiled with CFR 0.152.
 */
package main;

import atari.cartridge.Cartridge;
import atari.network.ServerConsole;
import atari.network.socket.SocketRemoteTransmitter;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import parameters.Parameters;
import pc.cartridge.ROMLoader;
import pc.savestate.FileSaveStateMedia;
import pc.screen.Screen;
import pc.speaker.Speaker;
import utils.Terminator;

public class MultiplayerServer {
    public static void main(String[] args) throws RemoteException, AlreadyBoundException, NotBoundException {
        boolean success;
        Parameters.init(args);
        SocketRemoteTransmitter remoteTransmitter = new SocketRemoteTransmitter();
        ServerConsole console = new ServerConsole(remoteTransmitter);
        Screen screen = new Screen(console.videoOutput(), console.controlsSocket(), console.cartridgeSocket());
        Speaker speaker = new Speaker(console.audioOutput());
        new FileSaveStateMedia(console.saveStateSocket());
        screen.powerOn();
        speaker.powerOn();
        if (Parameters.mainArg != null) {
            Cartridge cart = ROMLoader.load(Parameters.mainArg);
            if (cart == null) {
                Terminator.terminate();
            }
            console.cartridgeSocket().insert(cart, true);
        }
        if (!(success = remoteTransmitter.listen())) {
            System.exit(1);
        }
    }
}

