/*
 * Decompiled with CFR 0.152.
 */
package main;

import atari.cartridge.Cartridge;
import atari.console.Console;
import parameters.Parameters;
import pc.cartridge.ROMLoader;
import pc.savestate.FileSaveStateMedia;
import pc.screen.Screen;
import pc.speaker.Speaker;
import utils.Terminator;

public class Standalone {
    public static void main(String[] args) {
        Parameters.init(args);
        Console console = new Console();
        Screen screen = new Screen(console.videoOutput(), console.controlsSocket(), console.cartridgeSocket());
        Speaker speaker = new Speaker(console.audioOutput());
        new FileSaveStateMedia(console.saveStateSocket());
        screen.powerOn();
        speaker.powerOn();
        if (Parameters.mainArg != null) {
            Cartridge cart = ROMLoader.load(Parameters.mainArg);
            if (cart == null) {
                Terminator.terminate();
            }
            console.cartridgeSocket().insert(cart, true);
        }
    }
}

