/*
 * Decompiled with CFR 0.152.
 */
package pc.cartridge;

import atari.cartridge.Cartridge;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JOptionPane;
import pc.cartridge.CartridgeCreator;
import pc.cartridge.UnsupportedROMFormatException;

public class ROMLoader {
    private static final int MAX_ROM_SIZE = 32768;
    private static final int MAX_STREAM_SIZE = 34816;
    public static final String VALID_FILES_DESC = "ROM files (.bin .rom .a26 .zip)";
    public static final String[] VALID_FILE_EXTENSIONS = new String[]{"bin", "rom", "a26", "zip"};

    public static Cartridge load(String url) {
        try {
            return ROMLoader.load(new URL(url));
        }
        catch (MalformedURLException ex) {
            ROMLoader.errorMessage(ex, url);
            return null;
        }
    }

    public static Cartridge load(File file) {
        try {
            return ROMLoader.load(file.toURI().toURL());
        }
        catch (MalformedURLException ex) {
            ROMLoader.errorMessage(ex, file.getPath());
            return null;
        }
    }

    public static Cartridge load(URL url) {
        InputStream stream = null;
        try {
            System.out.println("Loading Cartridge from: " + url);
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(5000);
            stream = conn.getInputStream();
            return ROMLoader.load(stream, url.toString());
        }
        catch (AccessControlException ex) {
            ROMLoader.errorMessage(ex, url.toString());
        }
        catch (IOException ex) {
            ROMLoader.errorMessage(ex, url.toString());
        }
        return null;
    }

    public static Cartridge load(InputStream stream, String name) {
        BufferedInputStream buffer = ROMLoader.bufferedStream(stream);
        try {
            Cartridge cartridge = ROMLoader.tryCreation(buffer, name);
            return cartridge;
        }
        catch (UnsupportedROMFormatException ex) {
            buffer.reset();
            InputStream romFromZIP = ROMLoader.getFirstROMFromZIP(buffer);
            if (romFromZIP == null) {
                throw ex;
            }
            Cartridge cartridge = ROMLoader.tryCreation(romFromZIP, name);
            return cartridge;
        }
        catch (IOException ex) {
            ROMLoader.errorMessage(ex, name);
        }
        finally {
            try {
                stream.close();
                buffer.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static BufferedInputStream bufferedStream(InputStream stream) {
        BufferedInputStream buf = new BufferedInputStream(stream, 34816);
        buf.mark(34816);
        return buf;
    }

    private static Cartridge tryCreation(InputStream stream, String name) throws IOException, UnsupportedROMFormatException {
        int read;
        byte[] buffer = new byte[32768];
        int totalRead = 0;
        while ((read = stream.read(buffer, totalRead, 32768 - totalRead)) != -1 && (totalRead += read) < 32768) {
        }
        byte[] content = totalRead > 0 ? Arrays.copyOf(buffer, totalRead) : new byte[]{};
        return CartridgeCreator.create(content, name);
    }

    private static InputStream getFirstROMFromZIP(InputStream stream) throws IOException, UnsupportedROMFormatException {
        ZipInputStream zipStream = new ZipInputStream(stream);
        ZipEntry entry;
        block0: while ((entry = zipStream.getNextEntry()) != null) {
            String entryName = entry.getName().toUpperCase();
            int i = 0;
            while (true) {
                if (i >= VALID_FILE_EXTENSIONS.length) continue block0;
                if (entryName.endsWith(VALID_FILE_EXTENSIONS[i].toUpperCase())) {
                    return zipStream;
                }
                ++i;
            }
            break;
        }
        return null;
    }

    private static void errorMessage(Exception ex, String name) {
        System.out.println("Could not load Cartridge from: " + name);
        System.out.println(ex);
        JOptionPane.showMessageDialog(null, "Could not load Cartridge from:\n" + name, "Error loading Cartridge", 0);
    }
}

