/*
 * Decompiled with CFR 0.152.
 */
package pc.screen;

import atari.cartridge.Cartridge;
import atari.cartridge.CartridgeSocket;
import atari.controls.ConsoleControlsSocket;
import general.av.video.VideoMonitor;
import general.av.video.VideoSignal;
import general.av.video.VideoStandard;
import general.board.Clock;
import general.board.ClockDriven;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import parameters.Parameters;
import pc.cartridge.FileROMChooser;
import pc.cartridge.URLROMChooser;
import pc.controls.AWTConsoleControls;
import pc.screen.CRTTriadComposite;
import pc.screen.DisplayCanvas;
import pc.screen.ScreenControlsAdapter;
import pc.screen.ScreenFullWindow;
import pc.screen.ScreenWindow;
import utils.GraphicsDeviceHelper;
import utils.Terminator;

public class Screen
implements ClockDriven,
VideoMonitor {
    public Clock clock;
    public final ConsoleControlsSocket consoleControlsSocket;
    private AWTConsoleControls toolkitControls;
    private boolean cartridgeChangeEnabled = CARTRIDGE_CHANGE;
    private final VideoSignal videoSignal;
    private final CartridgeSocket cartridgeSocket;
    private final double fps;
    private VideoStandard signalStandard;
    private int signalWidth;
    private int signalHeight;
    private VideoStandard videoStandardDetected;
    private int videoStandardDetectionFrameCount;
    private int videoStandardDetectionTotalLinesCount;
    private int videoStandardDetectionLines = 0;
    private int[] backBuffer;
    private int[] frontBuffer;
    private int displayWidth;
    private int displayHeight;
    private double displayHeightPct;
    private int displayOriginX;
    private int displayOriginY;
    private double displayOriginYPct;
    private float displayScaleX;
    private float displayScaleY;
    private boolean signalOn = false;
    private boolean fullScreen = false;
    private int osdFramesLeft = -1;
    private String osdMessage;
    private JButton osdComponent;
    private boolean qualityRendering = QUALITY_RENDERING;
    private int crtMode = CRT_MODE;
    private int debug = 0;
    private int line = 0;
    private ScreenWindow window;
    private ScreenFullWindow fullWindow;
    private DisplayCanvas canvas;
    private BufferedImage frameImage;
    private BufferedImage scanlinesTextureImage;
    private CRTTriadComposite crtTriadComposite;
    private BufferedImage intermFrameImage;
    private Image logoIcon;
    private int VSYNCDetectionCount = 0;
    private String newDataMonitor = "nextLineMonitor";
    private String refreshMonitor = "refreshMonitor";
    private static final String BASE_TITLE = "javatari";
    private static final int VSYNC_DETECTION = 2;
    private static final int VSYNC_TOLERANCE = Parameters.SCREEN_VSYNC_TOLERANCE;
    public static final double DEFAULT_FPS = Parameters.SCREEN_DEFAULT_FPS;
    public static final int DEFAULT_ORIGIN_X = Parameters.SCREEN_DEFAULT_ORIGIN_X;
    public static final double DEFAULT_ORIGIN_Y_PCT = Parameters.SCREEN_DEFAULT_ORIGIN_Y_PCT;
    public static final int DEFAULT_WIDTH = Parameters.SCREEN_DEFAULT_WIDTH;
    public static final double DEFAULT_HEIGHT_PCT = Parameters.SCREEN_DEFAULT_HEIGHT_PCT;
    public static final float DEFAULT_SCALE_X = Parameters.SCREEN_DEFAULT_SCALE_X;
    public static final float DEFAULT_SCALE_Y = Parameters.SCREEN_DEFAULT_SCALE_Y;
    public static final float DEFAULT_SCALE_ASPECT_X = Parameters.SCREEN_DEFAULT_SCALE_ASPECT_X;
    public static final int OSD_FRAMES = Parameters.SCREEN_OSD_FRAMES;
    public static final boolean QUALITY_RENDERING = Parameters.SCREEN_QUALITY_RENDERING;
    public static final int CRT_MODE = Parameters.SCREEN_CRT_MODE;
    public static final float CRT_RETENTION_ALPHA = Parameters.SCREEN_CRT_RETENTION_ALPHA;
    public static final float SCANLINES_STRENGTH = Parameters.SCREEN_SCANLINES_STRENGTH;
    public static final int MULTI_BUFFERING = Parameters.SCREEN_MULTI_BUFFERING;
    public static final boolean PAGE_FLIPPING = Parameters.SCREEN_PAGE_FLIPPING;
    public static final int BUFFER_VSYNC = Parameters.SCREEN_BUFFER_VSYNC;
    public static final float FRAME_ACCELERATION = Parameters.SCREEN_FRAME_ACCELERATION;
    public static final float IMTERM_FRAME_ACCELERATION = Parameters.SCREEN_INTERM_FRAME_ACCELERATION;
    public static final float SCANLINES_ACCELERATION = Parameters.SCREEN_SCANLINES_ACCELERATION;
    private static final boolean CARTRIDGE_CHANGE = Parameters.SCREEN_CARTRIDGE_CHANGE;
    public static final boolean FULLSCREEN = Parameters.SCREEN_FULLSCREEN;
    public static final long serialVersionUID = 0L;

    public Screen(VideoSignal videoSignal, ConsoleControlsSocket controlsInput, CartridgeSocket cartridgeSocket) {
        this.fps = DEFAULT_FPS;
        this.videoSignal = videoSignal;
        this.consoleControlsSocket = controlsInput;
        this.cartridgeSocket = cartridgeSocket;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nextLine(int[] pixels, boolean vSynchSignal) {
        if (!this.signalState(pixels != null)) {
            return false;
        }
        boolean vSynced = false;
        String string = this.newDataMonitor;
        synchronized (string) {
            if (this.line < this.signalHeight) {
                System.arraycopy(pixels, 0, this.backBuffer, this.line * this.signalWidth, this.signalWidth);
            } else {
                vSynced = this.maxLineExceeded();
            }
            ++this.line;
            if (this.videoStandardDetected == null) {
                ++this.videoStandardDetectionLines;
            }
            if (vSynchSignal) {
                if (--this.VSYNCDetectionCount == 0) {
                    if (this.videoStandardDetected == null) {
                        this.videoStandardDetectionNewFrame();
                    }
                    vSynced = this.newFrame();
                }
            } else {
                this.VSYNCDetectionCount = 2;
            }
        }
        return vSynced;
    }

    @Override
    public VideoStandard videoStandardDetected() {
        return this.videoStandardDetected;
    }

    @Override
    public void videoStandardDetectionStart() {
        this.videoStandardDetected = null;
        this.videoStandardDetectionTotalLinesCount = 0;
        this.videoStandardDetectionFrameCount = 0;
    }

    @Override
    public int currentLine() {
        return this.line;
    }

    @Override
    public void synchOutput() {
        this.refresh();
    }

    @Override
    public void showOSD(String message) {
        this.osdMessage = message;
        this.osdFramesLeft = OSD_FRAMES;
    }

    @Override
    public void clockPulse() {
        this.synchOutput();
        if (this.fps < 0.0 && !Thread.interrupted()) {
            try {
                Thread.sleep(32L, 0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void powerOn() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Screen.this.fullScreen(FULLSCREEN);
                Screen.this.paintLogo();
                Screen.this.clock.go();
            }
        });
    }

    public void p1ControlsMode(boolean state) {
        this.toolkitControls.p1ControlsMode(state);
    }

    public void cartridgeChangeEnabled(boolean state) {
        this.cartridgeChangeEnabled = state;
    }

    private boolean newFrame() {
        if (this.debug > 0) {
            this.window.setTitle("javatari - " + this.line + " lines");
        }
        if (this.line < this.signalHeight - VSYNC_TOLERANCE) {
            return false;
        }
        Screen.arrayCopyWithStride(this.backBuffer, this.displayOriginY * this.signalWidth + this.displayOriginX, this.frontBuffer, 0, this.displayWidth * this.displayHeight, this.displayWidth, this.signalWidth);
        if (this.fps < 0.0) {
            this.clock.interrupt();
        }
        this.cleanBackBuffer();
        this.line = 0;
        return true;
    }

    private boolean maxLineExceeded() {
        if (this.line > this.signalHeight + VSYNC_TOLERANCE) {
            if (this.debug > 0) {
                System.out.println("Display maximum scanlines exceeded, line: " + this.line);
            }
            return this.newFrame();
        }
        return false;
    }

    private boolean signalState(boolean state) {
        this.signalOn = state;
        if (this.signalOn) {
            this.adjustToVideoSignal();
        } else {
            this.adjustToVideoSignalOff();
        }
        return this.signalOn;
    }

    private void cleanBackBuffer() {
        if (this.debug > 0) {
            Arrays.fill(this.backBuffer, Color.GREEN.getRGB());
        }
    }

    private void videoStandardDetectionNewFrame() {
        int linesCount = this.videoStandardDetectionLines;
        this.videoStandardDetectionLines = 0;
        if (linesCount < 250 || linesCount > 325) {
            return;
        }
        this.videoStandardDetectionTotalLinesCount += linesCount;
        if (++this.videoStandardDetectionFrameCount < 4) {
            return;
        }
        int averageLPF = this.videoStandardDetectionTotalLinesCount / this.videoStandardDetectionFrameCount;
        this.videoStandardDetected = averageLPF < 290 ? VideoStandard.NTSC : VideoStandard.PAL;
    }

    private void openWindow() {
        GraphicsDevice dev = GraphicsDeviceHelper.defaultScreenDevice();
        if (dev.isFullScreenSupported()) {
            dev.setFullScreenWindow(null);
        }
        this.fullWindow.setVisible(false);
        this.window.setVisible(true);
        this.fullScreen = false;
        this.canvas = this.window;
        this.canvasSetRenderingMode();
        float scX = this.canvas.getDefaultOpenningScaleX(this.displayWidth, this.displayHeight);
        this.setDisplayScale(scX, scX / DEFAULT_SCALE_ASPECT_X);
        this.canvasUpdateSize();
        this.canvasCenter();
    }

    private boolean openFullWindow() {
        GraphicsDevice dev = GraphicsDeviceHelper.defaultScreenDevice();
        if (!dev.isFullScreenSupported()) {
            return false;
        }
        this.window.setVisible(false);
        this.fullWindow.setVisible(true);
        dev.setFullScreenWindow(this.fullWindow);
        this.fullScreen = true;
        this.canvas = this.fullWindow;
        this.canvasSetRenderingMode();
        float scX = this.canvas.getDefaultOpenningScaleX(this.displayWidth, this.displayHeight);
        this.setDisplayScale(scX, scX / DEFAULT_SCALE_ASPECT_X);
        this.canvasUpdateSize();
        this.canvasCenter();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void canvasUpdateSize() {
        String string = this.refreshMonitor;
        synchronized (string) {
            Dimension size = new Dimension((int)((float)this.displayWidth * this.displayScaleX), (int)((float)this.displayHeight * this.displayScaleY));
            if (!this.fullScreen) {
                this.window.canvasSize(size);
                this.window.canvasMinimumSize(new Dimension((int)((float)this.displayWidth * DEFAULT_SCALE_X / DEFAULT_SCALE_Y), this.displayHeight));
            } else {
                this.fullWindow.canvasSize(size);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void canvasCenter() {
        if (this.canvas == null) {
            return;
        }
        String string = this.refreshMonitor;
        synchronized (string) {
            this.canvas.canvasCenter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void canvasSetRenderingMode() {
        String string = this.refreshMonitor;
        synchronized (string) {
            this.canvas.canvasSetRenderingMode();
        }
    }

    private Graphics2D canvasGraphics() {
        if (this.canvas == null) {
            return null;
        }
        Graphics2D canvasGraphics = this.canvas.canvasGraphics();
        canvasGraphics.setComposite(AlphaComposite.Src);
        if (canvasGraphics != null) {
            canvasGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, this.qualityRendering ? RenderingHints.VALUE_RENDER_QUALITY : RenderingHints.VALUE_RENDER_DEFAULT);
        }
        return canvasGraphics;
    }

    private void canvasFinish(Graphics2D graphics) {
        this.canvas.canvasFinishGraphics(graphics);
    }

    private void buildGUI() {
        this.window = new ScreenWindow(this);
        this.window.setTitle(BASE_TITLE);
        try {
            this.window.setDefaultCloseOperation(3);
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.fullWindow = new ScreenFullWindow();
        this.fullWindow.setTitle(BASE_TITLE);
        try {
            this.logoIcon = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/Logo.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.osdComponent = new JButton();
        this.osdComponent.setForeground(Color.GREEN);
        this.osdComponent.setBackground(new Color(0x50000000, true));
        this.osdComponent.setFont(new Font(this.osdComponent.getName(), 1, 15));
        this.osdComponent.setBorder(new EmptyBorder(5, 12, 5, 12));
        this.scanlinesTextureImage = new BufferedImage(2048, 1280, 3);
        Graphics2D g = this.scanlinesTextureImage.createGraphics();
        g.setColor(new Color((int)(SCANLINES_STRENGTH * 255.0f) << 24, true));
        int i = 1;
        while (i < this.scanlinesTextureImage.getHeight()) {
            g.drawLine(0, i, this.scanlinesTextureImage.getWidth(), i);
            i += 2;
        }
        g.dispose();
        if (SCANLINES_ACCELERATION >= 0.0f) {
            this.scanlinesTextureImage.setAccelerationPriority(SCANLINES_ACCELERATION);
        }
        this.crtTriadComposite = new CRTTriadComposite();
        this.intermFrameImage = new BufferedImage(2048, 1280, 1);
        if (IMTERM_FRAME_ACCELERATION >= 0.0f) {
            this.intermFrameImage.setAccelerationPriority(IMTERM_FRAME_ACCELERATION);
        }
    }

    private void init() {
        this.buildGUI();
        this.videoSignal.connectMonitor(this);
        this.adjustToVideoSignal();
        this.setDisplayDefaultSize();
        this.clock = new Clock(this, this.fps);
        this.toolkitControls = new AWTConsoleControls(this.consoleControlsSocket, this, this.window, this.fullWindow);
        new ScreenControlsAdapter(this, this.window, this.fullWindow);
        this.cleanBackBuffer();
        this.newFrame();
    }

    private void adjustToVideoSignal() {
        if (this.signalStandard == this.videoSignal.standard()) {
            return;
        }
        this.adjustToVideoStandard(this.videoSignal.standard());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustToVideoStandard(VideoStandard videoStandard) {
        String string = this.refreshMonitor;
        synchronized (string) {
            String string2 = this.newDataMonitor;
            synchronized (string2) {
                this.signalStandard = this.videoSignal.standard();
                this.signalWidth = videoStandard.width;
                this.signalHeight = videoStandard.height;
                this.setDisplaySize(this.displayWidth, this.displayHeightPct);
                this.setDisplayOrigin(this.displayOriginX, this.displayOriginYPct);
                this.backBuffer = new int[this.signalWidth * this.signalHeight];
                this.frontBuffer = new int[this.signalWidth * this.signalHeight];
                this.frameImage = new BufferedImage(this.signalWidth, this.signalHeight, 2);
                if (FRAME_ACCELERATION >= 0.0f) {
                    this.frameImage.setAccelerationPriority(FRAME_ACCELERATION);
                }
            }
        }
    }

    private void adjustToVideoSignalOff() {
        this.VSYNCDetectionCount = 2;
        this.line = 0;
        this.canvas.canvasClear();
        this.paintLogo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintLogo() {
        String string = this.refreshMonitor;
        synchronized (string) {
            Graphics2D canvasGraphics = this.canvasGraphics();
            if (canvasGraphics == null) {
                return;
            }
            int w = this.canvas.canvasEffectiveSize().width;
            int h = this.canvas.canvasEffectiveSize().height;
            canvasGraphics.setBackground(Color.BLACK);
            canvasGraphics.clearRect(0, 0, w, h);
            canvasGraphics.drawImage(this.logoIcon, (w - this.logoIcon.getWidth(null)) / 2, (h - this.logoIcon.getHeight(null)) / 2, null);
            this.paintOSD(canvasGraphics);
            this.canvasFinish(canvasGraphics);
        }
    }

    private void paintOSD(Graphics2D canvasGraphics) {
        if (--this.osdFramesLeft < 0) {
            return;
        }
        canvasGraphics.setComposite(AlphaComposite.SrcOver);
        this.osdComponent.setText(this.osdMessage);
        Dimension s = this.osdComponent.getPreferredSize();
        SwingUtilities.paintComponent(canvasGraphics, this.osdComponent, this.canvas.canvasContainer(), this.canvas.canvasEffectiveSize().width - s.width - 12, 12, s.width, s.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        if (!this.signalOn) {
            this.paintLogo();
            return;
        }
        String string = this.refreshMonitor;
        synchronized (string) {
            Graphics2D canvasGraphics = this.canvasGraphics();
            if (canvasGraphics == null) {
                return;
            }
            int canvasEffectiveWidth = this.canvas.canvasEffectiveSize().width;
            int canvasEffectiveHeight = this.canvas.canvasEffectiveSize().height;
            if (this.crtMode >= 3 || MULTI_BUFFERING < 2 && (this.osdFramesLeft >= 0 || this.crtMode > 0)) {
                int intermWidth = Math.min(canvasEffectiveWidth, 2048);
                int intermHeight = Math.min(canvasEffectiveHeight, 1280);
                Graphics2D intermGraphics = this.intermFrameImage.createGraphics();
                this.renderFrame(intermGraphics, intermWidth, intermHeight, true);
                if (this.crtMode == 2) {
                    this.renderScanlines(intermGraphics, intermWidth, intermHeight);
                }
                if (this.crtMode >= 3) {
                    intermGraphics.setComposite(this.crtTriadComposite);
                    intermGraphics.drawImage(this.intermFrameImage, 0, 0, intermWidth, intermHeight, 0, 0, intermWidth, intermHeight, null);
                }
                this.paintOSD(intermGraphics);
                intermGraphics.dispose();
                canvasGraphics.drawImage(this.intermFrameImage, 0, 0, intermWidth, intermHeight, 0, 0, intermWidth, intermHeight, null);
            } else {
                this.renderFrame(canvasGraphics, canvasEffectiveWidth, canvasEffectiveHeight, this.crtMode > 0);
                if (this.crtMode == 2) {
                    this.renderScanlines(canvasGraphics, canvasEffectiveWidth, canvasEffectiveHeight);
                }
                this.paintOSD(canvasGraphics);
            }
            this.canvasFinish(canvasGraphics);
        }
    }

    private void renderFrame(Graphics2D graphics, int canvasWidth, int canvasHeight, boolean clear) {
        if (clear) {
            graphics.setBackground(Color.BLACK);
            graphics.clearRect(0, 0, canvasWidth, canvasHeight);
        }
        if (this.crtMode > 0 && this.crtMode != 3) {
            graphics.setComposite(AlphaComposite.getInstance(3, CRT_RETENTION_ALPHA));
            graphics.drawImage(this.frameImage, 0, 0, canvasWidth, canvasHeight, 0, 0, this.displayWidth, this.displayHeight, null);
        }
        this.frameImage.getRaster().setDataElements(0, 0, this.displayWidth, this.displayHeight, this.frontBuffer);
        graphics.drawImage(this.frameImage, 0, 0, canvasWidth, canvasHeight, 0, 0, this.displayWidth, this.displayHeight, null);
    }

    private void renderScanlines(Graphics2D graphics, int canvasWidth, int canvasHeight) {
        graphics.setComposite(AlphaComposite.SrcOver);
        graphics.drawImage(this.scanlinesTextureImage, 0, 0, canvasWidth, canvasHeight, 0, 0, canvasWidth, canvasHeight, null);
    }

    private void setDisplayDefaultSize() {
        this.setDisplaySize(DEFAULT_WIDTH, DEFAULT_HEIGHT_PCT);
        this.setDisplayOrigin(DEFAULT_ORIGIN_X, DEFAULT_ORIGIN_Y_PCT);
        this.setDisplayScale(DEFAULT_SCALE_X, DEFAULT_SCALE_Y);
        this.canvasCenter();
    }

    private void setDisplayOrigin(int x, double yPct) {
        this.displayOriginX = x;
        if (this.displayOriginX < 0) {
            this.displayOriginX = 0;
        } else if (this.displayOriginX > this.signalWidth - this.displayWidth) {
            this.displayOriginX = this.signalWidth - this.displayWidth;
        }
        this.displayOriginYPct = yPct;
        if (this.displayOriginYPct < 0.0) {
            this.displayOriginYPct = 0.0;
        } else if (this.displayOriginYPct / 100.0 * (double)this.signalHeight > (double)(this.signalHeight - this.displayHeight)) {
            this.displayOriginYPct = ((double)this.signalHeight - (double)this.displayHeight) / (double)this.signalHeight * 100.0;
        }
        this.displayOriginY = (int)(this.displayOriginYPct / 100.0 * (double)this.signalHeight);
    }

    private void setDisplaySize(int width, double heightPct) {
        this.displayWidth = width;
        if (this.displayWidth < 10) {
            this.displayWidth = 10;
        } else if (this.displayWidth > this.signalWidth) {
            this.displayWidth = this.signalWidth;
        }
        this.displayHeightPct = heightPct;
        if (this.displayHeightPct < 10.0) {
            this.displayHeightPct = 10.0;
        } else if (this.displayHeightPct > 100.0) {
            this.displayHeightPct = 100.0;
        }
        this.displayHeight = (int)(this.displayHeightPct / 100.0 * (double)this.signalHeight);
        this.setDisplayOrigin(this.displayOriginX, this.displayOriginYPct);
        this.canvasUpdateSize();
    }

    private void setDisplayScale(float x, float y) {
        this.displayScaleX = x;
        if (this.displayScaleX < 1.0f) {
            this.displayScaleX = 1.0f;
        }
        this.displayScaleY = y;
        if (this.displayScaleY < 1.0f) {
            this.displayScaleY = 1.0f;
        }
        this.canvasUpdateSize();
    }

    private void setDisplayScaleDefaultAspect(float y) {
        int scaleY = (int)y;
        if (scaleY < 1) {
            scaleY = 1;
        }
        this.setDisplayScale((float)scaleY * DEFAULT_SCALE_ASPECT_X, scaleY);
    }

    private void loadCartridgeFromFile(boolean autoPower) {
        Cartridge cart;
        if (this.cartridgeChangeDisabledWarning()) {
            return;
        }
        if (this.fullScreen) {
            this.fullScreen(false);
        }
        if ((cart = FileROMChooser.chooseFile()) != null) {
            this.cartridgeSocket.insert(cart, autoPower);
        }
    }

    private void loadCartridgeFromURL(boolean autoPower) {
        Cartridge cart;
        if (this.cartridgeChangeDisabledWarning()) {
            return;
        }
        if (this.fullScreen) {
            this.fullScreen(false);
        }
        if ((cart = URLROMChooser.chooseURL()) != null) {
            this.cartridgeSocket.insert(cart, autoPower);
        }
    }

    private void loadCartridgeEmpty() {
        if (this.cartridgeChangeDisabledWarning()) {
            return;
        }
        this.cartridgeSocket.insert(null, false);
    }

    private boolean cartridgeChangeDisabledWarning() {
        if (!this.cartridgeChangeEnabled) {
            this.showOSD("Cartridge change is disabled");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullScreen(boolean state) {
        String string = this.refreshMonitor;
        synchronized (string) {
            if (state && this.openFullWindow()) {
                return;
            }
            this.openWindow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crtModeToggle() {
        String string = this.refreshMonitor;
        synchronized (string) {
            ++this.crtMode;
            if (this.crtMode > 4) {
                this.crtMode = 0;
            }
            this.showOSD(this.crtMode == 0 ? "CRT mode off" : "CRT mode " + this.crtMode);
        }
    }

    public void controlStateChanged(Control control, boolean state) {
        if (!state) {
            return;
        }
        switch (control) {
            case LOAD_CARTRIDGE_FILE: {
                this.loadCartridgeFromFile(true);
                break;
            }
            case LOAD_CARTRIDGE_FILE_NO_AUTO_POWER: {
                this.loadCartridgeFromFile(false);
                break;
            }
            case LOAD_CARTRIDGE_URL: {
                this.loadCartridgeFromURL(true);
                break;
            }
            case LOAD_CARTRIDGE_URL_NO_AUTO_POWER: {
                this.loadCartridgeFromURL(false);
                break;
            }
            case LOAD_CARTRIDGE_EMPTY: {
                this.loadCartridgeEmpty();
                break;
            }
            case FULL_SCREEN: {
                this.fullScreen(!this.fullScreen);
                break;
            }
            case QUALITY: {
                this.qualityRendering = !this.qualityRendering;
                this.showOSD(this.qualityRendering ? "Filter ON" : "Filter OFF");
                break;
            }
            case CRT_MODES: {
                this.crtModeToggle();
                break;
            }
            case DEBUG: {
                ++this.debug;
                if (this.debug <= 4) break;
                this.debug = 0;
                break;
            }
            case EXIT: {
                if (this.fullScreen) {
                    this.fullScreen(false);
                    break;
                }
                Terminator.terminate();
            }
            case HELP: {
                this.window.consolePanelWindow.toggle();
                break;
            }
            case ORIGIN_X_MINUS: {
                this.setDisplayOrigin(this.displayOriginX + 1, this.displayOriginYPct);
                break;
            }
            case ORIGIN_X_PLUS: {
                this.setDisplayOrigin(this.displayOriginX - 1, this.displayOriginYPct);
                break;
            }
            case ORIGIN_Y_MINUS: {
                this.setDisplayOrigin(this.displayOriginX, this.displayOriginYPct + 0.5);
                break;
            }
            case ORIGIN_Y_PLUS: {
                this.setDisplayOrigin(this.displayOriginX, this.displayOriginYPct - 0.5);
                break;
            }
            case WIDTH_MINUS: {
                this.setDisplaySize(this.displayWidth - 1, this.displayHeightPct);
                break;
            }
            case WIDTH_PLUS: {
                this.setDisplaySize(this.displayWidth + 1, this.displayHeightPct);
                break;
            }
            case HEIGHT_MINUS: {
                this.setDisplaySize(this.displayWidth, this.displayHeightPct - 0.5);
                break;
            }
            case HEIGHT_PLUS: {
                this.setDisplaySize(this.displayWidth, this.displayHeightPct + 0.5);
                break;
            }
            case SCALE_X_MINUS: {
                this.setDisplayScale(this.displayScaleX - 0.5f, this.displayScaleY);
                break;
            }
            case SCALE_X_PLUS: {
                this.setDisplayScale(this.displayScaleX + 0.5f, this.displayScaleY);
                break;
            }
            case SCALE_Y_MINUS: {
                this.setDisplayScale(this.displayScaleX, this.displayScaleY - 0.5f);
                break;
            }
            case SCALE_Y_PLUS: {
                this.setDisplayScale(this.displayScaleX, this.displayScaleY + 0.5f);
                break;
            }
            case SIZE_MINUS: {
                this.setDisplayScaleDefaultAspect(this.displayScaleY - 1.0f);
                break;
            }
            case SIZE_PLUS: {
                this.setDisplayScaleDefaultAspect(this.displayScaleY + 1.0f);
                break;
            }
            case SIZE_DEFAULT: {
                this.setDisplayDefaultSize();
            }
        }
    }

    private static void arrayCopyWithStride(int[] src, int srcPos, int[] dest, int destPos, int length, int chunk, int stride) {
        int total = 0;
        while (total < length) {
            System.arraycopy(src, srcPos, dest, destPos, chunk);
            srcPos += stride;
            destPos += chunk;
            total += chunk;
        }
    }

    public static enum Control {
        WIDTH_PLUS,
        HEIGHT_PLUS,
        WIDTH_MINUS,
        HEIGHT_MINUS,
        ORIGIN_X_PLUS,
        ORIGIN_Y_PLUS,
        ORIGIN_X_MINUS,
        ORIGIN_Y_MINUS,
        SCALE_X_PLUS,
        SCALE_Y_PLUS,
        SCALE_X_MINUS,
        SCALE_Y_MINUS,
        SIZE_PLUS,
        SIZE_MINUS,
        SIZE_DEFAULT,
        LOAD_CARTRIDGE_FILE,
        LOAD_CARTRIDGE_FILE_NO_AUTO_POWER,
        LOAD_CARTRIDGE_URL,
        LOAD_CARTRIDGE_URL_NO_AUTO_POWER,
        LOAD_CARTRIDGE_EMPTY,
        FULL_SCREEN,
        QUALITY,
        CRT_MODES,
        HELP,
        DEBUG,
        EXIT;

    }
}

