/*
 * Decompiled with CFR 0.152.
 */
package pc.screen;

import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.ImageCapabilities;
import java.awt.image.BufferStrategy;
import java.lang.reflect.Constructor;
import javax.swing.JFrame;
import pc.screen.DisplayCanvas;
import pc.screen.Screen;

public class ScreenFullWindow
extends JFrame
implements DisplayCanvas {
    private int canvasOriginX;
    private int canvasOriginY;
    private Dimension canvasEffectiveSize;
    private int clearBackgoundFrames = 0;
    private BufferStrategy bufferStrategy;
    public static final long serialVersionUID = 1L;

    public ScreenFullWindow() throws HeadlessException {
        this.init();
    }

    private void init() {
        this.setUndecorated(true);
        this.setBackground(Color.BLACK);
        this.setIgnoreRepaint(true);
        this.getContentPane().setBackground(Color.BLACK);
        this.getContentPane().setIgnoreRepaint(true);
        this.setLayout(null);
    }

    @Override
    public void canvasSize(Dimension size) {
        this.canvasOriginX = (this.getWidth() - size.width) / 2;
        this.canvasOriginY = (this.getHeight() - size.height) / 2;
        this.canvasEffectiveSize = size;
        this.repaint();
        if (this.bufferStrategy != null && this.bufferStrategy.getCapabilities().getFlipContents() != BufferCapabilities.FlipContents.BACKGROUND) {
            this.clearBackgoundFrames = Screen.MULTI_BUFFERING + 2;
        }
    }

    @Override
    public void canvasCenter() {
    }

    @Override
    public Dimension canvasEffectiveSize() {
        return this.canvasEffectiveSize;
    }

    @Override
    public void canvasSetRenderingMode() {
        if (Screen.MULTI_BUFFERING <= 0) {
            return;
        }
        BufferCapabilities desiredCaps = new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), Screen.PAGE_FLIPPING ? BufferCapabilities.FlipContents.BACKGROUND : null);
        Class<?> extBufCapClass = null;
        if (Screen.BUFFER_VSYNC != -1) {
            try {
                extBufCapClass = Class.forName("sun.java2d.pipe.hw.ExtendedBufferCapabilities");
                Class<?> vSyncTypeClass = Class.forName("sun.java2d.pipe.hw.ExtendedBufferCapabilities$VSyncType");
                Constructor<?> extBufCapConstructor = extBufCapClass.getConstructor(BufferCapabilities.class, vSyncTypeClass);
                Object vSyncType = vSyncTypeClass.getField(Screen.BUFFER_VSYNC == 1 ? "VSYNC_ON" : "VSYNC_OFF").get(null);
                BufferCapabilities extBuffCaps = (BufferCapabilities)extBufCapConstructor.newInstance(desiredCaps, vSyncType);
                this.createBufferStrategy(Screen.MULTI_BUFFERING, extBuffCaps);
            }
            catch (Exception vSyncTypeClass) {
                // empty catch block
            }
        }
        if (this.getBufferStrategy() == null) {
            try {
                this.createBufferStrategy(Screen.MULTI_BUFFERING, desiredCaps);
            }
            catch (Exception vSyncTypeClass) {
                // empty catch block
            }
        }
        if (this.getBufferStrategy() == null) {
            System.out.println("Could not create desired BufferStrategy. Switching to default...");
            this.createBufferStrategy(Screen.MULTI_BUFFERING);
        }
        this.bufferStrategy = this.getBufferStrategy();
        BufferCapabilities grantedCaps = this.bufferStrategy.getCapabilities();
        System.out.println("Backbuffer accelerated: " + grantedCaps.getBackBufferCapabilities().isAccelerated());
        System.out.println("PageFlipping active: " + grantedCaps.isPageFlipping() + ", " + grantedCaps.getFlipContents());
        if (extBufCapClass != null && grantedCaps.getClass().equals(extBufCapClass)) {
            try {
                System.out.println("VSynch active: " + extBufCapClass.getMethod("getVSync", null).invoke((Object)grantedCaps, new Object[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Graphics2D canvasGraphics() {
        Graphics2D canvasGraphics = (Graphics2D)(this.bufferStrategy != null ? this.bufferStrategy.getDrawGraphics() : this.getGraphics());
        if (this.clearBackgoundFrames-- > 0) {
            canvasGraphics.setColor(Color.BLACK);
            canvasGraphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        }
        canvasGraphics.translate(this.canvasOriginX, this.canvasOriginY);
        return canvasGraphics;
    }

    @Override
    public void canvasFinishGraphics(Graphics2D graphics) {
        graphics.dispose();
        if (this.bufferStrategy != null) {
            this.bufferStrategy.show();
        }
    }

    @Override
    public void canvasClear() {
        Graphics2D canvasGraphics = this.canvasGraphics();
        canvasGraphics.setColor(Color.BLACK);
        canvasGraphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.canvasFinishGraphics(canvasGraphics);
    }

    @Override
    public Container canvasContainer() {
        return this;
    }

    @Override
    public float getDefaultOpenningScaleX(int displayWidth, int displayHeight) {
        float scaleX = this.getWidth() / displayWidth;
        scaleX -= scaleX % Screen.DEFAULT_SCALE_ASPECT_X;
        float h = scaleX / Screen.DEFAULT_SCALE_ASPECT_X * (float)displayHeight;
        while (h > (float)(this.getHeight() + 20)) {
            h = (scaleX -= Screen.DEFAULT_SCALE_ASPECT_X) / Screen.DEFAULT_SCALE_ASPECT_X * (float)displayHeight;
        }
        return scaleX;
    }
}

