/*
 * Decompiled with CFR 0.152.
 */
package pc.screen;

import java.awt.BufferCapabilities;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.ImageCapabilities;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import parameters.Parameters;
import pc.screen.ConsolePanel;
import pc.screen.DisplayCanvas;
import pc.screen.Screen;
import utils.GraphicsDeviceHelper;
import utils.SlickFrame;

public class ScreenWindow
extends SlickFrame
implements DisplayCanvas {
    private Screen screen;
    private Canvas canvas;
    private BufferStrategy bufferStrategy;
    private BufferedImage topLeft;
    private BufferedImage bottomLeft;
    private BufferedImage topRight;
    private BufferedImage bottomRight;
    private BufferedImage top;
    private BufferedImage bottomBar;
    private BufferedImage bottomLeftBar;
    private BufferedImage bottomRightBar;
    private BufferedImage logoBar;
    private BufferedImage favicon;
    private BufferedImage icon64;
    private BufferedImage icon32;
    private int totalCanvasVertPadding;
    private int totalCanvasHorizPadding;
    public ConsolePanel consolePanelWindow;
    private static final int BORDER_SIZE = Parameters.SCREEN_BORDER_SIZE;
    private static final Insets SLICK_INSETS = new Insets(4, 4, 30, 4);
    public static final long serialVersionUID = 1L;

    public ScreenWindow(Screen screen) throws HeadlessException {
        this.totalCanvasVertPadding = ScreenWindow.SLICK_INSETS.top + ScreenWindow.SLICK_INSETS.bottom;
        this.totalCanvasHorizPadding = ScreenWindow.SLICK_INSETS.left + ScreenWindow.SLICK_INSETS.right;
        this.screen = screen;
        this.consolePanelWindow = new ConsolePanel(this, screen, screen.consoleControlsSocket);
    }

    @Override
    protected void init() {
        this.loadImages();
        this.addHotspots();
        this.setBackground(Color.BLACK);
        this.getContentPane().setBackground(Color.BLACK);
        this.getContentPane().setIgnoreRepaint(true);
        this.setLayout(null);
        this.setIconImages(Arrays.asList(this.icon64, this.icon32, this.favicon));
        this.canvas = new Canvas();
        this.canvas.setIgnoreRepaint(true);
        this.canvas.setFocusTraversalKeysEnabled(false);
        this.add(this.canvas);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ScreenWindow.this.positionCanvas();
            }
        });
        super.init();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Insets ins = this.getInsets();
            this.totalCanvasHorizPadding = ins.left + ins.right + ScreenWindow.SLICK_INSETS.left + ScreenWindow.SLICK_INSETS.right + BORDER_SIZE * 2;
            this.totalCanvasVertPadding = ins.top + ins.bottom + ScreenWindow.SLICK_INSETS.top + ScreenWindow.SLICK_INSETS.bottom + BORDER_SIZE * 2;
            this.consolePanelWindow.setVisible(true);
        }
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        this.canvas.addKeyListener(l);
        super.addKeyListener(l);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        this.canvas.addMouseListener(l);
        super.addMouseListener(l);
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        this.canvas.addMouseMotionListener(l);
        super.addMouseMotionListener(l);
    }

    @Override
    public void canvasSize(Dimension size) {
        Dimension winDim = this.windowDimensionForCanvasDimension(size);
        if (this.getSize().equals(winDim)) {
            return;
        }
        int centerX = this.getX() + this.getWidth() / 2;
        int centerY = this.getY() + (this.getHeight() + 137) / 4;
        int newX = centerX - winDim.width / 2;
        int newY = centerY - (winDim.height + 137) / 4;
        this.setBounds(newX, newY, winDim.width, winDim.height);
        this.validate();
        this.repaint();
    }

    @Override
    public void canvasCenter() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        int x = (tk.getScreenSize().width - this.getWidth()) / 2;
        int y = (tk.getScreenSize().height - this.getHeight() - 137) / 4;
        this.setLocation(x, y);
    }

    @Override
    public Dimension canvasEffectiveSize() {
        return this.canvas.getSize();
    }

    @Override
    public void canvasSetRenderingMode() {
        if (Screen.MULTI_BUFFERING <= 0) {
            return;
        }
        BufferCapabilities desiredCaps = new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), Screen.PAGE_FLIPPING ? BufferCapabilities.FlipContents.BACKGROUND : null);
        Class<?> extBufCapClass = null;
        if (Screen.BUFFER_VSYNC != -1) {
            try {
                extBufCapClass = Class.forName("sun.java2d.pipe.hw.ExtendedBufferCapabilities");
                Class<?> vSyncTypeClass = Class.forName("sun.java2d.pipe.hw.ExtendedBufferCapabilities$VSyncType");
                Constructor<?> extBufCapConstructor = extBufCapClass.getConstructor(BufferCapabilities.class, vSyncTypeClass);
                Object vSyncType = vSyncTypeClass.getField(Screen.BUFFER_VSYNC == 1 ? "VSYNC_ON" : "VSYNC_OFF").get(null);
                BufferCapabilities extBuffCaps = (BufferCapabilities)extBufCapConstructor.newInstance(desiredCaps, vSyncType);
                this.canvas.createBufferStrategy(Screen.MULTI_BUFFERING, extBuffCaps);
            }
            catch (Exception vSyncTypeClass) {
                // empty catch block
            }
        }
        if (this.canvas.getBufferStrategy() == null) {
            try {
                this.canvas.createBufferStrategy(Screen.MULTI_BUFFERING, desiredCaps);
            }
            catch (Exception vSyncTypeClass) {
                // empty catch block
            }
        }
        if (this.canvas.getBufferStrategy() == null) {
            System.out.println("Could not create desired BufferStrategy. Switching to default...");
            this.canvas.createBufferStrategy(Screen.MULTI_BUFFERING);
        }
        this.bufferStrategy = this.canvas.getBufferStrategy();
        BufferCapabilities grantedCaps = this.bufferStrategy.getCapabilities();
        System.out.println("Backbuffer accelerated: " + grantedCaps.getBackBufferCapabilities().isAccelerated());
        System.out.println("PageFlipping active: " + grantedCaps.isPageFlipping() + ", " + grantedCaps.getFlipContents());
        if (extBufCapClass != null && grantedCaps.getClass().equals(extBufCapClass)) {
            try {
                System.out.println("VSynch active: " + extBufCapClass.getMethod("getVSync", null).invoke((Object)grantedCaps, new Object[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Graphics2D canvasGraphics() {
        Graphics2D graphics = (Graphics2D)(this.bufferStrategy != null ? this.bufferStrategy.getDrawGraphics() : this.canvas.getGraphics());
        return graphics;
    }

    @Override
    public void canvasFinishGraphics(Graphics2D graphics) {
        graphics.dispose();
        if (this.bufferStrategy != null) {
            this.bufferStrategy.show();
        }
    }

    @Override
    public Container canvasContainer() {
        return this;
    }

    @Override
    public void canvasClear() {
        Graphics2D canvasGraphics = this.canvasGraphics();
        canvasGraphics.setColor(Color.BLACK);
        canvasGraphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.canvasFinishGraphics(canvasGraphics);
    }

    @Override
    public float getDefaultOpenningScaleX(int displayWidh, int displayHeight) {
        return Screen.DEFAULT_SCALE_X;
    }

    public void canvasMinimumSize(Dimension minSize) {
        this.minimunResize(this.windowDimensionForCanvasDimension(minSize));
    }

    private Dimension windowDimensionForCanvasDimension(Dimension size) {
        return new Dimension(size.width + this.totalCanvasHorizPadding, size.height + this.totalCanvasVertPadding);
    }

    private void positionCanvas() {
        this.canvas.setBounds(ScreenWindow.SLICK_INSETS.left + BORDER_SIZE, ScreenWindow.SLICK_INSETS.top + BORDER_SIZE, this.getWidth() - this.totalCanvasHorizPadding, this.getHeight() - this.totalCanvasVertPadding);
        this.validate();
    }

    private void addHotspots() {
        this.addHotspot(new Rectangle(8, -25, 19, 19), new Runnable(){

            @Override
            public void run() {
                ScreenWindow.this.screen.controlStateChanged(Screen.Control.EXIT, true);
            }
        });
        this.addHotspot(new Rectangle(-74, -20, 13, 15), new Runnable(){

            @Override
            public void run() {
                ScreenWindow.this.setState(1);
            }
        });
        this.addHotspot(new Rectangle(-56, -21, 13, 16), new Runnable(){

            @Override
            public void run() {
                ScreenWindow.this.screen.controlStateChanged(Screen.Control.SIZE_MINUS, true);
            }
        });
        this.addHotspot(new Rectangle(-40, -24, 14, 19), new Runnable(){

            @Override
            public void run() {
                ScreenWindow.this.screen.controlStateChanged(Screen.Control.SIZE_PLUS, true);
            }
        });
        this.addHotspot(new Rectangle(-10000, -27, 24, 28), new Runnable(){

            @Override
            public void run() {
                ScreenWindow.this.consolePanelWindow.toggle();
            }
        });
    }

    private void loadImages() {
        try {
            this.topLeft = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/TopLeft.png");
            this.bottomLeft = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/BottomLeft.png");
            this.topRight = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/TopRight.png");
            this.bottomRight = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/BottomRight.png");
            this.top = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/Top.png");
            this.bottomLeftBar = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/BottomLeftBar.png");
            this.bottomRightBar = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/BottomRightBar.png");
            this.bottomBar = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/BottomBar.png");
            this.logoBar = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/LogoBar.png");
            this.favicon = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/Favicon.png");
            this.icon64 = GraphicsDeviceHelper.loadAsCompatibleTranslucentImage("pc/screen/images/LogoIcon64.png");
            this.icon32 = GraphicsDeviceHelper.loadAsCompatibleTranslucentImage("pc/screen/images/LogoIcon32.png");
        }
        catch (IOException ex) {
            System.out.println("Screen Window: unable to load images\n" + ex);
        }
    }

    @Override
    public void paint(Graphics origGraphics) {
        Insets ins = this.getInsets();
        int w = this.getWidth() - ins.left - ins.right;
        int h = this.getHeight() - ins.top - ins.bottom;
        Graphics g = origGraphics.create(ins.left, ins.top, w, h);
        g.setColor(Color.BLACK);
        g.fillRect(ScreenWindow.SLICK_INSETS.left, ScreenWindow.SLICK_INSETS.top, this.getWidth() - ScreenWindow.SLICK_INSETS.left - ScreenWindow.SLICK_INSETS.right, this.getHeight() - ScreenWindow.SLICK_INSETS.top - ScreenWindow.SLICK_INSETS.bottom);
        int halfH = (h - 30) / 2;
        int halfW = w / 2;
        int maxHalfW = Math.min(halfW - 11, 512);
        int x = 0;
        while (x < w) {
            g.drawImage(this.top, x, 0, null);
            x += 512;
        }
        g.drawImage(this.topLeft, 0, 0, null);
        g.drawImage(this.topRight, w - 4, 0, null);
        x = 512;
        while (x < w - 512) {
            g.drawImage(this.bottomBar, x, h - 30, x + 256, h, 0, 0, 256, 30, null);
            x += 256;
        }
        g.drawImage(this.logoBar, halfW - 12, h - 30, null);
        g.drawImage(this.bottomLeftBar, 0, h - 30, maxHalfW, h, 0, 0, maxHalfW, 30, null);
        g.drawImage(this.bottomRightBar, w - maxHalfW, h - 30, w, h, 512 - maxHalfW, 0, 512, 30, null);
        g.drawImage(this.bottomLeft, 0, halfH, 4, h - 30, 0, 600 - halfH, 4, 600, null);
        g.drawImage(this.bottomRight, w - 4, halfH, w, h - 30, 0, 600 - halfH, 4, 600, null);
    }
}

