/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import utils.HotspotAction;

public class SlickFrame
extends JFrame {
    private final boolean resizable;
    private Point clickPosition = null;
    private Point startingLocation = null;
    private Dimension startingSize = null;
    private List<HotspotAction> hotspots = new ArrayList<HotspotAction>();
    private HotspotAction activeHotspot;
    private Dimension minimumSize = new Dimension(80, 40);
    public static final int CENTER_HOTSPOT = -10000;
    private static final int RESIZE_CORNER_SIZE = 18;
    public static final long serialVersionUID = 1L;

    public SlickFrame() throws HeadlessException {
        this(true);
    }

    public SlickFrame(boolean resizable) throws HeadlessException {
        this.init();
        this.resizable = resizable;
    }

    public void minimunResize(Dimension minSize) {
        this.minimumSize = minSize;
    }

    public void addHotspot(Rectangle area, Runnable activationAction) {
        this.hotspots.add(new HotspotAction(area, activationAction));
    }

    public void addHotspot(Rectangle area, Runnable activationAction, Runnable deactivationAction) {
        this.hotspots.add(new HotspotAction(area, activationAction, deactivationAction));
    }

    protected void init() {
        this.setUndecorated(true);
        this.setResizable(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                Point point = e.getPoint();
                for (HotspotAction hotspot : SlickFrame.this.hotspots) {
                    Rectangle efectiveArea = SlickFrame.this.effectiveArea(hotspot.area);
                    if (!efectiveArea.contains(point)) continue;
                    SlickFrame.this.activeHotspot = hotspot;
                    hotspot.activationAction.run();
                    return;
                }
                SlickFrame.this.clickPosition = e.getLocationOnScreen();
                if (!SlickFrame.this.resizable) {
                    SlickFrame.this.startingLocation = SlickFrame.this.getLocation();
                    return;
                }
                Rectangle resizeArea = new Rectangle(SlickFrame.this.getWidth() - 18, SlickFrame.this.getHeight() - 18, SlickFrame.this.getWidth(), SlickFrame.this.getHeight());
                if (resizeArea.contains(e.getPoint())) {
                    SlickFrame.this.startingSize = SlickFrame.this.getSize();
                } else {
                    SlickFrame.this.startingLocation = SlickFrame.this.getLocation();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                SlickFrame.this.clickPosition = null;
                if (SlickFrame.this.startingLocation != null) {
                    SlickFrame.this.finishedMoving();
                } else if (SlickFrame.this.startingSize != null) {
                    SlickFrame.this.finishedResizing();
                }
                SlickFrame.this.startingLocation = null;
                SlickFrame.this.startingSize = null;
                if (SlickFrame.this.activeHotspot != null && ((SlickFrame)SlickFrame.this).activeHotspot.deactivationAction != null) {
                    ((SlickFrame)SlickFrame.this).activeHotspot.deactivationAction.run();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SlickFrame.this.clickPosition == null) {
                    return;
                }
                Point p = e.getLocationOnScreen();
                if (SlickFrame.this.startingLocation != null) {
                    SlickFrame.this.movingTo(((SlickFrame)SlickFrame.this).startingLocation.x + p.x - ((SlickFrame)SlickFrame.this).clickPosition.x, ((SlickFrame)SlickFrame.this).startingLocation.y + p.y - ((SlickFrame)SlickFrame.this).clickPosition.y);
                } else {
                    SlickFrame.this.resizingTo(Math.max(((SlickFrame)SlickFrame.this).startingSize.width + p.x - ((SlickFrame)SlickFrame.this).clickPosition.x, ((SlickFrame)SlickFrame.this).minimumSize.width), Math.max(((SlickFrame)SlickFrame.this).startingSize.height + p.y - ((SlickFrame)SlickFrame.this).clickPosition.y, ((SlickFrame)SlickFrame.this).minimumSize.height));
                }
            }
        });
    }

    protected void movingTo(int x, int y) {
        this.setLocation(x, y);
    }

    protected void resizingTo(int width, int height) {
        this.setSize(width, height);
    }

    protected void finishedMoving() {
    }

    protected void finishedResizing() {
    }

    protected void paintHotspots(Graphics g) {
        g.setColor(Color.YELLOW);
        for (HotspotAction hotspot : this.hotspots) {
            Rectangle rect = this.effectiveArea(hotspot.area);
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    private Rectangle effectiveArea(Rectangle area) {
        Insets ins = this.getInsets();
        return new Rectangle(area.x == -10000 ? (this.getWidth() - area.width) / 2 : (area.x < 0 ? this.getWidth() - ins.right + area.x : area.x + ins.left), area.y == -10000 ? (this.getHeight() - area.height) / 2 : (area.y < 0 ? this.getHeight() - ins.bottom + area.y : area.y + ins.top), area.width, area.height);
    }
}

