/*
 * Decompiled with CFR 0.152.
 */
package atari.board;

import atari.cartridge.Cartridge;
import atari.pia.PIA;
import atari.pia.RAM;
import atari.tia.TIA;
import general.board.BUS16Bits;
import parameters.Parameters;
import utils.Randomizer;

public final class BUS
implements BUS16Bits {
    public Cartridge cartridge;
    public final RAM ram;
    public final TIA tia;
    public final PIA pia;
    private byte data = 0;
    private static final int CART_MASK = 4096;
    private static final int CART_SEL = 4096;
    private static final int RAM_MASK = 4736;
    private static final int RAM_SEL = 128;
    private static final int TIA_MASK = 4224;
    private static final int TIA_SEL = 0;
    private static final int PIA_MASK = 4736;
    private static final int PIA_SEL = 640;
    private static final boolean DATA_RETENTION = Parameters.BUS_DATA_RETENTION;

    public BUS(TIA tia, PIA pia, RAM ram) {
        this.ram = ram;
        this.tia = tia;
        this.pia = pia;
    }

    public void powerOn() {
        if (this.cartridge == null) {
            this.data = (byte)Randomizer.instance.nextInt(256);
        }
    }

    public void powerOff() {
    }

    @Override
    public byte readByte(int address) {
        if ((address & 0x1000) == 4096) {
            if (this.cartridge != null) {
                this.data = this.cartridge.readByte(address);
            }
            return this.data;
        }
        if ((address & 0x1280) == 128) {
            this.data = this.ram.readByte(address);
            return this.data;
        }
        if ((address & 0x1280) == 640) {
            this.data = this.pia.readByte(address);
            return this.data;
        }
        if (DATA_RETENTION) {
            this.data = (byte)(this.data & 0x3F | this.tia.readByte(address));
            return this.data;
        }
        this.data = this.tia.readByte(address);
        return this.data;
    }

    @Override
    public void writeByte(int address, byte b) {
        this.data = b;
        if ((address & 0x1280) == 128) {
            this.ram.writeByte(address, b);
            return;
        }
        if ((address & 0x1080) == 0) {
            this.tia.writeByte(address, b);
            return;
        }
        if ((address & 0x1280) == 640) {
            this.pia.writeByte(address, b);
            return;
        }
        if (this.cartridge != null) {
            this.cartridge.writeByte(address, b);
        }
    }

    public void cartridge(Cartridge cartridge) {
        this.cartridge = cartridge;
    }
}

