/*
 * Decompiled with CFR 0.152.
 */
package atari.network.rmi;

import atari.network.ClientConsole;
import atari.network.ControlChange;
import atari.network.RemoteReceiver;
import atari.network.ServerUpdate;
import atari.network.rmi.RMIRemoteReceiverInterface;
import atari.network.rmi.RMIRemoteTransmitter;
import atari.network.rmi.RMIRemoteTransmitterInterface;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import parameters.Parameters;

public class RMIRemoteReceiver
extends UnicastRemoteObject
implements RMIRemoteReceiverInterface,
RemoteReceiver {
    private ClientConsole console;
    private RMIRemoteTransmitterInterface transmitter;
    private ConcurrentLinkedQueue<ServerUpdate> updates = new ConcurrentLinkedQueue();
    private UpdatesConsumer updatesConsumer;
    private static final int MAX_UPDATES_PENDING = Parameters.CLIENT_MAX_UPDATES_PENDING;
    public static final long serialVersionUID = 1L;

    @Override
    public void clientConsole(ClientConsole console) {
        this.console = console;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ControlChange> receiveServerUpdate(ServerUpdate update) {
        ConcurrentLinkedQueue<ServerUpdate> concurrentLinkedQueue = this.updates;
        synchronized (concurrentLinkedQueue) {
            while (true) {
                if (this.updates.size() <= MAX_UPDATES_PENDING) {
                    this.updates.add(update);
                    this.updates.notifyAll();
                    return this.console.controlChangesToSend();
                }
                try {
                    this.updates.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void connect(String server) throws RemoteException, MalformedURLException, NotBoundException {
        Registry reg = LocateRegistry.getRegistry(server, RMIRemoteTransmitter.SERVICE_PORT);
        this.transmitter = (RMIRemoteTransmitterInterface)reg.lookup(RMIRemoteTransmitter.SERVICE_NAME);
        this.transmitter.connectReceiver(this);
        this.updatesConsumer = new UpdatesConsumer();
        this.updatesConsumer.start();
        this.console.connected();
    }

    private class UpdatesConsumer
    extends Thread {
        private UpdatesConsumer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                ServerUpdate update;
                ConcurrentLinkedQueue concurrentLinkedQueue = RMIRemoteReceiver.this.updates;
                synchronized (concurrentLinkedQueue) {
                    while (true) {
                        if ((update = (ServerUpdate)RMIRemoteReceiver.this.updates.poll()) != null) {
                            RMIRemoteReceiver.this.updates.notifyAll();
                            break;
                        }
                        try {
                            RMIRemoteReceiver.this.updates.wait(0L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                RMIRemoteReceiver.this.console.receiveServerUpdate(update);
                UpdatesConsumer.yield();
            }
        }
    }
}

