/*
 * Decompiled with CFR 0.152.
 */
package atari.network.rmi;

import atari.network.ControlChange;
import atari.network.RemoteTransmitter;
import atari.network.ServerConsole;
import atari.network.ServerUpdate;
import atari.network.rmi.RMIRemoteReceiverInterface;
import atari.network.rmi.RMIRemoteTransmitterInterface;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JOptionPane;
import parameters.Parameters;

public class RMIRemoteTransmitter
extends UnicastRemoteObject
implements RMIRemoteTransmitterInterface,
RemoteTransmitter {
    private ConcurrentLinkedQueue<ServerUpdate> updates = new ConcurrentLinkedQueue();
    private UpdatesSender updatesSender;
    private ServerConsole console;
    private RMIRemoteReceiverInterface receiver;
    private static final int MAX_UPDATES_PENDING = Parameters.SERVER_MAX_UPDATES_PENDING;
    public static final String SERVICE_NAME = Parameters.SERVER_SERVICE_NAME;
    public static final int SERVICE_PORT = Parameters.SERVER_SERVICE_PORT;
    public static final long serialVersionUID = 1L;

    @Override
    public void connectReceiver(RMIRemoteReceiverInterface receiver) {
        this.resetUpdatesPending();
        this.receiver = receiver;
        this.updatesSender = new UpdatesSender();
        this.updatesSender.start();
        this.console.clientConnected();
    }

    @Override
    public void serverConsole(ServerConsole console) {
        this.console = console;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sendUpdate(ServerUpdate update) {
        if (this.receiver == null) {
            return;
        }
        ConcurrentLinkedQueue<ServerUpdate> concurrentLinkedQueue = this.updates;
        synchronized (concurrentLinkedQueue) {
            while (true) {
                if (this.updates.size() <= MAX_UPDATES_PENDING) {
                    this.updates.add(update);
                    this.updates.notifyAll();
                    return;
                }
                try {
                    this.updates.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean isClientConnected() {
        return this.receiver != null;
    }

    public void listen() {
        try {
            Registry reg = LocateRegistry.createRegistry(SERVICE_PORT);
            reg.bind(SERVICE_NAME, this);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Unnable to start server!\n" + ex, "Atari P1 Server", 0);
        }
    }

    private void disconnectReceiver() {
        this.receiver = null;
        this.resetUpdatesPending();
        this.console.clientDisconnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetUpdatesPending() {
        ConcurrentLinkedQueue<ServerUpdate> concurrentLinkedQueue = this.updates;
        synchronized (concurrentLinkedQueue) {
            this.updates.clear();
            this.updates.notifyAll();
        }
    }

    private class UpdatesSender
    extends Thread {
        private UpdatesSender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                ServerUpdate update;
                ConcurrentLinkedQueue concurrentLinkedQueue = RMIRemoteTransmitter.this.updates;
                synchronized (concurrentLinkedQueue) {
                    while (true) {
                        if ((update = (ServerUpdate)RMIRemoteTransmitter.this.updates.poll()) != null) {
                            RMIRemoteTransmitter.this.updates.notifyAll();
                            break;
                        }
                        try {
                            RMIRemoteTransmitter.this.updates.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                try {
                    List<ControlChange> clientControlChages;
                    if (RMIRemoteTransmitter.this.receiver == null || (clientControlChages = RMIRemoteTransmitter.this.receiver.receiveServerUpdate(update)) == null) continue;
                    RMIRemoteTransmitter.this.console.receiveClientControlChanges(clientControlChages);
                    continue;
                }
                catch (RemoteException ex) {
                    System.out.println("RMIRemoteTransmitter: unable to send update\n" + ex);
                    RMIRemoteTransmitter.this.disconnectReceiver();
                    continue;
                }
                break;
            }
        }
    }
}

