/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.Instruction;
import general.m6502.M6502;
import general.m6502.OperandType;

public class ADC
extends Instruction {
    private final OperandType type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public ADC(M6502 cpu, OperandType type) {
        super(cpu);
        this.type = type;
    }

    @Override
    public int fetch() {
        switch (this.type) {
            case IMM: {
                this.ea = this.cpu.fetchImmediateAddress();
                return 2;
            }
            case Z_PAGE: {
                this.ea = this.cpu.fetchZeroPageAddress();
                return 3;
            }
            case Z_PAGE_X: {
                this.ea = this.cpu.fetchZeroPageXAddress();
                return 4;
            }
            case ABS: {
                this.ea = this.cpu.fetchAbsoluteAddress();
                return 4;
            }
            case ABS_X: {
                this.ea = this.cpu.fetchAbsoluteXAddress();
                return 4 + (this.cpu.pageCrossed ? 1 : 0);
            }
            case ABS_Y: {
                this.ea = this.cpu.fetchAbsoluteYAddress();
                return 4 + (this.cpu.pageCrossed ? 1 : 0);
            }
            case IND_X: {
                this.ea = this.cpu.fetchIndirectXAddress();
                return 6;
            }
            case IND_Y: {
                this.ea = this.cpu.fetchIndirectYAddress();
                return 5 + (this.cpu.pageCrossed ? 1 : 0);
            }
        }
        throw new IllegalStateException("ADC Invalid Operand Type: " + (Object)((Object)this.type));
    }

    @Override
    public void execute() {
        byte b = this.cpu.memory.readByte(this.ea);
        int uB = M6502.toUnsignedByte(b);
        byte oldA = this.cpu.A;
        int uOldA = M6502.toUnsignedByte(oldA);
        int aux = oldA + b + (this.cpu.CARRY ? 1 : 0);
        int uAux = uOldA + uB + (this.cpu.CARRY ? 1 : 0);
        byte newA = (byte)M6502.toUnsignedByte(uAux);
        boolean bl = this.cpu.ZERO = newA == 0;
        if (!this.cpu.DECIMAL_MODE) {
            this.cpu.NEGATIVE = newA < 0;
            this.cpu.OVERFLOW = aux > 127 || aux < -128;
            this.cpu.CARRY = uAux > 255;
            this.cpu.A = newA;
            return;
        }
        uAux = (uOldA & 0xF) + (uB & 0xF) + (this.cpu.CARRY ? 1 : 0);
        if (uAux >= 10) {
            uAux = (uAux + 6 & 0xF) + 16;
        }
        this.cpu.NEGATIVE = ((aux = (byte)(uOldA & 0xF0) + (byte)(uB & 0xF0) + (byte)uAux) & 0x80) > 0;
        this.cpu.OVERFLOW = aux > 127 | aux < -128;
        if ((uAux = (uOldA & 0xF0) + (uB & 0xF0) + uAux) >= 160) {
            uAux += 96;
        }
        this.cpu.CARRY = uAux > 255;
        this.cpu.A = (byte)M6502.toUnsignedByte(uAux);
    }
}

