/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.Instruction;
import general.m6502.M6502;
import general.m6502.OperandType;

public class ASL
extends Instruction {
    private final OperandType type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public ASL(M6502 cpu, OperandType type) {
        super(cpu);
        this.type = type;
    }

    @Override
    public int fetch() {
        switch (this.type) {
            case ACC: {
                this.ea = -1;
                return 2;
            }
            case Z_PAGE: {
                this.ea = this.cpu.fetchZeroPageAddress();
                return 5;
            }
            case Z_PAGE_X: {
                this.ea = this.cpu.fetchZeroPageXAddress();
                return 6;
            }
            case ABS: {
                this.ea = this.cpu.fetchAbsoluteAddress();
                return 6;
            }
            case ABS_X: {
                this.ea = this.cpu.fetchAbsoluteXAddress();
                return 7;
            }
        }
        throw new IllegalStateException("ASL Invalid Operand Type: " + (Object)((Object)this.type));
    }

    @Override
    public void execute() {
        if (this.type == OperandType.ACC) {
            byte val = this.cpu.A;
            this.cpu.CARRY = val < 0;
            this.cpu.A = val = (byte)(val << 1);
            this.cpu.ZERO = val == 0;
            this.cpu.NEGATIVE = val < 0;
        } else {
            byte val = this.cpu.memory.readByte(this.ea);
            this.cpu.CARRY = val < 0;
            val = (byte)(val << 1);
            this.cpu.ZERO = val == 0;
            this.cpu.NEGATIVE = val < 0;
            this.cpu.memory.writeByte(this.ea, val);
        }
    }
}

